<?php

if (! defined('ABSPATH')) {
    exit; // Exit if accessed directly
}


class iHomefinderValuationFormVirtualPageImpl extends iHomefinderAbstractVirtualPage
{
    
    public function getTitle()
    {
        return $this->getText(iHomefinderConstants::OPTION_VIRTUAL_PAGE_TITLE_VALUATION_FORM, "Valuation Request Form");
    }

    public function getPageTemplate()
    {
        return get_option(iHomefinderConstants::OPTION_VIRTUAL_PAGE_TEMPLATE_VALUATION_FORM, null);
    }
    
    public function getPermalink()
    {
        return $this->getText(iHomefinderConstants::OPTION_VIRTUAL_PAGE_PERMALINK_TEXT_VALUATION_FORM, "valuation-form");
    }
            
    public function getMetaTags()
    {
        $default = "<meta name=\"description\" content=\"\" />\n";
        return $this->getText(iHomefinderConstants::OPTION_VIRTUAL_PAGE_META_TAGS_VALUATION_FORM, $default);
    }
            
    public function getContent()
    {
        $this->remoteRequest
            ->addParameters($_REQUEST)
            ->addParameter("requestType", "valuation-form");
        $this->remoteResponse = $this->remoteRequest->remoteGetRequest();
    }

    public function getBody()
    {
        if ($this->displayRules->isKestrelAll()) {
            return iHomefinderKestrelPage::getValuationRequestFormPage();
        } else {
            return parent::getBody();
        }
    }
}
