<?php if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly 

$fb_app_ID                      = 'https://developers.facebook.com/apps/';
$fb_app_ID_help                 = 'https://developers.facebook.com/docs/development/create-an-app';
$fb_debugger                    = 'https://developers.facebook.com/tools/debug/';
$fb_access_token                = 'https://rocketapps.com.au/product/open-graphite-pro/#faq-08';
$twitter_card                   = 'https://cards-dev.twitter.com/validator/';
$reop_url                       = 'https://wordpress.org/support/plugin/open-graphite'; 
$buy_url                        = 'https://rocketapps.com.au/product/open-graphite-pro/?origin=open-graphite'; 
$yoast_org_and_logo             = admin_url() . 'admin.php?page=wpseo_page_settings#/site-representation';
$yoast_social                   = admin_url() . 'admin.php?page=wpseo_page_settings#/site-features';
$image_path                     = plugins_url('../images/help', __FILE__ );
?>

<div class="wrap og-help-wrap">

<div class="og-help-topics">

    <h2><?php _e( 'Open Graphite Help', 'open-graphite' ); ?></h2>
    
    <p class="topic"><?php _e( 'Can I customise how each page or post is previewed when shared on social media?', 'open-graphite' ); ?></p>
    <div>
        <p><?php _e( 'Yes. You can either set the option to automatically use the existing title, text (or excerpt) and image, or specify them manually on each page or post in the Open Graphite metabox.', 'open-graphite' ); ?></p>
        <img src="<?php echo esc_attr($image_path); ?>/metabox.png" />
    </div>

    <p class="topic"><?php _e( 'There appears to be duplicate sets of open graph tags.', 'open-graphite' ); ?></p>
    <div>
        <p><?php _e( 'Any other plug-in that inserts open graph tags into your website (Yoast is one that comes to mind) may conflict with Open Graphite to not work properly.', 'open-graphite' ); ?></p>
        <p><?php _e( "To test if you have a conflict, simply view the source code of your home page in your browser and search for any instances of <code>og:</code> within. Typically a plug-in will output the meta tags into it's own group. For this plug-in, they will be directly below the <code>&lt;!--/ Open Graphite /--&gt;</code> comment but other plug-ins will output something else (if at all). The only solution to resolve a conflict is to disable one of the plug-ins.", 'open-graphite' ); ?></p>
    </div>

    <?php if(in_array('wordpress-seo/wp-seo.php', apply_filters('active_plugins', get_option('active_plugins')))) { ?>
    <p class="topic" id="yoast"><?php _e( "How do I prevent Yoast from conflicting with Open Graphite?", 'open-graphite' ); ?></p>
    <div>
        <p><?php printf(__( 'To avoid a situation where you have sets of open graph tags generated by both Yoast and Open Graphite, you will need to <a href="%1$s" target="_blank">disable the Open Graph data and Twitter data</a> settings (scroll down to Social sharing), and make sure the <a href="%2$s" target="_blank">organisation name and logo</a> are empty.', 'open-graphite' ), $yoast_social, $yoast_org_and_logo); ?></p>
    </div>
    <?php } ?>

    <?php if ( class_exists( 'Jetpack' )) { ?>
    <p class="topic" id="yoast"><?php _e( "How do I prevent Jetpack from conflicting with Open Graphite?", 'open-graphite' ); ?></p>
    <div>
        <p><?php _e( 'To avoid a situation where you have multiple sets of open graph tags generated by both Jetpack and Open Graphite, you will need to disable Jetpack open graph meta tags by going to <code>Open Graphite</code> -> <code>Troubleshooting</code> and enabling the <code>Avoid Jetpack open graph tag conflict</code> checkbox.', 'open-graphite' ); ?></p>
    </div>
    <?php } ?>

    <p class="topic"><?php _e( "Facebook isn't showing the correct information when I share my page or post.", 'open-graphite' ); ?></p>
    <div>
        <p><?php _e( "Facebook (and possibly other social networks) will cache the open graph properties of a post that has previously been shared for up to 24 hours (maybe longer). During this time, any changes you make to your open graph properties will not be picked up by Facebook immediately. But there are a couple of solutions.", 'open-graphite' ); ?></p>

        <p><?php printf(__( '1) Get a <a href="%1$s" target="_blank" rel="noopener">Facebook Access Token</a>, or...', 'open-graphite' ), $fb_access_token); ?></p>

        <p><?php printf(__( '2) Use the official <a href="%1$s" target="_blank" rel="noopener">Facebook Debugger</a>, paste in the URL of your page or post and hit the <strong>Debug</strong> button. When it has finished, hit the <strong>Scrape Again</strong> button. This will force Facebook to fetch the latest open graph data from your post. Twitter has a similar tool called the <a href="%2$s" target="_blank" rel="noopener">Card Validator</a> for this purpose as well.', 'open-graphite' ), $fb_debugger, $twitter_card); ?></p>
        <img src="<?php echo esc_attr($image_path); ?>/facebook-debugger.png" />
        <p><?php _e( 'Facebook might complain about the lack of an App ID when you pass your URL through their debugger, but this will not prevent anything from working correctly.', 'open-graphite' ); ?></p>
    </div>

    <p class="topic"><?php _e( 'Do I need a Facebook App ID?', 'open-graphite' ); ?></p>
    <div>
        <p><?php printf(__(  'You do not need a Facebook App ID. That said, there may be instances where having one is helpful. <a href="%1$s" target="_blank" rel="noopener">Decide for yourself</a>. But if you plan on using the Facebook Access Token feature (highly recommended) then you will absolutely need a Facebook App ID.', 'open-graphite' ), $fb_app_ID_help); ?></p>
    </div>

    <p class="topic"><?php _e( 'Will my current settings be inherited if I upgrade to pro?', 'open-graphite' ); ?></p>
    <div>
        <p><?php printf(__(  'Yes. If you <a href="%1$s" target="_blank" rel="noopener">upgrade to Pro</a> all your current configurations will be preserved.', 'open-graphite' ), $buy_url); ?></p>
    </div>

    <p class="topic"><?php _e( 'Where can I get support for this plugin?', 'open-graphite' ); ?></p>
    <div>
        <p><?php printf(__( 'Leave a message at the <a href="%1$s" target="_blank">plug-in support page</a>.', 'open-graphite' ), $reop_url); ?></p>
    </div>
    
</div>