<?php
abstract class Bootstrap_Test_Setup extends Omise_Test_Case
{
    public function getOrderMock($expectedAmount, $expectedCurrency, $properties = [])
    {
        // Create a mock of the $order object
        $orderMock = Mockery::mock('WC_Order');

        // Define expectations for the mock
        $orderMock->allows([
            'get_id' => $properties['id'] ?? 123,
            'get_order_key' => $properties['key'] ?? 'order_kfeERDv',
        ]);
        $orderMock->shouldReceive('get_currency')
            ->andReturn(strtoupper($expectedCurrency));
        $orderMock->shouldReceive('get_total')
            ->andReturn($expectedAmount);  // in units
        $orderMock->shouldReceive('add_meta_data');
        $orderMock->shouldReceive('get_billing_phone')
            ->andReturn('1234567890');
        $orderMock->shouldReceive('get_address')
            ->andReturn([
                'country' => 'Thailand',
                'city' => 'Bangkok',
                'postcode' => '10110',
                'state' => 'Bangkok',
                'address_1' => 'Sukumvit Road'
            ]);
        $orderMock->shouldReceive('get_items')
            ->andReturn([
                [
                    'name' => 'T Shirt',
                    'subtotal' => 600,
                    'qty' => 1,
                    'product_id' => 'product_123',
                    'variation_id' => null
                ]
            ]);
        return $orderMock;
    }

    /**
     * FIXME: Only used in Omise_Payment_Konbini_Test.
     * We can refactor this into offline payment test class or the test itself.
     * @runInSeparateProcess
     */
    public function getChargeTest($classObj)
    {
        $expectedAmount = 999999;
        $expectedCurrency = 'thb';
        $expectedRequest = [
            "object" => "charge",
            "id" => "chrg_test_no1t4tnemucod0e51mo",
            "location" => "/charges/chrg_test_no1t4tnemucod0e51mo",
            "amount" => $expectedAmount,
            "currency" => $expectedCurrency
        ];

        // Create a mock for OmiseCharge
        $chargeMock = Mockery::mock('overload:OmiseCharge');
        $chargeMock->shouldReceive('create')->once()->andReturn($expectedRequest);

        $orderMock = $this->getOrderMock($expectedAmount, $expectedCurrency);

        $wcProduct = Mockery::mock('overload:WC_Product');
        $wcProduct->shouldReceive('get_sku')
            ->once()
            ->andReturn('sku_1234');

        $orderId = 'order_123';
        $result = $classObj->charge($orderId, $orderMock);
        $this->assertEquals($expectedAmount, $result['amount']);
        $this->assertEquals($expectedCurrency, $result['currency']);
    }

    protected function mockOmiseHttpExecutor()
    {
        require_once __DIR__ . '/../../../../includes/libraries/omise-php/lib/omise/OmiseCapability.php';
        require_once __DIR__ . '/../../../../includes/libraries/omise-php/lib/omise/OmiseCharge.php';

        return Mockery::mock('overload:' . OmiseHttpExecutor::class);
    }

    /**
     * When using this, `runInSeparateProcess` must be set to true
     * to avoid the OmiseHttpExecutor being cached.
     */
    protected function mockApiCall($fixture, $customAttrs = null)
    {
        $this->mockOmiseSetting(['pkey_xxx'], ['skey_xxx']);
        $this->enableApiCall(true);

        $response = load_fixture($fixture);

        if ($customAttrs) {
            $responseAttrs = json_decode($response, true);
            $responseAttrs = array_replace_recursive($responseAttrs, $customAttrs);

            $response = json_encode($responseAttrs);
        }

        $omiseHttpExecutorMock = $this->mockOmiseHttpExecutor();
        $omiseHttpExecutorMock
            ->shouldReceive('execute')
            ->once()
            ->andReturn($response);
    }

    protected function enableApiCall($isEnabled)
    {
        if (!$isEnabled) {
            Brain\Monkey\Functions\expect('is_admin')->andReturn(false);
            Brain\Monkey\Functions\expect('is_checkout')->andReturn(false);
            Brain\Monkey\Functions\expect('is_wc_endpoint_url')->andReturn(false);
        } else {
            Brain\Monkey\Functions\expect('is_admin')->andReturn(false);
            Brain\Monkey\Functions\expect('is_checkout')->andReturn(true);
            Brain\Monkey\Functions\expect('is_wc_endpoint_url')->andReturn(false);
        }
    }

    protected function mockRedirectUrl($redirectUrl = 'https://abc.com/order/complete') {
        $redirectUrlMock = Mockery::mock('alias:RedirectUrl');
        $redirectUrlMock->shouldReceive('create')->andReturn($redirectUrl);
        $redirectUrlMock->shouldReceive('getToken')->andReturn('token123');

        return $redirectUrlMock;
    }
}

