# CHANGELOG

## [v7.0.0 _(Oct 21, 2025)_](https://github.com/omise/omise-woocommerce/releases/tag/v7.0.0)
- Introduce new payment passkey to authenticate card transactions. (PR: [#535](https://github.com/omise/omise-woocommerce/issues/535), [#541](https://github.com/omise/omise-woocommerce/issues/541), [#545](https://github.com/omise/omise-woocommerce/issues/545))
- Create card token with cardholder's email and phone number when provided. (PR: [#537](https://github.com/omise/omise-woocommerce/issues/537))

## [v6.4.0 _(Sep 24, 2025)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.4.0)

- Fix saved card page error on My Account page. (PR: [#538](https://github.com/omise/omise-woocommerce/issues/538))
- Display actual Paynow QR expiration. (PR: [#539](https://github.com/omise/omise-woocommerce/issues/539))

## [v6.3.0 _(Sep 3, 2025)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.3.0)

- Fix WLB installment order description. (PR: [#534](https://github.com/omise/omise-woocommerce/issues/534))
- Fix payment form on Pay for Order page. (PR: [#533](https://github.com/omise/omise-woocommerce/issues/533))

## [v6.2.2 _(Jul 22, 2025)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.2.2)

- Add authentication to Paynow status endpoint. (PR: [#530](https://github.com/omise/omise-woocommerce/issues/530))

## [v6.2.1 _(Jun 16, 2025)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.2.1)

- Improve webhook rest route. (PR: [#526](https://github.com/omise/omise-woocommerce/pull/526))

## [v6.2.0 _(Jun 9, 2025)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.2.0)

- Update OmisePHP library to support API 2019-05-29. (PR: [#516](https://github.com/omise/omise-woocommerce/pull/516))
- Show merchant advice and missing 3DS fields on order note. (PR: [#517](https://github.com/omise/omise-woocommerce/pull/517))
- Fix PHP error when fetch capability. (PR: [#521](https://github.com/omise/omise-woocommerce/pull/521))
- Fix WooCommerce Block installment payment. (PR: [#522](https://github.com/omise/omise-woocommerce/pull/522))
- Support other languages on secure form. (PR: [#524](https://github.com/omise/omise-woocommerce/pull/524))
- Make WooCommerce Blocks announcement. (PR: [#525](https://github.com/omise/omise-woocommerce/pull/525))

## [v6.1.1 _(Mar 18, 2025)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.1.1)
- Reorganize logo and screenshots assets for automated deployment. (PR: [#513](https://github.com/omise/omise-woocommerce/pull/513))

## [v6.1.0 _(Mar 17, 2025)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.1.0)
- Rebrand Opn Payments to Omise. (PR: [#509](https://github.com/omise/omise-woocommerce/pull/509))
- Fix Boost payment method is not visible on the checkout page. (PR: [#507](https://github.com/omise/omise-woocommerce/pull/507))
- Fix credit card block does not show on WooCommerce 9.5.0. (PR: [#508](https://github.com/omise/omise-woocommerce/pull/508))

## [v6.0.5 _(Jan 15, 2025)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.0.5)
- Fix the issue of TrueMoney wallet not showing in payment options. (PR: [#500](https://github.com/omise/omise-woocommerce/pull/500))

## [v6.0.4 _(Jan 13, 2025)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.0.4)
- Fix the issue of missing TrueMoney payment methods. (PR: [#496](https://github.com/omise/omise-woocommerce/pull/496))

## [v6.0.3 _(Nov 27, 2024)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.0.3)
- Fix the issue of GooglePay not showing in shortcode. (PR: [#493](https://github.com/omise/omise-woocommerce/pull/493))

## [v6.0.2 _(Nov 20, 2024)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.0.2)
- Resolved installment issue when card is saved in shortcode setup. (PR: [#490](https://github.com/omise/omise-woocommerce/pull/490))

## [v6.0.1 _(Nov 12, 2024)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.0.1)
- Resolve issue of payment failing on installment when total amount is updated after selecting payment. (PR: [#485](https://github.com/omise/omise-woocommerce/pull/485))
- Fix Duitnow bank list issue. (PR: [#486](https://github.com/omise/omise-woocommerce/pull/486))
- Resolve the issue where no payment methods are displayed when the browser's back button is clicked from an issuer page. (PR: [#487](https://github.com/omise/omise-woocommerce/pull/487))

## [v6.0.0 _(Nov 5, 2024)_](https://github.com/omise/omise-woocommerce/releases/tag/v6.0.0)
- Support WooCommerce block. (PR: [#470](https://github.com/omise/omise-woocommerce/pull/470))
- Fix the loading issue in WooCommerce block cart. (PR: [#477](https://github.com/omise/omise-woocommerce/pull/477))
- Update banner message. (PR: [#479](https://github.com/omise/omise-woocommerce/pull/479))
- Make secure form mandatory. (PR: [#480](https://github.com/omise/omise-woocommerce/pull/480))
- Fix the issue of installment form not loading after an error. (PR: [#482](https://github.com/omise/omise-woocommerce/pull/482))

## [v5.9.0 _(Jul 24, 2024)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.9.0)
- Resolve dynamic property deprecation error for PHP 8.2 and above. (PR: [#465](https://github.com/omise/omise-woocommerce/pull/465))

## [v5.8.3 _(May 8, 2024)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.8.3)
- Remove OCBC PAO (PR: [#449](https://github.com/omise/omise-woocommerce/pull/449))

## [v5.8.2 _(Apr 9, 2024)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.8.2)
- Resolve PHP warnings. (PR [#443](https://github.com/omise/omise-woocommerce/pull/443))
- Remove white box appearing under WeChat Pay. (PR [#444](https://github.com/omise/omise-woocommerce/pull/444))
- Remove white box appearing under Truemoney. (PR [#445](https://github.com/omise/omise-woocommerce/pull/445))
- Removed Citi installment. (PR [#446](https://github.com/omise/omise-woocommerce/pull/446))

## [v5.8.1 _(Mar 7, 2024)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.8.1)
- Revert "Use WC order number metadata". (PR [#440](https://github.com/omise/omise-woocommerce/pull/440))

## [v5.8.0 _(Mar 5, 2024)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.8.0)
- Add WeChat Pay. (PR [#434](https://github.com/omise/omise-woocommerce/pull/434))
- Use WC order number metadata. (PR [#435](https://github.com/omise/omise-woocommerce/pull/435))

## [v5.7.0 _(Jan 11, 2024)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.7.0)
- Added TrueMoney jumpapp. (PR [#431](https://github.com/omise/omise-woocommerce/pull/431))
- Updated README.md. (PR [#429](https://github.com/omise/omise-woocommerce/pull/429))

## [v5.6.2 _(Dec 7, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.6.2)
- Update OCBC digital logo. (PR [#422](https://github.com/omise/omise-woocommerce/pull/422))
- Update installment interest rates. (PR [#423](https://github.com/omise/omise-woocommerce/pull/423))

## [v5.6.1 _(Nov 16, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.6.1)
- Fixed a custom font name bug. (PR [#419](https://github.com/omise/omise-woocommerce/pull/419))

## [v5.6.0 _(Nov 15, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.6.0)
- Support Google fonts other than Poppins. (PR [#416](https://github.com/omise/omise-woocommerce/pull/416))

## [v5.5.1 _(Nov 2, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.5.1)
- Fix mobile banking issue. (PR [#413](https://github.com/omise/omise-woocommerce/pull/413))

## [v5.5.0 _(Oct 17, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.5.0)
- Added dynamic webhook. (PR [#407](https://github.com/omise/omise-woocommerce/pull/407))
- Add QR expires countdown for PromptPay. (PR [#408](https://github.com/omise/omise-woocommerce/pull/408))

## [v5.4.1 _(Oct 3, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.4.1)
- Added payment instructions in thank you page for PromptPay payment. (PR [#401](https://github.com/omise/omise-woocommerce/pull/404))

## [v5.4.0 _(Sep 21, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.4.0)
- Added OCBC Digital for Singapore PSP. (PR [#401](https://github.com/omise/omise-woocommerce/pull/401))

## [v5.3.1 _(Sep 05, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.3.1)
- Fixed capabilities api calling on every pages. (PR [#398](https://github.com/omise/omise-woocommerce/pull/398))

## [v5.3.0 _(Aug 23, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.3.0)
- Add Alipay+ on Thailand psp. (PR [#394](https://github.com/omise/omise-woocommerce/pull/394))
- Adding admin_notices action once all dependencies are loaded. (PR [#395](https://github.com/omise/omise-woocommerce/pull/395))

## [v5.2.1 _(Aug 9, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.2.1)
- Fixed installment payment when admin manually pay for order. (PR [#388](https://github.com/omise/omise-woocommerce/pull/388))
- Fixed Japanese translation issue in secure form. (PR [#389](https://github.com/omise/omise-woocommerce/pull/389))

## [v5.2.0 _(Aug 3, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.2.0)
- Declare High-Performance Order Storage (HPOS) as compatible. (PR [#385](https://github.com/omise/omise-woocommerce/pull/385))
- Added a script to run test `composer test`. (PR [#385](https://github.com/omise/omise-woocommerce/pull/385))
- Update sonar properties to exclude javascript files. (PR [#385](https://github.com/omise/omise-woocommerce/pull/384))

## [v5.1.1 _(Jun 13, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.1.1)
- Remove free products from the Atome bill. (PR [#378](https://github.com/omise/omise-woocommerce/pull/378))
- Fix incompatible issue with country based payments plugin. (PR [#379](https://github.com/omise/omise-woocommerce/pull/379))

## [v5.1.0 _(May 15, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.1.0)
- Added Atome payment method. (PR [#364](https://github.com/omise/omise-woocommerce/pull/364))
- Installment minimum amount from capability API. (PR [#365](https://github.com/omise/omise-woocommerce/pull/365))
- Fixed Truemoney phone number input not displaying. (PR [#367](https://github.com/omise/omise-woocommerce/pull/367))
- Added Google pay icon. (PR [#368](https://github.com/omise/omise-woocommerce/pull/368))
- Fixed secure form not displaying on pay for order page. (PR [#371](https://github.com/omise/omise-woocommerce/pull/371))
- Added PayPay payment method. (PR [#372](https://github.com/omise/omise-woocommerce/pull/372))
- Fixed secured form database key mismatch. (PR [#373](https://github.com/omise/omise-woocommerce/pull/373))
- Fixed guest checkout with pay for order link. (PR [#374](https://github.com/omise/omise-woocommerce/pull/374))

## [v5.0.0 _(Apr 3, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v5.0.0)
- Replace credit card form with secure form with a feature flag options to switch between credit card forms. (PR [#354](https://github.com/omise/omise-woocommerce/pull/354))
- Added an admin notice to notify the user to update the current credit card form to embedded form. (PR [#358](https://github.com/omise/omise-woocommerce/pull/358))
- Track the adoption of the secure form. (PR [#359](https://github.com/omise/omise-woocommerce/pull/359))
- Removed SCB and KTB internet banking. (PR [#356](https://github.com/omise/omise-woocommerce/pull/356))
- Bug fix: hanlde Shopeepay cancel payment. (PR [#361](https://github.com/omise/omise-woocommerce/pull/361))

## [v4.29.0 _(Mar 8, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.29.0)
- Added Krungthai NEXT mobile banking (PR [#347](https://github.com/omise/omise-woocommerce/pull/347))

## [v4.28.1 _(Jan 25, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.28.1)
- Fix Uncaught Error: Call to a member function getShopeeBackend() on null. (PR [#344](https://github.com/omise/omise-woocommerce/pull/344))

## [v4.28.0 _(Jan 23, 2023)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.28.0)
- Added ShopeePay for Thailand and Singapore. (PR [#339](https://github.com/omise/omise-woocommerce/pull/339))
- Rebrand Lotus's Bill Payment. (PR [#336](https://github.com/omise/omise-woocommerce/pull/336))
- Replace ezypay with MBB in installments. (PR [#333](https://github.com/omise/omise-woocommerce/pull/333))
- Fixed the method to get currency to the correct method. (PR [#338](https://github.com/omise/omise-woocommerce/pull/338))
- Code Coverage Integration with Sonarcloud. (PR [#337](https://github.com/omise/omise-woocommerce/pull/337))
- Fix the compatible issue with PHP 7.2 and below. (PR [#342](https://github.com/omise/omise-woocommerce/pull/342))

## [v4.27.0 _(Dec 7, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.27.0)
- Rebrand Omise to Opn Payments. (PR [#329](https://github.com/omise/omise-woocommerce/pull/329))
- Update the links from Dashboard v1 to v2. (PR [#330](https://github.com/omise/omise-woocommerce/pull/330))
- Changed missing text from Omise to Opn Payments. (PR [#331](https://github.com/omise/omise-woocommerce/pull/331))

## [v4.26.0 _(Nov 2, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.26.0)
- Metadata keys is_omise_payment_resolved added as protected metadata. (PR [#324](https://github.com/omise/omise-woocommerce/pull/324))
- Fix the issue of customer getting back to checkout page from OTP page. (PR [#323](https://github.com/omise/omise-woocommerce/pull/323))
- Fixed the credit card form's UI issue with default theme. (PR [#322](https://github.com/omise/omise-woocommerce/pull/322))
- Added a delay of 0.5 seconds before calling the charge API in callback class so that we can fetch correct charge status. (PR [#321](https://github.com/omise/omise-woocommerce/pull/321))
- Increased the delay to 2 seconds and added a check for OCBC PAO redirect URL. (PR [#327](https://github.com/omise/omise-woocommerce/pull/327))

## [v4.25.0 _(Oct 6, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.25.0)
- Fixed the conflict between Omise and other payment gateway (PR [#317](https://github.com/omise/omise-woocommerce/pull/317))
- Added Validation on FPX and DuitNow checkout to select the bank (PR [#316](https://github.com/omise/omise-woocommerce/pull/316))
- Fixed customer cannot pay if the omise customer is removed from the API. (PR [#318](https://github.com/omise/omise-woocommerce/pull/318))
- Fixed Promptpay QR image format error on KPlus Android App (PR [#319](https://github.com/omise/omise-woocommerce/pull/319))

## [v4.24.2 _(Sep 20, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.24.2)
- Fix the issue of not being able to add new live keys. (PR [#313](https://github.com/omise/omise-woocommerce/pull/313))

## [v4.24.1 _(Sep 15, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.24.1)
- Fix the issue of user unable to set new keys when their old keys are expired. (PR [#311](https://github.com/omise/omise-woocommerce/pull/311))

## [v4.24.0 _(Sep 7, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.24.0)
- Added Japanese translation for the error messages. (PR [#301](https://github.com/omise/omise-woocommerce/pull/301))
- Update latest omise-php. (PR [#297](https://github.com/omise/omise-woocommerce/pull/297))

### 👾 Bug Fixes
- Billing address details are removed from the POST data when creating card token. (PR [#304](https://github.com/omise/omise-woocommerce/pull/304))
- Updated Omise_Capabilities class to prevent calling capabilities API when the keys are null. (PR [#305](https://github.com/omise/omise-woocommerce/pull/305))
- Fix the issue of mobile banking redirect URI not working in Android chrome. (PR [#309](https://github.com/omise/omise-woocommerce/pull/309))

## [v4.23.3 _(Aug 30, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.23.3)
### 👾 Bug Fixes
- Fixing the issue of card payment by reverting v4.23.2. (PR [#299](https://github.com/omise/omise-woocommerce/pull/299))

## [v4.23.2 _(Aug 18, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.23.2)

### 👾 Bug Fixes
- Handle capabilities failed. (PR [#294](https://github.com/omise/omise-woocommerce/pull/294))

## [v4.23.1 _(Aug 4, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.23.1)

### 👾 Bug Fixes
- Fixed issue of page broken when activate plugin version 4.23.0 (PR [#293](https://github.com/omise/omise-woocommerce/pull/293))

## [v4.23.0 _(Jul 25, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.23.0)

### 🚀 Enhancements
- Added Boost, DuitNow QR, DuitNow Online Banking/Wallets, Maybank QRPay and ShopeePay payment methods. Update Touch 'n Go to support non Alipay+. (PR [#287](https://github.com/omise/omise-woocommerce/pull/287))

## [v4.22.0 _(Jul 5, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.22.0)

### 🚀 Enhancements
- Allow GrabPay payment in Thailand (PR [#282](https://github.com/omise/omise-woocommerce/pull/282))

### 👾 Bug Fixes
- Fix the issue of order status changing to failed when user tries to capture a charge that's already been captured. (PR [#281](https://github.com/omise/omise-woocommerce/pull/281))

## [v4.21.1 _(Jun 16, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.21.1)

### 👾 Bug Fixes
- Fixed the issue of creating GooglePay live mode payments (PR [#280](https://github.com/omise/omise-woocommerce/pull/280))

## [v4.21.0 _(Jun 15, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.21.0)

### 🚀 Enhancements
- Added GooglePay payment method (PR [#278](https://github.com/omise/omise-woocommerce/pull/278))

## [v4.20.1 _(Jun 6, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.20.1)

### 🚀 Enhancements
- Update FPX logo, banklist and terms & condition (PR [#275](https://github.com/omise/omise-woocommerce/pull/275))
- Update assets Bank of China Logo for FPX (PR [#274](https://github.com/omise/omise-woocommerce/pull/274))

## [v4.20 _(May 11, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.20)

### 🚀 Enhancements
- Added GrabPay payment method (PR [#270](https://github.com/omise/omise-woocommerce/pull/270))

## [v4.19.3 _(May 10, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.19.3)

### 🚀 Enhancements
- Move OCBC Pay Anyone out of Mobile Banking (PR [#265](https://github.com/omise/omise-woocommerce/pull/265))

## [v4.19.2 _(Apr 21, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.19.2)

### 👾 Bug Fixes
- Fixed the issue of cannot go to order confimation page after pay with OCBC Pay Anyone. (PR [#262](https://github.com/omise/omise-woocommerce/pull/262))

## [v4.19.1 _(Apr 20, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.19.1)

### 🚀 Bug Fixes
- Fixed the issue of description set for Installment and TrueMoney wallet not displayed in the checkout page. (PR [#260](https://github.com/omise/omise-woocommerce/pull/260))

## [v4.19 _(Apr 4, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.19)

### 🚀 Enhancements
- Update assets for mobile banking logos (PR [#257](https://github.com/omise/omise-woocommerce/pull/257))

### 👾 Bug Fixes
- Fix issue with Rabbit LINE Pay being incompabible with older PHP versions (PR [#256](https://github.com/omise/omise-woocommerce/pull/256))

## [v4.18 _(Mar 23, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.18)

### 🚀 Enhancements
- Add support for BBL Mobile Banking and BAY Mobile Banking (PR [#252](https://github.com/omise/omise-woocommerce/pull/252))

## [v4.17.1 _(Mar 14, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.17.1)

### 👾 Bug Fixes
- Fix issue Mobile Banking and Rabbit LINE Pay not showing.

## [v4.17 _(Mar 8, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.17)

### 🚀 Enhancements
- Add support for KBank Mobile Banking and SCB Mobile Banking (PR [#246](https://github.com/omise/omise-woocommerce/pull/246))
- Add support for Rabbit LINE Pay (PR [#248](https://github.com/omise/omise-woocommerce/pull/248))

### 👾 Bug Fixes
- Fix issue where capture button is still showing after payment is already captured
- Fix issue where mobile banking payment options is display when checkout currency not supported (PR [#249](https://github.com/omise/omise-woocommerce/pull/249))

## [v4.16.2 _(Feb 22, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.16.2)
### 👾 Bug Fixes
- Fix authentication issue

## [v4.16.1 _(Feb 22, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.16.1)
### 👾 Bug Fixes
- Fix issue where place order button is not working correctly

## [v4.16 _(Feb 21, 2022)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.16)

### 🚀 Enhancements
- Add support for OCBC Pay Anyone Mobile Banking (PR [#239](https://github.com/omise/omise-woocommerce/pull/239))

## [v4.15.1 _(Dec 14, 2021)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.15.1)

### 👾 Bug Fixes
- Allow non Omise payment to send email to merchant once make order with status as oh-hold (PR [#242](https://github.com/omise/omise-woocommerce/pull/242))

## [v4.15 _(Oct 26, 2021)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.15)

### 🚀 Enhancements
- Add support for Citi, Maybank (EzyPay), UOB, and TTB Installment (PR [#236](https://github.com/omise/omise-woocommerce/pull/236))

### 👾 Bug Fixes
- Allow offline payment methods to send email when order status changes to processing (PR [#237](https://github.com/omise/omise-woocommerce/pull/237))

## [v4.14 _(Oct 21, 2021)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.14)

### 👾 Bug Fixes
- No longer sends email to merchant when order status is on hold (PR [#232](https://github.com/omise/omise-woocommerce/pull/232))
- Sends email to merchant when order status changes from on hold to processing (PR [#233](https://github.com/omise/omise-woocommerce/pull/233))
- No longer sends Paynow QR code with order process email (PR [#235](https://github.com/omise/omise-woocommerce/pull/235))

## [v4.13 _(Oct 18, 2021)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.13)

- Revert breaking changes in v4.12 which causes the email configuration page to freeze

## [v4.12 _(Oct 18, 2021)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.12)

### 👾 Bug Fixes
- Fix Paynow QR sent in new order email to merchant (PR [#229](https://github.com/omise/omise-woocommerce/pull/229))
- No longer send email to merchant when order status is on hold (PR [#230](https://github.com/omise/omise-woocommerce/pull/230))

## [v4.11 _(Aug 25, 2021)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.11)

### 🚀 Enhancements
- Add Alipay+ wallets (Only available in Singapore currently) (PR [#227](https://github.com/omise/omise-woocommerce/pull/227))

## [v4.10 _(Jul 21, 2021)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.10)

### 🚀 Enhancements
- Introducing FPX payment method (only available in Malaysia) (PR [#223](https://github.com/omise/omise-woocommerce/pull/223))

### 👾 Bug Fixes
- Fix PromptPay QR viewing issue after downloading from email (PR [#222](https://github.com/omise/omise-woocommerce/pull/222))
- Fix phone number input box not showing (PR [#225](https://github.com/omise/omise-woocommerce/pull/225))

## [v4.9 _(Jun 30, 2021)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.9)

### 🚀 Enhancements
- Update min amount for installment bay and kbank (PR [#218](https://github.com/omise/omise-woocommerce/pull/218))
- Remove QR from email when charge is no longer pending (PR [#219](https://github.com/omise/omise-woocommerce/pull/219))
- Enable credit/debit card payment methods in WooCommerce for MY (PR [#220](https://github.com/omise/omise-woocommerce/pull/220))

## [v4.8 _(Apr 19, 2021)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.8)

### 🚀 Enhancements
- Change the minimum amount for installment payments from 3000 to 2000 THB. (PR [#210](https://github.com/omise/omise-woocommerce/pull/210))
- Update Omise-PHP library from v2.11.2 to v2.13.0. (PR [#211](https://github.com/omise/omise-woocommerce/pull/211))

### 👾 Bug Fixes
- Fix CVE-2020-29156 security vulnerability. (PR [#213](https://github.com/omise/omise-woocommerce/pull/213))

## [v4.7 _(Mar 23, 2021)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.7)

### 🚀 Enhancements
- Updating the error message mapping for payment_rejected and failed_processing error codes. (PR [#207](https://github.com/omise/omise-woocommerce/pull/207))

## [v4.6 _(Dec 23, 2020)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.6)

### 🚀 Enhancements
- Updating translation for Japanese language in konbini payment. (PR [#204](https://github.com/omise/omise-woocommerce/pull/204))
- Adding support to online refunds in paynow. (PR [#202](https://github.com/omise/omise-woocommerce/pull/202))
- Run tests using GitHub Actions. (PR [#203](https://github.com/omise/omise-woocommerce/pull/203))

## [v4.5 _(Dec 04, 2020)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.5)

### 🚀 Enhancements
- Removing name attribute from card payment form. (PR [#196](https://github.com/omise/omise-woocommerce/pull/196))
- Rendering barcode in mobile phones vertically to avoid breakline. (PR [#197](https://github.com/omise/omise-woocommerce/pull/197))
- Refresh QR payment screen once customer completes payment. (PR [#198](https://github.com/omise/omise-woocommerce/pull/198))
- Auto formatting card numbers in input field on checkout page and My account page. (PR [#200](https://github.com/omise/omise-woocommerce/pull/200))

---

## [v4.4 _(Nov 17, 2020)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.4)

### ✨ Highlights
- Adding installment SCB support. (PR [#193](https://github.com/omise/omise-woocommerce/pull/193))

---

## [v4.3 _(Oct 15, 2020)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.3)

### ✨ Highlights
- Introducing Konbini payment method. (PR [#149](https://github.com/omise/omise-woocommerce/pull/149))

### 🚀 Enhancements
- PayNow, adding a link to the QR code url at the order-confirmation email. (PR [#185](https://github.com/omise/omise-woocommerce/pull/185))

---

## [v4.2 _(Sep 15, 2020)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.2)

### 🚀 Enhancements
- Removing Gruntfile and package.json as no longer needed grunt-wp-i18n library. (PR [#187](https://github.com/omise/omise-woocommerce/pull/187))

### 👾 Bug Fixes
- Updating deprecated functions in WooCommerce v3. (PR [#189](https://github.com/omise/omise-woocommerce/pull/189))
- Adding permission to callback which helps to removes a warning message on Wordpress 5.5. (PR [#188](https://github.com/omise/omise-woocommerce/pull/188))

---

## [v4.1 _(Aug 21, 2020)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.1)

### ✨ Highlights
- Introducing PromptPay payment method (Thailand). (PR [#170](https://github.com/omise/omise-woocommerce/pull/170))

### 🚀 Enhancements
- Bypassing Callback function for Offline payment methods. (PR [#184](https://github.com/omise/omise-woocommerce/pull/184))
- Manual Sync, handling more cases: 'expired', 'refunded', 'reversed'. (PR [#183](https://github.com/omise/omise-woocommerce/pull/183))
- Cleaning up code style & indentation. (PR [#182](https://github.com/omise/omise-woocommerce/pull/182))

---

## [v4.0 _(Jul 20, 2020)_](https://github.com/omise/omise-woocommerce/releases/tag/v4.0)

### ✨ Highlights
- Refactoring Event Handlers, make the code support for asynchronous request to prevent race-condition from Webhook. (PR [#179](https://github.com/omise/omise-woocommerce/pull/179))
- Revising Omise Settings. (PR [#175](https://github.com/omise/omise-woocommerce/pull/175))

### 🚀 Enhancements
- Credit Card payment, updating order status to 'processing' for successful 'auth-only' payment. (PR [#180](https://github.com/omise/omise-woocommerce/pull/180))
- Bump lodash from 4.17.15 to 4.17.19. (PR [#178](https://github.com/omise/omise-woocommerce/pull/178))
- Revise order statuses (Part 1, failing payment should result as order failed). (PR [#171](https://github.com/omise/omise-woocommerce/pull/171))
- PayNow: adding default payment instruction at the checkout page. (PR [#169](https://github.com/omise/omise-woocommerce/pull/169))
- Reduce duplicated code from offline payment methods to a dedicated class. (PR [#168](https://github.com/omise/omise-woocommerce/pull/168))
- Code Refactoring, simplifying Callback function. (PR [#167](https://github.com/omise/omise-woocommerce/pull/167))
- Integrating WooCommerce refund's reason parameter to Omise Refund object. (PR [#165](https://github.com/omise/omise-woocommerce/pull/165))
- Be able to create a refund when placing an order with Alipay or Installment payment method. (PR [#158](https://github.com/omise/omise-woocommerce/pull/158))
- Code refactoring, simplifying the 'process_refund' method. (PR [#157](https://github.com/omise/omise-woocommerce/pull/157))

### 📝 Documents
- Create LICENSE. (PR [#173](https://github.com/omise/omise-woocommerce/pull/173))
- Move usage docs to website. (PR [#172](https://github.com/omise/omise-woocommerce/pull/172))
- README, updating document. (PR [#159](https://github.com/omise/omise-woocommerce/pull/159))

---

## [v3.11 _(Mar 18, 2020)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.11)

### ✨ Highlights

- Introducing PayNow payment method (only available in Singapore) (PR [#152](https://github.com/omise/omise-woocommerce/pull/152))

### 🚀 Enhancements

- (proposal) Code cleaning for payment method classes. (PR [#153](https://github.com/omise/omise-woocommerce/pull/153))
- Payment Setting: properly display payment methods based on a given Omise Account (for admin) (PR [#151](https://github.com/omise/omise-woocommerce/pull/151))

---

## [v3.10 _(Jan 16, 2020)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.10)

### ✨ Highlights

- Credit Card payment, automatically detect if a particular charge is processing using 3-D Secure feature (PR [#146](https://github.com/omise/omise-woocommerce/pull/146))

### 🚀 Enhancements

- Code refactoring for a better i18n for strings that were in JS files (PR [#147](https://github.com/omise/omise-woocommerce/pull/147))
- Refactoring offsite payment methods (introducing abstract offsite class) (PR [#143](https://github.com/omise/omise-woocommerce/pull/143))

### 📝 Documents

- README, polishing and updating all missing contents (PR [#145](https://github.com/omise/omise-woocommerce/pull/145))

---

## [v3.9 _(Oct 31, 2019)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.9)

### ✨ Highlights

- Introducing TrueMoney payment (only available in Thailand) (PR [#139](https://github.com/omise/omise-woocommerce/pull/139))

### 🚀 Enhancements

- Bill Payment, correcting order status after a new order is placed (on-hold instead of pending-payment) (PR [#142](https://github.com/omise/omise-woocommerce/pull/142))
- Adding ability to sync payment status to Bill Payment and TrueMoney Payment (PR [#140](https://github.com/omise/omise-woocommerce/pull/140))

---

## [v3.8 _(Sep 17, 2019)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.8)

### 👾 Bug Fixes

- Billpayment - check if an order is made by Bill Payment before display a barcode. (PR [#137](https://github.com/omise/omise-woocommerce/pull/137))

---

## [v3.7 _(Sep 13, 2019)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.7)

### ✨ Highlights

- Introducing Bill Payment. (PR [#122](https://github.com/omise/omise-woocommerce/pull/122), [#125](https://github.com/omise/omise-woocommerce/pull/125), [#126](https://github.com/omise/omise-woocommerce/pull/126), [#128](https://github.com/omise/omise-woocommerce/pull/128), [#129](https://github.com/omise/omise-woocommerce/pull/129))

### 👾 Bug Fixes

- Event "charge.complete", making sure that event's charge id is identical with order transaction id. (PR [#131](https://github.com/omise/omise-woocommerce/pull/131))
- Fixing calling Omise_Money's non-static method statically. (PR [#130](https://github.com/omise/omise-woocommerce/pull/130))

### 📝 Documents

- Updating README.md, adding 2 missing payment methods at 'Enable Payment Method' section. (PR [#127](https://github.com/omise/omise-woocommerce/pull/127))

---

## [v3.6 _(Aug 1, 2019)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.6)

### ✨ Highlights

- [#118](https://github.com/omise/omise-woocommerce/pull/118): Better way to handle amount subunit, adding support for more currencies.

### 🚀 Enhancements

- [#124](https://github.com/omise/omise-woocommerce/pull/124): Updating npm vulnerable dependencies.

---

## [v3.5 _(Jul 23, 2019)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.5)

### 👾 Bug Fixes

- [#120](https://github.com/omise/omise-woocommerce/pull/120): Properly assigning querystrings for the payment callback endpoints.

---

## [v3.4 _(Jun 14, 2019)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.4)

### ✨ Highlights

- [#115](https://github.com/omise/omise-woocommerce/pull/115): Installment, display instalment monthly amount & interest fee at the checkout page.
- [#99](https://github.com/omise/omise-woocommerce/pull/99): Introduce Installment payment method.

### 🚀 Enhancements

- [#114](https://github.com/omise/omise-woocommerce/pull/114): Update Omise-PHP library from v2.11.1 to v2.11.2.
- [#113](https://github.com/omise/omise-woocommerce/pull/113): Unifying stylesheet & fixing some broken styles.
- [#112](https://github.com/omise/omise-woocommerce/pull/112): Correcting & enhancing payment response messages.
- [#111](https://github.com/omise/omise-woocommerce/pull/111): Removing all redundant code regarding to WC Order transaction ID assignment.
- [#109](https://github.com/omise/omise-woocommerce/pull/109): 🧹 Code Cleaning: Relocating 'capture' method from Omise_Payment class to Omise_Payment_Creditcard.
- [#108](https://github.com/omise/omise-woocommerce/pull/108): Refactoring, unify Omise key(s)-defining into one place.
- [#101](https://github.com/omise/omise-woocommerce/pull/101): Refactoring, simplifying payment processors.

---

## [v3.3 _(Mar 28, 2019)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.3)

### 🚀 Enhancements

- [#106](https://github.com/omise/omise-woocommerce/pull/106): Removing unused stylesheet & js file.
- [#102](https://github.com/omise/omise-woocommerce/pull/102): Migrating all related code to support Omise API version v2017-11-02.
- [#98](https://github.com/omise/omise-woocommerce/pull/98): Added filter hooks for charge.description and charge.metadata.
- [#96](https://github.com/omise/omise-woocommerce/pull/96): Refactoring plugin-initial code structure - part 3: Organizing Omise_Admin class.
- [#95](https://github.com/omise/omise-woocommerce/pull/95): Refactoring plugin-initial code structure - part 2: Relocating, renaming functions and method.
- [#94](https://github.com/omise/omise-woocommerce/pull/94): Refactoring plugin-initial code structure - part 1: Enhancing the behavior of checking dependency plugin.
- [#93](https://github.com/omise/omise-woocommerce/pull/93): Upgrade Omise-PHP library from v2.8.0 to v2.11.1.
- [#91](https://github.com/omise/omise-woocommerce/pull/91): Removing the deprecated function (from jQuery's reported).
- [#86](https://github.com/omise/omise-woocommerce/pull/86): README, update the installation instruction, enhance overall contents.

### 👾 Bug Fixes

- [#104](https://github.com/omise/omise-woocommerce/pull/104): Omise Setting Page, sanitizing input fields before save.

---

## [v3.2 _(Apr 20, 2018)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.2)

### ✨ Highlights

- Support multi currency (PR [#84](https://github.com/omise/omise-woocommerce/pull/84))

### 🚀 Enhancements

- Remove legacy files and codes (that we no longer use) (PR [#85](https://github.com/omise/omise-woocommerce/pull/85))

### 👾 Bug Fixes

- Issue #78 fatal error, if install omise plugin before woo commerce (PR [#83](https://github.com/omise/omise-woocommerce/pull/83), [#88](https://github.com/omise/omise-woocommerce/pull/88))

---

## [v3.1 _(Sep 19, 2017)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.1)

### ✨ Highlights

- Introduce WebHook feature. (PR [#62](https://github.com/omise/omise-woocommerce/pull/62))
- Add Omise Setting page and enhance Omise setting process. (PR [#61](https://github.com/omise/omise-woocommerce/pull/61))

### 🚀 Enhancements

- Spell WordPress correctly! (PR [#56](https://github.com/omise/omise-woocommerce/pull/56)) :by [@mayukojpn](https://github.com/mayukojpn))
- Support WooCommerce 2.x series & PHP 5.4 (PR [#59](https://github.com/omise/omise-woocommerce/pull/59))

## [v3.0 _(Jul 26, 2017)_](https://github.com/omise/omise-woocommerce/releases/tag/v3.0)

### ✨ Highlights

- Support Alipay payment! (PR [#48](https://github.com/omise/omise-woocommerce/pull/48))
- Be able to manual sync Omise charge status directly in a WooCommerce store. (PR [#47](https://github.com/omise/omise-woocommerce/pull/47))
- Now can create a refund inside the order detail page! (for credit card payment method only). (PR [#42](https://github.com/omise/omise-woocommerce/pull/42))
- Support Internet Banking payment! (PR [#41](https://github.com/omise/omise-woocommerce/pull/41), [#46](https://github.com/omise/omise-woocommerce/pull/46))
- Switch to fully use 'Omise-PHP' library to connect with Omise API instead of the previous custom one. (PR [#38](https://github.com/omise/omise-woocommerce/pull/38))
- Huge plugin code refactoring & provides a new plugin code structure (for anyone who did customize on the core code of plugin, please check this carefully!) (PR [#36](https://github.com/omise/omise-woocommerce/pull/36), [#37](https://github.com/omise/omise-woocommerce/pull/37), [#39](https://github.com/omise/omise-woocommerce/pull/39), [#40](https://github.com/omise/omise-woocommerce/pull/40))

### 🚀 Enhancements

- Backward compatible with Omsie-WooCommerce v1.2.3. (PR [#50](https://github.com/omise/omise-woocommerce/pull/50))
- Humanize messages that will be displayed on a user's screen (PR [#49](https://github.com/omise/omise-woocommerce/pull/49))
- Remove Omise Dashboard support. (PR [#44](https://github.com/omise/omise-woocommerce/pull/44))
- Upgrade Omise-PHP library to v2.8.0 (the latest one). (PR [#43](https://github.com/omise/omise-woocommerce/pull/43))
- Improve UX of the payment credit card form (after our UX team did researches on user behaviours on a credit card form). (PR [#45](https://github.com/omise/omise-woocommerce/pull/45))
- Update plugin's 'text-domain' to support GlotPress translation system.  (PR [#32](https://github.com/omise/omise-woocommerce/pull/32) & [#34](https://github.com/omise/omise-woocommerce/pull/34). Big thanks for [@mayukojpn](https://github.com/mayukojpn))

### 👾 Bug Fixes

- Fix 'save credit card for next time' feature for WooCommerce v3.x. (PR [#45](https://github.com/omise/omise-woocommerce/pull/45))

---

## [1.2.3] 2016-08-30
- *`Added`* Add a new feature, localization
- *`Added`* Add a translation file for Japanese
- *`Changed`* Change a page header from transactions history to charges history
- *`Removed`* Remove a link, view detail, from each row of transactions and transfers history table
- *`Removed`* Remove sub-tabs, charges and transfers
- *`Removed`* Remove an unused setting, description

## [1.2.2] 2016-08-26
- *`Improved`* Specify the display size of card brand image and allow customer to define their own style
- *`Removed`* Remove an unused unit test of the library, omise-php

## [1.2.1] 2016-08-05
- *`Added`* Configuration for card brand logo display
- *`Added`* List of transfers
- *`Fixed`* Changing page by specify the page number which is not functional

## [1.2.0] 2016-06-01
- *`Added`* manual capture feature
- *`Added`* supported JPY currency
- *`Added`* shortcut menu to Omise's setting page
- *`Added`* Included Omise-PHP 2.4.1 library to the project.
- *`Improved`* Redesigned Omise Dashboard
- *`Improved`* Re-ordered fields in Omise Setting page.
- *`Improved`* Better handle error cases (error messages)
- *`Improved`* Better handle WC order note to trace Omise's actions back.
- *`Improved`* Revised PHP code to following the WordPress Coding Standards.
- *`Improved`* Fixed/Improved various things.

## [1.1.1] 2015-11-16
- *`Added`* Added Omise-Version into the cURL request header.

## [1.1.0] 2015-09-24
- *`Added`* Adds support for 3-D Secure.

## [1.0.2] 2015-03-23
- *`Fixed`* Fix create token issue.

## [1.0.1] 2015-03-10
- *`Added`* Support fund transfers.

## [1.0.0] 2015-01-20
- *`Added`* First version supports.
  - Charge a card
  - Save a card
  - Delete a card
