<?php // (C) Copyright Bobbing Wide 2011-2014
/*

Notes & Limitations
- If the button that's generated doesn't fit your needs then you can go to 
  https://www.paypal.com/cgi-bin/webscr?cmd=_button-designer
  and generate the HTML directly
  
- This code assumes that you will not be adding Tax or Shipment costs
- The choice of images for the button are hard coded and uses images for the UK
- You can see a load of PayPal buttons at:
  http://members.cox.net/pptech/paypal_button_chart.htm   
- This code was originally based upon the jw-paypal-shortcodes plugin (designed for use in the US)
- It has now been almost completely rewritten to follow oik's lazy smart shortcode conventions
- The plugins (this one and jw-paypal-shortcodes) should co-exist peacefully.
- I had no idea what the purpose of this image was https://www.paypal.com/en_GB/i/scr/pixel.gif
  but having read the forums I now see that it's not particularly important so I've eliminated it
  from the generated code.
- The generated code is for NonHostedGuest buttons - not buttons that are saved in your PayPal account.
  see https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=developer/e_howto_html_paypal_shopping_cart
  
This is an extract from PayPal button creation help...
  
By default, the button creation tool saves payment buttons in your PayPal account. 
The tool saves your button and generates the code when you click the Create Button. 
You must copy and paste the generated code onto your webpages, whether or not you save your button at PayPal. 
The generated code is shorter for saved buttons, because PayPal keeps most of the information about your button in your account,
instead of placing it in the code that you add to your website.

Saving your payment buttons in your PayPal account has these benefits:

Your payment buttons are more secure, because the generated code that add to your website contains no information that can be tampered with to produce fraudulent payments.
You can edit the details and options for your payment buttons in your PayPal account, without changing the button code that you added to your website.
NOTE: If you change product options, you must copy and paste the code newly generated by PayPal to replace the code that you pasted previously.
You can track inventory.
Use the Step 2 section of the button creation tool to control whether your button is saved in your PayPal account.

For more information, see Saving Payment Buttons in Your PayPal Account.  
https://cms.paypal.com/us/cgi-bin/?cmd=_render-content&content_ID=developer/e_howto_html_saving_buttons
  
  
*/

      
/**
 * This file is loaded during oik_options_init which is called to process 'admin_init'
 * so we can't add processing for this action... just do it
 * Notes: 
 * - We assume that the current user can edit content. If they can't then the filters won't get called.
 * - It also seems unnecessary to test if we're in "rich_editing" mode; same reason as above.
*/
add_filter( 'mce_buttons', 'bw_paypal_filter_mce_button' );
add_filter( 'mce_external_plugins', 'bw_paypal_filter_mce_plugin' );

/**
 * Implement 'mce_buttons' filter to add the bwpaypal_button to the array of Tiny MCE buttons
 */       
function bw_paypal_filter_mce_button( $buttons ) {
  global $tinymce_version;
  if ( version_compare( $tinymce_version, '4018' ) >= 0 ) {
    array_push( $buttons, 'bwpaypal' );
  } else {  
    array_push( $buttons, 'bwpaypal_button' );
  }
  return $buttons;
}
 
/**
 * Implement 'mce_external_plugins' filter to add the jQuery code to be executed when then bwpaypalbutton_button is clicked
 * 
 * Note: The _button suffix is not used... not quite sure where the linkage is
 * @see http://codex.wordpress.org/TinyMCE_Custom_Buttons
 *
*/ 
function bw_paypal_filter_mce_plugin($plugins) {
  global $tinymce_version;
  if ( version_compare( $tinymce_version, '4018' ) >= 0 ) {
    $plugins['bwpaypal'] = oik_url( 'admin/oik_paypal_plugin_4.js' );
  } else {
    $plugins['bwpaypal'] = oik_url( 'admin/oik_paypal_plugin.js' );
  }
  return $plugins;
}
        

