<?php // phpcs:ignoreFile ?>
<div id="Theme_type_upload_div" style="display:<?php echo ($Html -> field_value('Theme[type]') == "" || $Html -> field_value('Theme[type]') == "upload") ? 'block' : 'none'; ?>;">
	<table class="form-table">
    	<tbody>
        	<tr>
            	<th><label for=""><?php esc_html_e('Choose HTML File', 'wp-mailinglist'); ?></label></th>
                <td>
                	<input class="widefat" type="file" name="upload" value="" />
                    <?php if (!empty($Theme -> errors['upload'])) : ?>
                    	<div class="newsletters_error"><?php echo wp_kses_post($Theme -> errors['upload']); ?></div>
                    <?php endif; ?>
                </td>
            </tr>
        </tbody>
    </table>
</div>

<h3><?php esc_html_e('Permanent Options', 'wp-mailinglist'); ?></h3>
<p class="howto"><?php esc_html_e('These options are used every time the template is used.', 'wp-mailinglist'); ?></p>
<table class="form-table">
	<tbody>
		<tr>
			<th><label for="Theme_themestylesheet"><?php esc_html_e('Include WordPress Theme Stylesheet', 'wp-mailinglist'); ?></label>
			<td>
				<label><input <?php checked($Theme -> data -> themestylesheet, 1, true); ?> type="checkbox" value="1" name="Theme[themestylesheet]" id="Theme_themestylesheet" /> <?php esc_html_e('Yes, include the WordPress theme stylesheet in this template.', 'wp-mailinglist'); ?></label>
			</td>
		</tr>
		<tr>
			<th><label for="Theme_acolor"><?php esc_html_e('Shortcode Link Color', 'wp-mailinglist'); ?></label>
			<?php echo ( $Html -> help(__('Set the color of the links generated from the plugin shortcodes dynamically.', 'wp-mailinglist'))); ?></th>
			<td>
				<input type="text" class="color-picker" name="Theme[acolor]" value="<?php echo esc_html($Html -> field_value('Theme[acolor]')); ?>" id="Theme_acolor" />
				<span class="howto"><?php echo sprintf(__('Control the color of the links generated by shortcodes such as %s, %s, %s, etc.', 'wp-mailinglist'), '[newsletters_online]', '[newsletters_activate]', '[newsletters_unsubscribe]'); ?></span>
			</td>
		</tr>
	</tbody>
</table>

<h3><?php esc_html_e('Once-Off Options', 'wp-mailinglist'); ?></h3>
<p class="howto"><?php esc_html_e('These options are used once when you save this template and not again.', 'wp-mailinglist'); ?></p>
<table class="form-table">
	<tbody>
    	<tr>
    		<th><label for="Theme_imgprependurl"><?php esc_html_e('Image Prepend URL', 'wp-mailinglist'); ?></label>
    		<?php echo ( $Html -> help(__('If your template has relative image paths in the source, this image prepend URL setting is very useful to automatically add an absolute URL to the source attribute of all images. E.g., <code>src="images/myimage.jpg"</code> and you fill in a prepend URL of <code>https://example.com/</code>, it will become <code>src="https://example.com/images/myimage.jpg"</code>', 'wp-mailinglist'))); ?></th>
    		<td>
            <input type="text" class="widefat" name="Theme[imgprependurl]" value="<?php echo  isset($Theme -> data -> imgprependurl) ? esc_attr(wp_unslash($Theme -> data -> imgprependurl)) : ''; ?>" id="Theme_imgprependurl" />
    			<span class="howto">
    				<small><?php esc_html_e('(optional)', 'wp-mailinglist'); ?></small> <?php esc_html_e('Prepend the SRC attribute of IMG tags with a URL', 'wp-mailinglist'); ?><br/>
    				<?php esc_html_e('Note that this is only used ONCE and this setting will revert again to none.', 'wp-mailinglist'); ?>
    			</span>
    		</td>
    	</tr>
        <tr>
			<th><label for="Theme_inlinestyles_N"><?php esc_html_e('Inline Styles', 'wp-mailinglist'); ?></label>
			<?php echo ( $Html -> help(__('Set this setting to "Yes" to automatically convert all CSS rules into inline, style attributes in the HTML elements. If you use this setting, be sure to create a backup of your original HTML for easier editing later on.', 'wp-mailinglist'))); ?></th>
			<td>
				<label><input onclick="if (!confirm('<?php esc_html_e('Please ensure that you create a local copy/backup of your newsletter template HTML for editing in the future.', 'wp-mailinglist'); ?>')) { return false; }" type="radio" name="Theme[inlinestyles]" value="Y" id="Theme_inlinestyles_Y" /> <?php esc_html_e('Yes', 'wp-mailinglist'); ?></label>
				<label><input type="radio" checked="checked" name="Theme[inlinestyles]" value="N" id="Theme_inlinestyles_N" /> <?php esc_html_e('No', 'wp-mailinglist'); ?></label>
				<span class="howto">
					<?php esc_html_e('Convert CSS rules into inline, style attributes on elements.', 'wp-mailinglist'); ?><br/>
					<?php esc_html_e('Note that this is only used ONCE and this setting will revert again to none.', 'wp-mailinglist'); ?>
				</span>
			</td>
		</tr>
	</tbody>
</table>