<?php // phpcs:ignoreFile ?>
<!-- Unsubscribe Settings -->

<?php

$resubscribe = $this -> get_option('resubscribe');
$unsubscribeemails = $this -> get_option('unsubscribeemails');
$unsubscribe_usernotification = $this -> get_option('unsubscribe_usernotification');
$unsubscribe_redirect = $this -> get_option('unsubscribe_redirect');
$unsubscribe_redirect_url = $this -> get_option('unsubscribe_redirect_url');

?>

<table class="form-table">
	<tbody>
		<tr>
			<th><label for="unsubscribeondelete_Y"><?php esc_html_e('Unsubscribe on User Deletion', 'wp-mailinglist'); ?></label>
			<?php echo ( $Html -> help(__('When you delete a WordPress user under "Users" in the dashboard, the subscriber (if any) with the same email address will be deleted as well.', 'wp-mailinglist'))); ?></th>
			<td>
				<?php $unsubscribeondelete = $this -> get_option('unsubscribeondelete'); ?>	
				<label><input <?php echo $unsubscribeondeleteCheck1 = ($unsubscribeondelete == "Y") ? 'checked="checked"' : ''; ?>  type="radio" name="unsubscribeondelete" value="Y" id="unsubscribeondelete_Y" /> <?php esc_html_e('Yes'); ?></label>
				<label><input <?php echo $unsubscribeondeleteCheck2 = ($unsubscribeondelete == "N") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribeondelete" value="N" id="unsubscribeondelete_N" /> <?php esc_html_e('No'); ?></label>
				<span class="howto"><?php esc_html_e('Should subscribers be unsubscribed when the user with the same email address is deleted?', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
		<tr class="advanced-setting">
			<th><label for="resubscribe"><?php esc_html_e('Resubscribe Link', 'wp-mailinglist'); ?></label></th>
			<td>
				<label><input onclick="if (jQuery(this).is(':checked')) { jQuery('#resubscribe_div').show(); } else { jQuery('#resubscribe_div').hide(); }" <?php echo (!empty($resubscribe)) ? 'checked="checked"' : ''; ?> type="checkbox" name="resubscribe" value="1" id="resubscribe" /> <?php esc_html_e('Yes, provide a resubscribe link after unsubscription.', 'wp-mailinglist'); ?></label>
				<span class="howto"><?php esc_html_e('Show a resubscribe link after someone has unsubscribed', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
	</tbody>
</table>

<div class="newsletters_indented" id="resubscribe_div" style="display:<?php echo (!empty($resubscribe)) ? 'block' : 'none'; ?>;">
	<table class="form-table">
		<tbody>
			<tr>
				<th><label for="resubscribetext"><?php esc_html_e('Resubscribe Link Text', 'wp-mailinglist'); ?></label>
				<?php echo ( $Html -> help(__('This setting simply specifies the text to use for the link of the [newsletters_resubscribe] shortcode that you put into newsletters to generate a resubscribe link.', 'wp-mailinglist'))); ?></th>
				<td>
					<?php if ($this -> language_do()) : ?>
						<?php 
						
						$languages = $this -> language_getlanguages(); 
						$resubscribetext = $this -> get_option('resubscribetext');
						
						?>
						<div id="resubscribetexttabs">
							<ul>
								<?php $tabnumber = 1; ?>
				                <?php foreach ($languages as $language) : ?>
				                 	<li><a href="#resubscribetexttab<?php echo esc_html($tabnumber); ?>"><?php echo wp_kses_post( $this -> language_flag($language)); ?></a></li>
				                    <?php $tabnumber++; ?>
				                <?php endforeach; ?>
				            </ul>
				            
				            <?php $tabnumber = 1; ?>
				            <?php foreach ($languages as $language) : ?>
				            	<div id="resubscribetexttab<?php echo esc_html($tabnumber); ?>">
				            		<input type="text" name="resubscribetext[<?php echo esc_html( $language); ?>]" value="<?php echo esc_attr(wp_unslash($this -> language_use($language, $resubscribetext))); ?>" id="resubscribetext_<?php echo esc_html( $language); ?>" class="widefat" />
				            	</div>
				            	<?php $tabnumber++; ?>
				            <?php endforeach; ?>
						</div>
						
						<script type="text/javascript">
						jQuery(document).ready(function() {
							if (jQuery.isFunction(jQuery.fn.tabs)) {
								jQuery('#resubscribetexttabs').tabs();
							}
						});
						</script>
					<?php else : ?>
						<input class="widefat" type="text" id="<?php echo esc_html( $this -> pre); ?>resubscribetext" name="resubscribetext" value="<?php echo esc_attr(wp_unslash($this -> get_option('resubscribetext'))); ?>" />
					<?php endif; ?>
					<span class="howto"><?php _e('Displays a resubscribe link generated by <code>[newsletters_resubscribe]</code> in content or template of newsletters.', 'wp-mailinglist'); ?></span>
				</td>
			</tr>
		</tbody>
	</table>
</div>

<table class="form-table">
	<tbody>
		<tr>
			<th><label for="<?php echo esc_html( $this -> pre); ?>unsubscribetext"><?php esc_html_e('Unsubscribe Link Text', 'wp-mailinglist'); ?></label>
			<?php echo ( $Html -> help(__('This setting simply specifies the text to use for the link of the [newsletters_unsubscribe] shortcode that you put into newsletters to generate an unsubscribe link. If you want to build your own links with custom text, you can use the [newsletters_unsubscribeurl] shortcode to just generate the URL for the unsubscribe link automatically.', 'wp-mailinglist'))); ?></th>
			<td>
				<?php if ($this -> language_do()) : ?>
					<?php 
					
					$languages = $this -> language_getlanguages(); 
					$unsubscribetext = $this -> get_option('unsubscribetext');
					
					?>
					<div id="unsubscribetexttabs">
						<ul>
							<?php $tabnumber = 1; ?>
			                <?php foreach ($languages as $language) : ?>
			                 	<li><a href="#unsubscribetexttab<?php echo esc_html($tabnumber); ?>"><?php echo wp_kses_post( $this -> language_flag($language)); ?></a></li>
			                    <?php $tabnumber++; ?>
			                <?php endforeach; ?>
			            </ul>
			            
			            <?php $tabnumber = 1; ?>
			            <?php foreach ($languages as $language) : ?>
			            	<div id="unsubscribetexttab<?php echo esc_html($tabnumber); ?>">
			            		<input type="text" name="unsubscribetext[<?php echo esc_html( $language); ?>]" value="<?php echo esc_attr(wp_unslash($this -> language_use($language, $unsubscribetext))); ?>" id="unsubscribetext_<?php echo esc_html( $language); ?>" class="widefat" />
			            	</div>
			            	<?php $tabnumber++; ?>
			            <?php endforeach; ?>
					</div>
					
					<script type="text/javascript">
					jQuery(document).ready(function() {
						if (jQuery.isFunction(jQuery.fn.tabs)) {
							jQuery('#unsubscribetexttabs').tabs();
						}
					});
					</script>
				<?php else : ?>
					<input class="widefat" type="text" id="<?php echo esc_html( $this -> pre); ?>unsubscribetext" name="unsubscribetext" value="<?php echo esc_attr(wp_unslash($this -> get_option('unsubscribetext'))); ?>" />
				<?php endif; ?>
				<span class="howto"><?php _e('Displays an unsubscribe link generated by <code>[newsletters_unsubscribe]</code> in content or template of newsletters.', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
		<tr>
			<th><label for="unsubscribealltext"><?php esc_html_e('Unsubscribe All Link Text', 'wp-mailinglist'); ?></label>
			<?php echo ( $Html -> help(__('Same as the setting above, except that this is the link text for the unsubscribe link to all the lists that the subscriber is subscribed to using the [newsletters_unsubscribeall] shortcode.', 'wp-mailinglist'))); ?></th>
			<td>
				<?php if ($this -> language_do()) : ?>
					<?php 
					
					$languages = $this -> language_getlanguages(); 
					$unsubscribealltext = $this -> get_option('unsubscribealltext');
					
					?>
					<div id="unsubscribealltexttabs">
						<ul>
							<?php $tabnumber = 1; ?>
			                <?php foreach ($languages as $language) : ?>
			                 	<li><a href="#unsubscribealltexttab<?php echo esc_html($tabnumber); ?>"><?php echo wp_kses_post( $this -> language_flag($language)); ?></a></li>
			                    <?php $tabnumber++; ?>
			                <?php endforeach; ?>
			            </ul>
			            
			            <?php $tabnumber = 1; ?>
			            <?php foreach ($languages as $language) : ?>
			            	<div id="unsubscribealltexttab<?php echo esc_html($tabnumber); ?>">
			            		<input type="text" name="unsubscribealltext[<?php echo esc_html( $language); ?>]" value="<?php echo esc_attr(wp_unslash($this -> language_use($language, $unsubscribealltext))); ?>" id="unsubscribealltext_<?php echo esc_html( $language); ?>" class="widefat" />
			            	</div>
			            	<?php $tabnumber++; ?>
			            <?php endforeach; ?>
					</div>
					
					<script type="text/javascript">
					jQuery(document).ready(function() {
						if (jQuery.isFunction(jQuery.fn.tabs)) {
							jQuery('#unsubscribealltexttabs').tabs();
						}
					});
					</script>
				<?php else : ?>
					<input class="widefat" type="text" id="unsubscribealltext" name="unsubscribealltext" value="<?php echo esc_attr(wp_unslash($this -> get_option('unsubscribealltext'))); ?>" />
				<?php endif; ?>
				<span class="howto"><?php _e('Displays an unsubscribe link generated by <code>[newsletters_unsubscribeall]</code> in content or template of newsletters.', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
		<tr>
			<th><label for="unsubscribe_usernotification"><?php esc_html_e('User Notification Email', 'wp-mailinglist'); ?></label>
			<?php echo ( $Html -> help(sprintf(__('Turning this on will send a notification email to acknowledge the unsubscribe after they have unsubscribed. You can modify the email message under %s', 'wp-mailinglist'), '<a href="?page=' . $this -> sections -> settings_templates . '">' . __('System Emails', 'wp-mailinglist') . '</a>'))); ?></th>
			<td>
				<label><input <?php echo (!empty($unsubscribe_usernotification)) ? 'checked="checked"' : ''; ?> type="checkbox" name="unsubscribe_usernotification" value="1" id="unsubscribe_usernotification" /> <?php esc_html_e('Yes, send the user an unsubscribe confirmation email', 'wp-mailinglist'); ?></label>
				<span class="howto"><?php esc_html_e('Enable this to send the user/subscriber a "Sorry to see you go..." email notification upon unsubscription. Edit the email in System Emails.', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
		<tr>
			<th><label for="unsubscribeconfirmation_Y"><?php esc_html_e('Unsubscribe Confirmation Screen', 'wp-mailinglist'); ?></label>
			<?php echo ( $Html -> help(__('This setting turns On/Off the unsubscribe confirmation screen which is a simple screen with checkboxes and a button so that subscribers can confirm their unsubscription. It is considered a good feature since it will prevent invalid unsubscribes such as when an unsubscribe link is clicked by accident inside the email.', 'wp-mailinglist'))); ?></th>
			<td>
				<label><input onclick="jQuery('#unsubscribeconfirmationNdiv').hide();" <?php echo ($this -> get_option('unsubscribeconfirmation') == "Y") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribeconfirmation" value="Y" id="unsubscribeconfirmation_Y" /> <?php esc_html_e('On', 'wp-mailinglist'); ?></label>
				<label><input onclick="jQuery('#unsubscribeconfirmationNdiv').show();" <?php echo ($this -> get_option('unsubscribeconfirmation') == "N") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribeconfirmation" value="N" id="unsubscribeconfirmation_N" /> <?php esc_html_e('Off', 'wp-mailinglist'); ?></label>
				<span class="howto"><?php esc_html_e('Let subscribers confirm their unsubscription. Turn this Off to unsubscribe immediately.', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
	</tbody>
</table>

<div class="newsletters_indented" id="unsubscribeconfirmationNdiv" style="display:<?php echo ($this -> get_option('unsubscribeconfirmation') == "N") ? 'block' : 'none'; ?>;">
	<table class="form-table">
		<tbody>
			<tr class="advanced-setting">
				<th><label for="unsubscriberemoveallsubscriptions_N"><?php esc_html_e('Remove All Subscriptions', 'wp-mailinglist'); ?></label>
				<?php echo ( $Html -> help(__('By default, a subscriber will be unsubscribed from the list(s) to which the newsletter was sent in the first place. If you turn this setting on, the subscriber will be automatically unsubscribed from all possible list subscriptions that they have.', 'wp-mailinglist'))); ?></th>
				<td>
					<label><input <?php echo ($this -> get_option('unsubscriberemoveallsubscriptions') == "Y") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscriberemoveallsubscriptions" value="Y" id="unsubscriberemoveallsubscriptions_Y" /> <?php esc_html_e('Yes', 'wp-mailinglist'); ?></label>
					<label><input <?php echo (!$this -> get_option('unsubscriberemoveallsubscriptions') || $this -> get_option('unsubscriberemoveallsubscriptions') == "N") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscriberemoveallsubscriptions" value="N" id="unsubscriberemoveallsubscriptions_N" /> <?php esc_html_e('No', 'wp-mailinglist'); ?></label>
					<span class="howto"><?php esc_html_e('With no confirmation, the subscriber is unsubscribed from only the list(s) sent to. This setting will remove all subscriptions if turned on.', 'wp-mailinglist'); ?></span>
				</td>
			</tr>
		</tbody>
	</table>
</div>

<table class="form-table">
	<tbody>
		<tr class="advanced-setting">
			<th><label for="unsubscribedelete_Y"><?php esc_html_e('Delete Subscriber on Unsubscribe', 'wp-mailinglist'); ?></label>
			<?php echo ( $Html -> help(__('A good setting to keep your subscribers database clean since it will delete a subscriber completely if the subscriber unsubscribes and has no subscriptions remaining.', 'wp-mailinglist'))); ?></th>
			<td>
				<label><input <?php echo ($this -> get_option('unsubscribedelete') == "Y") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribedelete" value="Y" id="unsubscribedelete_Y" /> <?php esc_html_e('Yes', 'wp-mailinglist'); ?></label>
				<label><input <?php echo ($this -> get_option('unsubscribedelete') == "N") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribedelete" value="N" id="unsubscribedelete_N" /> <?php esc_html_e('No', 'wp-mailinglist'); ?></label>
				<span class="howto"><?php esc_html_e('Turning this on will delete the subscriber record if no subscriptions remain on the record.', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
		<tr class="advanced-setting">
			<th><label for="unsubscribewpuserdelete_Y"><?php _e('Delete WordPress User on Subscriber Deletion', 'wp-mailinglist'); ?></label>
			<?php echo $Html -> help(__('Turning this on will delete the subscriber\'s WordPress user provided that the subscriber has one. This only happens once a subscriber is deleted by you.', 'wp-mailinglist')); ?></th>
			<td>
				<label><input <?php echo ($this -> get_option('unsubscribewpuserdelete') == "Y") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribewpuserdelete" value="Y" id="unsubscribewpuserdelete_Y" /> <?php _e('Yes', 'wp-mailinglist'); ?></label>
				<label><input <?php echo ($this -> get_option('unsubscribewpuserdelete') == "N") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribewpuserdelete" value="N" id="unsubscribewpuserdelete_N" /> <?php _e('No', 'wp-mailinglist'); ?></label>
				<span class="howto"><?php _e('Turning this on will delete the user in WordPress that belongs to the subscriber, once a subscriber is deleted by you.', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
		<tr class="advanced-setting">
            <th><label for="unsubscribewpuserdeletebyuser_Y"><?php _e('Delete WordPress User on Unsubscribe', 'wp-mailinglist'); ?></label>
                <?php echo $Html -> help(__('Turning this on will delete the user in WordPress that belongs to the subscriber (same email), once a subscriber unsubscribes on his own, whether by email or in the Manage Subscriptions page.', 'wp-mailinglist')); ?></th>
            <td>
                <label><input <?php echo ($this -> get_option('unsubscribewpuserdeletebyuser') == "Y") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribewpuserdeletebyuser" value="Y" id="unsubscribewpuserdeletebyuser_Y" /> <?php _e('Yes', 'wp-mailinglist'); ?></label>
                  <label><input <?php $val_unsubscribewpuserdeletebyuser_exists = !empty($this -> get_option('unsubscribewpuserdeletebyuser'));
                                    if ($val_unsubscribewpuserdeletebyuser_exists)
                                    {
                                        echo ($this -> get_option('unsubscribewpuserdeletebyuser') == "N") ? 'checked="checked"' : '';
                                    }
                                    else
                                    {
                                        echo 'checked="checked"';
                                    } ?> type="radio" name="unsubscribewpuserdeletebyuser" value="N" id="unsubscribewpuserdeletebyuser_N" /> <?php _e('No', 'wp-mailinglist'); ?></label>
                <span class="howto"><?php _e('Turning this on will delete the user in WordPress that belongs to the subscriber (same email), once a subscriber unsubscribes on his own, whether by email or in the Manage Subscriptions page.', 'wp-mailinglist'); ?></span>
            </td>
        </tr>
		<tr>
			<th><?php esc_html_e('Admin Notification on Unsubscribe', 'wp-mailinglist'); ?>
			<?php echo ( $Html -> help(sprintf(__('Turn this on to let the system send the administrator an email notification when a subscriber unsubscribes. The notification is sent to the "Administrator Email" setting under %s > Configuration > General > General Mail Settings.', 'wp-mailinglist'), $this -> name))); ?></th>
			<td>
				<?php $adminemailonunsubscription = $this -> get_option('adminemailonunsubscription'); ?>
				<label><input onclick="jQuery('#adminemailonunsubscribe_div').show();" <?php echo $check1 = ($adminemailonunsubscription == "Y") ? 'checked="checked"' : ''; ?> type="radio" name="adminemailonunsubscription" value="Y" /> <?php esc_html_e('On'); ?></label>
				<label><input onclick="jQuery('#adminemailonunsubscribe_div').hide();" <?php echo $check2 = ($adminemailonunsubscription == "N") ? 'checked="checked"' : ''; ?> type="radio" name="adminemailonunsubscription" value="N" /> <?php esc_html_e('Off'); ?></label>
				<span class="howto"><?php esc_html_e('Turn this on to receive a notification email on the administrator email each time someone unsubscribes.', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
	</tbody>
</table>

<div class="newsletters_indented" id="adminemailonunsubscribe_div" style="display:<?php echo (!empty($adminemailonunsubscription) && $adminemailonunsubscription == "Y") ? 'block' : 'none'; ?>;">
	<table class="form-table">
		<tbody>
			<tr class="advanced-setting">
				<th><label for="unsubscribeemails_single"><?php esc_html_e('Unsubscribe Emails', 'wp-mailinglist'); ?></label>
				<?php echo ( $Html -> help(__('When a subscriber is subscribed to multiple mailing lists and they unsubcribe and the "Admin Notification on Unsubscribe" setting above is turned on, the administrator is notified via email. This setting allows you to set whether you want the administrator to receive a single email for all the unsubscriptions or multiple emails (one for each mailing list).', 'wp-mailinglist'))); ?></th>
				<td>
					<label><input <?php echo (!empty($unsubscribeemails) && $unsubscribeemails == "single") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribeemails" value="single" id="unsubscribeemails_single" /> <?php esc_html_e('Single Email', 'wp-mailinglist'); ?></label>
					<label><input <?php echo (!empty($unsubscribeemails) && $unsubscribeemails == "multiple") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribeemails" value="multiple" id="unsubscribeemails_multiple" /> <?php esc_html_e('Multiple Emails (One for each list)', 'wp-mailinglist'); ?></label>
					<span class="howto"><?php esc_html_e('Should the system send a single or multiple unsubscribe emails when someone unsubscribes from multiple lists?', 'wp-mailinglist'); ?></span>
				</td>
			</tr>
		</tbody>
	</table>
</div>

<table class="form-table">
	<tbody>
		<tr>
			<th><label for="unsubscribecommentsY"><?php esc_html_e('Unsubscribe Comments Box', 'wp-mailinglist'); ?></label>
			<?php echo ( $Html -> help(__('Do you want to allow your subscribers to enter an optional message/comments in the process of unsubscribing? If you turn this on, the message/comments will be sent through to you in the unsubscribe notification and it will also be saved to the database for viewing later on.', 'wp-mailinglist'))); ?></th>
			<td>
				<label><input <?php echo ($this -> get_option('unsubscribecomments') == "Y") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribecomments" value="Y" id="unsubscribecommentsY" /> <?php esc_html_e('On', 'wp-mailinglist'); ?></label>
				<label><input <?php echo ($this -> get_option('unsubscribecomments') == "N") ? 'checked="checked"' : ''; ?> type="radio" name="unsubscribecomments" value="N" id="unsubscribecommentsN" /> <?php esc_html_e('Off', 'wp-mailinglist'); ?></label>
				<span class="howto"><?php esc_html_e('Turn this on to show a comment box on the unsubscribe confirmation page to allow users to post feedback.', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
		<tr>
			<th><label for="unsubscribe_redirect"><?php esc_html_e('Custom Unsubscribe Redirect', 'wp-mailinglist'); ?></label></th>
			<td>
				<label><input onclick="if (jQuery(this).is(':checked')) { jQuery('#unsubscribe_redirect_div').show(); } else { jQuery('#unsubscribe_redirect_div').hide(); }" <?php checked($unsubscribe_redirect, 1); ?> type="checkbox" name="unsubscribe_redirect" value="1" id="unsubscribe_redirect" /> <?php esc_html_e('Yes, redirect subscribers to a custom URL upon unsubscribe.', 'wp-mailinglist'); ?></label>
				<span class="howto"><?php esc_html_e('Tick/check this to specify a custom URL to redirect subscribers to after they unsubscribed.', 'wp-mailinglist'); ?></span>
			</td>
		</tr>
	</tbody>
</table>

<div class="newsletters_indented" id="unsubscribe_redirect_div" style="display:<?php echo (!empty($unsubscribe_redirect)) ? 'block' : 'none'; ?>;">
	<table class="form-table">
		<tbody>
			<tr>
				<th><label for="unsubscribe_redirect_url"><?php esc_html_e('Unsubscribe Redirect URL', 'wp-mailinglist'); ?></label></th>
				<td>
					<input type="text" class="widefat" name="unsubscribe_redirect_url" value="<?php echo esc_attr(wp_unslash($unsubscribe_redirect_url)); ?>" id="unsubscribe_redirect_url" />
					<span class="howto"><?php esc_html_e('Specify a full URL here to redirect subscribers to after they unsubscribe.', 'wp-mailinglist'); ?></span>
				</td>
			</tr>
		</tbody>
	</table>
</div>
