<?php
/**
 * This file fixes some issues generated by "Facebook Instant Articles & Google AMP Pages by PageFrog".
 *
 * We explained the issue in our blog: https://neliosoftware.com/blog/when-wordpress-freedom-kills-your-business/
 * And we asked for help here: https://wordpress.org/support/topic/your-plugin-generates-compatibility-issues/
 *
 * @package    Nelio_Content
 * @subpackage Nelio_Content/includes/compat
 * @author     David Aguilera <david.aguilera@neliosoftware.com>
 * @since      1.0.5
 */

namespace Nelio_Content\Compat\Page_Frog;

defined( 'ABSPATH' ) || exit;

/**
 * Callback to hook into Wordapress.
 *
 * @return void
 *
 * @since 1.0.5
 */
function pagefrog_fix_issues_with_post_page() {

	if ( ! is_admin() ) {
		return;
	}

	if ( ! function_exists( 'is_plugin_active' ) ) {
		return;
	}

	if ( ! is_plugin_active( 'pagefrog/pagefrog.php' ) ) {
		return;
	}

	$post_types = nelio_content_get_post_types( 'editor' );
	$screen     = get_current_screen();
	if ( empty( $screen ) || ! in_array( $screen->id, $post_types, true ) ) {
		return;
	}

	add_action( 'admin_head', __NAMESPACE__ . '\pagefrog_fix_global_css', 999 );
}
add_action( 'current_screen', __NAMESPACE__ . '\pagefrog_fix_issues_with_post_page' );

/**
 * Callback to revert the global CSS settings and applies them to only pagefrog's meta box.
 *
 * @return void
 *
 * @since 1.0.5
 */
function pagefrog_fix_global_css() {
	?>

	<style type="text/css">

		:before, :after, * {
			-webkit-box-sizing: initial;
			-moz-box-sizing: initial;
			box-sizing: initial;
		}

		#pagefrog-preview-meta-box :before,
		#pagefrog-preview-meta-box :after,
		#pagefrog-preview-meta-box * {
			-webkit-box-sizing: border-box;
			-moz-box-sizing: border-box;
			box-sizing: border-box;
		}

	</style>

	<?php
}
