/*
* Plugin Name Native Emoji
* Version 3.0
* Author Daniel Brandenburg
*/

tinymce.PluginManager.add('nep_native_emoji', function(editor, url) {
    
    'use strict';
    
    // Emojis List
    var nep_emoji_list = {
        // Emoji Frequently Used Codes
        'nep_frequently_used' : {
            'name' : nep_plugin_vars.nep_frequently_used,
            'codes' : nep_plugin_vars.nep_frequently_codes,
        },
        // Emoji Smileys & People Codes
        'nep_smileys_people' : {
            'name' : nep_plugin_vars.nep_smileys_people,
            'codes' : [
                {"id":"1f600", "class":"emoji", "code":"&#x1f600;"},
                {"id":"1f62c", "class":"emoji", "code":"&#x1f62c;"},
                {"id":"1f601", "class":"emoji", "code":"&#x1f601;"},
                {"id":"1f602", "class":"emoji", "code":"&#x1f602;"},
                {"id":"1f603", "class":"emoji", "code":"&#x1f603;"},
                {"id":"1f604", "class":"emoji", "code":"&#x1f604;"},
                {"id":"1f923", "class":"emoji", "code":"&#x1f923;"},
                {"id":"1f605", "class":"emoji", "code":"&#x1f605;"},
                {"id":"1f606", "class":"emoji", "code":"&#x1f606;"},
                {"id":"1f607", "class":"emoji", "code":"&#x1f607;"},
                {"id":"1f609", "class":"emoji", "code":"&#x1f609;"},
                {"id":"1f60a", "class":"emoji", "code":"&#x1f60a;"},
                {"id":"1f642", "class":"emoji", "code":"&#x1f642;"},
                {"id":"1f643", "class":"emoji", "code":"&#x1f643;"},
                {"id":"263a", "class":"emoji", "code":"&#x263a;"},
                {"id":"1f60b", "class":"emoji", "code":"&#x1f60b;"},
                {"id":"1f60c", "class":"emoji", "code":"&#x1f60c;"},
                {"id":"1f60d", "class":"emoji", "code":"&#x1f60d;"},
                {"id":"1f618", "class":"emoji", "code":"&#x1f618;"},
                {"id":"1f617", "class":"emoji", "code":"&#x1f617;"},
                {"id":"1f619", "class":"emoji", "code":"&#x1f619;"},
                {"id":"1f61a", "class":"emoji", "code":"&#x1f61a;"},
                {"id":"1f92a", "class":"emoji", "code":"&#x1f92a;"},
                {"id":"1f61c", "class":"emoji", "code":"&#x1f61c;"},
                {"id":"1f61d", "class":"emoji", "code":"&#x1f61d;"},
                {"id":"1f61b", "class":"emoji", "code":"&#x1f61b;"},
                {"id":"1f911", "class":"emoji", "code":"&#x1f911;"},
                {"id":"1f60e", "class":"emoji", "code":"&#x1f60e;"},
                {"id":"1f913", "class":"emoji", "code":"&#x1f913;"},
                {"id":"1f9d0", "class":"emoji", "code":"&#x1f9d0;"},
                {"id":"1f920", "class":"emoji", "code":"&#x1f920;"},
                {"id":"1f917", "class":"emoji", "code":"&#x1f917;"},
                {"id":"1f921", "class":"emoji", "code":"&#x1f921;"},
                {"id":"1f60f", "class":"emoji", "code":"&#x1f60f;"},
                {"id":"1f636", "class":"emoji", "code":"&#x1f636;"},
                {"id":"1f610", "class":"emoji", "code":"&#x1f610;"},
                {"id":"1f611", "class":"emoji", "code":"&#x1f611;"},
                {"id":"1f612", "class":"emoji", "code":"&#x1f612;"},
                {"id":"1f644", "class":"emoji", "code":"&#x1f644;"},
                {"id":"1f928", "class":"emoji", "code":"&#x1f928;"},
                {"id":"1f914", "class":"emoji", "code":"&#x1f914;"},
                {"id":"1f92b", "class":"emoji", "code":"&#x1f92b;"},
                {"id":"1f92d", "class":"emoji", "code":"&#x1f92d;"},
                {"id":"1f925", "class":"emoji", "code":"&#x1f925;"},
                {"id":"1f633", "class":"emoji", "code":"&#x1f633;"},
                {"id":"1f61e", "class":"emoji", "code":"&#x1f61e;"},
                {"id":"1f61f", "class":"emoji", "code":"&#x1f61f;"},
                {"id":"1f620", "class":"emoji", "code":"&#x1f620;"},
                {"id":"1f621", "class":"emoji", "code":"&#x1f621;"},
                {"id":"1f92c", "class":"emoji", "code":"&#x1f92c;"},
                {"id":"1f614", "class":"emoji", "code":"&#x1f614;"},
                {"id":"1f615", "class":"emoji", "code":"&#x1f615;"},
                {"id":"1f641", "class":"emoji", "code":"&#x1f641;"},
                {"id":"2639", "class":"emoji", "code":"&#x2639;"},
                {"id":"1f623", "class":"emoji", "code":"&#x1f623;"},
                {"id":"1f616", "class":"emoji", "code":"&#x1f616;"},
                {"id":"1f62b", "class":"emoji", "code":"&#x1f62b;"},
                {"id":"1f629", "class":"emoji", "code":"&#x1f629;"},
                {"id":"1f624", "class":"emoji", "code":"&#x1f624;"},
                {"id":"1f62e", "class":"emoji", "code":"&#x1f62e;"},
                {"id":"1f631", "class":"emoji", "code":"&#x1f631;"},
                {"id":"1f628", "class":"emoji", "code":"&#x1f628;"},
                {"id":"1f630", "class":"emoji", "code":"&#x1f630;"},
                {"id":"1f62f", "class":"emoji", "code":"&#x1f62f;"},
                {"id":"1f626", "class":"emoji", "code":"&#x1f626;"},
                {"id":"1f627", "class":"emoji", "code":"&#x1f627;"},
                {"id":"1f622", "class":"emoji", "code":"&#x1f622;"},
                {"id":"1f625", "class":"emoji", "code":"&#x1f625;"},
                {"id":"1f62a", "class":"emoji", "code":"&#x1f62a;"},
                {"id":"1f924", "class":"emoji", "code":"&#x1f924;"},
                {"id":"1f613", "class":"emoji", "code":"&#x1f613;"},
                {"id":"1f62d", "class":"emoji", "code":"&#x1f62d;"},
                {"id":"1f929", "class":"emoji", "code":"&#x1f929;"},
                {"id":"1f635", "class":"emoji", "code":"&#x1f635;"},
                {"id":"1f632", "class":"emoji", "code":"&#x1f632;"},
                {"id":"1f92f", "class":"emoji", "code":"&#x1f92f;"},
                {"id":"1f910", "class":"emoji", "code":"&#x1f910;"},
                {"id":"1f637", "class":"emoji", "code":"&#x1f637;"},
                {"id":"1f915", "class":"emoji", "code":"&#x1f915;"},
                {"id":"1f912", "class":"emoji", "code":"&#x1f912;"},
                {"id":"1f92e", "class":"emoji", "code":"&#x1f92e;"},
                {"id":"1f922", "class":"emoji", "code":"&#x1f922;"},
                {"id":"1f927", "class":"emoji", "code":"&#x1f927;"},
                {"id":"1f634", "class":"emoji", "code":"&#x1f634;"},
                {"id":"1f4a4", "class":"emoji", "code":"&#x1f4a4;"},
                {"id":"1f608", "class":"emoji", "code":"&#x1f608;"},
                {"id":"1f47f", "class":"emoji", "code":"&#x1f47f;"},
                {"id":"1f479", "class":"emoji", "code":"&#x1f479;"},
                {"id":"1f47a", "class":"emoji", "code":"&#x1f47a;"},
                {"id":"1f4a9", "class":"emoji", "code":"&#x1f4a9;"},
                {"id":"1f47b", "class":"emoji", "code":"&#x1f47b;"},
                {"id":"1f480", "class":"emoji", "code":"&#x1f480;"},
                {"id":"2620", "class":"emoji", "code":"&#x2620;"},
                {"id":"1f47d", "class":"emoji", "code":"&#x1f47d;"},
                {"id":"1f916", "class":"emoji", "code":"&#x1f916;"},
                {"id":"1f383", "class":"emoji", "code":"&#x1f383;"},
                {"id":"1f63a", "class":"emoji", "code":"&#x1f63a;"},
                {"id":"1f638", "class":"emoji", "code":"&#x1f638;"},
                {"id":"1f639", "class":"emoji", "code":"&#x1f639;"},
                {"id":"1f63b", "class":"emoji", "code":"&#x1f63b;"},
                {"id":"1f63c", "class":"emoji", "code":"&#x1f63c;"},
                {"id":"1f63d", "class":"emoji", "code":"&#x1f63d;"},
                {"id":"1f640", "class":"emoji", "code":"&#x1f640;"},
                {"id":"1f63f", "class":"emoji", "code":"&#x1f63f;"},
                {"id":"1f63e", "class":"emoji", "code":"&#x1f63e;"},
                {"id":"1f450", "class":"emoji_yellow nep_tone", "code":"&#x1f450;"},
                {"id":"1f932", "class":"emoji_yellow nep_tone", "code":"&#x1f932;"},
                {"id":"1f64c", "class":"emoji_yellow nep_tone", "code":"&#x1f64c;"},
                {"id":"1f44f", "class":"emoji_yellow nep_tone", "code":"&#x1f44f;"},
                {"id":"1f64f", "class":"emoji_yellow nep_tone", "code":"&#x1f64f;"},
                {"id":"1f450-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f450&#x1f3fb;"},
                {"id":"1f932-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f932&#x1f3fb;"},
                {"id":"1f64c-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f64c&#x1f3fb;"},
                {"id":"1f44f-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f44f&#x1f3fb;"},
                {"id":"1f64f-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f64f&#x1f3fb;"},
                {"id":"1f450-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f450&#x1f3fc;"},
                {"id":"1f932-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f932&#x1f3fc;"},
                {"id":"1f64c-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f64c&#x1f3fc;"},
                {"id":"1f44f-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f44f&#x1f3fc;"},
                {"id":"1f64f-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f64f&#x1f3fc;"},
                {"id":"1f450-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f450&#x1f3fd;"},
                {"id":"1f932-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f932&#x1f3fd;"},
                {"id":"1f64c-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f64c&#x1f3fd;"},
                {"id":"1f44f-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f44f&#x1f3fd;"},
                {"id":"1f64f-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f64f&#x1f3fd;"},
                {"id":"1f450-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f450&#x1f3fe;"},
                {"id":"1f932-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f932&#x1f3fe;"},
                {"id":"1f64c-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f64c&#x1f3fe;"},
                {"id":"1f44f-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f44f&#x1f3fe;"},
                {"id":"1f64f-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f64f&#x1f3fe;"},
                {"id":"1f450-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f450&#x1f3ff;"},
                {"id":"1f932-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f932&#x1f3ff;"},
                {"id":"1f64c-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f64c&#x1f3ff;"},
                {"id":"1f44f-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f44f&#x1f3ff;"},
                {"id":"1f64f-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f64f&#x1f3ff;"},
                {"id":"1f91d", "class":"emoji", "code":"&#x1f91d;"},
                {"id":"1f44d", "class":"emoji_yellow nep_tone", "code":"&#x1f44d;"},
                {"id":"1f44e", "class":"emoji_yellow nep_tone", "code":"&#x1f44e;"},
                {"id":"1f44a", "class":"emoji_yellow nep_tone", "code":"&#x1f44a;"},
                {"id":"270a", "class":"emoji_yellow nep_tone", "code":"&#x270a;"},
                {"id":"1f91b", "class":"emoji_yellow nep_tone", "code":"&#x1f91b;"},
                {"id":"1f91c", "class":"emoji_yellow nep_tone", "code":"&#x1f91c;"},
                {"id":"1f91e", "class":"emoji_yellow nep_tone", "code":"&#x1f91e;"},
                {"id":"270c", "class":"emoji_yellow nep_tone", "code":"&#x270c;"},
                {"id":"1f918", "class":"emoji_yellow nep_tone", "code":"&#x1f918;"},
                {"id":"1f91f", "class":"emoji_yellow nep_tone", "code":"&#x1f91f;"},
                {"id":"1f44c", "class":"emoji_yellow nep_tone", "code":"&#x1f44c;"},
                {"id":"1f448", "class":"emoji_yellow nep_tone", "code":"&#x1f448;"},
                {"id":"1f449", "class":"emoji_yellow nep_tone", "code":"&#x1f449;"},
                {"id":"1f446", "class":"emoji_yellow nep_tone", "code":"&#x1f446;"},
                {"id":"1f447", "class":"emoji_yellow nep_tone", "code":"&#x1f447;"},
                {"id":"261d", "class":"emoji_yellow nep_tone", "code":"&#x261d;"},
                {"id":"270b", "class":"emoji_yellow nep_tone", "code":"&#x270b;"},
                {"id":"1f91a", "class":"emoji_yellow nep_tone", "code":"&#x1f91a;"},
                {"id":"1f590", "class":"emoji_yellow nep_tone", "code":"&#x1f590;"},
                {"id":"1f596", "class":"emoji_yellow nep_tone", "code":"&#x1f596;"},
                {"id":"1f44b", "class":"emoji_yellow nep_tone", "code":"&#x1f44b;"},
                {"id":"1f919", "class":"emoji_yellow nep_tone", "code":"&#x1f919;"},
                {"id":"1f4aa", "class":"emoji_yellow nep_tone", "code":"&#x1f4aa;"},
                {"id":"1f595", "class":"emoji_yellow nep_tone", "code":"&#x1f595;"},
                {"id":"270d", "class":"emoji_yellow nep_tone", "code":"&#x270d;"},
                {"id":"1f933", "class":"emoji_yellow nep_tone", "code":"&#x1f933;"},
                {"id":"1f485", "class":"emoji_yellow nep_tone", "code":"&#x1f485;"},
                {"id":"1f44d-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f44d&#x1f3fb;"},
                {"id":"1f44e-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f44e&#x1f3fb;"},
                {"id":"1f44a-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f44a&#x1f3fb;"},
                {"id":"270a-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x270a&#x1f3fb;"},
                {"id":"1f91b-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f91b&#x1f3fb;"},
                {"id":"1f91c-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f91c&#x1f3fb;"},
                {"id":"1f91e-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f91e&#x1f3fb;"},
                {"id":"270c-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x270c&#x1f3fb;"},
                {"id":"1f918-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f918&#x1f3fb;"},
                {"id":"1f91f-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f91f&#x1f3fb;"},
                {"id":"1f44c-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f44c&#x1f3fb;"},
                {"id":"1f448-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f448&#x1f3fb;"},
                {"id":"1f449-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f449&#x1f3fb;"},
                {"id":"1f446-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f446&#x1f3fb;"},
                {"id":"1f447-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f447&#x1f3fb;"},
                {"id":"261d-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x261d&#x1f3fb;"},
                {"id":"270b-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x270b&#x1f3fb;"},
                {"id":"1f91a-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f91a&#x1f3fb;"},
                {"id":"1f590-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f590&#x1f3fb;"},
                {"id":"1f596-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f596&#x1f3fb;"},
                {"id":"1f44b-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f44b&#x1f3fb;"},
                {"id":"1f919-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f919&#x1f3fb;"},
                {"id":"1f4aa-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f4aa&#x1f3fb;"},
                {"id":"1f595-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f595&#x1f3fb;"},
                {"id":"270d-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x270d&#x1f3fb;"},
                {"id":"1f933-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f933&#x1f3fb;"},
                {"id":"1f485-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f485&#x1f3fb;"},
                {"id":"1f44d-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f44d&#x1f3fc;"},
                {"id":"1f44e-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f44e&#x1f3fc;"},
                {"id":"1f44a-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f44a&#x1f3fc;"},
                {"id":"270a-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x270a&#x1f3fc;"},
                {"id":"1f91b-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f91b&#x1f3fc;"},
                {"id":"1f91c-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f91c&#x1f3fc;"},
                {"id":"1f91e-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f91e&#x1f3fc;"},
                {"id":"270c-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x270c&#x1f3fc;"},
                {"id":"1f918-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f918&#x1f3fc;"},
                {"id":"1f91f-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f91f&#x1f3fc;"},
                {"id":"1f44c-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f44c&#x1f3fc;"},
                {"id":"1f448-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f448&#x1f3fc;"},
                {"id":"1f449-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f449&#x1f3fc;"},
                {"id":"1f446-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f446&#x1f3fc;"},
                {"id":"1f447-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f447&#x1f3fc;"},
                {"id":"261d-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x261d&#x1f3fc;"},
                {"id":"270b-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x270b&#x1f3fc;"},
                {"id":"1f91a-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f91a&#x1f3fc;"},
                {"id":"1f590-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f590&#x1f3fc;"},
                {"id":"1f596-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f596&#x1f3fc;"},
                {"id":"1f44b-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f44b&#x1f3fc;"},
                {"id":"1f919-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f919&#x1f3fc;"},
                {"id":"1f4aa-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f4aa&#x1f3fc;"},
                {"id":"1f595-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f595&#x1f3fc;"},
                {"id":"270d-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x270d&#x1f3fc;"},
                {"id":"1f933-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f933&#x1f3fc;"},
                {"id":"1f485-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f485&#x1f3fc;"},
                {"id":"1f44d-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f44d&#x1f3fd;"},
                {"id":"1f44e-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f44e&#x1f3fd;"},
                {"id":"1f44a-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f44a&#x1f3fd;"},
                {"id":"270a-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x270a&#x1f3fd;"},
                {"id":"1f91b-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f91b&#x1f3fd;"},
                {"id":"1f91c-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f91c&#x1f3fd;"},
                {"id":"1f91e-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f91e&#x1f3fd;"},
                {"id":"270c-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x270c&#x1f3fd;"},
                {"id":"1f918-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f918&#x1f3fd;"},
                {"id":"1f91f-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f91f&#x1f3fd;"},
                {"id":"1f44c-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f44c&#x1f3fd;"},
                {"id":"1f448-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f448&#x1f3fd;"},
                {"id":"1f449-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f449&#x1f3fd;"},
                {"id":"1f446-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f446&#x1f3fd;"},
                {"id":"1f447-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f447&#x1f3fd;"},
                {"id":"261d-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x261d&#x1f3fd;"},
                {"id":"270b-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x270b&#x1f3fd;"},
                {"id":"1f91a-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f91a&#x1f3fd;"},
                {"id":"1f590-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f590&#x1f3fd;"},
                {"id":"1f596-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f596&#x1f3fd;"},
                {"id":"1f44b-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f44b&#x1f3fd;"},
                {"id":"1f919-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f919&#x1f3fd;"},
                {"id":"1f4aa-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f4aa&#x1f3fd;"},
                {"id":"1f595-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f595&#x1f3fd;"},
                {"id":"270d-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x270d&#x1f3fd;"},
                {"id":"1f933-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f933&#x1f3fd;"},
                {"id":"1f485-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f485&#x1f3fd;"},
                {"id":"1f44d-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f44d&#x1f3fe;"},
                {"id":"1f44e-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f44e&#x1f3fe;"},
                {"id":"1f44a-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f44a&#x1f3fe;"},
                {"id":"270a-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x270a&#x1f3fe;"},
                {"id":"1f91b-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f91b&#x1f3fe;"},
                {"id":"1f91c-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f91c&#x1f3fe;"},
                {"id":"1f91e-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f91e&#x1f3fe;"},
                {"id":"270c-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x270c&#x1f3fe;"},
                {"id":"1f918-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f918&#x1f3fe;"},
                {"id":"1f91f-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f91f&#x1f3fe;"},
                {"id":"1f44c-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f44c&#x1f3fe;"},
                {"id":"1f448-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f448&#x1f3fe;"},
                {"id":"1f449-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f449&#x1f3fe;"},
                {"id":"1f446-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f446&#x1f3fe;"},
                {"id":"1f447-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f447&#x1f3fe;"},
                {"id":"261d-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x261d&#x1f3fe;"},
                {"id":"270b-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x270b&#x1f3fe;"},
                {"id":"1f91a-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f91a&#x1f3fe;"},
                {"id":"1f590-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f590&#x1f3fe;"},
                {"id":"1f596-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f596&#x1f3fe;"},
                {"id":"1f44b-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f44b&#x1f3fe;"},
                {"id":"1f919-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f919&#x1f3fe;"},
                {"id":"1f4aa-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f4aa&#x1f3fe;"},
                {"id":"1f595-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f595&#x1f3fe;"},
                {"id":"270d-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x270d&#x1f3fe;"},
                {"id":"1f933-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f933&#x1f3fe;"},
                {"id":"1f485-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f485&#x1f3fe;"},
                {"id":"1f44d-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f44d&#x1f3ff;"},
                {"id":"1f44e-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f44e&#x1f3ff;"},
                {"id":"1f44a-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f44a&#x1f3ff;"},
                {"id":"270a-1f3ff", "class":"emoji_black nep_tone", "code":"&#x270a&#x1f3ff;"},
                {"id":"1f91b-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f91b&#x1f3ff;"},
                {"id":"1f91c-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f91c&#x1f3ff;"},
                {"id":"1f91e-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f91e&#x1f3ff;"},
                {"id":"270c-1f3ff", "class":"emoji_black nep_tone", "code":"&#x270c&#x1f3ff;"},
                {"id":"1f918-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f918&#x1f3ff;"},
                {"id":"1f91f-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f91f&#x1f3ff;"},
                {"id":"1f44c-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f44c&#x1f3ff;"},
                {"id":"1f448-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f448&#x1f3ff;"},
                {"id":"1f449-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f449&#x1f3ff;"},
                {"id":"1f446-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f446&#x1f3ff;"},
                {"id":"1f447-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f447&#x1f3ff;"},
                {"id":"261d-1f3ff", "class":"emoji_black nep_tone", "code":"&#x261d&#x1f3ff;"},
                {"id":"270b-1f3ff", "class":"emoji_black nep_tone", "code":"&#x270b&#x1f3ff;"},
                {"id":"1f91a-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f91a&#x1f3ff;"},
                {"id":"1f590-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f590&#x1f3ff;"},
                {"id":"1f596-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f596&#x1f3ff;"},
                {"id":"1f44b-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f44b&#x1f3ff;"},
                {"id":"1f919-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f919&#x1f3ff;"},
                {"id":"1f4aa-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f4aa&#x1f3ff;"},
                {"id":"1f595-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f595&#x1f3ff;"},
                {"id":"270d-1f3ff", "class":"emoji_black nep_tone", "code":"&#x270d&#x1f3ff;"},
                {"id":"1f933-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f933&#x1f3ff;"},
                {"id":"1f485-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f485&#x1f3ff;"},
                {"id":"1f444", "class":"emoji", "code":"&#x1f444;"},
                {"id":"1f445", "class":"emoji", "code":"&#x1f445;"},
                {"id":"1f442", "class":"emoji_yellow nep_tone", "code":"&#x1f442;"},
                {"id":"1f443", "class":"emoji_yellow nep_tone", "code":"&#x1f443;"},
                {"id":"1f442-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f442&#x1f3fb;"},
                {"id":"1f443-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f443&#x1f3fb;"},
                {"id":"1f442-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f442&#x1f3fc;"},
                {"id":"1f443-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f443&#x1f3fc;"},
                {"id":"1f442-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f442&#x1f3fd;"},
                {"id":"1f443-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f443&#x1f3fd;"},
                {"id":"1f442-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f442&#x1f3fe;"},
                {"id":"1f443-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f443&#x1f3fe;"},
                {"id":"1f442-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f442&#x1f3ff;"},
                {"id":"1f443-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f443&#x1f3ff;"},
                {"id":"1f441", "class":"emoji", "code":"&#x1f441;"},
                {"id":"1f440", "class":"emoji", "code":"&#x1f440;"},
                {"id":"1f9e0", "class":"emoji", "code":"&#x1f9e0;"},
                {"id":"1f464", "class":"emoji", "code":"&#x1f464;"},
                {"id":"1f465", "class":"emoji", "code":"&#x1f465;"},
                {"id":"1f5e3", "class":"emoji", "code":"&#x1f5e3;"},
                {"id":"1f476", "class":"emoji_yellow nep_tone", "code":"&#x1f476;"},
                {"id":"1f9d2", "class":"emoji_yellow nep_tone", "code":"&#x1f9d2;"},
                {"id":"1f466", "class":"emoji_yellow nep_tone", "code":"&#x1f466;"},
                {"id":"1f467", "class":"emoji_yellow nep_tone", "code":"&#x1f467;"},
                {"id":"1f9d1", "class":"emoji_yellow nep_tone", "code":"&#x1f9d1;"},
                {"id":"1f468", "class":"emoji_yellow nep_tone", "code":"&#x1f468;"},
                {"id":"1f9d4", "class":"emoji_yellow nep_tone", "code":"&#x1f9d4;"},
                {"id":"1f471", "class":"emoji_yellow nep_tone", "code":"&#x1f471;"},
                {"id":"1f469", "class":"emoji_yellow nep_tone", "code":"&#x1f469;"},
                {"id":"1f471-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f471&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d3", "class":"emoji_yellow nep_tone", "code":"&#x1f9d3;"},
                {"id":"1f474", "class":"emoji_yellow nep_tone", "code":"&#x1f474;"},
                {"id":"1f475", "class":"emoji_yellow nep_tone", "code":"&#x1f475;"},
                {"id":"1f472", "class":"emoji_yellow nep_tone", "code":"&#x1f472;"},
                {"id":"1f473-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f473&#x200d&#x2640&#xfe0f;"},
                {"id":"1f473", "class":"emoji_yellow nep_tone", "code":"&#x1f473;"},
                {"id":"1f9d5", "class":"emoji_yellow nep_tone", "code":"&#x1f9d5;"},
                {"id":"1f46e-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f46e&#x200d&#x2640&#xfe0f;"},
                {"id":"1f46e", "class":"emoji_yellow nep_tone", "code":"&#x1f46e;"},
                {"id":"1f469-200d-1f692", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f692;"},
                {"id":"1f468-200d-1f692", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f692;"},
                {"id":"1f477-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f477&#x200d&#x2640&#xfe0f;"},
                {"id":"1f477", "class":"emoji_yellow nep_tone", "code":"&#x1f477;"},
                {"id":"1f469-200d-1f3ed", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f3ed;"},
                {"id":"1f468-200d-1f3ed", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f3ed;"},
                {"id":"1f469-200d-1f527", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f527;"},
                {"id":"1f468-200d-1f527", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f527;"},
                {"id":"1f469-200d-1f33e", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f33e;"},
                {"id":"1f468-200d-1f33e", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f33e;"},
                {"id":"1f469-200d-1f373", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f373;"},
                {"id":"1f468-200d-1f373", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f373;"},
                {"id":"1f476-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f476&#x1f3fb;"},
                {"id":"1f9d2-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f9d2&#x1f3fb;"},
                {"id":"1f466-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f466&#x1f3fb;"},
                {"id":"1f467-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f467&#x1f3fb;"},
                {"id":"1f9d1-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f9d1&#x1f3fb;"},
                {"id":"1f468-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb;"},
                {"id":"1f9d4-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f9d4&#x1f3fb;"},
                {"id":"1f471-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f471&#x1f3fb;"},
                {"id":"1f469-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb;"},
                {"id":"1f471-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f471&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d3-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f9d3&#x1f3fb;"},
                {"id":"1f474-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f474&#x1f3fb;"},
                {"id":"1f475-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f475&#x1f3fb;"},
                {"id":"1f472-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f472&#x1f3fb;"},
                {"id":"1f473-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f473&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f473-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f473&#x1f3fb;"},
                {"id":"1f9d5-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f9d5&#x1f3fb;"},
                {"id":"1f46e-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f46e&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f46e-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f46e&#x1f3fb;"},
                {"id":"1f469-1f3fb-200d-1f692", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f692;"},
                {"id":"1f468-1f3fb-200d-1f692", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f692;"},
                {"id":"1f477-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f477&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f477-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f477&#x1f3fb;"},
                {"id":"1f469-1f3fb-200d-1f3ed", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f3ed;"},
                {"id":"1f468-1f3fb-200d-1f3ed", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f3ed;"},
                {"id":"1f469-1f3fb-200d-1f527", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f527;"},
                {"id":"1f468-1f3fb-200d-1f527", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f527;"},
                {"id":"1f469-1f3fb-200d-1f33e", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f33e;"},
                {"id":"1f468-1f3fb-200d-1f33e", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f33e;"},
                {"id":"1f469-1f3fb-200d-1f373", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f373;"},
                {"id":"1f468-1f3fb-200d-1f373", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f373;"},
                {"id":"1f476-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f476&#x1f3fc;"},
                {"id":"1f9d2-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f9d2&#x1f3fc;"},
                {"id":"1f466-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f466&#x1f3fc;"},
                {"id":"1f467-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f467&#x1f3fc;"},
                {"id":"1f9d1-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f9d1&#x1f3fc;"},
                {"id":"1f468-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc;"},
                {"id":"1f9d4-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f9d4&#x1f3fc;"},
                {"id":"1f471-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f471&#x1f3fc;"},
                {"id":"1f469-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc;"},
                {"id":"1f471-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f471&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d3-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f9d3&#x1f3fc;"},
                {"id":"1f474-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f474&#x1f3fc;"},
                {"id":"1f475-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f475&#x1f3fc;"},
                {"id":"1f472-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f472&#x1f3fc;"},
                {"id":"1f473-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f473&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f473-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f473&#x1f3fc;"},
                {"id":"1f9d5-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f9d5&#x1f3fc;"},
                {"id":"1f46e-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f46e&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f46e-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f46e&#x1f3fc;"},
                {"id":"1f469-1f3fc-200d-1f692", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f692;"},
                {"id":"1f468-1f3fc-200d-1f692", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f692;"},
                {"id":"1f477-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f477&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f477-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f477&#x1f3fc;"},
                {"id":"1f469-1f3fc-200d-1f3ed", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f3ed;"},
                {"id":"1f468-1f3fc-200d-1f3ed", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f3ed;"},
                {"id":"1f469-1f3fc-200d-1f527", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f527;"},
                {"id":"1f468-1f3fc-200d-1f527", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f527;"},
                {"id":"1f469-1f3fc-200d-1f33e", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f33e;"},
                {"id":"1f468-1f3fc-200d-1f33e", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f33e;"},
                {"id":"1f469-1f3fc-200d-1f373", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f373;"},
                {"id":"1f468-1f3fc-200d-1f373", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f373;"},
                {"id":"1f476-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f476&#x1f3fd;"},
                {"id":"1f9d2-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d2&#x1f3fd;"},
                {"id":"1f466-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f466&#x1f3fd;"},
                {"id":"1f467-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f467&#x1f3fd;"},
                {"id":"1f9d1-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d1&#x1f3fd;"},
                {"id":"1f468-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd;"},
                {"id":"1f9d4-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d4&#x1f3fd;"},
                {"id":"1f471-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f471&#x1f3fd;"},
                {"id":"1f469-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd;"},
                {"id":"1f471-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f471&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d3-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d3&#x1f3fd;"},
                {"id":"1f474-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f474&#x1f3fd;"},
                {"id":"1f475-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f475&#x1f3fd;"},
                {"id":"1f472-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f472&#x1f3fd;"},
                {"id":"1f473-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f473&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f473-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f473&#x1f3fd;"},
                {"id":"1f9d5-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d5&#x1f3fd;"},
                {"id":"1f46e-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f46e&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f46e-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f46e&#x1f3fd;"},
                {"id":"1f469-1f3fd-200d-1f692", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f692;"},
                {"id":"1f468-1f3fd-200d-1f692", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f692;"},
                {"id":"1f477-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f477&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f477-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f477&#x1f3fd;"},
                {"id":"1f469-1f3fd-200d-1f3ed", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f3ed;"},
                {"id":"1f468-1f3fd-200d-1f3ed", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f3ed;"},
                {"id":"1f469-1f3fd-200d-1f527", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f527;"},
                {"id":"1f468-1f3fd-200d-1f527", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f527;"},
                {"id":"1f469-1f3fd-200d-1f33e", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f33e;"},
                {"id":"1f468-1f3fd-200d-1f33e", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f33e;"},
                {"id":"1f469-1f3fd-200d-1f373", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f373;"},
                {"id":"1f468-1f3fd-200d-1f373", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f373;"},
                {"id":"1f476-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f476&#x1f3fe;"},
                {"id":"1f9d2-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d2&#x1f3fe;"},
                {"id":"1f466-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f466&#x1f3fe;"},
                {"id":"1f467-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f467&#x1f3fe;"},
                {"id":"1f9d1-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d1&#x1f3fe;"},
                {"id":"1f468-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe;"},
                {"id":"1f9d4-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d4&#x1f3fe;"},
                {"id":"1f471-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f471&#x1f3fe;"},
                {"id":"1f469-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe;"},
                {"id":"1f471-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f471&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d3-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d3&#x1f3fe;"},
                {"id":"1f474-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f474&#x1f3fe;"},
                {"id":"1f475-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f475&#x1f3fe;"},
                {"id":"1f472-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f472&#x1f3fe;"},
                {"id":"1f473-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f473&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f473-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f473&#x1f3fe;"},
                {"id":"1f9d5-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d5&#x1f3fe;"},
                {"id":"1f46e-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f46e&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f46e-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f46e&#x1f3fe;"},
                {"id":"1f469-1f3fe-200d-1f692", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f692;"},
                {"id":"1f468-1f3fe-200d-1f692", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f692;"},
                {"id":"1f477-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f477&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f477-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f477&#x1f3fe;"},
                {"id":"1f469-1f3fe-200d-1f3ed", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f3ed;"},
                {"id":"1f468-1f3fe-200d-1f3ed", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f3ed;"},
                {"id":"1f469-1f3fe-200d-1f527", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f527;"},
                {"id":"1f468-1f3fe-200d-1f527", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f527;"},
                {"id":"1f469-1f3fe-200d-1f33e", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f33e;"},
                {"id":"1f468-1f3fe-200d-1f33e", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f33e;"},
                {"id":"1f469-1f3fe-200d-1f373", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f373;"},
                {"id":"1f468-1f3fe-200d-1f373", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f373;"},
                {"id":"1f476-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f476&#x1f3ff;"},
                {"id":"1f9d2-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f9d2&#x1f3ff;"},
                {"id":"1f466-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f466&#x1f3ff;"},
                {"id":"1f467-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f467&#x1f3ff;"},
                {"id":"1f9d1-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f9d1&#x1f3ff;"},
                {"id":"1f468-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff;"},
                {"id":"1f9d4-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f9d4&#x1f3ff;"},
                {"id":"1f471-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f471&#x1f3ff;"},
                {"id":"1f469-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff;"},
                {"id":"1f471-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f471&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d3-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f9d3&#x1f3ff;"},
                {"id":"1f474-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f474&#x1f3ff;"},
                {"id":"1f475-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f475&#x1f3ff;"},
                {"id":"1f472-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f472&#x1f3ff;"},
                {"id":"1f473-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f473&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f473-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f473&#x1f3ff;"},
                {"id":"1f9d5-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f9d5&#x1f3ff;"},
                {"id":"1f46e-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f46e&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f46e-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f46e&#x1f3ff;"},
                {"id":"1f469-1f3ff-200d-1f692", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f692;"},
                {"id":"1f468-1f3ff-200d-1f692", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f692;"},
                {"id":"1f477-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f477&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f477-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f477&#x1f3ff;"},
                {"id":"1f469-1f3ff-200d-1f3ed", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f3ed;"},
                {"id":"1f468-1f3ff-200d-1f3ed", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f3ed;"},
                {"id":"1f469-1f3ff-200d-1f527", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f527;"},
                {"id":"1f468-1f3ff-200d-1f527", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f527;"},
                {"id":"1f469-1f3ff-200d-1f33e", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f33e;"},
                {"id":"1f468-1f3ff-200d-1f33e", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f33e;"},
                {"id":"1f469-1f3ff-200d-1f373", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f373;"},
                {"id":"1f468-1f3ff-200d-1f373", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f373;"},
                {"id":"1f469-200d-1f3a4", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f3a4;"},
                {"id":"1f468-200d-1f3a4", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f3a4;"},
                {"id":"1f469-200d-1f3a8", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f3a8;"},
                {"id":"1f468-200d-1f3a8", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f3a8;"},
                {"id":"1f469-200d-1f3eb", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f3eb;"},
                {"id":"1f468-200d-1f3eb", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f3eb;"},
                {"id":"1f469-200d-1f393", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f393;"},
                {"id":"1f468-200d-1f393", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f393;"},
                {"id":"1f469-200d-1f4bc", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f4bc;"},
                {"id":"1f468-200d-1f4bc", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f4bc;"},
                {"id":"1f469-200d-1f4bb", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f4bb;"},
                {"id":"1f468-200d-1f4bb", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f4bb;"},
                {"id":"1f469-200d-1f52c", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f52c;"},
                {"id":"1f468-200d-1f52c", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f52c;"},
                {"id":"1f469-200d-1f680", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x1f680;"},
                {"id":"1f468-200d-1f680", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x1f680;"},
                {"id":"1f469-200d-2695-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x2695&#xfe0f;"},
                {"id":"1f468-200d-2695-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x2695&#xfe0f;"},
                {"id":"1f469-200d-2696-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x2696&#xfe0f;"},
                {"id":"1f468-200d-2696-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x2696&#xfe0f;"},
                {"id":"1f469-200d-2708-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f469&#x200d&#x2708&#xfe0f;"},
                {"id":"1f468-200d-2708-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f468&#x200d&#x2708&#xfe0f;"},
                {"id":"1f482-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f482&#x200d&#x2640&#xfe0f;"},
                {"id":"1f482", "class":"emoji_yellow nep_tone", "code":"&#x1f482;"},
                {"id":"1f575-fe0f-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f575&#xfe0f&#x200d&#x2640&#xfe0f;"},
                {"id":"1f575", "class":"emoji_yellow nep_tone", "code":"&#x1f575;"},
                {"id":"1f385", "class":"emoji_yellow nep_tone", "code":"&#x1f385;"},
                {"id":"1f936", "class":"emoji_yellow nep_tone", "code":"&#x1f936;"},
                {"id":"1f47c", "class":"emoji_yellow nep_tone", "code":"&#x1f47c;"},
                {"id":"1f478", "class":"emoji_yellow nep_tone", "code":"&#x1f478;"},
                {"id":"1f934", "class":"emoji_yellow nep_tone", "code":"&#x1f934;"},
                {"id":"1f469-1f3fb-200d-1f3a4", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f3a4;"},
                {"id":"1f468-1f3fb-200d-1f3a4", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f3a4;"},
                {"id":"1f469-1f3fb-200d-1f3a8", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f3a8;"},
                {"id":"1f468-1f3fb-200d-1f3a8", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f3a8;"},
                {"id":"1f469-1f3fb-200d-1f3eb", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f3eb;"},
                {"id":"1f468-1f3fb-200d-1f3eb", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f3eb;"},
                {"id":"1f469-1f3fb-200d-1f393", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f393;"},
                {"id":"1f468-1f3fb-200d-1f393", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f393;"},
                {"id":"1f469-1f3fb-200d-1f4bc", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f4bc;"},
                {"id":"1f468-1f3fb-200d-1f4bc", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f4bc;"},
                {"id":"1f469-1f3fb-200d-1f4bb", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f4bb;"},
                {"id":"1f468-1f3fb-200d-1f4bb", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f4bb;"},
                {"id":"1f469-1f3fb-200d-1f52c", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f52c;"},
                {"id":"1f468-1f3fb-200d-1f52c", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f52c;"},
                {"id":"1f469-1f3fb-200d-1f680", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x1f680;"},
                {"id":"1f468-1f3fb-200d-1f680", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x1f680;"},
                {"id":"1f469-1f3fb-200d-2695-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x2695&#xfe0f;"},
                {"id":"1f468-1f3fb-200d-2695-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x2695&#xfe0f;"},
                {"id":"1f469-1f3fb-200d-2696-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x2696&#xfe0f;"},
                {"id":"1f468-1f3fb-200d-2696-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x2696&#xfe0f;"},
                {"id":"1f469-1f3fb-200d-2708-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f469&#x1f3fb&#x200d&#x2708&#xfe0f;"},
                {"id":"1f468-1f3fb-200d-2708-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f468&#x1f3fb&#x200d&#x2708&#xfe0f;"},
                {"id":"1f482-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f482&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f482-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f482&#x1f3fb;"},
                {"id":"1f575-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f575&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f575-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f575&#x1f3fb;"},
                {"id":"1f385-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f385&#x1f3fb;"},
                {"id":"1f936-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f936&#x1f3fb;"},
                {"id":"1f47c-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f47c&#x1f3fb;"},
                {"id":"1f478-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f478&#x1f3fb;"},
                {"id":"1f934-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f934&#x1f3fb;"},
                {"id":"1f469-1f3fc-200d-1f3a4", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f3a4;"},
                {"id":"1f468-1f3fc-200d-1f3a4", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f3a4;"},
                {"id":"1f469-1f3fc-200d-1f3a8", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f3a8;"},
                {"id":"1f468-1f3fc-200d-1f3a8", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f3a8;"},
                {"id":"1f469-1f3fc-200d-1f3eb", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f3eb;"},
                {"id":"1f468-1f3fc-200d-1f3eb", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f3eb;"},
                {"id":"1f469-1f3fc-200d-1f393", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f393;"},
                {"id":"1f468-1f3fc-200d-1f393", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f393;"},
                {"id":"1f469-1f3fc-200d-1f4bc", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f4bc;"},
                {"id":"1f468-1f3fc-200d-1f4bc", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f4bc;"},
                {"id":"1f469-1f3fc-200d-1f4bb", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f4bb;"},
                {"id":"1f468-1f3fc-200d-1f4bb", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f4bb;"},
                {"id":"1f469-1f3fc-200d-1f52c", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f52c;"},
                {"id":"1f468-1f3fc-200d-1f52c", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f52c;"},
                {"id":"1f469-1f3fc-200d-1f680", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x1f680;"},
                {"id":"1f468-1f3fc-200d-1f680", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x1f680;"},
                {"id":"1f469-1f3fc-200d-2695-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x2695&#xfe0f;"},
                {"id":"1f468-1f3fc-200d-2695-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x2695&#xfe0f;"},
                {"id":"1f469-1f3fc-200d-2696-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x2696&#xfe0f;"},
                {"id":"1f468-1f3fc-200d-2696-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x2696&#xfe0f;"},
                {"id":"1f469-1f3fc-200d-2708-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f469&#x1f3fc&#x200d&#x2708&#xfe0f;"},
                {"id":"1f468-1f3fc-200d-2708-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f468&#x1f3fc&#x200d&#x2708&#xfe0f;"},
                {"id":"1f482-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f482&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f482-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f482&#x1f3fc;"},
                {"id":"1f575-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f575&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f575-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f575&#x1f3fc;"},
                {"id":"1f385-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f385&#x1f3fc;"},
                {"id":"1f936-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f936&#x1f3fc;"},
                {"id":"1f47c-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f47c&#x1f3fc;"},
                {"id":"1f478-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f478&#x1f3fc;"},
                {"id":"1f934-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f934&#x1f3fc;"},
                {"id":"1f469-1f3fd-200d-1f3a4", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f3a4;"},
                {"id":"1f468-1f3fd-200d-1f3a4", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f3a4;"},
                {"id":"1f469-1f3fd-200d-1f3a8", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f3a8;"},
                {"id":"1f468-1f3fd-200d-1f3a8", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f3a8;"},
                {"id":"1f469-1f3fd-200d-1f3eb", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f3eb;"},
                {"id":"1f468-1f3fd-200d-1f3eb", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f3eb;"},
                {"id":"1f469-1f3fd-200d-1f393", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f393;"},
                {"id":"1f468-1f3fd-200d-1f393", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f393;"},
                {"id":"1f469-1f3fd-200d-1f4bc", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f4bc;"},
                {"id":"1f468-1f3fd-200d-1f4bc", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f4bc;"},
                {"id":"1f469-1f3fd-200d-1f4bb", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f4bb;"},
                {"id":"1f468-1f3fd-200d-1f4bb", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f4bb;"},
                {"id":"1f469-1f3fd-200d-1f52c", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f52c;"},
                {"id":"1f468-1f3fd-200d-1f52c", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f52c;"},
                {"id":"1f469-1f3fd-200d-1f680", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x1f680;"},
                {"id":"1f468-1f3fd-200d-1f680", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x1f680;"},
                {"id":"1f469-1f3fd-200d-2695-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x2695&#xfe0f;"},
                {"id":"1f468-1f3fd-200d-2695-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x2695&#xfe0f;"},
                {"id":"1f469-1f3fd-200d-2696-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x2696&#xfe0f;"},
                {"id":"1f468-1f3fd-200d-2696-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x2696&#xfe0f;"},
                {"id":"1f469-1f3fd-200d-2708-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f469&#x1f3fd&#x200d&#x2708&#xfe0f;"},
                {"id":"1f468-1f3fd-200d-2708-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f468&#x1f3fd&#x200d&#x2708&#xfe0f;"},
                {"id":"1f482-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f482&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f482-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f482&#x1f3fd;"},
                {"id":"1f575-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f575&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f575-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f575&#x1f3fd;"},
                {"id":"1f385-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f385&#x1f3fd;"},
                {"id":"1f936-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f936&#x1f3fd;"},
                {"id":"1f47c-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f47c&#x1f3fd;"},
                {"id":"1f478-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f478&#x1f3fd;"},
                {"id":"1f934-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f934&#x1f3fd;"},
                {"id":"1f469-1f3fe-200d-1f3a4", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f3a4;"},
                {"id":"1f468-1f3fe-200d-1f3a4", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f3a4;"},
                {"id":"1f469-1f3fe-200d-1f3a8", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f3a8;"},
                {"id":"1f468-1f3fe-200d-1f3a8", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f3a8;"},
                {"id":"1f469-1f3fe-200d-1f3eb", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f3eb;"},
                {"id":"1f468-1f3fe-200d-1f3eb", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f3eb;"},
                {"id":"1f469-1f3fe-200d-1f393", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f393;"},
                {"id":"1f468-1f3fe-200d-1f393", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f393;"},
                {"id":"1f469-1f3fe-200d-1f4bc", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f4bc;"},
                {"id":"1f468-1f3fe-200d-1f4bc", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f4bc;"},
                {"id":"1f469-1f3fe-200d-1f4bb", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f4bb;"},
                {"id":"1f468-1f3fe-200d-1f4bb", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f4bb;"},
                {"id":"1f469-1f3fe-200d-1f52c", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f52c;"},
                {"id":"1f468-1f3fe-200d-1f52c", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f52c;"},
                {"id":"1f469-1f3fe-200d-1f680", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x1f680;"},
                {"id":"1f468-1f3fe-200d-1f680", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x1f680;"},
                {"id":"1f469-1f3fe-200d-2695-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x2695&#xfe0f;"},
                {"id":"1f468-1f3fe-200d-2695-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x2695&#xfe0f;"},
                {"id":"1f469-1f3fe-200d-2696-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x2696&#xfe0f;"},
                {"id":"1f468-1f3fe-200d-2696-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x2696&#xfe0f;"},
                {"id":"1f469-1f3fe-200d-2708-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f469&#x1f3fe&#x200d&#x2708&#xfe0f;"},
                {"id":"1f468-1f3fe-200d-2708-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f468&#x1f3fe&#x200d&#x2708&#xfe0f;"},
                {"id":"1f482-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f482&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f482-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f482&#x1f3fe;"},
                {"id":"1f575-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f575&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f575-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f575&#x1f3fe;"},
                {"id":"1f385-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f385&#x1f3fe;"},
                {"id":"1f936-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f936&#x1f3fe;"},
                {"id":"1f47c-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f47c&#x1f3fe;"},
                {"id":"1f478-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f478&#x1f3fe;"},
                {"id":"1f934-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f934&#x1f3fe;"},
                {"id":"1f469-1f3ff-200d-1f3a4", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f3a4;"},
                {"id":"1f468-1f3ff-200d-1f3a4", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f3a4;"},
                {"id":"1f469-1f3ff-200d-1f3a8", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f3a8;"},
                {"id":"1f468-1f3ff-200d-1f3a8", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f3a8;"},
                {"id":"1f469-1f3ff-200d-1f3eb", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f3eb;"},
                {"id":"1f468-1f3ff-200d-1f3eb", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f3eb;"},
                {"id":"1f469-1f3ff-200d-1f393", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f393;"},
                {"id":"1f468-1f3ff-200d-1f393", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f393;"},
                {"id":"1f469-1f3ff-200d-1f4bc", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f4bc;"},
                {"id":"1f468-1f3ff-200d-1f4bc", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f4bc;"},
                {"id":"1f469-1f3ff-200d-1f4bb", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f4bb;"},
                {"id":"1f468-1f3ff-200d-1f4bb", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f4bb;"},
                {"id":"1f469-1f3ff-200d-1f52c", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f52c;"},
                {"id":"1f468-1f3ff-200d-1f52c", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f52c;"},
                {"id":"1f469-1f3ff-200d-1f680", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x1f680;"},
                {"id":"1f468-1f3ff-200d-1f680", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x1f680;"},
                {"id":"1f469-1f3ff-200d-2695-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x2695&#xfe0f;"},
                {"id":"1f468-1f3ff-200d-2695-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x2695&#xfe0f;"},
                {"id":"1f469-1f3ff-200d-2696-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x2696&#xfe0f;"},
                {"id":"1f468-1f3ff-200d-2696-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x2696&#xfe0f;"},
                {"id":"1f469-1f3ff-200d-2708-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f469&#x1f3ff&#x200d&#x2708&#xfe0f;"},
                {"id":"1f468-1f3ff-200d-2708-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f468&#x1f3ff&#x200d&#x2708&#xfe0f;"},
                {"id":"1f482-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f482&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f482-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f482&#x1f3ff;"},
                {"id":"1f575-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f575&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f575-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f575&#x1f3ff;"},
                {"id":"1f385-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f385&#x1f3ff;"},
                {"id":"1f936-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f936&#x1f3ff;"},
                {"id":"1f47c-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f47c&#x1f3ff;"},
                {"id":"1f478-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f478&#x1f3ff;"},
                {"id":"1f934-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f934&#x1f3ff;"},
                {"id":"1f470", "class":"emoji_yellow nep_tone", "code":"&#x1f470;"},
                {"id":"1f935", "class":"emoji_yellow nep_tone", "code":"&#x1f935;"},
                {"id":"1f574", "class":"emoji_yellow nep_tone", "code":"&#x1f574;"},
                {"id":"1f9d9-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9d9&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d9-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9d9&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dd-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9dd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dd-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9dd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9da-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9da&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9da-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9da&#x200d&#x2642&#xfe0f;"},
                {"id":"1f470-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f470&#x1f3fb;"},
                {"id":"1f935-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f935&#x1f3fb;"},
                {"id":"1f574-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f574&#x1f3fb;"},
                {"id":"1f9d9-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9d9&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d9-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9d9&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dd-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9dd&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dd-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9dd&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9da-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9da&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9da-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9da&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f470-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f470&#x1f3fc;"},
                {"id":"1f935-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f935&#x1f3fc;"},
                {"id":"1f574-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f574&#x1f3fc;"},
                {"id":"1f9d9-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9d9&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d9-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9d9&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dd-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9dd&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dd-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9dd&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9da-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9da&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9da-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9da&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f470-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f470&#x1f3fd;"},
                {"id":"1f935-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f935&#x1f3fd;"},
                {"id":"1f574-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f574&#x1f3fd;"},
                {"id":"1f9d9-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d9&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d9-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d9&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dd-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9dd&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dd-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9dd&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9da-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9da&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9da-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9da&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f470-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f470&#x1f3fe;"},
                {"id":"1f935-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f935&#x1f3fe;"},
                {"id":"1f574-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f574&#x1f3fe;"},

                {"id":"1f9d9-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d9&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d9-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d9&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dd-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9dd&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dd-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9dd&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9da-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9da&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9da-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9da&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f470-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f470&#x1f3ff;"},
                {"id":"1f935-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f935&#x1f3ff;"},
                {"id":"1f574-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f574&#x1f3ff;"},
                {"id":"1f9d9-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9d9&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d9-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9d9&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dd-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9dd&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dd-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9dd&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9da-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9da&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9da-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9da&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9de-200d-2640-fe0f", "class":"emoji", "code":"&#x1f9de&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9de-200d-2642-fe0f", "class":"emoji", "code":"&#x1f9de&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dc-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9dc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dc-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9dc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9db-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9db&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9db-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9db&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dc-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9dc&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dc-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9dc&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9db-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9db&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9db-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9db&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dc-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9dc&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dc-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9dc&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9db-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9db&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9db-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9db&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dc-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9dc&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dc-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9dc&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9db-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9db&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9db-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9db&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dc-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9dc&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dc-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9dc&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9db-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9db&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9db-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9db&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9dc-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9dc&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9dc-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9dc&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9db-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9db&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9db-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9db&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9df-200d-2640-fe0f", "class":"emoji", "code":"&#x1f9df&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9df-200d-2642-fe0f", "class":"emoji", "code":"&#x1f9df&#x200d&#x2642&#xfe0f;"},
                {"id":"1f647-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f647&#x200d&#x2640&#xfe0f;"},
                {"id":"1f647", "class":"emoji_yellow nep_tone", "code":"&#x1f647;"},
                {"id":"1f481", "class":"emoji_yellow nep_tone", "code":"&#x1f481;"},
                {"id":"1f481-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f481&#x200d&#x2642&#xfe0f;"},
                {"id":"1f645", "class":"emoji_yellow nep_tone", "code":"&#x1f645;"},
                {"id":"1f645-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f645&#x200d&#x2642&#xfe0f;"},
                {"id":"1f646", "class":"emoji_yellow nep_tone", "code":"&#x1f646;"},
                {"id":"1f646-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f646&#x200d&#x2642&#xfe0f;"},
                {"id":"1f937", "class":"emoji_yellow nep_tone", "code":"&#x1f937;"},
                {"id":"1f937-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f937&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64b", "class":"emoji_yellow nep_tone", "code":"&#x1f64b;"},
                {"id":"1f64b-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f64b&#x200d&#x2642&#xfe0f;"},
                {"id":"1f926", "class":"emoji_yellow nep_tone", "code":"&#x1f926;"},
                {"id":"1f926-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f926&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64e", "class":"emoji_yellow nep_tone", "code":"&#x1f64e;"},
                {"id":"1f64e-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f64e&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64d", "class":"emoji_yellow nep_tone", "code":"&#x1f64d;"},
                {"id":"1f64d-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f64d&#x200d&#x2642&#xfe0f;"},
                {"id":"1f487", "class":"emoji_yellow nep_tone", "code":"&#x1f487;"},
                {"id":"1f487-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f487&#x200d&#x2642&#xfe0f;"},
                {"id":"1f486", "class":"emoji_yellow nep_tone", "code":"&#x1f486;"},
                {"id":"1f486-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f486&#x200d&#x2642&#xfe0f;"},
                {"id":"1f930", "class":"emoji_yellow nep_tone", "code":"&#x1f930;"},
                {"id":"1f931", "class":"emoji_yellow nep_tone", "code":"&#x1f931;"},
                {"id":"1f6b6-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f6b6&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b6", "class":"emoji_yellow nep_tone", "code":"&#x1f6b6;"},
                {"id":"1f3c3-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f3c3&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c3", "class":"emoji_yellow nep_tone", "code":"&#x1f3c3;"},
                {"id":"1f483", "class":"emoji_yellow nep_tone", "code":"&#x1f483;"},
                {"id":"1f57a", "class":"emoji_yellow nep_tone", "code":"&#x1f57a;"},
                {"id":"1f647-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f647&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f647-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f647&#x1f3fb;"},
                {"id":"1f481-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f481&#x1f3fb;"},
                {"id":"1f481-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f481&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f645-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f645&#x1f3fb;"},
                {"id":"1f645-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f645&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f646-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f646&#x1f3fb;"},
                {"id":"1f646-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f646&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f937-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f937&#x1f3fb;"},
                {"id":"1f937-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f937&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64b-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f64b&#x1f3fb;"},
                {"id":"1f64b-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f64b&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f926-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f926&#x1f3fb;"},
                {"id":"1f926-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f926&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64e-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f64e&#x1f3fb;"},
                {"id":"1f64e-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f64e&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64d-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f64d&#x1f3fb;"},
                {"id":"1f64d-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f64d&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f487-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f487&#x1f3fb;"},
                {"id":"1f487-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f487&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f486-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f486&#x1f3fb;"},
                {"id":"1f486-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f486&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f930-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f930&#x1f3fb;"},
                {"id":"1f931-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f931&#x1f3fb;"},
                {"id":"1f6b6-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f6b6&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b6-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f6b6&#x1f3fb;"},
                {"id":"1f3c3-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f3c3&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c3-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f3c3&#x1f3fb;"},
                {"id":"1f483-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f483&#x1f3fb;"},
                {"id":"1f57a-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f57a&#x1f3fb;"},
                {"id":"1f647-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f647&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f647-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f647&#x1f3fc;"},
                {"id":"1f481-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f481&#x1f3fc;"},
                {"id":"1f481-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f481&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f645-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f645&#x1f3fc;"},
                {"id":"1f645-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f645&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f646-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f646&#x1f3fc;"},
                {"id":"1f646-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f646&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f937-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f937&#x1f3fc;"},
                {"id":"1f937-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f937&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64b-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f64b&#x1f3fc;"},
                {"id":"1f64b-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f64b&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f926-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f926&#x1f3fc;"},
                {"id":"1f926-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f926&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64e-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f64e&#x1f3fc;"},
                {"id":"1f64e-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f64e&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64d-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f64d&#x1f3fc;"},
                {"id":"1f64d-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f64d&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f487-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f487&#x1f3fc;"},
                {"id":"1f487-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f487&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f486-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f486&#x1f3fc;"},
                {"id":"1f486-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f486&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f930-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f930&#x1f3fc;"},
                {"id":"1f931-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f931&#x1f3fc;"},
                {"id":"1f6b6-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f6b6&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b6-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f6b6&#x1f3fc;"},
                {"id":"1f3c3-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f3c3&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c3-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f3c3&#x1f3fc;"},
                {"id":"1f483-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f483&#x1f3fc;"},
                {"id":"1f57a-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f57a&#x1f3fc;"},
                {"id":"1f647-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f647&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f647-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f647&#x1f3fd;"},
                {"id":"1f481-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f481&#x1f3fd;"},
                {"id":"1f481-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f481&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f645-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f645&#x1f3fd;"},
                {"id":"1f645-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f645&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f646-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f646&#x1f3fd;"},
                {"id":"1f646-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f646&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f937-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f937&#x1f3fd;"},
                {"id":"1f937-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f937&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64b-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f64b&#x1f3fd;"},
                {"id":"1f64b-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f64b&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f926-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f926&#x1f3fd;"},
                {"id":"1f926-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f926&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64e-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f64e&#x1f3fd;"},
                {"id":"1f64e-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f64e&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64d-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f64d&#x1f3fd;"},
                {"id":"1f64d-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f64d&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f487-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f487&#x1f3fd;"},
                {"id":"1f487-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f487&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f486-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f486&#x1f3fd;"},
                {"id":"1f486-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f486&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f930-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f930&#x1f3fd;"},
                {"id":"1f931-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f931&#x1f3fd;"},
                {"id":"1f6b6-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f6b6&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b6-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f6b6&#x1f3fd;"},
                {"id":"1f3c3-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3c3&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c3-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3c3&#x1f3fd;"},
                {"id":"1f483-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f483&#x1f3fd;"},
                {"id":"1f57a-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f57a&#x1f3fd;"},
                {"id":"1f647-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f647&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f647-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f647&#x1f3fe;"},
                {"id":"1f481-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f481&#x1f3fe;"},
                {"id":"1f481-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f481&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f645-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f645&#x1f3fe;"},
                {"id":"1f645-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f645&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f646-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f646&#x1f3fe;"},
                {"id":"1f646-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f646&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f937-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f937&#x1f3fe;"},
                {"id":"1f937-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f937&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64b-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f64b&#x1f3fe;"},
                {"id":"1f64b-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f64b&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f926-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f926&#x1f3fe;"},
                {"id":"1f926-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f926&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64e-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f64e&#x1f3fe;"},
                {"id":"1f64e-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f64e&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64d-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f64d&#x1f3fe;"},
                {"id":"1f64d-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f64d&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f487-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f487&#x1f3fe;"},
                {"id":"1f487-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f487&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f486-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f486&#x1f3fe;"},
                {"id":"1f486-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f486&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f930-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f930&#x1f3fe;"},
                {"id":"1f931-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f931&#x1f3fe;"},
                {"id":"1f6b6-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f6b6&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b6-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f6b6&#x1f3fe;"},
                {"id":"1f3c3-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3c3&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c3-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3c3&#x1f3fe;"},
                {"id":"1f483-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f483&#x1f3fe;"},
                {"id":"1f57a-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f57a&#x1f3fe;"},
                {"id":"1f647-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f647&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f647-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f647&#x1f3ff;"},
                {"id":"1f481-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f481&#x1f3ff;"},
                {"id":"1f481-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f481&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f645-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f645&#x1f3ff;"},
                {"id":"1f645-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f645&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f646-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f646&#x1f3ff;"},
                {"id":"1f646-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f646&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f937-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f937&#x1f3ff;"},
                {"id":"1f937-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f937&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64b-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f64b&#x1f3ff;"},
                {"id":"1f64b-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f64b&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f926-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f926&#x1f3ff;"},
                {"id":"1f926-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f926&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64e-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f64e&#x1f3ff;"},
                {"id":"1f64e-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f64e&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f64d-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f64d&#x1f3ff;"},
                {"id":"1f64d-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f64d&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f487-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f487&#x1f3ff;"},
                {"id":"1f487-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f487&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f486-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f486&#x1f3ff;"},
                {"id":"1f486-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f486&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f930-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f930&#x1f3ff;"},
                {"id":"1f931-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f931&#x1f3ff;"},
                {"id":"1f6b6-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f6b6&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b6-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f6b6&#x1f3ff;"},
                {"id":"1f3c3-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f3c3&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c3-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f3c3&#x1f3ff;"},
                {"id":"1f483-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f483&#x1f3ff;"},
                {"id":"1f57a-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f57a&#x1f3ff;"},
                {"id":"1f46f", "class":"emoji", "code":"&#x1f46f;"},
                {"id":"1f46f-200d-2642-fe0f", "class":"emoji", "code":"&#x1f46f&#x200d&#x2642&#xfe0f;"},
                {"id":"1f46b", "class":"emoji", "code":"&#x1f46b;"},
                {"id":"1f46c", "class":"emoji", "code":"&#x1f46c;"},
                {"id":"1f46d", "class":"emoji", "code":"&#x1f46d;"},
                {"id":"1f491", "class":"emoji", "code":"&#x1f491;"},
                {"id":"1f469-200d-2764-fe0f-200d-1f469", "class":"emoji", "code":"&#x1f469&#x200d&#x2764&#xfe0f&#x200d&#x1f469;"},
                {"id":"1f468-200d-2764-fe0f-200d-1f468", "class":"emoji", "code":"&#x1f468&#x200d&#x2764&#xfe0f&#x200d&#x1f468;"},
                {"id":"1f48f", "class":"emoji", "code":"&#x1f48f;"},
                {"id":"1f469-200d-2764-fe0f-200d-1f48b-200d-1f469", "class":"emoji", "code":"&#x1f469&#x200d&#x2764&#xfe0f&#x200d&#x1f48b&#x200d&#x1f469;"},
                {"id":"1f468-200d-2764-fe0f-200d-1f48b-200d-1f468", "class":"emoji", "code":"&#x1f468&#x200d&#x2764&#xfe0f&#x200d&#x1f48b&#x200d&#x1f468;"},
                {"id":"1f46a", "class":"emoji", "code":"&#x1f46a;"},
                {"id":"1f468-200d-1f469-200d-1f467", "class":"emoji", "code":"&#x1f468&#x200d&#x1f469&#x200d&#x1f467;"},
                {"id":"1f468-200d-1f469-200d-1f467-200d-1f466", "class":"emoji", "code":"&#x1f468&#x200d&#x1f469&#x200d&#x1f467&#x200d&#x1f466;"},
                {"id":"1f468-200d-1f469-200d-1f466-200d-1f466", "class":"emoji", "code":"&#x1f468&#x200d&#x1f469&#x200d&#x1f466&#x200d&#x1f466;"},
                {"id":"1f468-200d-1f469-200d-1f467-200d-1f467", "class":"emoji", "code":"&#x1f468&#x200d&#x1f469&#x200d&#x1f467&#x200d&#x1f467;"},
                {"id":"1f469-200d-1f469-200d-1f466", "class":"emoji", "code":"&#x1f469&#x200d&#x1f469&#x200d&#x1f466;"},
                {"id":"1f469-200d-1f469-200d-1f467", "class":"emoji", "code":"&#x1f469&#x200d&#x1f469&#x200d&#x1f467;"},
                {"id":"1f469-200d-1f469-200d-1f467-200d-1f466", "class":"emoji", "code":"&#x1f469&#x200d&#x1f469&#x200d&#x1f467&#x200d&#x1f466;"},
                {"id":"1f469-200d-1f469-200d-1f466-200d-1f466", "class":"emoji", "code":"&#x1f469&#x200d&#x1f469&#x200d&#x1f466&#x200d&#x1f466;"},
                {"id":"1f469-200d-1f469-200d-1f467-200d-1f467", "class":"emoji", "code":"&#x1f469&#x200d&#x1f469&#x200d&#x1f467&#x200d&#x1f467;"},
                {"id":"1f468-200d-1f468-200d-1f466", "class":"emoji", "code":"&#x1f468&#x200d&#x1f468&#x200d&#x1f466;"},
                {"id":"1f468-200d-1f468-200d-1f467", "class":"emoji", "code":"&#x1f468&#x200d&#x1f468&#x200d&#x1f467;"},
                {"id":"1f468-200d-1f468-200d-1f467-200d-1f466", "class":"emoji", "code":"&#x1f468&#x200d&#x1f468&#x200d&#x1f467&#x200d&#x1f466;"},
                {"id":"1f468-200d-1f468-200d-1f466-200d-1f466", "class":"emoji", "code":"&#x1f468&#x200d&#x1f468&#x200d&#x1f466&#x200d&#x1f466;"},
                {"id":"1f468-200d-1f468-200d-1f467-200d-1f467", "class":"emoji", "code":"&#x1f468&#x200d&#x1f468&#x200d&#x1f467&#x200d&#x1f467;"},
                {"id":"1f469-200d-1f466", "class":"emoji", "code":"&#x1f469&#x200d&#x1f466;"},
                {"id":"1f469-200d-1f467", "class":"emoji", "code":"&#x1f469&#x200d&#x1f467;"},
                {"id":"1f469-200d-1f467-200d-1f466", "class":"emoji", "code":"&#x1f469&#x200d&#x1f467&#x200d&#x1f466;"},
                {"id":"1f469-200d-1f466-200d-1f466", "class":"emoji", "code":"&#x1f469&#x200d&#x1f466&#x200d&#x1f466;"},
                {"id":"1f469-200d-1f467-200d-1f467", "class":"emoji", "code":"&#x1f469&#x200d&#x1f467&#x200d&#x1f467;"},
                {"id":"1f468-200d-1f466", "class":"emoji", "code":"&#x1f468&#x200d&#x1f466;"},
                {"id":"1f468-200d-1f467", "class":"emoji", "code":"&#x1f468&#x200d&#x1f467;"},
                {"id":"1f468-200d-1f467-200d-1f466", "class":"emoji", "code":"&#x1f468&#x200d&#x1f467&#x200d&#x1f466;"},
                {"id":"1f468-200d-1f466-200d-1f466", "class":"emoji", "code":"&#x1f468&#x200d&#x1f466&#x200d&#x1f466;"},
                {"id":"1f468-200d-1f467-200d-1f467", "class":"emoji", "code":"&#x1f468&#x200d&#x1f467&#x200d&#x1f467;"},
                {"id":"1f45a", "class":"emoji", "code":"&#x1f45a;"},
                {"id":"1f455", "class":"emoji", "code":"&#x1f455;"},
                {"id":"1f9e5", "class":"emoji", "code":"&#x1f9e5;"},
                {"id":"1f456", "class":"emoji", "code":"&#x1f456;"},
                {"id":"1f454", "class":"emoji", "code":"&#x1f454;"},
                {"id":"1f457", "class":"emoji", "code":"&#x1f457;"},
                {"id":"1f459", "class":"emoji", "code":"&#x1f459;"},
                {"id":"1f458", "class":"emoji", "code":"&#x1f458;"},
                {"id":"1f484", "class":"emoji", "code":"&#x1f484;"},
                {"id":"1f48b", "class":"emoji", "code":"&#x1f48b;"},
                {"id":"1f463", "class":"emoji", "code":"&#x1f463;"},
                {"id":"1f9e6", "class":"emoji", "code":"&#x1f9e6;"},
                {"id":"1f460", "class":"emoji", "code":"&#x1f460;"},
                {"id":"1f461", "class":"emoji", "code":"&#x1f461;"},
                {"id":"1f462", "class":"emoji", "code":"&#x1f462;"},
                {"id":"1f45e", "class":"emoji", "code":"&#x1f45e;"},
                {"id":"1f45f", "class":"emoji", "code":"&#x1f45f;"},
                {"id":"1f9e2", "class":"emoji", "code":"&#x1f9e2;"},
                {"id":"1f452", "class":"emoji", "code":"&#x1f452;"},
                {"id":"1f3a9", "class":"emoji", "code":"&#x1f3a9;"},
                {"id":"1f393", "class":"emoji", "code":"&#x1f393;"},
                {"id":"1f451", "class":"emoji", "code":"&#x1f451;"},
                {"id":"26d1", "class":"emoji", "code":"&#x26d1;"},
                {"id":"1f392", "class":"emoji", "code":"&#x1f392;"},
                {"id":"1f45d", "class":"emoji", "code":"&#x1f45d;"},
                {"id":"1f45b", "class":"emoji", "code":"&#x1f45b;"},
                {"id":"1f45c", "class":"emoji", "code":"&#x1f45c;"},
                {"id":"1f4bc", "class":"emoji", "code":"&#x1f4bc;"},
                {"id":"1f453", "class":"emoji", "code":"&#x1f453;"},
                {"id":"1f576", "class":"emoji", "code":"&#x1f576;"},
                {"id":"1f9e3", "class":"emoji", "code":"&#x1f9e3;"},
                {"id":"1f9e4", "class":"emoji", "code":"&#x1f9e4;"},
                {"id":"1f48d", "class":"emoji", "code":"&#x1f48d;"},
                {"id":"1f302", "class":"emoji", "code":"&#x1f302;"},
                {"id":"2602", "class":"emoji", "code":"&#x2602;"}
            ]
        },
        // Emoji Animals & Nature Codes
        'nep_animals_nature' : {
            'name' : nep_plugin_vars.nep_animals_nature,
            'codes' : [
                {"id":"1f436", "class":"emoji", "code":"&#x1f436;"},
                {"id":"1f431", "class":"emoji", "code":"&#x1f431;"},
                {"id":"1f42d", "class":"emoji", "code":"&#x1f42d;"},
                {"id":"1f439", "class":"emoji", "code":"&#x1f439;"},
                {"id":"1f430", "class":"emoji", "code":"&#x1f430;"},
                {"id":"1f43b", "class":"emoji", "code":"&#x1f43b;"},
                {"id":"1f43c", "class":"emoji", "code":"&#x1f43c;"},
                {"id":"1f428", "class":"emoji", "code":"&#x1f428;"},
                {"id":"1f42f", "class":"emoji", "code":"&#x1f42f;"},
                {"id":"1f981", "class":"emoji", "code":"&#x1f981;"},
                {"id":"1f42e", "class":"emoji", "code":"&#x1f42e;"},
                {"id":"1f437", "class":"emoji", "code":"&#x1f437;"},
                {"id":"1f43d", "class":"emoji", "code":"&#x1f43d;"},
                {"id":"1f438", "class":"emoji", "code":"&#x1f438;"},
                {"id":"1f435", "class":"emoji", "code":"&#x1f435;"},
                {"id":"1f648", "class":"emoji", "code":"&#x1f648;"},
                {"id":"1f649", "class":"emoji", "code":"&#x1f649;"},
                {"id":"1f64a", "class":"emoji", "code":"&#x1f64a;"},
                {"id":"1f412", "class":"emoji", "code":"&#x1f412;"},
                {"id":"1f98d", "class":"emoji", "code":"&#x1f98d;"},
                {"id":"1f414", "class":"emoji", "code":"&#x1f414;"},
                {"id":"1f427", "class":"emoji", "code":"&#x1f427;"},
                {"id":"1f426", "class":"emoji", "code":"&#x1f426;"},
                {"id":"1f424", "class":"emoji", "code":"&#x1f424;"},
                {"id":"1f423", "class":"emoji", "code":"&#x1f423;"},
                {"id":"1f425", "class":"emoji", "code":"&#x1f425;"},
                {"id":"1f43a", "class":"emoji", "code":"&#x1f43a;"},
                {"id":"1f98a", "class":"emoji", "code":"&#x1f98a;"},
                {"id":"1f417", "class":"emoji", "code":"&#x1f417;"},
                {"id":"1f434", "class":"emoji", "code":"&#x1f434;"},
                {"id":"1f993", "class":"emoji", "code":"&#x1f993;"},
                {"id":"1f992", "class":"emoji", "code":"&#x1f992;"},
                {"id":"1f98c", "class":"emoji", "code":"&#x1f98c;"},
                {"id":"1f984", "class":"emoji", "code":"&#x1f984;"},
                {"id":"1f41d", "class":"emoji", "code":"&#x1f41d;"},
                {"id":"1f41b", "class":"emoji", "code":"&#x1f41b;"},
                {"id":"1f98b", "class":"emoji", "code":"&#x1f98b;"},
                {"id":"1f40c", "class":"emoji", "code":"&#x1f40c;"},
                {"id":"1f41e", "class":"emoji", "code":"&#x1f41e;"},
                {"id":"1f41c", "class":"emoji", "code":"&#x1f41c;"},
                {"id":"1f997", "class":"emoji", "code":"&#x1f997;"},
                {"id":"1f577", "class":"emoji", "code":"&#x1f577;"},
                {"id":"1f578", "class":"emoji", "code":"&#x1f578;"},
                {"id":"1f982", "class":"emoji", "code":"&#x1f982;"},
                {"id":"1f422", "class":"emoji", "code":"&#x1f422;"},
                {"id":"1f40d", "class":"emoji", "code":"&#x1f40d;"},
                {"id":"1f98e", "class":"emoji", "code":"&#x1f98e;"},
                {"id":"1f980", "class":"emoji", "code":"&#x1f980;"},
                {"id":"1f991", "class":"emoji", "code":"&#x1f991;"},
                {"id":"1f419", "class":"emoji", "code":"&#x1f419;"},
                {"id":"1f990", "class":"emoji", "code":"&#x1f990;"},
                {"id":"1f420", "class":"emoji", "code":"&#x1f420;"},
                {"id":"1f41f", "class":"emoji", "code":"&#x1f41f;"},
                {"id":"1f421", "class":"emoji", "code":"&#x1f421;"},
                {"id":"1f42c", "class":"emoji", "code":"&#x1f42c;"},
                {"id":"1f988", "class":"emoji", "code":"&#x1f988;"},
                {"id":"1f433", "class":"emoji", "code":"&#x1f433;"},
                {"id":"1f40b", "class":"emoji", "code":"&#x1f40b;"},
                {"id":"1f40a", "class":"emoji", "code":"&#x1f40a;"},
                {"id":"1f406", "class":"emoji", "code":"&#x1f406;"},
                {"id":"1f405", "class":"emoji", "code":"&#x1f405;"},
                {"id":"1f403", "class":"emoji", "code":"&#x1f403;"},
                {"id":"1f402", "class":"emoji", "code":"&#x1f402;"},
                {"id":"1f404", "class":"emoji", "code":"&#x1f404;"},
                {"id":"1f42a", "class":"emoji", "code":"&#x1f42a;"},
                {"id":"1f42b", "class":"emoji", "code":"&#x1f42b;"},
                {"id":"1f418", "class":"emoji", "code":"&#x1f418;"},
                {"id":"1f98f", "class":"emoji", "code":"&#x1f98f;"},
                {"id":"1f410", "class":"emoji", "code":"&#x1f410;"},
                {"id":"1f40f", "class":"emoji", "code":"&#x1f40f;"},
                {"id":"1f411", "class":"emoji", "code":"&#x1f411;"},
                {"id":"1f40e", "class":"emoji", "code":"&#x1f40e;"},
                {"id":"1f416", "class":"emoji", "code":"&#x1f416;"},
                {"id":"1f987", "class":"emoji", "code":"&#x1f987;"},
                {"id":"1f413", "class":"emoji", "code":"&#x1f413;"},
                {"id":"1f983", "class":"emoji", "code":"&#x1f983;"},
                {"id":"1f54a", "class":"emoji", "code":"&#x1f54a;"},
                {"id":"1f985", "class":"emoji", "code":"&#x1f985;"},
                {"id":"1f986", "class":"emoji", "code":"&#x1f986;"},
                {"id":"1f989", "class":"emoji", "code":"&#x1f989;"},
                {"id":"1f415", "class":"emoji", "code":"&#x1f415;"},
                {"id":"1f429", "class":"emoji", "code":"&#x1f429;"},
                {"id":"1f408", "class":"emoji", "code":"&#x1f408;"},
                {"id":"1f407", "class":"emoji", "code":"&#x1f407;"},
                {"id":"1f400", "class":"emoji", "code":"&#x1f400;"},
                {"id":"1f401", "class":"emoji", "code":"&#x1f401;"},
                {"id":"1f43f", "class":"emoji", "code":"&#x1f43f;"},
                {"id":"1f994", "class":"emoji", "code":"&#x1f994;"},
                {"id":"1f43e", "class":"emoji", "code":"&#x1f43e;"},
                {"id":"1f409", "class":"emoji", "code":"&#x1f409;"},
                {"id":"1f432", "class":"emoji", "code":"&#x1f432;"},
                {"id":"1f995", "class":"emoji", "code":"&#x1f995;"},
                {"id":"1f996", "class":"emoji", "code":"&#x1f996;"},
                {"id":"1f335", "class":"emoji", "code":"&#x1f335;"},
                {"id":"1f384", "class":"emoji", "code":"&#x1f384;"},
                {"id":"1f332", "class":"emoji", "code":"&#x1f332;"},
                {"id":"1f333", "class":"emoji", "code":"&#x1f333;"},
                {"id":"1f334", "class":"emoji", "code":"&#x1f334;"},
                {"id":"1f331", "class":"emoji", "code":"&#x1f331;"},
                {"id":"1f33f", "class":"emoji", "code":"&#x1f33f;"},
                {"id":"2618", "class":"emoji", "code":"&#x2618;"},
                {"id":"1f340", "class":"emoji", "code":"&#x1f340;"},
                {"id":"1f38d", "class":"emoji", "code":"&#x1f38d;"},
                {"id":"1f38b", "class":"emoji", "code":"&#x1f38b;"},
                {"id":"1f343", "class":"emoji", "code":"&#x1f343;"},
                {"id":"1f342", "class":"emoji", "code":"&#x1f342;"},
                {"id":"1f341", "class":"emoji", "code":"&#x1f341;"},
                {"id":"1f33e", "class":"emoji", "code":"&#x1f33e;"},
                {"id":"1f33a", "class":"emoji", "code":"&#x1f33a;"},
                {"id":"1f33b", "class":"emoji", "code":"&#x1f33b;"},
                {"id":"1f339", "class":"emoji", "code":"&#x1f339;"},
                {"id":"1f940", "class":"emoji", "code":"&#x1f940;"},
                {"id":"1f337", "class":"emoji", "code":"&#x1f337;"},
                {"id":"1f33c", "class":"emoji", "code":"&#x1f33c;"},
                {"id":"1f338", "class":"emoji", "code":"&#x1f338;"},
                {"id":"1f490", "class":"emoji", "code":"&#x1f490;"},
                {"id":"1f344", "class":"emoji", "code":"&#x1f344;"},
                {"id":"1f330", "class":"emoji", "code":"&#x1f330;"},
                {"id":"1f41a", "class":"emoji", "code":"&#x1f41a;"},
                {"id":"1f30e", "class":"emoji", "code":"&#x1f30e;"},
                {"id":"1f30d", "class":"emoji", "code":"&#x1f30d;"},
                {"id":"1f30f", "class":"emoji", "code":"&#x1f30f;"},
                {"id":"1f315", "class":"emoji", "code":"&#x1f315;"},
                {"id":"1f316", "class":"emoji", "code":"&#x1f316;"},
                {"id":"1f317", "class":"emoji", "code":"&#x1f317;"},
                {"id":"1f318", "class":"emoji", "code":"&#x1f318;"},
                {"id":"1f311", "class":"emoji", "code":"&#x1f311;"},
                {"id":"1f312", "class":"emoji", "code":"&#x1f312;"},
                {"id":"1f313", "class":"emoji", "code":"&#x1f313;"},
                {"id":"1f314", "class":"emoji", "code":"&#x1f314;"},
                {"id":"1f31a", "class":"emoji", "code":"&#x1f31a;"},
                {"id":"1f31d", "class":"emoji", "code":"&#x1f31d;"},
                {"id":"1f31b", "class":"emoji", "code":"&#x1f31b;"},
                {"id":"1f31c", "class":"emoji", "code":"&#x1f31c;"},
                {"id":"1f31e", "class":"emoji", "code":"&#x1f31e;"},
                {"id":"1f319", "class":"emoji", "code":"&#x1f319;"},
                {"id":"2b50", "class":"emoji", "code":"&#x2b50;"},
                {"id":"1f31f", "class":"emoji", "code":"&#x1f31f;"},
                {"id":"1f4ab", "class":"emoji", "code":"&#x1f4ab;"},
                {"id":"2728", "class":"emoji", "code":"&#x2728;"},
                {"id":"2604", "class":"emoji", "code":"&#x2604;"},
                {"id":"2600", "class":"emoji", "code":"&#x2600;"},
                {"id":"1f324", "class":"emoji", "code":"&#x1f324;"},
                {"id":"26c5", "class":"emoji", "code":"&#x26c5;"},
                {"id":"1f325", "class":"emoji", "code":"&#x1f325;"},
                {"id":"1f326", "class":"emoji", "code":"&#x1f326;"},
                {"id":"2601", "class":"emoji", "code":"&#x2601;"},
                {"id":"1f327", "class":"emoji", "code":"&#x1f327;"},
                {"id":"26c8", "class":"emoji", "code":"&#x26c8;"},
                {"id":"1f329", "class":"emoji", "code":"&#x1f329;"},
                {"id":"26a1", "class":"emoji", "code":"&#x26a1;"},
                {"id":"1f525", "class":"emoji", "code":"&#x1f525;"},
                {"id":"1f4a5", "class":"emoji", "code":"&#x1f4a5;"},
                {"id":"2744", "class":"emoji", "code":"&#x2744;"},
                {"id":"1f328", "class":"emoji", "code":"&#x1f328;"},
                {"id":"2603", "class":"emoji", "code":"&#x2603;"},
                {"id":"26c4", "class":"emoji", "code":"&#x26c4;"},
                {"id":"1f32c", "class":"emoji", "code":"&#x1f32c;"},
                {"id":"1f4a8", "class":"emoji", "code":"&#x1f4a8;"},
                {"id":"1f32a", "class":"emoji", "code":"&#x1f32a;"},
                {"id":"1f32b", "class":"emoji", "code":"&#x1f32b;"},
                {"id":"2614", "class":"emoji", "code":"&#x2614;"},
                {"id":"1f4a7", "class":"emoji", "code":"&#x1f4a7;"},
                {"id":"1f4a6", "class":"emoji", "code":"&#x1f4a6;"},
                {"id":"1f30a", "class":"emoji", "code":"&#x1f30a;"}
            ]
        },
        // Emoji Food & Drink Codes
        'nep_food_drink' : {
            'name' : nep_plugin_vars.nep_food_drink,
            'codes' : [
                {"id":"1f34f", "class":"emoji", "code":"&#x1f34f;"},
                {"id":"1f34e", "class":"emoji", "code":"&#x1f34e;"},
                {"id":"1f350", "class":"emoji", "code":"&#x1f350;"},
                {"id":"1f34a", "class":"emoji", "code":"&#x1f34a;"},
                {"id":"1f34b", "class":"emoji", "code":"&#x1f34b;"},
                {"id":"1f34c", "class":"emoji", "code":"&#x1f34c;"},
                {"id":"1f349", "class":"emoji", "code":"&#x1f349;"},
                {"id":"1f347", "class":"emoji", "code":"&#x1f347;"},
                {"id":"1f353", "class":"emoji", "code":"&#x1f353;"},
                {"id":"1f348", "class":"emoji", "code":"&#x1f348;"},
                {"id":"1f352", "class":"emoji", "code":"&#x1f352;"},
                {"id":"1f351", "class":"emoji", "code":"&#x1f351;"},
                {"id":"1f34d", "class":"emoji", "code":"&#x1f34d;"},
                {"id":"1f965", "class":"emoji", "code":"&#x1f965;"},
                {"id":"1f95d", "class":"emoji", "code":"&#x1f95d;"},
                {"id":"1f345", "class":"emoji", "code":"&#x1f345;"},
                {"id":"1f951", "class":"emoji", "code":"&#x1f951;"},
                {"id":"1f346", "class":"emoji", "code":"&#x1f346;"},
                {"id":"1f336", "class":"emoji", "code":"&#x1f336;"},
                {"id":"1f952", "class":"emoji", "code":"&#x1f952;"},
                {"id":"1f966", "class":"emoji", "code":"&#x1f966;"},
                {"id":"1f33d", "class":"emoji", "code":"&#x1f33d;"},
                {"id":"1f955", "class":"emoji", "code":"&#x1f955;"},
                {"id":"1f957", "class":"emoji", "code":"&#x1f957;"},
                {"id":"1f954", "class":"emoji", "code":"&#x1f954;"},
                {"id":"1f360", "class":"emoji", "code":"&#x1f360;"},
                {"id":"1f95c", "class":"emoji", "code":"&#x1f95c;"},
                {"id":"1f36f", "class":"emoji", "code":"&#x1f36f;"},
                {"id":"1f35e", "class":"emoji", "code":"&#x1f35e;"},
                {"id":"1f950", "class":"emoji", "code":"&#x1f950;"},
                {"id":"1f956", "class":"emoji", "code":"&#x1f956;"},
                {"id":"1f968", "class":"emoji", "code":"&#x1f968;"},
                {"id":"1f95e", "class":"emoji", "code":"&#x1f95e;"},
                {"id":"1f9c0", "class":"emoji", "code":"&#x1f9c0;"},
                {"id":"1f357", "class":"emoji", "code":"&#x1f357;"},
                {"id":"1f356", "class":"emoji", "code":"&#x1f356;"},
                {"id":"1f969", "class":"emoji", "code":"&#x1f969;"},
                {"id":"1f364", "class":"emoji", "code":"&#x1f364;"},
                {"id":"1f95a", "class":"emoji", "code":"&#x1f95a;"},
                {"id":"1f373", "class":"emoji", "code":"&#x1f373;"},
                {"id":"1f953", "class":"emoji", "code":"&#x1f953;"},
                {"id":"1f354", "class":"emoji", "code":"&#x1f354;"},
                {"id":"1f35f", "class":"emoji", "code":"&#x1f35f;"},
                {"id":"1f32d", "class":"emoji", "code":"&#x1f32d;"},
                {"id":"1f355", "class":"emoji", "code":"&#x1f355;"},
                {"id":"1f35d", "class":"emoji", "code":"&#x1f35d;"},
                {"id":"1f96a", "class":"emoji", "code":"&#x1f96a;"},
                {"id":"1f959", "class":"emoji", "code":"&#x1f959;"},
                {"id":"1f32e", "class":"emoji", "code":"&#x1f32e;"},
                {"id":"1f32f", "class":"emoji", "code":"&#x1f32f;"},
                {"id":"1f35c", "class":"emoji", "code":"&#x1f35c;"},
                {"id":"1f958", "class":"emoji", "code":"&#x1f958;"},
                {"id":"1f372", "class":"emoji", "code":"&#x1f372;"},
                {"id":"1f96b", "class":"emoji", "code":"&#x1f96b;"},
                {"id":"1f365", "class":"emoji", "code":"&#x1f365;"},
                {"id":"1f363", "class":"emoji", "code":"&#x1f363;"},
                {"id":"1f371", "class":"emoji", "code":"&#x1f371;"},
                {"id":"1f35b", "class":"emoji", "code":"&#x1f35b;"},
                {"id":"1f359", "class":"emoji", "code":"&#x1f359;"},
                {"id":"1f35a", "class":"emoji", "code":"&#x1f35a;"},
                {"id":"1f358", "class":"emoji", "code":"&#x1f358;"},
                {"id":"1f95f", "class":"emoji", "code":"&#x1f95f;"},
                {"id":"1f362", "class":"emoji", "code":"&#x1f362;"},
                {"id":"1f361", "class":"emoji", "code":"&#x1f361;"},
                {"id":"1f367", "class":"emoji", "code":"&#x1f367;"},
                {"id":"1f368", "class":"emoji", "code":"&#x1f368;"},
                {"id":"1f366", "class":"emoji", "code":"&#x1f366;"},
                {"id":"1f370", "class":"emoji", "code":"&#x1f370;"},
                {"id":"1f382", "class":"emoji", "code":"&#x1f382;"},
                {"id":"1f967", "class":"emoji", "code":"&#x1f967;"},
                {"id":"1f36e", "class":"emoji", "code":"&#x1f36e;"},
                {"id":"1f36d", "class":"emoji", "code":"&#x1f36d;"},
                {"id":"1f36c", "class":"emoji", "code":"&#x1f36c;"},
                {"id":"1f36b", "class":"emoji", "code":"&#x1f36b;"},
                {"id":"1f37f", "class":"emoji", "code":"&#x1f37f;"},
                {"id":"1f369", "class":"emoji", "code":"&#x1f369;"},
                {"id":"1f36a", "class":"emoji", "code":"&#x1f36a;"},
                {"id":"1f960", "class":"emoji", "code":"&#x1f960;"},
                {"id":"2615", "class":"emoji", "code":"&#x2615;"},
                {"id":"1f375", "class":"emoji", "code":"&#x1f375;"},
                {"id":"1f963", "class":"emoji", "code":"&#x1f963;"},
                {"id":"1f37c", "class":"emoji", "code":"&#x1f37c;"},
                {"id":"1f964", "class":"emoji", "code":"&#x1f964;"},
                {"id":"1f95b", "class":"emoji", "code":"&#x1f95b;"},
                {"id":"1f37a", "class":"emoji", "code":"&#x1f37a;"},
                {"id":"1f37b", "class":"emoji", "code":"&#x1f37b;"},
                {"id":"1f377", "class":"emoji", "code":"&#x1f377;"},
                {"id":"1f942", "class":"emoji", "code":"&#x1f942;"},
                {"id":"1f943", "class":"emoji", "code":"&#x1f943;"},
                {"id":"1f378", "class":"emoji", "code":"&#x1f378;"},
                {"id":"1f379", "class":"emoji", "code":"&#x1f379;"},
                {"id":"1f37e", "class":"emoji", "code":"&#x1f37e;"},
                {"id":"1f376", "class":"emoji", "code":"&#x1f376;"},
                {"id":"1f944", "class":"emoji", "code":"&#x1f944;"},
                {"id":"1f374", "class":"emoji", "code":"&#x1f374;"},
                {"id":"1f37d", "class":"emoji", "code":"&#x1f37d;"},
                {"id":"1f962", "class":"emoji", "code":"&#x1f962;"},
                {"id":"1f961", "class":"emoji", "code":"&#x1f961;"}
            ]
        },
        // Emoji Activity & Sports Codes
        'nep_activity_sports' : {
            'name' : nep_plugin_vars.nep_activity_sports,
            'codes' : [
                {"id":"26bd", "class":"emoji", "code":"&#x26bd;"},
                {"id":"1f3c0", "class":"emoji", "code":"&#x1f3c0;"},
                {"id":"1f3c8", "class":"emoji", "code":"&#x1f3c8;"},
                {"id":"26be", "class":"emoji", "code":"&#x26be;"},
                {"id":"1f3be", "class":"emoji", "code":"&#x1f3be;"},
                {"id":"1f3d0", "class":"emoji", "code":"&#x1f3d0;"},
                {"id":"1f3c9", "class":"emoji", "code":"&#x1f3c9;"},
                {"id":"1f3b1", "class":"emoji", "code":"&#x1f3b1;"},
                {"id":"1f3d3", "class":"emoji", "code":"&#x1f3d3;"},
                {"id":"1f3f8", "class":"emoji", "code":"&#x1f3f8;"},
                {"id":"1f945", "class":"emoji", "code":"&#x1f945;"},
                {"id":"1f3d2", "class":"emoji", "code":"&#x1f3d2;"},
                {"id":"1f3d1", "class":"emoji", "code":"&#x1f3d1;"},
                {"id":"1f3cf", "class":"emoji", "code":"&#x1f3cf;"},
                {"id":"1f94c", "class":"emoji", "code":"&#x1f94c;"},
                {"id":"26f3", "class":"emoji", "code":"&#x26f3;"},
                {"id":"1f3f9", "class":"emoji", "code":"&#x1f3f9;"},
                {"id":"1f3a3", "class":"emoji", "code":"&#x1f3a3;"},
                {"id":"1f94a", "class":"emoji", "code":"&#x1f94a;"},
                {"id":"1f94b", "class":"emoji", "code":"&#x1f94b;"},
                {"id":"26f8", "class":"emoji", "code":"&#x26f8;"},
                {"id":"1f3bf", "class":"emoji", "code":"&#x1f3bf;"},
                {"id":"1f6f7", "class":"emoji", "code":"&#x1f6f7;"},
                {"id":"26f7", "class":"emoji", "code":"&#x26f7;"},
                {"id":"1f3c2", "class":"emoji", "code":"&#x1f3c2;"},
                {"id":"1f3cb-fe0f-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f3cb&#xfe0f&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cb", "class":"emoji_yellow nep_tone", "code":"&#x1f3cb;"},
                {"id":"1f3cb-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f3cb&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cb-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f3cb&#x1f3fb;"},
                {"id":"1f3cb-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f3cb&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cb-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f3cb&#x1f3fc;"},
                {"id":"1f3cb-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3cb&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cb-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3cb&#x1f3fd;"},
                {"id":"1f3cb-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3cb&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cb-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3cb&#x1f3fe;"},
                {"id":"1f3cb-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f3cb&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cb-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f3cb&#x1f3ff;"},
                {"id":"1f93a", "class":"emoji", "code":"&#x1f93a;"},
                {"id":"1f93c-200d-2640-fe0f", "class":"emoji", "code":"&#x1f93c&#x200d&#x2640&#xfe0f;"},
                {"id":"1f93c", "class":"emoji", "code":"&#x1f93c;"},
                {"id":"1f938", "class":"emoji_yellow nep_tone", "code":"&#x1f938;"},
                {"id":"1f938-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f938&#x200d&#x2642&#xfe0f;"},
                {"id":"26f9-fe0f-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x26f9&#xfe0f&#x200d&#x2640&#xfe0f;"},
                {"id":"26f9", "class":"emoji_yellow nep_tone", "code":"&#x26f9;"},
                {"id":"1f93e", "class":"emoji_yellow nep_tone", "code":"&#x1f93e;"},
                {"id":"1f93e-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f93e&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d7-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9d7&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d7-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9d7&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3cc-fe0f-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f3cc&#xfe0f&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cc", "class":"emoji_yellow nep_tone", "code":"&#x1f3cc;"},
                {"id":"1f9d8-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9d8&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d8-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9d8&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d6-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9d6&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d6-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f9d6&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3c4-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f3c4&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c4-200d-2642-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f3c4&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3ca-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f3ca&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3ca", "class":"emoji_yellow nep_tone", "code":"&#x1f3ca;"},
                {"id":"1f93d-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f93d&#x200d&#x2640&#xfe0f;"},
                {"id":"1f93d", "class":"emoji_yellow nep_tone", "code":"&#x1f93d;"},
                {"id":"1f6a3-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f6a3&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6a3", "class":"emoji_yellow nep_tone", "code":"&#x1f6a3;"},
                {"id":"1f3c7", "class":"emoji_yellow nep_tone", "code":"&#x1f3c7;"},
                {"id":"1f6b4-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f6b4&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b4", "class":"emoji_yellow nep_tone", "code":"&#x1f6b4;"},
                {"id":"1f6b5-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f6b5&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b5", "class":"emoji_yellow nep_tone", "code":"&#x1f6b5;"},
                {"id":"1f938-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f938&#x1f3fb;"},
                {"id":"1f938-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f938&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"26f9-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x26f9&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"26f9-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x26f9&#x1f3fb;"},
                {"id":"1f93e-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f93e&#x1f3fb;"},
                {"id":"1f93e-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f93e&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d7-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9d7&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d7-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9d7&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3cc-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f3cc&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cc-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f3cc&#x1f3fb;"},
                {"id":"1f9d8-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9d8&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d8-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9d8&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d6-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9d6&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d6-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f9d6&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3c4-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f3c4&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c4-1f3fb-200d-2642-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f3c4&#x1f3fb&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3ca-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f3ca&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3ca-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f3ca&#x1f3fb;"},
                {"id":"1f93d-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f93d&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f93d-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f93d&#x1f3fb;"},
                {"id":"1f6a3-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f6a3&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6a3-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f6a3&#x1f3fb;"},
                {"id":"1f3c7-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f3c7&#x1f3fb;"},
                {"id":"1f6b4-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f6b4&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b4-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f6b4&#x1f3fb;"},
                {"id":"1f6b5-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f6b5&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b5-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f6b5&#x1f3fb;"},
                {"id":"1f938-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f938&#x1f3fc;"},
                {"id":"1f938-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f938&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"26f9-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x26f9&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"26f9-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x26f9&#x1f3fc;"},
                {"id":"1f93e-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f93e&#x1f3fc;"},
                {"id":"1f93e-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f93e&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d7-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9d7&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d7-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9d7&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3cc-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f3cc&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cc-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f3cc&#x1f3fc;"},
                {"id":"1f9d8-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9d8&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d8-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9d8&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d6-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9d6&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d6-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f9d6&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3c4-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f3c4&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c4-1f3fc-200d-2642-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f3c4&#x1f3fc&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3ca-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f3ca&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3ca-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f3ca&#x1f3fc;"},
                {"id":"1f93d-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f93d&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f93d-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f93d&#x1f3fc;"},
                {"id":"1f6a3-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f6a3&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6a3-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f6a3&#x1f3fc;"},
                {"id":"1f3c7-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f3c7&#x1f3fc;"},
                {"id":"1f6b4-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f6b4&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b4-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f6b4&#x1f3fc;"},
                {"id":"1f6b5-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f6b5&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b5-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f6b5&#x1f3fc;"},
                {"id":"1f938-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f938&#x1f3fd;"},
                {"id":"1f938-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f938&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"26f9-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x26f9&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"26f9-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x26f9&#x1f3fd;"},
                {"id":"1f93e-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f93e&#x1f3fd;"},
                {"id":"1f93e-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f93e&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d7-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d7&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d7-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d7&#x1f3fd&#x200d&#x2642&#xfe0f;"},

                {"id":"1f3cc-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3cc&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cc-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3cc&#x1f3fd;"},
                {"id":"1f9d8-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d8&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d8-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d8&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d6-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d6&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d6-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f9d6&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3c4-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3c4&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c4-1f3fd-200d-2642-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3c4&#x1f3fd&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3ca-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3ca&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3ca-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3ca&#x1f3fd;"},
                {"id":"1f93d-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f93d&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f93d-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f93d&#x1f3fd;"},
                {"id":"1f6a3-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f6a3&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6a3-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f6a3&#x1f3fd;"},
                {"id":"1f3c7-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f3c7&#x1f3fd;"},
                {"id":"1f6b4-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f6b4&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b4-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f6b4&#x1f3fd;"},
                {"id":"1f6b5-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f6b5&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b5-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f6b5&#x1f3fd;"},
                {"id":"1f938-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f938&#x1f3fe;"},
                {"id":"1f938-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f938&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"26f9-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x26f9&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"26f9-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x26f9&#x1f3fe;"},
                {"id":"1f93e-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f93e&#x1f3fe;"},
                {"id":"1f93e-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f93e&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d7-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d7&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d7-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d7&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3cc-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3cc&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cc-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3cc&#x1f3fe;"},
                {"id":"1f9d8-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d8&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d8-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d8&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d6-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d6&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d6-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f9d6&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3c4-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3c4&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c4-1f3fe-200d-2642-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3c4&#x1f3fe&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3ca-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3ca&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3ca-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3ca&#x1f3fe;"},
                {"id":"1f93d-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f93d&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f93d-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f93d&#x1f3fe;"},
                {"id":"1f6a3-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f6a3&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6a3-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f6a3&#x1f3fe;"},
                {"id":"1f3c7-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f3c7&#x1f3fe;"},
                {"id":"1f6b4-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f6b4&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b4-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f6b4&#x1f3fe;"},
                {"id":"1f6b5-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f6b5&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b5-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f6b5&#x1f3fe;"},
                {"id":"1f938-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f938&#x1f3ff;"},
                {"id":"1f938-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f938&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"26f9-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x26f9&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"26f9-1f3ff", "class":"emoji_black nep_tone", "code":"&#x26f9&#x1f3ff;"},
                {"id":"1f93e-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f93e&#x1f3ff;"},
                {"id":"1f93e-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f93e&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d7-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9d7&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d7-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9d7&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3cc-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f3cc&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3cc-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f3cc&#x1f3ff;"},
                {"id":"1f9d8-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9d8&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d8-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9d8&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f9d6-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9d6&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f9d6-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f9d6&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3c4-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f3c4&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3c4-1f3ff-200d-2642-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f3c4&#x1f3ff&#x200d&#x2642&#xfe0f;"},
                {"id":"1f3ca-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f3ca&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f3ca-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f3ca&#x1f3ff;"},
                {"id":"1f93d-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f93d&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f93d-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f93d&#x1f3ff;"},
                {"id":"1f6a3-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f6a3&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6a3-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f6a3&#x1f3ff;"},
                {"id":"1f3c7-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f3c7&#x1f3ff;"},
                {"id":"1f6b4-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f6b4&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b4-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f6b4&#x1f3ff;"},
                {"id":"1f6b5-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f6b5&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f6b5-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f6b5&#x1f3ff;"},
                {"id":"1f3bd", "class":"emoji", "code":"&#x1f3bd;"},
                {"id":"1f396", "class":"emoji", "code":"&#x1f396;"},
                {"id":"1f3c5", "class":"emoji", "code":"&#x1f3c5;"},
                {"id":"1f947", "class":"emoji", "code":"&#x1f947;"},
                {"id":"1f948", "class":"emoji", "code":"&#x1f948;"},
                {"id":"1f949", "class":"emoji", "code":"&#x1f949;"},
                {"id":"1f3c6", "class":"emoji", "code":"&#x1f3c6;"},
                {"id":"1f3f5", "class":"emoji", "code":"&#x1f3f5;"},
                {"id":"1f397", "class":"emoji", "code":"&#x1f397;"},
                {"id":"1f3ab", "class":"emoji", "code":"&#x1f3ab;"},
                {"id":"1f39f", "class":"emoji", "code":"&#x1f39f;"},
                {"id":"1f3aa", "class":"emoji", "code":"&#x1f3aa;"},
                {"id":"1f939-200d-2640-fe0f", "class":"emoji_yellow nep_tone", "code":"&#x1f939&#x200d&#x2640&#xfe0f;"},
                {"id":"1f939", "class":"emoji_yellow nep_tone", "code":"&#x1f939;"},
                {"id":"1f939-1f3fb-200d-2640-fe0f", "class":"emoji_pale nep_tone", "code":"&#x1f939&#x1f3fb&#x200d&#x2640&#xfe0f;"},
                {"id":"1f939-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f939&#x1f3fb;"},
                {"id":"1f939-1f3fc-200d-2640-fe0f", "class":"emoji_cream nep_tone", "code":"&#x1f939&#x1f3fc&#x200d&#x2640&#xfe0f;"},
                {"id":"1f939-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f939&#x1f3fc;"},
                {"id":"1f939-1f3fd-200d-2640-fe0f", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f939&#x1f3fd&#x200d&#x2640&#xfe0f;"},
                {"id":"1f939-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f939&#x1f3fd;"},
                {"id":"1f939-1f3fe-200d-2640-fe0f", "class":"emoji_dark_brown nep_tone", "code":"&#x1f939&#x1f3fe&#x200d&#x2640&#xfe0f;"},
                {"id":"1f939-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f939&#x1f3fe;"},
                {"id":"1f939-1f3ff-200d-2640-fe0f", "class":"emoji_black nep_tone", "code":"&#x1f939&#x1f3ff&#x200d&#x2640&#xfe0f;"},
                {"id":"1f939-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f939&#x1f3ff;"},
                {"id":"1f3ad", "class":"emoji", "code":"&#x1f3ad;"},
                {"id":"1f3a8", "class":"emoji", "code":"&#x1f3a8;"},
                {"id":"1f3ac", "class":"emoji", "code":"&#x1f3ac;"},
                {"id":"1f3a4", "class":"emoji", "code":"&#x1f3a4;"},
                {"id":"1f3a7", "class":"emoji", "code":"&#x1f3a7;"},
                {"id":"1f3bc", "class":"emoji", "code":"&#x1f3bc;"},
                {"id":"1f3b9", "class":"emoji", "code":"&#x1f3b9;"},
                {"id":"1f941", "class":"emoji", "code":"&#x1f941;"},
                {"id":"1f3b7", "class":"emoji", "code":"&#x1f3b7;"},
                {"id":"1f3ba", "class":"emoji", "code":"&#x1f3ba;"},
                {"id":"1f3b8", "class":"emoji", "code":"&#x1f3b8;"},
                {"id":"1f3bb", "class":"emoji", "code":"&#x1f3bb;"},
                {"id":"1f3b2", "class":"emoji", "code":"&#x1f3b2;"},
                {"id":"1f3af", "class":"emoji", "code":"&#x1f3af;"},
                {"id":"1f3b3", "class":"emoji", "code":"&#x1f3b3;"},
                {"id":"1f3ae", "class":"emoji", "code":"&#x1f3ae;"},
                {"id":"1f47e", "class":"emoji", "code":"&#x1f47e;"},
                {"id":"1f3b0", "class":"emoji", "code":"&#x1f3b0;"}
            ]
        },
        // Emoji Travel & Places Codes
        'nep_travel_places' : {
            'name' : nep_plugin_vars.nep_travel_places,
            'codes' : [
                {"id":"1f697", "class":"emoji", "code":"&#x1f697;"},
                {"id":"1f695", "class":"emoji", "code":"&#x1f695;"},
                {"id":"1f699", "class":"emoji", "code":"&#x1f699;"},
                {"id":"1f68c", "class":"emoji", "code":"&#x1f68c;"},
                {"id":"1f68e", "class":"emoji", "code":"&#x1f68e;"},
                {"id":"1f3ce", "class":"emoji", "code":"&#x1f3ce;"},
                {"id":"1f693", "class":"emoji", "code":"&#x1f693;"},
                {"id":"1f691", "class":"emoji", "code":"&#x1f691;"},
                {"id":"1f692", "class":"emoji", "code":"&#x1f692;"},
                {"id":"1f690", "class":"emoji", "code":"&#x1f690;"},
                {"id":"1f69a", "class":"emoji", "code":"&#x1f69a;"},
                {"id":"1f69b", "class":"emoji", "code":"&#x1f69b;"},
                {"id":"1f69c", "class":"emoji", "code":"&#x1f69c;"},
                {"id":"1f3cd", "class":"emoji", "code":"&#x1f3cd;"},
                {"id":"1f6f5", "class":"emoji", "code":"&#x1f6f5;"},
                {"id":"1f6b2", "class":"emoji", "code":"&#x1f6b2;"},
                {"id":"1f6f4", "class":"emoji", "code":"&#x1f6f4;"},
                {"id":"1f6a8", "class":"emoji", "code":"&#x1f6a8;"},
                {"id":"1f694", "class":"emoji", "code":"&#x1f694;"},
                {"id":"1f68d", "class":"emoji", "code":"&#x1f68d;"},
                {"id":"1f698", "class":"emoji", "code":"&#x1f698;"},
                {"id":"1f696", "class":"emoji", "code":"&#x1f696;"},
                {"id":"1f6a1", "class":"emoji", "code":"&#x1f6a1;"},
                {"id":"1f6a0", "class":"emoji", "code":"&#x1f6a0;"},
                {"id":"1f69f", "class":"emoji", "code":"&#x1f69f;"},
                {"id":"1f683", "class":"emoji", "code":"&#x1f683;"},
                {"id":"1f68b", "class":"emoji", "code":"&#x1f68b;"},
                {"id":"1f69d", "class":"emoji", "code":"&#x1f69d;"},
                {"id":"1f684", "class":"emoji", "code":"&#x1f684;"},
                {"id":"1f685", "class":"emoji", "code":"&#x1f685;"},
                {"id":"1f688", "class":"emoji", "code":"&#x1f688;"},
                {"id":"1f69e", "class":"emoji", "code":"&#x1f69e;"},
                {"id":"1f682", "class":"emoji", "code":"&#x1f682;"},
                {"id":"1f686", "class":"emoji", "code":"&#x1f686;"},
                {"id":"1f687", "class":"emoji", "code":"&#x1f687;"},
                {"id":"1f68a", "class":"emoji", "code":"&#x1f68a;"},
                {"id":"1f689", "class":"emoji", "code":"&#x1f689;"},
                {"id":"1f681", "class":"emoji", "code":"&#x1f681;"},
                {"id":"1f6e9", "class":"emoji", "code":"&#x1f6e9;"},
                {"id":"2708", "class":"emoji", "code":"&#x2708;"},
                {"id":"1f6eb", "class":"emoji", "code":"&#x1f6eb;"},
                {"id":"1f6ec", "class":"emoji", "code":"&#x1f6ec;"},
                {"id":"1f6f6", "class":"emoji", "code":"&#x1f6f6;"},
                {"id":"26f5", "class":"emoji", "code":"&#x26f5;"},
                {"id":"1f6e5", "class":"emoji", "code":"&#x1f6e5;"},
                {"id":"1f6a4", "class":"emoji", "code":"&#x1f6a4;"},
                {"id":"26f4", "class":"emoji", "code":"&#x26f4;"},
                {"id":"1f6f3", "class":"emoji", "code":"&#x1f6f3;"},
                {"id":"1f680", "class":"emoji", "code":"&#x1f680;"},
                {"id":"1f6f8", "class":"emoji", "code":"&#x1f6f8;"},
                {"id":"1f6f0", "class":"emoji", "code":"&#x1f6f0;"},
                {"id":"1f4ba", "class":"emoji", "code":"&#x1f4ba;"},
                {"id":"2693", "class":"emoji", "code":"&#x2693;"},
                {"id":"1f6a7", "class":"emoji", "code":"&#x1f6a7;"},
                {"id":"26fd", "class":"emoji", "code":"&#x26fd;"},
                {"id":"1f68f", "class":"emoji", "code":"&#x1f68f;"},
                {"id":"1f6a6", "class":"emoji", "code":"&#x1f6a6;"},
                {"id":"1f6a5", "class":"emoji", "code":"&#x1f6a5;"},
                {"id":"1f6d1", "class":"emoji", "code":"&#x1f6d1;"},
                {"id":"1f6a2", "class":"emoji", "code":"&#x1f6a2;"},
                {"id":"1f3a1", "class":"emoji", "code":"&#x1f3a1;"},
                {"id":"1f3a2", "class":"emoji", "code":"&#x1f3a2;"},
                {"id":"1f3a0", "class":"emoji", "code":"&#x1f3a0;"},
                {"id":"1f3d7", "class":"emoji", "code":"&#x1f3d7;"},
                {"id":"1f301", "class":"emoji", "code":"&#x1f301;"},
                {"id":"1f5fc", "class":"emoji", "code":"&#x1f5fc;"},
                {"id":"1f3ed", "class":"emoji", "code":"&#x1f3ed;"},
                {"id":"26f2", "class":"emoji", "code":"&#x26f2;"},
                {"id":"1f391", "class":"emoji", "code":"&#x1f391;"},
                {"id":"26f0", "class":"emoji", "code":"&#x26f0;"},
                {"id":"1f3d4", "class":"emoji", "code":"&#x1f3d4;"},
                {"id":"1f5fb", "class":"emoji", "code":"&#x1f5fb;"},
                {"id":"1f30b", "class":"emoji", "code":"&#x1f30b;"},
                {"id":"1f5fe", "class":"emoji", "code":"&#x1f5fe;"},
                {"id":"1f3d5", "class":"emoji", "code":"&#x1f3d5;"},
                {"id":"26fa", "class":"emoji", "code":"&#x26fa;"},
                {"id":"1f3de", "class":"emoji", "code":"&#x1f3de;"},
                {"id":"1f6e3", "class":"emoji", "code":"&#x1f6e3;"},
                {"id":"1f6e4", "class":"emoji", "code":"&#x1f6e4;"},
                {"id":"1f305", "class":"emoji", "code":"&#x1f305;"},
                {"id":"1f304", "class":"emoji", "code":"&#x1f304;"},
                {"id":"1f3dc", "class":"emoji", "code":"&#x1f3dc;"},
                {"id":"1f3d6", "class":"emoji", "code":"&#x1f3d6;"},
                {"id":"1f3dd", "class":"emoji", "code":"&#x1f3dd;"},
                {"id":"1f307", "class":"emoji", "code":"&#x1f307;"},
                {"id":"1f306", "class":"emoji", "code":"&#x1f306;"},
                {"id":"1f3d9", "class":"emoji", "code":"&#x1f3d9;"},
                {"id":"1f303", "class":"emoji", "code":"&#x1f303;"},
                {"id":"1f309", "class":"emoji", "code":"&#x1f309;"},
                {"id":"1f30c", "class":"emoji", "code":"&#x1f30c;"},
                {"id":"1f320", "class":"emoji", "code":"&#x1f320;"},
                {"id":"1f387", "class":"emoji", "code":"&#x1f387;"},
                {"id":"1f386", "class":"emoji", "code":"&#x1f386;"},
                {"id":"1f308", "class":"emoji", "code":"&#x1f308;"},
                {"id":"1f3d8", "class":"emoji", "code":"&#x1f3d8;"},
                {"id":"1f3f0", "class":"emoji", "code":"&#x1f3f0;"},
                {"id":"1f3ef", "class":"emoji", "code":"&#x1f3ef;"},
                {"id":"1f3df", "class":"emoji", "code":"&#x1f3df;"},
                {"id":"1f5fd", "class":"emoji", "code":"&#x1f5fd;"},
                {"id":"1f3e0", "class":"emoji", "code":"&#x1f3e0;"},
                {"id":"1f3e1", "class":"emoji", "code":"&#x1f3e1;"},
                {"id":"1f3da", "class":"emoji", "code":"&#x1f3da;"},
                {"id":"1f3e2", "class":"emoji", "code":"&#x1f3e2;"},
                {"id":"1f3ec", "class":"emoji", "code":"&#x1f3ec;"},
                {"id":"1f3e3", "class":"emoji", "code":"&#x1f3e3;"},
                {"id":"1f3e4", "class":"emoji", "code":"&#x1f3e4;"},
                {"id":"1f3e5", "class":"emoji", "code":"&#x1f3e5;"},
                {"id":"1f3e6", "class":"emoji", "code":"&#x1f3e6;"},
                {"id":"1f3e8", "class":"emoji", "code":"&#x1f3e8;"},
                {"id":"1f3ea", "class":"emoji", "code":"&#x1f3ea;"},
                {"id":"1f3eb", "class":"emoji", "code":"&#x1f3eb;"},
                {"id":"1f3e9", "class":"emoji", "code":"&#x1f3e9;"},
                {"id":"1f492", "class":"emoji", "code":"&#x1f492;"},
                {"id":"1f3db", "class":"emoji", "code":"&#x1f3db;"},
                {"id":"26ea", "class":"emoji", "code":"&#x26ea;"},
                {"id":"1f54c", "class":"emoji", "code":"&#x1f54c;"},
                {"id":"1f54d", "class":"emoji", "code":"&#x1f54d;"},
                {"id":"1f54b", "class":"emoji", "code":"&#x1f54b;"},
                {"id":"26e9", "class":"emoji", "code":"&#x26e9;"}
            ]
        },
        // Emoji Objects Codes
        'nep_objects' : {
            'name' : nep_plugin_vars.nep_objects,
            'codes' : [
                {"id":"231a", "class":"emoji", "code":"&#x231a;"},
                {"id":"1f4f1", "class":"emoji", "code":"&#x1f4f1;"},
                {"id":"1f4f2", "class":"emoji", "code":"&#x1f4f2;"},
                {"id":"1f4bb", "class":"emoji", "code":"&#x1f4bb;"},
                {"id":"2328", "class":"emoji", "code":"&#x2328;"},
                {"id":"1f5a5", "class":"emoji", "code":"&#x1f5a5;"},
                {"id":"1f5a8", "class":"emoji", "code":"&#x1f5a8;"},
                {"id":"1f5b1", "class":"emoji", "code":"&#x1f5b1;"},
                {"id":"1f5b2", "class":"emoji", "code":"&#x1f5b2;"},
                {"id":"1f579", "class":"emoji", "code":"&#x1f579;"},
                {"id":"1f5dc", "class":"emoji", "code":"&#x1f5dc;"},
                {"id":"1f4bd", "class":"emoji", "code":"&#x1f4bd;"},
                {"id":"1f4be", "class":"emoji", "code":"&#x1f4be;"},
                {"id":"1f4bf", "class":"emoji", "code":"&#x1f4bf;"},
                {"id":"1f4c0", "class":"emoji", "code":"&#x1f4c0;"},
                {"id":"1f4fc", "class":"emoji", "code":"&#x1f4fc;"},
                {"id":"1f4f7", "class":"emoji", "code":"&#x1f4f7;"},
                {"id":"1f4f8", "class":"emoji", "code":"&#x1f4f8;"},
                {"id":"1f4f9", "class":"emoji", "code":"&#x1f4f9;"},
                {"id":"1f3a5", "class":"emoji", "code":"&#x1f3a5;"},
                {"id":"1f4fd", "class":"emoji", "code":"&#x1f4fd;"},
                {"id":"1f39e", "class":"emoji", "code":"&#x1f39e;"},
                {"id":"1f4de", "class":"emoji", "code":"&#x1f4de;"},
                {"id":"260e", "class":"emoji", "code":"&#x260e;"},
                {"id":"1f4df", "class":"emoji", "code":"&#x1f4df;"},
                {"id":"1f4e0", "class":"emoji", "code":"&#x1f4e0;"},
                {"id":"1f4fa", "class":"emoji", "code":"&#x1f4fa;"},
                {"id":"1f4fb", "class":"emoji", "code":"&#x1f4fb;"},
                {"id":"1f399", "class":"emoji", "code":"&#x1f399;"},
                {"id":"1f39a", "class":"emoji", "code":"&#x1f39a;"},
                {"id":"1f39b", "class":"emoji", "code":"&#x1f39b;"},
                {"id":"23f1", "class":"emoji", "code":"&#x23f1;"},
                {"id":"23f2", "class":"emoji", "code":"&#x23f2;"},
                {"id":"23f0", "class":"emoji", "code":"&#x23f0;"},
                {"id":"1f570", "class":"emoji", "code":"&#x1f570;"},
                {"id":"23f3", "class":"emoji", "code":"&#x23f3;"},
                {"id":"231b", "class":"emoji", "code":"&#x231b;"},
                {"id":"1f4e1", "class":"emoji", "code":"&#x1f4e1;"},
                {"id":"1f50b", "class":"emoji", "code":"&#x1f50b;"},
                {"id":"1f50c", "class":"emoji", "code":"&#x1f50c;"},
                {"id":"1f4a1", "class":"emoji", "code":"&#x1f4a1;"},
                {"id":"1f526", "class":"emoji", "code":"&#x1f526;"},
                {"id":"1f56f", "class":"emoji", "code":"&#x1f56f;"},
                {"id":"1f5d1", "class":"emoji", "code":"&#x1f5d1;"},
                {"id":"1f6e2", "class":"emoji", "code":"&#x1f6e2;"},
                {"id":"1f6d2", "class":"emoji", "code":"&#x1f6d2;"},
                {"id":"1f4b8", "class":"emoji", "code":"&#x1f4b8;"},
                {"id":"1f4b5", "class":"emoji", "code":"&#x1f4b5;"},
                {"id":"1f4b4", "class":"emoji", "code":"&#x1f4b4;"},
                {"id":"1f4b6", "class":"emoji", "code":"&#x1f4b6;"},
                {"id":"1f4b7", "class":"emoji", "code":"&#x1f4b7;"},
                {"id":"1f4b0", "class":"emoji", "code":"&#x1f4b0;"},
                {"id":"1f4b3", "class":"emoji", "code":"&#x1f4b3;"},
                {"id":"1f48e", "class":"emoji", "code":"&#x1f48e;"},
                {"id":"2696", "class":"emoji", "code":"&#x2696;"},
                {"id":"1f527", "class":"emoji", "code":"&#x1f527;"},
                {"id":"1f528", "class":"emoji", "code":"&#x1f528;"},
                {"id":"2692", "class":"emoji", "code":"&#x2692;"},
                {"id":"1f6e0", "class":"emoji", "code":"&#x1f6e0;"},
                {"id":"26cf", "class":"emoji", "code":"&#x26cf;"},
                {"id":"1f529", "class":"emoji", "code":"&#x1f529;"},
                {"id":"2699", "class":"emoji", "code":"&#x2699;"},
                {"id":"26d3", "class":"emoji", "code":"&#x26d3;"},
                {"id":"1f52b", "class":"emoji", "code":"&#x1f52b;"},
                {"id":"1f4a3", "class":"emoji", "code":"&#x1f4a3;"},
                {"id":"1f52a", "class":"emoji", "code":"&#x1f52a;"},
                {"id":"1f5e1", "class":"emoji", "code":"&#x1f5e1;"},
                {"id":"2694", "class":"emoji", "code":"&#x2694;"},
                {"id":"1f6e1", "class":"emoji", "code":"&#x1f6e1;"},
                {"id":"1f6ac", "class":"emoji", "code":"&#x1f6ac;"},
                {"id":"26b0", "class":"emoji", "code":"&#x26b0;"},
                {"id":"26b1", "class":"emoji", "code":"&#x26b1;"},
                {"id":"1f3fa", "class":"emoji", "code":"&#x1f3fa;"},
                {"id":"1f52e", "class":"emoji", "code":"&#x1f52e;"},
                {"id":"1f4ff", "class":"emoji", "code":"&#x1f4ff;"},
                {"id":"1f488", "class":"emoji", "code":"&#x1f488;"},
                {"id":"2697", "class":"emoji", "code":"&#x2697;"},
                {"id":"1f52d", "class":"emoji", "code":"&#x1f52d;"},
                {"id":"1f52c", "class":"emoji", "code":"&#x1f52c;"},
                {"id":"1f573", "class":"emoji", "code":"&#x1f573;"},
                {"id":"1f48a", "class":"emoji", "code":"&#x1f48a;"},
                {"id":"1f489", "class":"emoji", "code":"&#x1f489;"},
                {"id":"1f321", "class":"emoji", "code":"&#x1f321;"},
                {"id":"1f3f7", "class":"emoji", "code":"&#x1f3f7;"},
                {"id":"1f516", "class":"emoji", "code":"&#x1f516;"},
                {"id":"1f6bd", "class":"emoji", "code":"&#x1f6bd;"},
                {"id":"1f6bf", "class":"emoji", "code":"&#x1f6bf;"},
                {"id":"1f6c1", "class":"emoji", "code":"&#x1f6c1;"},
                {"id":"1f6c0", "class":"emoji_yellow nep_tone", "code":"&#x1f6c0;"},
                {"id":"1f6c0-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f6c0&#x1f3fb;"},
                {"id":"1f6c0-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f6c0&#x1f3fc;"},
                {"id":"1f6c0-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f6c0&#x1f3fd;"},
                {"id":"1f6c0-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f6c0&#x1f3fe;"},
                {"id":"1f6c0-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f6c0&#x1f3ff;"},
                {"id":"1f511", "class":"emoji", "code":"&#x1f511;"},
                {"id":"1f5dd", "class":"emoji", "code":"&#x1f5dd;"},
                {"id":"1f6cb", "class":"emoji", "code":"&#x1f6cb;"},
                {"id":"1f6cc", "class":"emoji_yellow nep_tone", "code":"&#x1f6cc;"},
                {"id":"1f6cc-1f3fb", "class":"emoji_pale nep_tone", "code":"&#x1f6cc&#x1f3fb;"},
                {"id":"1f6cc-1f3fc", "class":"emoji_cream nep_tone", "code":"&#x1f6cc&#x1f3fc;"},
                {"id":"1f6cc-1f3fd", "class":"emoji_moderate_brown nep_tone", "code":"&#x1f6cc&#x1f3fd;"},
                {"id":"1f6cc-1f3fe", "class":"emoji_dark_brown nep_tone", "code":"&#x1f6cc&#x1f3fe;"},
                {"id":"1f6cc-1f3ff", "class":"emoji_black nep_tone", "code":"&#x1f6cc&#x1f3ff;"},
                {"id":"1f6cf", "class":"emoji", "code":"&#x1f6cf;"},
                {"id":"1f6aa", "class":"emoji", "code":"&#x1f6aa;"},
                {"id":"1f6ce", "class":"emoji", "code":"&#x1f6ce;"},
                {"id":"1f5bc", "class":"emoji", "code":"&#x1f5bc;"},
                {"id":"1f5fa", "class":"emoji", "code":"&#x1f5fa;"},
                {"id":"26f1", "class":"emoji", "code":"&#x26f1;"},
                {"id":"1f5ff", "class":"emoji", "code":"&#x1f5ff;"},
                {"id":"1f6cd", "class":"emoji", "code":"&#x1f6cd;"},
                {"id":"1f388", "class":"emoji", "code":"&#x1f388;"},
                {"id":"1f38f", "class":"emoji", "code":"&#x1f38f;"},
                {"id":"1f380", "class":"emoji", "code":"&#x1f380;"},
                {"id":"1f381", "class":"emoji", "code":"&#x1f381;"},
                {"id":"1f38a", "class":"emoji", "code":"&#x1f38a;"},
                {"id":"1f389", "class":"emoji", "code":"&#x1f389;"},
                {"id":"1f38e", "class":"emoji", "code":"&#x1f38e;"},
                {"id":"1f390", "class":"emoji", "code":"&#x1f390;"},
                {"id":"1f3ee", "class":"emoji", "code":"&#x1f3ee;"},
                {"id":"2709", "class":"emoji", "code":"&#x2709;"},
                {"id":"1f4e9", "class":"emoji", "code":"&#x1f4e9;"},
                {"id":"1f4e8", "class":"emoji", "code":"&#x1f4e8;"},
                {"id":"1f4e7", "class":"emoji", "code":"&#x1f4e7;"},
                {"id":"1f48c", "class":"emoji", "code":"&#x1f48c;"},
                {"id":"1f4ee", "class":"emoji", "code":"&#x1f4ee;"},
                {"id":"1f4ea", "class":"emoji", "code":"&#x1f4ea;"},
                {"id":"1f4eb", "class":"emoji", "code":"&#x1f4eb;"},
                {"id":"1f4ec", "class":"emoji", "code":"&#x1f4ec;"},
                {"id":"1f4ed", "class":"emoji", "code":"&#x1f4ed;"},
                {"id":"1f4e6", "class":"emoji", "code":"&#x1f4e6;"},
                {"id":"1f4ef", "class":"emoji", "code":"&#x1f4ef;"},
                {"id":"1f4e5", "class":"emoji", "code":"&#x1f4e5;"},
                {"id":"1f4e4", "class":"emoji", "code":"&#x1f4e4;"},
                {"id":"1f4dc", "class":"emoji", "code":"&#x1f4dc;"},
                {"id":"1f4c3", "class":"emoji", "code":"&#x1f4c3;"},
                {"id":"1f4d1", "class":"emoji", "code":"&#x1f4d1;"},
                {"id":"1f4ca", "class":"emoji", "code":"&#x1f4ca;"},
                {"id":"1f4c8", "class":"emoji", "code":"&#x1f4c8;"},
                {"id":"1f4c9", "class":"emoji", "code":"&#x1f4c9;"},
                {"id":"1f4c4", "class":"emoji", "code":"&#x1f4c4;"},
                {"id":"1f4c5", "class":"emoji", "code":"&#x1f4c5;"},
                {"id":"1f4c6", "class":"emoji", "code":"&#x1f4c6;"},
                {"id":"1f5d3", "class":"emoji", "code":"&#x1f5d3;"},
                {"id":"1f4c7", "class":"emoji", "code":"&#x1f4c7;"},
                {"id":"1f5c3", "class":"emoji", "code":"&#x1f5c3;"},
                {"id":"1f5f3", "class":"emoji", "code":"&#x1f5f3;"},
                {"id":"1f5c4", "class":"emoji", "code":"&#x1f5c4;"},
                {"id":"1f4cb", "class":"emoji", "code":"&#x1f4cb;"},
                {"id":"1f5d2", "class":"emoji", "code":"&#x1f5d2;"},
                {"id":"1f4c1", "class":"emoji", "code":"&#x1f4c1;"},
                {"id":"1f4c2", "class":"emoji", "code":"&#x1f4c2;"},
                {"id":"1f5c2", "class":"emoji", "code":"&#x1f5c2;"},
                {"id":"1f5de", "class":"emoji", "code":"&#x1f5de;"},
                {"id":"1f4f0", "class":"emoji", "code":"&#x1f4f0;"},
                {"id":"1f4d3", "class":"emoji", "code":"&#x1f4d3;"},
                {"id":"1f4d5", "class":"emoji", "code":"&#x1f4d5;"},
                {"id":"1f4d7", "class":"emoji", "code":"&#x1f4d7;"},
                {"id":"1f4d8", "class":"emoji", "code":"&#x1f4d8;"},
                {"id":"1f4d9", "class":"emoji", "code":"&#x1f4d9;"},
                {"id":"1f4d4", "class":"emoji", "code":"&#x1f4d4;"},
                {"id":"1f4d2", "class":"emoji", "code":"&#x1f4d2;"},
                {"id":"1f4da", "class":"emoji", "code":"&#x1f4da;"},
                {"id":"1f4d6", "class":"emoji", "code":"&#x1f4d6;"},
                {"id":"1f517", "class":"emoji", "code":"&#x1f517;"},
                {"id":"1f4ce", "class":"emoji", "code":"&#x1f4ce;"},
                {"id":"1f587", "class":"emoji", "code":"&#x1f587;"},
                {"id":"2702", "class":"emoji", "code":"&#x2702;"},
                {"id":"1f4d0", "class":"emoji", "code":"&#x1f4d0;"},
                {"id":"1f4cf", "class":"emoji", "code":"&#x1f4cf;"},
                {"id":"1f4cc", "class":"emoji", "code":"&#x1f4cc;"},
                {"id":"1f4cd", "class":"emoji", "code":"&#x1f4cd;"},
                {"id":"1f510", "class":"emoji", "code":"&#x1f510;"},
                {"id":"1f512", "class":"emoji", "code":"&#x1f512;"},
                {"id":"1f513", "class":"emoji", "code":"&#x1f513;"},
                {"id":"1f50f", "class":"emoji", "code":"&#x1f50f;"},
                {"id":"1f58a", "class":"emoji", "code":"&#x1f58a;"},
                {"id":"1f58b", "class":"emoji", "code":"&#x1f58b;"},
                {"id":"2712", "class":"emoji", "code":"&#x2712;"},
                {"id":"1f4dd", "class":"emoji", "code":"&#x1f4dd;"},
                {"id":"270f", "class":"emoji", "code":"&#x270f;"},
                {"id":"1f58d", "class":"emoji", "code":"&#x1f58d;"},
                {"id":"1f58c", "class":"emoji", "code":"&#x1f58c;"},
                {"id":"1f50d", "class":"emoji", "code":"&#x1f50d;"},
                {"id":"1f50e", "class":"emoji", "code":"&#x1f50e;"}
            ]
        },
        // Emoji Objects Codes
        'nep_symbols' : {
            'name' : nep_plugin_vars.nep_symbols,
            'codes' : [
                {"id":"2764", "class":"emoji", "code":"&#x2764;"},
                {"id":"1f9e1", "class":"emoji", "code":"&#x1f9e1;"},
                {"id":"1f49b", "class":"emoji", "code":"&#x1f49b;"},
                {"id":"1f49a", "class":"emoji", "code":"&#x1f49a;"},
                {"id":"1f499", "class":"emoji", "code":"&#x1f499;"},
                {"id":"1f49c", "class":"emoji", "code":"&#x1f49c;"},
                {"id":"1f5a4", "class":"emoji", "code":"&#x1f5a4;"},
                {"id":"1f494", "class":"emoji", "code":"&#x1f494;"},
                {"id":"2763", "class":"emoji", "code":"&#x2763;"},
                {"id":"1f495", "class":"emoji", "code":"&#x1f495;"},
                {"id":"1f49e", "class":"emoji", "code":"&#x1f49e;"},
                {"id":"1f493", "class":"emoji", "code":"&#x1f493;"},
                {"id":"1f497", "class":"emoji", "code":"&#x1f497;"},
                {"id":"1f496", "class":"emoji", "code":"&#x1f496;"},
                {"id":"1f498", "class":"emoji", "code":"&#x1f498;"},
                {"id":"1f49d", "class":"emoji", "code":"&#x1f49d;"},
                {"id":"1f49f", "class":"emoji", "code":"&#x1f49f;"},
                {"id":"262e", "class":"emoji", "code":"&#x262e;"},
                {"id":"271d", "class":"emoji", "code":"&#x271d;"},
                {"id":"262a", "class":"emoji", "code":"&#x262a;"},
                {"id":"1f549", "class":"emoji", "code":"&#x1f549;"},
                {"id":"2638", "class":"emoji", "code":"&#x2638;"},
                {"id":"2721", "class":"emoji", "code":"&#x2721;"},
                {"id":"1f52f", "class":"emoji", "code":"&#x1f52f;"},
                {"id":"1f54e", "class":"emoji", "code":"&#x1f54e;"},
                {"id":"262f", "class":"emoji", "code":"&#x262f;"},
                {"id":"2626", "class":"emoji", "code":"&#x2626;"},
                {"id":"1f6d0", "class":"emoji", "code":"&#x1f6d0;"},
                {"id":"26ce", "class":"emoji", "code":"&#x26ce;"},
                {"id":"2648", "class":"emoji", "code":"&#x2648;"},
                {"id":"2649", "class":"emoji", "code":"&#x2649;"},
                {"id":"264a", "class":"emoji", "code":"&#x264a;"},
                {"id":"264b", "class":"emoji", "code":"&#x264b;"},
                {"id":"264c", "class":"emoji", "code":"&#x264c;"},
                {"id":"264d", "class":"emoji", "code":"&#x264d;"},
                {"id":"264e", "class":"emoji", "code":"&#x264e;"},
                {"id":"264f", "class":"emoji", "code":"&#x264f;"},
                {"id":"2650", "class":"emoji", "code":"&#x2650;"},
                {"id":"2651", "class":"emoji", "code":"&#x2651;"},
                {"id":"2652", "class":"emoji", "code":"&#x2652;"},
                {"id":"2653", "class":"emoji", "code":"&#x2653;"},
                {"id":"1f194", "class":"emoji", "code":"&#x1f194;"},
                {"id":"269b", "class":"emoji", "code":"&#x269b;"},
                {"id":"2695", "class":"emoji", "code":"&#x2695;"},
                {"id":"2622", "class":"emoji", "code":"&#x2622;"},
                {"id":"2623", "class":"emoji", "code":"&#x2623;"},
                {"id":"1f4f4", "class":"emoji", "code":"&#x1f4f4;"},
                {"id":"1f4f3", "class":"emoji", "code":"&#x1f4f3;"},
                {"id":"1f236", "class":"emoji", "code":"&#x1f236;"},
                {"id":"1f21a", "class":"emoji", "code":"&#x1f21a;"},
                {"id":"1f238", "class":"emoji", "code":"&#x1f238;"},
                {"id":"1f23a", "class":"emoji", "code":"&#x1f23a;"},
                {"id":"1f237", "class":"emoji", "code":"&#x1f237;"},
                {"id":"2734", "class":"emoji", "code":"&#x2734;"},
                {"id":"1f19a", "class":"emoji", "code":"&#x1f19a;"},
                {"id":"1f251", "class":"emoji", "code":"&#x1f251;"},
                {"id":"1f4ae", "class":"emoji", "code":"&#x1f4ae;"},
                {"id":"1f250", "class":"emoji", "code":"&#x1f250;"},
                {"id":"3299", "class":"emoji", "code":"&#x3299;"},
                {"id":"3297", "class":"emoji", "code":"&#x3297;"},
                {"id":"1f234", "class":"emoji", "code":"&#x1f234;"},
                {"id":"1f235", "class":"emoji", "code":"&#x1f235;"},
                {"id":"1f239", "class":"emoji", "code":"&#x1f239;"},
                {"id":"1f232", "class":"emoji", "code":"&#x1f232;"},
                {"id":"1f170", "class":"emoji", "code":"&#x1f170;"},
                {"id":"1f171", "class":"emoji", "code":"&#x1f171;"},
                {"id":"1f18e", "class":"emoji", "code":"&#x1f18e;"},
                {"id":"1f191", "class":"emoji", "code":"&#x1f191;"},
                {"id":"1f17e", "class":"emoji", "code":"&#x1f17e;"},
                {"id":"1f198", "class":"emoji", "code":"&#x1f198;"},
                {"id":"26d4", "class":"emoji", "code":"&#x26d4;"},
                {"id":"1f4db", "class":"emoji", "code":"&#x1f4db;"},
                {"id":"1f6ab", "class":"emoji", "code":"&#x1f6ab;"},
                {"id":"274c", "class":"emoji", "code":"&#x274c;"},
                {"id":"2b55", "class":"emoji", "code":"&#x2b55;"},
                {"id":"1f4a2", "class":"emoji", "code":"&#x1f4a2;"},
                {"id":"2668", "class":"emoji", "code":"&#x2668;"},
                {"id":"1f6b7", "class":"emoji", "code":"&#x1f6b7;"},
                {"id":"1f6af", "class":"emoji", "code":"&#x1f6af;"},
                {"id":"1f6b3", "class":"emoji", "code":"&#x1f6b3;"},
                {"id":"1f6b1", "class":"emoji", "code":"&#x1f6b1;"},
                {"id":"1f51e", "class":"emoji", "code":"&#x1f51e;"},
                {"id":"1f4f5", "class":"emoji", "code":"&#x1f4f5;"},
                {"id":"1f6ad", "class":"emoji", "code":"&#x1f6ad;"},
                {"id":"2757", "class":"emoji", "code":"&#x2757;"},
                {"id":"2755", "class":"emoji", "code":"&#x2755;"},
                {"id":"2753", "class":"emoji", "code":"&#x2753;"},
                {"id":"2754", "class":"emoji", "code":"&#x2754;"},
                {"id":"203c", "class":"emoji", "code":"&#x203c;"},
                {"id":"2049", "class":"emoji", "code":"&#x2049;"},
                {"id":"1f4af", "class":"emoji", "code":"&#x1f4af;"},
                {"id":"1f505", "class":"emoji", "code":"&#x1f505;"},
                {"id":"1f506", "class":"emoji", "code":"&#x1f506;"},
                {"id":"1f531", "class":"emoji", "code":"&#x1f531;"},
                {"id":"269c", "class":"emoji", "code":"&#x269c;"},
                {"id":"303d", "class":"emoji", "code":"&#x303d;"},
                {"id":"26a0", "class":"emoji", "code":"&#x26a0;"},
                {"id":"1f6b8", "class":"emoji", "code":"&#x1f6b8;"},
                {"id":"1f530", "class":"emoji", "code":"&#x1f530;"},
                {"id":"267b", "class":"emoji", "code":"&#x267b;"},
                {"id":"1f22f", "class":"emoji", "code":"&#x1f22f;"},
                {"id":"1f4b9", "class":"emoji", "code":"&#x1f4b9;"},
                {"id":"2747", "class":"emoji", "code":"&#x2747;"},
                {"id":"2733", "class":"emoji", "code":"&#x2733;"},
                {"id":"274e", "class":"emoji", "code":"&#x274e;"},
                {"id":"2705", "class":"emoji", "code":"&#x2705;"},
                {"id":"1f4a0", "class":"emoji", "code":"&#x1f4a0;"},
                {"id":"1f300", "class":"emoji", "code":"&#x1f300;"},
                {"id":"27bf", "class":"emoji", "code":"&#x27bf;"},
                {"id":"1f310", "class":"emoji", "code":"&#x1f310;"},
                {"id":"24c2", "class":"emoji", "code":"&#x24c2;"},
                {"id":"1f3e7", "class":"emoji", "code":"&#x1f3e7;"},
                {"id":"1f6be", "class":"emoji", "code":"&#x1f6be;"},
                {"id":"267f", "class":"emoji", "code":"&#x267f;"},
                {"id":"1f17f", "class":"emoji", "code":"&#x1f17f;"},
                {"id":"1f233", "class":"emoji", "code":"&#x1f233;"},
                {"id":"1f202", "class":"emoji", "code":"&#x1f202;"},
                {"id":"1f6c2", "class":"emoji", "code":"&#x1f6c2;"},
                {"id":"1f6c3", "class":"emoji", "code":"&#x1f6c3;"},
                {"id":"1f6c4", "class":"emoji", "code":"&#x1f6c4;"},
                {"id":"1f6c5", "class":"emoji", "code":"&#x1f6c5;"},
                {"id":"1f6b0", "class":"emoji", "code":"&#x1f6b0;"},
                {"id":"1f6b9", "class":"emoji", "code":"&#x1f6b9;"},
                {"id":"2642", "class":"emoji", "code":"&#x2642;"},
                {"id":"1f6ba", "class":"emoji", "code":"&#x1f6ba;"},
                {"id":"2640", "class":"emoji", "code":"&#x2640;"},
                {"id":"1f6bc", "class":"emoji", "code":"&#x1f6bc;"},
                {"id":"1f6bb", "class":"emoji", "code":"&#x1f6bb;"},
                {"id":"1f6ae", "class":"emoji", "code":"&#x1f6ae;"},
                {"id":"1f3a6", "class":"emoji", "code":"&#x1f3a6;"},
                {"id":"1f4f6", "class":"emoji", "code":"&#x1f4f6;"},
                {"id":"1f201", "class":"emoji", "code":"&#x1f201;"},
                {"id":"1f196", "class":"emoji", "code":"&#x1f196;"},
                {"id":"1f197", "class":"emoji", "code":"&#x1f197;"},
                {"id":"1f199", "class":"emoji", "code":"&#x1f199;"},
                {"id":"1f192", "class":"emoji", "code":"&#x1f192;"},
                {"id":"1f195", "class":"emoji", "code":"&#x1f195;"},
                {"id":"1f193", "class":"emoji", "code":"&#x1f193;"},
                {"id":"30-20e3", "class":"emoji", "code":"&#x30&#x20e3;"},
                {"id":"31-20e3", "class":"emoji", "code":"&#x31&#x20e3;"},
                {"id":"32-20e3", "class":"emoji", "code":"&#x32&#x20e3;"},
                {"id":"33-20e3", "class":"emoji", "code":"&#x33&#x20e3;"},
                {"id":"34-20e3", "class":"emoji", "code":"&#x34&#x20e3;"},
                {"id":"35-20e3", "class":"emoji", "code":"&#x35&#x20e3;"},
                {"id":"36-20e3", "class":"emoji", "code":"&#x36&#x20e3;"},
                {"id":"37-20e3", "class":"emoji", "code":"&#x37&#x20e3;"},
                {"id":"38-20e3", "class":"emoji", "code":"&#x38&#x20e3;"},
                {"id":"39-20e3", "class":"emoji", "code":"&#x39&#x20e3;"},
                {"id":"1f51f", "class":"emoji", "code":"&#x1f51f;"},
                {"id":"1f522", "class":"emoji", "code":"&#x1f522;"},
                {"id":"25b6", "class":"emoji", "code":"&#x25b6;"},
                {"id":"23f8", "class":"emoji", "code":"&#x23f8;"},
                {"id":"23ef", "class":"emoji", "code":"&#x23ef;"},
                {"id":"23f9", "class":"emoji", "code":"&#x23f9;"},
                {"id":"23fa", "class":"emoji", "code":"&#x23fa;"},
                {"id":"23cf", "class":"emoji", "code":"&#x23cf;"},
                {"id":"23ed", "class":"emoji", "code":"&#x23ed;"},
                {"id":"23ee", "class":"emoji", "code":"&#x23ee;"},
                {"id":"23e9", "class":"emoji", "code":"&#x23e9;"},
                {"id":"23ea", "class":"emoji", "code":"&#x23ea;"},
                {"id":"1f500", "class":"emoji", "code":"&#x1f500;"},
                {"id":"1f501", "class":"emoji", "code":"&#x1f501;"},
                {"id":"1f502", "class":"emoji", "code":"&#x1f502;"},
                {"id":"25c0", "class":"emoji", "code":"&#x25c0;"},
                {"id":"1f53c", "class":"emoji", "code":"&#x1f53c;"},
                {"id":"1f53d", "class":"emoji", "code":"&#x1f53d;"},
                {"id":"23eb", "class":"emoji", "code":"&#x23eb;"},
                {"id":"23ec", "class":"emoji", "code":"&#x23ec;"},
                {"id":"27a1", "class":"emoji", "code":"&#x27a1;"},
                {"id":"2b05", "class":"emoji", "code":"&#x2b05;"},
                {"id":"2b06", "class":"emoji", "code":"&#x2b06;"},
                {"id":"2b07", "class":"emoji", "code":"&#x2b07;"},
                {"id":"2197", "class":"emoji", "code":"&#x2197;"},
                {"id":"2198", "class":"emoji", "code":"&#x2198;"},
                {"id":"2199", "class":"emoji", "code":"&#x2199;"},
                {"id":"2196", "class":"emoji", "code":"&#x2196;"},
                {"id":"2195", "class":"emoji", "code":"&#x2195;"},
                {"id":"1f504", "class":"emoji", "code":"&#x1f504;"},
                {"id":"21aa", "class":"emoji", "code":"&#x21aa;"},
                {"id":"21a9", "class":"emoji", "code":"&#x21a9;"},
                {"id":"1f503", "class":"emoji", "code":"&#x1f503;"},
                {"id":"2934", "class":"emoji", "code":"&#x2934;"},
                {"id":"2935", "class":"emoji", "code":"&#x2935;"},
                {"id":"23-20e3", "class":"emoji", "code":"&#x23&#x20e3;"},
                {"id":"2a-20e3", "class":"emoji", "code":"&#x2a&#x20e3;"},
                {"id":"2139", "class":"emoji", "code":"&#x2139;"},
                {"id":"1f524", "class":"emoji", "code":"&#x1f524;"},
                {"id":"1f521", "class":"emoji", "code":"&#x1f521;"},
                {"id":"1f520", "class":"emoji", "code":"&#x1f520;"},
                {"id":"1f523", "class":"emoji", "code":"&#x1f523;"},
                {"id":"1f3b5", "class":"emoji", "code":"&#x1f3b5;"},
                {"id":"1f3b6", "class":"emoji", "code":"&#x1f3b6;"},
                {"id":"3030", "class":"emoji", "code":"&#x3030;"},
                {"id":"27b0", "class":"emoji", "code":"&#x27b0;"},
                {"id":"2714", "class":"emoji", "code":"&#x2714;"},
                {"id":"2795", "class":"emoji", "code":"&#x2795;"},
                {"id":"2796", "class":"emoji", "code":"&#x2796;"},
                {"id":"2797", "class":"emoji", "code":"&#x2797;"},
                {"id":"2716", "class":"emoji", "code":"&#x2716;"},
                {"id":"1f4b2", "class":"emoji", "code":"&#x1f4b2;"},
                {"id":"1f4b1", "class":"emoji", "code":"&#x1f4b1;"},
                {"id":"1f51a", "class":"emoji", "code":"&#x1f51a;"},
                {"id":"1f519", "class":"emoji", "code":"&#x1f519;"},
                {"id":"1f51b", "class":"emoji", "code":"&#x1f51b;"},
                {"id":"1f51d", "class":"emoji", "code":"&#x1f51d;"},
                {"id":"1f51c", "class":"emoji", "code":"&#x1f51c;"},
                {"id":"2611", "class":"emoji", "code":"&#x2611;"},
                {"id":"1f518", "class":"emoji", "code":"&#x1f518;"},
                {"id":"26aa", "class":"emoji", "code":"&#x26aa;"},
                {"id":"26ab", "class":"emoji", "code":"&#x26ab;"},
                {"id":"1f534", "class":"emoji", "code":"&#x1f534;"},
                {"id":"1f535", "class":"emoji", "code":"&#x1f535;"},
                {"id":"1f538", "class":"emoji", "code":"&#x1f538;"},
                {"id":"1f539", "class":"emoji", "code":"&#x1f539;"},
                {"id":"1f536", "class":"emoji", "code":"&#x1f536;"},
                {"id":"1f537", "class":"emoji", "code":"&#x1f537;"},
                {"id":"1f53a", "class":"emoji", "code":"&#x1f53a;"},
                {"id":"25aa", "class":"emoji", "code":"&#x25aa;"},
                {"id":"25ab", "class":"emoji", "code":"&#x25ab;"},
                {"id":"2b1b", "class":"emoji", "code":"&#x2b1b;"},
                {"id":"2b1c", "class":"emoji", "code":"&#x2b1c;"},
                {"id":"1f53b", "class":"emoji", "code":"&#x1f53b;"},
                {"id":"25fc", "class":"emoji", "code":"&#x25fc;"},
                {"id":"25fb", "class":"emoji", "code":"&#x25fb;"},
                {"id":"25fe", "class":"emoji", "code":"&#x25fe;"},
                {"id":"25fd", "class":"emoji", "code":"&#x25fd;"},
                {"id":"1f532", "class":"emoji", "code":"&#x1f532;"},
                {"id":"1f533", "class":"emoji", "code":"&#x1f533;"},
                {"id":"1f508", "class":"emoji", "code":"&#x1f508;"},
                {"id":"1f509", "class":"emoji", "code":"&#x1f509;"},
                {"id":"1f50a", "class":"emoji", "code":"&#x1f50a;"},
                {"id":"1f507", "class":"emoji", "code":"&#x1f507;"},
                {"id":"1f4e3", "class":"emoji", "code":"&#x1f4e3;"},
                {"id":"1f4e2", "class":"emoji", "code":"&#x1f4e2;"},
                {"id":"1f514", "class":"emoji", "code":"&#x1f514;"},
                {"id":"1f515", "class":"emoji", "code":"&#x1f515;"},
                {"id":"1f0cf", "class":"emoji", "code":"&#x1f0cf;"},
                {"id":"1f004", "class":"emoji", "code":"&#x1f004;"},
                {"id":"1f3b4", "class":"emoji", "code":"&#x1f3b4;"},
                {"id":"1f441-200d-1f5e8", "class":"emoji", "code":"&#x1f441&#x200d&#x1f5e8;"},
                {"id":"1f5e8", "class":"emoji", "code":"&#x1f5e8;"},
                {"id":"1f4ad", "class":"emoji", "code":"&#x1f4ad;"},
                {"id":"1f5ef", "class":"emoji", "code":"&#x1f5ef;"},
                {"id":"1f4ac", "class":"emoji", "code":"&#x1f4ac;"},
                {"id":"1f550", "class":"emoji", "code":"&#x1f550;"},
                {"id":"1f551", "class":"emoji", "code":"&#x1f551;"},
                {"id":"1f552", "class":"emoji", "code":"&#x1f552;"},
                {"id":"1f553", "class":"emoji", "code":"&#x1f553;"},
                {"id":"1f554", "class":"emoji", "code":"&#x1f554;"},
                {"id":"1f555", "class":"emoji", "code":"&#x1f555;"},
                {"id":"1f556", "class":"emoji", "code":"&#x1f556;"},
                {"id":"1f557", "class":"emoji", "code":"&#x1f557;"},
                {"id":"1f558", "class":"emoji", "code":"&#x1f558;"},
                {"id":"1f559", "class":"emoji", "code":"&#x1f559;"},
                {"id":"1f55a", "class":"emoji", "code":"&#x1f55a;"},
                {"id":"1f55b", "class":"emoji", "code":"&#x1f55b;"},
                {"id":"1f55c", "class":"emoji", "code":"&#x1f55c;"},
                {"id":"1f55d", "class":"emoji", "code":"&#x1f55d;"},
                {"id":"1f55e", "class":"emoji", "code":"&#x1f55e;"},
                {"id":"1f55f", "class":"emoji", "code":"&#x1f55f;"},
                {"id":"1f560", "class":"emoji", "code":"&#x1f560;"},
                {"id":"1f561", "class":"emoji", "code":"&#x1f561;"},
                {"id":"1f562", "class":"emoji", "code":"&#x1f562;"},
                {"id":"1f563", "class":"emoji", "code":"&#x1f563;"},
                {"id":"1f564", "class":"emoji", "code":"&#x1f564;"},
                {"id":"1f565", "class":"emoji", "code":"&#x1f565;"},
                {"id":"1f566", "class":"emoji", "code":"&#x1f566;"},
                {"id":"1f567", "class":"emoji", "code":"&#x1f567;"}
            ]
        },
        // Emoji Flags Codes
        'nep_flags' : {
            'name' : nep_plugin_vars.nep_flags,
            'codes' : [
                {"id":"1f3f3", "class":"emoji", "code":"&#x1f3f3;"},
                {"id":"1f3f4", "class":"emoji", "code":"&#x1f3f4;"},
                {"id":"1f3c1", "class":"emoji", "code":"&#x1f3c1;"},
                {"id":"1f6a9", "class":"emoji", "code":"&#x1f6a9;"},
                {"id":"1f38c", "class":"emoji", "code":"&#x1f38c;"},
                {"id":"1f3f4-200d-2620-fe0f", "class":"emoji", "code":"&#x1f3f4&#x200d&#x2620&#xfe0f;"},
                {"id":"1f3f3-fe0f-200d-1f308", "class":"emoji", "code":"&#x1f3f3&#xfe0f&#x200d&#x1f308;"},
                {"id":"1f1e6-1f1e8", "class":"emoji", "code":"&#x1f1e6&#x1f1e8;"},
                {"id":"1f1e6-1f1e9", "class":"emoji", "code":"&#x1f1e6&#x1f1e9;"},
                {"id":"1f1e6-1f1ea", "class":"emoji", "code":"&#x1f1e6&#x1f1ea;"},
                {"id":"1f1e6-1f1eb", "class":"emoji", "code":"&#x1f1e6&#x1f1eb;"},
                {"id":"1f1e6-1f1ec", "class":"emoji", "code":"&#x1f1e6&#x1f1ec;"},
                {"id":"1f1e6-1f1ee", "class":"emoji", "code":"&#x1f1e6&#x1f1ee;"},
                {"id":"1f1e6-1f1f1", "class":"emoji", "code":"&#x1f1e6&#x1f1f1;"},
                {"id":"1f1e6-1f1f2", "class":"emoji", "code":"&#x1f1e6&#x1f1f2;"},
                {"id":"1f1e6-1f1f4", "class":"emoji", "code":"&#x1f1e6&#x1f1f4;"},
                {"id":"1f1e6-1f1f6", "class":"emoji", "code":"&#x1f1e6&#x1f1f6;"},
                {"id":"1f1e6-1f1f7", "class":"emoji", "code":"&#x1f1e6&#x1f1f7;"},
                {"id":"1f1e6-1f1f8", "class":"emoji", "code":"&#x1f1e6&#x1f1f8;"},
                {"id":"1f1e6-1f1f9", "class":"emoji", "code":"&#x1f1e6&#x1f1f9;"},
                {"id":"1f1e6-1f1fa", "class":"emoji", "code":"&#x1f1e6&#x1f1fa;"},
                {"id":"1f1e6-1f1fc", "class":"emoji", "code":"&#x1f1e6&#x1f1fc;"},
                {"id":"1f1e6-1f1fd", "class":"emoji", "code":"&#x1f1e6&#x1f1fd;"},
                {"id":"1f1e6-1f1ff", "class":"emoji", "code":"&#x1f1e6&#x1f1ff;"},
                {"id":"1f1e7-1f1e6", "class":"emoji", "code":"&#x1f1e7&#x1f1e6;"},
                {"id":"1f1e7-1f1e7", "class":"emoji", "code":"&#x1f1e7&#x1f1e7;"},
                {"id":"1f1e7-1f1e9", "class":"emoji", "code":"&#x1f1e7&#x1f1e9;"},
                {"id":"1f1e7-1f1ea", "class":"emoji", "code":"&#x1f1e7&#x1f1ea;"},
                {"id":"1f1e7-1f1eb", "class":"emoji", "code":"&#x1f1e7&#x1f1eb;"},
                {"id":"1f1e7-1f1ec", "class":"emoji", "code":"&#x1f1e7&#x1f1ec;"},
                {"id":"1f1e7-1f1ed", "class":"emoji", "code":"&#x1f1e7&#x1f1ed;"},
                {"id":"1f1e7-1f1ee", "class":"emoji", "code":"&#x1f1e7&#x1f1ee;"},
                {"id":"1f1e7-1f1ef", "class":"emoji", "code":"&#x1f1e7&#x1f1ef;"},
                {"id":"1f1e7-1f1f1", "class":"emoji", "code":"&#x1f1e7&#x1f1f1;"},
                {"id":"1f1e7-1f1f2", "class":"emoji", "code":"&#x1f1e7&#x1f1f2;"},
                {"id":"1f1e7-1f1f3", "class":"emoji", "code":"&#x1f1e7&#x1f1f3;"},
                {"id":"1f1e7-1f1f4", "class":"emoji", "code":"&#x1f1e7&#x1f1f4;"},
                {"id":"1f1e7-1f1f6", "class":"emoji", "code":"&#x1f1e7&#x1f1f6;"},
                {"id":"1f1e7-1f1f7", "class":"emoji", "code":"&#x1f1e7&#x1f1f7;"},
                {"id":"1f1e7-1f1f8", "class":"emoji", "code":"&#x1f1e7&#x1f1f8;"},
                {"id":"1f1e7-1f1f9", "class":"emoji", "code":"&#x1f1e7&#x1f1f9;"},
                {"id":"1f1e7-1f1fc", "class":"emoji", "code":"&#x1f1e7&#x1f1fc;"},
                {"id":"1f1e7-1f1fe", "class":"emoji", "code":"&#x1f1e7&#x1f1fe;"},
                {"id":"1f1e7-1f1ff", "class":"emoji", "code":"&#x1f1e7&#x1f1ff;"},
                {"id":"1f1e8-1f1e6", "class":"emoji", "code":"&#x1f1e8&#x1f1e6;"},
                {"id":"1f1e8-1f1e8", "class":"emoji", "code":"&#x1f1e8&#x1f1e8;"},
                {"id":"1f1e8-1f1e9", "class":"emoji", "code":"&#x1f1e8&#x1f1e9;"},
                {"id":"1f1e8-1f1eb", "class":"emoji", "code":"&#x1f1e8&#x1f1eb;"},
                {"id":"1f1e8-1f1ec", "class":"emoji", "code":"&#x1f1e8&#x1f1ec;"},
                {"id":"1f1e8-1f1ed", "class":"emoji", "code":"&#x1f1e8&#x1f1ed;"},
                {"id":"1f1e8-1f1ee", "class":"emoji", "code":"&#x1f1e8&#x1f1ee;"},
                {"id":"1f1e8-1f1f0", "class":"emoji", "code":"&#x1f1e8&#x1f1f0;"},
                {"id":"1f1e8-1f1f1", "class":"emoji", "code":"&#x1f1e8&#x1f1f1;"},
                {"id":"1f1e8-1f1f2", "class":"emoji", "code":"&#x1f1e8&#x1f1f2;"},
                {"id":"1f1e8-1f1f3", "class":"emoji", "code":"&#x1f1e8&#x1f1f3;"},
                {"id":"1f1e8-1f1f4", "class":"emoji", "code":"&#x1f1e8&#x1f1f4;"},
                {"id":"1f1e8-1f1f7", "class":"emoji", "code":"&#x1f1e8&#x1f1f7;"},
                {"id":"1f1e8-1f1fa", "class":"emoji", "code":"&#x1f1e8&#x1f1fa;"},
                {"id":"1f1e8-1f1fb", "class":"emoji", "code":"&#x1f1e8&#x1f1fb;"},
                {"id":"1f1e8-1f1fc", "class":"emoji", "code":"&#x1f1e8&#x1f1fc;"},
                {"id":"1f1e8-1f1fd", "class":"emoji", "code":"&#x1f1e8&#x1f1fd;"},
                {"id":"1f1e8-1f1fe", "class":"emoji", "code":"&#x1f1e8&#x1f1fe;"},
                {"id":"1f1e8-1f1ff", "class":"emoji", "code":"&#x1f1e8&#x1f1ff;"},
                {"id":"1f1e9-1f1ea", "class":"emoji", "code":"&#x1f1e9&#x1f1ea;"},

                {"id":"1f1e9-1f1ef", "class":"emoji", "code":"&#x1f1e9&#x1f1ef;"},
                {"id":"1f1e9-1f1f0", "class":"emoji", "code":"&#x1f1e9&#x1f1f0;"},
                {"id":"1f1e9-1f1f2", "class":"emoji", "code":"&#x1f1e9&#x1f1f2;"},
                {"id":"1f1e9-1f1f4", "class":"emoji", "code":"&#x1f1e9&#x1f1f4;"},
                {"id":"1f1e9-1f1ff", "class":"emoji", "code":"&#x1f1e9&#x1f1ff;"},
                {"id":"1f1ea-1f1e8", "class":"emoji", "code":"&#x1f1ea&#x1f1e8;"},
                {"id":"1f3f4-e0067-e0062-e0065-e006e-e0067-e007f", "class":"emoji", "code":"&#x1f3f4&#xe0067&#xe0062&#xe0065&#xe006e&#xe0067&#xe007f;"},
                {"id":"1f1ea-1f1ea", "class":"emoji", "code":"&#x1f1ea&#x1f1ea;"},
                {"id":"1f1ea-1f1ec", "class":"emoji", "code":"&#x1f1ea&#x1f1ec;"},
                {"id":"1f1ea-1f1ed", "class":"emoji", "code":"&#x1f1ea&#x1f1ed;"},
                {"id":"1f1ea-1f1f7", "class":"emoji", "code":"&#x1f1ea&#x1f1f7;"},
                {"id":"1f1ea-1f1f8", "class":"emoji", "code":"&#x1f1ea&#x1f1f8;"},
                {"id":"1f1ea-1f1f9", "class":"emoji", "code":"&#x1f1ea&#x1f1f9;"},
                {"id":"1f1ea-1f1fa", "class":"emoji", "code":"&#x1f1ea&#x1f1fa;"},
                {"id":"1f1eb-1f1ee", "class":"emoji", "code":"&#x1f1eb&#x1f1ee;"},
                {"id":"1f1eb-1f1ef", "class":"emoji", "code":"&#x1f1eb&#x1f1ef;"},
                {"id":"1f1eb-1f1f0", "class":"emoji", "code":"&#x1f1eb&#x1f1f0;"},
                {"id":"1f1eb-1f1f2", "class":"emoji", "code":"&#x1f1eb&#x1f1f2;"},
                {"id":"1f1eb-1f1f4", "class":"emoji", "code":"&#x1f1eb&#x1f1f4;"},
                {"id":"1f1eb-1f1f7", "class":"emoji", "code":"&#x1f1eb&#x1f1f7;"},
                {"id":"1f1ec-1f1e6", "class":"emoji", "code":"&#x1f1ec&#x1f1e6;"},
                {"id":"1f1ec-1f1e7", "class":"emoji", "code":"&#x1f1ec&#x1f1e7;"},
                {"id":"1f1ec-1f1e9", "class":"emoji", "code":"&#x1f1ec&#x1f1e9;"},
                {"id":"1f1ec-1f1ea", "class":"emoji", "code":"&#x1f1ec&#x1f1ea;"},
                {"id":"1f1ec-1f1eb", "class":"emoji", "code":"&#x1f1ec&#x1f1eb;"},
                {"id":"1f1ec-1f1ec", "class":"emoji", "code":"&#x1f1ec&#x1f1ec;"},
                {"id":"1f1ec-1f1ed", "class":"emoji", "code":"&#x1f1ec&#x1f1ed;"},
                {"id":"1f1ec-1f1ee", "class":"emoji", "code":"&#x1f1ec&#x1f1ee;"},
                {"id":"1f1ec-1f1f1", "class":"emoji", "code":"&#x1f1ec&#x1f1f1;"},
                {"id":"1f1ec-1f1f2", "class":"emoji", "code":"&#x1f1ec&#x1f1f2;"},
                {"id":"1f1ec-1f1f3", "class":"emoji", "code":"&#x1f1ec&#x1f1f3;"},
                {"id":"1f1ec-1f1f5", "class":"emoji", "code":"&#x1f1ec&#x1f1f5;"},
                {"id":"1f1ec-1f1f6", "class":"emoji", "code":"&#x1f1ec&#x1f1f6;"},
                {"id":"1f1ec-1f1f7", "class":"emoji", "code":"&#x1f1ec&#x1f1f7;"},
                {"id":"1f1ec-1f1f8", "class":"emoji", "code":"&#x1f1ec&#x1f1f8;"},
                {"id":"1f1ec-1f1f9", "class":"emoji", "code":"&#x1f1ec&#x1f1f9;"},
                {"id":"1f1ec-1f1fa", "class":"emoji", "code":"&#x1f1ec&#x1f1fa;"},
                {"id":"1f1ec-1f1fc", "class":"emoji", "code":"&#x1f1ec&#x1f1fc;"},
                {"id":"1f1ec-1f1fe", "class":"emoji", "code":"&#x1f1ec&#x1f1fe;"},
                {"id":"1f1ed-1f1f0", "class":"emoji", "code":"&#x1f1ed&#x1f1f0;"},
                {"id":"1f1ed-1f1f3", "class":"emoji", "code":"&#x1f1ed&#x1f1f3;"},
                {"id":"1f1ed-1f1f7", "class":"emoji", "code":"&#x1f1ed&#x1f1f7;"},
                {"id":"1f1ed-1f1f9", "class":"emoji", "code":"&#x1f1ed&#x1f1f9;"},
                {"id":"1f1ed-1f1fa", "class":"emoji", "code":"&#x1f1ed&#x1f1fa;"},
                {"id":"1f1ee-1f1e8", "class":"emoji", "code":"&#x1f1ee&#x1f1e8;"},
                {"id":"1f1ee-1f1e9", "class":"emoji", "code":"&#x1f1ee&#x1f1e9;"},
                {"id":"1f1ee-1f1ea", "class":"emoji", "code":"&#x1f1ee&#x1f1ea;"},
                {"id":"1f1ee-1f1f1", "class":"emoji", "code":"&#x1f1ee&#x1f1f1;"},
                {"id":"1f1ee-1f1f2", "class":"emoji", "code":"&#x1f1ee&#x1f1f2;"},
                {"id":"1f1ee-1f1f3", "class":"emoji", "code":"&#x1f1ee&#x1f1f3;"},
                {"id":"1f1ee-1f1f4", "class":"emoji", "code":"&#x1f1ee&#x1f1f4;"},
                {"id":"1f1ee-1f1f6", "class":"emoji", "code":"&#x1f1ee&#x1f1f6;"},
                {"id":"1f1ee-1f1f7", "class":"emoji", "code":"&#x1f1ee&#x1f1f7;"},
                {"id":"1f1ee-1f1f8", "class":"emoji", "code":"&#x1f1ee&#x1f1f8;"},
                {"id":"1f1ee-1f1f9", "class":"emoji", "code":"&#x1f1ee&#x1f1f9;"},
                {"id":"1f1ef-1f1ea", "class":"emoji", "code":"&#x1f1ef&#x1f1ea;"},
                {"id":"1f1ef-1f1f2", "class":"emoji", "code":"&#x1f1ef&#x1f1f2;"},
                {"id":"1f1ef-1f1f4", "class":"emoji", "code":"&#x1f1ef&#x1f1f4;"},
                {"id":"1f1ef-1f1f5", "class":"emoji", "code":"&#x1f1ef&#x1f1f5;"},
                {"id":"1f1f0-1f1ea", "class":"emoji", "code":"&#x1f1f0&#x1f1ea;"},
                {"id":"1f1f0-1f1ec", "class":"emoji", "code":"&#x1f1f0&#x1f1ec;"},
                {"id":"1f1f0-1f1ed", "class":"emoji", "code":"&#x1f1f0&#x1f1ed;"},
                {"id":"1f1f0-1f1ee", "class":"emoji", "code":"&#x1f1f0&#x1f1ee;"},
                {"id":"1f1f0-1f1f2", "class":"emoji", "code":"&#x1f1f0&#x1f1f2;"},
                {"id":"1f1f0-1f1f3", "class":"emoji", "code":"&#x1f1f0&#x1f1f3;"},
                {"id":"1f1f0-1f1f5", "class":"emoji", "code":"&#x1f1f0&#x1f1f5;"},
                {"id":"1f1f0-1f1f7", "class":"emoji", "code":"&#x1f1f0&#x1f1f7;"},
                {"id":"1f1f0-1f1fc", "class":"emoji", "code":"&#x1f1f0&#x1f1fc;"},
                {"id":"1f1f0-1f1fe", "class":"emoji", "code":"&#x1f1f0&#x1f1fe;"},
                {"id":"1f1f0-1f1ff", "class":"emoji", "code":"&#x1f1f0&#x1f1ff;"},
                {"id":"1f1f1-1f1e6", "class":"emoji", "code":"&#x1f1f1&#x1f1e6;"},
                {"id":"1f1f1-1f1e7", "class":"emoji", "code":"&#x1f1f1&#x1f1e7;"},
                {"id":"1f1f1-1f1e8", "class":"emoji", "code":"&#x1f1f1&#x1f1e8;"},
                {"id":"1f1f1-1f1ee", "class":"emoji", "code":"&#x1f1f1&#x1f1ee;"},
                {"id":"1f1f1-1f1f0", "class":"emoji", "code":"&#x1f1f1&#x1f1f0;"},
                {"id":"1f1f1-1f1f7", "class":"emoji", "code":"&#x1f1f1&#x1f1f7;"},
                {"id":"1f1f1-1f1f8", "class":"emoji", "code":"&#x1f1f1&#x1f1f8;"},
                {"id":"1f1f1-1f1f9", "class":"emoji", "code":"&#x1f1f1&#x1f1f9;"},
                {"id":"1f1f1-1f1fa", "class":"emoji", "code":"&#x1f1f1&#x1f1fa;"},
                {"id":"1f1f1-1f1fb", "class":"emoji", "code":"&#x1f1f1&#x1f1fb;"},
                {"id":"1f1f1-1f1fe", "class":"emoji", "code":"&#x1f1f1&#x1f1fe;"},
                {"id":"1f1f2-1f1e6", "class":"emoji", "code":"&#x1f1f2&#x1f1e6;"},
                {"id":"1f1f2-1f1e8", "class":"emoji", "code":"&#x1f1f2&#x1f1e8;"},
                {"id":"1f1f2-1f1e9", "class":"emoji", "code":"&#x1f1f2&#x1f1e9;"},
                {"id":"1f1f2-1f1ea", "class":"emoji", "code":"&#x1f1f2&#x1f1ea;"},
                {"id":"1f1f2-1f1ec", "class":"emoji", "code":"&#x1f1f2&#x1f1ec;"},
                {"id":"1f1f2-1f1ed", "class":"emoji", "code":"&#x1f1f2&#x1f1ed;"},
                {"id":"1f1f2-1f1f0", "class":"emoji", "code":"&#x1f1f2&#x1f1f0;"},
                {"id":"1f1f2-1f1f1", "class":"emoji", "code":"&#x1f1f2&#x1f1f1;"},
                {"id":"1f1f2-1f1f2", "class":"emoji", "code":"&#x1f1f2&#x1f1f2;"},
                {"id":"1f1f2-1f1f3", "class":"emoji", "code":"&#x1f1f2&#x1f1f3;"},
                {"id":"1f1f2-1f1f4", "class":"emoji", "code":"&#x1f1f2&#x1f1f4;"},
                {"id":"1f1f2-1f1f5", "class":"emoji", "code":"&#x1f1f2&#x1f1f5;"},
                {"id":"1f1f2-1f1f6", "class":"emoji", "code":"&#x1f1f2&#x1f1f6;"},
                {"id":"1f1f2-1f1f7", "class":"emoji", "code":"&#x1f1f2&#x1f1f7;"},
                {"id":"1f1f2-1f1f8", "class":"emoji", "code":"&#x1f1f2&#x1f1f8;"},
                {"id":"1f1f2-1f1f9", "class":"emoji", "code":"&#x1f1f2&#x1f1f9;"},
                {"id":"1f1f2-1f1fa", "class":"emoji", "code":"&#x1f1f2&#x1f1fa;"},
                {"id":"1f1f2-1f1fb", "class":"emoji", "code":"&#x1f1f2&#x1f1fb;"},
                {"id":"1f1f2-1f1fc", "class":"emoji", "code":"&#x1f1f2&#x1f1fc;"},
                {"id":"1f1f2-1f1fd", "class":"emoji", "code":"&#x1f1f2&#x1f1fd;"},
                {"id":"1f1f2-1f1fe", "class":"emoji", "code":"&#x1f1f2&#x1f1fe;"},
                {"id":"1f1f2-1f1ff", "class":"emoji", "code":"&#x1f1f2&#x1f1ff;"},
                {"id":"1f1f3-1f1e6", "class":"emoji", "code":"&#x1f1f3&#x1f1e6;"},
                {"id":"1f1f3-1f1e8", "class":"emoji", "code":"&#x1f1f3&#x1f1e8;"},
                {"id":"1f1f3-1f1ea", "class":"emoji", "code":"&#x1f1f3&#x1f1ea;"},
                {"id":"1f1f3-1f1eb", "class":"emoji", "code":"&#x1f1f3&#x1f1eb;"},
                {"id":"1f1f3-1f1ec", "class":"emoji", "code":"&#x1f1f3&#x1f1ec;"},
                {"id":"1f1f3-1f1ee", "class":"emoji", "code":"&#x1f1f3&#x1f1ee;"},
                {"id":"1f1f3-1f1f1", "class":"emoji", "code":"&#x1f1f3&#x1f1f1;"},
                {"id":"1f1f3-1f1f4", "class":"emoji", "code":"&#x1f1f3&#x1f1f4;"},
                {"id":"1f1f3-1f1f5", "class":"emoji", "code":"&#x1f1f3&#x1f1f5;"},
                {"id":"1f1f3-1f1f7", "class":"emoji", "code":"&#x1f1f3&#x1f1f7;"},
                {"id":"1f1f3-1f1fa", "class":"emoji", "code":"&#x1f1f3&#x1f1fa;"},
                {"id":"1f1f3-1f1ff", "class":"emoji", "code":"&#x1f1f3&#x1f1ff;"},
                {"id":"1f1f4-1f1f2", "class":"emoji", "code":"&#x1f1f4&#x1f1f2;"},
                {"id":"1f1f5-1f1e6", "class":"emoji", "code":"&#x1f1f5&#x1f1e6;"},
                {"id":"1f1f5-1f1ea", "class":"emoji", "code":"&#x1f1f5&#x1f1ea;"},
                {"id":"1f1f5-1f1eb", "class":"emoji", "code":"&#x1f1f5&#x1f1eb;"},
                {"id":"1f1f5-1f1ec", "class":"emoji", "code":"&#x1f1f5&#x1f1ec;"},
                {"id":"1f1f5-1f1ed", "class":"emoji", "code":"&#x1f1f5&#x1f1ed;"},
                {"id":"1f1f5-1f1f0", "class":"emoji", "code":"&#x1f1f5&#x1f1f0;"},
                {"id":"1f1f5-1f1f1", "class":"emoji", "code":"&#x1f1f5&#x1f1f1;"},
                {"id":"1f1f5-1f1f2", "class":"emoji", "code":"&#x1f1f5&#x1f1f2;"},
                {"id":"1f1f5-1f1f3", "class":"emoji", "code":"&#x1f1f5&#x1f1f3;"},
                {"id":"1f1f5-1f1f7", "class":"emoji", "code":"&#x1f1f5&#x1f1f7;"},
                {"id":"1f1f5-1f1f8", "class":"emoji", "code":"&#x1f1f5&#x1f1f8;"},
                {"id":"1f1f5-1f1f9", "class":"emoji", "code":"&#x1f1f5&#x1f1f9;"},
                {"id":"1f1f5-1f1fc", "class":"emoji", "code":"&#x1f1f5&#x1f1fc;"},
                {"id":"1f1f5-1f1fe", "class":"emoji", "code":"&#x1f1f5&#x1f1fe;"},
                {"id":"1f1f6-1f1e6", "class":"emoji", "code":"&#x1f1f6&#x1f1e6;"},
                {"id":"1f1f7-1f1ea", "class":"emoji", "code":"&#x1f1f7&#x1f1ea;"},
                {"id":"1f1f7-1f1f4", "class":"emoji", "code":"&#x1f1f7&#x1f1f4;"},
                {"id":"1f1f7-1f1f8", "class":"emoji", "code":"&#x1f1f7&#x1f1f8;"},
                {"id":"1f1f7-1f1fa", "class":"emoji", "code":"&#x1f1f7&#x1f1fa;"},
                {"id":"1f1f7-1f1fc", "class":"emoji", "code":"&#x1f1f7&#x1f1fc;"},
                {"id":"1f1f8-1f1e6", "class":"emoji", "code":"&#x1f1f8&#x1f1e6;"},
                {"id":"1f3f4-e0067-e0062-e0073-e0063-e0074-e007f", "class":"emoji", "code":"&#x1f3f4&#xe0067&#xe0062&#xe0073&#xe0063&#xe0074&#xe007f;"},
                {"id":"1f1f8-1f1e7", "class":"emoji", "code":"&#x1f1f8&#x1f1e7;"},
                {"id":"1f1f8-1f1e8", "class":"emoji", "code":"&#x1f1f8&#x1f1e8;"},
                {"id":"1f1f8-1f1e9", "class":"emoji", "code":"&#x1f1f8&#x1f1e9;"},
                {"id":"1f1f8-1f1ea", "class":"emoji", "code":"&#x1f1f8&#x1f1ea;"},
                {"id":"1f1f8-1f1ec", "class":"emoji", "code":"&#x1f1f8&#x1f1ec;"},
                {"id":"1f1f8-1f1ed", "class":"emoji", "code":"&#x1f1f8&#x1f1ed;"},
                {"id":"1f1f8-1f1ee", "class":"emoji", "code":"&#x1f1f8&#x1f1ee;"},
                {"id":"1f1f8-1f1f0", "class":"emoji", "code":"&#x1f1f8&#x1f1f0;"},
                {"id":"1f1f8-1f1f1", "class":"emoji", "code":"&#x1f1f8&#x1f1f1;"},
                {"id":"1f1f8-1f1f2", "class":"emoji", "code":"&#x1f1f8&#x1f1f2;"},
                {"id":"1f1f8-1f1f3", "class":"emoji", "code":"&#x1f1f8&#x1f1f3;"},
                {"id":"1f1f8-1f1f4", "class":"emoji", "code":"&#x1f1f8&#x1f1f4;"},
                {"id":"1f1f8-1f1f7", "class":"emoji", "code":"&#x1f1f8&#x1f1f7;"},
                {"id":"1f1f8-1f1f8", "class":"emoji", "code":"&#x1f1f8&#x1f1f8;"},
                {"id":"1f1f8-1f1f9", "class":"emoji", "code":"&#x1f1f8&#x1f1f9;"},
                {"id":"1f1f8-1f1fb", "class":"emoji", "code":"&#x1f1f8&#x1f1fb;"},
                {"id":"1f1f8-1f1fd", "class":"emoji", "code":"&#x1f1f8&#x1f1fd;"},
                {"id":"1f1f8-1f1fe", "class":"emoji", "code":"&#x1f1f8&#x1f1fe;"},
                {"id":"1f1f8-1f1ff", "class":"emoji", "code":"&#x1f1f8&#x1f1ff;"},
                {"id":"1f1f9-1f1e6", "class":"emoji", "code":"&#x1f1f9&#x1f1e6;"},
                {"id":"1f1f9-1f1e8", "class":"emoji", "code":"&#x1f1f9&#x1f1e8;"},
                {"id":"1f1f9-1f1e9", "class":"emoji", "code":"&#x1f1f9&#x1f1e9;"},
                {"id":"1f1f9-1f1eb", "class":"emoji", "code":"&#x1f1f9&#x1f1eb;"},
                {"id":"1f1f9-1f1ec", "class":"emoji", "code":"&#x1f1f9&#x1f1ec;"},
                {"id":"1f1f9-1f1ed", "class":"emoji", "code":"&#x1f1f9&#x1f1ed;"},
                {"id":"1f1f9-1f1ef", "class":"emoji", "code":"&#x1f1f9&#x1f1ef;"},
                {"id":"1f1f9-1f1f0", "class":"emoji", "code":"&#x1f1f9&#x1f1f0;"},
                {"id":"1f1f9-1f1f1", "class":"emoji", "code":"&#x1f1f9&#x1f1f1;"},
                {"id":"1f1f9-1f1f2", "class":"emoji", "code":"&#x1f1f9&#x1f1f2;"},
                {"id":"1f1f9-1f1f3", "class":"emoji", "code":"&#x1f1f9&#x1f1f3;"},
                {"id":"1f1f9-1f1f4", "class":"emoji", "code":"&#x1f1f9&#x1f1f4;"},
                {"id":"1f1f9-1f1f7", "class":"emoji", "code":"&#x1f1f9&#x1f1f7;"},
                {"id":"1f1f9-1f1f9", "class":"emoji", "code":"&#x1f1f9&#x1f1f9;"},
                {"id":"1f1f9-1f1fb", "class":"emoji", "code":"&#x1f1f9&#x1f1fb;"},
                {"id":"1f1f9-1f1fc", "class":"emoji", "code":"&#x1f1f9&#x1f1fc;"},
                {"id":"1f1f9-1f1ff", "class":"emoji", "code":"&#x1f1f9&#x1f1ff;"},
                {"id":"1f1fa-1f1e6", "class":"emoji", "code":"&#x1f1fa&#x1f1e6;"},
                {"id":"1f1fa-1f1ec", "class":"emoji", "code":"&#x1f1fa&#x1f1ec;"},
                {"id":"1f1fa-1f1f3", "class":"emoji", "code":"&#x1f1fa&#x1f1f3;"},
                {"id":"1f1fa-1f1f8", "class":"emoji", "code":"&#x1f1fa&#x1f1f8;"},
                {"id":"1f1fa-1f1fe", "class":"emoji", "code":"&#x1f1fa&#x1f1fe;"},
                {"id":"1f1fa-1f1ff", "class":"emoji", "code":"&#x1f1fa&#x1f1ff;"},
                {"id":"1f1fb-1f1e6", "class":"emoji", "code":"&#x1f1fb&#x1f1e6;"},
                {"id":"1f1fb-1f1e8", "class":"emoji", "code":"&#x1f1fb&#x1f1e8;"},
                {"id":"1f1fb-1f1ea", "class":"emoji", "code":"&#x1f1fb&#x1f1ea;"},
                {"id":"1f1fb-1f1ec", "class":"emoji", "code":"&#x1f1fb&#x1f1ec;"},
                {"id":"1f1fb-1f1ee", "class":"emoji", "code":"&#x1f1fb&#x1f1ee;"},
                {"id":"1f1fb-1f1f3", "class":"emoji", "code":"&#x1f1fb&#x1f1f3;"},
                {"id":"1f1fb-1f1fa", "class":"emoji", "code":"&#x1f1fb&#x1f1fa;"},
                {"id":"1f3f4-e0067-e0062-e0077-e006c-e0073-e007f", "class":"emoji", "code":"&#x1f3f4&#xe0067&#xe0062&#xe0077&#xe006c&#xe0073&#xe007f;"},
                {"id":"1f1fc-1f1eb", "class":"emoji", "code":"&#x1f1fc&#x1f1eb;"},
                {"id":"1f1fc-1f1f8", "class":"emoji", "code":"&#x1f1fc&#x1f1f8;"},
                {"id":"1f1fd-1f1f0", "class":"emoji", "code":"&#x1f1fd&#x1f1f0;"},
                {"id":"1f1fe-1f1ea", "class":"emoji", "code":"&#x1f1fe&#x1f1ea;"},
                {"id":"1f1fe-1f1f9", "class":"emoji", "code":"&#x1f1fe&#x1f1f9;"},
                {"id":"1f1ff-1f1e6", "class":"emoji", "code":"&#x1f1ff&#x1f1e6;"},
                {"id":"1f1ff-1f1f2", "class":"emoji", "code":"&#x1f1ff&#x1f1f2;"},
                {"id":"1f1ff-1f1fc", "class":"emoji", "code":"&#x1f1ff&#x1f1fc;"}
            ]
        }
    };

    // Emojis Tones
    var nep_emojis_tone = {
        'emoji_yellow' : nep_plugin_vars.nep_yellow,
        'emoji_pale' : nep_plugin_vars.nep_pale,
        'emoji_cream' : nep_plugin_vars.nep_cream,
        'emoji_moderate_brown' : nep_plugin_vars.nep_moderate_brown,
        'emoji_dark_brown' : nep_plugin_vars.nep_dark_brown,
        'emoji_black' : nep_plugin_vars.nep_black
    };
    
    // Panel Button Content
    function html_code() {
        var html, active, cat, i = 0, j = 0;

        html = '<div class="nep_container">';
       
            html += '<div class="nep_categories">';
            
                tinymce.each(nep_emoji_list, function(data, category) {                                           
                    active = (i++ === 0)? 'nep_active' : '';
                    if(data.codes.length >= 1){
                        html += '<button type="button" class="' + category + ' nep_scroll ' + active + '" data-target="' + category + '" title="' + data.name + '" tabindex="-1"></button>';
                    }
                });

            html += '</div>';

            html += '<div class="nep_list_picker">';
            
                tinymce.each(nep_emoji_list, function(data, category) {
                    if(data.codes.length >= 1){
                        html += '<div id="' + category +'" class="nep_category">';
                            html += '<h3 class="nep_category_title">' + data.name +'</h3>';
                        html += '</div>';
                    }
                });
            
            html += "</div>";

            html += '<div class="nep_tones_picker">';
                html += '<span class="nep_loading"></span>';
                html += '<button type="button" class="nep_close" tabindex="-1" title="' + nep_plugin_vars.nep_close + '"></button>';
                tinymce.each(nep_emojis_tone, function(name, id) {
                    active = (j++ === 0)? 'nep_active' : '';
                    html += '<button type="button" class="nep_tone_picker nep_' + id + ' ' + active + '" data-target="nep_' + id + '" tabindex="-1" title="' + name+ '"></button>';
                });
                
            html += "</div>";

        html += "</div>";
        
        return html;
    }
    
    // Append emojis after panel is opened
    function emojis_codes(){
        var time = 5, items = 1, max_items = 0;
                    
        tinymce.each(nep_emoji_list, function(data, category) {
            setTimeout(function(){
                var $appended_receptor = $('#' + category);
                max_items += data.codes.length;
                if(data.codes.length >= 1){
                    tinymce.each(data.codes, function(emoji) {
                        setTimeout(function(){                        
                            $appended_receptor.append('<button type="button" id="nep_emoji_' + emoji.id + '" class="nep_insert_emoji nep_' + emoji.class + '" data-code="' + emoji.code + '" data-key="' + emoji.id + '" data-placement="bottom-right" tabindex="-1"><i></i></button>'); 
                            items++;
                            if(max_items === items){
                                $('span.nep_loading').hide();
                            }                               
                        },time);
                        time += 5;
                    });
                }
            },time);
        });
                        
        return this;
    }
    
    // Custom Scroll Event
    function scrollEvent(el){
        el.on('scroll', function(){
            el.trigger('custom-scroll');
        });
    }
    
    // Panel Click Handle
    var has_been_clicked = false;
    
    // Add Panel Button
    editor.addButton('nep_native_emoji', {
        title: nep_plugin_vars.nep_name,
        tooltip: nep_plugin_vars.nep_insert_emoji,
        icon: 'nep_button',
        type: 'panelbutton',
        panel: {
            role: 'application',
            autohide: !0,
            html: html_code(),
            onclick: function(e) { 
                var category = editor.dom.getParent(e.target, '.nep_scroll'),
                    emoji    = editor.dom.getParent(e.target, '.nep_insert_emoji'),
                    tone     = editor.dom.getParent(e.target, '.nep_tone_picker'),
                    close    = editor.dom.getParent(e.target, '.nep_close'),                    
                    target, newOffset, key, eclass;
                
                if(category){
                    target = category.getAttribute('data-target'); 
                    newOffset =	($("#" + target).position().top + $('.nep_list_picker').scrollTop());
                    
                    $('.nep_scroll').removeClass('nep_active');
                    $('.nep_scroll[data-target=' + target + ']').addClass('nep_active');
                    $('.nep_list_picker').scrollTop(newOffset);
                }
                
                if(emoji){
                    key = emoji.getAttribute('data-key');
                    eclass = emoji.getAttribute('class');
                    
                    editor.insertContent(emoji.getAttribute('data-code'));                    
                    if(nep_plugin_vars.nep_close_panel){                        
                        this.hide();
                    } 
                    
                    $.ajax({
                        type: "POST",
                        url: nep_plugin_vars.nep_url + "db.php",
                        dataType:"html", 
                        data: {
                            "class": eclass,
                            "key": key
                        }
                    });
                }
                
                if(tone) {
                    target = tone.getAttribute('data-target');
                    
                    $('.nep_tone_picker').removeClass('nep_active');
                    $('.nep_tone_picker[data-target=' + target + ']').addClass('nep_active');
                    $('.nep_list_picker div:not(#nep_frequently_used) .nep_tone').hide();
                    $('.nep_list_picker div:not(#nep_frequently_used) .' + target).css( 'display', 'inline-block' );
                }
                
                if(close) {
                    this.hide();
                }                                                                
            },            
        },
        onclick: function() {
            if(!has_been_clicked){
                emojis_codes();
                scrollEvent($('.nep_list_picker'));
                has_been_clicked = true;
            }
            
            $(document).on('custom-scroll', '.nep_list_picker', function(){
                var newOffset = $(this).scrollTop();
                $('.nep_category').each(function() {                    
                    var target = $(this).attr( 'id' ),
                        top = ($('#' + target).position().top + $('.nep_list_picker').scrollTop());
                    
					if(newOffset >= top){
						$('.nep_scroll').removeClass('nep_active');
						$(".nep_scroll[data-target="+ target +"]").addClass('nep_active');
					}
                });
            });
        }
    }); 
       
});