<?php declare(strict_types=1); ?>
<div id="multisafepay-support" class="multisafepay-support-information">
    <h2 id="multisafepay-title"><?php echo esc_html__( 'Documentation', 'multisafepay' ); ?></h2>
    <p><?php echo esc_html__( 'Read our documentation for more information about MultiSafepay and how to get started:', 'multisafepay' ); ?></p>
    <ul class="docs-list">
        <li>
            <a target="_blank" href="https://docs.multisafepay.com/docs/second-chance" target="_blank"><?php echo esc_html__( 'Manual', 'multisafepay' ); ?>
        </li>
        <li>
            <a target="_blank" href="https://github.com/MultiSafepay/WooCommerce/blob/master/CHANGELOG.md" target="_blank"><?php echo esc_html__( 'Changelog', 'multisafepay' ); ?></a>
        </li>
        <li>
            <a target="_blank" href="https://docs.multisafepay.com/docs/second-chance#user-guide" target="_blank"><?php echo esc_html__( 'FAQ', 'multisafepay' ); ?></a>
        </li>
    </ul>
    <p><?php echo esc_html__( 'For developers:', 'multisafepay' ); ?></p>
    <ul class="docs-list">
        <li>
            <a target="_blank" href="https://docs.multisafepay.com/reference/introduction" target="_blank"><?php echo esc_html__( 'API Documentation', 'multisafepay' ); ?></a>
        </li>
        <li>
            <a target="_blank" href="https://github.com/MultiSafepay/WooCommerce" target="_blank"><?php echo esc_html__( 'MultiSafepay Github', 'multisafepay' ); ?></a>
        </li>
    </ul>
    <h2 id="multisafepay-title"><?php echo esc_html__( 'Account', 'multisafepay' ); ?></h2>
    <p>
        <?php echo esc_html__( 'To use this plugin you need a MultiSafepay account.', 'multisafepay' ); ?>
    </p>
    <ul class="account-list">
        <li><?php echo esc_html__( 'If you would like to have a clear overview of what MultiSafepay has to offer, feel free to create a ', 'multisafepay' ); ?> <a href="https://testmerchant.multisafepay.com/signup" target="_blank"><?php echo esc_html__( 'test account', 'multisafepay' ); ?></a>.</li>
        <li><?php echo esc_html__( 'If you would like to set up a live account, please contact the MultiSafepay sales department:', 'multisafepay' ); ?>
            <ul  class="multisafepay-sales-contact-list">
                <li><strong><?php echo esc_html__( 'Netherlands:', 'multisafepay' ); ?></strong>
                    <ul>
                        <li>
                            <?php echo esc_html__( 'Telephone:', 'multisafepay' ); ?> <a href="tel:+31208500501">+31 (0)20 - 8500501</a>
                        </li>
                        <li>
                            <?php echo esc_html__( 'E-mail:', 'multisafepay' ); ?> <a href="mailto:sales@multisafepay.com">sales@multisafepay.com</a>
                        </li>
                    </ul>
                </li>
                <li><strong><?php echo esc_html__( 'Belgium:', 'multisafepay' ); ?></strong>
                    <ul>
                        <li>
                            <?php echo esc_html__( 'Telephone:', 'multisafepay' ); ?> <a href="tel:+3238081241">+32 3 808 12 41</a>
                        </li>
                        <li>
                            <?php echo esc_html__( 'E-mail:', 'multisafepay' ); ?> <a href="mailto:sales.belgium@multisafepay.com">sales.belgium@multisafepay.com</a>
                        </li>
                    </ul>
                </li>
                <li><strong><?php echo esc_html__( 'Spain:', 'multisafepay' ); ?></strong>
                    <ul>
                        <li>
                            <?php echo esc_html__( 'Telephone:', 'multisafepay' ); ?> <a href="tel:+34911230486">+34 911 230 486</a>
                        </li>
                        <li>
                            <?php echo esc_html__( 'E-mail:', 'multisafepay' ); ?> <a href="mailto:comercial@multisafepay.es">comercial@multisafepay.es</a>
                        </li>
                    </ul>
                </li>
                <li><strong><?php echo esc_html__( 'Italy', 'multisafepay' ); ?></strong>
                    <ul>
                        <li>
                            <?php echo esc_html__( 'Telephone:', 'multisafepay' ); ?> <a href="tel:+390294750118">+39 02 947 50 118</a>
                        </li>
                        <li>
                            <?php echo esc_html__( 'E-mail:', 'multisafepay' ); ?> <a href="mailto:sales@multisafepay.it">sales@multisafepay.it</a>
                        </li>
                    </ul>
                </li>
            </ul>
        </li>
    </ul>
    <h2 id="multisafepay-title"><?php echo esc_html__( 'Contact', 'multisafepay' ); ?></h2>
    <p>
        <?php echo esc_html__( 'Need assistance? Feel free to contact our Integration Team:', 'multisafepay' ); ?>
    </p>
    <ul class="support-list">
        <li>
            <?php echo esc_html__( 'Telephone:', 'multisafepay' ); ?> <a href="tel:+31208500500">+31 (0)20 - 8500500</a>
        </li>
        <li>
            <?php echo esc_html__( 'E-mail:', 'multisafepay' ); ?> <a href="mailto:integration@multisafepay.com">integration@multisafepay.com</a>
        </li>
    </ul>
</div>
