<?php
if ( ! class_exists( 'MPG_Premium', false ) ) {
	class MPG_Premium {
		function set_basename( $status, $file ) {
		}
		function is_premium() {
			return defined('MPG_PRO_LOADED') && MPG_PRO_LOADED && apply_filters( 'product_mpg_license_status', '' ) === 'valid';
		}
		function can_edit(){
			static $has_more_than_one = null ;
			if ( $has_more_than_one === null ) {
				$has_more_than_one = count( MPG_ProjectModel::get_projects( 2 ) ) > 1;
			}
			if ( ! mpg_app()->is_premium() && $has_more_than_one ) {
				return false;
			}
			return true;
		}
		function get_upgrade_url( $feature = 'unknown' ) {
			return function_exists( 'tsdk_utmify' ) ? tsdk_utmify( tsdk_translate_link( 'https://themeisle.com/plugins/multi-pages-generator/upgrade' ), esc_attr( $feature ) ) : 'https://themeisle.com/plugins/multi-pages-generator/upgrade';
		}
		function is_legacy_user(){
			return get_option('mpg_legacy_user') === 'yes';
		}

		/**
		 * Upgrade notice.
		 */
		function upgrade_notice() {
			echo esc_html__( 'Your current free plan is limited to 1 project and every page generated has a branding label saying &quot;Generated by MPG&quot;. Schedule source import is also a PRO feature.', 'multiple-pages-generator-by-porthas' );
		}

		function get_license_type(){
			// proceed to check the plan only if the license is active.
			if ( ! $this->is_premium() ) {
				return 0;
			}
			$plan     = apply_filters( 'product_mpg_license_plan', 0 );
			$plan     = intval( $plan );
			$plan_map = array(
				1 => 2,
				2 => 2,
				3 => 3,
				4 => 2,
				5 => 2,
				6 => 3,
				7 => 1,
			);
			return $plan_map[ $plan ] ?? 0;
		}
		/**
		 * Method to return the type of licence.
		 *
		 * @param string $type Licence type.
		 *
		 * @access  public
		 * @return bool
		 */
		function is_license_of_type( $type ): bool {
			$plan     = $this->get_license_type(); // get the plan.
			if ( ! $plan ) {
				return false;
			}

			if ( ! in_array( $type, array( 1, 2, 3 ), true ) ) {
				return false;
			}
			return $plan >= $type;

		}

		/**
		 * Get license data.
		 */
		function get_license_data() {
			$option_name = basename( dirname( MPG_BASENAME ) );
			$option_name = str_replace( '-', '_', strtolower( trim( $option_name ) ) );

			return get_option( $option_name . '_license_data' );
		}

		/**
		 * Get the license expiration date.
		 *
		 * @param string $format format of the date.
		 * @return false|string
		 */
		function get_license_expiration_date( $format = 'F Y' ) {
			$data = $this->get_license_data();
			if ( isset( $data->expires ) ) {
				$parsed = date_parse( $data->expires );
				$time   = mktime( $parsed['hour'], $parsed['minute'], $parsed['second'], $parsed['month'], $parsed['day'], $parsed['year'] );
				return gmdate( $format, $time );
			}
			return false;
		}
	}

	function mpg_app() {
		return ( new MPG_Premium() );
	}
}
add_action( 'wp_loaded', function () {
	if ( ! mpg_app()->is_premium() ) {
		add_filter( 'plugin_row_meta', function ( $links_array, $plugin_file_name, $plugin_data, $status ) {

			if ( strpos( $plugin_file_name, basename( MPG_BASENAME ) ) !== false ) {
				$links_array[] = '<a style="color: #dba617;" href="' . mpg_app()->get_upgrade_url('pluginrow') . '">Upgrade</a>';
			}

			return $links_array;
		}, 10, 4 );

		add_action( 'admin_menu',
			function () {
				global $submenu;
				$menu_slug               = "mpg-project-builder";
				$submenu[ $menu_slug ][] = array(
					'<b style="width: calc(100% - 12px); padding: 6px 10px; font-size: 13px;font-weight: 600; line-height: 1; color: rgba(255, 255, 255, 1);border-radius: 3px;background-color: rgba(56, 81, 248, 1);  display: block; text-align: center; " class="left-btn-upgrade">' . esc_html__( 'Upgrade to Pro', 'multiple-pages-generator-by-porthas' ) . '</b>',
					'manage_options',
					mpg_app()->get_upgrade_url('datasetmenu')
				);
			} );
	}
} );
mpg_run();