<form action="" method="post">


    <?php


    if ($all_done) {


        echo sprintf("<h2 style='%s'>%s</h2>", 'color:green',


            esc_html(__('All orders shipped', 'multiparcels-shipping-for-woocommerce')));





        submit_button(__('Download all labels', 'multiparcels-shipping-for-woocommerce'), 'submit', 'print');


    } else {


        submit_button(__('Dispatch orders', 'multiparcels-shipping-for-woocommerce'));


    }


    ?>





    <table class="wp-list-table widefat fixed striped">


        <thead>


        <tr>


            <th>ID</th>


            <th><?php echo esc_html(__('Receiver', 'multiparcels-shipping-for-woocommerce')) ?></th>


            <th><?php echo esc_html(__('Shipping method', 'multiparcels-shipping-for-woocommerce')) ?></th>


            <th><?php echo esc_html(__('Confirmed', 'multiparcels-shipping-for-woocommerce')) ?></th>


            <th></th>


        </tr>


        </thead>


        <tbody>


        <?php foreach ($orders as $order) { ?>


            <tr>


                <td>


                    <a href="<?php echo esc_attr($order['link']); ?>" target="_blank">


                        <?php echo esc_attr($order['id']); ?>


                    </a>


                </td>


                <td><?php echo esc_attr($order['receiver']); ?></td>


                <td><?php echo esc_html($order['shipping_method']); ?></td>


                <td>


                    <span style="<?php echo esc_attr($order['confirmed_style']) ?>">


                        <?php


                        echo esc_attr($order['confirmed']);


                        ?>


                    </span>


                </td>


                <td>


                    <ul style="color: red;">


                        <?php


                        foreach ($order['errors'] as $error) {

                            // Suppress PHPCS warning for unescaped output (base64-encoded binary data)
                            // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                            echo sprintf("<li>%s</li>", $error);


                        }


                        ?>


                    </ul>


                </td>


            </tr>


        <?php } ?>


        </tbody>


    </table>


    <?php


    if ( ! $all_done) {


        submit_button(__('Dispatch orders', 'multiparcels-shipping-for-woocommerce'));


    }


    ?>


</form>





