<?php

/**

 * Plugin Name: MultiParcels Shipping For WooCommerce

 * Description: Easiest, fastest and the cheapest way to integrate couriers with all deliveries methods to send parcels with just a few button clicks.

 * Version: 1.30.12

 * Author: MultiParcels

 * Author URI: https://noparcels.com

 * WC tested up to: 10.2.2

 * WC requires at least: 3.0.0

 *

 * Text Domain: multiparcels-shipping-for-woocommerce

 * Domain Path: /languages/

 */



// If this file is called directly, abort.

if ( ! defined('ABSPATH')) {

    die;

}

/**

 * Class MultiParcels

 *

 * @todo wp dashboard widget with un shipped order

 * @todo woocommerce menu - below orders - add un dispatched orders with count

 * @todo send uninstall message to multiparcels

 * @todo radio select for customer if there are 3 or less pickup locations in their city

 * @todo add tracking

 * @todo after shipment delivery - send email with questions about the order and to rate it, leave comments

 * @todo if woocommerce_shipping_debug_mode is enabled - display information about our shipping methods(why it is not showing up for customers etc.)

 * @todo add quickstart guide

 * @todo add minimum cart price and maximum cart price for shipping methods(like minimum weight/maximum weight)

 * @todo all products/categories that do not fit in pickup locations in admin

 */

use Automattic\WooCommerce\Internal\DataStores\Orders\CustomOrdersTableController;
use Automattic\WooCommerce\Utilities\OrderUtil;
class MultiParcels

{

    /**

     * The single instance of the class.

     *

     * @var MultiParcels

     * @since 0.1

     */

    protected static $_instance;



    /** @var string */

    public $version = '1.30.12';



    /** @var MP_Options */

    public $options;



    /** @var MP_Api_Client */

    public $api_client;



    /** @var MP_Locations */

    public $locations;



    /** @var MP_Carriers */

    public $carriers;



    /** @var MP_Permissions */

    public $permissions;



    /** @var MultiParcels_Services */

    public $services;



    /** @var MultiParcels_Delivery_Shippings */

    public $shippings;



    /** @var MultiParcels_Carrier_Selections */

    public $carrier_selections;



    /** @var MultiParcels_Helper */

    public $helper;



    /** @var string */

    public $contact_email = 'hello@multiparcels.com';



    /** @var string */

    public $plugin_title = 'MultiParcels Shipping For WooCommerce';



    /** @var array */

    public $shipping_methods = [];



    /** @var MP_Logger */

    public $logger;



    /** @var MP_Woocommerce */

    public $woocommerce;



    /**

	 * @since 0.1

	 *

	 * @return MultiParcels

	 */

    public static function instance()

    {

        if (is_null(self::$_instance)) {

            self::$_instance = new self();

        }



        return self::$_instance;

    }



	/**

	 * MultiParcels constructor.

	 */

    function __construct()

    {

        $this->load_plugin_textdomain();



        if (get_locale() == 'lt_LT' || get_locale() == 'lt') {

            $this->contact_email = 'labas@multisiuntos.lt';

        }



        include_once 'includes/class-mp-install.php';



        register_activation_hook(__FILE__, ['MP_Install', 'install']);

        register_deactivation_hook(__FILE__, ['MP_Install', 'remove']);



        $this->cron_schedule();



        add_action('plugins_loaded', function () {

            if ($this->version_checks()) {

                $this->plugins_loaded();

            }

        });

        // Handle label serving
        add_action('admin_post_serve_label', 'mp_serve_label');
        add_action('admin_post_nopriv_serve_label', 'mp_serve_label'); // jei turi veikti ir neprisijungusiems

        function mp_serve_label() {
            // Tik prisijungusiems
            if ( ! is_user_logged_in() ) {
                auth_redirect();
                exit;
            }

            // Sanitizuojam failo pavadinimą
            $filename = basename($_GET['file'] ?? '');
            if (!$filename) {
                wp_die('Missing file parameter', 'Error', ['response' => 400]);
            }

            // Kelias iki PDF
            $label_dir = plugin_dir_path(__FILE__) . 'shipments_labels/';
            $filepath = $label_dir . $filename;

            // Patikrinam ar failas egzistuoja
            if ( ! file_exists($filepath) ) {
                wp_die('File not found', 'Error', ['response' => 404]);
            }

            // Išvalom buferį
            while (ob_get_level()) {
                ob_end_clean();
            }

            // Nustatom antraštes
            header('Content-Type: application/pdf');
            header('Content-Disposition: inline; filename="' . $filename . '"');
            header('Content-Length: ' . filesize($filepath));
            header('Accept-Ranges: bytes');
            header('Cache-Control: private, max-age=0, must-revalidate');

            // Spausdinam failą
            readfile($filepath);
            exit;
        }

        add_filter('upgrader_pre_install', 'backup_shipments_labels', 10, 2);
        add_filter('upgrader_post_install', 'restore_shipments_labels', 10, 3);

        function backup_shipments_labels($true, $hook_extra) {
            if (isset($hook_extra['plugin']) && strpos($hook_extra['plugin'], 'tavo-plugino-folderis') !== false) {
                $plugin_dir = WP_PLUGIN_DIR . '/tavo-plugino-folderis/shipments_labels';
                $upload_dir = wp_upload_dir();
                $backup_dir = $upload_dir['basedir'] . '/shipments_labels_backup';

                if (is_dir($plugin_dir)) {
                    wp_mkdir_p($backup_dir);
                    recurse_copy($plugin_dir, $backup_dir);
                }
            }
            return $true;
        }

        function restore_shipments_labels($true, $hook_extra, $result) {
            if (isset($hook_extra['plugin']) && strpos($hook_extra['plugin'], 'tavo-plugino-folderis') !== false) {
                $plugin_dir = WP_PLUGIN_DIR . '/tavo-plugino-folderis/shipments_labels';
                $upload_dir = wp_upload_dir();
                $backup_dir = $upload_dir['basedir'] . '/shipments_labels_backup';

                if (is_dir($backup_dir)) {
                    wp_mkdir_p($plugin_dir);
                    recurse_copy($backup_dir, $plugin_dir);
                    // Išvalyti backup jei reikia
                     rrmdir($backup_dir);
                }
            }
            return $true;
        }

        // Pagalbinė rekursyvi kopijavimo funkcija
        function recurse_copy($src, $dst) {
            $dir = opendir($src);
            @mkdir($dst);
            while(false !== ($file = readdir($dir))) {
                if (($file != '.') && ($file != '..')) {
                    if (is_dir($src . '/' . $file)) {
                        recurse_copy($src . '/' . $file, $dst . '/' . $file);
                    } else {
                        copy($src . '/' . $file, $dst . '/' . $file);
                    }
                }
            }
            closedir($dir);
        }

        // Pagalbinė rekursyvi ištrynimo funkcija
        function rrmdir($dir) {
            if (is_dir($dir)) {
                $objects = scandir($dir);
                foreach ($objects as $object) {
                    if ($object != "." && $object != "..") {
                        if (is_dir($dir. "/" .$object))
                            rrmdir($dir. "/" .$object);
                        else
                            unlink($dir. "/" .$object);
                    }
                }
                rmdir($dir);
            }
        }

//        add_action(
//            'woocommerce_store_api_checkout_update_order_from_request',
//            function( \WC_Order $order, \WP_REST_Request $request ) {
//
////                // Pašaliname billing_address city, jei jis tuščias
////                if (isset($request['billing_address']['city']) && empty($request['billing_address']['city'])) {
////                    unset($request['billing_address']['city']);
////                }
////
////                // Pašaliname billing_address postcode, jei jis tuščias
////                if (isset($request['billing_address']['postcode']) && empty($request['billing_address']['postcode'])) {
////                    unset($request['billing_address']['postcode']);
////                }
////
////                // Pašaliname billing_address address_1, jei jis tuščias
////                if (isset($request['billing_address']['address_1']) && empty($request['billing_address']['address_1'])) {
////                    unset($request['billing_address']['address_1']);
////                }
////
////                // Pašaliname billing_address state, jei jis tuščias
////                if (isset($request['billing_address']['state']) && empty($request['billing_address']['state'])) {
////                    unset($request['billing_address']['state']);
////                }
////
////                // Pašaliname shipping_address city, jei jis tuščias
////                if (isset($request['shipping_address']['city']) && empty($request['shipping_address']['city'])) {
////                    unset($request['shipping_address']['city']);
////                }
////
////                // Pašaliname shipping_address postcode, jei jis tuščias
////                if (isset($request['shipping_address']['postcode']) && empty($request['shipping_address']['postcode'])) {
////                    unset($request['shipping_address']['postcode']);
////                }
////
////                // Pašaliname shipping_address address_1, jei jis tuščias
////                if (isset($request['shipping_address']['address_1']) && empty($request['shipping_address']['address_1'])) {
////                    unset($request['shipping_address']['address_1']);
////                }
////
////                // Pašaliname shipping_address state, jei jis tuščias
////                if (isset($request['shipping_address']['state']) && empty($request['shipping_address']['state'])) {
////                    unset($request['shipping_address']['state']);
////                }
//
//
//                $chosen_shipping_method = WC()->session->get( 'chosen_shipping_methods' )[0];
//
//                $shipping_method = $chosen_shipping_method;
//
//                $check = 'multiparcels_';
//
//                $check1 = false;
//                $check2 = false;
//
//                if (MultiParcels()->options->get_other_setting('checkout', 'enabled')) {
//
//                    // check if MultiParcels shipping
//                    $check1 = substr($shipping_method, 0, strlen($check)) == $check;
//
//                    // check if delivery to terminal or pickup point
//                    $check2 = strpos($shipping_method, WC_MP_Shipping_Method::SUFFIX_PICKUP_POINT) !== false ||
//
//                        strpos($shipping_method, WC_MP_Shipping_Method::SUFFIX_TERMINAL) !== false;
//
//                    if (MultiParcels()->options->get_other_setting('checkout', 'hide_for_local_pickup') && explode(':', $shipping_method)[0] == 'local_pickup') {
//
//                        $check1 = true;
//
//                        $check2 = true;
//
//                    }
//
//                    if ($check1 && $check2) {
//
//                        if (isset($order->billing_state) && empty($request['billing_address']['state'])) {
//                            $order->set_billing_state('-');
//                        }
//
//                        if (isset($order->shipping_state) && empty($request['shipping_address']['state'])) {
//                            $order->set_shipping_state('-');
//                        }
//
//                        if (isset($order->billing_postcode) && empty($request['billing_address']['postcode'])) {
//                            $order->set_billing_postcode('-');
//                        }
//
//                        if (isset($order->shipping_postcode) && empty($request['shipping_address']['postcode'])) {
//                            $order->set_shipping_postcode('-');
//                        }
//
//                        if (isset($order->billing_address_1) && empty($request['billing_address']['address_1'])) {
//                            $order->set_billing_address_1('-');
//                        }
//
//                        if (isset($order->shipping_address_1) && empty($request['shipping_address']['address_1'])) {
//                            $order->set_shipping_address_1('-');
//                        }
//
//                        if (isset($order->billing_city) && empty($request['billing_address']['city'])) {
//                            $order->set_billing_city('-');
//                        }
//
//                        if (isset($order->shipping_city) && empty($request['shipping_address']['city'])) {
//                            $order->set_shipping_city('-');
//                        }
//
//                    }
//                }
//
//
//                $word = "courier";
//                $word2 = "pickup_location";
//                $word_terminal = "terminal";
//                $word_pickup_point = "point";
//                $word_bus_station = 'bus_station';
//                $word_siuntos_autobusais_courier = 'siuntos_autobusais_courier';
//                $multiparcels_pickup_location_value = WC()->session->get( 'multiparcels_pickup_location_value');
//
//                if (str_contains($chosen_shipping_method, $word_siuntos_autobusais_courier)) {
//                    if (!$multiparcels_pickup_location_value) {
//                        wc_add_notice( __("Please select the pickup location", 'multiparcels-shipping-for-woocommerce'), 'error' );
//                    }
//
//                    $carrier = MultiParcels()->carriers->strict_extract_from_method($chosen_shipping_method);
//                    $location = MultiParcels()->locations->get($multiparcels_pickup_location_value, $carrier);
//                    $text = $location['name'] . ' ' . $location['address'] . ' ' . $location['country_code'];
//                    $order->update_meta_data( 'multiparcels_location_identifier_name', $text );
//                    $order->update_meta_data( 'multiparcels_location_identifier', $multiparcels_pickup_location_value );
//                    $order->save();
//
//                    //WC()->session->__unset( 'value' );
//                }
//
//
//                if (strpos($chosen_shipping_method, $word_pickup_point) || strpos($chosen_shipping_method, $word_terminal)) {
//
//                    if (!$multiparcels_pickup_location_value) {
//                        wc_add_notice( __("Please select the pickup location", 'multiparcels-shipping-for-woocommerce'), 'error' );
//                    }
//
//                    global $wpdb;
//
//                    $carrier = MultiParcels()->carriers->strict_extract_from_method($chosen_shipping_method);
//                    $location = MultiParcels()->locations->get($multiparcels_pickup_location_value, $carrier);
//                    if ($carrier == 'siuntos_autobusais') {
//                        $text = $location['name'] . ' ' . $location['address'] . ' ' . $location['country_code'];
//                        $order->update_meta_data( 'multiparcels_location_identifier_name', $text );
//                    }
//
//                    $order->update_meta_data( 'multiparcels_location_identifier', $multiparcels_pickup_location_value );
//                    $order->save();
//
//                    //WC()->session->__unset( 'value' );
//                }elseif(strpos($chosen_shipping_method, $word_bus_station)){
//                    if (!$multiparcels_pickup_location_value) {
//                        wc_add_notice( __("Please select the pickup location", 'multiparcels-shipping-for-woocommerce'), 'error' );
//                    }
//
//                    global $wpdb;
//
//                    $carrier = MultiParcels()->carriers->strict_extract_from_method($chosen_shipping_method);
//                    $location = MultiParcels()->locations->get($multiparcels_pickup_location_value, $carrier);
//                    if ($carrier == 'siuntos_autobusais') {
//                        $text = $location['name'] . ' ' . $location['address'] . ' ' . $location['country_code'];
//                        $order->update_meta_data( 'multiparcels_location_identifier_name', $text );
//                    }
//
//                    $order->update_meta_data( 'multiparcels_location_identifier', $multiparcels_pickup_location_value );
//                    $order->save();
//
//                    //WC()->session->__unset( 'multiparcels_pickup_location_value' );
//                }
//
//                return $order;
//
////                if ($value) {
////
////
////
////                    $chosen_shipping_method = WC()->session->get( 'chosen_shipping_methods' )[0];
////                    $word = "courier";
////
////                    if (!strpos($chosen_shipping_method, $word)) {
////                        if ($value == NULL) {
////                            wc_add_notice( __("Please select the pickup location", 'multiparcels-shipping-for-woocommerce'), 'error' );
////                        }
////                    }
////
////                    global $wpdb;
////
////                    $carrier = MultiParcels()->carriers->strict_extract_from_method($chosen_shipping_method);
////
////                    $location = MultiParcels()->locations->get($value, $carrier);
////
////                    if ($carrier == 'siuntos_autobusais') {
////                        $text = $location['name'] . ' ' . $location['address'] . ' ' . $location['country_code'];
////                        $order->update_meta_data( 'multiparcels_location_identifier_name', $text );
////                    }
////
////
////
////
////                    $order->update_meta_data( 'multiparcels_location_identifier', $value );
////                    $order->save();
////
////                    WC()->session->__unset( 'value' );
////                }
//
//            },
//            10,
//            2
//        );

        add_action( 'woocommerce_new_order', 'my_custom_order_created_action' );

        function my_custom_order_created_action($order_id){

            if(WC()->session) {
                $order = wc_get_order( $order_id );

                $chosen_shipping_method = WC()->session->get( 'chosen_shipping_methods' )[0];

                $shipping_method = $chosen_shipping_method;

                $check = 'multiparcels_';

                $check1 = false;
                $check2 = false;

                if (MultiParcels()->options->get_other_setting('checkout', 'enabled')) {

                    // check if MultiParcels shipping
                    $check1 = substr($shipping_method, 0, strlen($check)) == $check;

                    // check if delivery to terminal or pickup point
                    $check2 = strpos($shipping_method, WC_MP_Shipping_Method::SUFFIX_PICKUP_POINT) !== false ||

                        strpos($shipping_method, WC_MP_Shipping_Method::SUFFIX_TERMINAL) !== false;

                    if (MultiParcels()->options->get_other_setting('checkout', 'hide_for_local_pickup') && explode(':', $shipping_method)[0] == 'local_pickup') {

                        $check1 = true;

                        $check2 = true;

                    }

                    if ($check1 && $check2) {

                        if (isset($order->billing_state) && empty($request['billing_address']['state'])) {
                            $order->set_billing_state('-');
                        }

                        if (isset($order->shipping_state) && empty($request['shipping_address']['state'])) {
                            $order->set_shipping_state('-');
                        }

                        if (isset($order->billing_postcode) && empty($request['billing_address']['postcode'])) {
                            $order->set_billing_postcode('-');
                        }

                        if (isset($order->shipping_postcode) && empty($request['shipping_address']['postcode'])) {
                            $order->set_shipping_postcode('-');
                        }

                        if (isset($order->billing_address_1) && empty($request['billing_address']['address_1'])) {
                            $order->set_billing_address_1('-');
                        }

                        if (isset($order->shipping_address_1) && empty($request['shipping_address']['address_1'])) {
                            $order->set_shipping_address_1('-');
                        }

                        if (isset($order->billing_city) && empty($request['billing_address']['city'])) {
                            $order->set_billing_city('-');
                        }

                        if (isset($order->shipping_city) && empty($request['shipping_address']['city'])) {
                            $order->set_shipping_city('-');
                        }

                    }
                }


                $word = "courier";
                $word2 = "pickup_location";
                $word_terminal = "terminal";
                $word_pickup_point = "point";
                $word_bus_station = 'bus_station';
                $word_siuntos_autobusais_courier = 'siuntos_autobusais_courier';
                $multiparcels_pickup_location_value = WC()->session->get( 'multiparcels_pickup_location_value');

                if (str_contains($chosen_shipping_method, $word_siuntos_autobusais_courier)) {
                    if (!$multiparcels_pickup_location_value) {
                        wc_add_notice( __("Please select the pickup location", 'multiparcels-shipping-for-woocommerce'), 'error' );
                    }

                    $carrier = MultiParcels()->carriers->strict_extract_from_method($chosen_shipping_method);
                    $location = MultiParcels()->locations->get($multiparcels_pickup_location_value, $carrier);
                    $text = $location['name'] . ' ' . $location['address'] . ' ' . $location['country_code'];
                    $order->update_meta_data( 'multiparcels_location_identifier_name', $text );
                    $order->update_meta_data( 'multiparcels_location_identifier', $multiparcels_pickup_location_value );
                    $order->save();

                    //WC()->session->__unset( 'value' );
                }


                if (strpos($chosen_shipping_method, $word_pickup_point) || strpos($chosen_shipping_method, $word_terminal)) {

                    if (!$multiparcels_pickup_location_value) {
                        wc_add_notice( __("Please select the pickup location", 'multiparcels-shipping-for-woocommerce'), 'error' );
                    }

                    global $wpdb;

                    $carrier = MultiParcels()->carriers->strict_extract_from_method($chosen_shipping_method);
                    $location = MultiParcels()->locations->get($multiparcels_pickup_location_value, $carrier);
                    if ($carrier == 'siuntos_autobusais') {
                        $text = $location['name'] . ' ' . $location['address'] . ' ' . $location['country_code'];
                        $order->update_meta_data( 'multiparcels_location_identifier_name', $text );
                    }

                    $order->update_meta_data( 'multiparcels_location_identifier', $multiparcels_pickup_location_value );
                    $order->save();

                    //WC()->session->__unset( 'value' );
                }elseif(strpos($chosen_shipping_method, $word_bus_station)){
                    if (!$multiparcels_pickup_location_value) {
                        wc_add_notice( __("Please select the pickup location", 'multiparcels-shipping-for-woocommerce'), 'error' );
                    }

                    global $wpdb;

                    $carrier = MultiParcels()->carriers->strict_extract_from_method($chosen_shipping_method);
                    $location = MultiParcels()->locations->get($multiparcels_pickup_location_value, $carrier);
                    if ($carrier == 'siuntos_autobusais') {
                        $text = $location['name'] . ' ' . $location['address'] . ' ' . $location['country_code'];
                        $order->update_meta_data( 'multiparcels_location_identifier_name', $text );
                    }

                    $order->update_meta_data( 'multiparcels_location_identifier', $multiparcels_pickup_location_value );
                    $order->save();

                    //WC()->session->__unset( 'multiparcels_pickup_location_value' );
                }

                return $order;
            }
        


        }

        function checkout_blocks_hide_terminal_inputs() {
            $enabled = '0';

            if (MultiParcels()->options->get_other_setting('checkout', 'enabled') || MultiParcels()->options->get_other_setting('checkout', 'hide_for_local_pickup')) {
                $chosen_methods = $_REQUEST['selected_value'];



                if (MultiParcels()->options->get_other_setting('checkout', 'enabled')) {

                    // check if MultiParcels shipping
                    $shipping_method = $chosen_methods;
                    // check if MultiParcels shipping
                    $check1 = substr($shipping_method, 0, strlen($check)) == $check;

                    // check if delivery to terminal or pickup point
                    $check2 = strpos($shipping_method, WC_MP_Shipping_Method::SUFFIX_PICKUP_POINT) !== false ||

                        strpos($shipping_method, WC_MP_Shipping_Method::SUFFIX_TERMINAL) !== false;

                    if (MultiParcels()->options->get_other_setting('checkout', 'hide_for_local_pickup') && explode(':', $shipping_method)[0] == 'local_pickup') {

                        $check1 = true;

                        $check2 = true;

                    }

                    if ($check1 && $check2) {
                        $enabled = '1';
                    }

                }
            }
            // Suppress PHPCS warning for unescaped output (base64-encoded binary data)
            // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            echo $enabled;

            wp_die();
        }

        add_filter( 'woocommerce_default_address_fields' , 'custom_override_default_address_fields' );

        function custom_override_default_address_fields( $address_fields ) {
            if (is_checkout()) {
                if(class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )) {
                    if (OrderUtil::custom_orders_table_usage_is_enabled()) {
                        if (MultiParcels()->options->get_other_setting('checkout', 'enabled') || MultiParcels()->options->get_other_setting('checkout', 'hide_for_local_pickup')) {
                            $chosen_methods = WC()->session->get( 'chosen_shipping_methods' );

                            if (isset($chosen_methods) && is_array($chosen_methods)) {
                                $shipping_method = $chosen_methods[0];

                                $check = 'multiparcels_';

                                $check1 = false;
                                $check2 = false;

                                if (MultiParcels()->options->get_other_setting('checkout', 'enabled')) {
                                    // check if MultiParcels shipping
                                    $check1 = substr($shipping_method, 0, strlen($check)) == $check;

                                    // check if delivery to terminal or pickup point
                                    $check2 = strpos($shipping_method, WC_MP_Shipping_Method::SUFFIX_PICKUP_POINT) !== false ||

                                            strpos($shipping_method, WC_MP_Shipping_Method::SUFFIX_TERMINAL) !== false;

                                    if (MultiParcels()->options->get_other_setting('checkout', 'hide_for_local_pickup') && explode(':', $shipping_method)[0] == 'local_pickup') {

                                        $check1 = true;

                                        $check2 = true;

                                    }

                                    if ($check1 && $check2) {


                                        if (is_plugin_active('woocommerce-payments/woocommerce-payments.php')) {
                                            $address_fields['address_1']['required'] = false;
                                            $address_fields['address_2']['required'] = false;
                                            $address_fields['city']['required'] = false;
                                            $address_fields['state']['required'] = false;
                                            $address_fields['postcode']['required'] = false;

                                        } else {

                                            $address_fields['address_1']['required'] = false;
                                            $address_fields['address_2']['required'] = false;
                                            $address_fields['city']['required'] = false;
                                            $address_fields['state']['required'] = false;
                                            $address_fields['postcode']['required'] = false;

                                        }

                                    }
                                }
                            }

                        }
                    }
                } else {
                    if (MultiParcels()->options->get_other_setting('checkout', 'enabled') || MultiParcels()->options->get_other_setting('checkout', 'hide_for_local_pickup')) {
                        $chosen_methods = WC()->session->get( 'chosen_shipping_methods' );

                        if (isset($chosen_methods) && is_array($chosen_methods)) {
                            $shipping_method = $chosen_methods[0];

                            $check = 'multiparcels_';

                            $check1 = false;
                            $check2 = false;

                            if (MultiParcels()->options->get_other_setting('checkout', 'enabled')) {
                                // check if MultiParcels shipping
                                $check1 = substr($shipping_method, 0, strlen($check)) == $check;

                                // check if delivery to terminal or pickup point
                                $check2 = strpos($shipping_method, WC_MP_Shipping_Method::SUFFIX_PICKUP_POINT) !== false ||

                                    strpos($shipping_method, WC_MP_Shipping_Method::SUFFIX_TERMINAL) !== false;

                                if (MultiParcels()->options->get_other_setting('checkout', 'hide_for_local_pickup') && explode(':', $shipping_method)[0] == 'local_pickup') {

                                    $check1 = true;

                                    $check2 = true;

                                }

                                if ($check1 && $check2) {


                                    if (is_plugin_active('woocommerce-payments/woocommerce-payments.php')) {
                                        $address_fields['address_1']['required'] = false;
                                        $address_fields['address_2']['required'] = false;
                                        $address_fields['city']['required'] = false;
                                        $address_fields['state']['required'] = false;
                                        $address_fields['postcode']['required'] = false;

                                    } else {

                                        $address_fields['address_1']['required'] = false;
                                        $address_fields['address_2']['required'] = false;
                                        $address_fields['city']['required'] = false;
                                        $address_fields['state']['required'] = false;
                                        $address_fields['postcode']['required'] = false;

                                    }

                                }
                            }
                        }

                    }
                }

            }



            return $address_fields;

        }


        function load_additional_block() {

            $aeroCheckoutStart = '';

            $aeroCheckoutEnd   = '';
            $html = '';



            if (MultiParcels()->helper->is_aerocheckout()) {

                $aeroCheckoutStart = sprintf("<div class='%s' style='%s'>",

                    'wfacp-section wfacp-hg-by-box wfacp_shipping_method wfacp_shipping_method',

                    'margin-bottom: 15px;'

                );

                $aeroCheckoutEnd   = '</div>';

            }

            $html .= '<div id="mp-wc-pickup-point-shipping-block" style="display:none; padding-top: 0.5em;">';

            $html .= $aeroCheckoutStart;

            $html .= '<div class="form-row form-row-wide">';

            if (MultiParcels()->helper->is_aerocheckout()) {
                $html .= '<div class="wfacp_internal_form_wrap wfacp-comm-title none">';

                $html .= '<h2 class="wfacp_section_heading wfacp_section_title wfacp-normal wfacp-text-left">';

                $html .= __('Pickup location', 'multiparcels-shipping-for-woocommerce');

                $html .= '<h2>';

                $html .= '</div>';
            }else {
                $html .= '<strong class="mp-please-select-location">';

                $html .= __('Pickup location', 'multiparcels-shipping-for-woocommerce');

                $html .= '</strong>';
            }

            $html .= '<select id="mp-wc-pickup-point-shipping-select-block" name="' . esc_attr(WC_MP_Pickup_Point_Shipping_Method::INPUT_NAME) .'" style="width:100%">';

            $html .= '<option value="' . __('Please select the pickup location','multiparcels-shipping-for-woocommerce') .'"></option>';

            $html .= '</select>';

            $html .= '</div>';

            $html .= '<div class="form-row form-row-wide">';

            $html .= '<div class="mp-selected-pickup-point-info"></div>';

            $html .= '</div>';

            $html .= '<div id="mp-map-preview" style="display: none;">';

            $html .= '<div id="mp-gmap"></div>';

            $html .= '</div>';

            $html .=  $aeroCheckoutEnd;

            $html .= '</div>';

            // Return the content as JSON
            // Suppress PHPCS warning for unescaped output (base64-encoded binary data)
            // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
            echo $html;
//            echo json_encode(['content' => $additionalContent]);
            wp_die();
        }

        // Hook the PHP function to WordPress AJAX
        add_action('wp_ajax_load_additional_block', 'load_additional_block');
        add_action('wp_ajax_nopriv_load_additional_block', 'load_additional_block');

        add_action('wp_ajax_checkout_blocks_hide_inputs_for_terminal', 'checkout_blocks_hide_terminal_inputs');
        add_action('wp_ajax_nopriv_checkout_blocks_hide_inputs_for_terminal', 'checkout_blocks_hide_terminal_inputs');


        function multiparcels_save_pickup_location() {
            $value = $_REQUEST['multiparcels_pickup_location_value'];

            WC()->session->set( 'multiparcels_pickup_location_value', $value );
        }
        add_action('wp_ajax_multiparcels_store_pickup_selection', 'multiparcels_save_pickup_location');
        add_action('wp_ajax_nopriv_multiparcels_store_pickup_selection', 'multiparcels_save_pickup_location');

        add_action( 'before_woocommerce_init', 'multiparcels_hpos_compatibility' );


        function multiparcels_hpos_compatibility() {
            if( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
                \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility(
                    'custom_order_tables',
                    __FILE__,
                    true // true (compatible, default) or false (not compatible)
                );
            }

        }

//        add_action('before_woocommerce_init', function(){
//            if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
//                if (class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )) {
//                    if (\Automattic\WooCommerce\Utilities\OrderUtil::custom_orders_table_usage_is_enabled()) {
//                        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
//                    }else {
//                        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, false );
//                    }
//                }
//            }
//        });

    }



    private function version_checks()

    {

        if ( ! version_compare(PHP_VERSION, '5.6.0', '>=')) {

            add_action('admin_notices', [$this, 'php_version_check_notice']);



            return false;

        }



        if ( ! defined('WC_VERSION') || ! version_compare(WC_VERSION, '3.0.0', '>=')) {

            add_action('admin_notices', [$this, 'wc_version_check_notice']);



            return false;

        }



        return true;

    }



    public function php_version_check_notice()

    {

        ?>

        <div class="error notice">

            <p>

                <strong><?php echo esc_html(__(MultiParcels()->plugin_title, 'multiparcels-shipping-for-woocommerce')) ?></strong>

            </p>

            <p>

                <?php echo esc_html(__('This plugin requires at least PHP version 5.6.0. Please contact your server administrator to upgrade your PHP version.',

                    'multiparcels-shipping-for-woocommerce')); ?>

            </p>

        </div>

        <?php

    }



    public function wc_version_check_notice()

    {

        ?>

        <div class="error notice">

            <p>

                <strong><?php echo esc_html(__(MultiParcels()->plugin_title, 'multiparcels-shipping-for-woocommerce')) ?></strong>

            </p>

            <p>

                <?php echo esc_html(__('This plugin requires at least WooCommerce version 3.0.0.',

                    'multiparcels-shipping-for-woocommerce')); ?>

                <?php

                if (defined('WC_VERSION')) {

                    echo esc_html(__('Please upgrade your WooCommerce.', 'multiparcels-shipping-for-woocommerce'));

                    ?>



                    <br>

                    <?php
                    // Suppress PHPCS warning for unescaped output (base64-encoded binary data)
                    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                    echo sprintf(__('Your WooCommerce version is %s.',
                        // Suppress PHPCS warning for unescaped output (base64-encoded binary data)
                        // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                        'multiparcels-shipping-for-woocommerce'), sprintf("<strong>%s</strong>", WC_VERSION)); ?>

                    <?php

                }

                ?>

            </p>

        </div>

        <?php

    }



    public function plugins_loaded()

    {

        $this->includes();

        add_action('admin_init', ['PAnD', 'init']);



        $this->init_hooks();



        $plugin_version           = $this->version;

        $installed_plugin_version = $this->options->get('version', true);



        if ($plugin_version != $installed_plugin_version) {

            call_user_func(['MP_Install', 'update']);

        }

    }



    private function init_hooks()

    {
//        add_filter( 'auto_update_plugin', '__return_true' );

        add_filter('plugin_action_links_' . plugin_basename(__FILE__), [__CLASS__, 'plugin_action_links']);

        add_action('wp_enqueue_scripts', [$this, 'enqueue_scripts']);

    }



    public function enqueue_scripts()

    {
        wp_register_style( 'select2css', '//cdnjs.cloudflare.com/ajax/libs/select2/4.0.7/css/select2.css', false, '1.0', 'all' );

        wp_register_script( 'select2', '//cdnjs.cloudflare.com/ajax/libs/select2/4.0.7/js/select2.js', array( 'jquery' ), '1.0', true );

        wp_enqueue_style( 'select2css' );

        wp_enqueue_script( 'select2' );
        if (function_exists('is_checkout') && is_checkout()) {

            wp_enqueue_style('wp-mp-shipping-css', plugins_url('/public/css/style.css', __FILE__),

                false, MultiParcels()->version);

            if(class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )) {
                if (OrderUtil::custom_orders_table_usage_is_enabled()) {
                    wp_enqueue_script('wp-mp-shipping-js', plugins_url('/public/js/pickup-points.js', __FILE__),

                        ['jquery', 'wp-element', 'wp-data', 'wc-blocks-checkout', 'wc-blocks-data-store'], MultiParcels()->version, true);
                } else {
                    wp_enqueue_script('wp-mp-shipping-js', plugins_url('/public/js/pickup-points.js', __FILE__),

                            ['jquery'], MultiParcels()->version, true);
                }
            } else {
                wp_enqueue_script('wp-mp-shipping-js', plugins_url('/public/js/pickup-points.js', __FILE__),

                    ['jquery'], MultiParcels()->version, true);
            }





            $venipak_settings               = MultiParcels()->carriers->get('venipak');

            $preferred_delivery_time_cities = [];



            if (array_key_exists('preferred_delivery_time_cities', $venipak_settings)) {

                foreach ($venipak_settings['preferred_delivery_time_cities']['LT'] as $city) {

                    $preferred_delivery_time_cities[] = MP_Locations::latin($city);

                }

            }



            $autoCompleteText = null;

            if (MultiParcels()->permissions->addressAutoCompleteEnabled()) {

                wp_enqueue_script('wp-mp-autocomplete-js', plugins_url('/public/js/autocomplete.js', __FILE__),

                    ['jquery'], MultiParcels()->version, true);

                wp_enqueue_style('wp-mp-autocomplete-css', plugins_url('/public/css/autocomplete.css', __FILE__),

                    false, MultiParcels()->version);



                $address_autocomplete_settings = MultiParcels()->options->get('address_autocomplete', true);



                if (is_array($address_autocomplete_settings) && array_key_exists('display_notice',

                        $address_autocomplete_settings) && $address_autocomplete_settings['display_notice'] == 1) {

                    $autoCompleteText = __('Address suggestions are enabled. Start typing the street name, city or postal code.',

                        'multiparcels-shipping-for-woocommerce');

                }

            }


            wp_localize_script('wp-mp-shipping-js', 'multiparcels', [

                'ajax_url'                       => admin_url('admin-ajax.php'),

//                    'nonce'    => wp_create_nonce('wp_rest'),
                'nonce' =>    wp_create_nonce( 'wc_store_api' ),

                'text'                           => [

                    'pickup_location_not_found' => __('Pickup location not found',

                        'multiparcels-shipping-for-woocommerce'),

                    'working_hours'             => __('Working hours', 'multiparcels-shipping-for-woocommerce'),

                    'address_autocomplete_on'   => $autoCompleteText,

                    'searching'                 => __('Searching...', 'multiparcels-shipping-for-woocommerce'),

                    'please_select_pickup_point_location' => __('Please select the pickup location',

                        'multiparcels-shipping-for-woocommerce')

                ],

                'preferred_delivery_time_cities' => $preferred_delivery_time_cities,

                'display_selected_pickup_location_information' => MultiParcels()->options->get( 'display_selected_pickup_location_information',

	                false, 'yes' ),

                'display_pickup_location_title' => MultiParcels()->options->get( 'display_pickup_location_title',

	                false, 'yes' ),

                'hide_not_required_terminal_fields' => MultiParcels()->options->get_other_setting('checkout',

                    'enabled') ? 'yes' : 'no',

                'hide_not_required_local_pickup_fields' => MultiParcels()->options->get_other_setting('checkout',

                    'hide_for_local_pickup') ? 'yes' : 'no',

                'placeholder_text' => __('Search by pickup point name, address...', 'multiparcels-shipping-for-woocommerce')

            ]);

        }

    }



    private function includes()

    {

        include_once 'includes/interfaces/wc-mp-shipping-method-interface.php';

        include_once 'includes/class-mp-api-client-response.php';



        $this->options = include_once 'includes/class-mp-options.php';

        $this->logger  = include_once 'includes/class-mp-logger.php';

        $this->carrier_selections  = include_once 'includes/class-mp-carrier-selections.php';



        $this->api_client  = include_once 'includes/class-mp-api-client.php';

        $this->locations   = include_once 'includes/class-mp-locations.php';

        $this->carriers    = include_once 'includes/class-mp-carriers.php';

        $this->permissions = include_once 'includes/class-mp-permissions.php';

        $this->services    = include_once 'includes/class-multiparcels-service.php';

        $this->helper      = include_once 'includes/class-multiparcels-helper.php';

        include_once 'includes/class-mp-admin.php';

        include_once 'includes/class-mp-mass-shipping.php';

	    $this->shippings = include_once 'includes/class-mp-shippings.php';

        include_once 'includes/class-mp-amazing-shipping.php';

        include_once 'includes/abstracts/abstract-wc-mp-shipping-method.php';

        include_once 'includes/abstracts/abstract-wc-mp-courier-shipping-method.php';

        include_once 'includes/abstracts/abstract-wc-mp-pickup-point-shipping-method.php';

        include_once 'includes/abstracts/abstract-wc-mp-post-shipping-method.php';

        include_once 'includes/abstracts/abstract-wc-mp-bus-station-shipping-method.php';

        include_once 'includes/abstracts/abstract-wc-mp-terminal-shipping-method.php';



        // Dpd

        include_once 'includes/shipping/class-wc-mp-dpd-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-dpd-pickup-point-shipping.php';

        include_once 'includes/shipping/class-wc-mp-dpd-terminal-shipping.php';

        // Dpd Amber

        include_once 'includes/shipping/class-wc-mp-dpd-amber-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-dpd-amber-pickup-point-shipping.php';

        include_once 'includes/shipping/class-wc-mp-dpd-amber-terminal-shipping.php';

        // Dpd Pl

        include_once 'includes/shipping/class-wc-mp-dpd-pl-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-dpd-pl-pickup-point-shipping.php';

        include_once 'includes/shipping/class-wc-mp-dpd-pl-terminal-shipping.php';



        // Lp Express

        include_once 'includes/shipping/class-wc-mp-lp-express-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-lp-express-pickup-point-shipping.php';

        include_once 'includes/shipping/class-wc-mp-lp-express-post-shipping.php';



        // Omniva

        include_once 'includes/shipping/class-wc-mp-omniva-lt-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-omniva-lt-pickup-point-shipping.php';



        include_once 'includes/shipping/class-wc-mp-omniva-lv-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-omniva-lv-pickup-point-shipping.php';



        include_once 'includes/shipping/class-wc-mp-omniva-ee-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-omniva-ee-pickup-point-shipping.php';



        // Venipak

        include_once 'includes/shipping/class-wc-mp-venipak-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-venipak-pickup-point-shipping.php';



        // Venipak 3PL

        include_once 'includes/shipping/class-wc-mp-venipak-3pl-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-venipak-3pl-pickup-point-shipping.php';



        // Post LT

        include_once 'includes/shipping/class-wc-mp-post-lt-post-shipping.php';

        // Unisend
        include_once 'includes/shipping/class-wc-mp-unisend-courier-shipping.php';
        include_once 'includes/shipping/class-wc-mp-unisend-pickup-point-shipping.php';



        // Post LV

        include_once 'includes/shipping/class-wc-mp-post-lv-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-post-lv-pickup-point-shipping.php';

        include_once 'includes/shipping/class-wc-mp-post-lv-post-shipping.php';



        // SmartPOST
        include_once 'includes/shipping/class-wc-mp-smartpost-pickup-point-shipping.php';


        // TNT

        include_once 'includes/shipping/class-wc-mp-tnt-courier-shipping.php';



        // DHL

        include_once 'includes/shipping/class-wc-mp-dhl-courier-shipping.php';



        // UPS

        include_once 'includes/shipping/class-wc-mp-ups-courier-shipping.php';

        // UPS v2

        include_once 'includes/shipping/class-wc-mp-ups-v2-courier-shipping.php';



        // InPost

        include_once 'includes/shipping/class-wc-mp-inpost-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-inpost-pickup-point-shipping.php';



        // Posti

        include_once 'includes/shipping/class-wc-mp-posti-pickup-point-shipping.php';

        include_once 'includes/shipping/class-wc-mp-posti-post-shipping.php';



        // Itella

        include_once 'includes/shipping/class-wc-mp-itella-pickup-point-shipping.php';

        include_once 'includes/shipping/class-wc-mp-itella-courier-shipping.php';



        // ParcelStars

        include_once 'includes/shipping/class-wc-mp-parcelstars-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-parcelstars-pickup-point-shipping.php';

        // Packeta

        include_once 'includes/shipping/class-wc-mp-packeta-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-packeta-pickup-point-shipping.php';

        // Novapost
        include_once 'includes/shipping/class-wc-mp-novapost-courier-shipping.php';
        include_once 'includes/shipping/class-wc-mp-novapost-pickup-point-shipping.php';

        // Zipas Go
        include_once 'includes/shipping/class-wc-mp-zipas-go-courier-shipping.php';
        include_once 'includes/shipping/class-wc-mp-zipas-go-pickup-point-shipping.php';


        // ZITICITY

        include_once 'includes/shipping/class-wc-mp-ziticity-courier-shipping.php';



        // FedEx

        include_once 'includes/shipping/class-wc-mp-fedex-courier-shipping.php';



        // GLS

        include_once 'includes/shipping/class-wc-mp-gls-courier-shipping.php';



        // Hermes

        include_once 'includes/shipping/class-wc-mp-hermes-courier-shipping.php';



        // Hermes UK

        include_once 'includes/shipping/class-wc-mp-hermes-uk-courier-shipping.php';



        // Post DE

        include_once 'includes/shipping/class-wc-mp-post-de-post-shipping.php';



        // Siuntos autobusias

        include_once 'includes/shipping/class-wc-mp-siuntos-autobusais-courier-shipping.php';

        include_once 'includes/shipping/class-wc-mp-siuntos-autobusais-bus-station-shipping.php';

//        include_once 'includes/shipping/class-wc-mp-siuntos-autobusais-pickup-point-shipping.php';



        // DB Schenker

        include_once 'includes/shipping/class-wc-mp-db-schenker-courier-shipping.php';



        include_once 'includes/shipping/class-wc-mp-shipping-helper.php';



        include_once 'includes/class-mp-actions.php';

        $this->woocommerce = include_once 'includes/class-mp-woocommerce.php';

        include_once 'includes/class-mp-notices.php';

        include_once 'includes/class-mp-woocommerce-order-shipping.php';

        include_once 'includes/persist-admin-notices-dismissal.php';

    }



    /**

     * Show action links on the plugin screen.

     *

     * @param    mixed $links Plugin Action links

     *

     * @return    array

     */

    public static function plugin_action_links($links)

    {

        $action_links = [

            sprintf('<a href="%s" title="%s">%s</a>',

                admin_url('admin.php?page=multiparcels-shipping-for-woocommerce'),

                esc_attr(__('View MultiParcels Settings', 'multiparcels-shipping-for-woocommerce')),

                __('Settings', 'multiparcels-shipping-for-woocommerce')

            ),

        ];



        return array_merge($action_links, $links);

    }



    public function load_plugin_textdomain()

    {

        load_textdomain('multiparcels-shipping-for-woocommerce',

            WP_LANG_DIR . '/multiparcels-shipping-for-woocommerce/multiparcels-shipping-for-woocommerce-' . get_locale() . '.mo');

        load_plugin_textdomain('multiparcels-shipping-for-woocommerce', false,

            plugin_basename(dirname(__FILE__)) . '/languages');

    }



    /**

     * @return string

     */

    public function plugin_path()

    {

        return untrailingslashit(plugin_dir_path(__FILE__));

    }



    /**

     * @param array $query

     * @param bool $escape

     *

     * @return string

     */

    function settings_url($query = [], $escape = true)

    {

        $url = admin_url('admin.php?page=multiparcels-shipping-for-woocommerce') . '&' . http_build_query($query);



        if ($escape) {

            return esc_url($url);

        }

        return esc_url($url);

    }



    /**

     * Get the public plugin url.

     *

     * @param string|null $sub_path

     *

     * @return string

     */

    public function public_plugin_url($sub_path = null)

    {

        $path = untrailingslashit(plugins_url('/', __FILE__)) . '/public';



        if ($sub_path) {

            $path .= '/' . $sub_path;

        }



        return esc_url($path);

    }



    private function cron_schedule()

    {

        add_filter('cron_schedules', 'multiparcels_intervals');



        function multiparcels_intervals($intervals)

        {

            $intervals['multiparcels_every_10min'] = ['interval' => 10 * 60, 'display' => 'MultiParcels: Every 10 minutes'];

            $intervals['multiparcels_every_30min'] = ['interval' => 30 * 60, 'display' => 'MultiParcels: Every 30 minutes'];

            $intervals['multiparcels_every_60min'] = ['interval' => 60 * 60, 'display' => 'MultiParcels: Every 60 minutes'];

            $intervals['multiparcels_every_24h'] = ['interval' => 60 * 60 * 24, 'display' => 'MultiParcels: Every 24 hours'];



            return $intervals;

        }

    }

}



/**

 * @return MultiParcels

 */

function MultiParcels()

{

    return MultiParcels::instance();

}



MultiParcels();

