<?php



// If this file is called directly, abort.

if ( ! defined('ABSPATH')) {

    die;

}



/**

 * Class MP_Locations

 */
use Automattic\WooCommerce\Utilities\OrderUtil;


class MP_Locations

{

    const TYPE_TERMINAL = 'terminal';

    const TYPE_PICKUP_POINT = 'pickup_point';



    /** @var string */

    private $table = 'multiparcels_terminals';



    /**

     * @param string|null $carrier_code

     * @param string|null $country

     * @param string|null $type

     *

     * @return mixed

     */

	public function all( $carrier_code = null, $country = null, $type = null ) {

		global $wpdb;



		$wheres = [];



		if ( $carrier_code ) {

			$wheres['carrier_code'] = $carrier_code;

		}



		if ( $country ) {

			$wheres['country_code'] = $country;

		}

        if(MultiParcels()->permissions->isFull()) {
            if ( $type ) {
                $wheres['type'] = $type;

            }else if($carrier_code == 'dpd' || $carrier_code == 'venipak') {
                if (MultiParcels()->options->get('terminal_options') == 1) {
                    $wheres['type'] = 'terminal';
                }
            }
        } else {
            if ( $type ) {
                $wheres['type'] = $type;
            }
        }

        if($carrier_code == 'post_lv') {
            $wheres['type'] = ['terminal', 'post_office'];
        }

//		$query = "SELECT * FROM " . $this->table();
//
//		if ( count( $wheres ) ) {
//
//			$query .= ' WHERE ';
//
//
//
//			foreach ( $wheres as $column => $value ) {
//
//				$query .= sprintf( "`%s` = '%s' AND ", $column, esc_sql( $value ) );
//
//			}
//
//
//
//			$query = rtrim( $query, ' AND ' );
//
//		}

        // New functionality
        $query = "SELECT * FROM " . $this->table();

        if ( count( $wheres ) ) {

            $query .= ' WHERE ';
            $whereParts = [];

            foreach ($wheres as $column => $value) {
                if (is_array($value)) {
                    $escaped = array_map('esc_sql', $value);
                    $inClause = "'" . implode("','", $escaped) . "'";
                    $whereParts[] = "`$column` IN ($inClause)";
                } else {
                    $whereParts[] = sprintf("`%s` = '%s'", $column, esc_sql($value));
                }
            }

            $query .= implode(' AND ', $whereParts);

        }

        if ($carrier_code == 'packeta') {
            $delivery_methods = MultiParcels()->options->get('extra_delivery_pickup_points_packeta', true);

            if ($delivery_methods) {
                $delivery_methods_array = [];

                foreach ($delivery_methods as $key => $delivery_method) {
                    $delivery_methods_array [] = $delivery_method;
                }

                $query .= ' AND `custom_fields` IN(';

                $last_key = array_key_last($delivery_methods_array);

                $one_delivery_method_text = '';

                foreach ($delivery_methods_array as $one_key => $one_delivery_method) {
                    if ($one_key == $last_key) {
                        $one_delivery_method_text .= sprintf( "'%s'", $one_delivery_method);

                    }else {
                        $one_delivery_method_text .= sprintf( "'%s'", $one_delivery_method);
                        $one_delivery_method_text .= ',';
                    }


                }

                $query .= $one_delivery_method_text;

                $query .= ') ';

            }

        }

		return $wpdb->get_results( $query, ARRAY_A );

	}



    /**

     * @param string $identifier

     * @param string $carrier_code

     *

     * @return array

     */

    public function get($identifier, $carrier_code, $post_office = null)

    {

        global $wpdb;



        $type_sql = "AND `type` != 'post_office'";

        if ($post_office) {

            $type_sql = "AND `type` = 'post_office'";

        }

        $query = $wpdb->prepare("SELECT * FROM " . $this->table() . " WHERE `identifier` = %s AND `carrier_code` = %s " . $type_sql,

            $identifier, $carrier_code);

        return $wpdb->get_row($query, ARRAY_A);

    }

    public function get_latvian_post_location($identifier, $carrier_code, $post_office = null, $country_code)
    {
        global $wpdb;


        $type_sql = "AND `type` != 'post_office'";

        if ($post_office) {

            $type_sql = "AND `type` = 'post_office'";

        }

        $query = $wpdb->prepare("SELECT * FROM " . $this->table() . " WHERE `identifier` = %s AND `carrier_code` = %s AND `country_code` = %s" . $type_sql,

            $identifier, $carrier_code, $country_code);

        return $wpdb->get_row($query, ARRAY_A);
    }



    public function grouped_by_city($carrier_code, $country, $normalKeys = false, $type = null)

    {

        $groups    = [];

        $locations = $this->all($carrier_code, $country, $type);



        foreach ($locations as $location) {

            if (MultiParcels()->options->get('show_all_cities') === "2" || MultiParcels()->options->get('show_all_cities') === 2) {

                $city                        = $location['city'];

            }else {

                $city = $this->latin_only($location['city']);

            }

            $location['city_simplified'] = $city;



            $groups[$city][$location['name'] . $location['address']] = $location;

        }



        foreach ($groups as $key => $data){

            ksort($groups[$key]);

        }



        ksort($groups);

        // For now only Lithuanian

        $priorityCities = [

            'Vilnius',

            'Kaunas',

            'Klaipėda',

        ];



        // needed for sorting properly

        $priorityCities = array_reverse($priorityCities);



        foreach ($priorityCities as $city) {

            if (array_key_exists($city, $groups)) {

                $groups = [$city => $groups[$city]] + $groups;

            }

        }



        if ($normalKeys) {

            foreach ($groups as $city => $items) {

                $first_city = reset($items);



                unset($groups[$city]);



                $groups[$first_city['city']] = $items;

            }

        }

        return $groups;

    }



	/**

	 * @param      $carrier_code

	 * @param      $city

	 * @param      $country

	 * @param null $type

	 *

	 * @return array

	 */

    public function get_for_city($carrier_code, $city, $country, $type = null)

    {

        $city   = $this->latin_only($city);

        $groups = $this->grouped_by_city($carrier_code, $country, false, $type);



        if (MultiParcels()->options->getBool('show_all_cities')) {

            return $groups;

        }



        if (isset($groups[$city])) {

            return [

                $city => $groups[$city],

            ];

        }



        return $this->grouped_by_city($carrier_code, $country, true, $type);

    }



    public function latin_only($text)

    {

        return self::latin($text);

    }



	public static function latin($text)

	{

		$table = array(

			'À'=>'A', 'Á'=>'A', 'Â'=>'A', 'Ã'=>'A', 'Ä'=>'A', 'Å'=>'A', 'Ă'=>'A', 'Ā'=>'A', 'Ą'=>'A', 'Æ'=>'A', 'Ǽ'=>'A',

			'à'=>'a', 'á'=>'a', 'â'=>'a', 'ã'=>'a', 'ä'=>'a', 'å'=>'a', 'ă'=>'a', 'ā'=>'a', 'ą'=>'a', 'æ'=>'a', 'ǽ'=>'a',



			'Þ'=>'B', 'þ'=>'b', 'ß'=>'Ss',



			'Ç'=>'C', 'Č'=>'C', 'Ć'=>'C', 'Ĉ'=>'C', 'Ċ'=>'C',

			'ç'=>'c', 'č'=>'c', 'ć'=>'c', 'ĉ'=>'c', 'ċ'=>'c',



			'Đ'=>'Dj', 'Ď'=>'D',

			'đ'=>'dj', 'ď'=>'d',



			'È'=>'E', 'É'=>'E', 'Ê'=>'E', 'Ë'=>'E', 'Ĕ'=>'E', 'Ē'=>'E', 'Ę'=>'E', 'Ė'=>'E',

			'è'=>'e', 'é'=>'e', 'ê'=>'e', 'ë'=>'e', 'ĕ'=>'e', 'ē'=>'e', 'ę'=>'e', 'ė'=>'e',



			'Ĝ'=>'G', 'Ğ'=>'G', 'Ġ'=>'G', 'Ģ'=>'G',

			'ĝ'=>'g', 'ğ'=>'g', 'ġ'=>'g', 'ģ'=>'g',



			'Ĥ'=>'H', 'Ħ'=>'H',

			'ĥ'=>'h', 'ħ'=>'h',



			'Ì'=>'I', 'Í'=>'I', 'Î'=>'I', 'Ï'=>'I', 'İ'=>'I', 'Ĩ'=>'I', 'Ī'=>'I', 'Ĭ'=>'I', 'Į'=>'I',

			'ì'=>'i', 'í'=>'i', 'î'=>'i', 'ï'=>'i', 'į'=>'i', 'ĩ'=>'i', 'ī'=>'i', 'ĭ'=>'i', 'ı'=>'i',



			'Ĵ'=>'J',

			'ĵ'=>'j',



			'Ķ'=>'K',

			'ķ'=>'k', 'ĸ'=>'k',



			'Ĺ'=>'L', 'Ļ'=>'L', 'Ľ'=>'L', 'Ŀ'=>'L', 'Ł'=>'L',

			'ĺ'=>'l', 'ļ'=>'l', 'ľ'=>'l', 'ŀ'=>'l', 'ł'=>'l',



			'Ñ'=>'N', 'Ń'=>'N', 'Ň'=>'N', 'Ņ'=>'N', 'Ŋ'=>'N',

			'ñ'=>'n', 'ń'=>'n', 'ň'=>'n', 'ņ'=>'n', 'ŋ'=>'n', 'ŉ'=>'n',



			'Ò'=>'O', 'Ó'=>'O', 'Ô'=>'O', 'Õ'=>'O', 'Ö'=>'O', 'Ø'=>'O', 'Ō'=>'O', 'Ŏ'=>'O', 'Ő'=>'O', 'Œ'=>'O',

			'ò'=>'o', 'ó'=>'o', 'ô'=>'o', 'õ'=>'o', 'ö'=>'o', 'ø'=>'o', 'ō'=>'o', 'ŏ'=>'o', 'ő'=>'o', 'œ'=>'o', 'ð'=>'o',



			'Ŕ'=>'R', 'Ř'=>'R',

			'ŕ'=>'r', 'ř'=>'r', 'ŗ'=>'r',



			'Š'=>'S', 'Ŝ'=>'S', 'Ś'=>'S', 'Ş'=>'S',

			'š'=>'s', 'ŝ'=>'s', 'ś'=>'s', 'ş'=>'s',



			'Ŧ'=>'T', 'Ţ'=>'T', 'Ť'=>'T',

			'ŧ'=>'t', 'ţ'=>'t', 'ť'=>'t',



			'Ù'=>'U', 'Ú'=>'U', 'Û'=>'U', 'Ü'=>'U', 'Ũ'=>'U', 'Ū'=>'U', 'Ŭ'=>'U', 'Ů'=>'U', 'Ű'=>'U', 'Ų'=>'U',

			'ù'=>'u', 'ú'=>'u', 'û'=>'u', 'ü'=>'u', 'ũ'=>'u', 'ū'=>'u', 'ŭ'=>'u', 'ů'=>'u', 'ű'=>'u', 'ų'=>'u',



			'Ŵ'=>'W', 'Ẁ'=>'W', 'Ẃ'=>'W', 'Ẅ'=>'W',

			'ŵ'=>'w', 'ẁ'=>'w', 'ẃ'=>'w', 'ẅ'=>'w',



			'Ý'=>'Y', 'Ÿ'=>'Y', 'Ŷ'=>'Y',

			'ý'=>'y', 'ÿ'=>'y', 'ŷ'=>'y',



			'Ž'=>'Z', 'Ź'=>'Z', 'Ż'=>'Z',

			'ž'=>'z', 'ź'=>'z', 'ż'=>'z',

		);



		$text = strtr($text, $table);



		// lowercase

		$text = strtolower($text);



		if (empty($text)) {

			return 'n-a';

		}



		return $text;

	}



    /**

     * Returns prefixed table name

     *

     * @return string

     */

    private function table()

    {

        global $wpdb;



        return $wpdb->prefix . $this->table;

    }



    /**

     * Create a location

     *

     * @param array $data

     */

    public function create($data)

    {

        global $wpdb;



        $wpdb->insert($this->table(), $data);

    }



    public function clear()

    {

        global $wpdb;



        $wpdb->query("TRUNCATE " . $this->table());

    }



    /**

     * @param string $type

     *

     * @return string

     */

    public function type_name($type)

    {

        if ($type == self::TYPE_TERMINAL) {

            return __('Terminal', 'multiparcels-shipping-for-woocommerce');

        }

        if ($type == self::TYPE_PICKUP_POINT) {

            return __('Pickup Point', 'multiparcels-shipping-for-woocommerce');

        }



        return $type;

    }



    /**

     * @param array $location

     *

     * @return string

     */

    public function selected_text($location)

    {

        $selected_text = __("Selected terminal", 'multiparcels-shipping-for-woocommerce');



        if ($location['type'] == MP_Locations::TYPE_PICKUP_POINT) {

            $selected_text = __("Selected pickup point", 'multiparcels-shipping-for-woocommerce');

        }



        return $selected_text;

    }



    public function update()

    {

    	// check if there are no errors

//	    $test_response = MultiParcels()->api_client->request('locations_for_shops', 'GET', [
//
//		    'limit'      => 1,
//
//	    ]);

//        $test_response = MultiParcels()->api_client->request('api/v1/locations_for_shops', 'GET', [
//
//            'limit'      => 1,
//
//        ]);

        $test_response = MultiParcels()->api_client->request('api/translate/mp/locations', 'GET', [

            'limit'      => 1,

        ]);


	    if ( ! $test_response->was_successful() ) {

		    MultiParcels()->options->set_other( 'last_update', 'test failed' );



		    return;

	    }

	    // make sure there are no problems before clearing

        $test_api = MultiParcels()->api_client->request('api/translate/mp/locations', 'GET', [

            'limit'      => 1,

        ]);



        if ( ! $test_api->was_successful()) {

            return;

        }



        $this->clear();

        // Make sure the table exists

        MP_Install::table();



        $carriers = MultiParcels()->carriers->all_enabled();

        foreach ($carriers as $carrier_code) {

            $carrier = MultiParcels()->carriers->get($carrier_code);



            if (!$carrier['has_terminals'] && !$carrier['has_pickup_points']) {

                continue;

            }



            $countries = $carrier['pickup_points_countries'];




            $extraCountries = MultiParcels()->locations->get_extra_countries($carrier_code);

            if (is_array($extraCountries) && count($extraCountries)) {

                $countries = array_merge($countries, $extraCountries);

            }

            foreach ($countries as $country) {

                $search = [];

                $search[] = 'courier_code:'.$carrier_code;

                $search[] = 'country_code:'.$country;

                $page = 1;
                $limit = 7000; // kiekviename puslapyje
                $hasMore = true;

                while ($hasMore) {
                    $response = MultiParcels()->api_client->request('api/translate/mp/locations', 'GET', [
                        'limit' => $limit,
                        'page'  => $page,
                        'search' => implode(';', $search),
                        'searchJoin' => 'and',
                    ]);

                    if ($response->was_successful()) {
                        $locations = $response->get_data();
                        if (count($locations) == 0) {
                            $hasMore = false;
                            break;
                        }

                        foreach ($locations as $locationData) {

                            $location = [
                                'carrier_code' => $locationData['courier_code'],
                                'type'         => $locationData['type'],
                                'name'         => $locationData['name'],
                                'address'      => $locationData['address'],
                                'postal_code'  => $locationData['postal_code'],
                                'city'         => $locationData['city'],
                                'country_code' => $locationData['country_code'],
                                'identifier'   => $locationData['identifier'],
                                'comment'      => $locationData['comment'],
                                'working_hours'=> $locationData['working_hours'],
                                'latitude'     => $locationData['latitude'],
                                'longitude'    => $locationData['longitude']
                            ];

                            if ($carrier_code == 'packeta') {
                                $location['custom_fields'] = $locationData['custom_fields']['method'];
                            }

                            MultiParcels()->locations->create($location);
                        }

                        // Jei gautų įrašų skaičius mažesnis už limit – paskutinis puslapis
                        if (count($locations) < $limit) {
                            $hasMore = false;
                        } else {
                            $page++;
                        }
                    }
                }

//                $response = MultiParcels()->api_client->request('api/translate/mp/locations', 'GET', [
//                    'limit' => 99999,
//                    'search' => implode(';', $search),
//                    'searchJoin' => 'and',
//                ]);

//                if ($response->was_successful()) {
//                    $locations = $response->get_data();

//                    if (count($locations) > 0) {
//                        foreach ($locations as $locationData) {
//                            if ($carrier_code == 'packeta') {
//                                $location = [
//                                    'carrier_code' => $locationData['courier_code'],
//                                    'type' => $locationData['type'],
//                                    'name' => $locationData['name'],
//                                    'address' => $locationData['address'],
//                                    'postal_code' => $locationData['postal_code'],
//                                    'city' => $locationData['city'],
//                                    'country_code' => $locationData['country_code'],
//                                    'identifier' => $locationData['identifier'],
//                                    'comment' => $locationData['comment'],
//                                    'working_hours' => $locationData['working_hours'],
//                                    'latitude' => $locationData['latitude'],
//                                    'longitude' => $locationData['longitude'],
//                                    'custom_fields' => $locationData['custom_fields']['method']
//                                ];
//                            }else {
//                                $location = [
//                                    'carrier_code' => $locationData['courier_code'],
//                                    'type' => $locationData['type'],
//                                    'name' => $locationData['name'],
//                                    'address' => $locationData['address'],
//                                    'postal_code' => $locationData['postal_code'],
//                                    'city' => $locationData['city'],
//                                    'country_code' => $locationData['country_code'],
//                                    'identifier' => $locationData['identifier'],
//                                    'comment' => $locationData['comment'],
//                                    'working_hours' => $locationData['working_hours'],
//                                    'latitude' => $locationData['latitude'],
//                                    'longitude' => $locationData['longitude']
//                                ];
//                            }
//
//                            MultiParcels()->locations->create($location);
//
//                        }
//                    }
//                }

                MultiParcels()->options->set('last_update', current_time('Y-m-d H:i:s'), true);

            }

        }

    }



    /**

     * @param int|WC_Order $order

     *

     * @return array|false

     */

    public function get_location_for_order($order)

    {


        if (is_numeric($order)) {

            $order = wc_get_order($order);

        }



        if (!$order) {

            return false;

        }



        $order_shipping_methods = $order->get_shipping_methods();

        /** @var WC_Order_Item_Shipping $order_shipping_method */

        $order_shipping_method = reset($order_shipping_methods);



        $method = '';



        if ($order_shipping_method) {

            $method = $order_shipping_method->get_method_id();

        }



        $courier_code = MultiParcels()->carriers->extract_from_method($method);

        if ($courier_code) {
            if (class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )) {
                if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
                    // HPOS usage is enabled.
                    $location_identifier = $order->get_meta('multiparcels_location_identifier', true);
                }else {
                    $location_identifier = get_post_meta($order->get_id(), 'multiparcels_location_identifier', true);
                }
            } else {
                // Traditional CPT-based orders are in use.
                $location_identifier = get_post_meta($order->get_id(), 'multiparcels_location_identifier', true);
            }

            $without_instance = explode(':', $method)[0];

            if ($without_instance == 'multiparcels_post_lv_pickup_point') {
                $country_code = '';

                $order_id = $order->get_id();

                if (class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )) {
                    if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
                        // HPOS usage is enabled.
                        $order_meta   = $order->get_meta_data();
                    } else {
                        // Traditional CPT-based orders are in use.
                        $order_meta   = get_post_meta($order_id);
                    }
                } else {
                    // Traditional CPT-based orders are in use.
                    $order_meta   = get_post_meta($order_id);
                }

                if (class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )) {
                    if( OrderUtil::custom_orders_table_usage_is_enabled() ) {
                        // HPOS is enabled.
                        if ($order->get_billing_country()) {
                            $country_code = sanitize_text_field($order->get_billing_country());
                        }

                    } else {
                        // CPT-based orders are in use.
                        if (array_key_exists('_billing_country', $order_meta)) {
                            $country_code = sanitize_text_field($order_meta['_billing_country'][0]);
                        }
                    }
                } else {
                    // CPT-based orders are in use.
                    if (array_key_exists('_billing_country', $order_meta)) {
                        $country_code = sanitize_text_field($order_meta['_billing_country'][0]);
                    }
                }

                $location = MultiParcels()->locations->get_latvian_post_location($location_identifier, $courier_code, null, $country_code);

            } else {
                $location = MultiParcels()->locations->get($location_identifier, $courier_code, MultiParcels()->locations->is_delivery_to_latvian_post_office($method));
            }

            if ($location) {

                return $location;

            }

        }



        return false;

    }



    public function google_maps_enabled()

    {

        if (MultiParcels()->options->get('google_maps_api_key') == '') {

            return false;

        }



        return true;

    }



	/**

	 * @param WC_Order|int $order

	 *

	 * @return bool

	 */

	public function is_delivery_to_pickup_point( $order, $allow_post_office = false) {

		if (is_numeric($order)) {

			$order = wc_get_order($order);

		}



		if ( ! $order instanceof WC_Order ) {

			return false;

		}



		$order_shipping_methods = $order->get_shipping_methods();

		/** @var WC_Order_Item_Shipping $order_shipping_method */

		$order_shipping_method = reset($order_shipping_methods);



		$method = '';



		if ($order_shipping_method) {

			$method = $order_shipping_method->get_method_id();

		}



		if ( strpos( $method, WC_MP_Shipping_Method::SUFFIX_PICKUP_POINT ) !== false || strpos( $method,

				WC_MP_Shipping_Method::SUFFIX_TERMINAL ) !== false ||  strpos( $method,

                WC_MP_Shipping_Method::SUFFIX_BUS_STATION) !== false ) {

			return true;

		}



		if ($allow_post_office) {

		    return $this->is_delivery_to_latvian_post_office($method);

        }



		return false;

    }



    /**

     * @param string|WC_Order $method

     * @return bool

     */

    public function is_delivery_to_latvian_post_office($method)

    {

        if ($method instanceof WC_Order) {

            $shipping_methods = $method->get_shipping_methods();

            $shipping_methods = reset($shipping_methods);



            if (isset($shipping_methods['method_id'])) {

                $method = $shipping_methods['method_id'];

            } else {

                $method = null;

            }

        }


        if (MultiParcels()->carriers->extract_from_method($method) != WC_MP_Shipping_Helper::CARRIER_POST_LV) {

            return false;

        }



        $without_instance = explode(':', $method)[0];

        $post_ending = '_'.WC_MP_Shipping_Method::SUFFIX_POST;



//        if (substr($without_instance, strlen($post_ending) * -1) == $post_ending) {
//
//            return true;
//
//        }

        if($without_instance == 'multiparcels_post_lv_pickup_point') {
            return true;
        }



        return false;

    }



    /**

     * @param $carrier_code

     * @param $country

     * @return bool

     */

    public function check_extra_country($carrier_code, $country)

    {

        $key = 'extra_countries_'.$carrier_code;

        $countries = MultiParcels()->options->get_other($key);



        return isset($countries[$country]);

    }

    public function check_extra_delivery_method($carrier_code, $delivery_pickup_point) {
        $key = 'extra_delivery_pickup_points_'.$carrier_code;

        $delivery_pickup_points = MultiParcels()->options->get_other($key);



        return isset($delivery_pickup_points[$delivery_pickup_point]);
    }

    public function check_extra_city($carrier_code, $city)

    {

        $key = 'extra_cities_'.$carrier_code;

        $cities = MultiParcels()->options->get_other($key);



        return isset($cities[$city]);

    }

    public function check_extra_siuntos_autobusais_cities($carrier_code, $city)
    {
        $key = 'extra_siuntos_autobusais_pickup_cities_'.$carrier_code;

        $siuntos_autobusais_pickup_cities = MultiParcels()->options->get_other($key);



        return isset($siuntos_autobusais_pickup_cities[$city]);
    }



    /**

     * @param string $carrier_code

     * @param string $country

     */

    public function enabled_extra_country($carrier_code, $country)

    {

        $key = 'extra_cities_'.$carrier_code;

        $countries = MultiParcels()->options->get_other($key);

        if (!is_array($countries)) {

            $countries = [];

        }

        $countries[$country] = $country;

        MultiParcels()->options->set_other($key, $countries);

    }

    public function enabled_extra_city($carrier_code, $city)

    {

        $key = 'extra_cities_'.$carrier_code;

        delete_option('multiparcels_extra_cities' . $carrier_code);

        $cities = [];

        $cities[$city] = $city;

        MultiParcels()->options->set_other($key, $cities);

    }

    public function enabled_extra_siuntos_autobusais_pickup_city($carrier_code, $city)

    {

        $key = 'extra_siuntos_autobusais_pickup_cities_'.$carrier_code;

        $siuntos_autobusais_pickup_points = MultiParcels()->options->get_other($key);

        if (!is_array($siuntos_autobusais_pickup_points)) {

            $siuntos_autobusais_pickup_points = [];

        }

        $siuntos_autobusais_pickup_points[$city] = $city;

        MultiParcels()->options->set_other($key, $siuntos_autobusais_pickup_points);



//        delete_option('multiparcels_extra_siuntos_autobusais_pickup_cities_' . $carrier_code);
//
//        $cities = [];

//        $cities[$city] = $city;

//        MultiParcels()->options->set_other($key, $cities);

    }



    public function enabled_extra_delivery_pickup_point($carrier_code, $delivery_pickup_point)
    {
        $key = 'extra_delivery_pickup_points_'.$carrier_code;

        $delivery_pickup_points = MultiParcels()->options->get_other($key);

        if (!is_array($delivery_pickup_points)) {

            $delivery_pickup_points = [];

        }

        $delivery_pickup_points[$delivery_pickup_point] = $delivery_pickup_point;

        MultiParcels()->options->set_other($key, $delivery_pickup_points);
    }

    public function disable_extra_delivery_pickup_point($carrier_code, $delivery_pickup_point)
    {
        $key = 'extra_delivery_pickup_points_'.$carrier_code;

        $delivery_pickup_points = MultiParcels()->options->get_other($key);

        if (!is_array($delivery_pickup_points)) {

            $delivery_pickup_points = [];

        }

        unset($delivery_pickup_points[$delivery_pickup_point]);

        MultiParcels()->options->set_other($key, $delivery_pickup_points);
    }



    /**

     * @param string $carrier_code

     * @param string $country

     */

    public function disable_extra_country($carrier_code, $country)

    {

        $key = 'extra_countries_'.$carrier_code;

        $countries = MultiParcels()->options->get_other($key);

        if (!is_array($countries)) {

            $countries = [];

        }



        unset($countries[$country]);



        MultiParcels()->options->set_other($key, $countries);

    }

    public function disable_extra_city($carrier_code, $city)

    {

        $key = 'extra_cities_'.$carrier_code;

        $cities = MultiParcels()->options->get_other($key);

        if (!is_array($cities)) {

            $cities = [];

        }



        unset($cities[$city]);



        MultiParcels()->options->set_other($key, $cities);

    }

    public function disable_extra_siuntos_autobusais_pickup_city($carrier_code, $city)

    {

        $key = 'extra_siuntos_autobusais_pickup_cities_'.$carrier_code;

        $cities = MultiParcels()->options->get_other($key);

        if (!is_array($cities)) {

            $cities = [];

        }



        unset($cities[$city]);

        MultiParcels()->options->set_other($key, $cities);

    }



    /**

     * @param string $carrier_code

     * @return array

     */

    public function get_extra_countries($carrier_code)

    {

        $key = 'extra_countries_'.$carrier_code;

        $countries = MultiParcels()->options->get_other($key);

        if (!is_array($countries)) {

            $countries = [];

        }



        return $countries;

    }

}



return new MP_Locations();

