<?php







// If this file is called directly, abort.



if ( ! defined( 'ABSPATH' ) ) {



	die;



}







if ( ! class_exists( 'WP_List_Table' ) ) {



	require_once( ABSPATH . 'wp-admin/includes/class-wp-list-table.php' );



}











/**



 * Class MP_Amazing_shipping



 */

use Automattic\WooCommerce\Utilities\OrderUtil;

class MP_Amazing_shipping {







	const ACTION_DELETE_SHIPPING = 'multiparcels_delete_shipping';







	/**



	 * Admin constructor.



	 */



	public function __construct() {



		add_action( 'wp_ajax_nopriv_' . 'multiparcels_amazing_shipping_next', [ $this, 'do_next' ] );



		add_action( 'wp_ajax_' . 'multiparcels_amazing_shipping_next', [ $this, 'do_next' ] );



		add_action( 'admin_post_' . self::ACTION_DELETE_SHIPPING, [ $this, 'delete_shipping' ] );



	}









	public static function link() {



		return admin_url( 'admin.php?page=multiparcels-shippings' );



	}







	public function delete_shipping() {

		

		

		$nonce = $_GET['_wpnonce'];

			if ( ! wp_verify_nonce( $nonce, 'delete' ) ) {

				

				die( esc_html(__( 'Security check for deleting', 'multiparcels-shipping-for-woocommerce' )) );

				

			} 

			else {

				

					MultiParcels()->shippings->delete( $_GET['id'] );

					wp_redirect( self::link() );

					

			}



	



	}







	static function free_shipments() {



	    $link = 'https://multiparcels.com/registration/';







		if ( get_locale() == 'lt_LT' || get_locale() == 'lt' ) {



			$link = 'https://multisiuntos.lt/registracija/';



		}







		?>



        <div class="wrap">



            <h1 class="wp-heading-inline">



				<?php echo esc_html(__( 'Shipments', 'multiparcels-shipping-for-woocommerce' )); ?>



            </h1>







            <hr class="wp-header-end">







            <div style="width: 100%;height: 400px;display: flex;background: white;justify-content: center;align-items: center;flex-direction: column;">



                <div style="margin-bottom: 15px;">



                    <img src="<?php echo esc_html(MultiParcels()->public_plugin_url( 'images/logo.svg' )); ?>" alt="MultiParcels"



                         style="width: 250px;vertical-align: middle"> <span



                            style="vertical-align: middle;display: inline-block;font-size: 18px;padding-top: 8px;"> - <?php echo esc_html(__( 'One solution for all courier parcels',



                            'multiparcels-shipping-for-woocommerce' )) ?></span>



                </div>



                <h1 style="margin-bottom: 25px;">



					<?php echo esc_html(__( 'From here you could ship your orders in seconds without copying any order details, why not give it a try?',



                        'multiparcels-shipping-for-woocommerce' )) ?>



                </h1>



                <div>



                    <a href="<?php echo esc_html(__( $link,



                        'multiparcels-shipping-for-woocommerce' )); ?>" target="_blank" class="button button-primary">



						<?php echo esc_html(__( 'Get free full version', 'multiparcels-shipping-for-woocommerce' )) ?>



                    </a>



                </div>



            </div>



        </div>



		<?php



	}







	private static function labels( $id ) {


		$shipments = MultiParcels()->shippings->get_shipments( $id );







		$external_ids = [];

		foreach ( $shipments as $shipment ) {

            if (class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )) {
                if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
                    $order = wc_get_order( $shipment['order_id'] );
                    $data = $order->get_meta('multiparcels_external_id', true);

                    if ($data) {
                        $ids = explode( ',', $data );

                        foreach ( $ids as $id ) {
                            $external_ids[] = $id;
                        }

                    }
                }else {
                    $data = get_post_meta( $shipment['order_id'], 'multiparcels_external_id' );

                    if ( count( $data ) ) {

                        $ids = explode( ',', $data[0] );

                        foreach ( $ids as $id ) {
                            $external_ids[] = $id;
                        }
                    }
                }
            } else {
                $data = get_post_meta( $shipment['order_id'], 'multiparcels_external_id' );

                if ( count( $data ) ) {

                    $ids = explode( ',', $data[0] );

                    foreach ( $ids as $id ) {
                        $external_ids[] = $id;
                    }
                }
            }
//





		}

		if ( count( $external_ids ) ) {



//			$response = MultiParcels()->api_client->request( 'batch_labels', 'POST', [
//
//
//
//				'shipments' => $external_ids,
//
//
//
//			] );

            $response = MultiParcels()->api_client->request( 'api/translate/mp/batch_labels', 'POST', [



                'shipments' => $external_ids,



            ] );







			if ( $response->was_successful() ) {



				$file_name = sprintf( "labels_%d.pdf", mt_rand( 10000, 99999 ) );



//				$upload    = wp_upload_bits( $file_name, null, base64_decode( $response->get_data()['content'] ) );

                $labels_content = base64_decode($response->get_data()['content']);

                // Create a unique filename
                $labels_directory = WP_CONTENT_DIR . '/plugins/multiparcels-shipping-for-woocommerce/shipments_labels/';

                // Create the directory if it doesn't exist
                if (!file_exists($labels_directory)) {
                    mkdir($labels_directory, 0755, true);
                }

//                if (file_exists($labels_directory . $file_name)) {
//                    $file_path = $labels_directory . $file_name;
//                    unlink($file_path);
//                }

                $result = file_put_contents($labels_directory . $file_name, $labels_content);

//                $upload_url = content_url() . '/plugins/multiparcels-shipping-for-woocommerce/shipments_labels/' . $file_name;
                //$upload_url = content_url() . '/plugins/multiparcels-shipping-for-woocommerce/serve_label.php?file=' . $file_name;
                $upload_url = admin_url() . 'admin-post.php?action=serve_label&file=' . $file_name;

                header('Location: ' . $upload_url);



//				header( 'Location: ' . $upload['url'] );



				exit;



			}



		}



	}







	private static function reset_failed( $id ) {



		$shipments = MultiParcels()->shippings->get_shipments( $id, MultiParcels_Delivery_Shippings::STATUS_FAILED );







		foreach ( $shipments as $shipment ) {



			MultiParcels()->shippings->update_shipment( $shipment['id'],



				MultiParcels_Delivery_Shippings::STATUS_WAITING );



		}







		MultiParcels()->shippings->recalculate( $id );



	}







	static function shipments() {



		if ( array_key_exists( 'start', $_GET ) ) {



			self::start( $_GET['start'] );







			return;



		}







		if ( array_key_exists( 'labels', $_GET ) ) {



			self::labels( $_GET['labels'] );







			return;



		}







		if ( array_key_exists( 'reset_failed', $_GET ) ) {



			self::reset_failed( $_GET['reset_failed'] );



		}







		$table = new MultiParcels_List_Table();



		$table->prepare_items();

		?>

        <div class="wrap">



            <h1 class="wp-heading-inline">



				<?php echo esc_html(__( 'Shipments', 'multiparcels-shipping-for-woocommerce' )) ?>



            </h1>

            <a href="<?php echo esc_html(admin_url( 'edit.php?post_type=shop_order' )); ?>" class="page-title-action">



                <?php echo esc_html(__( 'Create', 'multiparcels-shipping-for-woocommerce' )) ?>



            </a>

            <hr class="wp-header-end">



            <div style="display: flex;align-items: center;">



                <?php



                if (isset($_GET['switch'])) {



                    MultiParcels()->options->set_other( 'skip_extra_step_when_mass_shipping', $_GET['switch'] == 'enable');



                }







                $enabled = MultiParcels()->options->get_other( 'skip_extra_step_when_mass_shipping' );






                // Suppress PHPCS warning for unescaped output (base64-encoded binary data)
                // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                echo sprintf('<span style="%s">%s:</span>', 'margin-right: 5px;', __("Automatically start dispatching orders", "multiparcels-shipping-for-woocommerce"));







                if ($enabled) {


                    // Suppress PHPCS warning for unescaped output (base64-encoded binary data)
                    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                    echo sprintf("<a class='button button-primary button-small' href='%s'>%s</a>", '?page=multiparcels-shippings&switch=disable', __('Yes', 'multiparcels-shipping-for-woocommerce'));



                } else {


                    // Suppress PHPCS warning for unescaped output (base64-encoded binary data)
                    // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
                    echo sprintf("<a class='button button-primary button-small' href='%s'>%s</a>", '?page=multiparcels-shippings&switch=enable', __('No', 'multiparcels-shipping-for-woocommerce'));



                }



                ?>



            </div>







            <div id="multiparcels-amazing-shipping-table">



				<?php $table->display(); ?>



            </div>



        </div>







        <style>



            #multiparcels-amazing-shipping-table .column-id, #multiparcels-amazing-shipping-table .column-done, #multiparcels-amazing-shipping-table .column-status {



                width: 70px;



            }



        </style>



		<?php



	}







	static function start( $id ) {



		$shipping = MultiParcels()->shippings->get( $id );



		$history  = MultiParcels()->shippings->get_history( $id );







		if ( ! $shipping ) {



			echo 'Not found';







			return;



		}







		echo "<div class='wrap'>";



		?>



        <h1 class="wp-heading-inline">



			<?php echo esc_html(__( 'Shipments', 'multiparcels-shipping-for-woocommerce' )) ?>



        </h1>



		<?php







		wc_get_template( 'admin/amazing-shipping.php', [



			'shipping' => $shipping,



			'history'  => $history,



		],'',MultiParcels()->plugin_path() . '/woocommerce/' );







		echo "</div>";



	}







	public function do_next() {

		$id            = $_POST['id'];



		$next_shipment = MultiParcels()->shippings->get_next_shipment( $id );







		if ( $next_shipment ) {

            if (class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )) {
                if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
                    // HPOS usage is enabled.
                    $order = wc_get_order( $next_shipment['order_id'] );
                    $already_confirmed = (bool) $order->get_meta(MP_Woocommerce_Order_Shipping::CONFIRMED_KEY, true);
                }else {
                    // Traditional CPT-based orders are in use.
                    $already_confirmed = (bool) get_post_meta( $next_shipment['order_id'], MP_Woocommerce_Order_Shipping::CONFIRMED_KEY, true );
                }
            } else {
                // Traditional CPT-based orders are in use.
                $already_confirmed = (bool) get_post_meta( $next_shipment['order_id'], MP_Woocommerce_Order_Shipping::CONFIRMED_KEY, true );
            }


			if ( ! $already_confirmed ) {



				/** @var MP_Woocommerce_Order_Shipping $shippingClass */



				$shippingClass = new MP_Woocommerce_Order_Shipping();



				$shippingClass->ship_order( $next_shipment['order_id'], [], false );







				$status = MultiParcels_Delivery_Shippings::STATUS_DONE;





                if (class_exists( \Automattic\WooCommerce\Utilities\OrderUtil::class )) {
                    if ( OrderUtil::custom_orders_table_usage_is_enabled() ) {
                        // HPOS usage is enabled.
                        $order = wc_get_order($next_shipment['order_id']);
                        if ( ! (bool) $order->get_meta(MP_Woocommerce_Order_Shipping::CONFIRMED_KEY, true) ) {
                            $status = MultiParcels_Delivery_Shippings::STATUS_FAILED;
                        }
                    }else {
                        // Traditional CPT-based orders are in use.
                        if ( ! (bool) get_post_meta( $next_shipment['order_id'], MP_Woocommerce_Order_Shipping::CONFIRMED_KEY, true ) ) {

                            $status = MultiParcels_Delivery_Shippings::STATUS_FAILED;
                        }
                    }
                } else {
                    // Traditional CPT-based orders are in use.
                    if ( ! (bool) get_post_meta( $next_shipment['order_id'], MP_Woocommerce_Order_Shipping::CONFIRMED_KEY, true ) ) {

					    $status = MultiParcels_Delivery_Shippings::STATUS_FAILED;
				    }
                }





			} else {



				$status = MultiParcels_Delivery_Shippings::STATUS_ALREADY_SHIPPED;



			}







			MultiParcels()->shippings->update_shipment( $next_shipment['id'], $status );



			MultiParcels()->shippings->recalculate( $id );



		}







		$shipping = MultiParcels()->shippings->get( $id );



		$history  = MultiParcels()->shippings->get_history( $id );







		wp_send_json_success( [



			'shipping' => $shipping,



			'next'     => $next_shipment,



			'history'  => $history,



		] );



	}



}







class MultiParcels_List_Table extends WP_List_Table {



	public function prepare_items() {







		$columns      = $this->get_columns();



		$data         = $this->table_data();



		$per_page     = 10;



		$current_Page = $this->get_pagenum();



		$total_items  = count( $data );



		$this->set_pagination_args( [



			'total_items' => $total_items,



			'per_page'    => $per_page,



		] );



		rsort( $data );



		$data                  = array_slice( $data, ( ( $current_Page - 1 ) * $per_page ), $per_page );



		$this->_column_headers = [ $columns, [], [] ];



		$this->items           = $data;



	}







	public function get_columns() {



		$columns = [







			'id'         => 'ID',



			'done'       => _x( 'Done', 'Amazing shipping', 'multiparcels-shipping-for-woocommerce' ),



			'failed'     => _x( 'Failed', 'Amazing shipping', 'multiparcels-shipping-for-woocommerce' ),



			'shipments'  => __( 'Shipments', 'multiparcels-shipping-for-woocommerce' ),



			'status'     => __( 'Status', 'multiparcels-shipping-for-woocommerce' ),



			'created_at' => __( 'Created at', 'multiparcels-shipping-for-woocommerce' ),



			'actions'    => __( 'Actions', 'multiparcels-shipping-for-woocommerce' ),



		];







		return $columns;



	}







	private function table_data() {



		return MultiParcels()->shippings->all();



	}







	public function column_default( $item, $column_name ) {



		switch ( $column_name ) {



			case 'id':



			case 'done':



			case 'shipments':



			case 'created_at':



				return $item[ $column_name ];



			case 'status':



				return sprintf(



					"<span style='color: %s'>%s</span>",



					MultiParcels()->shippings->status_color( $item[ $column_name ] ),



					MultiParcels()->shippings->status( $item[ $column_name ] )



				);



			case 'count':



				return sprintf( '%d/%d', $item['done'], $item['shipments'] );



			case 'failed':



				if ( $item['failed'] > 0 ) {



					return sprintf( "<div style='%s'>%d</div>", 'background:red;color:white;padding:5px;',



						$item['failed'] );



				} else {



					return 0;



				}



			case 'actions':



				return $this->actions_html( $item );



			default:



				return print_r( $item, true );



		}



	}







	public function actions_html( $item ) {



		$html = '';







		if ( $item['status'] == MultiParcels_Delivery_Shippings::STATUS_WAITING ) {



			$html .= sprintf(



				"<a class='button button-primary' href='%s'>%s</a>",



				MP_Amazing_shipping::link() . '&start=' . $item['id'],



				__( 'Start', 'multiparcels-shipping-for-woocommerce' )



			);







			$html .= '<div style="height: 5px;"></div>';



		} elseif ( $item['failed'] > 0 ) {



			$html .= sprintf(



				"<a class='button' href='%s'>%s</a>",



				MP_Amazing_shipping::link() . '&start=' . $item['id'],



				__( 'Failed shipments', 'multiparcels-shipping-for-woocommerce' )



			);







			$html .= '<div style="height: 5px;"></div>';



		}







		if ( $item['status'] == MultiParcels_Delivery_Shippings::STATUS_DONE && $item['done'] > 0 ) {



			$html .= sprintf(



				"<a class='button' href='%s'>%s</a>",



				MP_Amazing_shipping::link() . '&labels=' . $item['id'],



				__( 'Download all labels', 'multiparcels-shipping-for-woocommerce' )



			);







			$html .= '<div style="height: 5px;"></div>';



		}







		if ( $item['status'] == MultiParcels_Delivery_Shippings::STATUS_DONE && $item['failed'] > 0 ) {



			$html .= sprintf(



				"<a class='button' href='%s'>%s</a>",



//				wp_nonce_url( MP_Amazing_shipping::link() . '&reset_failed=' . $item['id'],
                MP_Amazing_shipping::link() . '&reset_failed=' . $item['id'],



//				__( 'Reset failed', 'multiparcels-shipping-for-woocommerce' ),'reset')
                __( 'Reset failed', 'multiparcels-shipping-for-woocommerce' )



			);







			$html .= '<div style="height: 5px;"></div>';



		}







		$html .= sprintf( "<a class='button' href='%s'>%s</a>",



				wp_nonce_url(admin_url( 'admin-post.php?action=' . MP_Amazing_shipping::ACTION_DELETE_SHIPPING . '&id=' . $item['id'] ),'delete'),



			__( 'Delete', 'multiparcels-shipping-for-woocommerce' ) );







		return $html;



	}



}







return new MP_Amazing_shipping();



