// DOM.event.move
//
// 2.0.0
//
// Stephen Band
//
// Triggers 'movestart', 'move' and 'moveend' events after
// mousemoves following a mousedown cross a distance threshold,
// similar to the native 'dragstart', 'drag' and 'dragend' events.
// Move events are throttled to animation frames. Move event objects
// have the properties:
//
// pageX:
// pageY:     Page coordinates of pointer.
// startX:
// startY:    Page coordinates of pointer at movestart.
// distX:
// distY:     Distance the pointer has moved since movestart.
// deltaX:
// deltaY:    Distance the finger has moved since last event.
// velocityX:
// velocityY: Average velocity over last few events.
!function(e){"function"==typeof define&&define.amd?define([],e):"undefined"!=typeof module&&null!==module&&module.exports?module.exports=e:e()}(function(){var e=Object.assign||window.jQuery&&jQuery.extend,t=window.requestAnimationFrame||window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(e,t){return window.setTimeout(function(){e()},25)};!function(){if("function"==typeof window.CustomEvent)return!1;function e(e,t){t=t||{bubbles:!1,cancelable:!1,detail:void 0};var n=document.createEvent("CustomEvent");return n.initCustomEvent(e,t.bubbles,t.cancelable,t.detail),n}e.prototype=window.Event.prototype,window.CustomEvent=e}();var n={textarea:!0,input:!0,select:!0,button:!0},i={move:"mousemove",cancel:"mouseup dragstart",end:"mouseup"},a={move:"touchmove",cancel:"touchend",end:"touchend"},o=/\s+/,r={bubbles:!0,cancelable:!0},c="function"==typeof Symbol?Symbol("events"):{};function u(e){return e[c]||(e[c]={})}function v(e,t,n,i,a){t=t.split(o);var r,c,v=u(e),f=t.length;function s(e){n(e,i)}for(;f--;)(r=v[c=t[f]]||(v[c]=[])).push([n,s]),e.addEventListener(c,s)}function f(e,t,n,i){t=t.split(o);var a,r,c,v=u(e),f=t.length;if(v){for(;f--;)if(r=v[a=t[f]])for(c=r.length;c--;)r[c][0]===n&&(e.removeEventListener(a,r[c][1]),r.splice(c,1))}}function s(t,n,i){var a,o=(a=n,new CustomEvent(a,r));i&&e(o,i),t.dispatchEvent(o)}function d(e){var n=e,i=!1,a=!1;this.kick=function(e){i=!0,a||function e(o){i?(n(),t(e),a=!0,i=!1):a=!1}()},this.end=function(e){var t=n;e&&(a?(n=i?function(){t(),e()}:e,i=!0):e())}}function m(){}function l(e){e.preventDefault()}function p(e,t){var n,i;if(e.identifiedTouch)return e.identifiedTouch(t);for(n=-1,i=e.length;++n<i;)if(e[n].identifier===t)return e[n]}function g(e,t){var n=p(e.changedTouches,t.identifier);if(n&&(n.pageX!==t.pageX||n.pageY!==t.pageY))return n}function h(e,t){b(e,t,e,Y)}function X(e,t){Y()}function Y(){f(document,i.move,h),f(document,i.cancel,X)}function y(e){f(document,a.move,e.touchmove),f(document,a.cancel,e.touchend)}function b(e,t,n,i){var a,o,r,c,u,v,f,d,l,p=n.pageX-t.pageX,g=n.pageY-t.pageY;if(!(p*p+g*g<64)){a=e,o=t,r=n,c=p,u=g,v=i,f=a.targetTouches,d=a.timeStamp-o.timeStamp,l={altKey:a.altKey,ctrlKey:a.ctrlKey,shiftKey:a.shiftKey,startX:o.pageX,startY:o.pageY,distX:c,distY:u,deltaX:c,deltaY:u,pageX:r.pageX,pageY:r.pageY,velocityX:c/d,velocityY:u/d,identifier:o.identifier,targetTouches:f,finger:f?f.length:1,enableMove:function(){this.moveEnabled=!0,this.enableMove=m,a.preventDefault()}},s(o.target,"movestart",l),v(o)}}function $(e,t){var n=t.timer;t.touch=e,t.timeStamp=e.timeStamp,n.kick()}function T(e,t){var n=t.target,a=t.event,o=t.timer;f(document,i.move,$),f(document,i.end,T),_(n,a,o,function(){setTimeout(function(){f(n,"click",l)},0)})}function _(e,t,n,i){n.end(function(){return s(e,"moveend",t),i&&i()})}if(v(document,"mousedown",function e(t){var a,o;if(1===(a=t).which&&!a.ctrlKey&&!a.altKey)!n[(o=t).target.tagName.toLowerCase()]&&(v(document,i.move,h,t),v(document,i.cancel,X,t))}),v(document,"touchstart",function e(t){if(!n[t.target.tagName.toLowerCase()]){var i=t.changedTouches[0],o={target:i.target,pageX:i.pageX,pageY:i.pageY,identifier:i.identifier,touchmove:function(e,t){var n,i,a;n=e,i=t,a=g(n,i),a&&b(n,i,a,y)},touchend:function(e,t){var n,i;n=e,i=t,p(n.changedTouches,i.identifier)&&y(i)}};v(document,a.move,o.touchmove,o),v(document,a.cancel,o.touchend,o)}}),v(document,"movestart",function e(t){if(!t.defaultPrevented&&t.moveEnabled){var n={startX:t.startX,startY:t.startY,pageX:t.pageX,pageY:t.pageY,distX:t.distX,distY:t.distY,deltaX:t.deltaX,deltaY:t.deltaY,velocityX:t.velocityX,velocityY:t.velocityY,identifier:t.identifier,targetTouches:t.targetTouches,finger:t.finger},o={target:t.target,event:n,timer:new d(function e(t){var i,a,r,c;i=n,a=o.touch,c=(r=o.timeStamp)-i.timeStamp,i.distX=a.pageX-i.startX,i.distY=a.pageY-i.startY,i.deltaX=a.pageX-i.pageX,i.deltaY=a.pageY-i.pageY,i.velocityX=.3*i.velocityX+.7*i.deltaX/c,i.velocityY=.3*i.velocityY+.7*i.deltaY/c,i.pageX=a.pageX,i.pageY=a.pageY,s(o.target,"move",n)}),touch:void 0,timeStamp:t.timeStamp};void 0===t.identifier?(v(t.target,"click",l),v(document,i.move,$,o),v(document,i.end,T,o)):(o.activeTouchmove=function(e,t){var n,i,a,o,r;n=e,i=t,a=i.event,o=i.timer,r=g(n,a),r&&(n.preventDefault(),a.targetTouches=n.targetTouches,i.touch=r,i.timeStamp=n.timeStamp,o.kick())},o.activeTouchend=function(e,t){!function e(t,n){var i,o=n.target,r=n.event,c=n.timer;if(p(t.changedTouches,r.identifier)){i=n,f(document,a.move,i.activeTouchmove),f(document,a.end,i.activeTouchend),_(o,r,c)}}(e,t)},v(document,a.move,o.activeTouchmove,o),v(document,a.end,o.activeTouchend,o))}}),window.jQuery){var E="startX startY pageX pageY distX distY deltaX deltaY velocityX velocityY".split(" ");jQuery.event.special.movestart={setup:function(){return v(this,"movestart",w),!1},teardown:function(){return f(this,"movestart",w),!1},add:K},jQuery.event.special.move={setup:function(){return v(this,"movestart",S),!1},teardown:function(){return f(this,"movestart",S),!1},add:K},jQuery.event.special.moveend={setup:function(){return v(this,"movestart",k),!1},teardown:function(){return f(this,"movestart",k),!1},add:K}}function w(e){e.enableMove()}function S(e){e.enableMove()}function k(e){e.enableMove()}function K(e){var t=e.handler;e.handler=function(e){for(var n,i=E.length;i--;)e[n=E[i]]=e.originalEvent[n];t.apply(this,arguments)}}});