<?php
defined( 'ABSPATH' ) or exit;

class Montonio_DPD_Parcel_Machines extends Montonio_Shipping_Method {
    protected $max_dimensions = array( 36, 43, 61 ); // lowest to highest (cm)

    public $default_title      = 'DPD parcel machines';
    public $default_max_weight = 31.5; // kg

    /**
     * Called from parent's constructor
     *
     * @return void
     */
    protected function init() {
        $this->id                 = 'montonio_dpd_parcel_machines';
        $this->method_title       = __( 'Montonio DPD parcel machines', 'montonio-for-woocommerce' );
        $this->method_description = __( 'DPD parcel machines', 'montonio-for-woocommerce' );
        $this->supports           = array(
            'shipping-zones',
            'instance-settings',
            'instance-settings-modal'
        );

        $this->carrier_code = 'dpd';
        $this->type_v2       = 'parcelMachine';
        $this->title         = $this->get_option( 'title', __( 'DPD parcel machines', 'montonio-for-woocommerce' ) );

        if ( 'DPD parcel machines' === $this->title ) {
            $this->title = __( 'DPD parcel machines', 'montonio-for-woocommerce' );
        }
    }
}
