<?php
defined( 'ABSPATH' ) or exit;

class Montonio_DPD_Courier extends Montonio_Shipping_Method {
    public $default_title      = 'DPD courier';
    public $default_max_weight = 31; // kg

    /**
     * Called from parent's constructor
     *
     * @return void
     */
    protected function init() {
        $this->id                 = 'montonio_dpd_courier';
        $this->method_title       = __( 'Montonio DPD courier', 'montonio-for-woocommerce' );
        $this->method_description = __( 'DPD courier', 'montonio-for-woocommerce' );
        $this->supports           = array(
            'shipping-zones',
            'instance-settings',
            'instance-settings-modal'
        );

        $this->carrier_code = 'dpd';
        $this->type_v2       = 'courier';
        $this->title         = $this->get_option( 'title', __( 'DPD courier', 'montonio-for-woocommerce' ) );

        if ( 'DPD courier' === $this->title ) {
            $this->title = __( 'DPD courier', 'montonio-for-woocommerce' );
        }
    }
}
