(function ($) {
    'use strict';

    // Reset default email tracking code text
    $(document).on('click', '.montonio-reset-email-tracking-code-text', function (e) {
        e.preventDefault();

        $('#montonio_email_tracking_code_text').val('Track your shipment:');
    });

    // Conditionaliy toggle order prefix id field visibility
    function togglePrefixfield() {
        var selectedVal = $('#woocommerce_wc_montonio_api_merchant_reference_type').val();

        if (selectedVal === 'add_prefix') {
            $('#woocommerce_wc_montonio_api_order_prefix').closest('tr').show();
        } else {
            $('#woocommerce_wc_montonio_api_order_prefix').closest('tr').hide();
        }
    }

    togglePrefixfield();

    $(document).on('change', '#woocommerce_wc_montonio_api_merchant_reference_type', function () {
        togglePrefixfield();
    });


    // Add loader when settings are saved
    var currentUrl = window.location.href;
    if (currentUrl.indexOf('tab=montonio_shipping') !== -1) {
        $('button.woocommerce-save-button').on('click', function () {
            $(this).css('pointer-events', 'none');

            if ($('#montonio_shipping_enabled').is(':checked')) {
                $(this).after('<div class="montonio-options-loader">Syncing pickup points, please wait!</div>');
            }
        });

    }

    // Move the p.submit element inside .montonio-options__content
    function adjustOptionsLayout() {
        var $montonioOptions = $('.montonio-options');
        var $montonioOptionsContent = $('.montonio-options .montonio-options__container .montonio-options__content');
        var $submitButton = $('p.submit');

        if ($montonioOptions.length === 0 || $submitButton.length === 0) {
            return;
        }

        // Check if submit button is already inside .montonio-options
        if ($montonioOptions.find('p.submit').length > 0) {
            return;
        }

        // Find all elements between .montonio-options and p.submit (inclusive)
        var $elementsToWrap = $montonioOptions.nextUntil('p.submit').add($submitButton);

        // Move elements into .montonio-options
        $elementsToWrap.appendTo($montonioOptionsContent);

        $montonioOptions.find('button.woocommerce-save-button').removeClass('components-button is-primary button-primary').addClass('montonio-button');
    }

    adjustOptionsLayout();

    // Hide the Montonio banner when the dismiss button or close button is clicked
    $('.montonio-banner__close').on('click', function (e) {
        e.preventDefault();

        var bannerId = $(this).closest('.montonio-banner').attr('id');

        $(this).closest('.montonio-banner').addClass('hidden');

        updateBannerVisibility(bannerId);
    });

    function updateBannerVisibility(bannerId) {
        $.post(
            ajaxurl,
            {
                action: 'update_montonio_banner_visibility',
                id: bannerId,
                _ajax_nonce: $('#' + bannerId + ' #_wpnonce').val()
            },
            function () {
                console.log('Banner visibility updated');
            }
        );
    }

    function toggleInternationalShippinhPricingTypeElemStates($modal) {
        const $pricingTypeSelectElem = $modal.find('select[id*="pricing_type"]');
        const $flatRateCostInputElem = $modal.find('input[id*="flat_rate_cost"]');
        if ($pricingTypeSelectElem.val() !== 'flat_rate') {
            $flatRateCostInputElem.prop('disabled', true);
        }
        $pricingTypeSelectElem.on('change', function () {
            if ($(this).val() === 'flat_rate') {
                $flatRateCostInputElem.prop('disabled', false);
            } else {
                $flatRateCostInputElem.prop('disabled', true);
            }
        });
    }

    // Apply International Shipping settings UX rules
    $(document.body).on('wc_backbone_modal_loaded', function (e, target) {
        // Only run for the shipping method settings modal
        if (target !== 'wc-modal-shipping-method-settings') {
            return;
        }

        var $modal = $('#wc-backbone-modal-dialog');
        toggleInternationalShippinhPricingTypeElemStates($modal);

        var $modal = $('#wc-backbone-modal-dialog');
        var $saveButton = $('#btn-ok');

        // Find all required default dimension fields
        var $defaultLength = $modal.find('input[id*="default_length"]');
        var $defaultWidth = $modal.find('input[id*="default_width"]');
        var $defaultHeight = $modal.find('input[id*="default_height"]');
        var $defaultWeight = $modal.find('input[id*="default_weight"]');

        // Only proceed if these fields exist in this modal
        if ($defaultLength.length === 0) {
            return;
        }

        function checkRequiredFields() {
            var allFilled = true;

            [$defaultLength, $defaultWidth, $defaultHeight, $defaultWeight].forEach(function ($field) {
                if (!$.trim($field.val())) {
                    $field.css('border', '2px solid var(--wc-red, #a00)');
                    allFilled = false;
                } else {
                    $field.css('border', '');   
                }
            });

            if (!allFilled) {
                $saveButton.prop('disabled', true).addClass('disabled');
            } else {
                $saveButton.prop('disabled', false).removeClass('disabled');
            }
        }

        // Check on page load
        checkRequiredFields();

        // Check on input change
        $defaultLength.add($defaultWidth).add($defaultHeight).add($defaultWeight).on('input change', function () {
            checkRequiredFields();
        });
    });

})(jQuery);