<?php

defined( 'ABSPATH' ) or exit; // Exit if accessed directly

if ( empty( $options['author_box_meta_show'] ) )
{
    return;
}

$meta      = '';
$nofollow  = ( $options['social_profiles_nofollow'] ? 'rel="nofollow"' : '' );
$separator = sprintf( '&nbsp;%s&nbsp;', '<span class="m-a-box-meta-divider">'.$options['author_box_meta_divider'].'</span>' );

$author_job = $author_company = $author_phone = $author_email = $author_web = $author_meta = '';
if ( !empty( $profile->get_meta( 'job' ) ) )
{
    $author_job = '<span ' . ( $add_microdata ? 'itemprop="jobTitle"' : '' ) . '>' . esc_html( $profile->get_meta( 'job' ) ) . '</span>';
}
if ( !empty( $profile->get_meta( 'company' ) ) )
{
    $author_company = sprintf(
        '%s%s%s%s%s'
        , '<span ' . ( $add_microdata ? 'itemprop="worksFor" itemscope itemtype="https://schema.org/Organization"' : '' ) . '>'
        , $profile->get_meta( 'company_link' ) ? '<a href="' . esc_url( $profile->get_meta( 'company_link' ) ) . '" target="_blank" '.( $add_microdata ? 'itemprop="url"' : '' ). $nofollow . '>' : ''
        , '<span ' . ( $add_microdata ? 'itemprop="name"' : '' ) . '>' . esc_html( $profile->get_meta( 'company' ) ) . '</span>'
        , $profile->get_meta( 'company_link' ) ? '</a>' : ''
        , '</span>'
    );
}
if ( !empty( $profile->get_meta( 'phone' ) ) )
{
    $author_phone = '<a href="tel:'.esc_attr( $profile->get_meta( 'phone' ) ).'"'. ( $add_microdata ? ' itemprop="telephone"' : '' ) . ' content="'.esc_attr( $profile->get_meta( 'phone' ) ).'" '.$nofollow.'>' . esc_html( $profile->get_meta( 'phone' ) ) . '</a>';
    $author_phone = apply_filters( 'authorship/box/meta/phone', $author_phone, $profile->get_meta( 'phone' ), $add_microdata, $nofollow );
}
if ( !empty( $profile->get_email() ) )
{
    $author_email = '<a href="mailto:'.esc_attr( $profile->get_email() ).'" target="_top"'. ( $add_microdata ? ' itemprop="email"' : '' ) . ' content="'.esc_attr( $profile->get_email() ).'" '.$nofollow.'>' . esc_html( $profile->get_email() ) . '</a>';
    $author_email = apply_filters( 'authorship/box/meta/email', $author_email, $profile->get_email(), $add_microdata, $nofollow );

}
if ( !empty( $profile->get_website() ) )
{
    $author_web = '<a href="' . esc_attr( $profile->get_website() ) . '" target="_blank" '. $nofollow . '>'
                  . '<span class="m-a-box-string-web">' . apply_filters( 'authorship/box/meta/web', ( $options['author_box_meta_web'] ? $options['author_box_meta_web'] : __( "Website", 'molongui-authorship' ) ), $profile ) . '</span>'
                  . '</a>';
}
if ( 'slim' === $options['author_box_layout'] and $options['author_box_show_related_posts'] and ( $profile->has_posts() or !empty( $options['author_box_related_show_empty'] ) ) )
{
    $more_posts_label = !empty( $options[ 'author_box_meta_posts' ] )
        ? esc_html( apply_filters( 'authorship/box/meta/more', $options['author_box_meta_posts'], $profile ) )
        : __( "+ posts", 'molongui-authorship' );

    $bio_label = !empty( $options[ 'author_box_meta_bio' ] )
        ? esc_html( apply_filters( 'authorship/box/meta/bio', $options['author_box_meta_bio'], $profile ) )
        : __( "Bio ⮌", 'molongui-authorship' );

    ob_start(); ?>

    <a href="#" class="m-a-box-data-toggle" rel="nofollow">
        <span class="m-a-box-string-more-posts">
            <?php echo esc_html( $more_posts_label ); ?>
        </span>
        <span class="m-a-box-string-bio" style="display:none">
            <?php echo esc_html( $bio_label ); ?>
        </span>
    </a>

    <?php $author_more = ob_get_clean();
}

$showing_job = $showing_company = $showing_phone = $showing_email = $showing_web = $showing_more = false;
if ( !empty( $author_job ) )
{
    $showing_job = true;
    $meta .= $author_job;
}
if ( !empty( $author_company ) )
{
    if ( !empty( $showing_job ) )
    {
        $meta .= sprintf( '%s%s%s'
            , '&nbsp;'
            , '<span class="m-a-box-string-at">' . apply_filters( 'authorship/box/meta/at', ( $options['author_box_meta_at'] ? esc_attr( $options['author_box_meta_at'] ) : __( "at", 'molongui-authorship' ) ), $profile ).'</span>'
            , '&nbsp;'
        );
    }

    $showing_company = true;
    $meta .= $author_company;
}
if ( !empty( $author_phone ) and ( $options['author_box_meta_show_phone'] or $profile->get_meta( 'show_meta_phone' ) ) )
{
    if ( !empty( $showing_job ) or !empty( $showing_company ) )
    {
        $meta .= apply_filters( 'molongui_authorship/author_meta_separator', $separator, 'phone' );
    }

    $showing_phone = true;
    $meta .= $author_phone;
}
if ( !empty( $author_email ) and ( $options['author_box_meta_show_email'] or $profile->get_meta( 'show_meta_mail' ) ) )
{
    if ( !empty( $showing_job ) or !empty( $showing_company ) or !empty( $showing_phone ) )
    {
        $meta .= apply_filters( 'molongui_authorship/author_meta_separator', $separator, 'email' );
    }

    $showing_email = true;
    $meta .= $author_email;
}
if ( !empty( $author_web ) )
{
    if ( !empty( $showing_job ) or !empty( $showing_company ) or !empty( $showing_phone ) or !empty( $showing_email ) )
    {
        $meta .= apply_filters( 'molongui_authorship/author_meta_separator', $separator, 'web' );
    }

    $showing_web = true;
    $meta .= $author_web;
}
if ( !empty( $author_more ) )
{
    if ( !empty( $showing_job ) or !empty( $showing_company ) or !empty( $showing_phone ) or !empty( $showing_email ) or !empty( $showing_web ) )
    {
        $meta .= apply_filters( 'molongui_authorship/author_meta_separator', $separator, 'more' );
    }

    $showing_more = true;
    $meta .= $author_more;
}

if ( empty( $meta ) )
{
    return;
}

?>

<div class="m-a-box-item m-a-box-meta">
    <?php echo $meta; ?>
    <?php if ( !empty( $author_more ) and !did_action( 'molongui_authorship/slim_content_toggle' ) ) : ?>
    <?php do_action( 'molongui_authorship/slim_content_toggle' ); ?>
    <script type="text/javascript">

        document.addEventListener('DOMContentLoaded', function()
        {
            document.addEventListener('click', function(event)
            {
                const target = event.target.closest('.m-a-box-data-toggle');

                if (target)
                {
                    event.preventDefault();

                    let authorBox = target.closest('.m-a-box');
                    if ( authorBox.getAttribute('data-multiauthor') )
                    {
                        authorBox = target.closest('[data-author-ref]');
                    }

                    if (authorBox)
                    {
                        const postLabel = target.querySelector('.m-a-box-string-more-posts');
                        const bioLabel  = target.querySelector('.m-a-box-string-bio');

                        if ( postLabel.style.display === "none" )
                        {
                            postLabel.style.display = "inline";
                            bioLabel.style.display  = "none";
                        }
                        else
                        {
                            postLabel.style.display = "none";
                            bioLabel.style.display  = "inline";
                        }
                        const bio     = authorBox.querySelector('.m-a-box-bio');
                        const related = authorBox.querySelector('.m-a-box-related-entries');

                        if ( related.style.display === "none" )
                        {
                            related.style.display = "block";
                            bio.style.display     = "none";
                        }
                        else
                        {
                            related.style.display = "none";
                            bio.style.display     = "block";
                        }
                    }
                }
            });
        });
    </script>
    <?php endif; ?>
</div>
