<?php
/*!
 * Utility class to render UI components for the settings page of the plugin.
 *
 * @author     Molongui
 * @package    Framework
 * @subpackage fw/core/modules/settings
 * @since      3.3.0
 */

namespace Molongui\Authorship\Common\Modules\Settings;

use Molongui\Authorship\Common\Utils\WP;

defined( 'ABSPATH' ) or exit; // Exit if accessed directly
class UI
{
    public static function allowed_html()
    {
        return array
        (
            'style'  => array(),
            'div'    => array
            (
                'id'    => array(),
                'class' => array(),
                'style' => array(),
                'title' => array(),
            ),
            'span'   => array
            (
                'id'    => array(),
                'class' => array(),
                'style' => array(),
                'title' => array(),
            ),
            'p'      => array
            (
                'id'    => array(),
                'class' => array(),
                'style' => array(),
                'title' => array(),
            ),
            'ol'     => array
            (
                'id'    => array(),
                'class' => array(),
                'style' => array(),
            ),
            'ul'     => array
            (
                'id'    => array(),
                'class' => array(),
                'style' => array(),
                'title' => array(),
            ),
            'li'     => array
            (
                'id'    => array(),
                'class' => array(),
                'style' => array(),
                'title' => array(),
            ),
            'img'    => array
            (
                'src'    => array(),
                'height' => array(),
                'width'  => array(),
                'alt'    => array(),
                'title'  => array(),
                'id'     => array(),
                'class'  => array(),
                'style'  => array(),
            ),
            'code'   => array
            (
                'id'    => array(),
                'class' => array(),
                'style' => array(),
                'title' => array(),
            ),
            'br'     => array(),
            'hr'     => array(),
            'em'     => array(),
            'strong' => array(),
            'b'      => array(),
            'i'      => array
            (
                'id'     => array(),
                'title'  => array(),
                'class'  => array(),
                'style'  => array(),
            ),
            'a'      => array
            (
                'id'     => array(),
                'href'   => array(),
                'target' => array(),
                'title'  => array(),
                'class'  => array(),
                'style'  => array(),
            ),
            'select'  => array
            (
                'type'     => array(),
                'id'       => array(),
                'name'     => array(),
                'value'    => array(),
                'style'    => array(),
                'class'    => array(),
                'disabled' => array(),
            ),
            'option' => array
            (
                'id'       => array(),
                'name'     => array(),
                'value'    => array(),
                'style'    => array(),
                'class'    => array(),
                'title'    => array(),
                'selected' => array(),
                'disabled' => array(),
            ),
            'input'  => array
            (
                'type'        => array(),
                'id'          => array(),
                'name'        => array(),
                'class'       => array(),
                'style'       => array(),
                'title'       => array(),
                'value'       => array(),
                'disabled'    => array(),
                'placeholder' => array(),
                'checked'     => array(),
                'min'         => array(),
                'max'         => array(),
            ),
            'label'  => array
            (
                'for'   => array(),
                'id'    => array(),
                'class' => array(),
                'style' => array(),
                'title' => array(),
            ),
            'textarea' => array
            (
                'id'       => array(),
                'name'     => array(),
                'class'    => array(),
                'style'    => array(),
                'title'    => array(),
                'value'    => array(),
                'readonly' => array(),
                'rows'     => array(),
                'disabled' => array(),
            ),
            'svg' => array
            (
                'class'           => array(),
                'style'           => array(),
                'version'         => array(),
                'xmlns'           => array(),
                'width'           => array(),
                'height'          => array(),
                'viewbox'         => array(), // Must be lowercase!
                'role'            => array(),
                'fill'            => array(),
                'transform'       => array(),
                'aria-hidden'     => array(),
                'aria-labelledby' => array(),
                'stroke'          => true,
                'stroke-width'    => true,
                'stroke-linecap'  => true,
                'stroke-linejoin' => true,
            ),
            'g' => array
            (
                'class'           => array(),
                'style'           => array(),
                'role'            => array(),
                'fill'            => array(),
                'transform'       => array(),
                'aria-hidden'     => array(),
                'aria-labelledby' => array(),
                'stroke'          => true,
                'stroke-width'    => true,
                'stroke-linecap'  => true,
                'stroke-linejoin' => true,
            ),
            'path' => array
            (
                'fill'            => array(),
                'd'               => array(),
                'class'           => array(),
                'style'           => array(),
                'stroke'          => true,
                'stroke-width'    => true,
                'stroke-linecap'  => true,
                'stroke-linejoin' => true,
            ),
            'circle' => array
            (
                'class'           => array(),
                'style'           => array(),
                'cx'              => true,
                'cy'              => true,
                'r'               => true,
                'fill'            => true,
                'stroke'          => true,
                'stroke-width'    => true,
                'stroke-linecap'  => true,
                'stroke-linejoin' => true,
            ),
            'line' => array
            (
                'x1'              => true,
                'y1'              => true,
                'x2'              => true,
                'y2'              => true,
                'stroke'          => true,
                'stroke-width'    => true,
                'stroke-linecap'  => true,
                'stroke-linejoin' => true,
            ),
            'polygon' => array
            (
                'fill'            => array(),
                'class'           => array(),
                'style'           => array(),
                'points'          => array(),
            ),
        );
    }
    public static function get_icon( $id = null )
    {
        $icon = '';

        if ( !isset( $id ) )
        {
            return $icon;
        }

        switch ( $id )
        {
            case 'bulb':
            case 'tip':
                $icon = '<svg height="32px" width="32px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve" fill="#000000" transform="rotate(0)" stroke="#000000"><g stroke-width="0"></g><g stroke-linecap="round" stroke-linejoin="round"></g><g><path fill="#0CA7A6" d="M211.027,432.705v34.321l0,0C211.027,491.865,231.162,512,256,512s44.973-20.135,44.973-44.973 v-34.321L211.027,432.705z"></path> <path fill="#26D9DA" d="M256,432.705h-44.973v34.321l0,0C211.027,491.865,231.162,512,256,512V432.705z"></path> <path fill="#FBB500" d="M256,0C160.451,0,82.994,77.457,82.994,173.006c0,47.263,18.952,90.1,49.671,121.325l0.011-0.013 c21.017,20.943,36.017,47.916,42.219,78.1v24.643h162.208v-24.643c6.201-30.183,21.201-57.157,42.219-78.1l0.012,0.013 c30.719-31.225,49.671-74.061,49.671-121.325C429.006,77.457,351.549,0,256,0z"></path> <path fill="#FFCE47" d="M256,397.061V0C160.451,0,82.994,77.457,82.994,173.006c0,47.263,18.952,90.1,49.671,121.325 l0.011-0.013c21.017,20.943,36.017,47.916,42.219,78.1v24.643H256z"></path> <path fill="#FFF1D8" d="M305.093,378.258h-31.347V259.911h-35.494v118.347h-31.347V259.911h-10.659 c-23.162,0-42.006-18.844-42.006-42.005c0-23.162,18.844-42.006,42.006-42.006s42.006,18.844,42.006,42.006v10.658h35.494v-10.658 c0-23.162,18.844-42.006,42.006-42.006c23.162,0,42.006,18.844,42.006,42.006c0,23.161-18.844,42.005-42.006,42.005h-10.659V378.258 z M305.093,228.564h10.659c5.878,0,10.659-4.781,10.659-10.658c0-5.878-4.781-10.659-10.659-10.659 c-5.878,0-10.659,4.781-10.659,10.659V228.564z M196.248,207.247c-5.878,0-10.659,4.781-10.659,10.659 c0,5.876,4.781,10.658,10.659,10.658h10.659v-10.658C206.907,212.029,202.124,207.247,196.248,207.247z"></path> <path fill="#0CA7A6" d="M348.889,393.682c0-8.968-4.715-16.818-11.784-21.264H174.896 c-7.071,4.446-11.784,12.295-11.784,21.264c0,11.896,8.277,21.837,19.38,24.439h0.029c-6.663,4.518-11.042,12.151-11.042,20.807 c0,13.876,11.248,25.125,25.125,25.125h118.797c13.875,0,25.125-11.248,25.125-25.125c0-8.657-4.379-16.29-11.042-20.807h0.029 C340.612,415.519,348.889,405.578,348.889,393.682z"></path> <path fill="#26D9DA" d="M256,372.418h-81.104c-7.071,4.446-11.784,12.295-11.784,21.264c0,11.896,8.277,21.837,19.38,24.439 h0.029c-6.663,4.518-11.042,12.151-11.042,20.807c0,13.876,11.248,25.125,25.125,25.125H256V372.418z"></path> <path fill="#008E8E" d="M329.48,418.12H182.52c-6.663,4.518-11.042,12.151-11.042,20.807 c0,13.876,11.248,25.125,25.125,25.125h118.797c13.875,0,25.125-11.248,25.125-25.125 C340.523,430.271,336.143,422.638,329.48,418.12z"></path><path fill="#0CA7A6" d="M256,418.12h-73.48c-6.663,4.518-11.042,12.151-11.042,20.807c0,13.876,11.248,25.125,25.125,25.125 H256V418.12z"></path></g></svg>';
                break;

            case 'filter':
                $icon = '<svg height="32px" width="32px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="-51.2 -51.2 614.40 614.40" xml:space="preserve" fill="#000000" transform="rotate(0)"><g stroke-width="0" transform="translate(0,0), scale(1)"></g><g stroke-linecap="round" stroke-linejoin="round" stroke="#CCCCCC" stroke-width="11.264"></g><g> <g> <g> <path fill="#B2F3FF" d="M480,0H32C18.766,0,8,10.766,8,24v38.578c0,8.109,3.039,15.844,8.555,21.773l187.172,210.188 c2.758,2.969,4.273,6.828,4.273,10.883v130.086c0,10.43,5.102,20.227,13.648,26.211l69.766,48.836 c1.367,0.961,2.977,1.445,4.586,1.445c1.266,0,2.531-0.297,3.695-0.906c2.648-1.375,4.305-4.109,4.305-7.094V305.422 c0-4.055,1.516-7.914,4.273-10.883L495.445,84.352c5.516-5.93,8.555-13.664,8.555-21.773V24C504,10.766,493.234,0,480,0z"></path> </g> <g> <path fill="#51DBFF" d="M8.133,64c0.337,7.581,3.233,14.774,8.421,20.352l187.172,210.188 c0.423,0.455,0.759,0.966,1.123,1.461h102.302c0.363-0.495,0.7-1.006,1.123-1.461L495.445,84.352 c5.188-5.578,8.084-12.771,8.421-20.352H8.133z"></path> </g> <g> <path fill="#51DBFF" d="M256,0H32C18.766,0,8,10.766,8,24v38.578c0,8.109,3.039,15.844,8.555,21.773l187.172,210.188 c2.758,2.969,4.273,6.828,4.273,10.883v130.086c0,10.43,5.102,20.227,13.648,26.211L256,485.765V0z"></path> </g> <g> <path fill="#45BDF0" d="M256,296V64H8.133c0.167,3.772,0.974,7.446,2.375,10.875c0.116,0.279,0.285,0.533,0.409,0.809 c0.625,1.412,1.304,2.803,2.134,4.114c1.028,1.604,2.185,3.137,3.503,4.554l187.172,210.188c0.423,0.455,0.759,0.966,1.123,1.461 H256z"></path> </g> <g> <path fill="#527991" d="M256,24H12C5.373,24,0,18.627,0,12v0C0,5.373,5.373,0,12,0l244,0V24z"></path> </g> <g> <path fill="#45BDF0" d="M500,24H256V0l244,0c6.627,0,12,5.373,12,12v0C512,18.627,506.627,24,500,24z"></path> </g> </g> </g></svg>';
                break;

            case 'premium':
                $icon = '<svg height="32px" width="32px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 511.351 511.351" xml:space="preserve" fill="#000000"><g id="SVGRepo_iconCarrier"> <g> <g> <path fill="#E9001E" d="M241.005,338.937c1.664-2.516,4.555-3.875,7.625-3.531l138.562,16.648 c2.5,0.305,4.719,1.766,5.977,3.945l50.43,87.352c1.344,2.328,1.43,5.18,0.227,7.578c-1.203,2.406-3.539,4.047-6.211,4.367 l-57.086,6.812l-34.445,46.031c-1.516,2.031-3.891,3.211-6.406,3.211c-0.156,0-0.32-0.008-0.484-0.016 c-2.688-0.164-5.109-1.664-6.453-4l-92-160C239.231,344.719,239.333,341.461,241.005,338.937z"></path> </g> <g> <path fill="#FF4F19" d="M323.746,363.336c-1.508-2.617-1.406-5.875,0.266-8.398c1.664-2.516,4.555-3.875,7.625-3.531 l63.27,7.602l48.693,84.343c1.344,2.328,1.43,5.18,0.227,7.578c-1.203,2.406-3.539,4.047-6.211,4.367l-57.075,6.811 L323.746,363.336z"></path> </g> <g> <path fill="#FF4F19" d="M270.348,338.937c-1.664-2.516-4.555-3.875-7.625-3.531L124.16,352.055 c-2.5,0.305-4.719,1.766-5.977,3.945l-50.43,87.352c-1.344,2.328-1.43,5.18-0.227,7.578c1.203,2.406,3.539,4.047,6.211,4.367 l57.086,6.812l34.445,46.031c1.516,2.031,3.891,3.211,6.406,3.211c0.156,0,0.32-0.008,0.484-0.016 c2.688-0.164,5.109-1.664,6.453-4l92-160C272.121,344.719,272.019,341.461,270.348,338.937z"></path> </g> <g> <path fill="#E9001E" d="M187.607,363.336c1.508-2.617,1.406-5.875-0.266-8.398c-1.664-2.516-4.555-3.875-7.625-3.531 l-63.27,7.602l-48.693,84.343c-1.344,2.328-1.43,5.18-0.227,7.578c1.203,2.406,3.539,4.047,6.211,4.367l57.075,6.811 L187.607,363.336z"></path> </g> <g> <path fill="#FFD200" d="M437.238,163.875c-8.109-8.062-15.781-15.68-18.914-23.234c-3.367-8.109-3.391-19.82-3.414-31.148 C414.863,91.547,414.824,73,402.754,60.93c-12.07-12.078-30.625-12.117-48.562-12.164c-11.328-0.023-23.039-0.055-31.148-3.414 c-7.562-3.133-15.18-10.805-23.242-18.922C287.496,14.039,273.551,0,255.676,0s-31.82,14.039-44.125,26.43 c-8.062,8.117-15.68,15.789-23.242,18.922c-8.109,3.367-19.82,3.391-31.148,3.414c-17.937,0.047-36.484,0.086-48.562,12.156 C96.527,73,96.488,91.547,96.441,109.484c-0.023,11.328-0.047,23.039-3.414,31.148c-3.141,7.562-10.805,15.18-18.922,23.242 c-12.391,12.305-26.43,26.25-26.43,44.125c0,17.883,14.039,31.828,26.43,44.133c8.117,8.062,15.789,15.672,18.922,23.234 c3.367,8.109,3.391,19.82,3.414,31.148c0.047,17.945,0.086,36.492,12.156,48.562c12.07,12.078,30.625,12.117,48.57,12.156 c11.328,0.031,23.031,0.055,31.141,3.414c7.562,3.141,15.18,10.805,23.242,18.922c12.305,12.391,26.25,26.43,44.125,26.43 s31.82-14.039,44.125-26.43c8.062-8.117,15.68-15.781,23.242-18.922c8.102-3.359,19.812-3.383,31.133-3.414 c17.945-0.039,36.5-0.078,48.578-12.156c12.07-12.07,12.109-30.617,12.156-48.562c0.023-11.328,0.047-23.039,3.414-31.148 c3.133-7.562,10.805-15.172,18.922-23.234c12.391-12.305,26.43-26.25,26.43-44.133 C463.676,190.125,449.629,176.18,437.238,163.875z"></path> </g> <g> <path fill="#FF9600" d="M93.027,140.633c-3.141,7.562-10.805,15.18-18.922,23.242c-12.391,12.305-26.43,26.25-26.43,44.125 c0,17.883,14.039,31.828,26.43,44.133c8.117,8.062,15.789,15.672,18.922,23.234c3.367,8.109,3.391,19.82,3.414,31.148 c0.047,17.945,0.086,36.492,12.156,48.562c12.07,12.078,30.625,12.117,48.57,12.156c11.328,0.031,23.031,0.055,31.141,3.414 c7.562,3.141,15.18,10.805,23.242,18.922c12.305,12.391,26.25,26.43,44.125,26.43s31.82-14.039,44.125-26.43 c8.062-8.117,15.68-15.781,23.242-18.922c8.102-3.359,19.812-3.383,31.133-3.414c17.945-0.039,36.5-0.078,48.578-12.156 L108.598,60.922C96.527,73,96.488,91.547,96.441,109.484C96.418,120.812,96.394,132.523,93.027,140.633z"></path> </g> <g> <circle fill="#FFFFFF" cx="255.676" cy="208.003" r="136.651"></circle> </g> <g> <path fill="#FF9600" d="M335.181,286.857l-158.36-158.36c-20.46,20.293-33.145,48.412-33.145,79.506 c0,61.856,50.144,112,112,112C286.769,320.003,314.888,307.317,335.181,286.857z"></path> </g> <g> <path fill="#FFD200" d="M159.39,111.065c-24.921,24.754-40.365,59.037-40.365,96.937 c0,75.47,61.181,136.651,136.651,136.651c37.901,0,72.183-15.445,96.937-40.366L159.39,111.065z"></path> </g> <g> <circle fill="#FFD200" cx="255.676" cy="208.003" r="112"></circle> </g> <g> <path fill="#FF9600" d="M176.821,128.497c-20.46,20.293-33.145,48.412-33.145,79.506c0,61.856,50.144,112,112,112 c31.094,0,59.212-12.686,79.506-33.146L176.821,128.497z"></path> </g> <g> <circle fill="#FFFFFF" cx="296.001" cy="167.677" r="32"></circle> </g> </g> </g></svg>';
                break;

            case 'trumphet':
                $icon = '<svg height="32px" width="32px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve" fill="#000000"><g stroke-width="0"></g><g stroke-linecap="round" stroke-linejoin="round"></g><g> <g> <g> <g> <g> <path fill="#FFC26D" d="M328.281,197.518l42.263,42.263c24.05,24.05,24.05,63.164,0,87.214L220.116,477.423 c-24.041,24.041-63.156,24.041-87.206-0.008l-42.263-42.263l23.302-23.302l42.263,42.263c11.194,11.194,29.407,11.185,40.592,0 l150.428-150.428c11.194-11.194,11.194-29.399,0-40.592l-42.263-42.263L328.281,197.518z"></path> </g> <rect x="96.305" y="419.158" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -273.8401 206.8599)" fill="#FF9A1B" width="32.955" height="29.653"></rect> <path fill="#FF9A1B" d="M328.281,197.518l31.297,31.297c-5.819,2.225-11.655,4.803-17.441,7.751 c-4.635,2.351-9.161,4.963-13.604,7.826l-23.563-23.563L328.281,197.518z"></path> <rect x="244.158" y="350.659" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -169.6652 324.6759)" fill="#FF9A1B" width="125.857" height="32.966"></rect> </g> <path fill="#FFDBAA" d="M258.805,224.848L29.706,453.947l30.287,30.287l229.099-229.099 c13.381-13.381,28.64-24.812,45.506-33.393c73.111-37.198,150.367-19.379,150.367-19.379L311.578,28.974 c0,0,17.818,77.256-19.379,150.367C283.617,196.208,272.187,211.466,258.805,224.848z"></path> <rect x="164.014" y="265.587" transform="matrix(0.7071 -0.7071 0.7071 0.7071 -136.4688 244.5326)" fill="#FFC26D" width="125.857" height="42.823"></rect> <path fill="#FFB54E" d="M506.957,214.21L506.957,214.21c-6.725,6.725-17.627,6.725-24.352,0L299.729,31.335 c-6.725-6.725-6.725-17.627,0-24.352l0,0c6.725-6.725,17.627-6.725,24.352,0l182.875,182.875 C513.681,196.583,513.681,207.486,506.957,214.21z"></path> <circle fill="#FFB54E" cx="37.922" cy="476.017" r="34.043"></circle> <path fill="#FF9A1B" d="M61.991,500.092c-8.823,8.823-21.296,11.788-32.573,8.884c5.705-1.452,11.093-4.417,15.561-8.884 c13.301-13.301,13.301-34.853,0-48.144c-4.468-4.468-9.856-7.433-15.561-8.895c11.277-2.904,23.75,0.061,32.573,8.895 C75.292,465.239,75.292,486.791,61.991,500.092z"></path> <path fill="#FF9A1B" d="M79.186,424.033c-1.962,0-3.925-0.748-5.422-2.246l-13.318-13.317 c-2.995-2.994-2.995-7.849,0-10.844c2.994-2.994,7.85-2.995,10.844,0l13.318,13.317c2.995,2.994,2.995,7.849,0,10.844 C83.11,423.284,81.148,424.033,79.186,424.033z"></path> <path fill="#FF9A1B" d="M103.603,399.615c-1.962,0-3.925-0.748-5.422-2.246l-13.318-13.317 c-2.995-2.994-2.995-7.849,0-10.844c2.994-2.994,7.85-2.995,10.844,0l13.318,13.317c2.995,2.994,2.995,7.849,0,10.844 C107.528,398.866,105.566,399.615,103.603,399.615z"></path> <path fill="#FF9A1B" d="M128.021,375.197c-1.962,0-3.925-0.749-5.422-2.246l-13.318-13.318 c-2.995-2.994-2.995-7.85,0-10.844c2.994-2.994,7.85-2.994,10.844,0l13.318,13.318c2.995,2.994,2.995,7.85,0,10.844 C131.946,374.448,129.983,375.197,128.021,375.197z"></path> <path fill="#F37D7E" d="M425.171,435.385l-41.437,8.399l-8.399,41.437c-1.129,5.569-8.003,7.641-12.022,3.623L173.6,299.13 c-4.638-4.638-4.638-12.157,0-16.794l48.686-48.686c4.638-4.638,12.157-4.638,16.794,0l189.713,189.713 C432.812,427.381,430.74,434.256,425.171,435.385z"></path> <path fill="#ED6264" d="M239.077,233.651l189.711,189.711c4.022,4.022,1.957,10.891-3.611,12.025l-14.368,2.914 L222.618,250.11c-4.635-4.635-12.159-4.635-16.794,0l16.459-16.459C226.926,229.007,234.441,229.016,239.077,233.651z"></path> <path fill="#FFDBAA" d="M29.126,483.661H7.668c-4.235,0-7.668-3.433-7.668-7.668s3.433-7.668,7.668-7.668h21.458 c4.235,0,7.668,3.433,7.668,7.668S33.36,483.661,29.126,483.661z"></path> </g> <g> <path fill="#FFDBAA" d="M461.729,58.941c-1.962,0-3.925-0.748-5.422-2.246c-2.995-2.995-2.995-7.85,0-10.844l14.405-14.405 c2.995-2.994,7.85-2.995,10.844,0c2.995,2.995,2.995,7.85,0,10.844l-14.405,14.405C465.654,58.192,463.691,58.941,461.729,58.941z "></path> <g> <path fill="#FFDBAA" d="M479.856,87.154c-3.567,0-6.761-2.502-7.504-6.132c-0.849-4.149,1.826-8.2,5.975-9.049 l19.958-4.083c4.153-0.852,8.2,1.826,9.049,5.975c0.849,4.149-1.826,8.2-5.975,9.049l-19.958,4.083 C480.882,87.103,480.365,87.154,479.856,87.154z"></path> <path fill="#FFDBAA" d="M433.525,40.807c-0.51,0-1.026-0.051-1.545-0.157c-4.149-0.849-6.824-4.9-5.975-9.049 l4.083-19.958c0.849-4.149,4.901-6.828,9.049-5.975c4.149,0.849,6.824,4.9,5.975,9.049l-4.083,19.958 C440.287,38.305,437.092,40.807,433.525,40.807z"></path> </g> </g> </g> </g></svg>';
                break;

            case 'internet':
                $icon = '<svg height="32px" width="32px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 509.287 509.287" xml:space="preserve" fill="#000000"><g> <path fill="#F1F3F7" d="M254.644,482.162c-125.457,0-227.518-102.061-227.518-227.518S129.187,27.126,254.644,27.126 s227.518,102.061,227.518,227.518S380.101,482.162,254.644,482.162z"></path> <path fill="#6EB1E1" d="M254.644,0C113.928,0,0,113.928,0,254.644s113.928,254.644,254.644,254.644 s254.644-113.928,254.644-254.644S395.359,0,254.644,0z M254.644,479.11c-26.448,0-54.93-35.264-72.901-93.584h145.801 C309.573,443.846,281.091,479.11,254.644,479.11z M174.623,358.4c-6.103-26.787-9.833-57.303-10.511-90.193h181.065 c-0.678,33.229-4.747,63.407-10.511,90.193H174.623z M27.465,268.207h109.521c0.678,32.212,4.408,62.728,10.172,90.193H52.556 C38.315,331.274,29.499,300.758,27.465,268.207z M254.644,30.177c26.448,0,54.93,35.264,72.901,93.584H181.743 C199.714,65.441,228.196,30.177,254.644,30.177z M334.665,150.887c6.103,26.787,9.833,57.303,10.511,90.193H164.111 c0.678-33.229,4.747-63.407,10.511-90.193H334.665z M136.985,241.081H27.465c2.034-32.551,10.511-63.068,24.752-90.193h94.601 C141.393,178.352,137.664,208.869,136.985,241.081z M372.302,268.207h109.521c-2.034,32.551-10.511,63.068-24.752,90.193h-94.601 C367.894,330.935,371.624,300.419,372.302,268.207z M372.302,241.081c-0.678-32.212-4.408-62.728-9.833-90.193h94.601 c14.241,27.465,22.718,57.981,24.752,90.193H372.302z M440.456,123.762h-84.768c-10.511-37.298-25.091-67.815-43.062-88.837 C365.181,48.487,409.939,80.699,440.456,123.762z M196.662,34.585c-17.632,21.023-32.551,51.878-43.062,88.837H68.832 C99.348,80.699,144.106,48.487,196.662,34.585z M68.832,385.526H153.6c10.511,37.298,25.091,67.815,43.062,88.837 C144.106,460.8,99.348,428.588,68.832,385.526z M312.625,474.702c17.632-21.022,32.551-51.878,43.062-88.837h84.768 C409.939,428.588,365.181,460.8,312.625,474.702z"></path> </g></svg>';
                break;

            case 'support':
                $icon = '<svg height="32px" width="32px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 456.183 456.183" xml:space="preserve" fill="#000000"><g> <g> <g> <path fill="none" d="M352.531,232.056V40.703H57.925v187.375c0,1.736-0.377,3.453-1.105,5.029l-17.672,38.291 l63.053-37.645c1.858-1.111,3.983-1.697,6.149-1.697H352.531z M96.689,84.738h220.847c6.628,0,12,5.373,12,12 c0,6.627-5.372,12-12,12H96.689c-6.627,0-12-5.373-12-12C84.689,90.111,90.062,84.738,96.689,84.738z M96.689,174.414 c-6.627,0-12-5.373-12-12c0-6.629,5.373-12,12-12h146.469c6.627,0,12,5.371,12,12c0,6.627-5.373,12-12,12H96.689z"></path> <path fill="#73D0F4" d="M399.109,355.824V173.457h-22.578v59.334c0,12.828-10.438,23.266-23.266,23.266H112.502v103.346 H350.25c2.166,0,4.291,0.588,6.15,1.697l60.635,36.199l-16.82-36.445C399.486,359.275,399.109,357.56,399.109,355.824z M293.506,312.871H147.037c-6.627,0-12-5.373-12-12c0-6.627,5.373-12,12-12h146.469c6.627,0,12,5.373,12,12 C305.506,307.498,300.133,312.871,293.506,312.871z"></path> <path fill="#3D6889" d="M455.078,422.451l-31.969-69.264V172.439c0-12.674-10.309-22.982-22.981-22.982h-23.597V39.968 c0-12.828-10.438-23.266-23.266-23.266H57.189c-12.828,0-23.265,10.438-23.265,23.266v185.475L1.105,296.552 c-2.205,4.777-1.041,10.434,2.87,13.951c2.261,2.033,5.134,3.078,8.028,3.078c2.114,0,4.241-0.559,6.148-1.697l70.35-42v90.537 c0,12.672,10.309,22.98,22.981,22.98h235.456l91.092,54.383c1.907,1.139,4.033,1.695,6.148,1.695c2.895,0,5.767-1.045,8.027-3.078 C456.119,432.884,457.282,427.228,455.078,422.451z M356.4,361.099c-1.859-1.109-3.984-1.697-6.15-1.697H112.502V256.056h240.764 c12.828,0,23.266-10.438,23.266-23.266v-59.334h22.578v182.367c0,1.736,0.377,3.451,1.105,5.029l16.82,36.445L356.4,361.099z M39.148,271.398l17.672-38.291c0.728-1.576,1.105-3.293,1.105-5.029V40.703h294.606v191.353H108.35 c-2.166,0-4.291,0.586-6.149,1.697L39.148,271.398z"></path> <path fill="#3D6889" d="M96.689,108.738h220.847c6.628,0,12-5.373,12-12c0-6.627-5.372-12-12-12H96.689 c-6.627,0-12,5.373-12,12C84.689,103.365,90.062,108.738,96.689,108.738z"></path> <path fill="#3D6889" d="M255.158,162.414c0-6.629-5.373-12-12-12H96.689c-6.627,0-12,5.371-12,12c0,6.627,5.373,12,12,12 h146.469C249.785,174.414,255.158,169.041,255.158,162.414z"></path> <path fill="#3D6889" d="M293.506,288.871H147.037c-6.627,0-12,5.373-12,12c0,6.627,5.373,12,12,12h146.469 c6.627,0,12-5.373,12-12C305.506,294.244,300.133,288.871,293.506,288.871z"></path> </g> </g> </g></svg>';
                break;

            case 'wizard':
                $icon = '<svg height="32px" width="32px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512.001 512.001" xml:space="preserve" fill="#000000"><g> <g style="opacity:0.6;"> <circle fill="#AEB2D3" cx="224.865" cy="287.134" r="224.714"></circle> <circle fill="#EFE388" cx="399.643" cy="112.357" r="112.357"></circle> </g> <path fill="#6F7475" d="M330.799,110.583L4.178,437.203c-9.75,9.75-1.846,33.464,17.655,52.965s43.215,27.406,52.965,17.655 l326.621-326.621L330.799,110.583z"></path> <path fill="#4E565A" d="M348.454,163.548L21.833,490.169c19.501,19.501,43.215,27.406,52.965,17.655l326.621-326.621 L348.454,163.548z"></path> <path fill="#5F6568" d="M330.799,110.583L4.178,437.203c-6.534,6.534-5.13,19.338,2.368,32.943l341.908-341.908 L330.799,110.583z"></path> <path fill="#E7E4CD" d="M374.937,66.444l-44.138,44.138c-9.75,9.75-1.846,33.464,17.655,52.965s43.215,27.406,52.965,17.655 l44.138-44.137L374.937,66.444z"></path> <path fill="#C1BDAB" d="M410.248,101.755l-61.793,61.793c19.501,19.501,43.215,27.406,52.965,17.655l44.138-44.137 L410.248,101.755z"></path> <ellipse transform="matrix(0.7071 -0.7071 0.7071 0.7071 48.2013 319.8911)" fill="#D5D2BD" cx="410.243" cy="101.761" rx="24.968" ry="49.936"></ellipse> </g></svg>';
                break;

            case 'fireworks':
                $icon = '<svg height="32px" width="32px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 466.078 466.078" xml:space="preserve" fill="#000000"> <g> <path fill="#FFEBAF" d="M253.038,466.071c0-0.02,0-0.041,0-0.061c-0.045-3.903-2.553-194.286-61.342-298.615l-38.571-20.277 l-13.796,7.252c20.998,28.903,88.661,132.3,111.184,291.94c2.159,12.192,2.518,19.631,2.524,19.756L253.038,466.071z"></path> <polygon fill="#FFEBAF" points="253.039,466.078 253.039,466.068 253.039,466.074 "></polygon> <path fill="#FFEBAF" d="M348.877,251.534l-11.924-6.268l-41.929,22.043c-22.932,58.088-33.483,118.543-38.238,157.302 c-2.438,24.802-3.675,40.526-3.745,41.421c-0.001,0.017-0.002,0.047-0.002,0.047C265.244,347.032,338.056,263.379,348.877,251.534z "></path> <path fill="#FFE696" d="M250.514,446.31c-6.758-38.154-31.209-122.855-117.977-175.805l-5.371,5.235l2.322,13.538 c39.679,24.478,108.482,79.968,123.55,176.801l-0.001-0.012C253.032,465.94,252.673,458.502,250.514,446.31z"></path> <path fill="#FFE696" d="M321.448,88.994l-8.325-4.377l-20.167,10.602c-7.096,25.942-13.113,56.945-18.154,90.081 l17.522-2.548C300.655,145.148,310.351,111.785,321.448,88.994z"></path> <path fill="#FFE696" d="M287.511,205.668l-13.749-13.403c-14.733,100.384-20.719,218.137-20.723,273.745 c0,0.02,0,0.041,0,0.061v0.007l0-0.004l0-0.005c0-0.004,0.001-0.016,0.003-0.037c0.07-0.895,1.307-16.619,3.745-41.421 C261.816,373.438,271.957,283.629,287.511,205.668z"></path> <path fill="#FFE178" d="M191.696,167.395l19.074,10.027l-11.008-64.188l46.637-45.461l-64.449-9.367L153.125,0 l-28.824,58.406l-64.453,9.367l46.637,45.461l-11.008,64.188l43.853-23.053l13.796-7.252L191.696,167.395z M94.23,78.945 l40.695-5.914l18.199-36.875l18.199,36.875l40.691,5.914l-29.449,28.695l6.953,40.531l-36.395-19.133l-36.398,19.133l6.953-40.531 L94.23,78.945z"></path> <path fill="#FFE178" d="M302.316,220.102l-8.176,47.672l0.884-0.465l41.929-22.043l11.924,6.268l30.892,16.24l-8.176-47.672 l34.637-33.766l-47.867-6.961L336.953,136l-21.406,43.375l-23.223,3.377l-17.522,2.548l-7.123,1.036l6.082,5.929l13.749,13.403 L302.316,220.102z M326.172,194l10.781-21.844L347.738,194l24.109,3.508l-17.449,17l4.121,24.016l-21.566-11.336l-21.563,11.336 l4.121-24.016l-17.449-17L326.172,194z"></path> <polygon fill="#FFD237" points="132.537,270.504 149.208,254.254 118.746,249.827 105.124,222.224 91.501,249.827 61.039,254.254 83.081,275.74 77.878,306.078 105.124,291.754 132.369,306.078 129.488,289.277 127.166,275.74 "></polygon> <polygon fill="#FFD237" points="321.448,88.994 345.314,101.54 339.166,65.696 365.208,40.311 329.219,35.082 313.124,2.47 297.029,35.082 261.039,40.311 287.081,65.696 280.934,101.54 292.957,95.219 313.124,84.617 "></polygon> <polygon fill="#FFD237" points="251.488,128.593 244.3,114.029 237.112,128.593 221.039,130.929 232.67,142.266 229.924,158.274 244.3,150.716 258.676,158.274 255.931,142.266 267.561,130.929 "></polygon> <polygon fill="#FFD237" points="366.157,322.319 358.969,307.755 351.781,322.319 335.708,324.655 347.339,335.992 344.593,352 358.969,344.442 373.346,352 370.6,335.992 382.23,324.655 "></polygon> </g> </svg>';
                break;

            case 'download':
                $icon = '<svg height="32px" width="32px" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" viewBox="0 0 512 512" xml:space="preserve" fill="#000000"> <polygon points="319.666,253.182 319.666,95.093 192.334,95.093 192.334,253.182 131.742,253.182 256,416.907 380.258,253.182" fill="#CEE8FA"></polygon> <g> <path d="M256,431.967c-4.709,0-9.148-2.203-11.996-5.954L119.748,262.287 c-3.458-4.555-4.036-10.678-1.492-15.8c2.543-5.123,7.769-8.364,13.488-8.364h45.533V95.092c0-8.315,6.742-15.059,15.059-15.059 h127.331c8.317,0,15.059,6.743,15.059,15.059v143.03h45.533c5.719,0,10.945,3.239,13.488,8.364 c2.543,5.122,1.965,11.244-1.492,15.8L267.997,426.011C265.148,429.764,260.709,431.967,256,431.967z M162.075,268.241L256,391.999 l93.925-123.758h-30.259c-8.317,0-15.059-6.743-15.059-15.059V110.151h-97.214v143.03c0,8.315-6.742,15.059-15.059,15.059h-30.259 V268.241z" fill="#2D527C"></path> <path d="M256,512C114.842,512,0,397.158,0,256S114.842,0,256,0c8.317,0,15.059,6.743,15.059,15.059 S264.317,30.118,256,30.118C131.448,30.118,30.118,131.448,30.118,256S131.448,481.882,256,481.882S481.882,380.552,481.882,256 c0-68.911-30.874-133.183-84.706-176.34c-6.489-5.203-7.532-14.681-2.33-21.17c5.203-6.49,14.679-7.529,21.168-2.331 C477.015,105.064,512,177.903,512,256C512,397.158,397.158,512,256,512z" fill="#2D527C"></path> </g> </svg>';
                break;

            case 'alert':
                $icon = '';
                break;
        }

        return $icon;
    }
    public static function render_tabs( $tabs )
    {
        if ( empty( $tabs ) )
        {
            return;
        }
        ?>
        <style>
            .molongui-ui-tabs {
                position: relative;
            }

            .molongui-ui-tab-radio {
                display: none;
            }

            .molongui-ui-tabs-navigation {
                display: flex;
                margin-bottom: 1em;
            }

            .molongui-ui-tab-label {
                cursor: pointer;
                padding: 0.5em 1em;
                background: #f1f1f1;
                border: 1px solid #ddd;
                margin-right: 0.5em;
                transition: background 0.3s ease;
            }

            .molongui-ui-tab-label:hover {
                background: #e1e1e1;
            }

            .molongui-ui-tab-radio:checked + .molongui-ui-tabs-navigation .molongui-ui-tab-label {
                background: #ffffff;
                border-bottom: none;
                font-weight: bold;
            }

            .molongui-ui-tabs-content {
                border: 1px solid #ddd;
                padding: 1em;
                background: #ffffff;
            }

            .molongui-ui-tab-content {
                display: none;
            }

            .molongui-ui-tab-radio:checked ~ .molongui-ui-tabs-content #content-tab-0,
            .molongui-ui-tab-radio:checked ~ .molongui-ui-tabs-content #content-tab-1,
            .molongui-ui-tab-radio:checked ~ .molongui-ui-tabs-content #content-tab-2 {
                display: block;
            }
        </style>
        <div class="molongui-ui-tabs">
            <input type="radio" name="molongui-ui-tabs" id="tab-0" checked class="molongui-ui-tab-radio">
            <?php foreach ( $tabs as $index => $tab ) : ?>
                <input type="radio" name="molongui-ui-tabs" id="tab-<?php echo esc_attr( $index ); ?>" class="molongui-ui-tab-radio">
            <?php endforeach; ?>

            <div class="molongui-ui-tabs-navigation">
                <?php foreach ( $tabs as $index => $tab ) : ?>
                    <label for="tab-<?php echo esc_attr( $index ); ?>" class="molongui-ui-tab-label">
                        <?php echo esc_html( $tab['title'] ); ?>
                    </label>
                <?php endforeach; ?>
            </div>

            <div class="molongui-ui-tabs-content">
                <?php foreach ( $tabs as $index => $tab ) : ?>
                    <div class="molongui-ui-tab-content" id="content-tab-<?php echo esc_attr( $index ); ?>">
                        <?php //echo wp_kses_post( $tab['content'] ); ?>
<?php echo wp_kses( $tab['content'] ); ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <?php
    }
    public static function heading( $args )
    {
        ob_start(); ?>

        <div class="molongui-ui-heading <?php echo !empty( $args['class'] ) ? esc_attr( $args['class'] ) : ''; ?>">
            <div class="molongui-ui-heading__title">
                <?php echo wp_kses_post( $args['title'] ); ?>
            </div>
            <?php if ( !empty( $args['subtitle'] ) ) : ?>
                <p class="molongui-ui-heading__subtitle">
                    <?php echo wp_kses_post( $args['subtitle'] ); ?>
                </p>
            <?php endif; ?>
        </div>

        <?php

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo ob_get_clean();
        }
        else
        {
            return ob_get_clean();
        }
    }
    public static function card( $args )
    {
        ob_start();
        ?>
        <div class="molongui-ui-card <?php echo !empty( $args['disabled'] ) ? 'molongui-ui-card--disabled' : ''; ?> <?php echo !empty( $args['class'] ) ? esc_attr( $args['class'] ) : ''; ?>">
            <?php if ( !empty( $args['image'] ) ) : ?>
                <img class="molongui-ui-card__image" src="<?php echo esc_attr( $args['image'] ); ?>" alt="" />
            <?php endif; ?>
            <div class="molongui-ui-card__title">
                <?php echo wp_kses_post( $args['title'] ); ?>
            </div>
            <?php if ( !empty( $args['description'] ) ) : ?>
                <div class="molongui-ui-card__description">
                    <?php echo wp_kses_post( $args['description'] ); ?>
                </div>
            <?php endif; ?>
            <?php if ( !empty( $args['disabled'] ) ) : ?>
                <div style="display:flex; flex-direction:row; align-items:center; margin-top:auto">
                    <?php if ( 'premium' === $args['disabled'] ) : ?>
                        <div class="molongui-ui-card__premium">
                            <a href="<?php echo esc_url( MOLONGUI_AUTHORSHIP_WEB ); ?>" target="_blank">
                                <?php _e( "Pro Only", 'molongui-authorship' ); ?>
                            </a>
                        </div>
                    <?php endif; ?>
                    <div class="molongui-ui-card__button">
                        <?php echo esc_html( $args['button']['label'] ); ?>
                    </div>
                </div>
            <?php elseif ( !empty( $args['button']['accept'] ) ) : ?>
                <input class="molongui-ui-card__input" type="file" id="<?php echo esc_attr( !empty( $args['button']['id'] ) ? $args['button']['id'] : '' ); ?>" accept="<?php echo esc_attr( $args['button']['accept'] ); ?>" data-multiple-caption="{count} files selected" <?php echo ( !empty( $args['button']['multi'] ) ? 'multiple' : '' ); ?> />
                <label class="molongui-ui-card__button" for="<?php echo esc_attr( !empty( $args['button']['id'] ) ? $args['button']['id'] : '' ); ?>"><?php echo esc_html( $args['button']['label'] ); ?></label>
            <?php elseif ( !empty( $args['button']['link'] ) ) : ?>
                <a class="molongui-ui-card__button" id="<?php echo esc_attr( !empty( $args['button']['id'] ) ? $args['button']['id'] : '' ); ?>" href="<?php echo esc_attr( $args['button']['link'] ); ?>" target="<?php echo esc_attr( !empty( $args['button']['target'] ) ? $args['button']['target'] : '_self' ); ?>">
                    <?php echo esc_html( $args['button']['label'] ); ?>
                </a>
            <?php else: ?>
                <div class="molongui-ui-card__button" id="<?php echo esc_attr( !empty( $args['button']['id'] ) ? $args['button']['id'] : '' ); ?>">
                    <?php echo esc_html( $args['button']['label'] ); ?>
                </div>
            <?php endif; ?>
            <?php if ( !empty( $args['button']['nonce'] ) and empty( $args['disabled'] ) ) : ?>
                <?php wp_nonce_field( $args['button']['nonce'], $args['button']['nonce'].'_nonce' ); ?>
            <?php endif; ?>
        </div>
        <?php

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo ob_get_clean();
        }
        else
        {
            return ob_get_clean();
        }
    }
    public static function input_text( $args )
    {
        ob_start(); ?>
        <div class="molongui-ui-control molongui-ui-control__input">
            <div class="molongui-ui-input molongui-ui-input--text <?php echo !empty( $args['class'] ) ? esc_attr( $args['class'] ) : ''; ?>">
                <?php if ( !empty( $args['label'] ) ) : ?>
                    <label class="molongui-ui-input__label" for="<?php echo esc_attr( $args['id'] ); ?>">
                        <?php echo wp_kses_post( $args['label'] ); ?>
                    </label>
                <?php endif; ?>
                <?php if ( !empty( $args['disabled'] ) ) : ?>
                    <input class="molongui-ui-input__input" type="text" disabled="disabled" value="<?php echo esc_attr( $args['value'] ); ?>" />
                    <?php if ( !empty( $args['tooltip'] ) ) : ?>
                        <div class="molongui-ui-tooltip">
                            <?php echo wp_kses_post( $args['tooltip'] ); ?>
                        </div>
                    <?php endif; ?>
                <?php else : ?>
                    <input class="molongui-ui-input__input" type="text" id="<?php echo esc_attr( $args['id'] ); ?>" name="<?php echo esc_attr( $args['id'] ); ?>" value="<?php echo esc_attr( $args['value'] ); ?>" />
                <?php endif; ?>
            </div>
            <?php if ( !empty( $args['description'] ) ) : ?>
                <div class="molongui-ui-input__description">
                    <?php echo wp_kses( $args['description'], self::allowed_html() ); ?>
                </div>
            <?php endif; ?>
        </div>
        <?php

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo ob_get_clean();
        }
        else
        {
            return ob_get_clean();
        }
    }
    public static function input_number( $args )
    {
        ob_start(); ?>
        <div class="molongui-ui-control molongui-ui-control__input">
            <div class="molongui-ui-input molongui-ui-input--number <?php echo !empty( $args['class'] ) ? esc_attr( $args['class'] ) : ''; ?>">
                <?php if ( !empty( $args['label'] ) ) : ?>
                    <label class="molongui-ui-input__label" for="<?php echo esc_attr( $args['id'] ); ?>">
                        <?php echo wp_kses_post( $args['label'] ); ?>
                    </label>
                <?php endif; ?>
                <?php if ( !empty( $args['disabled'] ) ) : ?>
                    <input class="molongui-ui-input__input" type="number" disabled="disabled" value="<?php echo esc_attr( $args['value'] ); ?>" />
                    <?php if ( !empty( $args['tooltip'] ) ) : ?>
                        <div class="molongui-ui-tooltip">
                            <?php echo wp_kses_post( $args['tooltip'] ); ?>
                        </div>
                    <?php endif; ?>
                <?php else : ?>
                    <input class="molongui-ui-input__input" type="number" id="<?php echo esc_attr( $args['id'] ); ?>" name="<?php echo esc_attr( $args['id'] ); ?>" value="<?php echo esc_attr( $args['value'] ); ?>" min="<?php echo !empty( $args['min'] ) ? esc_attr( $args['min'] ) : ''; ?>" max="<?php echo !empty( $args['max'] ) ? esc_attr( $args['max'] ) : ''; ?>" />
                <?php endif; ?>
            </div>
            <?php if ( !empty( $args['description'] ) ) : ?>
                <div class="molongui-ui-input__description">
                    <?php echo wp_kses( $args['description'], self::allowed_html() ); ?>
                </div>
            <?php endif; ?>
        </div>
        <?php

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo ob_get_clean();
        }
        else
        {
            return ob_get_clean();
        }
    }
    public static function textarea( $args )
    {
        ob_start(); ?>
        <div class="molongui-ui-control molongui-ui-control__textarea">
            <div class="molongui-ui-textarea <?php echo !empty( $args['class'] ) ? esc_attr( $args['class'] ) : ''; ?>">
                <?php if ( !empty( $args['description'] ) ) : ?>
                    <div class="molongui-ui-textarea__description">
                        <?php echo wp_kses( $args['description'], self::allowed_html() ); ?>
                    </div>
                <?php endif; ?>
                <?php if ( !empty( $args['label'] ) ) : ?>
                    <label class="molongui-ui-textarea__label" for="<?php echo esc_attr( $args['id'] ); ?>">
                        <?php echo wp_kses_post( $args['label'] ); ?>
                    </label>
                <?php endif; ?>
                <?php if ( !empty( $args['disabled'] ) ) : ?>
                    <textarea class="molongui-ui-textarea__input" disabled="disabled" rows="<?php echo !empty( $args['rows'] ) ? esc_attr( $args['rows'] ) : ''; ?>" placeholder="<?php echo !empty( $args['placeholder'] ) ? esc_attr( $args['placeholder'] ) : ''; ?>"><?php echo wp_kses( $args['value'], self::allowed_html() ); ?></textarea>
                    <?php if ( !empty( $args['tooltip'] ) ) : ?>
                        <div class="molongui-ui-tooltip">
                            <?php echo wp_kses_post( $args['tooltip'] ); ?>
                        </div>
                    <?php endif; ?>
                <?php else : ?>
                    <textarea class="molongui-ui-textarea__input" id="<?php echo esc_attr( $args['id'] ); ?>" name="<?php echo esc_attr( $args['id'] ); ?>" rows="<?php echo !empty( $args['rows'] ) ? esc_attr( $args['rows'] ) : ''; ?>" placeholder="<?php echo !empty( $args['placeholder'] ) ? esc_attr( $args['placeholder'] ) : ''; ?>"><?php echo wp_kses( $args['value'], self::allowed_html() ); ?></textarea>
                <?php endif; ?>
            </div>
        </div>
        <?php

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo ob_get_clean();
        }
        else
        {
            return ob_get_clean();
        }
    }
    public static function radio( $args )
    {
        ob_start(); ?>
        <div class="molongui-ui-control molongui-ui-control__radio">

            <?php if ( !empty( $args['title'] ) ) : ?>
                <div class="molongui-ui-radio__title">
                    <?php echo wp_kses( $args['title'], self::allowed_html() ); ?>
                </div>
            <?php endif; ?>

            <?php foreach ( $args['options'] as $option ) : ?>
                <div class="molongui-ui-radio">
                    <?php if ( !empty( $option['disabled'] ) ) : ?>
                        <input class="molongui-ui-radio__input" type="radio" disabled="disabled" />
                        <?php if ( !empty( $option['tooltip'] ) or !empty( $args['tooltip'] ) ) : ?>
                            <div class="molongui-ui-tooltip">
                                <?php echo wp_kses_post( !empty( $option['tooltip'] ) ? $option['tooltip'] : $args['tooltip'] ); ?>
                            </div>
                        <?php endif; ?>
                    <?php else : ?>
                        <input class="molongui-ui-radio__input" type="radio" id="<?php echo esc_attr( $args['id'] . '_' . $option['value'] ); ?>" name="<?php echo esc_attr( $args['id'] ); ?>" value="<?php echo esc_attr( $option['value'] ); ?>" <?php checked( $args['selected'], $option['value'] ); ?> />
                    <?php endif; ?>
                    <label class="molongui-ui-radio__label" for="<?php echo esc_attr( $args['id'] . '_' . $option['value'] ); ?>">
                        <?php echo wp_kses_post( $option['label'] ); ?>
                    </label>
                    <?php if ( !empty( $option['description'] ) ) : ?>
                        <div class="molongui-ui-radio__description">
                            <?php echo wp_kses( $option['description'], self::allowed_html() ); ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endforeach; ?>

        </div>
        <?php

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo ob_get_clean();
        }
        else
        {
            return ob_get_clean();
        }
    }
    public static function checkbox( $args )
    {
        ob_start(); ?>
        <div class="molongui-ui-control molongui-ui-control__checkbox">

            <div class="molongui-ui-checkbox <?php echo !empty( $args['class'] ) ? esc_attr( $args['class'] ) : ''; ?>">
                <?php if ( !empty( $args['disabled'] ) ) : ?>
                    <input class="molongui-ui-checkbox__input" type="checkbox" disabled="disabled" <?php echo checked( $args['value'], true, false ); ?> />
                <?php else : ?>
                    <input class="molongui-ui-checkbox__input" type="checkbox" id="<?php echo esc_attr( $args['id'] ); ?>" name="<?php echo esc_attr( $args['id'] ); ?>" <?php echo checked( $args['value'], true, false ); ?> />
                <?php endif; ?>
                <label class="molongui-ui-checkbox__label" for="<?php echo esc_attr( $args['id'] ); ?>">
                    <?php echo wp_kses_post( $args['label'] ); ?>
                </label>
                <?php if ( !empty( $args['help'] ) ) : ?>
                    <?php self::help_markup( $args['help'] ); ?>
                <?php endif; ?>
                <?php if ( !empty( $args['tooltip'] ) ) : ?>
                    <div class="molongui-ui-tooltip">
                        <?php echo wp_kses_post( $args['tooltip'] ); ?>
                    </div>
                <?php endif; ?>
            </div>

            <?php if ( !empty( $args['description'] ) ) : ?>
                <div class="molongui-ui-checkbox__description">
                    <?php echo wp_kses( $args['description'], self::allowed_html() ); ?>
                </div>
            <?php endif; ?>

            <?php if ( !empty( $args['content'] ) ) : ?>
                <div class="molongui-ui-control__content">
                    <?php if ( !empty( $args['content']['off'] ) ) : ?>
                        <div class="molongui-ui-control__content--off">
                            <?php echo wp_kses( $args['content']['off'], self::allowed_html() ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ( !empty( $args['content']['on'] ) ) : ?>
                        <div class="molongui-ui-control__content--on">
                            <?php echo wp_kses( $args['content']['on'], self::allowed_html() ); ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

        </div>
        <?php

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo ob_get_clean();
        }
        else
        {
            return ob_get_clean();
        }
    }
    public static function checkbox_group( $args )
    {
        if ( empty( $args['options'] ) or !is_array( $args['options'] ) )
        {
            return;
        }
        if ( empty( $args['layout'] ) or !in_array( $args['layout'], array( 'block', 'inline' ) ) )
        {
            $args['layout'] = 'block';
        }
        $selected_values = explode( ',', $args['selected'] );

        ob_start(); ?>
        <div class="molongui-ui-control molongui-ui-control__checkbox-group">
            <div class="molongui-ui-checkbox-group <?php echo ( 'inline' === $args['layout'] ) ? 'molongui-ui-checkbox-group--inline' : ''; ?> <?php echo !empty( $args['class'] ) ? esc_attr( $args['class'] ) : ''; ?>">

                <?php if ( 'inline' === $args['layout'] ) : ?>
                    <?php if ( !empty( $args['title'] ) ) : ?>
                        <label class="molongui-ui-checkbox-group__label">
                            <?php echo wp_kses_post( $args['title'] ); ?>
                        </label>
                    <?php endif; ?>
                <?php else: ?>
                    <?php if ( !empty( $args['title'] ) ) : ?>
                        <div class="molongui-ui-checkbox-group__title">
                            <?php echo esc_html( $args['title'] ); ?>
                            <?php if ( !empty( $args['help'] ) ) : ?>
                                <?php self::help_markup( $args['help'] ); ?>
                            <?php endif; ?>
                        </div>
                    <?php endif; ?>
                    <?php if ( !empty( $args['description'] ) ) : ?>
                        <div class="molongui-ui-checkbox-group__description">
                            <?php echo wp_kses( $args['description'], self::allowed_html() ); ?>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>

                <div class="molongui-ui-checkbox-group__items">
                    <?php foreach ( $args['options'] as $option ) : ?>
                        <div class="molongui-ui-checkbox-group__item" title="<?php echo esc_attr( $option['label'] ); ?>">
                            <?php if ( !empty( $args['disabled'] ) or !empty( $option['disabled'] ) ) : ?>
                                <input type="checkbox" class="molongui-ui-checkbox-group__input" disabled="disabled" <?php echo !empty( $option['premium'] ) ? 'data-premium="1"' : ''; ?> <?php echo in_array( $option['value'], $selected_values, true ) ? 'checked' : ''; ?> />
                                <label class="molongui-ui-checkbox-group__input-label">
                                    <?php echo wp_kses_post( $option['label'] ); ?>
                                </label>
                                <?php if ( !empty( $option['tooltip'] ) or !empty( $args['tooltip'] ) ) : ?>
                                    <div class="molongui-ui-tooltip">
                                        <?php echo wp_kses_post( !empty( $option['tooltip'] ) ? $option['tooltip'] : $args['tooltip'] ); ?>
                                    </div>
                                <?php endif; ?>
                            <?php else : ?>
                                <input type="checkbox" class="molongui-ui-checkbox-group__input" id="<?php echo esc_attr( $args['id'] . '_' . $option['value'] ); ?>" name="<?php echo esc_attr( $args['id'] ); ?>[]" value="<?php echo esc_attr( $option['value'] ); ?>" <?php echo in_array( $option['value'], $selected_values, true ) ? 'checked' : ''; ?> />
                                <label for="<?php echo esc_attr( $args['id'] . '_' . $option['value'] ); ?>" class="molongui-ui-checkbox-group__input-label">
                                    <?php echo wp_kses_post( $option['label'] ); ?>
                                </label>
                            <?php endif; ?>
                        </div>
                    <?php endforeach; ?>
                </div>

            </div>
        </div>
        <?php

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo ob_get_clean();
        }
        else
        {
            return ob_get_clean();
        }
    }
    public static function toggle( $args )
    {
        ob_start(); ?>
        <div class="molongui-ui-control molongui-ui-control__toggle">

            <div class="molongui-ui-toggle <?php echo !empty( $args['class'] ) ? esc_attr( $args['class'] ) : ''; ?>">
                <input type="checkbox" role="switch" class="molongui-ui-toggle__input" <?php echo !empty( $args['id'] ) ? 'id="'.esc_attr( $args['id'] ).'" name="'.esc_attr( $args['id'] ).'"' : ''; ?> <?php echo checked( $args['value'], true, false ); ?> <?php echo disabled( $args['disabled'], true, false ); ?> />
                <div class="molongui-ui-toggle__text">
                    <label for="<?php echo esc_attr( $args['id'] ); ?>" class="molongui-ui-toggle__label">
                        <?php echo wp_kses_post( $args['label'] ); ?>
                    </label>
                    <div class="molongui-ui-toggle__description">
                        <?php echo wp_kses( $args['description'], self::allowed_html() ); ?>
                    </div>
                </div>
            </div>

            <?php if ( !empty( $args['content'] ) ) : ?>
                <div class="molongui-ui-control__content">
                    <?php if ( !empty( $args['content']['off'] ) ) : ?>
                        <div class="molongui-ui-control__content--off">
                            <?php echo wp_kses( $args['content']['off'], self::allowed_html() ); ?>
                        </div>
                    <?php endif; ?>
                    <?php if ( !empty( $args['content']['on'] ) ) : ?>
                        <div class="molongui-ui-control__content--on">
                            <?php echo wp_kses( $args['content']['on'], self::allowed_html() ); ?>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>

        </div>
        <?php

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo ob_get_clean();
        }
        else
        {
            return ob_get_clean();
        }
    }
    public static function select( $args )
    {
        ob_start(); ?>
        <div class="molongui-ui-control molongui-ui-control__select">
            <div class="molongui-ui-select  <?php echo !empty( $args['class'] ) ? esc_attr( $args['class'] ) : ''; ?>">
                <?php if ( !empty( $args['label'] ) ) : ?>
                    <label class="molongui-ui-select__label" for="<?php echo esc_attr( $args['id'] ); ?>">
                        <?php echo wp_kses( $args['label'], self::allowed_html() ); ?>
                    </label>
                <?php endif; ?>
                <?php if ( !empty( $args['disabled'] ) ) : ?>
                    <select class="molongui-ui-select__input" disabled="disabled">
                        <?php foreach ( $args['options'] as $option ) : ?>
                            <option value="<?php echo esc_attr( $option['value'] ); ?>" <?php selected( $args['selected'], $option['value'] ); ?> <?php disabled( ( isset( $option['disabled'] ) ? $option['disabled'] : false ), true, true ); ?>>
                                <?php echo esc_html( $option['label'] ); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                    <?php if ( !empty( $args['tooltip'] ) ) : ?>
                        <div class="molongui-ui-tooltip">
                            <?php echo wp_kses_post( $args['tooltip'] ); ?>
                        </div>
                    <?php endif; ?>
                <?php else : ?>
                    <select id="<?php echo esc_attr( $args['id'] ); ?>" name="<?php echo esc_attr( $args['id'] ); ?>" class="molongui-ui-select__input" <?php disabled( isset( $args['disabled'] ) ? $args['disabled'] : false, true, true ); ?> >
                        <?php foreach ( $args['options'] as $option ) : ?>
                            <option value="<?php echo esc_attr( $option['value'] ); ?>" <?php selected( $args['selected'], $option['value'] ); ?> <?php disabled( ( isset( $option['disabled'] ) ? $option['disabled'] : false ), true, true ); ?>>
                                <?php echo esc_html( $option['label'] ); ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                <?php endif; ?>
                <?php if ( !empty( $args['help'] ) ) : ?>
                    <?php self::help_markup( $args['help'] ); ?>
                <?php endif; ?>
            </div>
            <?php if ( !empty( $args['description'] ) ) : ?>
                <div class="molongui-ui-select__description">
                    <?php echo wp_kses( $args['description'], self::allowed_html() ); ?>
                </div>
            <?php endif; ?>
        </div>
        <?php

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo ob_get_clean();
        }
        else
        {
            return ob_get_clean();
        }
    }
    public static function notice( $args )
    {
        if ( apply_filters( 'authorship/show_settings_notice', true ) )
        {
            if ( !empty( $args['icon'] ) )
            {
                $icon = self::get_icon( $args['icon'] );
            }

            $style = '';
            if ( !empty( $args['margin'] ) )
            {
                $style = ( is_rtl() ? 'margin-right' : 'margin-left' ) . ':'.$args['margin'].'px;';
            }

            ob_start(); ?>
            <div class="molongui-ui-notice" style="<?php esc_attr_e( $style ); ?>">
                <?php if ( isset( $icon ) ) : ?>
                    <div class="molongui-ui-notice__icon">
                        <?php echo wp_kses( $icon, self::allowed_html() ); ?>
                    </div>
                <?php endif; ?>
                <div class="molongui-ui-notice__text">
                    <?php echo wp_kses( $args['text'], self::allowed_html() ); ?>
                </div>
                <a class="molongui-ui-notice__button" href="<?php echo esc_url( $args['link'] ); ?>" target="<?php echo esc_attr( !empty( $args['target'] ) ? $args['target'] : '_blank' ); ?>">
                    <?php echo esc_html( $args['button'] ); ?>
                </a>
            </div>
            <?php

            $notice = ob_get_clean();

            if ( !isset( $args['echo'] ) or $args['echo'] )
            {
                echo $notice;
            }
            else
            {
                return $notice;
            }
        }
    }
    public static function banner( $args )
    {
        if ( !empty( $args['premium'] ) )
        {
            if ( !apply_filters( 'authorship/show_upgrade_notice', true ) )
            {
                return;
            }
        }

        if ( apply_filters( 'authorship/show_settings_banner', true ) )
        {
            if ( !empty( $args['icon'] ) )
            {
                $icon = self::get_icon( $args['icon'] );
            }

            $style = '';
            if ( !empty( $args['margin'] ) )
            {
                $style = ( is_rtl() ? 'margin-right' : 'margin-left' ) . ':'.$args['margin'].'px;';
            }

            ob_start(); ?>
            <div class="molongui-ui-banner" style="<?php esc_attr_e( $style ); ?>">
                <a class="molongui-ui-banner__link" href="<?php echo esc_url( $args['link'] ); ?>" target="<?php echo esc_attr( !empty( $args['target'] ) ? $args['target'] : '_blank' ); ?>">
                    <?php if ( isset( $icon ) ) : ?>
                        <div class="molongui-ui-banner__icon">
                            <?php echo wp_kses( $icon, self::allowed_html() ); ?>
                        </div>
                    <?php endif; ?>
                    <div class="molongui-ui-banner__text">
                        <?php echo wp_kses( $args['text'], self::allowed_html() ); ?>
                    </div>
                    <?php if ( !empty( $args['button'] ) ) : ?>
                    <div class="molongui-ui-banner__button">
                        <?php echo esc_html( $args['button'] ); ?>
                    </div>
                    <?php else : ?>
                    <div class="molongui-ui-banner__arrow">
                        <svg width="19" height="17" viewBox="0 0 19 17" xmlns="http://www.w3.org/2000/svg">
                            <path d="M10.6953 16.3906L18.4062 8.60938L10.6953 0.828125L8.63281 2.98438L12.8516 7.10938H0.699219V10.1094H12.8516L8.63281 14.2344L10.6953 16.3906Z"></path>
                        </svg>
                    </div>
                    <?php endif; ?>
                </a>
            </div>
            <?php

            $banner = ob_get_clean();

            if ( !isset( $args['echo'] ) or $args['echo'] )
            {
                echo $banner;
            }
            else
            {
                return $banner;
            }
        }
    }
    public static function upgrade( $args )
    {
        if ( apply_filters( 'authorship/show_upgrade_notice', true ) or !empty( $args['keep'] ) )
        {
            $icon = empty( $args['icon'] ) ? 'premium' : $args['icon'];

            ob_start(); ?>
            <div class="molongui-ui-upgrade">
                <a class="molongui-ui-upgrade__link" href="<?php echo esc_url( $args['link'] ); ?>" target="<?php echo esc_attr( !empty( $args['target'] ) ? $args['target'] : '_blank' ); ?>">
                    <div class="molongui-ui-upgrade__message">
                        <?php echo wp_kses( self::get_icon( $icon ), self::allowed_html() ); ?>
                        <div class="molongui-ui-upgrade__text">
                            <?php echo esc_html( $args['text'] ); ?>
                        </div>
                    </div>
                    <div class="molongui-ui-upgrade__button">
                        <?php echo esc_html( !empty( $args['button'] ) ? $args['button'] : __( "Upgrade Now", 'molongui-authorship' ) ); ?>
                    </div>
                </a>
            </div>
            <?php

            $upgrade = ob_get_clean();

            if ( !isset( $args['echo'] ) or $args['echo'] )
            {
                echo $upgrade;
            }
            else
            {
                return $upgrade;
            }
        }
    }
    public static function div_open( $args )
    {
        $id    = !empty( $args['id'] ) ? $args['id'] : '';
        $class = !empty( $args['class'] ) ? $args['class'] : '';

        if ( apply_filters( 'authorship/show_upgrade_notice', true ) )
        {
            if ( !empty( $args['premium'] ) )
            {
                if ( !empty( $class ) )
                {
                    $class .= ' ';
                }
                $class .= 'premium';
            }
        }

        ob_start(); ?>

        <div id="<?php echo esc_attr( $id ); ?>" class="<?php echo esc_attr( $class ); ?>">

        <?php
        $html = ob_get_clean();

        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo $html;
        }
        else
        {
            return $html;
        }
    }
    public static function div_close( $args )
    {
        if ( !isset( $args['echo'] ) or $args['echo'] )
        {
            echo '</div>';
        }
        else
        {
            return '</div>';
        }
    }
    public static function help_markup( $message )
    {
        if ( empty( $message ) )
        {
            return;
        }
        ?>

        <div class="molongui-ui-help">
            <svg width="18px" height="18px" viewBox="0 0 24.00 24.00" fill="none" xmlns="http://www.w3.org/2000/svg">
                <g>
                    <path d="M12 7.01001V7.00002M12 17L12 10M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="#3c434a" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"></path>
                </g>
            </svg>
            <div class="molongui-ui-tooltip">
                <?php echo wp_kses_post( $message ); ?>
            </div>
        </div>
        <?php
    }


} // class
