<?php
/**
 * Blocks Initializer
 *
 * Enqueue CSS/JS of all the blocks.
 *
 * @since   1.0.0
 * @package BodModal
 */

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

/**
 * Enqueue Gutenberg block assets for both frontend + backend.
 *
 * @uses {wp-editor} for WP editor styles.
 * @uses {wp-blocks} for block type registration & related functions.
 * @uses {wp-element} for WP Element abstraction — structure of blocks.
 * @uses {wp-i18n} to internationalize the block's text.
 * @since 1.0.0
 */
function bod_modal_block_assets() { // phpcs:ignore
	
	// Frontend Scripts.
	wp_register_script(
		'bod-modal-block-js', // Handle.
		plugins_url( '/dist/modal.js', dirname( __FILE__ ) ), // Block.build.js: We register the block here. Built with Webpack.
		array( 'jquery' ), // Dependencies, defined above.
		filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.build.js' ), // Version: File modification time.
		true // Enqueue the script in the footer.
	);

	// Backend Scripts.
	wp_register_script(
		'bod-modal-block-editor-js', // Handle.
		plugins_url( '/dist/blocks.build.js', dirname( __FILE__ ) ), // Block.build.js: We register the block here. Built with Webpack.
		array( 'wp-blocks', 'wp-i18n', 'wp-element', 'wp-editor' ), // Dependencies, defined above.
	    filemtime( plugin_dir_path( __DIR__ ) . 'dist/blocks.build.js' ), // Version: File modification time.
		true // Enqueue the script in the footer.
	);

	// Frontend / backend Styles.
	wp_register_style(
		'bod-modal-block-style-css', // Handle.
		plugins_url( 'dist/blocks.style.build.css', dirname( __FILE__ ) ), // Block style CSS.
		array(  ) // Dependency to include the CSS after it.
	);

	// Backend styles
	wp_register_style(
		'bod-modal-block-editor-css', // Handle.
		plugins_url( 'dist/blocks.editor.build.css', dirname( __FILE__ ) ), // Block editor CSS.
		array( 'wp-edit-blocks' , 'wp-editor' ) // Dependency to include the CSS after it.
	);

	/**
	 * Register Gutenberg block on server-side.
	 *
	 * Register the block on server-side to ensure that the block
	 * scripts and styles for both frontend and backend are
	 * enqueued when the editor loads.
	 *
	 * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
	 * @since 1.16.0
	 */
	register_block_type(
		'bod/modal-block', array(
			// Enqueue js on both frontend & backend.
			'script'        => 'bod-modal-block-js',
			// Enqueue css on both frontend & backend.
			'style'         => 'bod-modal-block-style-css',
			// Enqueue blocks.build.js in the editor only.
			'editor_script' => 'bod-modal-block-editor-js',
			// Enqueue blocks.editor.build.css in the editor only.
			'editor_style'  => 'bod-modal-block-editor-css',
		)
	);
}

// Hook: Frontend assets.
add_action( 'init', 'bod_modal_block_assets' );

