<?php

/*
 * Plugin Name: MetaSlider Lightbox
 * Plugin URI: https://www.metaslider.com
 * Description: MetaSlider Lightbox is the lightbox plugin for WordPress. Create lightbox display for images, sliders, galleries, videos, and more.
 * Version: 2.20.0
 * Author: MetaSlider
 * Author URI: https://www.metaslider.com
 * License: GPL-2.0+
 * Copyright: 2020+ MetaSlider
 *
 * Text Domain: ml-slider-lightbox
 * Domain Path: /languages
 */
if (! defined('ABSPATH')) {
    die('No direct access.');
}

if (! class_exists('MetaSlider\Lightbox\MetaSliderLightboxPlugin')) {
    require_once plugin_dir_path(__FILE__) . 'class-ml-slider-lightbox.php';
    add_action('plugins_loaded', array(MetaSlider\Lightbox\MetaSliderLightboxPlugin::getInstance(), 'setup'), 10);

    // Register activation hook
    register_activation_hook(__FILE__, 'metaslider_lightbox_activation');
}

/**
 * Plugin activation hook
 * Sets a transient to trigger redirect to settings page
 */
function metaslider_lightbox_activation()
{
    // Set transient to trigger redirect (expires in 30 seconds)
    set_transient('metaslider_lightbox_activation_redirect', true, 30);
}
