function mo_validation_goback(){
    var redirectUrl = (typeof moExternalPopUps !== 'undefined' && moExternalPopUps.login_page_url) 
        ? moExternalPopUps.login_page_url 
        : (typeof moExternalPopUps !== 'undefined' && moExternalPopUps.home_url) 
        ? moExternalPopUps.home_url 
        : window.location.origin;
    window.location.href = redirectUrl;
}
jQuery(document).ready(function(){
    $mo=jQuery;
    $mo(".close").click(function(){
        mo_validation_goback();
    });
    $mo("#send_otp").click(function(o){
        var e=$mo("input[name=mo_phone_number]").val();
        var n = $mo("input[name=mopopup_wpnonce]").val();
        $mo("#mo_message").empty(),
        $mo("#mo_message").append('<div class="moloader"></div>'),
        $mo("#mo_message").show(),
        $mo.ajax({
            url: moExternalPopUps.secure_site_url,
            type:"POST",
            data:{
                action:"mo_external_popup_option",
                mo_external_popup_option:"miniorange-ajax-otp-generate",
                user_phone:e,
                mopopup_wpnonce:n
            },
            crossDomain:!0,
            dataType:"json",
            success:function(o){
                if("success"===o.result){
                    $mo("#mo_message").empty(),
                    $mo("#mo_message").text(o.message),
                    $mo("#mo_message").css("background-color","#8eed8e"),
                    $mo("#validate_otp").show(),
                    $mo("#send_otp").val(moExternalPopUps.resend_otp_text),
                    $mo("#mo_validate_otp").show(),
                    $mo("input[name=mo_otp_token]").focus()
                } else {
                    $mo("#mo_message").empty(),
                    $mo("#mo_message").text(o.message),
                    $mo("#mo_message").css("background-color","#eda58e"),
                    $mo("input[name=mo_phone_number]").focus()
                    }
            },
            error:function(o,e,m){}
        })
    }),
    $mo("#validate_otp").click(function(o){
        var e=$mo("input[name=mo_otp_token]").val(),
        m=$mo("input[name=mo_phone_number]").val(),
        n=$mo("input[name=mopopup_wpnonce]").val();
        $mo("#mo_message").empty(),
        $mo("#mo_message").append('<div class="moloader"></div>'),
        $mo("#mo_message").show(),
        $mo.ajax({
            url: moExternalPopUps.secure_site_url,
            type:"POST",
            data:{
                action:"mo_external_popup_option",
                mo_external_popup_option:"miniorange-ajax-otp-validate",
                mo_otp_token:e,
                user_phone:m,
                mopopup_wpnonce:n
            },
            crossDomain:!0,
            dataType:"json",
            success:function(o){
                $mo("#mo_message").append('<div class="moloader"></div>');
                if("success"===o.result){
                    $mo("#mo_message").hide(),
                    $mo("#mo_validate_form").submit()
                } else {
                    $mo("#mo_message").empty(),
                    $mo("#mo_message").text(o.message),
                    $mo("#mo_message").css("background-color","#eda58e"),
                    $mo("input[name=validate_otp]").focus()
                }
            },
            error:function(o,e,m){}
        })
    })
})
document.addEventListener("DOMContentLoaded", function() {
    var form = document.querySelector("#mo_validate_form");
    const otpInputs = document.querySelectorAll(".mo_customer_validation-textbox.mo-new-ui-validation-textbox");
    // Create regex pattern to remove anything other than alphanumeric characters and + sign
    let inputPattern;
    if (typeof moPopUps !== 'undefined' && moPopUps.pattern) {
        try {
            // Convert string pattern to RegExp (remove leading/trailing slashes and flags)
            const patternStr = moPopUps.pattern.replace(/^\/|\/[gimuy]*$/g, '');
            inputPattern = new RegExp(patternStr, 'g');
        } catch (error) {
            // Fallback to default pattern: allow alphanumeric and + sign
            inputPattern = /[^a-zA-Z0-9+]/g;
        }
    } else {
        // Default pattern: remove anything other than alphanumeric and + sign
        inputPattern = /[^a-zA-Z0-9+]/g;
    }
    
    otpInputs.forEach(function (input) {
        input.addEventListener("input", function () {
            const originalValue = input.value;
            const cleanedValue = originalValue.replace(inputPattern, "");
            if (originalValue !== cleanedValue) {
                input.value = cleanedValue;
            }
        });
        input.addEventListener("paste", function (e) {
            e.preventDefault();
            const pasted = (e.clipboardData || window.clipboardData).getData("text");
            const clean = pasted.replace(inputPattern, "");
            const start = input.selectionStart;
            const end = input.selectionEnd;
            const currentValue = input.value;
            input.value = currentValue.slice(0, start) + clean + currentValue.slice(end);
            input.setSelectionRange(start + clean.length, start + clean.length);
        });
    });
});