// Dedicated script for the Error OTP popup.
// Provides the global `mo_validation_goback` helper and also
// explicitly binds click handlers to the close button.
(function (window, document) {
	'use strict';

	function mo_validation_goback() {
		var form = document.getElementById('validation_goBack_form');
		if (form) {
			form.submit();
		}
	}

	function bindErrorPopupClose() {
		var closeButtons = document.querySelectorAll('.mo_customer_validation-modal .close');
		if (!closeButtons || !closeButtons.length) {
			return;
		}

		closeButtons.forEach(function (btn) {
			btn.addEventListener('click', function (e) {
				if (e && typeof e.preventDefault === 'function') {
					e.preventDefault();
				}
				mo_validation_goback();
			});
		});
	}

	// Expose globally so inline onclick="{{GO_BACK_ACTION_CALL}}" can access it.
	window.mo_validation_goback = mo_validation_goback;

	// Ensure binding happens regardless of when the script loads.
	if (document.readyState === 'loading') {
		document.addEventListener('DOMContentLoaded', bindErrorPopupClose);
	} else {
		bindErrorPopupClose();
	}
})(window, document);
