<?php
/**
 * Contains List of countries to be shown in dropdown.
 * Contains functions for getting country list for dropdown and whatsapp pricing
 *
 * @package miniorange-validaition-settings
 */

namespace OTP\Helper;

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

use OTP\Traits\Instance;

/**
 * This class lists down all the countries and their country code.
 * It also lists down a few country code related functions.
 */
if ( ! class_exists( 'TransactionCost' ) ) {
	/**
	 * CountryList class
	 */
	class TransactionCost {

		use Instance;

		/**
		 * Constructor
		 */
		protected function __construct() {
			$sms_pricing = array(
				'All Countries'                  => array(
					'100 '   => '28',
					'500 '   => '135',
					'1000 '  => '259',
					'5000 '  => '1268',
					'10000 ' => '2486',
					'50000 ' => '11680',
				),
				'Afghanistan'                    => array(
					'100 '   => '55',
					'500 '   => '272',
					'1000 '  => '533',
					'5000 '  => '2636',
					'10000 ' => '5221',
					'50000 ' => '25355',
				),
				'Albania'                        => array(
					'100 '   => '21',
					'500 '   => '100',
					'1000 '  => '189',
					'5000 '  => '917',
					'10000 ' => '1784',
					'50000 ' => '8170',
				),
				'Algeria'                        => array(
					'100 '   => '39',
					'500 '   => '190',
					'1000 '  => '369',
					'5000 '  => '1817',
					'10000 ' => '3584',
					'50000 ' => '17170',
				),
				'Andorra'                        => array(
					'100 '   => '16',
					'500 '   => '77',
					'1000 '  => '144',
					'5000 '  => '694',
					'10000 ' => '1338',
					'50000 ' => '5940',
				),
				'Angola'                         => array(
					'100 '   => '25',
					'500 '   => '121',
					'1000 '  => '231',
					'5000 '  => '1129',
					'10000 ' => '2207',
					'50000 ' => '10285',
				),
				'Argentina'                      => array(
					'100 '   => '19',
					'500 '   => '89',
					'1000 '  => '167',
					'5000 '  => '806',
					'10000 ' => '1562',
					'50000 ' => '7060',
				),
				'Armenia'                        => array(
					'100 '   => '31',
					'500 '   => '152',
					'1000 '  => '293',
					'5000 '  => '1437',
					'10000 ' => '2824',
					'50000 ' => '13370',
				),
				'Australia'                      => array(
					'100 '   => '11',
					'500 '   => '50',
					'1000 '  => '89',
					'5000 '  => '420',
					'10000 ' => '790',
					'50000 ' => '3200',
				),
				'Austria'                        => array(
					'100 '   => '12',
					'500 '   => '54',
					'1000 '  => '97',
					'5000 '  => '457',
					'10000 ' => '864',
					'50000 ' => '3570',
				),
				'Azerbaijan'                     => array(
					'100 '   => '59',
					'500 '   => '289',
					'1000 '  => '567',
					'5000 '  => '2808',
					'10000 ' => '5566',
					'50000 ' => '27080',
				),
				'Bahamas'                        => array(
					'100 '   => '17',
					'500 '   => '79',
					'1000 '  => '147',
					'5000 '  => '708',
					'10000 ' => '1365',
					'50000 ' => '6075',
				),
				'Bahrain'                        => array(
					'100 '   => '12',
					'500 '   => '55',
					'1000 '  => '99',
					'5000 '  => '467',
					'10000 ' => '883',
					'50000 ' => '3665',
				),
				'Bangladesh'                     => array(
					'100 '   => '50',
					'500 '   => '247',
					'1000 '  => '484',
					'5000 '  => '2395',
					'10000 ' => '4739',
					'50000 ' => '22945',
				),
				'Barbados'                       => array(
					'100 '   => '47',
					'500 '   => '231',
					'1000 '  => '452',
					'5000 '  => '2231',
					'10000 ' => '4411',
					'50000 ' => '21305',
				),
				'Belarus'                        => array(
					'100 '   => '34',
					'500 '   => '163',
					'1000 '  => '316',
					'5000 '  => '1555',
					'10000 ' => '3060',
					'50000 ' => '14550',
				),
				'Belgium'                        => array(
					'100 '   => '16',
					'500 '   => '74',
					'1000 '  => '137',
					'5000 '  => '656',
					'10000 ' => '1261',
					'50000 ' => '5555',
				),
				'Belize'                         => array(
					'100 '   => '31',
					'500 '   => '151',
					'1000 '  => '291',
					'5000 '  => '1426',
					'10000 ' => '2801',
					'50000 ' => '13255',
				),
				'Benin'                          => array(
					'100 '   => '36',
					'500 '   => '173',
					'1000 '  => '336',
					'5000 '  => '1654',
					'10000 ' => '3258',
					'50000 ' => '15540',
				),
				'Bhutan'                         => array(
					'100 '   => '53',
					'500 '   => '259',
					'1000 '  => '508',
					'5000 '  => '2515',
					'10000 ' => '4979',
					'50000 ' => '24145',
				),
				'Bolivia'                        => array(
					'100 '   => '32',
					'500 '   => '156',
					'1000 '  => '301',
					'5000 '  => '1476',
					'10000 ' => '2901',
					'50000 ' => '13755',
				),
				'Bosnia and Herzegovina'         => array(
					'100 '   => '47',
					'500 '   => '229',
					'1000 '  => '448',
					'5000 '  => '2215',
					'10000 ' => '4380',
					'50000 ' => '21150',
				),
				'Brazil'                         => array(
					'100 '   => '11',
					'500 '   => '51',
					'1000 '  => '91',
					'5000 '  => '430',
					'10000 ' => '810',
					'50000 ' => '3300',
				),
				'Botswana'                       => array(
					'100 '   => '15',
					'500 '   => '69',
					'1000 '  => '128',
					'5000 '  => '613',
					'10000 ' => '1175',
					'50000 ' => '5125',
				),
				'Brunei'                         => array(
					'100 '   => '13',
					'500 '   => '58',
					'1000 '  => '106',
					'5000 '  => '504',
					'10000 ' => '958',
					'50000 ' => '4040',
				),
				'Bulgaria'                       => array(
					'100 '   => '23',
					'500 '   => '112',
					'1000 '  => '214',
					'5000 '  => '1044',
					'10000 ' => '2038',
					'50000 ' => '9440',
				),
				'Burkina Faso'                   => array(
					'100 '   => '28',
					'500 '   => '138',
					'1000 '  => '265',
					'5000 '  => '1300',
					'10000 ' => '2550',
					'50000 ' => '12000',
				),
				'Burundi'                        => array(
					'100 '   => '51',
					'500 '   => '248',
					'1000 '  => '486',
					'5000 '  => '2403',
					'10000 ' => '4755',
					'50000 ' => '23025',
				),
				'Cabo Verde (Cape Verde)'        => array(
					'100 '   => '26',
					'500 '   => '126',
					'1000 '  => '242',
					'5000 '  => '1185',
					'10000 ' => '2319',
					'50000 ' => '10845',
				),
				'Cambodia'                       => array(
					'100 '   => '22',
					'500 '   => '107',
					'1000 '  => '204',
					'5000 '  => '994',
					'10000 ' => '1937',
					'50000 ' => '8935',
				),
				'Cameroon'                       => array(
					'100 '   => '41',
					'500 '   => '200',
					'1000 '  => '390',
					'5000 '  => '1924',
					'10000 ' => '3798',
					'50000 ' => '18240',
				),
				'Canada'                         => array(
					'100 '   => '8',
					'500 '   => '35',
					'1000 '  => '59',
					'5000 '  => '270',
					'10000 ' => '490',
					'50000 ' => '1700',
				),
				'Chad'                           => array(
					'100 '   => '46',
					'500 '   => '223',
					'1000 '  => '436',
					'5000 '  => '2152',
					'10000 ' => '4254',
					'50000 ' => '20520',
				),
				'Chile'                          => array(
					'100 '   => '13',
					'500 '   => '60',
					'1000 '  => '109',
					'5000 '  => '518',
					'10000 ' => '985',
					'50000 ' => '4175',
				),
				'China'                          => array(
					'100 '   => '12',
					'500 '   => '54',
					'1000 '  => '97',
					'5000 '  => '459',
					'10000 ' => '868',
					'50000 ' => '3590',
				),
				'Colombia'                       => array(
					'100 '   => '11',
					'500 '   => '48',
					'1000 '  => '86',
					'5000 '  => '404',
					'10000 ' => '758',
					'50000 ' => '3040',
				),
				'Congo (Republic)'               => array(
					'100 '   => '20',
					'500 '   => '95',
					'1000 '  => '180',
					'5000 '  => '874',
					'10000 ' => '1697',
					'50000 ' => '7735',
				),
				'Congo (DRC)'                    => array(
					'100 '   => '26',
					'500 '   => '125',
					'1000 '  => '240',
					'5000 '  => '1174',
					'10000 ' => '2298',
					'50000 ' => '10740',
				),
				'Comoros'                        => array(
					'100 '   => '41',
					'500 '   => '198',
					'1000 '  => '386',
					'5000 '  => '1904',
					'10000 ' => '3757',
					'50000 ' => '18035',
				),
				'Costa Rica'                     => array(
					'100 '   => '11',
					'500 '   => '49',
					'1000 '  => '87',
					'5000 '  => '409',
					'10000 ' => '767',
					'50000 ' => '3085',
				),
				'Côte d\'Ivoire'                 => array(
					'100 '   => '45',
					'500 '   => '222',
					'1000 '  => '433',
					'5000 '  => '2138',
					'10000 ' => '4226',
					'50000 ' => '20380',
				),
				'Croatia'                        => array(
					'100 '   => '20',
					'500 '   => '95',
					'1000 '  => '180',
					'5000 '  => '871',
					'10000 ' => '1691',
					'50000 ' => '7705',
				),
				'Cuba'                           => array(
					'100 '   => '13',
					'500 '   => '63',
					'1000 '  => '115',
					'5000 '  => '548',
					'10000 ' => '1045',
					'50000 ' => '4475',
				),
				'Cyprus'                         => array(
					'100 '   => '11',
					'500 '   => '51',
					'1000 '  => '92',
					'5000 '  => '432',
					'10000 ' => '813',
					'50000 ' => '3315',
				),
				'Czechia'                        => array(
					'100 '   => '14',
					'500 '   => '65',
					'1000 '  => '120',
					'5000 '  => '571',
					'10000 ' => '1092',
					'50000 ' => '4710',
				),
				'Denmark'                        => array(
					'100 '   => '11',
					'500 '   => '52',
					'1000 '  => '93',
					'5000 '  => '439',
					'10000 ' => '827',
					'50000 ' => '3385',
				),
				'Dominica'                       => array(
					'100 '   => '32',
					'500 '   => '155',
					'1000 '  => '300',
					'5000 '  => '1471',
					'10000 ' => '2892',
					'50000 ' => '13710',
				),
				'Dominican Republic'             => array(
					'100 '   => '15',
					'500 '   => '70',
					'1000 '  => '129',
					'5000 '  => '618',
					'10000 ' => '1185',
					'50000 ' => '5175',
				),
				'Ecuador'                        => array(
					'100 '   => '39',
					'500 '   => '190',
					'1000 '  => '369',
					'5000 '  => '1816',
					'10000 ' => '3582',
					'50000 ' => '17160',
				),
				'Eritrea'                        => array(
					'100 '   => '24',
					'500 '   => '113',
					'1000 '  => '216',
					'5000 '  => '1053',
					'10000 ' => '2055',
					'50000 ' => '9525',
				),
				'Euator'                         => array(
					'100 '   => '8',
					'500 '   => '34',
					'1000 '  => '65',
					'5000 '  => '312',
					'10000 ' => '614',
					'50000 ' => '2965',
				),
				'Egypt'                          => array(
					'100 '   => '39',
					'500 '   => '193',
					'1000 '  => '375',
					'5000 '  => '1848',
					'10000 ' => '3645',
					'50000 ' => '17475',
				),
				'El Salvador'                    => array(
					'100 '   => '20',
					'500 '   => '98',
					'1000 '  => '185',
					'5000 '  => '900',
					'10000 ' => '1749',
					'50000 ' => '7995',
				),
				'Estonia'                        => array(
					'100 '   => '12',
					'500 '   => '55',
					'1000 '  => '100',
					'5000 '  => '475',
					'10000 ' => '899',
					'50000 ' => '3745',
				),
				'Ethiopia'                       => array(
					'100 '   => '50',
					'500 '   => '246',
					'1000 '  => '482',
					'5000 '  => '2383',
					'10000 ' => '4716',
					'50000 ' => '22830',
				),
				'Finland'                        => array(
					'100 '   => '18',
					'500 '   => '86',
					'1000 '  => '162',
					'5000 '  => '784',
					'10000 ' => '1518',
					'50000 ' => '6840',
				),
				'Fiji'                           => array(
					'100 '   => '28',
					'500 '   => '133',
					'1000 '  => '256',
					'5000 '  => '1254',
					'10000 ' => '2457',
					'50000 ' => '11535',
				),
				'France'                         => array(
					'100 '   => '13',
					'500 '   => '60',
					'1000 '  => '110',
					'5000 '  => '525',
					'10000 ' => '1000',
					'50000 ' => '4250',
				),
				'Gabon'                          => array(
					'100 '   => '44',
					'500 '   => '214',
					'1000 '  => '417',
					'5000 '  => '2059',
					'10000 ' => '4068',
					'50000 ' => '19590',
				),
				'Gambia'                         => array(
					'100 '   => '22',
					'500 '   => '106',
					'1000 '  => '201',
					'5000 '  => '978',
					'10000 ' => '1906',
					'50000 ' => '8780',
				),
				'Georgia'                        => array(
					'100 '   => '25',
					'500 '   => '119',
					'1000 '  => '227',
					'5000 '  => '1109',
					'10000 ' => '2167',
					'50000 ' => '10085',
				),
				'Germany'                        => array(
					'100 '   => '15',
					'500 '   => '68',
					'1000 '  => '126',
					'5000 '  => '601',
					'10000 ' => '1152',
					'50000 ' => '5010',
				),
				'Ghana'                          => array(
					'100 '   => '44',
					'500 '   => '214',
					'1000 '  => '418',
					'5000 '  => '2062',
					'10000 ' => '4074',
					'50000 ' => '19620',
				),
				'Greece'                         => array(
					'100 '   => '14',
					'500 '   => '65',
					'1000 '  => '119',
					'5000 '  => '568',
					'10000 ' => '1086',
					'50000 ' => '4680',
				),
				'Guadeloupe'                     => array(
					'100 '   => '19',
					'500 '   => '89',
					'1000 '  => '167',
					'5000 '  => '808',
					'10000 ' => '1566',
					'50000 ' => '7080',
				),
				'Guatemala'                      => array(
					'100 '   => '37',
					'500 '   => '183',
					'1000 '  => '355',
					'5000 '  => '1750',
					'10000 ' => '3450',
					'50000 ' => '16500',
				),
				'Guinea'                         => array(
					'100 '   => '40',
					'500 '   => '193',
					'1000 '  => '376',
					'5000 '  => '1855',
					'10000 ' => '3659',
					'50000 ' => '17545',
				),
				'Guinea-Bissau'                  => array(
					'100 '   => '28',
					'500 '   => '135',
					'1000 '  => '259',
					'5000 '  => '1266',
					'10000 ' => '2482',
					'50000 ' => '11660',
				),
				'Guyana'                         => array(
					'100 '   => '32',
					'500 '   => '158',
					'1000 '  => '305',
					'5000 '  => '1498',
					'10000 ' => '2945',
					'50000 ' => '13975',
				),
				'Haiti'                          => array(
					'100 '   => '49',
					'500 '   => '242',
					'1000 '  => '473',
					'5000 '  => '2336',
					'10000 ' => '4622',
					'50000 ' => '22360',
				),
				'Honduras'                       => array(
					'100 '   => '30',
					'500 '   => '144',
					'1000 '  => '277',
					'5000 '  => '1356',
					'10000 ' => '2662',
					'50000 ' => '12560',
				),
				'Hong Kong'                      => array(
					'100 '   => '14',
					'500 '   => '66',
					'1000 '  => '122',
					'5000 '  => '584',
					'10000 ' => '1118',
					'50000 ' => '4840',
				),
				'Hungary'                        => array(
					'100 '   => '15',
					'500 '   => '72',
					'1000 '  => '133',
					'5000 '  => '640',
					'10000 ' => '1229',
					'50000 ' => '5395',
				),
				'Iceland'                        => array(
					'100 '   => '13',
					'500 '   => '62',
					'1000 '  => '113',
					'5000 '  => '536',
					'10000 ' => '1021',
					'50000 ' => '4355',
				),
				'India'                          => array(
					'500 '   => '5',
					'1000 '  => '7',
					'5000 '  => '27',
					'10000 ' => '48',
					'50000 ' => '185',
				),
				'Indonesia'                      => array(
					'100 '   => '60',
					'500 '   => '297',
					'1000 '  => '583',
					'5000 '  => '2890',
					'10000 ' => '5729',
					'50000 ' => '27895',
				),
				'Iran'                           => array(
					'100 '   => '44',
					'500 '   => '213',
					'1000 '  => '416',
					'5000 '  => '2052',
					'10000 ' => '4054',
					'50000 ' => '19520',
				),
				'Iraq'                           => array(
					'100 '   => '47',
					'500 '   => '230',
					'1000 '  => '449',
					'5000 '  => '2220',
					'10000 ' => '4390',
					'50000 ' => '21200',
				),
				'Ireland'                        => array(
					'100 '   => '12',
					'500 '   => '58',
					'1000 '  => '105',
					'5000 '  => '500',
					'10000 ' => '950',
					'50000 ' => '4000',
				),
				'Israel'                         => array(
					'100 '   => '32',
					'500 '   => '158',
					'1000 '  => '305',
					'5000 '  => '1499',
					'10000 ' => '2948',
					'50000 ' => '13990',
				),
				'Italy'                          => array(
					'100 '   => '13',
					'500 '   => '59',
					'1000 '  => '108',
					'5000 '  => '515',
					'10000 ' => '980',
					'50000 ' => '4150',
				),
				'Jamaica'                        => array(
					'100 '   => '31',
					'500 '   => '150',
					'1000 '  => '289',
					'5000 '  => '1417',
					'10000 ' => '2784',
					'50000 ' => '13170',
				),
				'Japan'                          => array(
					'100 '   => '15',
					'500 '   => '68',
					'1000 '  => '126',
					'5000 '  => '605',
					'10000 ' => '1159',
					'50000 ' => '5045',
				),
				'Jordan'                         => array(
					'100 '   => '27',
					'500 '   => '130',
					'1000 '  => '249',
					'5000 '  => '1220',
					'10000 ' => '2390',
					'50000 ' => '11200',
				),
				'Kazakhstan'                     => array(
					'100 '   => '40',
					'500 '   => '194',
					'1000 '  => '378',
					'5000 '  => '1864',
					'10000 ' => '3678',
					'50000 ' => '17640',
				),
				'Kenya'                          => array(
					'100 '   => '25',
					'500 '   => '120',
					'1000 '  => '229',
					'5000 '  => '1120',
					'10000 ' => '2190',
					'50000 ' => '10200',
				),
				'Kosovo'                         => array(
					'100 '   => '20',
					'500 '   => '97',
					'1000 '  => '183',
					'5000 '  => '889',
					'10000 ' => '1727',
					'50000 ' => '7885',
				),
				'Kuwait'                         => array(
					'100 '   => '28',
					'500 '   => '137',
					'1000 '  => '264',
					'5000 '  => '1292',
					'10000 ' => '2534',
					'50000 ' => '11920',
				),
				'Kyrgyzstan'                     => array(
					'100 '   => '43',
					'500 '   => '213',
					'1000 '  => '415',
					'5000 '  => '2046',
					'10000 ' => '4041',
					'50000 ' => '19455',
				),
				'Laos'                           => array(
					'100 '   => '18',
					'500 '   => '87',
					'1000 '  => '163',
					'5000 '  => '788',
					'10000 ' => '1525',
					'50000 ' => '6875',
				),
				'Latvia'                         => array(
					'100 '   => '11',
					'500 '   => '50',
					'1000 '  => '89',
					'5000 '  => '417',
					'10000 ' => '783',
					'50000 ' => '3165',
				),
				'Lebanon'                        => array(
					'100 '   => '42',
					'500 '   => '206',
					'1000 '  => '402',
					'5000 '  => '1983',
					'10000 ' => '3915',
					'50000 ' => '18825',
				),
				'Lesotho'                        => array(
					'100 '   => '37',
					'500 '   => '181',
					'1000 '  => '352',
					'5000 '  => '1735',
					'10000 ' => '3419',
					'50000 ' => '16345',
				),
				'Liberia'                        => array(
					'100 '   => '17',
					'500 '   => '80',
					'1000 '  => '150',
					'5000 '  => '725',
					'10000 ' => '1400',
					'50000 ' => '6250',
				),
				'Libya'                          => array(
					'100 '   => '59',
					'500 '   => '291',
					'1000 '  => '571',
					'5000 '  => '2829',
					'10000 ' => '5608',
					'50000 ' => '27290',
				),
				'Liechtenstein'                  => array(
					'100 '   => '9',
					'500 '   => '39',
					'1000 '  => '67',
					'5000 '  => '308',
					'10000 ' => '566',
					'50000 ' => '2080',
				),
				'Lithuania'                      => array(
					'100 '   => '11',
					'500 '   => '51',
					'1000 '  => '91',
					'5000 '  => '426',
					'10000 ' => '802',
					'50000 ' => '3260',
				),
				'Luxembourg'                     => array(
					'100 '   => '20',
					'500 '   => '94',
					'1000 '  => '177',
					'5000 '  => '856',
					'10000 ' => '1661',
					'50000 ' => '7555',
				),
				'Macau'                          => array(
					'100 '   => '10',
					'500 '   => '46',
					'1000 '  => '81',
					'5000 '  => '380',
					'10000 ' => '710',
					'50000 ' => '2800',
				),
				'Macedonia'                      => array(
					'100 '   => '15',
					'500 '   => '69',
					'1000 '  => '127',
					'5000 '  => '606',
					'10000 ' => '1162',
					'50000 ' => '5060',
				),
				'Madagascar'                     => array(
					'100 '   => '52',
					'500 '   => '256',
					'1000 '  => '502',
					'5000 '  => '2485',
					'10000 ' => '4920',
					'50000 ' => '23850',
				),
				'Malawi'                         => array(
					'100 '   => '45',
					'500 '   => '220',
					'1000 '  => '429',
					'5000 '  => '2118',
					'10000 ' => '4186',
					'50000 ' => '20180',
				),
				'Malaysia'                       => array(
					'100 '   => '37',
					'500 '   => '183',
					'1000 '  => '355',
					'5000 '  => '1749',
					'10000 ' => '3448',
					'50000 ' => '16490',
				),
				'Maldives'                       => array(
					'100 '   => '41',
					'500 '   => '199',
					'1000 '  => '387',
					'5000 '  => '1909',
					'10000 ' => '3767',
					'50000 ' => '18085',
				),
				'Mali'                           => array(
					'100 '   => '43',
					'500 '   => '208',
					'1000 '  => '406',
					'5000 '  => '2003',
					'10000 ' => '3956',
					'50000 ' => '19030',
				),
				'Malta'                          => array(
					'100 '   => '13',
					'500 '   => '60',
					'1000 '  => '113',
					'5000 '  => '538',
					'10000 ' => '1026',
					'50000 ' => '4380',
				),
				'Mauritania'                     => array(
					'100 '   => '40',
					'500 '   => '197',
					'1000 '  => '384',
					'5000 '  => '1892',
					'10000 ' => '3733',
					'50000 ' => '17915',
				),
				'Mauritius'                      => array(
					'100 '   => '24',
					'500 '   => '114',
					'1000 '  => '218',
					'5000 '  => '1065',
					'10000 ' => '2080',
					'50000 ' => '9650',
				),
				'Mexico'                         => array(
					'100 '   => '15',
					'500 '   => '69',
					'1000 '  => '128',
					'5000 '  => '611',
					'10000 ' => '1171',
					'50000 ' => '5105',
				),
				'Moldova'                        => array(
					'100 '   => '20',
					'500 '   => '94',
					'1000 '  => '177',
					'5000 '  => '860',
					'10000 ' => '1670',
					'50000 ' => '7600',
				),
				'Mongolia'                       => array(
					'100 '   => '38',
					'500 '   => '184',
					'1000 '  => '358',
					'5000 '  => '1765',
					'10000 ' => '3480',
					'50000 ' => '16650',
				),
				'Montenegro'                     => array(
					'100 '   => '28',
					'500 '   => '134',
					'1000 '  => '257',
					'5000 '  => '1256',
					'10000 ' => '2462',
					'50000 ' => '11560',
				),
				'Morocco'                        => array(
					'100 '   => '36',
					'500 '   => '175',
					'1000 '  => '339',
					'5000 '  => '1668',
					'10000 ' => '3286',
					'50000 ' => '15680',
				),
				'Mozambique'                     => array(
					'100 '   => '14',
					'500 '   => '65',
					'1000 '  => '119',
					'5000 '  => '569',
					'10000 ' => '1088',
					'50000 ' => '4690',
				),
				'Myanmar'                        => array(
					'100 '   => '48',
					'500 '   => '235',
					'1000 '  => '459',
					'5000 '  => '2267',
					'10000 ' => '4484',
					'50000 ' => '21670',
				),
				'Namibia'                        => array(
					'100 '   => '11',
					'500 '   => '49',
					'1000 '  => '87',
					'5000 '  => '410',
					'10000 ' => '770',
					'50000 ' => '3100',
				),
				'Nepal'                          => array(
					'100 '   => '24',
					'500 '   => '115',
					'1000 '  => '219',
					'5000 '  => '1066',
					'10000 ' => '2082',
					'50000 ' => '9660',
				),
				'Netherlands'                    => array(
					'100 '   => '16',
					'500 '   => '73',
					'1000 '  => '136',
					'5000 '  => '651',
					'10000 ' => '1252',
					'50000 ' => '5510',
				),
				'New Zealand'                    => array(
					'100 '   => '12',
					'500 '   => '57',
					'1000 '  => '104',
					'5000 '  => '491',
					'10000 ' => '931',
					'50000 ' => '3905',
				),
				'Nicaragua'                      => array(
					'100 '   => '21',
					'500 '   => '103',
					'1000 '  => '195',
					'5000 '  => '948',
					'10000 ' => '1845',
					'50000 ' => '8475',
				),
				'Niger'                          => array(
					'100 '   => '38',
					'500 '   => '183',
					'1000 '  => '356',
					'5000 '  => '1754',
					'10000 ' => '3457',
					'50000 ' => '16535',
				),
				'Nigeria'                        => array(
					'100 '   => '44',
					'500 '   => '216',
					'1000 '  => '422',
					'5000 '  => '2084',
					'10000 ' => '4117',
					'50000 ' => '19835',
				),
				'Norway'                         => array(
					'100 '   => '12',
					'500 '   => '53',
					'1000 '  => '96',
					'5000 '  => '453',
					'10000 ' => '856',
					'50000 ' => '3530',
				),
				'Occupied Palestinian Territory' => array(
					'100 '   => '51',
					'500 '   => '253',
					'1000 '  => '495',
					'5000 '  => '2446',
					'10000 ' => '4842',
					'50000 ' => '23460',
				),
				'Oman'                           => array(
					'100 '   => '30',
					'500 '   => '144',
					'1000 '  => '278',
					'5000 '  => '1364',
					'10000 ' => '2677',
					'50000 ' => '12635',
				),
				'Pakistan'                       => array(
					'100 '   => '53',
					'500 '   => '259',
					'1000 '  => '508',
					'5000 '  => '2515',
					'10000 ' => '4979',
					'50000 ' => '24145',
				),
				'Panama'                         => array(
					'100 '   => '23',
					'500 '   => '112',
					'1000 '  => '213',
					'5000 '  => '1040',
					'10000 ' => '2030',
					'50000 ' => '9400',
				),
				'Papua New Guinea'               => array(
					'100 '   => '71',
					'500 '   => '352',
					'1000 '  => '694',
					'5000 '  => '3441',
					'10000 ' => '6831',
					'50000 ' => '33405',
				),
				'Paraguay'                       => array(
					'100 '   => '19',
					'500 '   => '91',
					'1000 '  => '172',
					'5000 '  => '832',
					'10000 ' => '1614',
					'50000 ' => '7320',
				),
				'Peru'                           => array(
					'100 '   => '24',
					'500 '   => '114',
					'1000 '  => '217',
					'5000 '  => '1060',
					'10000 ' => '2070',
					'50000 ' => '9600',
				),
				'Philippines'                    => array(
					'100 '   => '31',
					'500 '   => '149',
					'1000 '  => '287',
					'5000 '  => '1410',
					'10000 ' => '2770',
					'50000 ' => '13100',
				),
				'Poland'                         => array(
					'100 '   => '9',
					'500 '   => '42',
					'1000 '  => '74',
					'5000 '  => '344',
					'10000 ' => '638',
					'50000 ' => '2440',
				),
				'Portugal'                       => array(
					'100 '   => '9',
					'500 '   => '39',
					'1000 '  => '67',
					'5000 '  => '309',
					'10000 ' => '568',
					'50000 ' => '2090',
				),
				'Puerto Rico'                    => array(
					'100 '   => '13',
					'500 '   => '63',
					'1000 '  => '115',
					'5000 '  => '546',
					'10000 ' => '1042',
					'50000 ' => '4460',
				),
				'Qatar'                          => array(
					'100 '   => '31',
					'500 '   => '152',
					'1000 '  => '293',
					'5000 '  => '1437',
					'10000 ' => '2824',
					'50000 ' => '13370',
				),
				'Republic of Korea'              => array(
					'100 '   => '9',
					'500 '   => '38',
					'1000 '  => '66',
					'5000 '  => '305',
					'10000 ' => '560',
					'50000 ' => '2050',
				),
				'Romania'                        => array(
					'100 '   => '12',
					'500 '   => '55',
					'1000 '  => '99',
					'5000 '  => '470',
					'10000 ' => '889',
					'50000 ' => '3695',
				),
				'Russia'                         => array(
					'100 '   => '56',
					'500 '   => '275',
					'1000 '  => '539',
					'5000 '  => '2666',
					'10000 ' => '5282',
					'50000 ' => '25660',
				),
				'Rwanda'                         => array(
					'100 '   => '41',
					'500 '   => '201',
					'1000 '  => '392',
					'5000 '  => '1933',
					'10000 ' => '3815',
					'50000 ' => '18325',
				),
				'Saint Kitts and Nevis'          => array(
					'100 '   => '34',
					'500 '   => '164',
					'1000 '  => '317',
					'5000 '  => '1557',
					'10000 ' => '3064',
					'50000 ' => '14570',
				),
				'Samoa'                          => array(
					'100 '   => '38',
					'500 '   => '188',
					'1000 '  => '365',
					'5000 '  => '1799',
					'10000 ' => '3548',
					'50000 ' => '16990',
				),
				'Saudi Arabia'                   => array(
					'100 '   => '23',
					'500 '   => '112',
					'1000 '  => '213',
					'5000 '  => '1040',
					'10000 ' => '2030',
					'50000 ' => '9400',
				),
				'Senegal'                        => array(
					'100 '   => '42',
					'500 '   => '206',
					'1000 '  => '402',
					'5000 '  => '1983',
					'10000 ' => '3916',
					'50000 ' => '18830',
				),
				'Serbia'                         => array(
					'100 '   => '48',
					'500 '   => '227',
					'1000 '  => '444',
					'5000 '  => '2192',
					'10000 ' => '4334',
					'50000 ' => '20920',
				),
				'Seychelles'                     => array(
					'100 '   => '26',
					'500 '   => '126',
					'1000 '  => '242',
					'5000 '  => '1182',
					'10000 ' => '2313',
					'50000 ' => '10815',
				),
				'Sierra Leone'                   => array(
					'100 '   => '54',
					'500 '   => '268',
					'1000 '  => '525',
					'5000 '  => '2599',
					'10000 ' => '5148',
					'50000 ' => '24990',
				),
				'Singapore'                      => array(
					'100 '   => '11',
					'500 '   => '52',
					'1000 '  => '94',
					'5000 '  => '442',
					'10000 ' => '833',
					'50000 ' => '3415',
				),
				'Slovakia'                       => array(
					'100 '   => '13',
					'500 '   => '63',
					'1000 '  => '115',
					'5000 '  => '550',
					'10000 ' => '1049',
					'50000 ' => '4495',
				),
				'Slovenia'                       => array(
					'100 '   => '26',
					'500 '   => '125',
					'1000 '  => '239',
					'5000 '  => '1166',
					'10000 ' => '2281',
					'50000 ' => '10655',
				),
				'Somalia'                        => array(
					'100 '   => '35',
					'500 '   => '169',
					'1000 '  => '327',
					'5000 '  => '1607',
					'10000 ' => '3163',
					'50000 ' => '15065',
				),
				'South Africa'                   => array(
					'100 '   => '17',
					'500 '   => '83',
					'1000 '  => '155',
					'5000 '  => '750',
					'10000 ' => '1450',
					'50000 ' => '6500',
				),
				'South Korea'                    => array(
					'100 '   => '4',
					'500 '   => '16',
					'1000 '  => '28',
					'5000 '  => '125',
					'10000 ' => '240',
					'50000 ' => '1095',
				),
				'Spain'                          => array(
					'100 '   => '11',
					'500 '   => '53',
					'1000 '  => '95',
					'5000 '  => '450',
					'10000 ' => '849',
					'50000 ' => '3495',
				),
				'SriLanka'                       => array(
					'100 '   => '56',
					'500 '   => '273',
					'1000 '  => '536',
					'5000 '  => '2651',
					'10000 ' => '5252',
					'50000 ' => '25510',
				),
				'Sudan'                          => array(
					'100 '   => '32',
					'500 '   => '154',
					'1000 '  => '298',
					'5000 '  => '1461',
					'10000 ' => '2871',
					'50000 ' => '13605',
				),
				'Suriname'                       => array(
					'100 '   => '34',
					'500 '   => '163',
					'1000 '  => '316',
					'5000 '  => '1552',
					'10000 ' => '3054',
					'50000 ' => '14520',
				),
				'Sweden'                         => array(
					'100 '   => '12',
					'500 '   => '55',
					'1000 '  => '100',
					'5000 '  => '474',
					'10000 ' => '897',
					'50000 ' => '3735',
				),
				'Switzerland'                    => array(
					'100 '   => '12',
					'500 '   => '53',
					'1000 '  => '96',
					'5000 '  => '454',
					'10000 ' => '857',
					'50000 ' => '3535',
				),
				'Syria'                          => array(
					'100 '   => '62',
					'500 '   => '304',
					'1000 '  => '598',
					'5000 '  => '2962',
					'10000 ' => '5874',
					'50000 ' => '28620',
				),
				'Tajikistan'                     => array(
					'100 '   => '61',
					'500 '   => '303',
					'1000 '  => '595',
					'5000 '  => '2949',
					'10000 ' => '5848',
					'50000 ' => '28490',
				),
				'Taiwan'                         => array(
					'100 '   => '14',
					'500 '   => '64',
					'1000 '  => '118',
					'5000 '  => '563',
					'10000 ' => '1076',
					'50000 ' => '4630',
				),
				'Tanzania'                       => array(
					'100 '   => '53',
					'500 '   => '258',
					'1000 '  => '506',
					'5000 '  => '2505',
					'10000 ' => '4959',
					'50000 ' => '24045',
				),
				'Thailand'                       => array(
					'100 '   => '8',
					'500 '   => '38',
					'1000 '  => '65',
					'5000 '  => '300',
					'10000 ' => '550',
					'50000 ' => '2000',
				),
				'Timor-Leste'                    => array(
					'100 '   => '31',
					'500 '   => '153',
					'1000 '  => '295',
					'5000 '  => '1447',
					'10000 ' => '2843',
					'50000 ' => '13465',
				),
				'Trinidad and Tobago'            => array(
					'100 '   => '36',
					'500 '   => '174',
					'1000 '  => '337',
					'5000 '  => '1660',
					'10000 ' => '3269',
					'50000 ' => '15595',
				),
				'Togo'                           => array(
					'100 '   => '67',
					'500 '   => '329',
					'1000 '  => '648',
					'5000 '  => '3213',
					'10000 ' => '6375',
					'50000 ' => '31125',
				),
				'Tunisia'                        => array(
					'100 '   => '53',
					'500 '   => '258',
					'1000 '  => '506',
					'5000 '  => '2504',
					'10000 ' => '4957',
					'50000 ' => '24035',
				),
				'Turkey'                         => array(
					'100 '   => '9',
					'500 '   => '39',
					'1000 '  => '67',
					'5000 '  => '308',
					'10000 ' => '566',
					'50000 ' => '2080',
				),
				'Turkmenistan'                   => array(
					'100 '   => '44',
					'500 '   => '214',
					'1000 '  => '417',
					'5000 '  => '2056',
					'10000 ' => '4061',
					'50000 ' => '19555',
				),
				'Uganda'                         => array(
					'100 '   => '25',
					'500 '   => '122',
					'1000 '  => '234',
					'5000 '  => '1142',
					'10000 ' => '2234',
					'50000 ' => '10420',
				),
				'Ukraine'                        => array(
					'100 '   => '25',
					'500 '   => '120',
					'1000 '  => '230',
					'5000 '  => '1121',
					'10000 ' => '2191',
					'50000 ' => '10205',
				),
				'United Arab Emirates'           => array(
					'100 '   => '17',
					'500 '   => '80',
					'1000 '  => '150',
					'5000 '  => '722',
					'10000 ' => '1394',
					'50000 ' => '6220',
				),
				'United Kingdom'                 => array(
					'100 '   => '10',
					'500 '   => '46',
					'1000 '  => '82',
					'5000 '  => '381',
					'10000 ' => '711',
					'50000 ' => '2805',
				),
				'United State'                   => array(
					'100 '   => '8',
					'500 '   => '35',
					'1000 '  => '60',
					'5000 '  => '273',
					'10000 ' => '496',
					'50000 ' => '1730',
				),
				'Uruguay'                        => array(
					'100 '   => '18',
					'500 '   => '86',
					'1000 '  => '162',
					'5000 '  => '785',
					'10000 ' => '1520',
					'50000 ' => '6850',
				),
				'Uzbekistan'                     => array(
					'100 '   => '59',
					'500 '   => '292',
					'1000 '  => '573',
					'5000 '  => '2836',
					'10000 ' => '5621',
					'50000 ' => '27355',
				),
				'Vanuatu'                        => array(
					'100 '   => '37',
					'500 '   => '181',
					'1000 '  => '351',
					'5000 '  => '1729',
					'10000 ' => '3408',
					'50000 ' => '16290',
				),
				'Venezuela'                      => array(
					'100 '   => '31',
					'500 '   => '150',
					'1000 '  => '289',
					'5000 '  => '1417',
					'10000 ' => '2784',
					'50000 ' => '13170',
				),
				'Vietnam'                        => array(
					'100 '   => '31',
					'500 '   => '152',
					'1000 '  => '293',
					'5000 '  => '1440',
					'10000 ' => '2830',
					'50000 ' => '13400',
				),
				'Yemen'                          => array(
					'100 '   => '46',
					'500 '   => '226',
					'1000 '  => '441',
					'5000 '  => '2177',
					'10000 ' => '4303',
					'50000 ' => '20765',
				),
				'Zambia'                         => array(
					'100 '   => '44',
					'500 '   => '217',
					'1000 '  => '424',
					'5000 '  => '2092',
					'10000 ' => '4133',
					'50000 ' => '19915',
				),
				'Zimbabwe'                       => array(
					'100 '   => '30',
					'500 '   => '145',
					'1000 '  => '280',
					'5000 '  => '1375',
					'10000 ' => '2699',
					'50000 ' => '12745',
				),
			);
			add_action( 'wp_ajax_wa_miniorange_check_pricing', array( $this, 'check_whatsapp_pricing' ) );
			add_action( 'wp_ajax_miniorange_check_sms_pricing', array( $this, 'check_sms_pricing' ) );
			define(
				'MO_SMS_PRICING',
				$sms_pricing
			);
		}


		/**
		 * Function for checking the whatsapp pricing.
		 */
		public function check_whatsapp_pricing() {
			if ( ! check_ajax_referer( 'whatsappnonce', 'security', false ) ) {
				return;
			}
			$target_country = isset( $_POST['target_country'] ) ? sanitize_text_field( wp_unslash( $_POST['target_country'] ) ) : '';

			$whatsapp_pricing_response = $this->mo_wa_check_pricing( $target_country );
			if ( empty( $whatsapp_pricing_response ) ) {
				wp_send_json_error( array( 'message' => __( 'Country not found', 'miniorange-otp-verification' ) ) );
				return;
			}
			wp_send_json_success( $whatsapp_pricing_response );
		}


		/**
		 * Function for checking the SMS pricing.
		 */
		public function check_sms_pricing() {
			if ( ! check_ajax_referer( 'mosmsnonce', 'security', false ) ) {
				return;
			}
			$target_country       = isset( $_POST['target_country'] ) ? sanitize_text_field( wp_unslash( $_POST['target_country'] ) ) : '';
			$sms_pricing_response = isset( MO_SMS_PRICING[ $target_country ] ) ? MO_SMS_PRICING[ $target_country ] : array();
			if ( empty( $sms_pricing_response ) ) {
				wp_send_json_error( array( 'message' => __( 'Country not found', 'miniorange-otp-verification' ) ) );
				return;
			}
			wp_send_json_success( $sms_pricing_response );
		}


		/**
		 * Check the whatsapp pricing for a particular target country.
		 *
		 * @param string $target_country - target country.
		 * @return array
		 */
		public function mo_wa_check_pricing( $target_country ) {
			$content = $this->check_transaction_cost( $target_country );
			return $content;
		}

		/**Country List
		 *
		 * @var $countries
		 */
		public static $countries = array(
			array(
				'name'         => 'All Countries',
				'alphacode'    => '',
				'countryCode'  => '',
				'whatsappcost' => array(
					'100'   => '25',
					'500'   => '89',
					'1000'  => '169',
					'5000'  => '768',
					'10000' => '1518',
					'50000' => '7475',
				),
			),
			array(
				'name'         => 'North America',
				'whatsappcost' => array(
					'100'   => '3',
					'500'   => '9',
					'1000'  => '17',
					'5000'  => '75',
					'10000' => '150',
					'50000' => '740',
				),
			),
			array(
				'name'         => 'Rest of Africa',
				'whatsappcost' => array(
					'100'   => '13',
					'500'   => '63',
					'1000'  => '124',
					'5000'  => '612',
					'10000' => '1215',
					'50000' => '6050',
				),
			),
			array(
				'name'         => 'Rest of Asia Pacific',
				'whatsappcost' => array(
					'100'   => '9',
					'500'   => '42',
					'1000'  => '83',
					'5000'  => '410',
					'10000' => '821',
					'50000' => '4101',
				),
			),
			array(
				'name'         => 'Rest of Central & Eastern Europe',
				'whatsappcost' => array(
					'100'   => '10',
					'500'   => '46',
					'1000'  => '91',
					'5000'  => '438',
					'10000' => '865',
					'50000' => '4220',
				),
			),
			array(
				'name'         => 'Rest of Latin America',
				'whatsappcost' => array(
					'100'   => '8',
					'500'   => '37',
					'1000'  => '72',
					'5000'  => '355',
					'10000' => '710',
					'50000' => '3535',
				),
			),
			array(
				'name'         => 'Rest of Middle East',
				'whatsappcost' => array(
					'100'   => '9',
					'500'   => '41',
					'1000'  => '81',
					'5000'  => '389',
					'10000' => '767',
					'50000' => '3680',
				),
			),
			array(
				'name'         => 'Rest of Western Europe',
				'whatsappcost' => array(
					'100'   => '15',
					'500'   => '71',
					'1000'  => '139',
					'5000'  => '682',
					'10000' => '1357',
					'50000' => '6670',
				),
			),
			array(
				'name'         => 'Argentina',
				'alphacode'    => 'ar',
				'countryCode'  => '+54',
				'whatsappcost' => array(
					'100'   => '8',
					'500'   => '37',
					'1000'  => '70',
					'5000'  => '340',
					'10000' => '665',
					'50000' => '3300',
				),
			),
			array(
				'name'         => 'Brazil (Brasil)',
				'alphacode'    => 'br',
				'countryCode'  => '+55',
				'whatsappcost' => array(
					'100'   => '8',
					'500'   => '33',
					'1000'  => '63',
					'5000'  => '275',
					'10000' => '533',
					'50000' => '2550',
				),
			),
			array(
				'name'         => 'Chile',
				'alphacode'    => 'cl',
				'countryCode'  => '+56',
				'whatsappcost' => array(
					'100'   => '10',
					'500'   => '42',
					'1000'  => '83',
					'5000'  => '399',
					'10000' => '787',
					'50000' => '3830',
				),
			),
			array(
				'name'         => 'Colombia',
				'alphacode'    => 'co',
				'countryCode'  => '+57',
				'whatsappcost' => array(
					'100'   => '3',
					'500'   => '10',
					'1000'  => '17',
					'5000'  => '70',
					'10000' => '130',
					'50000' => '545',
				),
			),
			array(
				'name'         => 'Egypt (‫مصر‬‎)',
				'alphacode'    => 'eg',
				'countryCode'  => '+20',
				'whatsappcost' => array(
					'100'   => '13',
					'500'   => '58',
					'1000'  => '114',
					'5000'  => '557',
					'10000' => '1103',
					'50000' => '5410',
				),

			),
			array(
				'name'         => 'France',
				'alphacode'    => 'fr',
				'countryCode'  => '+33',
				'whatsappcost' => array(
					'100'   => '16',
					'500'   => '76',
					'1000'  => '150',
					'5000'  => '736',
					'10000' => '1462',
					'50000' => '7205',
				),
			),
			array(
				'name'         => 'Germany (Deutschland)',
				'alphacode'    => 'de',
				'countryCode'  => '+49',
				'whatsappcost' => array(
					'100'   => '16',
					'500'   => '73',
					'1000'  => '144',
					'5000'  => '703',
					'10000' => '1395',
					'50000' => '6870',
				),
			),
			array(
				'name'         => 'India (भारत)',
				'alphacode'    => 'in',
				'countryCode'  => '+91',
				'whatsappcost' => array(
					'100'   => '3',
					'500'   => '8',
					'1000'  => '14',
					'5000'  => '53',
					'10000' => '96',
					'50000' => '375',
				),
			),
			array(
				'name'         => 'Indonesia',
				'alphacode'    => 'id',
				'countryCode'  => '+62',
				'whatsappcost' => array(
					'100'   => '4',
					'500'   => '16',
					'1000'  => '32',
					'5000'  => '160',
					'10000' => '318',
					'50000' => '1582',
				),
			),
			array(
				'name'         => 'Israel (‫ישראל‬‎)',
				'alphacode'    => 'il',
				'countryCode'  => '+972',
				'whatsappcost' => array(
					'100'   => '5',
					'500'   => '20',
					'1000'  => '37',
					'5000'  => '170',
					'10000' => '330',
					'50000' => '1545',
				),
			),
			array(
				'name'         => 'Italy (Italia)',
				'alphacode'    => 'it',
				'countryCode'  => '+39',
				'whatsappcost' => array(
					'100'   => '8',
					'500'   => '37',
					'1000'  => '71',
					'5000'  => '342',
					'10000' => '673',
					'50000' => '3260',
				),
			),
			array(
				'name'         => 'Kazakhstan (Казахстан)',
				'alphacode'    => 'kz',
				'countryCode'  => '+7',
				'whatsappcost' => array(
					'100'   => '8',
					'500'   => '38',
					'1000'  => '75',
					'5000'  => '373',
					'10000' => '746',
					'50000' => '3728',
				),
			),
			array(
				'name'         => 'Malaysia',
				'alphacode'    => 'my',
				'countryCode'  => '+60',
				'whatsappcost' => array(
					'100'   => '10',
					'500'   => '45',
					'1000'  => '78',
					'5000'  => '375',
					'10000' => '746',
					'50000' => '3720',
				),
			),
			array(
				'name'         => 'Mexico (México)',
				'alphacode'    => 'mx',
				'countryCode'  => '+52',
				'whatsappcost' => array(
					'100'   => '5',
					'500'   => '22',
					'1000'  => '42',
					'5000'  => '195',
					'10000' => '379',
					'50000' => '1790',
				),
			),
			array(
				'name'         => 'Netherlands (Nederland)',
				'alphacode'    => 'nl',
				'countryCode'  => '+31',
				'whatsappcost' => array(
					'100'   => '17',
					'500'   => '79',
					'1000'  => '156',
					'5000'  => '763',
					'10000' => '1515',
					'50000' => '7470',
				),
			),
			array(
				'name'         => 'Nigeria',
				'alphacode'    => 'ng',
				'countryCode'  => '+234',
				'whatsappcost' => array(
					'100'   => '7',
					'500'   => '30',
					'1000'  => '59',
					'5000'  => '278',
					'10000' => '546',
					'50000' => '2625',
				),
			),
			array(
				'name'         => 'Pakistan (‫پاکستان‬‎)',
				'alphacode'    => 'pk',
				'countryCode'  => '+92',
				'whatsappcost' => array(
					'100'   => '7',
					'500'   => '28',
					'1000'  => '54',
					'5000'  => '257',
					'10000' => '503',
					'50000' => '2410',
				),
			),
			array(
				'name'         => 'Peru (Perú)',
				'alphacode'    => 'pe',
				'countryCode'  => '+51',
				'whatsappcost' => array(
					'100'   => '8',
					'500'   => '34',
					'1000'  => '67',
					'5000'  => '319',
					'10000' => '628',
					'50000' => '3035',
				),
			),
			array(
				'name'         => 'Russia (Россия)',
				'alphacode'    => 'ru',
				'countryCode'  => '+7',
				'whatsappcost' => array(
					'100'   => '9',
					'500'   => '38',
					'1000'  => '73',
					'5000'  => '352',
					'10000' => '693',
					'50000' => '3360',
				),
			),
			array(
				'name'         => 'Saudi Arabia (‫المملكة العربية السعودية‬‎)',
				'alphacode'    => 'sa',
				'countryCode'  => '+966',
				'whatsappcost' => array(
					'100'   => '5',
					'500'   => '21',
					'1000'  => '40',
					'5000'  => '183',
					'10000' => '355',
					'50000' => '1670',
				),
			),
			array(
				'name'         => 'South Africa',
				'alphacode'    => 'za',
				'countryCode'  => '+27',
				'whatsappcost' => array(
					'100'   => '5',
					'500'   => '19',
					'1000'  => '35',
					'5000'  => '160',
					'10000' => '310',
					'50000' => '1445',
				),
			),
			array(
				'name'         => 'Spain (España)',
				'alphacode'    => 'es',
				'countryCode'  => '+34',
				'whatsappcost' => array(
					'100'   => '8',
					'500'   => '35',
					'1000'  => '69',
					'5000'  => '328',
					'10000' => '645',
					'50000' => '3120',
				),
			),
			array(
				'name'         => 'Turkey (Türkiye)',
				'alphacode'    => 'tr',
				'countryCode'  => '+90',
				'whatsappcost' => array(
					'100'   => '3',
					'500'   => '10',
					'1000'  => '17',
					'5000'  => '70',
					'10000' => '130',
					'50000' => '545',
				),
			),
			array(
				'name'         => 'United Arab Emirates (‫الإمارات العربية المتحدة‬‎)',
				'alphacode'    => 'ae',
				'countryCode'  => '+971',
				'whatsappcost' => array(
					'100'   => '5',
					'500'   => '20',
					'1000'  => '39',
					'5000'  => '178',
					'10000' => '346',
					'50000' => '1625',
				),
			),
			array(
				'name'         => 'United Kingdom',
				'alphacode'    => 'gb',
				'countryCode'  => '+44',
				'whatsappcost' => array(
					'100'   => '9',
					'500'   => '40',
					'1000'  => '70',
					'5000'  => '340',
					'10000' => '660',
					'50000' => '3275',
				),
			),
		);

		/**
		 * Function for selected countries.
		 *
		 * @return array
		 */
		public static function get_only_country_list() {
			$country_list = array();
			foreach ( self::$countries as $country ) {
				if ( $country['name'] ) {
					array_push( $country_list, $country['name'] );
				}
			}
			return $country_list;
		}

		/**
		 * Function to check the whatsapp pricing for the target country.
		 *
		 * @param string $target_country - target country.
		 * @return array
		 */
		public static function check_transaction_cost( $target_country ) {
			foreach ( self::$countries as $country ) {
				if ( $country['name'] === $target_country ) {
					return $country['whatsappcost'];
				}
			}
			return array();
		}
	}
}
