/*!
MTWaypoints (no framework) - 4.0.1
Copyright © 2011-2016 Caleb Troughton
Licensed under the MIT license.
https://github.com/imakewebthings/waypoints/blob/master/licenses.txt
*/
!function(){"use strict";var t=0,e={};function n(i){if(!i)throw new Error("No options passed to MTWaypoint constructor");if(!i.element)throw new Error("No element option passed to MTWaypoint constructor");if(!i.handler)throw new Error("No handler option passed to MTWaypoint constructor");this.key="waypoint-"+t,this.options=n.Adapter.extend({},n.defaults,i),this.element=this.options.element,this.adapter=new n.Adapter(this.element),this.callback=i.handler,this.axis=this.options.horizontal?"horizontal":"vertical",this.enabled=this.options.enabled,this.triggerPoint=null,this.group=n.Group.findOrCreate({name:this.options.group,axis:this.axis}),this.context=n.Context.findOrCreateByElement(this.options.context),n.offsetAliases[this.options.offset]&&(this.options.offset=n.offsetAliases[this.options.offset]),this.group.add(this),this.context.add(this),e[this.key]=this,t+=1}n.prototype.queueTrigger=function(t){this.group.queueTrigger(this,t)},n.prototype.trigger=function(t){this.enabled&&this.callback&&this.callback.apply(this,t)},n.prototype.destroy=function(){this.context.remove(this),this.group.remove(this),delete e[this.key]},n.prototype.disable=function(){return this.enabled=!1,this},n.prototype.enable=function(){return this.context.refresh(),this.enabled=!0,this},n.prototype.next=function(){return this.group.next(this)},n.prototype.previous=function(){return this.group.previous(this)},n.invokeAll=function(t){var n=[];for(var i in e)n.push(e[i]);for(var o=0,r=n.length;o<r;o++)n[o][t]()},n.destroyAll=function(){n.invokeAll("destroy")},n.disableAll=function(){n.invokeAll("disable")},n.enableAll=function(){for(var t in n.Context.refreshAll(),e)e[t].enabled=!0;return this},n.refreshAll=function(){n.Context.refreshAll()},n.viewportHeight=function(){return window.innerHeight||document.documentElement.clientHeight},n.viewportWidth=function(){return document.documentElement.clientWidth},n.adapters=[],n.defaults={context:window,continuous:!0,enabled:!0,group:"default",horizontal:!1,offset:0},n.offsetAliases={"bottom-in-view":function(){return this.context.innerHeight()-this.adapter.outerHeight()},"right-in-view":function(){return this.context.innerWidth()-this.adapter.outerWidth()}},window.MTWaypoint=n}(),function(){"use strict";function t(t){window.setTimeout(t,1e3/60)}var e=0,n={},i=window.MTWaypoint,o=window.onload;function r(t){this.element=t,this.Adapter=i.Adapter,this.adapter=new this.Adapter(t),this.key="waypoint-context-"+e,this.didScroll=!1,this.didResize=!1,this.oldScroll={x:this.adapter.scrollLeft(),y:this.adapter.scrollTop()},this.waypoints={vertical:{},horizontal:{}},t.waypointContextKey=this.key,n[t.waypointContextKey]=this,e+=1,i.windowContext||(i.windowContext=!0,i.windowContext=new r(window)),this.createThrottledScrollHandler(),this.createThrottledResizeHandler()}r.prototype.add=function(t){var e=t.options.horizontal?"horizontal":"vertical";this.waypoints[e][t.key]=t,this.refresh()},r.prototype.checkEmpty=function(){var t=this.Adapter.isEmptyObject(this.waypoints.horizontal),e=this.Adapter.isEmptyObject(this.waypoints.vertical),i=this.element==this.element.window;t&&e&&!i&&(this.adapter.off(".waypoints"),delete n[this.key])},r.prototype.createThrottledResizeHandler=function(){var t=this;function e(){t.handleResize(),t.didResize=!1}this.adapter.on("resize.waypoints",(function(){t.didResize||(t.didResize=!0,i.requestAnimationFrame(e))}))},r.prototype.createThrottledScrollHandler=function(){var t=this;function e(){t.handleScroll(),t.didScroll=!1}this.adapter.on("scroll.waypoints",(function(){t.didScroll&&!i.isTouch||(t.didScroll=!0,i.requestAnimationFrame(e))}))},r.prototype.handleResize=function(){i.Context.refreshAll()},r.prototype.handleScroll=function(){var t={},e={horizontal:{newScroll:this.adapter.scrollLeft(),oldScroll:this.oldScroll.x,forward:"right",backward:"left"},vertical:{newScroll:this.adapter.scrollTop(),oldScroll:this.oldScroll.y,forward:"down",backward:"up"}};for(var n in e){var i=e[n],o=i.newScroll>i.oldScroll?i.forward:i.backward;for(var r in this.waypoints[n]){var s=this.waypoints[n][r];if(null!==s.triggerPoint){var a=i.oldScroll<s.triggerPoint,l=i.newScroll>=s.triggerPoint;(a&&l||!a&&!l)&&(s.queueTrigger(o),t[s.group.id]=s.group)}}}for(var h in t)t[h].flushTriggers();this.oldScroll={x:e.horizontal.newScroll,y:e.vertical.newScroll}},r.prototype.innerHeight=function(){return this.element==this.element.window?i.viewportHeight():this.adapter.innerHeight()},r.prototype.remove=function(t){delete this.waypoints[t.axis][t.key],this.checkEmpty()},r.prototype.innerWidth=function(){return this.element==this.element.window?i.viewportWidth():this.adapter.innerWidth()},r.prototype.destroy=function(){var t=[];for(var e in this.waypoints)for(var n in this.waypoints[e])t.push(this.waypoints[e][n]);for(var i=0,o=t.length;i<o;i++)t[i].destroy()},r.prototype.refresh=function(){var t,e=this.element==this.element.window,n=e?void 0:this.adapter.offset(),o={};for(var r in this.handleScroll(),t={horizontal:{contextOffset:e?0:n.left,contextScroll:e?0:this.oldScroll.x,contextDimension:this.innerWidth(),oldScroll:this.oldScroll.x,forward:"right",backward:"left",offsetProp:"left"},vertical:{contextOffset:e?0:n.top,contextScroll:e?0:this.oldScroll.y,contextDimension:this.innerHeight(),oldScroll:this.oldScroll.y,forward:"down",backward:"up",offsetProp:"top"}}){var s=t[r];for(var a in this.waypoints[r]){var l,h,c,p,u=this.waypoints[r][a],d=u.options.offset,f=u.triggerPoint,w=0,v=null==f;u.element!==u.element.window&&(w=u.adapter.offset()[s.offsetProp]),"function"==typeof d?d=d.apply(u):"string"==typeof d&&(d=parseFloat(d),u.options.offset.indexOf("%")>-1&&(d=Math.ceil(s.contextDimension*d/100))),l=s.contextScroll-s.contextOffset,u.triggerPoint=Math.floor(w+l-d),h=f<s.oldScroll,c=u.triggerPoint>=s.oldScroll,p=!h&&!c,!v&&(h&&c)?(u.queueTrigger(s.backward),o[u.group.id]=u.group):(!v&&p||v&&s.oldScroll>=u.triggerPoint)&&(u.queueTrigger(s.forward),o[u.group.id]=u.group)}}return i.requestAnimationFrame((function(){for(var t in o)o[t].flushTriggers()})),this},r.findOrCreateByElement=function(t){return r.findByElement(t)||new r(t)},r.refreshAll=function(){for(var t in n)n[t].refresh()},r.findByElement=function(t){return n[t.waypointContextKey]},window.onload=function(){o&&o(),r.refreshAll()},i.requestAnimationFrame=function(e){(window.requestAnimationFrame||window.mozRequestAnimationFrame||window.webkitRequestAnimationFrame||t).call(window,e)},i.Context=r}(),function(){"use strict";function t(t,e){return t.triggerPoint-e.triggerPoint}function e(t,e){return e.triggerPoint-t.triggerPoint}var n={vertical:{},horizontal:{}},i=window.MTWaypoint;function o(t){this.name=t.name,this.axis=t.axis,this.id=this.name+"-"+this.axis,this.waypoints=[],this.clearTriggerQueues(),n[this.axis][this.name]=this}o.prototype.add=function(t){this.waypoints.push(t)},o.prototype.clearTriggerQueues=function(){this.triggerQueues={up:[],down:[],left:[],right:[]}},o.prototype.flushTriggers=function(){for(var n in this.triggerQueues){var i=this.triggerQueues[n],o="up"===n||"left"===n;i.sort(o?e:t);for(var r=0,s=i.length;r<s;r+=1){var a=i[r];(a.options.continuous||r===i.length-1)&&a.trigger([n])}}this.clearTriggerQueues()},o.prototype.next=function(e){this.waypoints.sort(t);var n=i.Adapter.inArray(e,this.waypoints);return n===this.waypoints.length-1?null:this.waypoints[n+1]},o.prototype.previous=function(e){this.waypoints.sort(t);var n=i.Adapter.inArray(e,this.waypoints);return n?this.waypoints[n-1]:null},o.prototype.queueTrigger=function(t,e){this.triggerQueues[e].push(t)},o.prototype.remove=function(t){var e=i.Adapter.inArray(t,this.waypoints);e>-1&&this.waypoints.splice(e,1)},o.prototype.first=function(){return this.waypoints[0]},o.prototype.last=function(){return this.waypoints[this.waypoints.length-1]},o.findOrCreate=function(t){return n[t.axis][t.name]||new o(t)},i.Group=o}(),function(){"use strict";var t=window.MTWaypoint;function e(t){return t===t.window}function n(t){return e(t)?t:t.defaultView}function i(t){this.element=t,this.handlers={}}i.prototype.innerHeight=function(){return e(this.element)?this.element.innerHeight:this.element.clientHeight},i.prototype.innerWidth=function(){return e(this.element)?this.element.innerWidth:this.element.clientWidth},i.prototype.off=function(t,e){function n(t,e,n){for(var i=0,o=e.length-1;i<o;i++){var r=e[i];n&&n!==r||t.removeEventListener(r)}}var i=t.split("."),o=i[0],r=i[1],s=this.element;if(r&&this.handlers[r]&&o)n(s,this.handlers[r][o],e),this.handlers[r][o]=[];else if(o)for(var a in this.handlers)n(s,this.handlers[a][o]||[],e),this.handlers[a][o]=[];else if(r&&this.handlers[r]){for(var l in this.handlers[r])n(s,this.handlers[r][l],e);this.handlers[r]={}}},i.prototype.offset=function(){if(!this.element.ownerDocument)return null;var t=this.element.ownerDocument.documentElement,e=n(this.element.ownerDocument),i={top:0,left:0};return this.element.getBoundingClientRect&&(i=this.element.getBoundingClientRect()),null===e&&(e=window),{top:i.top+e.pageYOffset-t.clientTop,left:i.left+e.pageXOffset-t.clientLeft}},i.prototype.on=function(t,e){var n=t.split("."),i=n[0],o=n[1]||"__default",r=this.handlers[o]=this.handlers[o]||{};(r[i]=r[i]||[]).push(e),this.element.addEventListener(i,e)},i.prototype.outerHeight=function(t){var n,i=this.innerHeight();return t&&!e(this.element)&&(n=window.getComputedStyle(this.element),i+=parseInt(n.marginTop,10),i+=parseInt(n.marginBottom,10)),i},i.prototype.outerWidth=function(t){var n,i=this.innerWidth();return t&&!e(this.element)&&(n=window.getComputedStyle(this.element),i+=parseInt(n.marginLeft,10),i+=parseInt(n.marginRight,10)),i},i.prototype.scrollLeft=function(){var t=n(this.element);return t?t.pageXOffset:this.element.scrollLeft},i.prototype.scrollTop=function(){var t=n(this.element);return t?t.pageYOffset:this.element.scrollTop},i.extend=function(){var t=Array.prototype.slice.call(arguments);function e(t,e){if("object"==typeof t&&"object"==typeof e)for(var n in e)e.hasOwnProperty(n)&&(t[n]=e[n]);return t}for(var n=1,i=t.length;n<i;n++)e(t[0],t[n]);return t[0]},i.inArray=function(t,e,n){return null==e?-1:e.indexOf(t,n)},i.isEmptyObject=function(t){for(var e in t)return!1;return!0},t.adapters.push({name:"noframework",Adapter:i}),t.Adapter=i}(),function(){"use strict";function t(){}var e=window.MTWaypoint;function n(t){this.options=e.Adapter.extend({},n.defaults,t),this.axis=this.options.horizontal?"horizontal":"vertical",this.waypoints=[],this.element=this.options.element,this.createMTWaypoints()}n.prototype.createMTWaypoints=function(){for(var t={vertical:[{down:"enter",up:"exited",offset:"100%"},{down:"entered",up:"exit",offset:"bottom-in-view"},{down:"exit",up:"entered",offset:0},{down:"exited",up:"enter",offset:function(){return-this.adapter.outerHeight()}}],horizontal:[{right:"enter",left:"exited",offset:"100%"},{right:"entered",left:"exit",offset:"right-in-view"},{right:"exit",left:"entered",offset:0},{right:"exited",left:"enter",offset:function(){return-this.adapter.outerWidth()}}]},e=0,n=t[this.axis].length;e<n;e++){var i=t[this.axis][e];this.createMTWaypoint(i)}},n.prototype.createMTWaypoint=function(t){var n=this;this.waypoints.push(new e({context:this.options.context,element:this.options.element,enabled:this.options.enabled,handler:function(t){return function(e){n.options[t[e]].call(n,e)}}(t),offset:t.offset,horizontal:this.options.horizontal}))},n.prototype.destroy=function(){for(var t=0,e=this.waypoints.length;t<e;t++)this.waypoints[t].destroy();this.waypoints=[]},n.prototype.disable=function(){for(var t=0,e=this.waypoints.length;t<e;t++)this.waypoints[t].disable()},n.prototype.enable=function(){for(var t=0,e=this.waypoints.length;t<e;t++)this.waypoints[t].enable()},n.defaults={context:window,enabled:!0,enter:t,entered:t,exit:t,exited:t},e.Inview=n}(),jQuery(document).ready((function(t){var e=function(){var e=!1;window.top.TvrMT?e=window.top:window.parent.TvrMT?e=window.parent:window.parent.parent&&window.parent.parent.TvrMT&&(e=window.parent.parent);e&&e.TvrMT;var n={click:!1,inview:!1,inview_once:!1,mouseenter:!1,focus:!1},i={isInsideMT:e,data:{},boundEls:t.extend({},!0,n),targetEls:t.extend({},!0,n),customEvents:[],eventClasses:[],isTargetingMode:function(){return i.isInsideMT},mediaMatches:function(t){return window.matchMedia(t).matches},isDomEl:function(t){return t&&t.prop&&t.prop("tagName")},jquery_compat:function(e){try{return t(e)}catch(t){return!1}},resolve_active_target:function(t,e,n){if(t.target){if(t.relative_dom){for(var o=0;o<t.relative_dom.length;o++){var r=t.relative_dom[o];switch(r.directive){case"parent":e=e.parent(r.selector);break;case"parents":e=e.parents(r.selector);break;case"closest":e=e.closest(r.selector);break;case"children":e=e.children(r.selector);break;case"find":e=e.find(r.selector);break;case"next":e=e.next(r.selector);break;case"prev":e=e.prev(r.selector);break;case"siblings":e=e.siblings(r.selector)}}return i.isDomEl(e)?(i.update_cached_els("targetEls",t.event,e),e):n}return n}return e},update_cached_els:function(e,n,o){i[e][n]?i[e][n]=t(i[e][n]).add(o):i[e][n]=o},apply_effect:function(t){if(!t.eventObj.mq||window.matchMedia(t.eventObj.mq).matches){var e=i.resolve_active_target(t.eventObj,t.$el,t.$target_els);if(e.hasClass(t.evt_class)&&(e.removeClass(t.evt_class),"transition"===t.eventObj.type))return!1;if(window.requestAnimationFrame((function(n){window.requestAnimationFrame((function(n){e.addClass(t.evt_class)}))})),i.after_animation(e,{type:t.eventObj.type,args:[t],cb:function(t){"inview_once"==t.event&&t.waypoint.destroy()}}),"transition"===t.eventObj.type){var n=!1;switch(t.event){case"mouseenter":n="mouseleave";break;case"focus":n="blur"}n&&t.$el.on(n,null,t,(function(n){e.removeClass(t.evt_class)}))}}},after_animation:function(t,e){var n="transition"===e.type?"transitionend.tvr webkitTransitionEnd.tvr oTransitionEnd.tvr otransitionend.tvr MSTransitionEnd.tvr":"oanimationend.tvr animationend.tvr webkitAnimationEnd.tvr";t.on(n,(function(){e.cb.apply(this,e.args),t.off(n)}))},refresh_event_binding:function(){if(window.MT_Events_Data&&MT_Events_Data===Object(MT_Events_Data)){MTWaypoint.destroyAll();var e=t(),o=i.customEvents.join(" ");for(var r in i.boundEls)if(i.boundEls.hasOwnProperty(r)){var s=i.boundEls[r],a=i.targetEls[r];s&&"inview"!==r&&"inview_once"!==r&&s.off(o),a&&(e=e.add(a))}e.removeClass(i.eventClasses.join(" ")),i.boundEls=t.extend({},!0,n),i.targetEls=t.extend({},!0,n);var l=MT_Events_Data;for(var h in l)if(l.hasOwnProperty(h))for(var c=l[h],p=0;p<c.length;p++){var u=c[p],d=i.jquery_compat(u.code),f=(a=u.target?i.jquery_compat(u.target):d,"focus"===h?"mt-js_"+h:"mt-"+h),w=h+".tvr-"+u.mqKey;i.update_cached_els("boundEls",h,d),u.relative_dom||i.update_cached_els("targetEls",h,a),t.inArray(f,i.eventClasses)<0&&i.eventClasses.push(f),"inview"!==h&&"inview_once"!==h&&t.inArray(w,i.customEvents)<0&&i.customEvents.push(w),d&&d.each((function(e){var n=t(this),o=n[0],r={$el:n,$target_els:a,event:h,evt_class:f,custom_event:w,eventObj:u};switch(h){case"click":case"mouseenter":case"focus":n.on(w,null,r,(function(t){"click"===r.event&&i.isTargetingMode()||t.stopPropagation(),i.apply_effect(r)}));break;case"inview":case"inview_once":new MTWaypoint.Inview({element:o,group:h,enabled:!1,mt:r,enter:function(t){this.options.mt.waypoint=this,i.apply_effect(this.options.mt)},exit:function(t){var e=this.options.mt;"transition"===e.eventObj.type&&"inview_once"!==e.event&&i.resolve_active_target(e.eventObj,e.$el,e.$target_els).removeClass(e.evt_class)}}).enable()}}))}}}};return i}();e.refresh_event_binding(),window.MT_Events_Manager=e}));