<?php
/**
 * Update page content.
 *
 * @package MelapressLoginSecurity
 * @since 2.0.0
 */

declare(strict_types=1);

// Exit if accessed directly.
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

?>

<div class="wrap features-wrap">
	<div class="c4wp-upgrade-section">
		
		<div class="content-block">
			<div class="logo-wrap">
				<img src="<?php echo esc_url( MLS_PLUGIN_URL . 'assets/images/password-policy-manager.png' ); ?>" alt="">
			</div>
			<p><?php esc_html_e( 'The security of your WordPress website & WooCommerce store is as strong as the weakest password!', 'c4wp-wpp' ); ?></p>
			<p><?php esc_html_e( 'Weak passwords should not jeopardize the security of your website. Configure strong password policies with Melapress Login Security and ensure your team, customers & subscribers use strong passwords.', 'c4wp-wpp' ); ?></p>
			<div class="premium-cta">
			<a href="https://melapress.com/wordpress-login-security/pricing/?utm_source=plugins&utm_medium=link&utm_campaign=mls" target="_blank" rel="noopener">Upgrade to Premium</a>
			</div>
		</div>

		<div class="content-block">
			<table class="c21 feature-table">
				<tbody>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10 c4"><span class="c5"></span></p>
						</td>
						<td class="c8 row-head" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><?php esc_html_e( 'Premium', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c12 row-head" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><?php esc_html_e( 'Free', 'melapress-login-security' ); ?></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Email support and forum access', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'We stand behind all of our products with world-class support and a team of professionals who absolutely care.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Enforce Strong Passwords', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Easily enable password policies and enforce the use of strong passwords on your WordPress websites within seconds!', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Configurable Password Policies', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'All the password policies are configurable. You can configure policies for password length, history, complexity, use of special characters and many others.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Password Policies per User Role', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Configure different password policies for different user roles, including custom ones. You can also exclude a specific user, or user role from all the policies.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Multisite Network Compatible', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Enforce strong password policies at network level so no user jeopardizes the security of your multisite network.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>


					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Hide the WordPress login page', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Change the URL of your WordPress login page so it is not accessible to malicious attackers.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>

					
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( '1-Click Reset All Passwords', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Reset all passwords and terminate all logged in session with 1-click in case of suspicious activity. When you use this feature, all users will receive clear instructions on how to reset their passwords.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>

					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Limit Failed Login Attempts', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Automatically block users with too many failed login attempts to protect your website & users from successful password and dictionary attacks.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
					</tr>

					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Restrict user logins by IP Addresses', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Allow / limit a user\'s login to an IP address or a number of IP addresses. All the IP addresses and such limitations can be configured for every individual user, allowing you to restrict account sharing but at the same time giving the users the flexibility they need.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'WooCommerce & Third Party Plugins Ready', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Do you use WooCommerce for your eCommerce website? Do you use LearnDash, MemberPress and other popular plugins for Membership and business websites? Enforce login security policies on forms from these plugins with just a mouse click.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>

					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Limit login page traffic by country', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Use Geoblocking to restrict access to the WordPress login page to certain countries only, or to block traffic originating from certain countries.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					

					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Restrict user login times', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Restrict your users\' login times to specific days and hours and enforce your working hours policy, improve website and user account security, and reduce your website\'s attack surface.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Automatically Lock Inactive Users', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Inactive users are an easy prime target for malicious hackers. Our plugin automatically identifies & locks inactive users to help you protect your website. It also alerts you about them.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Get alerted of unrecognized devices', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Keep WordPress users\' accounts secure by by sending them an immediate email alert if they log in from a new browser / device, allowing them to remotely terminate the session and notify the website administrator.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>


					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Add security questions', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Prevent unauthorized user account changes usch as password resets or when unlocking a user account by requiring users to answer preconfigured security questions.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>


					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Editable email templates & notifications', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Take control of all the emails and user notifications - edit their content with our easy to use settings so all messages fit your business\' branding.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>

					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Users activity & passwords reports', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Use the reports to easily see the last time users were active, their password age and whose password is expired.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>

					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Weekly summary email', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Get a weekly email with a detailed summary of all password resets and changes, inactivity lockouts, failed logins, and more.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>

					<tr class="c2">
						<td class="c6" colspan="1" rowspan="1">
							<p class="c10"><span class="c5"><strong><?php esc_html_e( 'Bulk user import', 'melapress-login-security' ); ?></strong><?php esc_html_e( 'Use the plugin\'s Users import feature to import a list of users via a CSV file. You can also require all imported users to change their password on their first login.', 'melapress-login-security' ); ?></span></p>
						</td>
						<td class="c8" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-saved"></span></span></p>
						</td>
						<td class="c12" colspan="1" rowspan="1">
							<p class="c7"><span class="c5"><span class="dashicons dashicons-no"></span></span></p>
						</td>
					</tr>
				</tbody>
			</table>
		</div>

		<div class="premium-cta">
			<a href="https://melapress.com/wordpress-login-security/pricing/?utm_source=plugins&utm_medium=link&utm_campaign=mls" target="_blank" rel="noopener"><?php esc_html_e( 'Upgrade to Premium', 'melapress-login-security' ); ?></a>
		</div>

	</div>
</div>

<style type="text/css">
	#postbox-container-1 {
		display: none;
	}
	.features-wrap {
		background: #fff;
		padding: 25px 30px;
		max-width: 880px;
	}

	.features-wrap h2 {
		font-size: 28px;
			margin-bottom: 30px;
	}

	.features-wrap p {
		font-size: 14px;
		line-height: 28px;
		font-weight: normal;
	}

	.feature-list {
		margin-bottom: 20px;
	}

	.feature-list li {
		margin-bottom: 10px;
		font-size: 15px;
	}

	.feature-list li .dashicons {
		color:  #ff8977
	}

	.premium-cta {
		margin: 25px 0 15px;
		text-align: center;
	}

	.premium-cta .text-link {
		color:  #ff8977;
		background: transparent;
		border:  #ff8977;
		text-decoration: dashed;
	}

	.premium-cta a, .table-link {
		background-color:  #ff8977;
		color: #fff;
		padding: 15px 26px;
		border-radius: 30px;
		font-size: 16px;
		white-space: nowrap;
		text-decoration: none;
		font-weight: 700;
		display: inline-block;
		margin-right: 15px;
		border: 2px solid  #ff8977
	}

	.premium-cta a:hover, .table-link:hover, .premium-cta a.inverse, .table-link.inverse {
		color:  #ff8977;
		background-color: #fff;
	}

	.premium-cta a.inverse:hover {
		color: #fff;
		background-color:  #ff8977;
	}

	.content-block {
		margin-bottom: 26px;
		border-bottom: 1px solid #eee;
		padding-bottom: 15px;
		overflow: hidden;
	}

	.feature-table strong {
		font-size: 16px;
		clear: both;
		display: block;
	}
	
	.feature-table tr td {
		text-align: center;
		min-width: 200px
	}
	.feature-table tr td:first-of-type {
		text-align: left;
		font-weight: 500;
	}
	.feature-table td p {
		margin-top: 0;
	}
	.row-head span {
		font-size: 17px;
		font-weight: 700;
	}
	.feature-table .dashicons {
		color: #50284E;
	}
	.feature-table .dashicons-no {
		color: red;
	}
	.table-link {
		font-size: 14px;
		padding: 9px;
		width: 193px;
		margin-top: 10px;
	}
	.pull-up {
		position: relative;
		top: -23px;
	}

	.logo-wrap img {
		max-width: 230px;
		margin-top: 20px;
	}

	.logo-wrap {
		float: left;
		margin-right: 30px;
	}

</style>
