<?php

declare(strict_types=1);

use Isolated\Symfony\Component\Finder\Finder;

return [
	// The prefix configuration. If a non null value will be used, a random prefix will be generated.
	"prefix" => "Mediavine\\Create",

	// By default when running php-scoper add-prefix, it will prefix all relevant code found in the current working
	// directory. You can however define which files should be scoped by defining a collection of Finders in the
	// following configuration key.
	//
	// For more see: https://github.com/humbug/php-scoper#finders-and-paths
	"finders" => [
		Finder::create()
			->files()
			->ignoreVCS(true)
			->notName(
				"/LICENSE|.*\\.md|.*\\.dist|Makefile|composer\\.json|composer\\.lock/"
			)
			->exclude([
				"doc",
				"test",
				"test_old",
				"tests",
				"Tests",
				"vendor-bin",
			])
			->in("vendor/guzzlehttp")
			->in("vendor/ralouphie")
			->in("vendor/mediavine/paapi5-php-sdk")
			->in("vendor/psr")
			->name("*.php"),
	],

	// When scoping PHP files, there will be scenarios where some of the code being scoped indirectly references the
	// original namespace. These will include, for example, strings or string manipulations. PHP-Scoper has limited
	// support for prefixing such strings. To circumvent that, you can define patchers to manipulate the file to your
	// heart contents.
	//
	// For more see: https://github.com/humbug/php-scoper#patchers
	"patchers" => [
		function (string $filePath, string $prefix, string $content) {
			if (
				false !== strpos($filePath, "vendor/mediavine/paapi5-php-sdk/")
			) {
				$prefix = str_replace("\\", "\\\\\\\\", $prefix);
				$content = preg_replace(
					'/\'\\\\\\\\Amazon\\\\/m',
					'\'' . $prefix . "\\\\\\\\Amazon\\\\",
					$content
				);
			}

			if (strpos($filePath, 'vendor/mediavine/paapi5-php-sdk/src/com/amazon/paapi5/v1/GetItemsRequest.php') !== false) {
				$content = preg_replace(
					'/public function offsetExists\([^)]*\)/',
					'#[\ReturnTypeWillChange]' . PHP_EOL . '    public function offsetExists($offset)',
					$content
				);
				$content = preg_replace(
					'/public function offsetGet\([^)]*\)/',
					'#[\ReturnTypeWillChange]' . PHP_EOL . '    public function offsetGet($offset)',
					$content
				);
				$content = preg_replace(
					'/public function offsetSet\([^)]*\)/',
					'#[\ReturnTypeWillChange]' . PHP_EOL . '    public function offsetSet($offset, $value)',
					$content
				);
				$content = preg_replace(
					'/public function offsetUnset\([^)]*\)/',
					'#[\ReturnTypeWillChange]' . PHP_EOL . '    public function offsetUnset($offset)',
					$content
				);
			}

			return $content;
		},
	],

	// PHP-Scoper's goal is to make sure that all code for a project lies in a distinct PHP namespace. However, you
	// may want to share a common API between the bundled code of your PHAR and the consumer code. For example if
	// you have a PHPUnit PHAR with isolated code, you still want the PHAR to be able to understand the
	// PHPUnit\Framework\TestCase class.
	//
	// A way to achieve this is by specifying a list of classes to not prefix with the following configuration key. Note
	// that this does not work with functions or constants neither with classes belonging to the global namespace.
	//
	// Fore more see https://github.com/humbug/php-scoper#whitelist
	"whitelist" => [
		"WP*",
		"Mediavine\*",
		"\WP_REST_Response",
		"wp\*",
		"\WP*", // Everything
	],
];
