<?php

/**
 * Matomo - free/libre analytics platform
 *
 * @link    https://matomo.org
 * @license https://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */
namespace Piwik\Plugins\UserCountry\Reports;

use Piwik\Piwik;
use Piwik\Plugin\ViewDataTable;
use Piwik\Plugins\UserCountry\Columns\Country;
use Piwik\Plugins\UserCountry\LocationProvider;
use Piwik\Url;
class GetCountry extends \Piwik\Plugins\UserCountry\Reports\Base
{
    protected function init()
    {
        parent::init();
        $this->dimension = new Country();
        $this->name = Piwik::translate('UserCountry_Country');
        $this->documentation = Piwik::translate('UserCountry_getCountryDocumentation');
        $this->order = 5;
    }
    public function configureView(ViewDataTable $view)
    {
        $view->config->show_exclude_low_population = \false;
        $view->config->documentation = $this->documentation;
        $view->requestConfig->filter_limit = 5;
        if (LocationProvider::getCurrentProviderId() == LocationProvider\DefaultProvider::ID) {
            // if we're using the default location provider, add a note explaining how it works
            $footerMessage = Piwik::translate("General_Note") . ': ' . Piwik::translate('UserCountry_DefaultLocationProviderExplanation', [Url::getExternalLinkTag('https://matomo.org/docs/geo-locate/'), '</a>']);
            $view->config->show_footer_message = $footerMessage;
        }
    }
}
