<?php

/**
 * Matomo - free/libre analytics platform
 *
 * @link    https://matomo.org
 * @license https://www.gnu.org/licenses/gpl-3.0.html GPL v3 or later
 */
namespace Piwik\Plugins\Goals\Columns\Metrics\GoalSpecific;

use Piwik\Archive\DataTableFactory;
use Piwik\Columns\Dimension;
use Piwik\DataTable;
use Piwik\DataTable\Row;
use Piwik\Metrics;
use Piwik\Metrics\Formatter;
use Piwik\Piwik;
use Piwik\Plugins\Goals\Columns\Metrics\GoalSpecificProcessedMetric;
use Piwik\Plugins\Goals\Goals;
/**
 * Attributed Revenue for a specific goal.
 */
class RevenueEntry extends GoalSpecificProcessedMetric
{
    public function getName()
    {
        return Goals::makeGoalColumn($this->idGoal, 'revenue_entry', \false);
    }
    public function getTranslatedName()
    {
        return Piwik::translate(Piwik::translate('Goals_NRevenue'), $this->getGoalName());
    }
    public function getDocumentation()
    {
        return Piwik::translate('Goals_ColumnRevenueAttributedDocumentation', $this->getGoalNameForDocs());
    }
    public function getDependentMetrics()
    {
        return ['goals'];
    }
    public function compute(Row $row)
    {
        $mappingFromNameToIdGoal = Metrics::getMappingFromNameToIdGoal();
        $goalMetrics = $this->getGoalMetrics($row);
        return (float) $this->getMetric($goalMetrics, 'revenue_entry', $mappingFromNameToIdGoal);
    }
    public function format($value, Formatter $formatter)
    {
        return $formatter->getPrettyMoney($value, $this->idSite);
    }
    public function beforeFormat($report, DataTable $table)
    {
        $this->idSite = DataTableFactory::getSiteIdFromMetadata($table);
        return !empty($this->idSite);
        // skip formatting if there is no site to get currency info from
    }
    public function getSemanticType() : ?string
    {
        return Dimension::TYPE_MONEY;
    }
}
