<?php
/**
 * @var $last_quiz
 * @var $passing_grade
 */

if ( ! empty( $last_quiz['progress'] ) ) :
	if ( empty( $passing_grade ) ) {
		$passed = true;
		$icon   = 'up';
	} else {
		$passed = ( $passing_grade <= $last_quiz['progress'] );
		$icon   = ( $passed ) ? 'up' : 'down';
	}
	?>

	<div class="stm_lms_result__round stm_lms_result__round_<?php echo esc_attr( $icon ); ?>">
		<svg xmlns="http://www.w3.org/2000/svg" width="102.938" height="89.093" viewBox="0 0 102.938 89.093">
			<path d="M333.041,726.715c5.217-5.079,3.6-15.353-5.428-15.353l-23.765.015c0.9-4.924,2.208-13.087,2.157-13.856-0.5-7.3-5.254-16.184-5.459-16.548-0.867-1.581-5.248-3.723-9.656-2.8-5.695,1.194-6.277,4.75-6.254,5.73,0,0,.245,9.727.271,12.325-2.725,5.853-12.117,21.238-14.965,22.422a4.416,4.416,0,0,0-2.256-.618H237.661a4.548,4.548,0,0,0-4.6,4.5l0,40.6a4.325,4.325,0,0,0,4.325,3.9h26.969a4.3,4.3,0,0,0,4.335-4.245v-1.347a3.19,3.19,0,0,1,1.457.212c1.734,1.082,3.876,2.437,6.672,2.437h40.243c15.046,0,13.43-13.069,12.061-14.854,2.536-2.705,4.11-7.484,1.964-11.256C332.736,736.276,335.636,731.577,333.041,726.715Zm-69.612,36.069h-26.05v-40.52h26.05v40.52Zm62.6-36.416-0.248,1c6.933,1.93,3.24,9.746-1.732,10.257l-0.244,1c6.647,1.653,3.476,9.7-1.728,10.253l-0.248,1c5.429,0.874,4.114,9.939-4.11,9.939l-40.933.019c-2.891,0-5.524-3.224-7.651-3.224h-1.856V725.421a65.012,65.012,0,0,0,6.734-4.536c2.987-2.491,15.2-21.811,15.2-24.229s-0.267-12.879-.267-12.879,2.394-3.021,7.746-.817c0,0,4.5,8.261,4.96,14.842,0,0-2.029,13.56-3.116,17.815h28.378C333.885,715.624,332.555,725.365,326.024,726.368Z"
					transform="translate(-233.062 -677.938)"/>
		</svg>
		<div class="stm_lms_timer__time">
			<div class="stm_lms_timer__time_h">
				<div class="heading_font"><?php echo esc_attr( $last_quiz['progress'] . '%' ); ?></div>
				<span><?php esc_html_e( 'Answered correctly', 'masterstudy-lms-learning-management-system' ); ?></span>
			</div>
		</div>
	</div>

<?php endif; ?>
