<?php
if( function_exists('acf_add_local_field_group') ):

	add_action( 'acf/include_fields', function() {
	if ( ! function_exists( 'acf_add_local_field_group' ) ) {
		return;
	}

	acf_add_local_field_group( array(
	'key' => 'group_6206d24255958',
	'title' => 'Additional Details',
	'fields' => array(
		array(
			'key' => 'field_6206d36b2ce8f',
			'label' => 'Store Locator Fields',
			'name' => 'store_locator_fields',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'See more about the Store Locator <a target="_blank" href="https://wpmaps-docs.mapster.me/maps/lists/store-locator">in our documentation</a>.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'allow_in_bindings' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_6206d4336615e',
			'label' => 'Address',
			'name' => 'address',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_6206d36b2ce8f',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_6206d4ec9e2be',
			'label' => 'Phone Number',
			'name' => 'phone_number',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_6206d36b2ce8f',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_62e179de58126',
			'label' => 'Website',
			'name' => 'website',
			'aria-label' => '',
			'type' => 'url',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_6206d36b2ce8f',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
		),
		array(
			'key' => 'field_6206d24a504fc',
			'label' => 'Hours',
			'name' => 'hours',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_6206d36b2ce8f',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6206d45207365',
					'label' => 'Show Hours',
					'name' => 'show_hours',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6206d27c504fd',
					'label' => 'Monday',
					'name' => 'monday',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d45207365',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6206d28f504ff',
							'label' => 'Open',
							'name' => 'open',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_6206d2ae50500',
							'label' => 'Close',
							'name' => 'close',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_622fbdddca829',
							'label' => 'Closed',
							'name' => 'closed',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
					),
				),
				array(
					'key' => 'field_6206d2ba50501',
					'label' => 'Tuesday',
					'name' => 'tuesday',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d45207365',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6206d2ba50502',
							'label' => 'Open',
							'name' => 'open',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_6206d2ba50503',
							'label' => 'Close',
							'name' => 'close',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_622fbe07ca82a',
							'label' => 'Closed',
							'name' => 'closed',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
					),
				),
				array(
					'key' => 'field_6206d2c050504',
					'label' => 'Wednesday',
					'name' => 'wednesday',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d45207365',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6206d2c050505',
							'label' => 'Open',
							'name' => 'open',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_6206d2c050506',
							'label' => 'Close',
							'name' => 'close',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_622fbe12ca82b',
							'label' => 'Closed',
							'name' => 'closed',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
					),
				),
				array(
					'key' => 'field_6206d2cd50508',
					'label' => 'Thursday',
					'name' => 'thursday',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d45207365',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6206d2cd50509',
							'label' => 'Open',
							'name' => 'open',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_6206d2cd5050a',
							'label' => 'Close',
							'name' => 'close',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_622fbe1bca82c',
							'label' => 'Closed',
							'name' => 'closed',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
					),
				),
				array(
					'key' => 'field_6206d2d35050b',
					'label' => 'Friday',
					'name' => 'friday',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d45207365',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6206d2d35050c',
							'label' => 'Open',
							'name' => 'open',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_6206d2d35050d',
							'label' => 'Close',
							'name' => 'close',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_622fbe25ca82d',
							'label' => 'Closed',
							'name' => 'closed',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
					),
				),
				array(
					'key' => 'field_6206d2d85050e',
					'label' => 'Saturday',
					'name' => 'saturday',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d45207365',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6206d2d85050f',
							'label' => 'Open',
							'name' => 'open',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_6206d2d850510',
							'label' => 'Close',
							'name' => 'close',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_622fbe2fca82e',
							'label' => 'Closed',
							'name' => 'closed',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
					),
				),
				array(
					'key' => 'field_6206d2df50511',
					'label' => 'Sunday',
					'name' => 'sunday',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d45207365',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6206d2df50512',
							'label' => 'Open',
							'name' => 'open',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_6206d2df50513',
							'label' => 'Close',
							'name' => 'close',
							'aria-label' => '',
							'type' => 'time_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'display_format' => 'g:i a',
							'return_format' => 'g:i a',
						),
						array(
							'key' => 'field_622fbe38ca82f',
							'label' => 'Closed',
							'name' => 'closed',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
					),
				),
			),
		),
		array(
			'key' => 'field_6206d2ef50514',
			'label' => 'Social Media',
			'name' => 'social_media',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_6206d36b2ce8f',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6206d4a219f0e',
					'label' => 'Show Social Media',
					'name' => 'show_social_media',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6206d2fc50515',
					'label' => 'Facebook',
					'name' => 'facebook',
					'aria-label' => '',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d4a219f0e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
				array(
					'key' => 'field_6206d30550516',
					'label' => 'Twitter',
					'name' => 'twitter',
					'aria-label' => '',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d4a219f0e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
				array(
					'key' => 'field_6206d30d50517',
					'label' => 'LinkedIn',
					'name' => 'linkedin',
					'aria-label' => '',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d4a219f0e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
				array(
					'key' => 'field_6206d31350518',
					'label' => 'Instagram',
					'name' => 'instagram',
					'aria-label' => '',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d4a219f0e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
				array(
					'key' => 'field_6206d31a50519',
					'label' => 'TikTok',
					'name' => 'tiktok',
					'aria-label' => '',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d4a219f0e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
				array(
					'key' => 'field_6206d50cb7262',
					'label' => 'YouTube',
					'name' => 'youtube',
					'aria-label' => '',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d4a219f0e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
				array(
					'key' => 'field_6206d512b7263',
					'label' => 'Pinterest',
					'name' => 'pinterest',
					'aria-label' => '',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6206d4a219f0e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
			),
		),
		array(
			'key' => 'field_63c9b370b52a8',
			'label' => 'Custom Button',
			'name' => 'custom_button',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Add a custom button beside Phone and Directions in the general Store Locator list.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_6206d36b2ce8f',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_63c9b370b52a9',
					'label' => 'Show Custom Button',
					'name' => 'show_custom_button',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_63c9b3d2b52b1',
					'label' => 'Custom Button Icon',
					'name' => 'custom_button_icon',
					'aria-label' => '',
					'type' => 'image',
					'instructions' => 'This image should be small and square to look good!',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_63c9b370b52a9',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'url',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
					'preview_size' => 'thumbnail',
				),
				array(
					'key' => 'field_63c9b370b52aa',
					'label' => 'Custom Button URL',
					'name' => 'custom_button_url',
					'aria-label' => '',
					'type' => 'url',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_63c9b370b52a9',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
				),
			),
		),
		array(
			'key' => 'field_62195710c0c4f',
			'label' => 'Locator Description',
			'name' => 'locator_description',
			'aria-label' => '',
			'type' => 'wysiwyg',
			'instructions' => 'A short description for the Store Locator sidebar.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_6206d36b2ce8f',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'tabs' => 'all',
			'toolbar' => 'full',
			'media_upload' => 1,
			'delay' => 0,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-location',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_61636c62b003e',
	'title' => 'Map',
	'fields' => array(
		array(
			'key' => 'field_6163702facc13',
			'label' => 'Map Tiles',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_616370e532005',
			'label' => 'Map Tiles',
			'name' => 'map_type',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_61636c71d48e1',
					'label' => 'Map Provider',
					'name' => 'map_provider',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'If you need help choosing, see our <a href="https://wpmaps-docs.mapster.me/" target="_blank">help docs</a>! After you change this option, please update and reload the page to see the correct map loaded.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'maplibre' => 'MapLibre',
						'mapbox' => 'Mapbox',
						'google-maps' => 'Google Maps',
						'custom-image' => 'Custom Image (MapLibre)',
					),
					'default_value' => 'maplibre',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_61636d761864c',
					'label' => 'Access Token',
					'name' => 'access_token',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Insert your <a href="https://docs.mapbox.com/help/getting-started/access-tokens/" target="_blank">access token</a> here. By default, it\'s loaded from <a href="/wp-admin/edit.php?post_type=mapster-wp-map&page=wordpress-maps-settings" target="_blank">Settings</a>.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_66d6bc083ada4',
					'label' => 'Map Tile Style',
					'name' => '',
					'aria-label' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '<div id="mapster-current-style"></div>
<a name=\'Style Selector\' href=\'#TB_inline?width=100&inlineId=mapster-style-selector\' class="thickbox button button-primary button-large">Select a Style</a>
<div id="mapster-style-selector" style="display:none;></div>',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),
				array(
					'key' => 'field_61636d141864b',
					'label' => 'Map Tile Style (Access Token)',
					'name' => 'map_tile_style_access_token',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'Differs depending if you have an <a href="https://docs.mapbox.com/help/getting-started/access-tokens/" target="_blank">access token</a> or not.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636d761864c',
								'operator' => '!=empty',
							),
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'standard-day' => 'Standard Day',
						'standard-night' => 'Standard Night',
						'standard-dusk' => 'Standard Dusk',
						'standard-dawn' => 'Standard Dawn',
						'standard-satellite-day' => 'Standard Satellite Day',
						'standard-satellite-night' => 'Standard Satellite Night',
						'streets' => 'Streets',
						'outdoors' => 'Outdoors',
						'light' => 'Light',
						'dark' => 'Dark',
						'satellite' => 'Satellite',
						'satellite-streets' => 'Satellite Streets',
						'navigation-day' => 'Navigation Day',
						'navigation-night' => 'Navigation Night',
						'mapster-monochrome-blue' => 'Monochrome Blue',
						'mapster-swiss-ski' => 'Swiss Ski',
						'mapster-neon' => 'Neon',
						'mapster-vintage' => 'Vintage',
						'mapster-whaam' => 'Whaam! (Comic book)',
						'mapster-camouflage' => 'Camouflage',
						'mapster-bright' => 'Bright',
						'mapster-unicorn' => 'Unicorn',
						'mapster-pencil' => 'Pencil',
						'mapster-memory' => 'Memory',
						'mapster-bubble' => 'Bubble',
						'mapster-frank' => 'Frank',
						'mapster-minimo' => 'Minimo',
						'mapster-standard-oil' => 'Standard Oil',
						'mapster-blueprint' => 'Blueprint',
						'mapster-neon-glow' => 'Neon Glow',
						'empty' => 'Empty',
						'open-street-map' => 'Open Street Map',
						'open-topo-map' => 'Open Topo Map',
						'hot-osm' => 'Humanitarian Open Street Map',
						'cyclo-osm' => 'CyclOSM',
						'esri-satellite' => 'Satellite (ESRI)',
						'esri-topo' => 'Topography (ESRI)',
					),
					'default_value' => 'streets',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_61636f4ed9390',
					'label' => 'Map Tile Style (No Access Token)',
					'name' => 'map_tile_style_no_access_token',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'Differs depending if you have an access token or not.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636d761864c',
								'operator' => '==empty',
							),
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636d761864c',
								'operator' => '==empty',
							),
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'open-street-map' => 'Open Street Map',
						'open-topo-map' => 'Open Topo Map',
						'hot-osm' => 'Humanitarian Open Street Map',
						'cyclo-osm' => 'CyclOSM',
						'esri-satellite' => 'Satellite (ESRI)',
						'esri-topo' => 'Topography (ESRI)',
						'esri-hybrid' => 'Hybrid (ESRI)',
						'dark-matter' => 'Dark Matter (CartoCDN)',
						'dark-matter-nolabels' => 'Dark Matter No Labels',
						'positron' => 'Positron (CartoCDN)',
						'positron-nolabels' => 'Positron No Labels',
						'voyager' => 'Voyager (CartoCDN)',
						'voyager-nolabels' => 'Voyager No Labels',
						'icgc-main' => 'ICGC Main',
						'icgc-dark' => 'ICGC Dark',
						'icgc-orthophoto' => 'ICGC Orthophoto',
						'empty' => 'Empty',
					),
					'default_value' => 'open-street-map',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'allow_in_bindings' => 1,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_6278706cd0583',
					'label' => 'Snazzy Map Style',
					'name' => 'snazzy_map_style',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'Go to <a href="https://snazzymaps.com/" target="_blank">Snazzy Maps</a>, and copy-paste the "Javascript Style Array" from the map you want. See the <a href="https://wpmaps-docs.mapster.me/" target="_blank">Mapster docs</a> for more information.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'google-maps',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'allow_in_bindings' => 1,
					'rows' => 6,
					'placeholder' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_616b319f75796',
					'label' => 'Custom Style URL',
					'name' => 'custom_mapbox_style',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Enter a <a href="https://docs.mapbox.com/help/glossary/style-url/" target="_blank">style URL</a> from your Mapbox account or another map provider here. Note if you use Maplibre, your Mapbox style URL will not work.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_6271a737238e5',
					'label' => 'Custom Style JSON',
					'name' => 'custom_style_json',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'See <a href="https://docs.mapbox.com/mapbox-gl-js/style-spec/" target="_blank">Mapbox docs</a> to learn more about making a style JSON.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => 4,
					'new_lines' => '',
				),
				array(
					'key' => 'field_63277539b7cee',
					'label' => 'Custom Image',
					'name' => 'custom_image',
					'aria-label' => '',
					'type' => 'image',
					'instructions' => 'Use an image for your base map instead of a map tile service. Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'custom-image',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'array',
					'preview_size' => 'medium',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array(
					'key' => 'field_616cc11de5b4f',
					'label' => '3D Terrain',
					'name' => 'terrain',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Add 3D terrain to the map.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'allow_in_bindings' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_662d1568dbdf8',
					'label' => '3D Buildings',
					'name' => 'buildings_3d',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Add 3D buildings to the map (requires Mapbox style).<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
							array(
								'field' => 'field_61636d761864c',
								'operator' => '!=empty',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_62bc7ec257df5',
					'label' => 'Globe',
					'name' => 'globe',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Turn your Mapbox map into a 3D globe.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster WP Maps Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_62bc8179b2085',
					'label' => 'Globe Background',
					'name' => 'globe_background',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62bc7ec257df5',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'transparent' => 'Transparent',
						'star-fog' => 'Stars & Fog',
					),
					'default_value' => 'transparent',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_6270aedc7a9dc',
					'label' => 'Projection',
					'name' => 'projection',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'mercator' => 'Mercator',
						'naturalEarth' => 'Natural Earth',
						'albers' => 'Albers',
						'equalEarth' => 'Equal Earth',
						'equirectangular' => 'Equirectangular',
						'lambertConformalConic' => 'Lambert Comformal Conic',
						'winkelTripel' => 'Winkel Tripel',
					),
					'default_value' => 'mercator',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_662c225e19afb',
					'label' => 'Language',
					'name' => 'map_language',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'If you\'d like to have your map appear in a different language. This may not work with some styles, depending on the languages you\'ve loaded into your map.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'en' => 'English',
						'es' => 'Spanish',
						'fr' => 'French',
						'de' => 'German',
						'it' => 'Italian',
						'pt' => 'Portuguese',
						'ru' => 'Russian',
						'zh-Hans' => 'Simplified Chinese',
						'zh-Hant' => 'Traditional Chinese',
						'ja' => 'Japanese',
						'ko' => 'Korean',
						'vi' => 'Vietnamese',
						'ar' => 'Arabic',
					),
					'default_value' => 'en',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_66cb6c68360a7',
					'label' => 'Duplicate horizontally',
					'name' => 'duplicate_horizontally_copy',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'This makes copies of the world map horizontally.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'custom-image',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
			),
		),
		array(
			'key' => 'field_6423ca3c20223',
			'label' => 'Initial View',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_617c54ddda520',
			'label' => 'Initial View',
			'name' => 'view',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_617c54f6da521',
					'label' => 'Initial Load',
					'name' => 'initial_load',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'Choose how you want to map to zoom when it first loads.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'fit-features' => 'Fit to Features',
						'manual' => 'Manual Center & Zoom',
						'location' => 'User Location',
					),
					'default_value' => 'fit-features',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_670a0ca98ccf7',
					'label' => 'Set from View',
					'name' => '',
					'aria-label' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_617c54f6da521',
								'operator' => '==',
								'value' => 'manual',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '<button class="button button-secondary mapster-set-manual-map-view">Set manual values from current map view</button>',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),
				array(
					'key' => 'field_66d49df1779e5',
					'label' => 'About User Location',
					'name' => '',
					'aria-label' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_617c54f6da521',
								'operator' => '==',
								'value' => 'location',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => 'Requires <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>. By default, this will only load to the user\'s IP, which may be inaccurate. Set your preferred zoom below. For a more accurate geolocation on load, use the Geolocation Control.

This service uses <a href="https://ip-api.com/" target="_blank">IP-API.com</a>, which is not to be used on any commercial website unless you purchase a license. It has a number of technical restrictions as well. Please contact Mapster if you need more from this.',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),
				array(
					'key' => 'field_617c5543da522',
					'label' => 'Manual Latitude',
					'name' => 'manual_latitude',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_617c54f6da521',
								'operator' => '==',
								'value' => 'manual',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => -90,
					'max' => 90,
					'step' => '',
				),
				array(
					'key' => 'field_617c558dda523',
					'label' => 'Manual Longitude',
					'name' => 'manual_longitude',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_617c54f6da521',
								'operator' => '==',
								'value' => 'manual',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => -180,
					'max' => 180,
					'step' => '',
				),
				array(
					'key' => 'field_617c559fda524',
					'label' => 'Manual Zoom',
					'name' => 'manual_zoom',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_617c54f6da521',
								'operator' => '==',
								'value' => 'manual',
							),
						),
						array(
							array(
								'field' => 'field_617c54f6da521',
								'operator' => '==',
								'value' => 'location',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'min' => 0,
					'max' => 22,
					'placeholder' => '',
					'step' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_62704588d27a3',
					'label' => 'Manual Pitch',
					'name' => 'manual_pitch',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'min' => 0,
					'max' => 90,
					'allow_in_bindings' => 1,
					'placeholder' => 0,
					'step' => '',
					'prepend' => '',
					'append' => '°',
				),
				array(
					'key' => 'field_62704593d27a4',
					'label' => 'Manual Rotation',
					'name' => 'manual_rotation',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'min' => -360,
					'max' => 360,
					'allow_in_bindings' => 1,
					'placeholder' => 0,
					'step' => '',
					'prepend' => '',
					'append' => '°',
				),
				array(
					'key' => 'field_66e5ca493efda',
					'label' => 'Padding Around Bounds',
					'name' => 'padding_around_bounds',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => 'Extra padding so features are not on the edge of the map.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_617c54f6da521',
								'operator' => '==',
								'value' => 'fit-features',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 20,
					'min' => 0,
					'max' => 500,
					'placeholder' => '',
					'step' => 1,
					'prepend' => '',
					'append' => 'px',
				),
				array(
					'key' => 'field_669ef02d322c4',
					'label' => 'Globe Animation',
					'name' => 'globe_animation',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Select options for rotating the globe automatically. Rotation will stop when the user clicks on the map.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62bc7ec257df5',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_669ef06d322c5',
					'label' => 'Animation Speed',
					'name' => 'globe_animation_speed',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => 'Select a speed between 1 and 200.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_669ef02d322c4',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 80,
					'min' => 1,
					'max' => 200,
					'placeholder' => '',
					'step' => 1,
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_669ef0a6322c6',
					'label' => 'Animation Direction',
					'name' => 'globe_animation_direction',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_669ef02d322c4',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'west-east' => 'West -> East',
						'east-west' => 'East -> West',
						'south-north' => 'South -> North',
						'north-south' => 'North -> South',
					),
					'default_value' => 'west-east',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_6423ca4920224',
			'label' => 'Map Size',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_616766dcb2f7e',
			'label' => 'Map Size',
			'name' => 'layout',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6167658ddd833',
					'label' => 'Height',
					'name' => 'height',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => 400,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => 0,
					'max' => '',
					'step' => '',
				),
				array(
					'key' => 'field_616765acdd834',
					'label' => 'Height Units',
					'name' => 'height_units',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '15',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'px' => 'px',
						'%' => '%',
						'vh' => 'vh',
					),
					'default_value' => 'px',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'allow_in_bindings' => 1,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_62dae867050a8',
					'label' => 'Height Warning',
					'name' => '',
					'aria-label' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_616765acdd834',
								'operator' => '==',
								'value' => '%',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => 'Please be careful when setting heights to percentage -- you must structure your HTML properly for this to work, otherwise the height will be zero.',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),
				array(
					'key' => 'field_616765d4dd835',
					'label' => 'Width',
					'name' => 'width',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => 100,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => 0,
					'max' => '',
					'step' => '',
				),
				array(
					'key' => 'field_616765e8dd836',
					'label' => 'Width Units',
					'name' => 'width_units',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '15',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'px' => 'px',
						'%' => '%',
						'vw' => 'vw',
					),
					'default_value' => '%',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'allow_in_bindings' => 1,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_6351ba83249f7',
					'label' => 'Add Mobile Breakpoints',
					'name' => 'add_mobile_breakpoints',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Add different height or width values at two additional breakpoints.<span class="mapster-pro-text"> Available in Pro.</span>',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_6351bad694e35',
					'label' => 'Breakpoints',
					'name' => 'breakpoints',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6351ba83249f7',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '70',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_6351baf294e36',
							'label' => 'Breakpoint 1',
							'name' => 'breakpoint_1',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => 'Enter the breakpoint value (1024px for tablet is default)',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1024,
							'min' => '',
							'max' => '',
							'placeholder' => '',
							'step' => 1,
							'prepend' => '',
							'append' => 'px',
						),
						array(
							'key' => 'field_6351bb3b94e37',
							'label' => 'Breakpoint 1 Map Width',
							'name' => 'breakpoint_1_map_width',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '70',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'maxlength' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_6351bb7094e39',
							'label' => 'Width Units',
							'name' => 'breakpoint_1_map_width_units',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '30',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'px' => 'px',
								'%' => '%',
							),
							'default_value' => '%',
							'return_format' => 'value',
							'multiple' => 0,
							'allow_null' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_6351bb4694e38',
							'label' => 'Breakpoint 1 Map Height',
							'name' => 'breakpoint_1_map_height',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '70',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'min' => '',
							'max' => '',
							'placeholder' => '',
							'step' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_6351bb9f94e3a',
							'label' => 'Height Units',
							'name' => 'breakpoint_1_map_height_units',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '30',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'px' => 'px',
								'%' => '%',
							),
							'default_value' => 'px',
							'return_format' => 'value',
							'multiple' => 0,
							'allow_null' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_6351be7a7e433',
							'label' => 'Breakpoint 2',
							'name' => 'breakpoint_2',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => 'Enter the breakpoint value (428px for mobile is default)',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 428,
							'min' => '',
							'max' => '',
							'placeholder' => '',
							'step' => 1,
							'prepend' => '',
							'append' => 'px',
						),
						array(
							'key' => 'field_6351be887e434',
							'label' => 'Breakpoint 2 Map Width',
							'name' => 'breakpoint_2_map_width',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '70',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'maxlength' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_6351bea67e435',
							'label' => 'Width Units',
							'name' => 'breakpoint_2_map_width_units',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '30',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'px' => 'px',
								'%' => '%',
							),
							'default_value' => '%',
							'return_format' => 'value',
							'multiple' => 0,
							'allow_null' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_6351bead7e436',
							'label' => 'Breakpoint 2 Map Height',
							'name' => 'breakpoint_2_map_height',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '70',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'min' => '',
							'max' => '',
							'placeholder' => '',
							'step' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_6351beb47e437',
							'label' => 'Height Units',
							'name' => 'breakpoint_2_map_height_units',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '30',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'px' => 'px',
								'%' => '%',
							),
							'default_value' => 'px',
							'return_format' => 'value',
							'multiple' => 0,
							'allow_null' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
					),
				),
				array(
					'key' => 'field_61a4300dd751a',
					'label' => 'Full page',
					'name' => 'full_page',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Selecting this option will make your map as high as the user\'s screen and as wide as your theme allows (100%).',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_61a43130873b9',
					'label' => 'Ignore Container',
					'name' => 'ignore_container',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Ignore your theme limits and force the map to be the full width of the user\'s screen.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61a4300dd751a',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_66e0b2ad0bf84',
					'label' => 'Map Only',
					'name' => 'map_only',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'This option will completely remove any other HTML content (menu bars, footers, etc) and make your page only the map.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61a43130873b9',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_61e82dfbea012',
					'label' => 'Duplicate horizontally',
					'name' => 'duplicate_horizontally',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'This makes copies of the world map horizontally.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'custom-image',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
			),
		),
		array(
			'key' => 'field_61637af50e99e',
			'label' => 'Points, Lines, Polygons',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_61637b0892e4a',
			'label' => 'Locations',
			'name' => 'locations',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'mapster-wp-location',
			),
			'taxonomy' => '',
			'allow_null' => 0,
			'multiple' => 1,
			'return_format' => 'object',
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_6283100fb4f7d',
			'label' => 'Load 3D Model Libraries',
			'name' => 'load_3d_model_libraries',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'If you\'re using the 3D model point type, turn this on.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61637b0892e4a',
						'operator' => '>',
						'value' => '0',
					),
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '!=',
						'value' => 'google-maps',
					),
				),
				array(
					array(
						'field' => 'field_6186d543b6f7f',
						'operator' => '>',
						'value' => '0',
					),
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '!=',
						'value' => 'google-maps',
					),
				),
				array(
					array(
						'field' => 'field_66c3d2faf89a2',
						'operator' => '>',
						'value' => '0',
					),
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '!=',
						'value' => 'google-maps',
					),
				),
			),
			'wrapper' => array(
				'width' => '20',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_61637b2fb1cc2',
			'label' => 'Lines',
			'name' => 'lines',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'mapster-wp-line',
			),
			'taxonomy' => '',
			'allow_null' => 0,
			'multiple' => 1,
			'return_format' => 'object',
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_61637b3fb1cc3',
			'label' => 'Polygons',
			'name' => 'polygons',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'mapster-wp-polygon',
			),
			'taxonomy' => '',
			'allow_null' => 0,
			'multiple' => 1,
			'return_format' => 'object',
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_6186d543b6f7f',
			'label' => 'Add by Category',
			'name' => 'add_by_category',
			'aria-label' => '',
			'type' => 'taxonomy',
			'instructions' => 'Try not to add features twice -- you may encounter errors or duplications.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'taxonomy' => 'wp-map-category',
			'field_type' => 'multi_select',
			'allow_null' => 0,
			'add_term' => 0,
			'save_terms' => 0,
			'load_terms' => 0,
			'return_format' => 'id',
			'multiple' => 0,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_66c3d2faf89a2',
			'label' => 'Add Custom Posts',
			'name' => 'add_custom_posts',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Add any post that you\'ve added a Mapster Map ACF custom field to.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'post_type' => '',
			'post_status' => '',
			'taxonomy' => '',
			'return_format' => 'object',
			'multiple' => 1,
			'allow_null' => 0,
			'bidirectional' => 0,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_68a8201cbafe3',
			'label' => 'Add by Custom Category',
			'name' => 'add_by_custom_category',
			'aria-label' => '',
			'type' => 'taxonomy',
			'instructions' => 'Add any category from your site (they must have Mapster fields to function). <span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'taxonomy' => 'category',
			'add_term' => 0,
			'save_terms' => 0,
			'load_terms' => 0,
			'return_format' => 'id',
			'field_type' => 'multi_select',
			'allow_null' => 0,
			'allow_in_bindings' => 0,
			'bidirectional' => 0,
			'multiple' => 0,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_62657cf9c510a',
			'label' => 'Show all languages',
			'name' => 'show_all_languages',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'If this is true, posts from equivalent translated categories will be fetched.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_6186d543b6f7f',
						'operator' => '!=empty',
					),
				),
			),
			'wrapper' => array(
				'width' => '100',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_66cb618156d5b',
			'label' => 'Clustering',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_6885fadf8db13',
			'label' => 'Clustering Instructions',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => 'Please select only one type of clustering at a time. If you select more than one, you may have unexpected results. Clustering will only appear on your live map (not in the preview above).',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_616f6b591ebac',
			'label' => 'Circle Clustering',
			'name' => 'circle_clustering',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_6178dcc22f265',
			'label' => 'Label & Icon Clustering',
			'name' => 'label_icon_clustering',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_626f1b0c0f5a0',
			'label' => 'Marker Clustering',
			'name' => 'marker_clustering',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_68852b6edc4e0',
			'label' => 'Polygon Clustering',
			'name' => 'polygon_clustering',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster WP Maps Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'allow_in_bindings' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_6885f8be856c6',
			'label' => 'Line Clustering',
			'name' => 'line_clustering',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster WP Maps Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'allow_in_bindings' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_626f2cc43dd53',
			'label' => 'Cluster Options',
			'name' => 'cluster_options',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Further cluster customization, such as clustering by category, as well as specifying color, size, and other options for different cluster breakpoints.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster WP Maps Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_62d8233486f5e',
					'label' => 'Cluster by Category',
					'name' => 'cluster_by_category',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6488f2e119cdb',
					'label' => 'Show Category Name Instead of Number',
					'name' => 'show_category_name',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Instead of showing a number in the middle of the circle, show the category name. You can use the options below to further customize the circle or hide it completely.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62d8233486f5e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_66695480b6b8d',
					'label' => 'Image on Cluster',
					'name' => 'image_on_cluster',
					'aria-label' => '',
					'type' => 'image',
					'instructions' => 'This image will replace all cluster circles. The image should not be more than 150x150.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'url',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
					'preview_size' => 'thumbnail',
				),
				array(
					'key' => 'field_62d82418c8cbb',
					'label' => 'Categories to Cluster',
					'name' => 'categories_to_cluster',
					'aria-label' => '',
					'type' => 'taxonomy',
					'instructions' => 'These categories will be clustered independently.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62d8233486f5e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'taxonomy' => 'wp-map-category',
					'field_type' => 'multi_select',
					'allow_null' => 1,
					'add_term' => 0,
					'save_terms' => 0,
					'load_terms' => 0,
					'return_format' => 'id',
					'multiple' => 0,
					'bidirectional_target' => array(
					),
				),
				array(
					'key' => 'field_62d8246ac8cbc',
					'label' => 'Category Cluster Styling',
					'name' => 'category_cluster_styling',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'Enter each cluster hex code color on a separate line (in order of the categories selected above). See the docs for more details. Note that further styling (in Enable Cluster Options) will not be applied to category clusters.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62d8233486f5e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_62746e6b5e449',
					'label' => 'Enable Cluster Options',
					'name' => 'enable_cluster_options',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_626f2d653dd55',
					'label' => 'Small Clusters',
					'name' => '',
					'aria-label' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62746e6b5e449',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
					'selected' => 0,
				),
				array(
					'key' => 'field_626f2dfe13c0a',
					'label' => 'Small Cluster Color',
					'name' => 'small_cluster_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#51bbd6',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_626f2e4213c0d',
					'label' => 'Small Cluster Radius',
					'name' => 'small_cluster_radius',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 20,
					'placeholder' => 20,
					'prepend' => '',
					'append' => 'px',
					'min' => 0,
					'max' => '',
					'step' => '0.1',
				),
				array(
					'key' => 'field_626f396ca8119',
					'label' => 'Small Cluster Count',
					'name' => 'small_cluster_count',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => 'How many individual points mark the upper limit of the small cluster?',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 50,
					'placeholder' => 50,
					'prepend' => '',
					'append' => 'points',
					'min' => 0,
					'max' => '',
					'step' => 1,
				),
				array(
					'key' => 'field_626f3057eb6ce',
					'label' => 'Small Cluster Border Color',
					'name' => 'small_cluster_border_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#FFFFFF',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_626f3093eb6d1',
					'label' => 'Small Cluster Border Width',
					'name' => 'small_cluster_width',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => 0,
					'prepend' => '',
					'append' => 'px',
					'min' => 0,
					'max' => '',
					'step' => '0.1',
				),
				array(
					'key' => 'field_626f2d713dd56',
					'label' => 'Medium Clusters',
					'name' => '',
					'aria-label' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62746e6b5e449',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
					'selected' => 0,
				),
				array(
					'key' => 'field_626f2e0d13c0b',
					'label' => 'Medium Cluster Color',
					'name' => 'medium_cluster_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#f1f075',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_626f2e5c13c0e',
					'label' => 'Medium Cluster Radius',
					'name' => 'medium_cluster_radius',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 30,
					'placeholder' => 30,
					'prepend' => '',
					'append' => 'px',
					'min' => 0,
					'max' => '',
					'step' => '0.1',
				),
				array(
					'key' => 'field_626f3998a811a',
					'label' => 'Medium Cluster Count',
					'name' => 'medium_cluster_count',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => 'How many individual points mark the upper limit of the medium cluster?',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 100,
					'placeholder' => 100,
					'prepend' => '',
					'append' => 'points',
					'min' => 0,
					'max' => '',
					'step' => 1,
				),
				array(
					'key' => 'field_626f306eeb6cf',
					'label' => 'Medium Cluster Border Color',
					'name' => 'medium_cluster_border_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#FFFFFF',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_626f30a2eb6d2',
					'label' => 'Medium Cluster Border Width',
					'name' => 'medium_cluster_width',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => 0,
					'prepend' => '',
					'append' => 'px',
					'min' => 0,
					'max' => '',
					'step' => '0.1',
				),
				array(
					'key' => 'field_626f2d793dd57',
					'label' => 'Large Clusters',
					'name' => '',
					'aria-label' => '',
					'type' => 'tab',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62746e6b5e449',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'placement' => 'top',
					'endpoint' => 0,
					'selected' => 0,
				),
				array(
					'key' => 'field_626f2e1113c0c',
					'label' => 'Large Cluster Color',
					'name' => 'large_cluster_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#f28cb1',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_626f2e6113c0f',
					'label' => 'Large Cluster Radius',
					'name' => 'large_cluster_radius',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 40,
					'placeholder' => 40,
					'prepend' => '',
					'append' => 'px',
					'min' => 0,
					'max' => '',
					'step' => '0.1',
				),
				array(
					'key' => 'field_626f3074eb6d0',
					'label' => 'Large Cluster Border Color',
					'name' => 'large_cluster_border_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#FFFFFF',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_626f30b3eb6d3',
					'label' => 'Large Cluster Border Width',
					'name' => 'large_cluster_width',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => 0,
					'prepend' => '',
					'append' => 'px',
					'min' => 0,
					'max' => '',
					'step' => '0.1',
				),
			),
		),
		array(
			'key' => 'field_61636fe6af17b',
			'label' => 'Interactivity',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_6167667ab2f7c',
			'label' => 'Zoom on Scroll',
			'name' => 'zoom_on_scroll',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Allow user to zoom with the mouse wheel. This will not change the editor map, only the map presented on the front-end of your site.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616766a3b2f7d',
			'label' => 'Interactivity',
			'name' => 'interactivity',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Enable or disable interaction completely on the map. This will not change the editor map, only the map presented on the front-end of your site.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => 'Enable',
			'ui_off_text' => 'Disable',
		),
		array(
			'key' => 'field_65e37d5c2fc89',
			'label' => 'Clicking Disabled',
			'name' => 'clicking_disabled',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Clicking or hovering over markers and features won\'t do anything if this is enabled.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616766a3b2f7d',
						'operator' => '!=',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui_on_text' => 'Enable',
			'ui_off_text' => 'Disable',
			'ui' => 1,
		),
		array(
			'key' => 'field_6552b401e90f5',
			'label' => 'Cooperative Gestures',
			'name' => 'cooperative_gestures',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'This enables "cooperative gestures" on your map, requiring the user to zoom with Ctrl+Scroll or pan using two fingers on a mobile device.<span class="mapster-pro-text"> Available in <a target="_blank" href="https://wpmaps.mapster.me/pro">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => 'Enable',
			'ui_off_text' => 'Disable',
			'ui' => 1,
		),
		array(
			'key' => 'field_63aa002cff2e6',
			'label' => 'Allow Rotation and Pitch',
			'name' => 'allow_rotation_and_pitch',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Enable or disable user ability to rotate and pitch (tilt) the map.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616766a3b2f7d',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui_on_text' => 'Enable',
			'ui_off_text' => 'Disable',
			'ui' => 1,
		),
		array(
			'key' => 'field_61dcb6807d0b8',
			'label' => 'Open Popups in Sidebar',
			'name' => 'open_popups_in_sidebar',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Instead of opening popups on features, this causes featured images, content, etc to load in a scrollable sidebar on the map. Your popup custom styles will still be applied here.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => 'Enable',
			'ui_off_text' => 'Disable',
		),
		array(
			'key' => 'field_627afe7ba0d2f',
			'label' => 'Minimum Sidebar Width',
			'name' => 'minimum_sidebar_width',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61dcb6807d0b8',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => 100,
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => 0,
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_627b0007a0d30',
			'label' => 'Maximum Sidebar Width',
			'name' => 'maximum_sidebar_width',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61dcb6807d0b8',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => 250,
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => 0,
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_62d7047669208',
			'label' => 'Restricted Movement',
			'name' => 'restricted_movement',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Restrict user zooming and panning to within certain coordinate boundaries and zoom levels.<span class="mapster-pro-text"> Available in Pro.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_62d7058669212',
					'label' => 'Restrict Movement',
					'name' => 'restrict_movement',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_62d704d06920a',
					'label' => 'Allowed Bounds',
					'name' => 'allowed_bounds',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => 'Enter in a SW coordinate and a NE coordinate that represent the bounds your user is allowed to pan.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62d7058669212',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_62d7052f6920d',
							'label' => 'Southwest Latitude',
							'name' => 'southwest_latitude',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'min' => -90,
							'max' => 90,
							'step' => '',
						),
						array(
							'key' => 'field_62d705066920b',
							'label' => 'Southwest Longitude',
							'name' => 'southwest_longitude',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'min' => -180,
							'max' => 180,
							'step' => '',
						),
						array(
							'key' => 'field_62d705426920e',
							'label' => 'Northeast Latitude',
							'name' => 'northeast_latitude',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'min' => -90,
							'max' => 90,
							'step' => '',
						),
						array(
							'key' => 'field_62d705256920c',
							'label' => 'Northeast Longitude',
							'name' => 'northeast_longitude',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'min' => -180,
							'max' => 180,
							'step' => '',
						),
					),
				),
				array(
					'key' => 'field_62d705576920f',
					'label' => 'Allowed Zoom',
					'name' => 'allowed_zoom',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62d7058669212',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_62d7057469211',
							'label' => 'Min Zoom',
							'name' => 'min_zoom',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'min' => 0,
							'max' => 22,
							'step' => '',
						),
						array(
							'key' => 'field_62d7056069210',
							'label' => 'Max Zoom',
							'name' => 'max_zoom',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'min' => 0,
							'max' => 22,
							'step' => '',
						),
					),
				),
			),
		),
		array(
			'key' => 'field_61636fb2af179',
			'label' => 'Controls',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_66cb7dbbaec53',
			'label' => 'Basic Controls',
			'name' => '',
			'aria-label' => '',
			'type' => 'accordion',
			'instructions' => 'Zoom, scale, fullscreen, attribution, default map logo. (Google Maps: map type and streetview)',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'open' => 0,
			'multi_expand' => 0,
			'endpoint' => 0,
		),
		array(
			'key' => 'field_616768aa0ad63',
			'label' => 'Zoom Control',
			'name' => 'zoom_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_61676748f4045',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_616767b7f4049',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676748f4045',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-right',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_6167693919e09',
			'label' => 'Scale Control',
			'name' => 'scale_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6167693919e0a',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6167693919e0b',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167693919e0a',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_6167693919e0a',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'bottom-right',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_6167697d19e0f',
			'label' => 'Fullscreen Control',
			'name' => 'fullscreen_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6167697d19e10',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6167697d19e11',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167697d19e10',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-right',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_63f0fdec5bffa',
			'label' => 'Attribution Control',
			'name' => 'attribution_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'If using Mapbox, <a href="https://docs.mapbox.com/mapbox-gl-js/example/attribution-position/" target="_blank">you must include this as per the terms of service</a>. However, you may change its position here.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_63f0fdec5bffc',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'bottom-right',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_63f103b79267e',
			'label' => 'Logo',
			'name' => 'logo_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'This is included with Mapbox and Maplibre, but you may change its position here.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_63f103b79267f',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'bottom-left',
					'return_format' => '',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_6273f3f2b3b69',
			'label' => 'Map Type Control',
			'name' => 'map_type_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'google-maps',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6273f3f2b3b6a',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6273f3f2b3b6b',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6273f3f2b3b6a',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-left',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_6273fa0c97377',
			'label' => 'Street View Control',
			'name' => 'street_view_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'google-maps',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6273fa0c97378',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6273fa0c97379',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6273fa0c97378',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'bottom-right',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_66cb7f59a0a4c',
			'label' => 'Basic Controls (copy)',
			'name' => '',
			'aria-label' => '',
			'type' => 'accordion',
			'instructions' => 'description',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'open' => 0,
			'multi_expand' => 0,
			'endpoint' => 1,
		),
		array(
			'key' => 'field_66cb7f82a0a4d',
			'label' => 'Geocoding & Geolocation',
			'name' => '',
			'aria-label' => '',
			'type' => 'accordion',
			'instructions' => 'Geocoder, geolocation, directions, POI searchbox.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'open' => 0,
			'multi_expand' => 0,
			'endpoint' => 0,
		),
		array(
			'key' => 'field_616768d90ad64',
			'label' => 'Geocoder Control',
			'name' => 'geocoder_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'This allows users to search for an address. Requires a Mapbox token.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6167685d51239',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_616768875123a',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167685d51239',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-left',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_61676cf907199',
					'label' => 'Limit Results',
					'name' => 'limit_results',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Limit results to specific countries. Use 2-letter country codes, separated by commas.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167685d51239',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_66f476c3379af',
					'label' => 'Limit by Bounds',
					'name' => 'limit_by_bounds',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Limit the search result more specifically by a set of coordinates.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167685d51239',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'allow_in_bindings' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_66f47707379b0',
					'label' => 'Bounds Limit',
					'name' => 'bounds_limit',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => 'Enter in a SW coordinate and a NE coordinate that represent the bounds your user is allowed to pan.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_66f476c3379af',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_66f47707379b1',
							'label' => 'Southwest Latitude',
							'name' => 'southwest_latitude',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'min' => -90,
							'max' => 90,
							'allow_in_bindings' => 1,
							'placeholder' => '',
							'step' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_66f47707379b2',
							'label' => 'Southwest Longitude',
							'name' => 'southwest_longitude',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'min' => -180,
							'max' => 180,
							'allow_in_bindings' => 1,
							'placeholder' => '',
							'step' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_66f47707379b3',
							'label' => 'Northeast Latitude',
							'name' => 'northeast_latitude',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'min' => -90,
							'max' => 90,
							'allow_in_bindings' => 1,
							'placeholder' => '',
							'step' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_66f47707379b4',
							'label' => 'Northeast Longitude',
							'name' => 'northeast_longitude',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'min' => -180,
							'max' => 180,
							'allow_in_bindings' => 1,
							'placeholder' => '',
							'step' => '',
							'prepend' => '',
							'append' => '',
						),
					),
				),
				array(
					'key' => 'field_6695748362942',
					'label' => 'Accept Lat/Lngs',
					'name' => 'accept_latlngs',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Allow the user to enter latitude and longitude values directly.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167685d51239',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_625c477632a21',
					'label' => 'Placeholder',
					'name' => 'placeholder',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167685d51239',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'Search',
					'placeholder' => 'Search',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_65d38de96fc46',
					'label' => 'Marker Color',
					'name' => 'marker_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => 'Change the color of the marker displayed when a user selects a location.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167685d51239',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#3FB1CE',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
			),
		),
		array(
			'key' => 'field_6167695619e0c',
			'label' => 'Geolocation Control (User Tracking)',
			'name' => 'geolocation_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'This adds a button to the map so users can see their own location (requires HTTPS).',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6167695619e0d',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6167695619e0e',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167695619e0d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-right',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_62bc82713cfb8',
					'label' => 'Set on Load',
					'name' => 'set_on_load',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Request permission and set map to user location when the map loads.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167695619e0d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_6519d89296311',
					'label' => 'Show Accuracy Circle',
					'name' => 'show_accuracy_circle',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Show a circle representing the variance in user position. <span class="mapster-pro-text">Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167695619e0d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_6519d8d396312',
					'label' => 'Show User Heading',
					'name' => 'show_user_heading',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Must be a Mapbox map to work.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167695619e0d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_6519d8de96313',
					'label' => 'Track User Location',
					'name' => 'track_user_location',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Track the user location as it changes.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167695619e0d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_66b05a996fe99',
					'label' => 'Enable High Accuracy',
					'name' => 'enable_high_accuracy',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Use the most accurate location possible. Browsers will be less accurate than mobile devices.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6167695619e0d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
			),
		),
		array(
			'key' => 'field_6167763ea63ab',
			'label' => 'Directions Control',
			'name' => 'directions_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Requires a Mapbox token.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_61677651a63ac',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6167768aa63ad',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61677651a63ac',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-left',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_616776a6a63ae',
					'label' => 'Units',
					'name' => 'units',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61677651a63ac',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'imperial' => 'Imperial',
						'metric' => 'Metric',
					),
					'default_value' => 'imperial',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_616776cba63af',
					'label' => 'Default Type',
					'name' => 'default_type',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61677651a63ac',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'mapbox/driving-traffic' => 'Driving Traffic',
						'mapbox/driving' => 'Driving',
						'mapbox/walking' => 'Walking',
						'mapbox/cycling' => 'Cycling',
					),
					'default_value' => 'mapbox/driving-traffic',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_61677707a63b0',
					'label' => 'Placeholder Text',
					'name' => 'placeholder_text',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61677651a63ac',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'Enter a starting location',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
			),
		),
		array(
			'key' => 'field_672be5c6a46df',
			'label' => 'Searchbox Control',
			'name' => 'searchbox_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Requires a Mapbox token.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_672be5c6a46e0',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'allow_in_bindings' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_672be5c6a46e1',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_672be5c6a46e0',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-left',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'allow_in_bindings' => 1,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_66cb7fd9a0a4e',
			'label' => 'Geocoding & Geolocation (copy)',
			'name' => '',
			'aria-label' => '',
			'type' => 'accordion',
			'instructions' => 'Geocoder, geolocation, directions.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'open' => 0,
			'multi_expand' => 0,
			'endpoint' => 1,
		),
		array(
			'key' => 'field_66cb7ffaa0a4f',
			'label' => 'Toggler Controls',
			'name' => '',
			'aria-label' => '',
			'type' => 'accordion',
			'instructions' => '3D on/off, layer controls, style switching, toggleable control menu.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'open' => 0,
			'multi_expand' => 0,
			'endpoint' => 0,
		),
		array(
			'key' => 'field_616cc35dcbbe0',
			'label' => '3D Control',
			'name' => '3d_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Adds a button that allows the user to easily switch to a 3D tilted view.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_616cc386cbbe1',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_616cc39fcbbe2',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_616cc386cbbe1',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-right',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_640e5509aee56',
			'label' => 'Layer Control',
			'name' => 'layer_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Toggle on and off layers that you\'ve added to a Style you\'re loading from Mapbox.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_640e5509aee57',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_640e5509aee58',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_640e5509aee57',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-left',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_640e5509aee59',
					'label' => 'Toggleable Layers',
					'name' => 'toggleable_layers',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'Here, enter the layer names for each toggle, according to the name you\'ve given them in your Mapbox style. Multiple layers for one toggle should be separated by commas, and each toggle should be on a new line.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_640e5509aee57',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'rows' => '',
					'placeholder' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_640e55eaaee5a',
					'label' => 'Toggleable Layer Titles',
					'name' => 'toggleable_layer_titles',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'In the same order as on the left, enter a title you want to appear for each set of toggleable layers. These should line up with the sets of layers you\'ve entered. If you\'re not sure, take a look at the documentation!',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_640e5509aee57',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'rows' => '',
					'placeholder' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_640e5d42408c9',
					'label' => 'Checkbox Type',
					'name' => 'checkbox_type',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'Select checkboxes or switches if you want to allow multiple layer sets to be turned on and off independently. If you select radio, please make sure only one listed layer is set to Visible by default in your Style.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_640e5509aee57',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'checkbox' => 'Checkboxes',
						'radio' => 'Radio Buttons',
						'switch' => 'Switches',
					),
					'default_value' => 'radio',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_64155b52d8de9',
			'label' => 'Style Switcher Control',
			'name' => 'style_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Toggle on and off styles (underlying map tiles), created in Mapbox or elsewhere.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_64155b52d8dea',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_64155b52d8deb',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64155b52d8dea',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-left',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_64155b52d8dec',
					'label' => 'Styles',
					'name' => 'toggleable_styles',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'Here, enter the style URLs or style JSONs. Use line breaks to separate each entry. See the <a href="https://wpmaps.mapster.me/pro" target="_blank">documentation</a> for more specific help!',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64155b52d8dea',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'rows' => '',
					'placeholder' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_641659db46bbb',
					'label' => 'Style Titles',
					'name' => 'toggleable_styles_titles',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'Here you can enter the title you want shown for this Style in the toggle menu. Make sure each takes up one line in the same order as on the left.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64155b52d8dea',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '50',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'rows' => '',
					'placeholder' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_6419cbdffab6a',
					'label' => 'Initial Style Title',
					'name' => 'initial_style_title',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64155b52d8dea',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
			),
		),
		array(
			'key' => 'field_66e210d711526',
			'label' => 'Control Menu',
			'name' => 'control_menu',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Place controls into a toggleable menu to conserve space.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_66e2112011527',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_66e2184e98e49',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_66e2112011527',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-left',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_66e2113e11528',
					'label' => 'Included Controls',
					'name' => 'included_controls',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Select the controls that will be placed inside the menu. <div class="mapster-controls-in-menu"></div>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_66e2112011527',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
			),
		),
		array(
			'key' => 'field_66cb8031a0a50',
			'label' => 'Toggler Controls (copy)',
			'name' => '',
			'aria-label' => '',
			'type' => 'accordion',
			'instructions' => '3D on/off, layer controls, style switching.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'open' => 0,
			'multi_expand' => 0,
			'endpoint' => 1,
		),
		array(
			'key' => 'field_66cb805ca0a51',
			'label' => 'Other controls',
			'name' => '',
			'aria-label' => '',
			'type' => 'accordion',
			'instructions' => 'Download data, print map, custom HTML control.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'open' => 0,
			'multi_expand' => 0,
			'endpoint' => 0,
		),
		array(
			'key' => 'field_626752b6d7c02',
			'label' => 'Download Control',
			'name' => 'download_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Allow users to download the data from your map.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_626752b6d7c03',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_626752b6d7c04',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_626752b6d7c03',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'bottom-right',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_626752cbd7c05',
					'label' => 'Interact with Filters',
					'name' => 'interact_with_filters',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'If this is turned on, the downloaded data will match any active category filters.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_626752b6d7c03',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_626760e98fdf0',
					'label' => 'Notify on Download',
					'name' => 'notify_on_download',
					'aria-label' => '',
					'type' => 'user',
					'instructions' => 'Select users to be notified when a download occurs.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_626752b6d7c03',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'role' => '',
					'allow_null' => 1,
					'multiple' => 1,
					'return_format' => 'id',
					'bidirectional_target' => array(
					),
				),
				array(
					'key' => 'field_642dccafab983',
					'label' => 'Included Fields',
					'name' => 'included_fields',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'Enter fields to include in download CSV by entering them here, separated by commas. By default all fields are included. To easily find the field names you want, download the full CSV first.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_626752b6d7c03',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'rows' => '',
					'placeholder' => 'id,geography,etc',
					'new_lines' => '',
				),
			),
		),
		array(
			'key' => 'field_6673d063a1a32',
			'label' => 'Print Control',
			'name' => 'print_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Allows users to print a simple static image of your map.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6673d063a1a33',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_6673d063a1a34',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6673d063a1a33',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'maplibre',
							),
						),
						array(
							array(
								'field' => 'field_6673d063a1a33',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '==',
								'value' => 'mapbox',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'bottom-right',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
			),
		),
		array(
			'key' => 'field_62d81c54ff321',
			'label' => 'Custom HTML Control',
			'name' => 'custom_html_control',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Add any HTML and CSS you want into a custom control.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_62d81c54ff322',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_62d81c54ff323',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62d81c54ff322',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'bottom-right',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_62d81c7fff327',
					'label' => 'Custom HTML',
					'name' => 'custom_html',
					'aria-label' => '',
					'type' => 'acf_code_field',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62d81c54ff322',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'mode' => 'htmlmixed',
					'theme' => 'monokai',
				),
			),
		),
		array(
			'key' => 'field_66cb8074a0a52',
			'label' => 'Other controls (copy)',
			'name' => '',
			'aria-label' => '',
			'type' => 'accordion',
			'instructions' => 'Download data, print map, custom HTML control.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'open' => 0,
			'multi_expand' => 0,
			'endpoint' => 1,
		),
		array(
			'key' => 'field_66cca5f0c567e',
			'label' => 'Control Order',
			'name' => 'control_order',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Drag activated controls to ensure they load in the order that you want.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span><div class="mapster-reorder-controls"></div>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'maplibre',
					),
				),
				array(
					array(
						'field' => 'field_61636c71d48e1',
						'operator' => '==',
						'value' => 'mapbox',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_616372615390b',
			'label' => 'Filters',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_616769a697bdd',
			'label' => 'Filters',
			'name' => 'filter',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Enabling filters will allow users to search through and/or change the visibility of features on your map.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_61676c30af8b3',
					'label' => 'Category Filter',
					'name' => 'category_filter',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => 'Add a control panel that lists the categories of your features as toggles. All categories attached to your features will be included.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_61676c53af8b4',
							'label' => 'Enable',
							'name' => 'enable',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_616c512ca1b1c',
							'label' => 'Category Display',
							'name' => 'category_display',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => 'You can add a color or icon to each category in the Categories section, and have them appear beside the category in the list.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676c53af8b4',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'none' => 'None',
								'colors' => 'Colors',
								'icons' => 'icons',
							),
							'default_value' => 'none',
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_616c5174a1b1d',
							'label' => 'Checkbox Display',
							'name' => 'checkbox_display',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676c53af8b4',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'switch' => 'Switch',
								'checkbox' => 'Checkbox',
							),
							'default_value' => 'switch',
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_61676c5daf8b5',
							'label' => 'Position',
							'name' => 'position',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676c53af8b4',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'top-right' => 'Top Right',
								'top-left' => 'Top Left',
								'bottom-right' => 'Bottom Right',
								'bottom-left' => 'Bottom Left',
							),
							'default_value' => 'top-right',
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_625323af2535d',
							'label' => 'Advanced Options',
							'name' => 'advanced_enable',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'More complex options for filtering.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_647f7026835c7',
							'label' => 'Show Number of Features',
							'name' => 'show_number_of_features',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Show the total number of features in a category in parentheses beside the category label.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_61fc4a03a4c32',
							'label' => 'Functionality',
							'name' => 'functionality',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => 'Inclusive means that if a feature has any category active, it will appear. Exclusive means that if a feature has any category inactive, it will disappear. This applies to features with multiple categories.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'inclusive' => 'Inclusive',
								'exclusive' => 'Exclusive',
							),
							'default_value' => 'inclusive',
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_6230c99834a01',
							'label' => 'Independent Children',
							'name' => 'independent_children',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Allow child categories to be toggled without affecting the parent category\'s visibility.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_6807f95f0ed11',
							'label' => 'Parent Category Display',
							'name' => 'parent_cat_display',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => 'By default, parents and children both have checkboxes. You can hide top-level checkboxes with this if you choose.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'default' => 'Default',
								'hide_check' => 'Hide Parent Toggle',
							),
							'default_value' => 'default',
							'return_format' => 'value',
							'multiple' => 0,
							'allow_null' => 0,
							'allow_in_bindings' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_63f2a5495b3db',
							'label' => 'Excluded Categories',
							'name' => 'excluded_categories',
							'aria-label' => '',
							'type' => 'taxonomy',
							'instructions' => 'Choose categories to hide from the category filter. Note that excluding a parent category will also cause its child categories to be hidden.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'taxonomy' => 'wp-map-category',
							'add_term' => 0,
							'save_terms' => 0,
							'load_terms' => 0,
							'return_format' => 'id',
							'field_type' => 'multi_select',
							'allow_null' => 1,
							'multiple' => 0,
							'bidirectional_target' => array(
							),
						),
						array(
							'key' => 'field_61eca4017cd31',
							'label' => 'Initial Visibility',
							'name' => 'initial_visibility',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Start with all categories enabled or disabled.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 1,
							'ui' => 1,
							'ui_on_text' => 'Enabled',
							'ui_off_text' => 'Disabled',
						),
						array(
							'key' => 'field_61fc48396fd9a',
							'label' => 'Pre-Selected Categories',
							'name' => 'pre_selected_categories',
							'aria-label' => '',
							'type' => 'taxonomy',
							'instructions' => 'These categories will be on by default.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61eca4017cd31',
										'operator' => '!=',
										'value' => '1',
									),
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'taxonomy' => 'wp-map-category',
							'field_type' => 'multi_select',
							'allow_null' => 0,
							'add_term' => 0,
							'save_terms' => 0,
							'load_terms' => 0,
							'return_format' => 'id',
							'multiple' => 0,
							'bidirectional_target' => array(
							),
						),
						array(
							'key' => 'field_66c748c85807e',
							'label' => 'Category Order',
							'name' => 'category_order',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '<div class="mapster-reorder-categories"></div>',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'maxlength' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_66b05e864dda0',
							'label' => 'Reset Button',
							'name' => 'reset_button',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Adds a reset button to reset categories to their initial state.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676c53af8b4',
										'operator' => '==',
										'value' => '1',
									),
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_6253289a44c7f',
							'label' => 'Additional Filters',
							'name' => 'additional_filters',
							'aria-label' => '',
							'type' => 'textarea',
							'instructions' => 'You may want to include fields or feature properties in addition to categories when filtering. Enter these below using the syntax described in the <a href="https://wpmaps-docs.mapster.me/maps/filters/category-filter#additional-filters-pro" target="_blank">Mapster docs</a>. Please note this will not work in the admin preview.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'maxlength' => '',
							'allow_in_bindings' => 1,
							'rows' => '',
							'placeholder' => '',
							'new_lines' => '',
						),
						array(
							'key' => 'field_62a44a63232d9',
							'label' => 'Render in External Div',
							'name' => 'render_in_external_div',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => 'Enter a custom ID on your page to append this element into instead of putting it on the map.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_63f2eff03f140',
							'label' => 'Accordion Layout',
							'name' => 'accordion_layout',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Turn this on if you want child categories to only be visible when a parent category is opened (collapsible layout).',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625323af2535d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
					),
				),
				array(
					'key' => 'field_61676ae545cb3',
					'label' => 'Custom Search Filter',
					'name' => 'custom_search_filter',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => 'This will allow a text search (using the names and popup text you\'ve added to features) and present results to users in a clickable dropdown.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_61676a4e45cb1',
							'label' => 'Enable',
							'name' => 'enable',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_61676abb45cb2',
							'label' => 'Include Geocoder',
							'name' => 'include_geocoder',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'This will allow users to search both addresses and your feature information at once. Requires a Mapbox token.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676a4e45cb1',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_61676ed29d539',
							'label' => 'Limit Results',
							'name' => 'limit_results',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => 'Limit results to specific countries. Use 2-letter country codes, separated by commas.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676abb45cb2',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_61676ef49d53a',
							'label' => 'Position',
							'name' => 'position',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676a4e45cb1',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'top-right' => 'Top Right',
								'top-left' => 'Top Left',
								'bottom-right' => 'Bottom Right',
								'bottom-left' => 'Bottom Left',
							),
							'default_value' => 'top-left',
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_625c47e732a23',
							'label' => 'Placeholder',
							'name' => 'placeholder',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676abb45cb2',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Search',
							'placeholder' => 'Search',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_6418f26085dc2',
							'label' => 'Advanced Options',
							'name' => 'advanced_enable',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Increase results displayed and change search type.<span class="mapster-pro-text"> In <a href="https://wpmaps.mapster.me/pro">Pro</a>.</span>',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_66f7498c254f5',
							'label' => 'Limit by Bounds',
							'name' => 'limit_by_bounds',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Limit the search result more specifically by a set of coordinates.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676abb45cb2',
										'operator' => '==',
										'value' => '1',
									),
									array(
										'field' => 'field_6418f26085dc2',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'allow_in_bindings' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_66f749b8254f6',
							'label' => 'Bounds Limit',
							'name' => 'bounds_limit',
							'aria-label' => '',
							'type' => 'group',
							'instructions' => 'Enter in a SW coordinate and a NE coordinate that represent the bounds your user is allowed to pan.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676abb45cb2',
										'operator' => '==',
										'value' => '1',
									),
									array(
										'field' => 'field_6418f26085dc2',
										'operator' => '==',
										'value' => '1',
									),
									array(
										'field' => 'field_66f7498c254f5',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'block',
							'sub_fields' => array(
								array(
									'key' => 'field_66f749b8254f7',
									'label' => 'Southwest Latitude',
									'name' => 'southwest_latitude',
									'aria-label' => '',
									'type' => 'number',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'min' => -90,
									'max' => 90,
									'allow_in_bindings' => 1,
									'placeholder' => '',
									'step' => '',
									'prepend' => '',
									'append' => '',
								),
								array(
									'key' => 'field_66f749b8254f8',
									'label' => 'Southwest Longitude',
									'name' => 'southwest_longitude',
									'aria-label' => '',
									'type' => 'number',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'min' => -180,
									'max' => 180,
									'allow_in_bindings' => 1,
									'placeholder' => '',
									'step' => '',
									'prepend' => '',
									'append' => '',
								),
								array(
									'key' => 'field_66f749b8254f9',
									'label' => 'Northeast Latitude',
									'name' => 'northeast_latitude',
									'aria-label' => '',
									'type' => 'number',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'min' => -90,
									'max' => 90,
									'allow_in_bindings' => 1,
									'placeholder' => '',
									'step' => '',
									'prepend' => '',
									'append' => '',
								),
								array(
									'key' => 'field_66f749b8254fa',
									'label' => 'Northeast Longitude',
									'name' => 'northeast_longitude',
									'aria-label' => '',
									'type' => 'number',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'default_value' => '',
									'min' => -180,
									'max' => 180,
									'allow_in_bindings' => 1,
									'placeholder' => '',
									'step' => '',
									'prepend' => '',
									'append' => '',
								),
							),
						),
						array(
							'key' => 'field_641133c9ec354',
							'label' => 'Number of Results',
							'name' => 'number_of_results',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => 'Show up to this many results when the user types a search.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676a4e45cb1',
										'operator' => '==',
										'value' => '1',
									),
									array(
										'field' => 'field_6418f26085dc2',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => 5,
							'min' => 1,
							'max' => '',
							'placeholder' => '',
							'step' => 1,
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_6418f188a2332',
							'label' => 'Search Type',
							'name' => 'search_type',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676a4e45cb1',
										'operator' => '==',
										'value' => '1',
									),
									array(
										'field' => 'field_6418f26085dc2',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'exact-match' => 'Exact match',
								'any-match' => 'Any terms exist',
								'all-match' => 'All terms exist',
							),
							'default_value' => 'exact-match',
							'return_format' => '',
							'multiple' => 0,
							'allow_null' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_6899a5e727248',
							'label' => 'Embed on Separate Page',
							'name' => '',
							'aria-label' => '',
							'type' => 'message',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_6418f26085dc2',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => 'To embed this search on another page, use the shortcode below.
<div id="mapster-wp-map-external-search-filter-shortcode"></div>',
							'new_lines' => 'wpautop',
							'esc_html' => 0,
						),
					),
				),
				array(
					'key' => 'field_61676b7379238',
					'label' => 'Filter Dropdown',
					'name' => 'filter_dropdown',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => 'Present map features to users in a clickable dropdown list.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_61676ba779239',
							'label' => 'Enable',
							'name' => 'enable',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_61e82f8a5a145',
							'label' => 'Placeholder',
							'name' => 'placeholder',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676ba779239',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Click to select a place',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_61676bb57923a',
							'label' => 'Position',
							'name' => 'position',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676ba779239',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'top-right' => 'Top Right',
								'bottom-right' => 'Bottom Right',
								'top-left' => 'Top Left',
								'bottom-left' => 'Bottom Left',
							),
							'default_value' => 'top-right',
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_6687b19755367',
							'label' => 'Display Images',
							'name' => 'display_images',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Show the popup featured image above the title in the dropdown list.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676ba779239',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
					),
				),
			),
		),
		array(
			'key' => 'field_66cb619f56d5c',
			'label' => 'Lists',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_61676dc862fc5',
			'label' => 'List',
			'name' => 'list',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'This will create a clickable list of all your features -- perfect for a Store Locator.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_61676dd662fc6',
					'label' => 'Enable',
					'name' => 'enable',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_616c57feabfda',
					'label' => 'Include Geocoder',
					'name' => '',
					'aria-label' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => 'To include a geocoder for address searching, go to the "Controls" tab and add a Geocoder Control. It will interact with the list using the options below.',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),
				array(
					'key' => 'field_616c5809abfdb',
					'label' => 'Sort by Distance',
					'name' => 'sort_by_distance',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Sorts by the distance of the current map\'s center (adjusting as user searches or moves).',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_616c584aabfdc',
					'label' => 'Show Distance',
					'name' => 'show_distance',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Show distance from the map center to the shape\'s center.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_616caf7bbfac5',
					'label' => 'Units',
					'name' => 'units',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_616c584aabfdc',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'imperial' => 'Imperial',
						'metric' => 'Metric',
					),
					'default_value' => 'imperial',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_621810a38d022',
					'label' => 'Listing Type',
					'name' => 'listing_type',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'scrollable' => 'Scrollable',
						'paginate' => 'Paginate',
					),
					'default_value' => 'scrollable',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_61676e4062fc7',
					'label' => 'Number of Locations',
					'name' => 'number_of_locations',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => 'Number of locations listed on each page of results.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_621810a38d022',
								'operator' => '==',
								'value' => 'paginate',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 5,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'min' => 0,
					'max' => '',
					'step' => '',
				),
				array(
					'key' => 'field_61676e6862fc8',
					'label' => 'Position',
					'name' => 'position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-left',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_66df717426320',
					'label' => 'Render in External Div',
					'name' => 'render_in_external_div',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Enter a custom ID on your page to append this element into instead of putting it on the map.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_66fc2d8f463e3',
					'label' => 'Advanced Options',
					'name' => 'advanced_options',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Includes grouping by category and ordering options. <span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'allow_in_bindings' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_66cdf92a7ef44',
					'label' => 'List Order',
					'name' => 'list_order',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_616c5809abfdb',
								'operator' => '!=',
								'value' => '1',
							),
							array(
								'field' => 'field_66fc2d8f463e3',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'default' => 'Default',
						'title-asc' => 'Title (ascending)',
						'title-desc' => 'Title (descending)',
						'slug-asc' => 'Slug (ascending)',
						'slug-desc' => 'Slug (descending)',
						'id-asc' => 'ID (ascending)',
						'id-desc' => 'ID (descending)',
						'menu_order-asc' => 'Menu Order (ascending)',
						'menu_order-desc' => 'Menu Order (descending)',
					),
					'default_value' => 'default',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'allow_in_bindings' => 1,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_6691a56ce058c',
					'label' => 'Display Images',
					'name' => 'display_images',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Show images above titles in list.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_66fc2d8f463e3',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'allow_in_bindings' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_66cdf90b7ef43',
					'label' => 'Group by Category',
					'name' => 'group_by_category',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'This will group items in categories into accordion lists.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_66fc2d8f463e3',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'allow_in_bindings' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_620c20f680c0c',
					'label' => 'Store Locator Options',
					'name' => 'store_locator_options',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => 'Turn your list into a Store Locator.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61676dd662fc6',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_620c211180c0d',
							'label' => 'Enable',
							'name' => 'enable',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Enable a special list made for Store Locators.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61676dd662fc6',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_62195610c3e7a',
							'label' => 'Sort Hours by Day',
							'name' => 'sort_hours_by_day',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'This allows you to show days by hour starting with the current day as "Today".',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_620c211180c0d',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
					),
				),
			),
		),
		array(
			'key' => 'field_62bf85949448e',
			'label' => 'Specialty Maps',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_6424664a0053c',
			'label' => 'Map Compare',
			'name' => 'map_compare',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Create a sliding display that compares two maps and allows users to slide between them.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro">Mapster Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6424665d0053d',
					'label' => 'Enable',
					'name' => 'enable_map_slider',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '!=',
								'value' => 'google-maps',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_642469ba9d25a',
					'label' => 'Compared Map',
					'name' => 'compared_map',
					'aria-label' => '',
					'type' => 'post_object',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6424665d0053d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'post_type' => array(
						0 => 'mapster-wp-map',
					),
					'taxonomy' => '',
					'return_format' => 'id',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 1,
					'bidirectional_target' => array(
					),
				),
			),
		),
		array(
			'key' => 'field_6426681760d4c',
			'label' => 'Heatmap',
			'name' => 'heatmap',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Display points in a heatmap visualization.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro">Mapster Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6426681760d4d',
					'label' => 'Enable',
					'name' => 'enable_heatmap',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '!=',
								'value' => 'google-maps',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_64274ae2be609',
					'label' => 'Heatmap Layer',
					'name' => 'heatmap_layer',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'Select which set of points should be converted to a heatmap layout. The original points will be hidden unless you specify a zoom level for their visibility below.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6426681760d4d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'marker' => 'Markers',
						'circle' => 'Circles',
						'symbol' => 'Labels',
					),
					'default_value' => 'marker',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_64274b54be60a',
					'label' => 'Heatmap Layer Visibility',
					'name' => 'heatmap_layer_visibility',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => 'By default, your heatmap will replace the points that make it up. If you want the heatmap to fade out and your points to reappear at a certain zoom level, set that zoom level here.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6426681760d4d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'min' => 0,
					'max' => 22,
					'placeholder' => '',
					'step' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_64274bafbe60b',
					'label' => 'Heatmap Weighted Property',
					'name' => 'heatmap_weighted_property',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'If you want certain points to have more "weight" in your heatmap, type the property name here. The property must be numeric to work! View this after Publishing to see changes, and add intensity below if the changes are not noticeable enough.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6426681760d4d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_64274c04be60c',
					'label' => 'Heatmap Intensity',
					'name' => 'heatmap_intensity',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => 'Intensity increases the overall scale of your heatmap, making it more extreme.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6426681760d4d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'min' => 0,
					'max' => '',
					'placeholder' => '',
					'step' => 1,
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_64274c32be60d',
					'label' => 'Heatmap Color Range',
					'name' => 'heatmap_color_range',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'Set a series of colors, from low to high intensity, for the heatmap. You can use RGB, RGBA, or Hex code values. Each color should be on its own line. Add as many colors as you want.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6426681760d4d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'rgba(33,102,172,0)
	rgb(103,169,207)
	rgb(209,229,240)
	rgb(253,219,199)
	rgb(239,138,98)
	rgb(178,24,43)',
					'maxlength' => '',
					'rows' => '',
					'placeholder' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_64274c98be60e',
					'label' => 'Heatmap Point Radius',
					'name' => 'heatmap_point_radius',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => 'Select how large each point should be for the heatmap. Higher radius means more overlap between points.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6426681760d4d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 20,
					'min' => 0,
					'max' => '',
					'placeholder' => '',
					'step' => '',
					'prepend' => '',
					'append' => 'px',
				),
				array(
					'key' => 'field_64274cd9be60f',
					'label' => 'Heatmap Opacity',
					'name' => 'heatmap_opacity',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6426681760d4d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 100,
					'min' => 0,
					'max' => 100,
					'placeholder' => '',
					'step' => '',
					'prepend' => '',
					'append' => '%',
				),
			),
		),
		array(
			'key' => 'field_6427c5c2ad19c',
			'label' => 'Elevation Line Chart',
			'name' => 'elevation_line_chart',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6427c5c2ad19d',
					'label' => 'Enable',
					'name' => 'enable_elevation_chart',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '!=',
								'value' => 'google-maps',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_642b66d912479',
					'label' => 'Control Position',
					'name' => 'control_position',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6427c5c2ad19d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'top-right' => 'Top Right',
						'top-left' => 'Top Left',
						'bottom-right' => 'Bottom Right',
						'bottom-left' => 'Bottom Left',
					),
					'default_value' => 'top-left',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_642b6358105a6',
					'label' => 'Single Line',
					'name' => 'single_line',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'If your map is showing a single line that you want to show elevation for, turn this on. Otherwise, users will be able to mouse over lines on your map and click to see an elevation profile.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6427c5c2ad19d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_642b63ab105a7',
					'label' => 'Open on Load',
					'name' => 'open_on_load',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'If this is off, users will still be able to open the elevation profile by pressing a control button on the map.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6427c5c2ad19d',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_642b6358105a6',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_642b63e4105a8',
					'label' => 'Profile Color',
					'name' => 'profile_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => 'Color for the profile line.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6427c5c2ad19d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#333333',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_643604b33f65a',
					'label' => 'Units',
					'name' => 'units',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6427c5c2ad19d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'meters' => 'Meters / Kilometers',
						'feet' => 'Feet / Miles',
					),
					'default_value' => 'meters',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_643604d43f65b',
					'label' => 'Show Line Length',
					'name' => 'show_line_length',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6427c5c2ad19d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
			),
		),
		array(
			'key' => 'field_62bfee9772b97',
			'label' => 'Submission',
			'name' => 'submission',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Allow users to submit points to your map and site.<span class="mapster-pro-text"> This feature is available in Mapster WP Maps Pro.</span> Once you\'ve installed Pro, make sure you turn on the "User Submission" switch in Advanced Options in Mapster WP Settings.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_62bf86449448f',
					'label' => 'Enable Submission',
					'name' => 'enable_submission',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Enable users to submit points to this map.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_62bfe60f7fe4e',
					'label' => 'Submission Interface',
					'name' => 'submission_interface',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62bf86449448f',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_62bfe7e97fe51',
							'label' => 'Categories',
							'name' => 'categories',
							'aria-label' => '',
							'type' => 'taxonomy',
							'instructions' => 'Select categories for users to choose from when creating their point.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'taxonomy' => 'wp-map-category',
							'field_type' => 'multi_select',
							'allow_null' => 0,
							'add_term' => 0,
							'save_terms' => 0,
							'load_terms' => 0,
							'return_format' => 'id',
							'multiple' => 0,
							'bidirectional_target' => array(
							),
						),
						array(
							'key' => 'field_62bf884694493',
							'label' => 'Include Address Search',
							'name' => 'include_address_search',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Allow users to search for a location using a geocoded address.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_62bf886b94494',
							'label' => 'Mapbox Geocoder Access Token',
							'name' => 'mapbox_geocoder_access_token',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_62bf884694493',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62bfe6a97fe4f',
							'label' => 'Title Field',
							'name' => 'title_field',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => 'Enter an ACF field attached to the User Submission post type that should be used as the title.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'maxlength' => '',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_62bf86b094491',
							'label' => 'Submission Button Shortcode',
							'name' => '',
							'aria-label' => '',
							'type' => 'message',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => 'Place shortcodes on the same page as your map wherever you want add or edit buttons. To change other verbiage and phrases, use a translation plugin like WPML to edit the plugin strings.

	<strong>Options:</strong>
	type = "create_point" OR "edit_point"
	button_text, header_text = "custom text"
	modal_size = "sm" OR "lg"',
							'new_lines' => 'wpautop',
							'esc_html' => 0,
						),
					),
				),
				array(
					'key' => 'field_62c35713fc0b6',
					'label' => 'Administration',
					'name' => 'administration',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62bf86449448f',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_62d709e7ac3ed',
							'label' => 'Allowed Area',
							'name' => 'allowed_area',
							'aria-label' => '',
							'type' => 'post_object',
							'instructions' => 'Only allow users to submit points within the area of an allowed polygon. This polygon will not visually appear on the map unless added separately.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'post_type' => array(
								0 => 'mapster-wp-polygon',
							),
							'taxonomy' => '',
							'allow_null' => 1,
							'multiple' => 0,
							'return_format' => 'id',
							'ui' => 1,
							'bidirectional_target' => array(
							),
						),
						array(
							'key' => 'field_62c358aa7ca2c',
							'label' => 'Template Post',
							'name' => 'template_post',
							'aria-label' => '',
							'type' => 'post_object',
							'instructions' => 'Select a template feature that will serve as a stylistic base for user submissions.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_62d98e5d41b0c',
										'operator' => '!=',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'post_type' => array(
								0 => 'mapster-wp-location',
							),
							'taxonomy' => '',
							'allow_null' => 0,
							'multiple' => 0,
							'return_format' => 'id',
							'ui' => 1,
							'bidirectional_target' => array(
							),
						),
						array(
							'key' => 'field_62d98ecf98a9c',
							'label' => 'Template Posts',
							'name' => 'template_posts',
							'aria-label' => '',
							'type' => 'post_object',
							'instructions' => 'Select multiple template features that will serve as stylistic bases for user submissions. These must be arranged in a matching order with the categories you\'ve selected.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_62d98e5d41b0c',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'post_type' => array(
								0 => 'mapster-wp-location',
							),
							'taxonomy' => '',
							'allow_null' => 0,
							'multiple' => 1,
							'return_format' => 'id',
							'ui' => 1,
							'bidirectional_target' => array(
							),
						),
						array(
							'key' => 'field_62d98e5d41b0c',
							'label' => 'Multiple Templates',
							'name' => 'multiple_templates',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Select different templates for each category?',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '30',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_62ed3320bbab0',
							'label' => 'Show all languages on one map',
							'name' => 'show_all_languages_on_one_map',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'For more about managing maps with WPML, read <a href="https://wpmaps-docs.mapster.me/developer/internationalization">the docs</a>.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'allow_in_bindings' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_62bfeae7520a6',
							'label' => 'Notify Users',
							'name' => 'notify_users',
							'aria-label' => '',
							'type' => 'user',
							'instructions' => 'Select users who will be notified by email when a new post is submitted.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_62bf86449448f',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'role' => '',
							'allow_null' => 0,
							'multiple' => 1,
							'return_format' => 'id',
							'bidirectional_target' => array(
							),
						),
						array(
							'key' => 'field_62bfeb687b5ee',
							'label' => 'Submission Permissions',
							'name' => 'permissions',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'public' => 'Public',
								'private' => 'Logged in only',
								'admin' => 'Admin only',
							),
							'default_value' => false,
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_62f129760185a',
							'label' => 'Editing Permissions',
							'name' => 'editing_permissions',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'public' => 'Public',
								'user' => 'User can only edit own submissions',
								'private' => 'Logged in only',
								'admin' => 'Admin only',
							),
							'default_value' => false,
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_62c35758fc0b7',
							'label' => 'Publish Immediately',
							'name' => 'publish_immediately',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Choose whether new submitted posts will be published immediately or saved as drafts.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
					),
				),
				array(
					'key' => 'field_62ee83084d697',
					'label' => 'Custom Texts',
					'name' => 'custom_texts',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_62bf86449448f',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_62ee83574d699',
							'label' => 'Add Point Text',
							'name' => 'add_point_text',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Add Point to Map',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee84fc18ec3',
							'label' => 'Choose How',
							'name' => 'choose_how',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Choose how to add your point.',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee851318ec4',
							'label' => 'Address Search',
							'name' => 'address_search',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Address Search',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee854818ec5',
							'label' => 'Map Click',
							'name' => 'map_click',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Map Click',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee856618ec6',
							'label' => 'Search Location',
							'name' => 'search_location',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Search for a location',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee85a118ec7',
							'label' => 'Selection Saved',
							'name' => 'selection_saved',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Your selection is saved.',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee85af18ec8',
							'label' => 'Selection Error',
							'name' => 'selection_error',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'You selected a point outside the allowed area. Please try again.',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee85c318ec9',
							'label' => 'Try Again',
							'name' => 'try_again',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Try again',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee85d618eca',
							'label' => 'Confirm',
							'name' => 'confirm',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Confirm',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee85de18ecb',
							'label' => 'Capture point',
							'name' => 'capture_point',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Capture Point',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee85fc18ecc',
							'label' => 'Drag Zoom',
							'name' => 'drag_zoom',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Drag and zoom map as needed',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee861818ecd',
							'label' => 'No Permissions',
							'name' => 'no_permissions',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Sorry, you don\'t have permissions to add or edit points.',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee863518ecf',
							'label' => 'Change Map Location',
							'name' => 'change_map_location',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Change Map Location',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee864618ed0',
							'label' => 'Back',
							'name' => 'back',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Back to map',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee865218ed1',
							'label' => 'Save',
							'name' => 'save',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Save',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee866218ed2',
							'label' => 'Submit',
							'name' => 'submit',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Submit',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_62ee866d18ed3',
							'label' => 'Thanks',
							'name' => 'thanks',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '33',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Thanks for your submission.',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
					),
				),
			),
		),
		array(
			'key' => 'field_6507ba2f30537',
			'label' => 'Listing Page',
			'name' => 'listing_page',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Create a map that lists posts beside it, which will cause an effect to happen when those posts are hovered over. See <a href="https://wpmaps-docs.mapster.me/maps/specialty-maps/listing-page-map" target="_blank">the documentation for help.</a> <span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro">Mapster Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6507ba2f30538',
					'label' => 'Enable',
					'name' => 'enable_listing_page',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61636c71d48e1',
								'operator' => '!=',
								'value' => 'google-maps',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_6507ba6e3053a',
					'label' => 'Listings Shortcode',
					'name' => '',
					'aria-label' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6507ba2f30538',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),
				array(
					'key' => 'field_65086c665044a',
					'label' => 'Options',
					'name' => 'options',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6507ba2f30538',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_650b762d57889',
							'label' => 'Listing Style',
							'name' => 'listing_style',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => 'Select a way for your listings to show. If titles, just text will be listed (as links). If image grid, make sure you have standardized featured images on all your posts!',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'title_list' => 'Title List',
								'grid_list' => 'Image Grid',
								'custom_html' => 'Custom HTML',
							),
							'default_value' => 'title_list',
							'return_format' => 'value',
							'multiple' => 0,
							'allow_null' => 0,
							'allow_in_bindings' => 1,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_650b7712503db',
							'label' => 'Show Titles on Images',
							'name' => 'show_titles_on_images',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_650b762d57889',
										'operator' => '==',
										'value' => 'grid_list',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_6805668842795',
							'label' => 'Listing Container Custom Class',
							'name' => 'listing_container_class',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => 'Add your own class to the container of the listings, so you can add grid or flex as you want.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_650b762d57889',
										'operator' => '==',
										'value' => 'custom_html',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'maxlength' => '',
							'allow_in_bindings' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_6803cb7b93442',
							'label' => 'Custom Listing HTML',
							'name' => 'custom_listing_html',
							'aria-label' => '',
							'type' => 'acf_code_field',
							'instructions' => 'Enter the custom HTML for each item here. You can use the tags {title}, {image_url}, {link}, and {date} to have those elements be inserted dynamically.',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_650b762d57889',
										'operator' => '==',
										'value' => 'custom_html',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'placeholder' => '',
							'mode' => 'htmlmixed',
							'theme' => 'monokai',
							'allow_in_bindings' => 0,
						),
						array(
							'key' => 'field_67b69837c567d',
							'label' => 'Listings Order',
							'name' => 'listings_order',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'post_order' => 'Post Order (ascending)',
								'post_order_desc' => 'Post Order (descending)',
								'alphabetical' => 'Alphabetical (ascending)',
								'alphabetical_desc' => 'Alphabetical (descending)',
								'date' => 'Date (ascending)',
								'date_desc' => 'Date (descending)',
							),
							'default_value' => 'post_order',
							'return_format' => 'value',
							'multiple' => 0,
							'allow_null' => 0,
							'allow_in_bindings' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_6803caed93441',
							'label' => 'Interaction Event',
							'name' => 'interaction_event',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'hover' => 'Hover',
								'click' => 'Click',
							),
							'default_value' => 'hover',
							'return_format' => 'value',
							'multiple' => 0,
							'allow_null' => 0,
							'allow_in_bindings' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_65086ca25044c',
							'label' => 'Center on Interaction',
							'name' => 'center_on_hover',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Center the map when posts are hovered over or clicked.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'allow_in_bindings' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_68656092bfc55',
							'label' => 'Open Popup on Interaction',
							'name' => 'popup_on_hover',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Open relevant popup when posts are hovered over or clicked.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'allow_in_bindings' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_65086c2350449',
							'label' => 'Lazy Load',
							'name' => 'lazy_load',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Load listings only as the user scrolls down the page.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_65565d4a40d6a',
							'label' => 'Sticky Map',
							'name' => 'sticky_map',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'The map will stick on the screen as the user scrolls through the listings.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_6803cc1b93443',
							'label' => 'Link Destination',
							'name' => 'link_destination',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => 'Note: if you select "Post Category", it will use the first category on the post.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'post' => 'Post',
								'post_type' => 'Post Type',
								'post_category' => 'Post Category',
								'none' => 'Don\'t Open Link',
							),
							'default_value' => 'post',
							'return_format' => 'value',
							'multiple' => 0,
							'allow_null' => 0,
							'allow_in_bindings' => 0,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_67b697769be74',
							'label' => 'Links Open in New Window',
							'name' => 'links_in_new_window',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 1,
							'allow_in_bindings' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_67b699814e7e0',
							'label' => 'Reset Zoom on Mouseout',
							'name' => 'reset_zoom_on_mouseout',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 1,
							'allow_in_bindings' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
					),
				),
			),
		),
		array(
			'key' => 'field_66ca9fe2d5985',
			'label' => 'Preloader',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_66c8efa8f82fe',
			'label' => 'Loading',
			'name' => 'loading',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Customize the loading graphic for your map.<span class="mapster-pro-text"> Available in <a href="wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_66c8efc6f82ff',
					'label' => 'Loading Graphic',
					'name' => 'loading_graphic',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'Select a preset loading graphic (from <a href="https://samherbert.net/svg-loaders/" target="_blank">https://samherbert.net/svg-loaders/</a>). Upload your own by selecting custom.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'<svg width="55" height="80" viewBox="0 0 55 80" xmlns="http://www.w3.org/2000/svg" fill="#FFF"> <g transform="matrix(1 0 0 -1 0 80)"> <rect width="10" height="20" rx="3"> <animate attributeName="height" begin="0s" dur="4.3s" values="20;45;57;80;64;32;66;45;64;23;66;13;64;56;34;34;2;23;76;79;20" calcMode="linear" repeatCount="indefinite" /> </rect> <rect x="15" width="10" height="80" rx="3"> <animate attributeName="height" begin="0s" dur="2s" values="80;55;33;5;75;23;73;33;12;14;60;80" calcMode="linear" repeatCount="indefinite" /> </rect> <rect x="30" width="10" height="50" rx="3"> <animate attributeName="height" begin="0s" dur="1.4s" values="50;34;78;23;56;23;34;76;80;54;21;50" calcMode="linear" repeatCount="indefinite" /> </rect> <rect x="45" width="10" height="30" rx="3"> <animate attributeName="height" begin="0s" dur="2s" values="30;45;13;80;56;72;45;76;34;23;67;30" calcMode="linear" repeatCount="indefinite" /> </rect> </g> </svg>' => 'Audio',
						'<svg width="57" height="57" viewBox="0 0 57 57" xmlns="http://www.w3.org/2000/svg" stroke="#fff"> <g fill="none" fill-rule="evenodd"> <g transform="translate(1 1)" stroke-width="2"> <circle cx="5" cy="50" r="5"> <animate attributeName="cy" begin="0s" dur="2.2s" values="50;5;50;50" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="cx" begin="0s" dur="2.2s" values="5;27;49;5" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="27" cy="5" r="5"> <animate attributeName="cy" begin="0s" dur="2.2s" from="5" to="5" values="5;50;50;5" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="cx" begin="0s" dur="2.2s" from="27" to="27" values="27;49;5;27" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="49" cy="50" r="5"> <animate attributeName="cy" begin="0s" dur="2.2s" values="50;50;5;50" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="cx" from="49" to="49" begin="0s" dur="2.2s" values="49;5;27;49" calcMode="linear" repeatCount="indefinite" /> </circle> </g> </g> </svg>' => 'Ball Triangle',
						'<svg width="135" height="140" viewBox="0 0 135 140" xmlns="http://www.w3.org/2000/svg" fill="#fff"> <rect y="10" width="15" height="120" rx="6"> <animate attributeName="height" begin="0.5s" dur="1s" values="120;110;100;90;80;70;60;50;40;140;120" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="y" begin="0.5s" dur="1s" values="10;15;20;25;30;35;40;45;50;0;10" calcMode="linear" repeatCount="indefinite" /> </rect> <rect x="30" y="10" width="15" height="120" rx="6"> <animate attributeName="height" begin="0.25s" dur="1s" values="120;110;100;90;80;70;60;50;40;140;120" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="y" begin="0.25s" dur="1s" values="10;15;20;25;30;35;40;45;50;0;10" calcMode="linear" repeatCount="indefinite" /> </rect> <rect x="60" width="15" height="140" rx="6"> <animate attributeName="height" begin="0s" dur="1s" values="120;110;100;90;80;70;60;50;40;140;120" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="y" begin="0s" dur="1s" values="10;15;20;25;30;35;40;45;50;0;10" calcMode="linear" repeatCount="indefinite" /> </rect> <rect x="90" y="10" width="15" height="120" rx="6"> <animate attributeName="height" begin="0.25s" dur="1s" values="120;110;100;90;80;70;60;50;40;140;120" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="y" begin="0.25s" dur="1s" values="10;15;20;25;30;35;40;45;50;0;10" calcMode="linear" repeatCount="indefinite" /> </rect> <rect x="120" y="10" width="15" height="120" rx="6"> <animate attributeName="height" begin="0.5s" dur="1s" values="120;110;100;90;80;70;60;50;40;140;120" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="y" begin="0.5s" dur="1s" values="10;15;20;25;30;35;40;45;50;0;10" calcMode="linear" repeatCount="indefinite" /> </rect> </svg>' => 'Bars',
						'<svg width="135" height="135" viewBox="0 0 135 135" xmlns="http://www.w3.org/2000/svg" fill="#fff"> <path d="M67.447 58c5.523 0 10-4.477 10-10s-4.477-10-10-10-10 4.477-10 10 4.477 10 10 10zm9.448 9.447c0 5.523 4.477 10 10 10 5.522 0 10-4.477 10-10s-4.478-10-10-10c-5.523 0-10 4.477-10 10zm-9.448 9.448c-5.523 0-10 4.477-10 10 0 5.522 4.477 10 10 10s10-4.478 10-10c0-5.523-4.477-10-10-10zM58 67.447c0-5.523-4.477-10-10-10s-10 4.477-10 10 4.477 10 10 10 10-4.477 10-10z"> <animateTransform attributeName="transform" type="rotate" from="0 67 67" to="-360 67 67" dur="2.5s" repeatCount="indefinite"/> </path> <path d="M28.19 40.31c6.627 0 12-5.374 12-12 0-6.628-5.373-12-12-12-6.628 0-12 5.372-12 12 0 6.626 5.372 12 12 12zm30.72-19.825c4.686 4.687 12.284 4.687 16.97 0 4.686-4.686 4.686-12.284 0-16.97-4.686-4.687-12.284-4.687-16.97 0-4.687 4.686-4.687 12.284 0 16.97zm35.74 7.705c0 6.627 5.37 12 12 12 6.626 0 12-5.373 12-12 0-6.628-5.374-12-12-12-6.63 0-12 5.372-12 12zm19.822 30.72c-4.686 4.686-4.686 12.284 0 16.97 4.687 4.686 12.285 4.686 16.97 0 4.687-4.686 4.687-12.284 0-16.97-4.685-4.687-12.283-4.687-16.97 0zm-7.704 35.74c-6.627 0-12 5.37-12 12 0 6.626 5.373 12 12 12s12-5.374 12-12c0-6.63-5.373-12-12-12zm-30.72 19.822c-4.686-4.686-12.284-4.686-16.97 0-4.686 4.687-4.686 12.285 0 16.97 4.686 4.687 12.284 4.687 16.97 0 4.687-4.685 4.687-12.283 0-16.97zm-35.74-7.704c0-6.627-5.372-12-12-12-6.626 0-12 5.373-12 12s5.374 12 12 12c6.628 0 12-5.373 12-12zm-19.823-30.72c4.687-4.686 4.687-12.284 0-16.97-4.686-4.686-12.284-4.686-16.97 0-4.687 4.686-4.687 12.284 0 16.97 4.686 4.687 12.284 4.687 16.97 0z"> <animateTransform attributeName="transform" type="rotate" from="0 67 67" to="360 67 67" dur="8s" repeatCount="indefinite"/> </path> </svg>' => 'Circles',
						'<svg width="105" height="105" viewBox="0 0 105 105" xmlns="http://www.w3.org/2000/svg" fill="#fff"> <circle cx="12.5" cy="12.5" r="12.5"> <animate attributeName="fill-opacity" begin="0s" dur="1s" values="1;.2;1" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="12.5" cy="52.5" r="12.5" fill-opacity=".5"> <animate attributeName="fill-opacity" begin="100ms" dur="1s" values="1;.2;1" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="52.5" cy="12.5" r="12.5"> <animate attributeName="fill-opacity" begin="300ms" dur="1s" values="1;.2;1" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="52.5" cy="52.5" r="12.5"> <animate attributeName="fill-opacity" begin="600ms" dur="1s" values="1;.2;1" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="92.5" cy="12.5" r="12.5"> <animate attributeName="fill-opacity" begin="800ms" dur="1s" values="1;.2;1" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="92.5" cy="52.5" r="12.5"> <animate attributeName="fill-opacity" begin="400ms" dur="1s" values="1;.2;1" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="12.5" cy="92.5" r="12.5"> <animate attributeName="fill-opacity" begin="700ms" dur="1s" values="1;.2;1" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="52.5" cy="92.5" r="12.5"> <animate attributeName="fill-opacity" begin="500ms" dur="1s" values="1;.2;1" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="92.5" cy="92.5" r="12.5"> <animate attributeName="fill-opacity" begin="200ms" dur="1s" values="1;.2;1" calcMode="linear" repeatCount="indefinite" /> </circle> </svg>' => 'Grid',
						'<svg width="38" height="38" viewBox="0 0 38 38" xmlns="http://www.w3.org/2000/svg" stroke="#fff"> <g fill="none" fill-rule="evenodd"> <g transform="translate(1 1)" stroke-width="2"> <circle stroke-opacity=".5" cx="18" cy="18" r="18"/> <path d="M36 18c0-9.94-8.06-18-18-18"> <animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur="1s" repeatCount="indefinite"/> </path> </g> </g> </svg>' => 'Oval',
						'<svg width="44" height="44" viewBox="0 0 44 44" xmlns="http://www.w3.org/2000/svg" stroke="#fff"> <g fill="none" fill-rule="evenodd" stroke-width="2"> <circle cx="22" cy="22" r="1"> <animate attributeName="r" begin="0s" dur="1.8s" values="1; 20" calcMode="spline" keyTimes="0; 1" keySplines="0.165, 0.84, 0.44, 1" repeatCount="indefinite" /> <animate attributeName="stroke-opacity" begin="0s" dur="1.8s" values="1; 0" calcMode="spline" keyTimes="0; 1" keySplines="0.3, 0.61, 0.355, 1" repeatCount="indefinite" /> </circle> <circle cx="22" cy="22" r="1"> <animate attributeName="r" begin="-0.9s" dur="1.8s" values="1; 20" calcMode="spline" keyTimes="0; 1" keySplines="0.165, 0.84, 0.44, 1" repeatCount="indefinite" /> <animate attributeName="stroke-opacity" begin="-0.9s" dur="1.8s" values="1; 0" calcMode="spline" keyTimes="0; 1" keySplines="0.3, 0.61, 0.355, 1" repeatCount="indefinite" /> </circle> </g> </svg>' => 'Puff',
						'<svg width="45" height="45" viewBox="0 0 45 45" xmlns="http://www.w3.org/2000/svg" stroke="#fff"> <g fill="none" fill-rule="evenodd" transform="translate(1 1)" stroke-width="2"> <circle cx="22" cy="22" r="6" stroke-opacity="0"> <animate attributeName="r" begin="1.5s" dur="3s" values="6;22" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="stroke-opacity" begin="1.5s" dur="3s" values="1;0" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="stroke-width" begin="1.5s" dur="3s" values="2;0" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="22" cy="22" r="6" stroke-opacity="0"> <animate attributeName="r" begin="3s" dur="3s" values="6;22" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="stroke-opacity" begin="3s" dur="3s" values="1;0" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="stroke-width" begin="3s" dur="3s" values="2;0" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="22" cy="22" r="8"> <animate attributeName="r" begin="0s" dur="1.5s" values="6;1;2;3;4;5;6" calcMode="linear" repeatCount="indefinite" /> </circle> </g> </svg>' => 'Rings',
						'<svg width="58" height="58" viewBox="0 0 58 58" xmlns="http://www.w3.org/2000/svg"> <g fill="none" fill-rule="evenodd"> <g transform="translate(2 1)" stroke="#FFF" stroke-width="1.5"> <circle cx="42.601" cy="11.462" r="5" fill-opacity="1" fill="#fff"> <animate attributeName="fill-opacity" begin="0s" dur="1.3s" values="1;0;0;0;0;0;0;0" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="49.063" cy="27.063" r="5" fill-opacity="0" fill="#fff"> <animate attributeName="fill-opacity" begin="0s" dur="1.3s" values="0;1;0;0;0;0;0;0" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="42.601" cy="42.663" r="5" fill-opacity="0" fill="#fff"> <animate attributeName="fill-opacity" begin="0s" dur="1.3s" values="0;0;1;0;0;0;0;0" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="27" cy="49.125" r="5" fill-opacity="0" fill="#fff"> <animate attributeName="fill-opacity" begin="0s" dur="1.3s" values="0;0;0;1;0;0;0;0" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="11.399" cy="42.663" r="5" fill-opacity="0" fill="#fff"> <animate attributeName="fill-opacity" begin="0s" dur="1.3s" values="0;0;0;0;1;0;0;0" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="4.938" cy="27.063" r="5" fill-opacity="0" fill="#fff"> <animate attributeName="fill-opacity" begin="0s" dur="1.3s" values="0;0;0;0;0;1;0;0" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="11.399" cy="11.462" r="5" fill-opacity="0" fill="#fff"> <animate attributeName="fill-opacity" begin="0s" dur="1.3s" values="0;0;0;0;0;0;1;0" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="27" cy="5" r="5" fill-opacity="0" fill="#fff"> <animate attributeName="fill-opacity" begin="0s" dur="1.3s" values="0;0;0;0;0;0;0;1" calcMode="linear" repeatCount="indefinite" /> </circle> </g> </g> </svg>' => 'Spinning Circles',
						'<svg width="38" height="38" viewBox="0 0 38 38" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient x1="8.042%" y1="0%" x2="65.682%" y2="23.865%" id="a"> <stop stop-color="#fff" stop-opacity="0" offset="0%"/> <stop stop-color="#fff" stop-opacity=".631" offset="63.146%"/> <stop stop-color="#fff" offset="100%"/> </linearGradient> </defs> <g fill="none" fill-rule="evenodd"> <g transform="translate(1 1)"> <path d="M36 18c0-9.94-8.06-18-18-18" id="Oval-2" stroke="url(#a)" stroke-width="2"> <animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur="0.9s" repeatCount="indefinite" /> </path> <circle fill="#fff" cx="36" cy="18" r="1"> <animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur="0.9s" repeatCount="indefinite" /> </circle> </g> </g> </svg>' => 'Tail Spin',
						'<svg width="120" height="30" viewBox="0 0 120 30" xmlns="http://www.w3.org/2000/svg" fill="#fff"> <circle cx="15" cy="15" r="15"> <animate attributeName="r" from="15" to="15" begin="0s" dur="0.8s" values="15;9;15" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="fill-opacity" from="1" to="1" begin="0s" dur="0.8s" values="1;.5;1" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="60" cy="15" r="9" fill-opacity="0.3"> <animate attributeName="r" from="9" to="9" begin="0s" dur="0.8s" values="9;15;9" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="fill-opacity" from="0.5" to="0.5" begin="0s" dur="0.8s" values=".5;1;.5" calcMode="linear" repeatCount="indefinite" /> </circle> <circle cx="105" cy="15" r="15"> <animate attributeName="r" from="15" to="15" begin="0s" dur="0.8s" values="15;9;15" calcMode="linear" repeatCount="indefinite" /> <animate attributeName="fill-opacity" from="1" to="1" begin="0s" dur="0.8s" values="1;.5;1" calcMode="linear" repeatCount="indefinite" /> </circle> </svg>' => 'Three Dots',
						'custom' => 'Custom',
					),
					'default_value' => '<svg width="38" height="38" viewBox="0 0 38 38" xmlns="http://www.w3.org/2000/svg" stroke="#fff"> <g fill="none" fill-rule="evenodd"> <g transform="translate(1 1)" stroke-width="2"> <circle stroke-opacity=".5" cx="18" cy="18" r="18"/> <path d="M36 18c0-9.94-8.06-18-18-18"> <animateTransform attributeName="transform" type="rotate" from="0 18 18" to="360 18 18" dur="1s" repeatCount="indefinite"/> </path> </g> </g> </svg>',
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_66c97df729540',
					'label' => 'Custom Loader',
					'name' => 'custom_loader',
					'aria-label' => '',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_66c8efc6f82ff',
								'operator' => '==',
								'value' => 'custom',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'url',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
					'preview_size' => 'medium',
				),
				array(
					'key' => 'field_66c8f08ff8300',
					'label' => 'Background Color',
					'name' => 'background_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'rgba(255,255,255,0.6)',
					'enable_opacity' => 1,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_66c9796cf39d9',
					'label' => 'Loader Color',
					'name' => 'loader_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_66c8efc6f82ff',
								'operator' => '!=',
								'value' => 'custom',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'rgba(0, 0, 0, 0.3)',
					'enable_opacity' => 1,
					'return_format' => 'string',
				),
			),
		),
		array(
			'key' => 'field_61ae3c8d5599d',
			'label' => 'Developer',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'left',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_61ae3ca05599e',
			'label' => 'Javascript',
			'name' => 'javascript',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Add the name of a Javascript function you want to run after the map initializes. This function must be global. It will be given a "map" variable and a "features" variable, with which you can create more custom functionality or sidebar lists, etc.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_625df58b28054',
			'label' => 'Embed',
			'name' => 'embed',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Share your map so other websites can embed it.<span class="mapster-pro-text"> Available in <a href=\'https://wpmaps.mapster.me/pro\' target=\'_blank\'>Mapster WP Maps Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_625df47b6416b',
					'label' => 'Allow Embed',
					'name' => 'allow_embed',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_625df5497461d',
					'label' => 'Protect Embed',
					'name' => 'protect_embed',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Turn this on if you want to control which websites can embed your map.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625df47b6416b',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_625df4cd6416c',
					'label' => 'Allowed Origins',
					'name' => 'allowed_origins',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'Enter each URL origin on a new line. Make sure you include the full URL of the root website (ie, https://mapster.me). See the <a href="https://wpmaps-docs.mapster.me/maps/developer/embedding-maps" target="_blank">Mapster docs</a> for more information.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625df5497461d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'allow_in_bindings' => 1,
					'rows' => '',
					'placeholder' => '',
					'new_lines' => '',
				),
				array(
					'key' => 'field_625df5ebf4ecc',
					'label' => 'Embed Code',
					'name' => '',
					'aria-label' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625df47b6416b',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'new_lines' => 'wpautop',
					'esc_html' => 1,
				),
			),
		),
		array(
			'key' => 'field_64d6d1fe65fb2',
			'label' => 'Cache',
			'name' => 'cache',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'If your map has a ton of features (1000+), this will pre-generate a file that the frontend will load, significantly speeding up loading time. You must manually refresh this anytime you make a change to a feature loaded on this map or the map options.<span class="mapster-pro-text"> Available in <a href=\'https://wpmaps.mapster.me/pro\' target=\'_blank\'>Mapster WP Maps Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_64d6d2ae41b81',
					'label' => 'Use Cache',
					'name' => 'use_cache',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_64d6d24765fb7',
					'label' => 'Generate Cache',
					'name' => 'generate_cache',
					'aria-label' => '',
					'type' => 'button_group',
					'instructions' => 'Press this to regenerate the cache file for this map. Make sure to "Update" and save your map first, and only after you save, then press this!',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_64d6d2ae41b81',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'Refresh Cached Response' => 'Refresh Cached Response',
					),
					'default_value' => '',
					'return_format' => 'value',
					'allow_null' => 0,
					'layout' => 'horizontal',
				),
			),
		),
		array(
			'key' => 'field_66e08625e320a',
			'label' => 'Progressive Loading',
			'name' => 'progressive_loading',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Using this will only load in features that are visible within the map bounds, up to a maximum number of features at a time. These will update as the user zooms and scrolls. This can give you greater control over showing very large datasets on your map. Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_66e08681e320b',
					'label' => 'Enabled',
					'name' => 'enabled',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_66e086a0e320c',
					'label' => 'Number of Features to Load',
					'name' => 'number_of_features',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => 'Enter the number of features that the map should load into the visible screen.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_66e08681e320b',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 100,
					'min' => 0,
					'max' => '',
					'placeholder' => '',
					'step' => 1,
					'prepend' => '',
					'append' => '',
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-map',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_6168cc95e9e68',
	'title' => 'Map Categories',
	'fields' => array(
		array(
			'key' => 'field_6168ccb0939fe',
			'label' => 'Color',
			'name' => 'color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_6168ce2b0cba5',
			'label' => 'Icon',
			'name' => 'icon',
			'aria-label' => '',
			'type' => 'image',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'preview_size' => 'medium',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'taxonomy',
				'operator' => '==',
				'value' => 'wp-map-category',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => false,
	'modified' => 1720575858,
) );

	acf_add_local_field_group( array(
	'key' => 'group_616377d62836b',
	'title' => 'Map Line',
	'fields' => array(
		array(
			'key' => 'field_616377f9af36c',
			'label' => 'Line',
			'name' => 'line',
			'aria-label' => '',
			'type' => 'mapster-map',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'mapster-draw-type' => 'linestring',
			'mapster-include-styling' => 0,
			'mapster-include-popup-details' => 0,
			'default_value' => '{ "type" : "FeatureCollection", "features" : [] }',
		),
		array(
			'key' => 'field_616378425c334',
			'label' => 'Color',
			'name' => 'color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#000000',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_6163780caf36d',
			'label' => 'Width',
			'name' => 'width',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => 5,
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => 0,
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_6163782e5c333',
			'label' => 'Opacity',
			'name' => 'opacity',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => 100,
			'placeholder' => '',
			'prepend' => '',
			'append' => '%',
			'min' => 0,
			'max' => 100,
			'step' => 1,
		),
		array(
			'key' => 'field_616378845c338',
			'label' => 'Dashed Line',
			'name' => 'dashed_line',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Dashed lines only work using Mapbox maps.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616378b9a2d93',
			'label' => 'Dash Properties',
			'name' => 'dash_properties',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'See the documentation for help on setting these values.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616378845c338',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6163784f5c335',
					'label' => 'Dash Length',
					'name' => 'dash_length',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 2,
					'placeholder' => '',
					'prepend' => '',
					'append' => 'px',
					'min' => '',
					'max' => '',
					'step' => '',
				),
				array(
					'key' => 'field_6163786d5c337',
					'label' => 'Gap Length',
					'name' => 'gap_length',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 1,
					'placeholder' => '',
					'prepend' => '',
					'append' => 'px',
					'min' => '',
					'max' => '',
					'step' => '',
				),
			),
		),
		array(
			'key' => 'field_625a55accad95',
			'label' => 'Hover Effects',
			'name' => 'hover_effects',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '<span class="mapster-pro-text">Hover effects are available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_625a5614cad99',
					'label' => 'Hover Enabled',
					'name' => 'hover_enabled',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'Enable hover effects.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_625a55f8cad98',
					'label' => 'Hover Color',
					'name' => 'hover_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625a5614cad99',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#000000',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_625a55e0cad97',
					'label' => 'Hover Width',
					'name' => 'hover_width',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625a5614cad99',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 5,
					'placeholder' => '',
					'prepend' => '',
					'append' => 'px',
					'min' => 0,
					'max' => '',
					'step' => '',
				),
				array(
					'key' => 'field_625a5660cad9a',
					'label' => 'Hover Opacity',
					'name' => 'hover_opacity',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625a5614cad99',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 100,
					'placeholder' => '',
					'prepend' => '',
					'append' => '%',
					'min' => 0,
					'max' => 100,
					'step' => 1,
				),
			),
		),
		array(
			'key' => 'field_6329ef9d2f5e1',
			'label' => 'Base Image',
			'name' => 'base_image',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-line',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_6163732e0426e',
	'title' => 'Map Location',
	'fields' => array(
		array(
			'key' => 'field_6163b9b4b4ddc',
			'label' => 'Location',
			'name' => 'location',
			'aria-label' => '',
			'type' => 'mapster-map',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'mapster-draw-type' => 'point',
			'mapster-include-styling' => 0,
			'mapster-include-popup-details' => 0,
			'default_value' => '{ "type" : "FeatureCollection", "features" : [] }',
		),
		array(
			'key' => 'field_61637347292a4',
			'label' => 'Location Style',
			'name' => 'location_style',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose how you want the location to be displayed: as a circle, a classic marker, text, or an icon.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'circle' => 'Circle',
				'marker' => 'Marker',
				'label' => 'Label & Icon',
				'3d-model' => '3D Model',
			),
			'default_value' => 'marker',
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
			'create_options' => 0,
			'save_options' => 0,
		),
		array(
			'key' => 'field_616373e5cca5e',
			'label' => 'Circle',
			'name' => 'circle',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61637347292a4',
						'operator' => '==',
						'value' => 'circle',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6163740b2db31',
					'label' => 'Radius',
					'name' => 'radius',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 5,
					'placeholder' => '',
					'prepend' => '',
					'append' => 'px',
					'min' => 0,
					'max' => '',
					'step' => '0.1',
				),
				array(
					'key' => 'field_6163743632bb4',
					'label' => 'Opacity',
					'name' => 'opacity',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 100,
					'placeholder' => '',
					'prepend' => '',
					'append' => '%',
					'min' => 0,
					'max' => 100,
					'step' => 1,
				),
				array(
					'key' => 'field_6163749bd02bd',
					'label' => 'Color',
					'name' => 'color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#000000',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_616374c0d02bf',
					'label' => 'Border Width',
					'name' => 'stroke-width',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => '',
					'prepend' => '',
					'append' => 'px',
					'min' => 0,
					'max' => '',
					'step' => '0.1',
				),
				array(
					'key' => 'field_616374e7d02c0',
					'label' => 'Border Color',
					'name' => 'stroke-color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_616507d400234',
					'label' => 'Border Opacity',
					'name' => 'stroke-opacity',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 100,
					'placeholder' => '',
					'prepend' => '',
					'append' => '%',
					'min' => 0,
					'max' => 100,
					'step' => 1,
				),
				array(
					'key' => 'field_6800343793440',
					'label' => 'Static Circle',
					'name' => 'circle-static-size',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'This will cause the circle to remain a static real-world size as you zoom in and out, instead of scaling. Available in <a href="https://wpmaps.mapster.me/" target="_blank">Pro</a>.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'allow_in_bindings' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_625ad848c2bfa',
					'label' => 'Hover Effects',
					'name' => 'hover_effects',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '<span class="mapster-pro-text">Hover effects are available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_625ad8adc2bfb',
							'label' => 'Hover Enabled',
							'name' => 'hover_enabled',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_625ad8d1c2bfc',
							'label' => 'Hover Radius',
							'name' => 'hover_radius',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625ad8adc2bfb',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => 5,
							'placeholder' => '',
							'prepend' => '',
							'append' => 'px',
							'min' => 0,
							'max' => '',
							'step' => '0.1',
						),
						array(
							'key' => 'field_625ad8d5c2bfd',
							'label' => 'Hover Opacity',
							'name' => 'hover_opacity',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625ad8adc2bfb',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => 100,
							'placeholder' => '',
							'prepend' => '',
							'append' => '%',
							'min' => 0,
							'max' => 100,
							'step' => 1,
						),
						array(
							'key' => 'field_625ad8d8c2bfe',
							'label' => 'Hover Color',
							'name' => 'hover_color',
							'aria-label' => '',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625ad8adc2bfb',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => '#000000',
							'enable_opacity' => 0,
							'return_format' => 'string',
						),
						array(
							'key' => 'field_625ad8dbc2bff',
							'label' => 'Hover Border Width',
							'name' => 'hover_stroke-width',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625ad8adc2bfb',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => 'px',
							'min' => 0,
							'max' => '',
							'step' => '0.1',
						),
						array(
							'key' => 'field_625ad8ddc2c00',
							'label' => 'Hover Border Color',
							'name' => 'hover_stroke-color',
							'aria-label' => '',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625ad8adc2bfb',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => '',
							'enable_opacity' => 0,
							'return_format' => 'string',
						),
						array(
							'key' => 'field_625ad8e0c2c01',
							'label' => 'Hover Border Opacity',
							'name' => 'hover_stroke-opacity',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625ad8adc2bfb',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => 100,
							'placeholder' => '',
							'prepend' => '',
							'append' => '%',
							'min' => 0,
							'max' => 100,
							'step' => 1,
						),
					),
				),
			),
		),
		array(
			'key' => 'field_6163751088e44',
			'label' => 'Marker',
			'name' => 'marker',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61637347292a4',
						'operator' => '==',
						'value' => 'marker',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_61637538a4710',
					'label' => 'Image',
					'name' => '',
					'aria-label' => '',
					'type' => 'message',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'message' => 'To use a custom marker image, select the "Icon & Text" Location Style above.',
					'new_lines' => 'wpautop',
					'esc_html' => 0,
				),
				array(
					'key' => 'field_616375cc16796',
					'label' => 'Color',
					'name' => 'color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#000000',
					'enable_opacity' => 0,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_6163755da4711',
					'label' => 'Scale',
					'name' => 'scale',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 100,
					'placeholder' => '',
					'prepend' => '',
					'append' => '%',
					'min' => 0,
					'max' => '',
					'step' => 1,
				),
				array(
					'key' => 'field_616375ff7b4e4',
					'label' => 'Rotation',
					'name' => 'rotation',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 1,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => '',
					'prepend' => '',
					'append' => '°',
					'min' => 0,
					'max' => 360,
					'step' => 1,
				),
				array(
					'key' => 'field_6164674824f6b',
					'label' => 'Anchor',
					'name' => 'anchor',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'center' => 'Center',
						'top' => 'Top',
						'bottom' => 'Bottom',
						'left' => 'Left',
						'right' => 'Right',
						'top-left' => 'Top Left',
						'top-right' => 'Top Right',
						'bottom-left' => 'Bottom Left',
						'bottom-right' => 'Bottom Right',
					),
					'default_value' => 'center',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_625adba94b0e5',
					'label' => 'Hover Effects',
					'name' => 'hover_effects',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '<span class="mapster-pro-text">Hover effects are available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_625adbcb4b0e6',
							'label' => 'Hover Enabled',
							'name' => 'hover_enabled',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui' => 1,
							'ui_on_text' => '',
							'ui_off_text' => '',
						),
						array(
							'key' => 'field_625adc264b0e7',
							'label' => 'Hover Color',
							'name' => 'hover_color',
							'aria-label' => '',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625adbcb4b0e6',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => '#000000',
							'enable_opacity' => 0,
							'return_format' => 'string',
						),
						array(
							'key' => 'field_625adc284b0e8',
							'label' => 'Hover Scale',
							'name' => 'hover_scale',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625adbcb4b0e6',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => 100,
							'placeholder' => '',
							'prepend' => '',
							'append' => '%',
							'min' => 0,
							'max' => '',
							'step' => 1,
						),
						array(
							'key' => 'field_625adc2a4b0e9',
							'label' => 'Hover Rotation',
							'name' => 'hover_rotation',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_625adbcb4b0e6',
										'operator' => '==',
										'value' => '1',
									),
								),
							),
							'wrapper' => array(
								'width' => '55',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => '°',
							'min' => 0,
							'max' => 360,
							'step' => 1,
						),
					),
				),
			),
		),
		array(
			'key' => 'field_61637642c8191',
			'label' => 'Label',
			'name' => 'label',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61637347292a4',
						'operator' => '==',
						'value' => 'label',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6165137947bb0',
					'label' => 'Label On',
					'name' => 'label_on',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_616513aa47bb1',
					'label' => 'Text Properties',
					'name' => 'text_properties',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6165137947bb0',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_616376581a4fb',
							'label' => 'Label Text',
							'name' => 'text-field',
							'aria-label' => '',
							'type' => 'text',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 'Label',
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'maxlength' => '',
						),
						array(
							'key' => 'field_6163770ad6e84',
							'label' => 'Font',
							'name' => 'text-font',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => 'By default, only Open Sans will work in a Mapbox Style. Other fonts will work from custom tile sources. If you want a font in your Mapbox map, you must load it in the Mapbox Style Editor.',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'Open Sans Regular' => 'Open Sans',
								'Open Sans Bold' => 'Open Sans Bold',
								'Open Sans Italic' => 'Open Sans Italic',
								'Klokantech Noto Sans Regular' => 'Noto Sans',
								'Klokantech Noto Sans Bold' => 'Noto Sans Bold',
								'Klokantech Noto Sans Italic' => 'Noto Sans Italic',
								'Metropolis Regular' => 'Metropolis',
								'Metropolis Bold' => 'Metropolis Bold',
								'Metropolis Regular Italic' => 'Metropolis Italic',
							),
							'default_value' => 'Open Sans',
							'return_format' => 'value',
							'multiple' => 0,
							'allow_null' => 0,
							'allow_in_bindings' => 1,
							'ui' => 0,
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_6163767f1a4fc',
							'label' => 'Font Size',
							'name' => 'text-size',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 16,
							'placeholder' => '',
							'prepend' => '',
							'append' => 'px',
							'min' => 0,
							'max' => '',
							'step' => '',
						),
						array(
							'key' => 'field_616376b8d6e81',
							'label' => 'Color',
							'name' => 'text-color',
							'aria-label' => '',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '#000000',
							'enable_opacity' => 0,
							'return_format' => 'string',
						),
						array(
							'key' => 'field_616376d1d6e82',
							'label' => 'Opacity',
							'name' => 'text-opacity',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 100,
							'placeholder' => '',
							'prepend' => '',
							'append' => '%',
							'min' => 0,
							'max' => 100,
							'step' => 1,
						),
						array(
							'key' => 'field_616376f3d6e83',
							'label' => 'Rotation',
							'name' => 'text-rotate',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => '°',
							'min' => 0,
							'max' => 360,
							'step' => 1,
						),
						array(
							'key' => 'field_6165280fe8593',
							'label' => 'Position X',
							'name' => 'text-translate-x',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => 'px',
							'min' => '',
							'max' => '',
							'step' => '0.1',
						),
						array(
							'key' => 'field_61652812e8594',
							'label' => 'Position Y',
							'name' => 'text-translate-y',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => 'px',
							'min' => '',
							'max' => '',
							'step' => '0.1',
						),
						array(
							'key' => 'field_61637726d6e85',
							'label' => 'Outline Width',
							'name' => 'text-halo-width',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 1,
							'placeholder' => '',
							'prepend' => '',
							'append' => '',
							'min' => 0,
							'max' => '',
							'step' => '0.1',
						),
						array(
							'key' => 'field_6163774eaeba0',
							'label' => 'Outline Color',
							'name' => 'text-halo-color',
							'aria-label' => '',
							'type' => 'color_picker',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => '#FFFFFF',
							'enable_opacity' => 0,
							'return_format' => 'string',
						),
						array(
							'key' => 'field_61637761aeba1',
							'label' => 'Outline Blur',
							'name' => 'text-halo-blur',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 50,
							'placeholder' => '',
							'prepend' => '',
							'append' => '%',
							'min' => 0,
							'max' => 100,
							'step' => 1,
						),
					),
				),
			),
		),
		array(
			'key' => 'field_61651d590c6be',
			'label' => 'Icon',
			'name' => 'icon',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61637347292a4',
						'operator' => '==',
						'value' => 'label',
					),
				),
			),
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_61651d740c6bf',
					'label' => 'Icon On',
					'name' => 'icon_on',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_61651d9bf95dc',
					'label' => 'Icon Properties',
					'name' => 'icon_properties',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61651d740c6bf',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_61651da7f95dd',
							'label' => 'Image',
							'name' => 'icon-image',
							'aria-label' => '',
							'type' => 'image',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'return_format' => 'array',
							'library' => 'all',
							'min_width' => '',
							'min_height' => '',
							'min_size' => '',
							'max_width' => '',
							'max_height' => '',
							'max_size' => '',
							'mime_types' => 'png,jpeg,jpg,gif,svg,avif,webp',
							'allow_in_bindings' => 1,
							'preview_size' => 'full',
						),
						array(
							'key' => 'field_6165211f02ad4',
							'label' => 'Scale',
							'name' => 'icon-size',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 100,
							'placeholder' => '',
							'prepend' => '',
							'append' => '%',
							'min' => 0,
							'max' => '',
							'step' => '',
						),
						array(
							'key' => 'field_6165216202ad5',
							'label' => 'Opacity',
							'name' => 'icon-opacity',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 100,
							'placeholder' => '',
							'prepend' => '',
							'append' => '%',
							'min' => 0,
							'max' => 100,
							'step' => '',
						),
						array(
							'key' => 'field_616522bd02ad8',
							'label' => 'Rotation',
							'name' => 'icon-rotate',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => '°',
							'min' => 0,
							'max' => 360,
							'step' => 1,
						),
						array(
							'key' => 'field_6165218102ad6',
							'label' => 'Position X',
							'name' => 'icon-translate-x',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => 'px',
							'min' => '',
							'max' => '',
							'step' => '0.1',
						),
						array(
							'key' => 'field_6165229802ad7',
							'label' => 'Position Y',
							'name' => 'icon-translate-y',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '50',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => 'px',
							'min' => '',
							'max' => '',
							'step' => '0.1',
						),
						array(
							'key' => 'field_616cb97fcb230',
							'label' => 'Anchor',
							'name' => 'icon-anchor',
							'aria-label' => '',
							'type' => 'select',
							'instructions' => '',
							'required' => 1,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'choices' => array(
								'center' => 'Center',
								'left' => 'Left',
								'right' => 'Right',
								'top' => 'Top',
								'bottom' => 'Bottom',
								'top-left' => 'Top Left',
								'top-right' => 'Top Right',
								'bottom-left' => 'Bottom Left',
								'bottom-right' => 'Bottom Right',
							),
							'default_value' => 'center',
							'allow_null' => 0,
							'multiple' => 0,
							'ui' => 0,
							'return_format' => 'value',
							'ajax' => 0,
							'placeholder' => '',
							'create_options' => 0,
							'save_options' => 0,
						),
						array(
							'key' => 'field_665ad1841bc15',
							'label' => 'Static Size',
							'name' => 'icon-static-size',
							'aria-label' => '',
							'type' => 'true_false',
							'instructions' => 'Keep the label/icon a static size as the user zooms. You will likely need to adjust the Scale above after activating this.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
							'required' => 0,
							'conditional_logic' => array(
								array(
									array(
										'field' => 'field_61637347292a4',
										'operator' => '==',
										'value' => 'label',
									),
								),
							),
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'message' => '',
							'default_value' => 0,
							'ui_on_text' => '',
							'ui_off_text' => '',
							'ui' => 1,
						),
						array(
							'key' => 'field_66f74cceb5611',
							'label' => 'Hover Effects',
							'name' => 'hover_effects',
							'aria-label' => '',
							'type' => 'group',
							'instructions' => '<span class="mapster-pro-text">Hover effects are available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'layout' => 'block',
							'sub_fields' => array(
								array(
									'key' => 'field_66f74cceb5612',
									'label' => 'Hover Enabled',
									'name' => 'hover_enabled',
									'aria-label' => '',
									'type' => 'true_false',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => 0,
									'wrapper' => array(
										'width' => '',
										'class' => '',
										'id' => '',
									),
									'message' => '',
									'default_value' => 0,
									'allow_in_bindings' => 1,
									'ui_on_text' => '',
									'ui_off_text' => '',
									'ui' => 1,
								),
								array(
									'key' => 'field_66f74cceb5613',
									'label' => 'Hover Opacity',
									'name' => 'hover_opacity',
									'aria-label' => '',
									'type' => 'number',
									'instructions' => '',
									'required' => 0,
									'conditional_logic' => array(
										array(
											array(
												'field' => 'field_66f74cceb5612',
												'operator' => '==',
												'value' => '1',
											),
										),
									),
									'wrapper' => array(
										'width' => '100',
										'class' => '',
										'id' => '',
									),
									'default_value' => 100,
									'min' => 0,
									'max' => 100,
									'allow_in_bindings' => 0,
									'placeholder' => '',
									'step' => '',
									'prepend' => '',
									'append' => '%',
								),
							),
						),
					),
				),
			),
		),
		array(
			'key' => 'field_6270b6fdaf84f',
			'label' => '3D Model',
			'name' => '3d_model',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Adding 3D models is available in <a href="https://wpmaps.mapster.me" target="_blank">Mapster WP Maps Pro</a>.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61637347292a4',
						'operator' => '==',
						'value' => '3d-model',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6270b743af850',
					'label' => '3D Model File',
					'name' => '3d_model_file',
					'aria-label' => '',
					'type' => 'file',
					'instructions' => 'Upload a GLB file here.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'url',
					'library' => 'all',
					'min_size' => '',
					'max_size' => '',
					'mime_types' => 'glb,obj',
				),
				array(
					'key' => 'field_628308a5e80c3',
					'label' => 'Scale',
					'name' => 'scale',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 1000,
					'min' => 0,
					'max' => '',
					'placeholder' => '',
					'step' => '0.1',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_628308c7e80c4',
					'label' => 'Rotation',
					'name' => 'rotation',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_628308d1e80c5',
							'label' => 'X Rotation',
							'name' => 'x_rotation',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 90,
							'placeholder' => '',
							'prepend' => '',
							'append' => '°',
							'min' => 0,
							'max' => 360,
							'step' => '',
						),
						array(
							'key' => 'field_628308f9e80c6',
							'label' => 'Y Rotation',
							'name' => 'y_rotation',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => '°',
							'min' => 0,
							'max' => 360,
							'step' => '',
						),
						array(
							'key' => 'field_62830903e80c7',
							'label' => 'Z Rotation',
							'name' => 'z_rotation',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'placeholder' => '',
							'prepend' => '',
							'append' => '°',
							'min' => 0,
							'max' => 360,
							'step' => '',
						),
					),
				),
			),
		),
		array(
			'key' => 'field_6329e82c1b138',
			'label' => 'Base Image',
			'name' => 'base_image',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_6631206118aa2',
			'label' => 'Default Zoom Level',
			'name' => 'default_zoom_level',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => 'Zoom level when selected via dropdowns or autozooms.<span class="mapster-pro-text"> Editable in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 15,
			'min' => 0,
			'max' => 22,
			'placeholder' => '',
			'step' => '',
			'prepend' => '',
			'append' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-location',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_616379566202f',
	'title' => 'Map Polygon',
	'fields' => array(
		array(
			'key' => 'field_61637961f8c23',
			'label' => 'Polygon',
			'name' => 'polygon',
			'aria-label' => '',
			'type' => 'mapster-map',
			'instructions' => '',
			'required' => 1,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'mapster-draw-type' => 'polygon',
			'mapster-include-styling' => 0,
			'mapster-include-popup-details' => 0,
			'default_value' => '{ "type" : "FeatureCollection", "features" : [] }',
		),
		array(
			'key' => 'field_626f6804fb3f8',
			'label' => 'Polygon Style',
			'name' => 'polygon_style',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'fill' => 'Flat',
				'fill-extrusion' => '3D',
				'fill-image' => 'Image',
				'fill-pattern' => 'Pattern',
			),
			'default_value' => 'fill',
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'allow_in_bindings' => 1,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'create_options' => 0,
			'save_options' => 0,
		),
		array(
			'key' => 'field_61637967f8c24',
			'label' => 'Color',
			'name' => 'color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_626f6804fb3f8',
						'operator' => '==',
						'value' => 'fill',
					),
				),
				array(
					array(
						'field' => 'field_626f6804fb3f8',
						'operator' => '==',
						'value' => 'fill-extrusion',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#0e1b82',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_61637980f8c25',
			'label' => 'Opacity',
			'name' => 'opacity',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_626f6804fb3f8',
						'operator' => '==',
						'value' => 'fill',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => 75,
			'min' => 0,
			'max' => 100,
			'allow_in_bindings' => 1,
			'placeholder' => '',
			'step' => 1,
			'prepend' => '',
			'append' => '%',
		),
		array(
			'key' => 'field_6169fb5075f7f',
			'label' => 'Outline Color',
			'name' => 'outline-color',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => 'Make this transparent if you don\'t want it visible.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_626f6804fb3f8',
						'operator' => '==',
						'value' => 'fill',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => 'rgba(0, 0, 0, 0)',
			'enable_opacity' => 1,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_68a0675f25ca6',
			'label' => 'Pattern',
			'name' => 'pattern',
			'aria-label' => '',
			'type' => 'image',
			'instructions' => '<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me" target="_blank">Mapster WP Maps Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_626f6804fb3f8',
						'operator' => '==',
						'value' => 'fill-pattern',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
			'allow_in_bindings' => 0,
			'preview_size' => 'full',
		),
		array(
			'key' => 'field_626f5af9d937d',
			'label' => '3D Polygon',
			'name' => '3d_polygon',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Define a base height and max height.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me" target="_blank">Mapster WP Maps Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_626f6804fb3f8',
						'operator' => '==',
						'value' => 'fill-extrusion',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_626f5b2cd937e',
					'label' => 'Base Height',
					'name' => 'base',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => 0,
					'prepend' => '',
					'append' => 'units',
					'min' => 0,
					'max' => '',
					'step' => '',
				),
				array(
					'key' => 'field_626f5b6dd9382',
					'label' => 'Top Height',
					'name' => 'height',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => 0,
					'prepend' => '',
					'append' => 'units',
					'min' => 0,
					'max' => '',
					'step' => '',
				),
			),
		),
		array(
			'key' => 'field_66b6c547993e5',
			'label' => 'Polygon Image',
			'name' => 'polygon_image',
			'aria-label' => '',
			'type' => 'image',
			'instructions' => 'The image will stretch to fill a rectangular space covered by your polygon (the bounds). The black background above is just to help you fit the image correctly, it will not appear in the final map!<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_626f6804fb3f8',
						'operator' => '==',
						'value' => 'fill-image',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
			'allow_in_bindings' => 1,
			'preview_size' => 'full',
		),
		array(
			'key' => 'field_625ad3154cc0f',
			'label' => 'Hover Effects',
			'name' => 'hover_effects',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '<span class="mapster-pro-text">Hover effects are available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_625ad3234cc10',
					'label' => 'Hover Enabled',
					'name' => 'hover_enabled',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_625ad3714cc11',
					'label' => 'Hover Color',
					'name' => 'hover_color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625ad3234cc10',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_626f6804fb3f8',
								'operator' => '==',
								'value' => 'fill',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => '#0e1b82',
					'enable_opacity' => 0,
					'return_format' => 'string',
					'allow_in_bindings' => 1,
				),
				array(
					'key' => 'field_625ad3784cc12',
					'label' => 'Opacity',
					'name' => 'opacity',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625ad3234cc10',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_626f6804fb3f8',
								'operator' => '==',
								'value' => 'fill',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 75,
					'placeholder' => '',
					'prepend' => '',
					'append' => '%',
					'min' => 0,
					'max' => 100,
					'step' => 1,
				),
				array(
					'key' => 'field_625ad37f4cc13',
					'label' => 'Outline Color',
					'name' => 'outline-color',
					'aria-label' => '',
					'type' => 'color_picker',
					'instructions' => 'Make this transparent if you don\'t want it visible.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625ad3234cc10',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_626f6804fb3f8',
								'operator' => '==',
								'value' => 'fill',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'rgba(0, 0, 0, 0)',
					'enable_opacity' => 1,
					'return_format' => 'string',
				),
				array(
					'key' => 'field_626f5b9cf0117',
					'label' => 'Base Height',
					'name' => 'base',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625ad3234cc10',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_626f6804fb3f8',
								'operator' => '==',
								'value' => 'fill-extrusion',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => 0,
					'prepend' => '',
					'append' => 'units',
					'min' => 0,
					'max' => '',
					'step' => '',
				),
				array(
					'key' => 'field_626f5bb0f0118',
					'label' => 'Top Height',
					'name' => 'height',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_625ad3234cc10',
								'operator' => '==',
								'value' => '1',
							),
							array(
								'field' => 'field_626f6804fb3f8',
								'operator' => '==',
								'value' => 'fill-extrusion',
							),
						),
					),
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'placeholder' => 0,
					'prepend' => '',
					'append' => 'units',
					'min' => 0,
					'max' => '',
					'step' => '',
				),
			),
		),
		array(
			'key' => 'field_6329efab822ed',
			'label' => 'Base Image',
			'name' => 'base_image',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-polygon',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_62832f795a8b9',
	'title' => 'Mapster Help',
	'fields' => array(
		array(
			'key' => 'field_62832f86ed5ce',
			'label' => 'Mapster WP Maps Introduction',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '<strong>Confused about how to use this plugin?</strong> We have <a href="https://wpmaps-docs.mapster.me/getting-started/guides" target="_blank">extensive documentation available</a>.

	<a id="mapster-view-quick-tutorial" class="button button-secondary">View Quick Tutorial</a>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-map',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'side',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_6168be3bc0b53',
	'title' => 'Mapster Settings',
	'fields' => array(
		array(
			'key' => 'field_627f0fb446178',
			'label' => 'General',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_6168be7458083',
			'label' => 'Default Access Token',
			'name' => 'default_access_token',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter your Mapbox Access Token. Not required for MapLibre maps.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '100',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_62773cf2300be',
			'label' => 'Google Maps API Key',
			'name' => 'google_maps_api_key',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'If you want to use Google Maps, enter your <a href="https://developers.google.com/maps/documentation/javascript/get-api-key" target="_blank">API key</a> here.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '100',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_6168db6fdbb0d',
			'label' => 'Gutenberg Editor',
			'name' => 'gutenberg_editor',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Enable or disable the Gutenberg editor on maps, lines, locations, and polygons.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => 'Enable',
			'ui_off_text' => 'Disable',
		),
		array(
			'key' => 'field_6168e08fc684b',
			'label' => 'Public Pages',
			'name' => 'public_pages',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Enable or disable map post types from being publicly accessible as standalone pages on your site.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '100',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6168e0c0c684c',
					'label' => 'Maps',
					'name' => 'maps',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6168e0cdc684d',
					'label' => 'Locations',
					'name' => 'locations',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6168e0d7c684e',
					'label' => 'Lines',
					'name' => 'lines',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6168e0dcc684f',
					'label' => 'Polygons',
					'name' => 'polygons',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_62e05c9a776ce',
					'label' => 'User Submissions',
					'name' => 'user_submissions',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_623794030cdd2',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
			),
		),
		array(
			'key' => 'field_6262ee16ca263',
			'label' => 'Permalinks',
			'name' => 'permalinks',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Customize the permalinks for Mapster\'s custom post types.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_6168e0c0c684c',
						'operator' => '==',
						'value' => '1',
					),
				),
				array(
					array(
						'field' => 'field_6168e0cdc684d',
						'operator' => '==',
						'value' => '1',
					),
				),
				array(
					array(
						'field' => 'field_6168e0d7c684e',
						'operator' => '==',
						'value' => '1',
					),
				),
				array(
					array(
						'field' => 'field_6168e0dcc684f',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6262ee2eca264',
					'label' => 'Maps',
					'name' => 'maps',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6168e0c0c684c',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_6262ee40ca265',
					'label' => 'Locations',
					'name' => 'locations',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6168e0cdc684d',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_6262ee51ca266',
					'label' => 'Lines',
					'name' => 'lines',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6168e0d7c684e',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_6262ee64ca267',
					'label' => 'Polygons',
					'name' => 'polygons',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6168e0dcc684f',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_62e05c74776cd',
					'label' => 'User Submissions',
					'name' => 'user_submissions',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_623794030cdd2',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_65022ac872243',
					'label' => 'Listing Pages',
					'name' => 'listing_pages',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_650229e177d82',
								'operator' => '==',
								'value' => '1',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
			),
		),
		array(
			'key' => 'field_627f0fc346179',
			'label' => 'Advanced Options',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_628077bc3a048',
			'label' => 'Mapbox Username',
			'name' => 'mapbox_username',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'This is not your email. Log into Mapbox to find your username. Only necessary for advanced functionality like creating tilesets.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
		array(
			'key' => 'field_62806fc79ed47',
			'label' => 'Mapbox Secret Token',
			'name' => 'mapbox_secret_token',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'The secret token is used for more advanced functionality, such as managing tilesets and datasets from inside Wordpress. Your token must have tileset:read, tileset:write, and tileset:list enabled. See <a href="https://wpmaps-docs.mapster.me/" target="_blank">the docs</a>.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_623793d30cdd0',
			'label' => 'Pro',
			'name' => 'pro',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '<span class="mapster-pro-text"><a href="https://wpmaps.mapster.me/pro" target="_blank">Install Mapster WP Maps Pro</a> to get way more features, and enable them here.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_623793f50cdd1',
					'label' => 'Store Locator',
					'name' => 'mwm_store_locator',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_623794030cdd2',
					'label' => 'User Submission',
					'name' => 'mwm_user_submission',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
				array(
					'key' => 'field_6398b46560e96',
					'label' => 'Editing Map Style',
					'name' => 'editing_map_style',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'If you\'ve added a "Default Access Token" in Settings, here you can add a style URL that you want editing pages to use instead of the default Open Street Maps tileset.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'placeholder' => 'eg., mapbox://styles/mapbox/streets-v12',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_63dd489333f60',
					'label' => 'Default Shortcode Map',
					'name' => 'default_shortcode_map',
					'aria-label' => '',
					'type' => 'post_object',
					'instructions' => 'This map will serve as the "default basemap" for the shortcodes generated for individual Locations, Lines, or Polygons. This can be overwritten if another basemap is chosen on the individual edit screen.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'post_type' => array(
						0 => 'mapster-wp-map',
					),
					'taxonomy' => '',
					'return_format' => 'id',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 1,
					'bidirectional_target' => array(
					),
				),
				array(
					'key' => 'field_643d8b43e5840',
					'label' => 'Default Map View',
					'name' => 'default_map_view',
					'aria-label' => '',
					'type' => 'group',
					'instructions' => 'Here, you can set the default starting center and zoom of all maps.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'layout' => 'block',
					'sub_fields' => array(
						array(
							'key' => 'field_643d8b9ae5841',
							'label' => 'Default Latitude',
							'name' => 'default_latitude',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'min' => -90,
							'max' => 90,
							'placeholder' => '',
							'step' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_643d8bd7e5842',
							'label' => 'Default Longitude',
							'name' => 'default_longitude',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 0,
							'min' => -180,
							'max' => 180,
							'placeholder' => '',
							'step' => '',
							'prepend' => '',
							'append' => '',
						),
						array(
							'key' => 'field_643d8bf6e5843',
							'label' => 'Default Zoom',
							'name' => 'default_zoom',
							'aria-label' => '',
							'type' => 'number',
							'instructions' => '',
							'required' => 0,
							'conditional_logic' => 0,
							'wrapper' => array(
								'width' => '',
								'class' => '',
								'id' => '',
							),
							'default_value' => 2,
							'min' => 0,
							'max' => 22,
							'placeholder' => '',
							'step' => '',
							'prepend' => '',
							'append' => '',
						),
					),
				),
				array(
					'key' => 'field_627f10194617b',
					'label' => 'Spatial API',
					'name' => 'spatial_api',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '<a href="https://wpmaps-docs.mapster.me/" target="_blank">See the docs</a> for details on how to query the spatial API, including returning GeoJSONs, Point-In-Polygon queries, polygon overlaps, and more.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui' => 1,
					'ui_on_text' => 'On',
					'ui_off_text' => 'Off',
				),
				array(
					'key' => 'field_63f6cd9a20b31',
					'label' => 'Encoded Geometries',
					'name' => 'encoded_geometries',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'This may help to speed up your maps that load a lot of complex geometries. <a href="https://wpmaps-docs.mapster.me/" target="_blank">See the docs</a> for more information on how to use this feature. CURRENTLY IN DEVELOPMENT.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => 'On',
					'ui_off_text' => 'Off',
					'ui' => 1,
				),
				array(
					'key' => 'field_62c5fff3d659b',
					'label' => 'Tileset Management Format',
					'name' => 'tileset_management_format',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => 'This area is for adding custom properties to features you send to Mapbox (experimental feature).',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => '',
					'new_lines' => '',
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-settings',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_6169ff23a6e6d',
	'title' => 'Popup Style',
	'fields' => array(
		array(
			'key' => 'field_616a029963383',
			'label' => 'Preview',
			'name' => '',
			'aria-label' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'message' => 'Test out how your popup looks on this map!
	<div class="button button-primary">Open Popup</div>
	<div id="map"></div>',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_616a0768a7f41',
			'label' => 'Preview Content',
			'name' => '_copy',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_616a02f694f0b',
					'label' => 'Header Text Preview',
					'name' => 'header_text_preview',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'Sample Header',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_616a031894f0d',
					'label' => 'Content Preview',
					'name' => 'content_preview',
					'aria-label' => '',
					'type' => 'textarea',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'Sample content in a single paragraph.',
					'placeholder' => '',
					'maxlength' => '',
					'rows' => 5,
					'new_lines' => '',
				),
				array(
					'key' => 'field_616a0739c7606',
					'label' => 'Button Text Preview',
					'name' => 'button_text_preview',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '100',
						'class' => '',
						'id' => '',
					),
					'default_value' => 'Sample Button',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
			),
		),
		array(
			'key' => 'field_616a129681262',
			'label' => 'Layout',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_616a12538125e',
			'label' => 'Enable Header',
			'name' => 'enable_header',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616a58e080e71',
			'label' => 'Enable Image',
			'name' => 'enable_image',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616a58f480e72',
			'label' => 'Image Height',
			'name' => 'image_height',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616a58e080e71',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => 50,
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => 0,
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_65185f360101d',
			'label' => 'Image Thumbnail Resolution',
			'name' => 'image_thumbnail_size',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616a58e080e71',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'thumbnail' => 'Thumbnail (150px x 150px max)',
				'medium' => 'Medium (300px x 300px max)',
				'large' => 'Large (1024px x 1024px max)',
				'full' => 'Full Size',
			),
			'default_value' => 'medium',
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'create_options' => 0,
			'save_options' => 0,
		),
		array(
			'key' => 'field_616a12668125f',
			'label' => 'Enable Body',
			'name' => 'enable_body',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616a127281260',
			'label' => 'Enable Footer',
			'name' => 'enable_footer',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616a127b81261',
			'label' => 'Enable Pointer',
			'name' => 'enable_pointer',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616a01a206a3a',
			'label' => 'Background Colors',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_6169ff4ee9eeb',
			'label' => 'Background',
			'name' => 'background',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#FFFFFF',
			'enable_opacity' => 1,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_6169ff66e9eec',
			'label' => 'Header',
			'name' => 'header',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#FFFFFF',
			'enable_opacity' => 1,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_6169ffa8e9eed',
			'label' => 'Body',
			'name' => 'body',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#FFFFFF',
			'enable_opacity' => 1,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_6169ffb4e9eee',
			'label' => 'Footer',
			'name' => 'footer',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#FFFFFF',
			'enable_opacity' => 1,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_6169ffc2e9eef',
			'label' => 'Button',
			'name' => 'button',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#2271b1',
			'enable_opacity' => 1,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_6169ffd1e9ef0',
			'label' => 'Pointer',
			'name' => 'pointer',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#FFFFFF',
			'enable_opacity' => 1,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_616a01c806a3c',
			'label' => 'Text',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_616a0ec000da7',
			'label' => 'Align',
			'name' => 'align',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'left' => 'Left',
				'center' => 'Center',
				'right' => 'Right',
			),
			'default_value' => 'none',
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
			'create_options' => 0,
			'save_options' => 0,
		),
		array(
			'key' => 'field_6169fff1e9ef2',
			'label' => 'Header Text',
			'name' => 'header_text',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#000000',
			'enable_opacity' => 1,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_616a000ae9ef3',
			'label' => 'Body Text',
			'name' => 'body_text',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#000000',
			'enable_opacity' => 1,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_616a0018e9ef4',
			'label' => 'Button Text',
			'name' => 'button_text',
			'aria-label' => '',
			'type' => 'color_picker',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '#FFFFFF',
			'enable_opacity' => 0,
			'return_format' => 'string',
		),
		array(
			'key' => 'field_616a01dd06a3d',
			'label' => 'CSS',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_616a00d9c802e',
			'label' => 'Popup Class',
			'name' => 'popup_class',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter a custom class you can use for adding CSS styles.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'maxlength' => '',
		),
		array(
			'key' => 'field_616a5d2b3c357',
			'label' => 'Use Custom CSS',
			'name' => 'use_custom_css',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616a0093c802d',
			'label' => 'CSS Editor',
			'name' => 'css_editor',
			'aria-label' => '',
			'type' => 'acf_code_field',
			'instructions' => 'Only edit this if you understand CSS and the relevant classes! The default CSS on load is included here. A common error is that the placeholder image will overwrite your default image -- you can fix this by erasing the line in #mapster-popup .map-popup-image that defines the background-image.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616a5d2b3c357',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => 'mapster-css-editor',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'mode' => 'css',
			'theme' => 'monokai',
		),
		array(
			'key' => 'field_626b25c4b2bfc',
			'label' => 'HTML',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_626b25f3b2bfd',
			'label' => 'Use Custom HTML',
			'name' => 'use_custom_html',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '<span class="mapster-pro-text">Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster WP Maps Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_626b260ab2bfe',
			'label' => 'HTML Editor',
			'name' => 'html_editor',
			'aria-label' => '',
			'type' => 'acf_code_field',
			'instructions' => 'This will replace all the HTML that appears inside the popup. Use the "CSS" tab, erase the default CSS, and write new CSS there to use it for this HTML. Or just erase it and write your CSS in a stylesheet.

	Available tags that will substitute dynamic content: {header} {image_url} {content} {button_link} {button_text}. You can also add custom fields that you know exist on your features. See the <a href="https://wpmaps-docs.mapster.me/popups/popup-templates/html" target="_blank">Mapster docs</a> for more information.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_626b25f3b2bfd',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => 'mapster-css-editor',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'mode' => 'htmlmixed',
			'theme' => 'monokai',
			'allow_in_bindings' => 1,
		),
		array(
			'key' => 'field_616a07d025da2',
			'label' => 'Options',
			'name' => '',
			'aria-label' => '',
			'type' => 'tab',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'placement' => 'top',
			'endpoint' => 0,
			'selected' => 0,
		),
		array(
			'key' => 'field_616a084925da7',
			'label' => 'Max Width',
			'name' => 'max_width',
			'aria-label' => '',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'default_value' => 240,
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => 0,
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_6732bc667d61a',
			'label' => 'Popup Anchor',
			'name' => 'popup_anchor',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'center' => 'Center',
				'top' => 'Top',
				'bottom' => 'Bottom',
				'left' => 'Left',
				'right' => 'Right',
				'top-left' => 'Top Left',
				'top-right' => 'Top Right',
				'bottom-left' => 'Bottom Left',
				'bottom-right' => 'Bottom Right',
			),
			'default_value' => 'bottom',
			'return_format' => 'value',
			'multiple' => 0,
			'allow_null' => 0,
			'allow_in_bindings' => 0,
			'ui' => 0,
			'ajax' => 0,
			'placeholder' => '',
			'create_options' => 0,
			'save_options' => 0,
		),
		array(
			'key' => 'field_616a080825da3',
			'label' => 'Close Button',
			'name' => 'close_button',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616a081525da4',
			'label' => 'Close on Click',
			'name' => 'close_on_click',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Close popup whenever another place on the map is clicked.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616a083525da5',
			'label' => 'Close on Map Move',
			'name' => 'close_on_map_move',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_63a37f0ec5728',
			'label' => 'Center on Open',
			'name' => 'center_on_open',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Center the popup window in the middle of the map when clicked.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_63ac8c0cd289b',
			'label' => 'Zoom on Open',
			'name' => 'zoom_on_open',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'This will zoom into the clicked point when the popup opens. This may override other similar functionality, be sure to test!<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_655ceac424b5c',
			'label' => 'Open as Modal Immediately',
			'name' => 'open_as_modal_immediately',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Instead of opening a popup, turning this on will open the content normally entered for the popup (without any additional buttons or styling) in a modal instead.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_684ab316e9871',
			'label' => 'Starting Popup Position',
			'name' => 'popup_translate',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => 'Here you can change the starting position of the popup by moving it a set amount of pixels in any specific direction.<span class="mapster-pro-text"> Available in <a href="https://wpmaps.mapster.me" target="_blank">Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_684ab33de9872',
					'label' => 'Left',
					'name' => 'left_translate',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'min' => '',
					'max' => '',
					'allow_in_bindings' => 0,
					'placeholder' => '',
					'step' => 1,
					'prepend' => '',
					'append' => 'px',
				),
				array(
					'key' => 'field_684ab386e9873',
					'label' => 'Right',
					'name' => 'right_translate',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'min' => '',
					'max' => '',
					'allow_in_bindings' => 0,
					'placeholder' => '',
					'step' => 1,
					'prepend' => '',
					'append' => 'px',
				),
				array(
					'key' => 'field_684ab394e9874',
					'label' => 'Top',
					'name' => 'top_translate',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'min' => '',
					'max' => '',
					'allow_in_bindings' => 0,
					'placeholder' => '',
					'step' => 1,
					'prepend' => '',
					'append' => 'px',
				),
				array(
					'key' => 'field_684ab39ce9875',
					'label' => 'Bottom',
					'name' => 'bottom_translate',
					'aria-label' => '',
					'type' => 'number',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '55',
						'class' => '',
						'id' => '',
					),
					'default_value' => 0,
					'min' => '',
					'max' => '',
					'allow_in_bindings' => 0,
					'placeholder' => '',
					'step' => 1,
					'prepend' => '',
					'append' => 'px',
				),
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-popup',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_626492b319912',
	'title' => 'Post Display Options',
	'fields' => array(
		array(
			'key' => 'field_626492dbed193',
			'label' => 'Show Map in Post',
			'name' => 'show_map_in_post',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Turn this on if you want this post to show a map of this single feature.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_6264930aed194',
			'label' => 'Template Map',
			'name' => 'template_map',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'This map will serve as the underlying template for the single feature display. However, it will only show the one feature for this post. You can set a default for this on the Settings page (Pro only).',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_626492dbed193',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'mapster-wp-map',
			),
			'taxonomy' => '',
			'return_format' => 'id',
			'multiple' => 0,
			'allow_null' => 1,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_6507bb67c3f87',
			'label' => 'Associated Post',
			'name' => 'associated_post',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Search for a post or page you want to associate with this feature. This is part of <a href="https://wpmaps-docs.mapster.me/pro-features/specialty-maps/listing-page-map" target="_blank">creating Listing Pages</a><span class="mapster-pro-text"> in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a></span>.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'post_type' => '',
			'post_status' => '',
			'taxonomy' => '',
			'return_format' => 'object',
			'multiple' => 0,
			'allow_null' => 0,
			'bidirectional' => 0,
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-location',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-line',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-polygon',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'side',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_6400d71c36a00',
	'title' => 'User Submission Points',
	'fields' => array(
		array(
			'key' => 'field_6400d71bc051a',
			'label' => 'User Submitted Title',
			'name' => 'user_submitted_title',
			'aria-label' => '',
			'type' => 'text',
			'instructions' => 'Enter in a title for your submitted point here.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'maxlength' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-user-sub',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );

	acf_add_local_field_group( array(
	'key' => 'group_6163d357655f4',
	'title' => 'Popup',
	'fields' => array(
		array(
			'key' => 'field_616a60c610c96',
			'label' => 'Enable Popup',
			'name' => 'enable_popup',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_616a145a4f1eb',
			'label' => 'Popup Template',
			'name' => 'popup_style',
			'aria-label' => '',
			'type' => 'post_object',
			'instructions' => 'Create new popup templates in the "Popup Template" section of Mapster WP Maps.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616a60c610c96',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'post_type' => array(
				0 => 'mapster-wp-popup',
			),
			'taxonomy' => '',
			'allow_null' => 0,
			'multiple' => 0,
			'return_format' => 'object',
			'ui' => 1,
			'bidirectional_target' => array(
			),
		),
		array(
			'key' => 'field_616a60fd2218f',
			'label' => 'Interaction',
			'name' => 'interaction',
			'aria-label' => '',
			'type' => 'select',
			'instructions' => 'Choose how the popup will open.',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616a60c610c96',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'choices' => array(
				'click' => 'Click',
				'hover' => 'Hover',
			),
			'default_value' => 'click',
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'return_format' => 'value',
			'ajax' => 0,
			'placeholder' => '',
			'create_options' => 0,
			'save_options' => 0,
		),
		array(
			'key' => 'field_6262e65ac707a',
			'label' => 'Keep Popup Open on Hover',
			'name' => 'keep_popup_open_on_hover',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616a60fd2218f',
						'operator' => '==',
						'value' => 'hover',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_61d61953367da',
			'label' => 'Click on mobile',
			'name' => 'click_on_mobile',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Allow click on mobile (hover cannot work in mobile devices).',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616a60fd2218f',
						'operator' => '==',
						'value' => 'hover',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 1,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_6168d546268fb',
			'label' => 'Popup',
			'name' => 'popup',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_616a60c610c96',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_6169fc8a6e649',
					'label' => 'Header Text',
					'name' => 'header_text',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_61db0c22f9454',
					'label' => 'Image Type',
					'name' => 'image_type',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => 'Select either a single featured image or a gallery of images that will show as a slideshow.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'feature-image' => 'Feature Image',
						'gallery' => 'Gallery',
					),
					'default_value' => 'feature-image',
					'allow_null' => 0,
					'multiple' => 0,
					'ui' => 0,
					'return_format' => 'value',
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_6169fcb16e64b',
					'label' => 'Featured Image',
					'name' => 'featured_image',
					'aria-label' => '',
					'type' => 'image',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61db0c22f9454',
								'operator' => '==',
								'value' => 'feature-image',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'return_format' => 'array',
					'preview_size' => 'medium',
					'library' => 'all',
					'min_width' => '',
					'min_height' => '',
					'min_size' => '',
					'max_width' => '',
					'max_height' => '',
					'max_size' => '',
					'mime_types' => '',
				),
				array(
					'key' => 'field_61dcb4a861391',
					'label' => 'Images',
					'name' => 'images',
					'aria-label' => '',
					'type' => 'photo_gallery',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_61db0c22f9454',
								'operator' => '==',
								'value' => 'gallery',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'fields[images' => array(
						'edit_modal' => 'Default',
						'images_limit' => '',
						'remove_edit_button' => 'No',
						'remove_delete_button' => 'No',
					),
					'edit_modal' => 'Default',
				),
				array(
					'key' => 'field_6169fc9c6e64a',
					'label' => 'Body Text',
					'name' => 'body_text',
					'aria-label' => '',
					'type' => 'wysiwyg',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 0,
					'delay' => 0,
				),
				array(
					'key' => 'field_66ca050355d9b',
					'label' => 'Render Shortcode',
					'name' => 'render_shortcode',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => 'This may slow down the loading of your popup. Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Pro</a>.',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 0,
					'ui_on_text' => '',
					'ui_off_text' => '',
					'ui' => 1,
				),
				array(
					'key' => 'field_6169fcbc6e64c',
					'label' => 'Button Text',
					'name' => 'button_text',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_6169fda56e64f',
					'label' => 'Button Action',
					'name' => 'button_action',
					'aria-label' => '',
					'type' => 'select',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'choices' => array(
						'to-post' => 'To Feature Post',
						'to-link' => 'To URL',
						'to-modal' => 'Open modal',
						'to-directions' => 'Open Google Maps Directions',
						'do-nothing' => 'Do Nothing',
					),
					'default_value' => false,
					'return_format' => 'value',
					'multiple' => 0,
					'allow_null' => 0,
					'ui' => 0,
					'ajax' => 0,
					'placeholder' => '',
					'create_options' => 0,
					'save_options' => 0,
				),
				array(
					'key' => 'field_625a553260a24',
					'label' => 'Modal Details',
					'name' => 'modal_details',
					'aria-label' => '',
					'type' => 'wysiwyg',
					'instructions' => 'You can show much more information in a modal if you have too much to fit into a normal popup. <span class="mapster-pro-text">Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6169fda56e64f',
								'operator' => '==',
								'value' => 'to-modal',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'allow_in_bindings' => 1,
					'tabs' => 'all',
					'toolbar' => 'full',
					'media_upload' => 1,
					'delay' => 0,
				),
				array(
					'key' => 'field_6169fddd6e650',
					'label' => 'Button URL',
					'name' => 'button_url',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => 'Please ensure that you enter a valid URL here. You may enter phone numbers by using the telephone syntax for HTML links.',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6169fda56e64f',
								'operator' => '==',
								'value' => 'to-link',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'maxlength' => '',
					'allow_in_bindings' => 0,
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
				),
				array(
					'key' => 'field_6169fe006e651',
					'label' => 'Open Link in New Tab',
					'name' => 'open_link_in_new_tab',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => array(
						array(
							array(
								'field' => 'field_6169fda56e64f',
								'operator' => '==',
								'value' => 'to-post',
							),
						),
						array(
							array(
								'field' => 'field_6169fda56e64f',
								'operator' => '==',
								'value' => 'to-link',
							),
						),
					),
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
			),
		),
		array(
			'key' => 'field_61ca464a6f328',
			'label' => 'Open Link on Click',
			'name' => 'open_link_on_click',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Open link by clicking directly on the feature.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_61ca46666f32a',
			'label' => 'Click Link',
			'name' => 'click_link',
			'aria-label' => '',
			'type' => 'group',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_61ca464a6f328',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'layout' => 'block',
			'sub_fields' => array(
				array(
					'key' => 'field_61ca465c6f329',
					'label' => 'URL',
					'name' => 'url',
					'aria-label' => '',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array(
					'key' => 'field_61ca46866f32b',
					'label' => 'Open Link in New Tab',
					'name' => 'open_link_in_new_tab',
					'aria-label' => '',
					'type' => 'true_false',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array(
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'message' => '',
					'default_value' => 1,
					'ui' => 1,
					'ui_on_text' => '',
					'ui_off_text' => '',
				),
			),
		),
		array(
			'key' => 'field_62728e641cb9d',
			'label' => 'Open Popup on Load',
			'name' => 'open_popup_on_load',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => 'Open popup as soon as the map loads.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '55',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'ui' => 1,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_68a60083cecb3',
			'label' => 'Popup Permanently Open',
			'name' => 'popup_permanent',
			'aria-label' => '',
			'type' => 'true_false',
			'instructions' => '<span class="mapster-pro-text">Available in <a href="https://wpmaps.mapster.me/pro" target="_blank">Mapster Pro</a>.</span>',
			'required' => 0,
			'conditional_logic' => array(
				array(
					array(
						'field' => 'field_62728e641cb9d',
						'operator' => '==',
						'value' => '1',
					),
				),
			),
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => '',
			'default_value' => 0,
			'allow_in_bindings' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
			'ui' => 1,
		),
		array(
			'key' => 'field_68a6092990ee9',
			'label' => 'Testing',
			'name' => 'testing',
			'aria-label' => '',
			'type' => 'any_taxonomy',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'allow_in_bindings' => 0,
			'bidirectional' => 0,
			'return_format' => 'id',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-location',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-line',
			),
		),
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'mapster-wp-polygon',
			),
		),
	),
	'menu_order' => 1,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => true,
	'description' => '',
	'show_in_rest' => 0,
) );
} );

endif;
?>
