<style type="text/css">
.mb-board {margin-top:10px;}
.mb-board a{text-decoration:none !important;}
.mb-board table {border-collapse: collapse;table-layout: fixed;word-break: break-all;min-height:209px;}
.mb-board table td{padding:1px 2px 0px;border:1px solid #eee;font-size:13px;}
.mb-board table th{background-color:#F6F6F6;border:1px solid #eee;}
.mb-board .text-left{text-align:left;padding-left:8px !important;}
.mb-board .mb-dash-title{font-size: 21px;margin: 0;line-height: 1.2;display: block;font-weight: 600;float:left;padding:2px 30px 0 0;}
.mb-board .mb-dash-panel-title{font-size: 16px;padding: 10px 0 0;margin: 0;line-height: 2.1;display: block;font-weight: 600;}
.mb-board .mb-dash-box-title{font-size: 14px;padding: 8px 12px;margin: 0;line-height: 1.4;border-bottom: 1px solid #eee;display: block;font-weight: 600;}
.mb-board .store-panel{margin:0px 0 0px;padding: 20px 10px 12px;box-shadow:none; box-shadow: 0 1px 1px rgba(0,0,0,.04);background: #fff;font-size: 13px;position:relative;}
.mb-board .store-panel-content{margin-left:13px;max-width:1500px;}
.mb-board .message-panel{margin:0px 0 0px;padding: 38px 0px 38px;box-shadow:none; text-align:center;border: 1px solid #e5e5e5;box-shadow: 0 1px 1px rgba(0,0,0,.04);    background: #fff;    font-size: 13px;line-height:25px;}

.mb-board .mb-dash-box{border: 1px solid #e5e5e5;border-top:none;box-shadow: 0 1px 1px rgba(0,0,0,.04);background: #fff;}
.mb-board .mc-gallery-regular-price1{text-decoration:line-through;font-size:11px;color:#BBB}
.mb-board .mc-gallery-sale-price1{font-weight:600;line-height:17px;color:#888;font-size:13px;}
.mb-board .mc-gallery-install-text1{font-weight:600;line-height:17px;color:#D11;font-size:13px;}
.mb-board .mc-gallery-install-text2{font-weight:600;line-height:17px;color:#888;font-size:13px;}
.mb-board .gallery-list-body .mc-gallery-title {text-align:left;padding-left:2px;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;min-height:20px;}
.mb-board .gallery-list-body .mc-gallery-title a{color: #676767;}

.mb-board .gallery-list-body .mc-gallery-description {text-align:left;padding-left:2px;text-overflow:ellipsis;overflow:hidden;white-space:nowrap;height:18px;}
.mb-board .gallery-list-body .mc-gallery-price {text-overflow:ellipsis;overflow:hidden;white-space:nowrap;height:24px;padding:2px 0px 2px 2px;}
.gallery-list .gallery-list-body .mc-gallery-item-wrap{ border:0; margin:0px 10px 7px 0 !important; position:relative; overflow:hidden; }
.gallery-list .gallery-list-body .mc-gallery-item-wrap:hover .gallery-hover-box{opacity:1;} 
.gallery-list .gallery-list-body .gallery-hover-box div{overflow:hidden;}
.gallery-list .gallery-list-body .gallery-hover-box{
	padding:10px 7px 10px 7px  !important; font-weight:600 !important; font-size:12px !important; position:absolute; bottom:0px; width:100%; background:rgba(0,0,0,0.6);	line-height:20px;opacity:0;	min-height:66px;
	-webkit-transition: all 0.2s ease-in-out;-moz-transition: all 0.2s ease-in-out;-o-transition: all 0.2s ease-in-out;-ms-transition: all 0.2s ease-in-out;transition: all 0.2s ease-in-out;
}
.mb-board .gallery-list-body .mc-gallery-item-wrap .img:hover{transform:scale(1);}
.gallery-list .gallery-list-body .gallery-hover-box div{color:#fff;}
.gallery-list .gallery-list-body .gallery-hover-box .hover-btn{color:#FFF;border:1px solid #FFF;padding:2px;text-align:center;margin-top:3px;background-color:rgba(255,255,255,0.2);}
.gallery-list .gallery-list-body .gallery-hover-box .hover-btn:hover{color:#fff !important;background-color:rgba(255,255,255,0.3);}

.gallery-list .gallery-list-body .gallery-hover-box .hover-btn3{background-color:rgba(93,151,205,0.8);}
.gallery-list .gallery-list-body .gallery-hover-box .hover-btn.hover-btn3:hover{background-color:rgba(93,151,205,1);}
.gallery-list .gallery-list-body .gallery-hover-box .hover-btn4{background-color:rgba(224,48,48,0.8);}
.gallery-list .gallery-list-body .gallery-hover-box .hover-btn.hover-btn4:hover{background-color:rgba(224,48,48,1);}
.gallery-list .gallery-list-body .gallery-hover-box .hover-btn5{background-color:rgba(37,49,117,0.8);}
.gallery-list .gallery-list-body .gallery-hover-box .hover-btn.hover-btn5:hover{background-color:rgba(37,49,117,1);}
.gallery-list .gallery-list-body .product-status{padding:2px 5px;color:#FFF;font-size:12px;font-weight:600;border-right:1px solid rgba(255,255,255,0.3);border-bottom:1px solid rgba(255,255,255,0.3);}
.gallery-list .gallery-list-body .mc-gallery-item-box-432 .mc-gallery-item-wrap {border: 1px solid #EEE !important;}
.gallery-list .gallery-list-body .mc-gallery-title span {font-size: 13px !important;}
.gallery-list .gallery-list-body .mc-gallery-item-img-432 {margin: 0px !important;}

/*탭 버튼 */
.mb-board button{cursor:pointer;margin-left:-1px;}
.mb-board .tab-menu-off{display:inline-block;min-width:50px;min-height:28px;padding:1px 11px 1px;border:1px solid #dbdbdb;text-align:center !important;background-color:#fff !important;}
.mb-board .tab-menu-on{display:inline-block;min-width:50px;min-height:28px;padding:1px 11px 1px;border:1px solid #dbdbdb;text-align:center !important;background-color:#888 !important;color:#FFF !important;}
.mb-board button.tab-menu-on:hover{background-color:#888 !important;}
.mb-board .tab-menu-on span{color:#FFF !important;}
</style>
<?php 
if(!defined('_MB_') || !is_super_admin()) exit();
do_action('mbw_store_page_init');

$category1			= "";
$product_pid			= "";
$send_data			= array();
if(!empty($_GET["category"])){
	$category1						= mbw_value_filter($_GET["category"]);
	$send_data['category1']		= $category1;
}
if(!empty($_GET["install_product"])){
	$product_pid					= mbw_value_filter($_GET["install_product"],"int");
	$send_data['product_pid']	= $product_pid;
	if(!empty($_GET["cid"])) $send_data['cid']	= mbw_value_filter($_GET["cid"]);
	if(!empty($_GET["token"])) $send_data['token']	= mbw_value_filter($_GET["token"]);
}else if(!empty($_GET["delete_product"])){
	$delete_pid					= mbw_value_filter($_GET["delete_product"],"int");
	$send_data['delete_pid']	= $delete_pid;
	if(!empty($_GET["cid"])) $send_data['cid']	= mbw_value_filter($_GET["cid"]);
	if(!empty($_GET["token"])) $send_data['token']	= mbw_value_filter($_GET["token"]);	
}
if(!function_exists('curl_init')){
	echo '<div class="mb-board"><div class="message-panel"><div style="font-size:15px;font-weight:600;">Error : Call to undefined function curl_init()</div><div style="font-size:15px;font-weight:600;">(스토어 연결 기능을 이용하기 위해서는 PHP - curl_init 모듈을 설치해 주셔야 합니다)</div></div></div>';	
	return;
}
$response			= mbw_request_store_api($send_data);

$mb_version2	= mbw_get_option("mb_version");
$check_version	= '2.3.8';
if(function_exists('get_plugin_data')){
	$plugin_data		= get_plugin_data(MBW_PLUGIN_PATH.'mangboard.php',false,false);
	if(!empty($plugin_data['Version'])){
		$mb_version2	= $plugin_data['Version'];
	}
}

if(!empty($_GET["install_product"])){	
	if(!current_user_can('administrator')){
		echo '<script>alert("'.__MM('MSG_INSTALL_PERMISSION_ERROR').'");moveURL("'.admin_url('admin.php').'?page=mbw_store&category="'.rawurlencode($category1).');</script>';
	}else if(version_compare($mb_version2, $check_version, '<')){
		echo '<script>alert("'.__MM('MSG_INSTALL_VERSION_ERROR').'");moveURL("'.admin_url('admin.php').'?page=mbw_store&category="'.rawurlencode($category1).');</script>';
	}else{
		echo '<div id="wpbody" role="main" class="mb-dash mb-'.esc_attr(mbw_get_vars("device_type")).'">';
		echo '<div id="wpbody-content" aria-label="Main Contents" tabindex="0" style="overflow: hidden;" class="mb-board">';
		$product_pid		= intval($_GET["install_product"]);
		if(!empty($product_pid) && !empty($response[0]['product'])){
			$url					= wp_nonce_url(admin_url("/admin.php?page=mbw_store&install_product=".$product_pid), 'mangboard-store'.$product_pid);
			if(($creds=request_filesystem_credentials($url))===false) return;
			if(!WP_Filesystem($creds)){request_filesystem_credentials($url);return;}

			mbw_install_store_product($product_pid,$response);			
		}else if(!empty($response[0]['content'])){
			echo $response[0]['content'];
			echo '<div style="padding:10px 0;text-align:center;"><div class="button"><a href="'.admin_url('admin.php').'?page=mbw_store" target="">'.__MM("MSG_STORE_MOVE").'</a></div></div>';								
		}else{
			echo '<div class="mb-board"><div class="message-panel"><div style="font-size:15px;font-weight:600;">MangBoard Store Install Error : 502</div></div></div>';	
		}
		echo '</div></div>';
		return;
	}
}else if(!empty($_GET["delete_product"])){
	if(!current_user_can('administrator')){
		echo '<script>alert("'.__MM('MSG_INSTALL_PERMISSION_ERROR').'");moveURL("'.admin_url('admin.php').'?page=mbw_store&category="'.rawurlencode($category1).');</script>';
	}else if(version_compare($mb_version2, $check_version, '<')){
		echo '<script>alert("'.__MM('MSG_INSTALL_VERSION_ERROR').'");moveURL("'.admin_url('admin.php').'?page=mbw_store&category="'.rawurlencode($category1).');</script>';
	}else{
		echo '<div id="wpbody" role="main" class="mb-dash mb-'.esc_attr(mbw_get_vars("device_type")).'">';
		echo '<div id="wpbody-content" aria-label="Main Contents" tabindex="0" style="overflow: hidden;" class="mb-board">';
		$product_pid		= intval($_GET["delete_product"]);
		if(!empty($product_pid) && !empty($response[0]['product'])){
			$url					= wp_nonce_url(admin_url("/admin.php?page=mbw_store&delete_product=".$product_pid), 'mangboard-store'.$product_pid);
			if(($creds=request_filesystem_credentials($url))===false) return;
			if(!WP_Filesystem($creds)){request_filesystem_credentials($url);return;}
			mbw_delete_store_product($product_pid,$response);
		}
		echo '</div></div>';
		return;
	}
}
$mb_locale		= mbw_get_option("locale");
if(empty($response[0]['title'])){
	echo '<div class="mb-board"><div class="message-panel"><div style="font-size:15px;font-weight:600;">MangBoard Store Error : 503</div></div></div>';	
	return;
}
?>
<script type="text/javascript">
function mbw_get_store_product(product_pid,product_name,cid,token){
	<?php
		if(version_compare($mb_version2, $check_version, '<')){
			echo 'alert("'.__MM('MSG_INSTALL_VERSION_ERROR').'");';
		}else{		
	?>
		if(confirm('"'+product_name+'"\n<?php echo __MM("MSG_INSTALL_SELECT_PRODUCT");?>')){
			moveURL("<?php echo admin_url('admin.php');?>?page=mbw_store&install_product="+product_pid+"&cid="+cid+"&token="+token);	
		}
	<?php } ?>
}
function mbw_delete_store_product(product_pid,product_name,cid,token){
	<?php
		if(version_compare($mb_version2, $check_version, '<')){
			echo 'alert("'.__MM('MSG_INSTALL_VERSION_ERROR').'");';
		}else{		
	?>
		if(confirm('"'+product_name+'"\n<?php echo __MM("MSG_DELETE_SELECT_PRODUCT");?>')){
			moveURL("<?php echo admin_url('admin.php');?>?page=mbw_store&delete_product="+product_pid+"&cid="+cid+"&token="+token);	
		}
	<?php } ?>
}
function mbw_get_store_template(product_pid,product_name,cid,token){
	<?php
		if(version_compare($mb_version2, $check_version, '<')){
			echo 'alert("'.__MM('MSG_INSTALL_VERSION_ERROR').'");';
		}else{
	?>
		if(confirm('"'+product_name+'"\n<?php echo __MM("MSG_INSTALL_SELECT_PRODUCT");?>')){
			moveURL("<?php echo admin_url('admin.php');?>?page=mbw_store&install_product="+product_pid+"&cid="+cid+"&token="+token+"&import="+product_pid);	
		}
	<?php } ?>		
}
function mbw_set_store_category(category){
	moveURL("<?php echo admin_url('admin.php');?>?page=mbw_store&category="+decodeURIComponent(category));	
}
</script>

<?php do_action('mbw_store_page_header'); ?>

<div id="wpbody" role="main" class="mb-dash mb-<?php echo esc_attr(mbw_get_vars("device_type"));?>">
<div id="wpbody-content" aria-label="Main Contents" tabindex="0" style="overflow: hidden;" class="mb-board">

<div id="store-panel" class="store-panel">
	<div class="store-panel-content">		
		<div>
			<?php
			if(!empty($response[0]['title'])){
				echo $response[0]['title'];
			}
			?>			
			<?php
			if(!empty($response[0]['description'])){
				echo $response[0]['description'];
			}
			?>			
		</div>
	</div>
	<div style="padding:17px 12px 2px;">
	<?php
		$category_label	= $response[0]['category_label'];
		$category_data	= $response[0]['category_data'];
		$label_array				= explode(",",$category_label);
		$data_array				= explode(",",$category_data);
		$index					= 0;
		$category_value		= $category1;
		if(empty($category_value)) $category_value		= "ALL";
		for($i=0;$i<count($data_array);$i++){
			if($data_array[$i]==$category_value) $tab_menu_class			= "tab-menu-on";
			else $tab_menu_class			= "tab-menu-off";			
			echo '<button onclick="mbw_set_store_category(\''.esc_js($data_array[$i]).'\');return false;" class="'.esc_attr($tab_menu_class).'" title="'.esc_attr($label_array[$i]).'" type="button"><span>'.$label_array[$i].'</span></button>';
			$index++;
		}
	?>
	</div>
	<?php
	if(mbw_get_vars("device_type")!="mobile"){
		if(!empty($response[0]['banner'])){
			echo $response[0]['banner'];
		}
	}
	?>
	<div style="padding:10px;">
	<?php	
	$product_items	= $response[0]['product'];

	$html	= "";
	$html	.= '<div class="mb-style1 gallery-list"><div class="gallery-list-body" style="padding-top:8px;">';

	if(!empty($product_items)){
		foreach($product_items as $product) {
			$title							= $product['title'];
			$description				= $product['description'];
			$link_url						= $product['link_url'];
			if(strpos($link_url, '?') === false)	$link_url		.= "?lang=".$mb_locale;
			else $link_url		.= "&lang=".$mb_locale;

			$image						= $product['image'];
			$product_status			= "";
			if(!empty($image)) $background_image		= 'background-image:url('.esc_url($image).');';
			else $background_image		= "";

			if(!empty($product['is_order'])){
				if(!empty($product['check_dir']) && is_dir(WP_CONTENT_DIR.'/'.$product['check_dir'])){		//설치가 되어있는지 체크
					if(!empty($product['btn_html4'])){
						$product['btn_html3']		= $product['btn_html4'];
					}
					$product_status	= '<div style="position:absolute;top:0;left:0;">'.$product['btn_text2'].'</div>';
				}else{
					$product_status	= '<div style="position:absolute;top:0;left:0;">'.$product['btn_text1'].'</div>';
				}				
			}else if(!empty($product['btn_text3'])){				
				$product_status	= '<div style="position:absolute;top:0;left:0;">'.$product['btn_text3'].'</div>';
			}else{	//dev2
				if(is_dir(WP_CONTENT_DIR.'/'.$product['check_dir']) && !empty($product['btn_text4'])){		//미등록된 설치 상품이 있는지 체크
					$product_status	= '<div style="position:absolute;top:0;left:0;">'.$product['btn_text4'].'</div>';
				}
			}
			if(!empty($product['check_dir']) && is_dir(WP_CONTENT_DIR.'/'.$product['check_dir']) && !empty($product['btn_html5'])){
				$product['btn_html3']		= $product['btn_html5'].$product['btn_html3'];
			}			
			$html	.= '<div class="mc-gallery-item-box-432" style="display:inline-block;width:220px;padding:0 !important;"><div class="mc-gallery-item-wrap">';
			$html	.= '<div class="mc-gallery-item-img-432" style="">
				<a href="'.esc_url($link_url).'" title="'.esc_attr($title).'" target="_blank">
					<div class="img" style="max-width:100%;width:210px;height:184px;margin:0 auto;'.$background_image.'background-position:center center;background-size:cover;background-repeat:no-repeat;"></div>
				</a>			
			</div>
			'.$product_status.'
			<div class="gallery-hover-box" style="height:100%;">
				<div style="text-align:center;line-height:18px;padding:7px 0 10px;">'.$title.'</div>
				<div style="text-align:left;">'.$description.'</div>
				<div style="position:absolute;bottom:5px;left:0;width:96%;margin:0 2%;">'.$product['btn_html1'].$product['btn_html2'].$product['btn_html3'].'</div>
			</div>
			<div class="mc-gallery-title text-center bold" style="font-size:13px;font-weight:600 !important;padding:7px 3px 2px;">
				<a href="'.esc_url($link_url).'" title="'.esc_attr($title).'" target="_blank"><span>'.$title.'</span></a>
			</div>
			<div class="mc-gallery-price text-center" style="padding:0px 0 0px;">
				<a href="'.esc_url($link_url).'" title="'.esc_attr($title).'" target="_blank">
					'.$product['price_html1'].$product['price_html2'].'
				</a>
			</div>';
			$html	.= '</div></div>';
		}
	}
	$html	.= '</div></div>';
	echo $html;
	?>
	</div>
</div>

<?php do_action('mbw_store_page_body'); ?>

</div><!-- wpbody-content -->
</div>
<?php do_action('mbw_store_page_footer'); ?>