<?php

if (!defined('ABSPATH'))
    die('Restricted Access');

class MJTC_user
{

    private $currentuser = null;
    public $socialmedia = null;

    function __construct()
    {
        if (is_user_logged_in()) { // wp user logged in
            $wpuserid = get_current_user_id();
            if (!is_numeric($wpuserid))
                return false;
            $query = "SELECT * FROM `".majesticsupport::$_db->prefix."mjtc_support_users` WHERE wpuid = " . esc_sql($wpuserid);
            $currentuser = majesticsupport::$_db->get_row($query);
            $majesticsupport_registerform = MJTC_request::MJTC_getVar('ms_support_register_nonce', 'post', '');
            $registerform = MJTC_request::MJTC_getVar('majesticsupport_registerform', 'post', 0);
            if ($currentuser == '' and ($majesticsupport_registerform == '' && $registerform == 0)) {// inserting a record in our table
                $userdata = get_userdata($wpuserid);
                $profile['id'] = '';
                // User display name
                $user_first = get_user_meta($wpuserid, 'first_name', true);
                $user_last = get_user_meta($wpuserid, 'last_name', true);
                if ($user_first && $user_last) {
                    $display_name = sprintf(_x('%1$s %2$s', 'Display name based on first name and last name'), $user_first, $user_last);
                } elseif ($user_first) {
                    $display_name = $user_first;
                } elseif ($user_last) {
                    $display_name = $user_last;
                } else {
                    $display_name = $userdata->display_name;
                }

                $profile['name'] = $display_name;
                if ($userdata->display_name == '') {
                    $profile['name'] = $userdata->user_nicename;
                }
                $profile['email'] = $userdata->user_email;
                $profile['wpuid'] = $wpuserid;
                $profile['created'] = date_i18n('Y-m-d H:i:s');
                $profile['status'] = 1;
                $profile['autogenerated'] = 1;

                $row = MJTC_includer::MJTC_getTable('users');
                $data['id'] = '';
                $data['wpuid'] = $wpuserid;
                $data['name'] = $profile['name'];
                $data['display_name'] = $display_name;
                $data['user_nicename'] = $userdata->user_nicename;
                $data['user_email'] = $userdata->user_email;
                $data['issocial'] = 0;
                $data['socialid'] = null;
				$data['created'] = date_i18n('Y-m-d H:i:s');
                $data['status'] = 1;
                $data['autogenerated'] = 1;
                $row->bind($data);
                $row->store();

                if (is_numeric($row->id)) {
                    $query = "SELECT * FROM `".majesticsupport::$_db->prefix."mjtc_support_users` WHERE id = " . esc_sql($row->id);
                    $currentuser = majesticsupport::$_db->get_results($query);
                }
            }
            $this->currentuser = $currentuser;
        } else { // wp user is not logged in
            if (in_array('sociallogin', majesticsupport::$_active_addons)){
                if (isset($_COOKIE['majesticsupport-socialid']) && !empty($_COOKIE['majesticsupport-socialid'])) { // social user is logged in
                    $query = "SELECT * FROM `".majesticsupport::$_db->prefix."mjtc_support_users` WHERE socialid = '" . esc_sql(majesticsupport::MJTC_sanitizeData($_COOKIE['majesticsupport-socialid'])) . "'";// MJTC_sanitizeData() function uses wordpress santize functions
                    $this->currentuser = majesticsupport::$_db->get_row($query);

                    $this->socialmedia = isset($_COOKIE['majesticsupport-socialmedia']) ? majesticsupport::MJTC_sanitizeData($_COOKIE['majesticsupport-socialmedia']) : '';// MJTC_sanitizeData() function uses wordpress santize functions
                }
            }
        }
    }

    function MJTC_isguest()
    {
        if (isset($_COOKIE['majesticsupport-socialid']) && !empty($_COOKIE['majesticsupport-socialid'])) {
            if (in_array('sociallogin', majesticsupport::$_active_addons)) {
                return false;
            } else {
                return true;
            }
        } elseif ($this->currentuser == null && !is_user_logged_in()) { // current user is guest
            return true;
        } else {
            return false;
        }
    }

    function MJTC_isdisabled()
    {
        if ($this->currentuser != null && $this->currentuser->status == 0) { // current user is disabled
            return true;
        } else {
            return false;
        }
    }

    function MJTC_uid()
    {

        if ($this->currentuser != null) {

            return $this->currentuser->id;
        }
    }

    function MJTC_wpuid()
    {

        if ($this->currentuser != null) {

            return $this->currentuser->wpuid;
        }
    }

    function MJTC_emailaddress()
    {
        if ($this->currentuser == null) { // current user is guest
            return false;
        } else {
            return $this->currentuser->emailaddress;
        }
    }

    function MJTC_fullname()
    {
        if ($this->currentuser == null) { // current user is guest
            return false;
        } else {
            $name = $this->currentuser->name;
            if($name == ""){
                $name = $this->currentuser->display_name;
            }
            if($name == ""){
                $name = $this->currentuser->user_nicename;
            }
            if($name == ""){ // get from wordpress
                $current_user = wp_get_current_user();
                if(0 != $current_user->ID){
                    $name = $current_user->user_firstname.' '.$current_user->user_lastname;
                    if($name == ""){
                        $name = $current_user->display_name;
                    }
                }
            }
            return $name;
        }
    }


    function MJTC_isMajesticSupportUser()
    {
        if (is_user_logged_in()) { // wp user logged in
            $wpuserid = MJTC_includer::MJTC_getObjectClass('user')->MJTC_uid();
            if (!is_numeric($wpuserid))
                return false;
            $query = "SELECT COUNT(id) FROM `".majesticsupport::$_db->prefix."mjtc_support_users` WHERE wpuid = " . esc_sql($wpuserid);
            $result = majesticsupport::$_db->get_results($query);
            if ($result > 0) {
                return true;
            } else {
                return false;
            }
        } else {
            if (isset($_COOKIE['majesticsupport-socialid']) && !empty($_COOKIE['majesticsupport-socialid'])) { // social user is logged in
                $query = "SELECT COUNT(id) FROM `".majesticsupport::$_db->prefix."mjtc_support_users` WHERE socialid = '" . esc_sql(majesticsupport::MJTC_sanitizeData($_COOKIE['majesticsupport-socialid'])) . "'";// MJTC_sanitizeData() function uses wordpress santize functions
                $result = majesticsupport::$_db->get_results($query);
                if ($result > 0) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    function MJTC_isSocialLogin()
    {
        if (isset($_COOKIE['majesticsupport-socialid']) && !empty($_COOKIE['majesticsupport-socialid'])) {
            return true;
        } else {
            return false;
        }
    }

    function MJTC_getmajesticsupportuidbyuserid($userid)
    {
        if (!is_numeric($userid)) return false;
        $query = "SELECT id FROM `".majesticsupport::$_db->prefix."mjtc_support_users` WHERE wpuid = " . esc_sql($userid);
        $uid = majesticsupport::$_db->get_results($query);
        return $uid;
    }

    function MJTC_getMSCurrentUser(){
        return $this->currentuser;
    }

    function MJTC_deleteUserRecords($uid , $is_delete_user = false ){
        if(! is_numeric($uid))
            return false;
        $model = MJTC_includer::MJTC_getModel('ticket');
        $query = "SELECT id , ticketid FROM `".majesticsupport::$_db->prefix."mjtc_support_tickets` WHERE wpuid = ".esc_sql($uid);
        $tickets = majesticsupport::$_db->get_results($query);

        do_action('ms_addon_deletequery_for_user');
        $query = "DELETE  ticket, reply,attachment,activity_log,erasedatarequests ". majesticsupport::$_addon_query['select'] . "
            FROM `". majesticsupport::$_db->prefix ."mjtc_support_users` AS user
            LEFT JOIN `". majesticsupport::$_db->prefix ."mjtc_support_tickets` AS ticket ON ticket.uid = user.id
            LEFT JOIN `". majesticsupport::$_db->prefix ."mjtc_support_replies` AS reply ON reply.ticketid = ticket.id
            LEFT JOIN `". majesticsupport::$_db->prefix ."mjtc_support_attachments` AS attachment ON attachment.ticketid = ticket.id
            LEFT JOIN `". majesticsupport::$_db->prefix ."mjtc_support_activity_log` AS activity_log ON activity_log.uid = user.id
            LEFT JOIN `". majesticsupport::$_db->prefix ."mjtc_support_erasedatarequests` AS erasedatarequests ON erasedatarequests.uid = user.id
            "
            . majesticsupport::$_addon_query['join'] . "
            WHERE user.id = " . esc_sql($uid);
        majesticsupport::$_db->query($query);
        do_action('reset_ms_aadon_query');
        $query = "DELETE user FROM `".majesticsupport::$_db->prefix."mjtc_support_users` AS user WHERE wpuid = " . esc_sql($uid);
        if(majesticsupport::$_db->query($query)){
            $maindir = wp_upload_dir();
            $basedir = $maindir['basedir'];
            $datadirectory = majesticsupport::$_config['data_directory'];
            $path = $basedir . '/' . $datadirectory. '/attachmentdata/ticket';
            foreach ($tickets as $key) {
                $userpath = $path . '/' . $key->ticketid;
                $files = glob($userpath.'/*');      
                // Deleting all the files in the list 
                foreach($files as $file) { 
                    if(is_file($file))  {
                        wp_delete_file($file);  
                    }
                }
                rmdir($userpath);
            }
            return true;
        }else{
            return false;
        }
    }

    function MJTC_getUserIDByWPUid($wpuid) {
        if (!is_numeric($wpuid))
            return false;

        $query = "SELECT id FROM `".majesticsupport::$_db->prefix."mjtc_support_users` WHERE wpuid = " . esc_sql($wpuid);
        $result = majesticsupport::$_db->get_var($query);
        return $result;
    }

    function MJTC_getUserNameByUid($uid) {
        if (!is_numeric($uid))
            return false;

        $query = "SELECT display_name,user_nicename FROM `".majesticsupport::$_db->prefix."mjtc_support_users` WHERE id = " . esc_sql($uid);
        $result = majesticsupport::$_db->get_row($query);
        return $result;
    }

}

