<?php

if (!defined('ABSPATH'))
    die('Restricted Access');

class MJTC_uploads {

    private $ticketid;
    private $articleid;
    private $downloadid;
    private $categoryid;
    private $staffid;
    private $uploadfor;

    function MJTC_upload_dir( $dir ) {
        $form_request = MJTC_request::MJTC_getVar('form_request');
        if($form_request == 'majesticsupport' OR $this->uploadfor == 'agent'){
            $datadirectory = majesticsupport::$_config['data_directory'];
            $path = $datadirectory . '/attachmentdata';

            $foldername = '';

            if($this->uploadfor == 'ticket'){
                if(!is_numeric($this->ticketid)) return false;
                $path = $path . '/ticket';
                $query = "SELECT attachmentdir FROM `".majesticsupport::$_db->prefix."mjtc_support_tickets` WHERE id = ".esc_sql($this->ticketid);
                $foldername = majesticsupport::$_db->get_var($query);
            }elseif($this->uploadfor == 'article'){
                $path = $path . '/articles/article_'.$this->articleid;
            }elseif($this->uploadfor == 'download'){
                $path = $path . '/downloads/download_'.$this->downloadid;
            }elseif($this->uploadfor == 'category'){
                $path = $datadirectory . '/knowledgebasedata/categories/category_'.$this->categoryid;
            }elseif($this->uploadfor == 'agent'){
                $path = $datadirectory . '/staffdata/staff_'.$this->staffid;
            }

            $userpath = $path . '/' . $foldername;
            $array = array(
                'path'   => $dir['basedir'] . '/' . $userpath,
                'url'    => $dir['baseurl'] . '/' . $userpath,
                'subdir' => '/'. $userpath,
            ) + $dir;
            return $array;
        }elseif($this->uploadfor == 'notificationlogo'){
            $datadirectory = majesticsupport::$_config['data_directory'];
            $path = $datadirectory;
            return $path;

        }else{
            return $dir;
        }
    }

    function MJTC_storeTicketAttachment($data, $caller){
        $ticketid = $data['ticketid'];
        $filesize = majesticsupport::$_config['file_maximum_size'];
        if (!function_exists('wp_handle_upload')) {
            do_action('majesticsupport_load_wp_file');
        }
        $this->ticketid = $ticketid;
        $this->uploadfor = 'ticket';
        // Register our path override.
        add_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        // Do our thing. WordPress will move the file to 'uploads/mycustomdir'.
        $result = array();
        if(!isset($_FILES['filename'])){
            return;
        }
        $files = majesticsupport::MJTC_sanitizeData($_FILES['filename']);// MJTC_sanitizeData() function uses wordpress santize functions

        if(!is_array($files['name'])){
            return;
        }

        foreach ($files['name'] as $key => $value) {
            if ($files['name'][$key]) {
                $file = array(
                        'name'     => $files['name'][$key],
                        'type'     => $files['type'][$key],
                        'tmp_name' => $files['tmp_name'][$key],
                        'error'    => $files['error'][$key],
                        'size'     => $files['size'][$key]
                        );
                $MJTC_uploadfilesize = $file['size'] / 1024; //kb
                if($MJTC_uploadfilesize > $filesize){
                    MJTC_message::MJTC_setMessage(esc_html(__('Error file size too large', 'majestic-support')), 'error');
                    return;
                }
                $filetyperesult = wp_check_filetype(sanitize_file_name($_FILES['filename']['name'][$key]));
                if(!empty($filetyperesult['ext']) && !empty($filetyperesult['type'])){
                    $document_file_types = MJTC_includer::MJTC_getModel('configuration')->getConfigValue('file_extension');
                    if(MJTC_majesticsupportphplib::MJTC_stristr($document_file_types, $filetyperesult['ext'])){

                        $result = wp_handle_upload($file, array('test_form' => false));
                        if ( $result && ! isset( $result['error'] ) ) {
                            // Get the folder where the file was uploaded
                            $file_directory = dirname($result['file']);
                            $filename = MJTC_majesticsupportphplib::MJTC_basename( $result['file'] );
                            $replyattachmentid = isset($data['replyattachmentid']) ? $data['replyattachmentid'] : '';
                            $result = $caller->MJTC_storeTicketAttachment($ticketid, $replyattachmentid, $MJTC_uploadfilesize, $filename);
                        } else {
                            /**
                             * Error generated by _wp_handle_upload()
                             * @see _wp_handle_upload() in wp-admin/includes/file.php
                             */
                            MJTC_message::MJTC_setMessage($result['error'], 'error');
                        }
                    }
                }
            }
        }
        // generate index file
        if (!empty($file_directory)) {
            MJTC_includer::MJTC_getModel('majesticsupport')->generateIndexFile($file_directory);
        }
        // Set everything back to normal.
        remove_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        return;
    }

    function MJTC_storeTicketViaEmailAttachment($idsarray,$key,$value){
        $ticketid = $idsarray[0];
        if(!is_numeric($ticketid))
            return;
        $datadirectory = majesticsupport::$_config['data_directory'];
        $maindir = wp_upload_dir();
        $path = $maindir['basedir'];
        $path = $path .'/'.$datadirectory;
        if (!file_exists($path)) { // create user directory
            MJTC_includer::MJTC_getModel('majesticsupport')->makeDir($path);
        }
        $path = $path . '/attachmentdata';
        if (!file_exists($path)) { // create user directory
            MJTC_includer::MJTC_getModel('majesticsupport')->makeDir($path);
        }
        $path = $path . '/ticket';
        if (!file_exists($path)) { // create user directory
            MJTC_includer::MJTC_getModel('majesticsupport')->makeDir($path);
        }
        $query = "SELECT attachmentdir FROM `".majesticsupport::$_db->prefix."mjtc_support_tickets` WHERE id = ".esc_sql($idsarray[0]);
        $foldername = majesticsupport::$_db->get_var($query);

        $path = $path . '/' . $foldername;
        if (!file_exists($path)) { // create user directory
            MJTC_includer::MJTC_getModel('majesticsupport')->makeDir($path);
        }

        file_put_contents($path . '/' . $key, $value); // save the file
        return true;
    }

    function MJTC_storeArticleAttachment($data, $caller){
        $id = $data['id'];
        $filesize = majesticsupport::$_config['file_maximum_size'];
        if (!function_exists('wp_handle_upload')) {
            do_action('majesticsupport_load_wp_file');
        }
        $this->articleid = $id;
        $this->uploadfor = 'article';
        // Register our path override.
        add_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        // Do our thing. WordPress will move the file to 'uploads/mycustomdir'.
        $result = array();
        if(!isset($_FILES['filename'])){
            return;
        }
        $files = majesticsupport::MJTC_sanitizeData($_FILES['filename']);// MJTC_sanitizeData() function uses wordpress santize functions
        if(!is_array($files['name'])){
            return;
        }

        foreach ($files['name'] as $key => $value) {
            if ($files['name'][$key]) {
                $file = array(
                        'name'     => $files['name'][$key],
                        'type'     => $files['type'][$key],
                        'tmp_name' => $files['tmp_name'][$key],
                        'error'    => $files['error'][$key],
                        'size'     => $files['size'][$key]
                        );
                $MJTC_uploadfilesize = $file['size'] / 1024; //kb
                if($MJTC_uploadfilesize > $filesize){
                    MJTC_message::MJTC_setMessage(esc_html(__('Error file size too large', 'majestic-support')), 'error');
                    return;
                }

                $filetyperesult = wp_check_filetype(sanitize_file_name($_FILES['filename']['name'][$key]));
                if(!empty($filetyperesult['ext']) && !empty($filetyperesult['type'])){
                    $document_file_types = MJTC_includer::MJTC_getModel('configuration')->getConfigValue('file_extension');
                    if(MJTC_majesticsupportphplib::MJTC_stristr($document_file_types, $filetyperesult['ext'])){

                        $result = wp_handle_upload($file, array('test_form' => false));
                        if ( $result && ! isset( $result['error'] ) ) {
                            // Get the folder where the file was uploaded
                            $file_directory = dirname($result['file']);
                            $filename = MJTC_majesticsupportphplib::MJTC_basename( $result['file'] );
                            $result = $caller->storeArticleAttachmet($id , $MJTC_uploadfilesize, $filename);
                        } else {
                            /**
                             * Error generated by _wp_handle_upload()
                             * @see _wp_handle_upload() in wp-admin/includes/file.php
                             */
                            MJTC_message::MJTC_setMessage($result['error'], 'error');
                        }
                    }
                }
            }
        }
        // generate index file
        if (!empty($file_directory)) {
            MJTC_includer::MJTC_getModel('majesticsupport')->generateIndexFile($file_directory);
        }
        // Set everything back to normal.
        remove_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        return;
    }

    function MJTC_storeDownloadAttachment($data, $caller){
        $id = $data['id'];
        $filesize = majesticsupport::$_config['file_maximum_size'];
        if (!function_exists('wp_handle_upload')) {
            do_action('majesticsupport_load_wp_file');
        }
        $this->downloadid = $id;
        $this->uploadfor = 'download';
        // Register our path override.
        add_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        // Do our thing. WordPress will move the file to 'uploads/mycustomdir'.
        $result = array();
        if(!isset($_FILES['filename'])){
            return;
        }
        $files = majesticsupport::MJTC_sanitizeData($_FILES['filename']);// MJTC_sanitizeData() function uses wordpress santize functions
        if(!is_array($files['name'])){
            return;
        }

        foreach ($files['name'] as $key => $value) {
            if ($files['name'][$key]) {
                $file = array(
                        'name'     => $files['name'][$key],
                        'type'     => $files['type'][$key],
                        'tmp_name' => $files['tmp_name'][$key],
                        'error'    => $files['error'][$key],
                        'size'     => $files['size'][$key]
                        );
                $MJTC_uploadfilesize = $file['size'] / 1024; //kb
                if($MJTC_uploadfilesize > $filesize){
                    MJTC_message::MJTC_setMessage(esc_html(__('Error file size too large', 'majestic-support')), 'error');
                    return;
                }
                $filetyperesult = wp_check_filetype(sanitize_file_name($_FILES['filename']['name'][$key]));
                if(!empty($filetyperesult['ext']) && !empty($filetyperesult['type'])){
                    $document_file_types = MJTC_includer::MJTC_getModel('configuration')->getConfigValue('file_extension');
                    if(MJTC_majesticsupportphplib::MJTC_stristr($document_file_types, $filetyperesult['ext'])){
                        $result = wp_handle_upload($file, array('test_form' => false));
                        if ( $result && ! isset( $result['error'] ) ) {
                            // Get the folder where the file was uploaded
                            $file_directory = dirname($result['file']);
                            $filename = MJTC_majesticsupportphplib::MJTC_basename( $result['file'] );
                            $result = $caller->MJTC_storeDownloadAttachment($id , $MJTC_uploadfilesize, $filename);
                        } else {
                            /**
                             * Error generated by _wp_handle_upload()
                             * @see _wp_handle_upload() in wp-admin/includes/file.php
                             */
                            MJTC_message::MJTC_setMessage($result['error'], 'error');
                        }
                    }
                }
            }
        }
        // generate index file
        if (!empty($file_directory)) {
            MJTC_includer::MJTC_getModel('majesticsupport')->generateIndexFile($file_directory);
        }
        // Set everything back to normal.
        remove_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        return;
    }

    function MJTC_uploadCategoryLogo($id , $caller){

        if(!is_numeric($id))
            return false;
        $filesize = majesticsupport::$_config['file_maximum_size'];
        if (!function_exists('wp_handle_upload')) {
            do_action('majesticsupport_load_wp_file');
        }
        $this->categoryid = $id;
        $this->uploadfor = 'category';
        // Register our path override.
        add_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        // Do our thing. WordPress will move the file to 'uploads/mycustomdir'.
        $result = array();
        $file = array(
                'name'     => sanitize_file_name($_FILES['filename']['name']),
                'type'     => majesticsupport::MJTC_sanitizeData($_FILES['filename']['type']),
                'tmp_name' => majesticsupport::MJTC_sanitizeData($_FILES['filename']['tmp_name']),
                'error'    => majesticsupport::MJTC_sanitizeData($_FILES['filename']['error']),
                'size'     => majesticsupport::MJTC_sanitizeData($_FILES['filename']['size']),
                );// MJTC_sanitizeData() function uses wordpress santize functions
        $MJTC_uploadfilesize = $file['size'] / 1024; //kb
        if($MJTC_uploadfilesize > $filesize){
            MJTC_message::MJTC_setMessage(esc_html(__('Error file size too large', 'majestic-support')), 'error');
            return;
        }

        $filetyperesult = wp_check_filetype(sanitize_file_name($_FILES['filename']['name']));
        if(!empty($filetyperesult['ext']) && !empty($filetyperesult['type'])){
            $image_file_types = MJTC_includer::MJTC_getModel('configuration')->getConfigValue('file_extension');

            if(MJTC_majesticsupportphplib::MJTC_stristr($image_file_types, $filetyperesult['ext'])){

                $result = wp_handle_upload($file, array('test_form' => false));
                if ( $result && ! isset( $result['error'] ) ) {
                    // Get the folder where the file was uploaded
                    $file_directory = dirname($result['file']);
                    $filename = MJTC_majesticsupportphplib::MJTC_basename( $result['file'] );
                    $result = $caller->storeCategoryLogo($id , $filename);
                    // generate index file
                    MJTC_includer::MJTC_getModel('majesticsupport')->generateIndexFile($file_directory);
                } else {
                    /**
                     * Error generated by _wp_handle_upload()
                     * @see _wp_handle_upload() in wp-admin/includes/file.php
                     */
                    MJTC_message::MJTC_setMessage($result['error'], 'error');
                }
            }
        }
        // Set everything back to normal.
        remove_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        return;
    }

    function MJTC_uploadStaffLogo($id , $caller){
        if(!is_numeric($id))
            return false;
        $filesize = majesticsupport::$_config['file_maximum_size'];
        if (!function_exists('wp_handle_upload')) {
            do_action('majesticsupport_load_wp_file');
        }
        $this->staffid = $id;
        $this->uploadfor = 'agent';
        // Register our path override.
        add_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        // Do our thing. WordPress will move the file to 'uploads/mycustomdir'.
        $result = array();
        $file = array(
                'name'     => sanitize_file_name($_FILES['filename']['name']),
                'type'     => majesticsupport::MJTC_sanitizeData($_FILES['filename']['type']),
                'tmp_name' => majesticsupport::MJTC_sanitizeData($_FILES['filename']['tmp_name']),
                'error'    => majesticsupport::MJTC_sanitizeData($_FILES['filename']['error']),
                'size'     => majesticsupport::MJTC_sanitizeData($_FILES['filename']['size']),
                );// MJTC_sanitizeData() function uses wordpress santize functions
        $MJTC_uploadfilesize = $file['size'] / 1024; //kb
        if($MJTC_uploadfilesize > $filesize){
            MJTC_message::MJTC_setMessage(esc_html(__('Error file size too large', 'majestic-support')), 'error');
            return;
        }
        $filetyperesult = wp_check_filetype(sanitize_file_name($_FILES['filename']['name']));
        if(!empty($filetyperesult['ext']) && !empty($filetyperesult['type'])){
            $image_file_types = MJTC_includer::MJTC_getModel('configuration')->getConfigValue('file_extension');
            if(MJTC_majesticsupportphplib::MJTC_stristr($image_file_types, $filetyperesult['ext'])){

                $result = wp_handle_upload($file, array('test_form' => false));
                if ( $result && ! isset( $result['error'] ) ) {
                    // Get the folder where the file was uploaded
                    $file_directory = dirname($result['file']);
                    $filename = MJTC_majesticsupportphplib::MJTC_basename( $result['file'] );
                    $result = $caller->storeStaffLogo($id , $filename);
                    // generate index file
                    MJTC_includer::MJTC_getModel('majesticsupport')->generateIndexFile($file_directory);
                } else {
                    /**
                     * Error generated by _wp_handle_upload()
                     * @see _wp_handle_upload() in wp-admin/includes/file.php
                     */
                    MJTC_message::MJTC_setMessage($result['error'], 'error');
                }
            }
        }
        // Set everything back to normal.
        remove_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        return;
    }

    function MJTC_storeTicketCustomUploadFile($id, $field){
        if(!isset($_FILES[$field])){
            return;
        }
        if (!function_exists('wp_handle_upload')) {
            do_action('majesticsupport_load_wp_file');
        }
        $filesize = majesticsupport::$_config['file_maximum_size'];
        $this->ticketid = $id;
        $this->uploadfor = 'ticket';
        // Register our path override.
        add_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        // Do our thing. WordPress will move the file to 'uploads/mycustomdir'.
        $result = array();
        $file = array(
                'name'     => sanitize_file_name($_FILES[$field]['name']),
                'type'     => majesticsupport::MJTC_sanitizeData($_FILES[$field]['type']),
                'tmp_name' => majesticsupport::MJTC_sanitizeData($_FILES[$field]['tmp_name']),
                'error'    => majesticsupport::MJTC_sanitizeData($_FILES[$field]['error']),
                'size'     => majesticsupport::MJTC_sanitizeData($_FILES[$field]['size'])
                );// MJTC_sanitizeData() function uses wordpress santize functions
        $MJTC_uploadfilesize = majesticsupport::MJTC_sanitizeData($_FILES[$field]['size']) / 1024; //kb
        // MJTC_sanitizeData() function uses wordpress santize functions
        if($MJTC_uploadfilesize > $filesize){
            MJTC_message::MJTC_setMessage(esc_html(__('Error file size too large', 'majestic-support')), 'error');
            return;
        }
        $filetyperesult = wp_check_filetype(sanitize_file_name($_FILES[$field]['name']));
        if(!empty($filetyperesult['ext']) && !empty($filetyperesult['type'])){
            $image_file_types = MJTC_includer::MJTC_getModel('configuration')->getConfigValue('file_extension');
            if(MJTC_majesticsupportphplib::MJTC_strstr($image_file_types, $filetyperesult['ext'])){

                $result = wp_handle_upload($file, array('test_form' => false));
                if (isset( $result['error'] ) ) {
                    /**
                     * Error generated by _wp_handle_upload()
                     * @see _wp_handle_upload() in wp-admin/includes/file.php
                     */
                    MJTC_message::MJTC_setMessage($result['error'], 'error');
                }else{
                    $filename = MJTC_majesticsupportphplib::MJTC_basename( $result['file'] );
                    // Get the folder where the file was uploaded
                    $file_directory = dirname($result['file']);
                    // generate index file
                    MJTC_includer::MJTC_getModel('majesticsupport')->generateIndexFile($file_directory);
                }
            }
        }
        // Set everything back to normal.
        remove_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        //to store name of custom file in params
        MJTC_includer::MJTC_getModel('ticket')->storeUploadFieldValueInParams($id,$filename,$field);
        return;
    }

	function MJTC_uploadInternalNoteAttachment($id,$field){
        if(!isset($_FILES[$field])){
            return;
        }
        $filename = '';
        $filesize = '';
        if (!function_exists('wp_handle_upload')) {
            do_action('majesticsupport_load_wp_file');
        }
        $filesize = majesticsupport::$_config['file_maximum_size'];
        $this->ticketid = $id;
        $this->uploadfor = 'ticket';
        // Register our path override.
        add_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        // Do our thing. WordPress will move the file to 'uploads/mycustomdir'.
        $result = array();
        $file = array(
                'name'     => sanitize_file_name($_FILES[$field]['name']),
                'type'     => majesticsupport::MJTC_sanitizeData($_FILES[$field]['type']),
                'tmp_name' => majesticsupport::MJTC_sanitizeData($_FILES[$field]['tmp_name']),
                'error'    => majesticsupport::MJTC_sanitizeData($_FILES[$field]['error']),
                'size'     => majesticsupport::MJTC_sanitizeData($_FILES[$field]['size'])
                );// MJTC_sanitizeData() function uses wordpress santize functions
        $MJTC_uploadfilesize = majesticsupport::MJTC_sanitizeData($_FILES[$field]['size']) / 1024; //kb
        // MJTC_sanitizeData() function uses wordpress santize functions
        if($MJTC_uploadfilesize > $filesize){
            MJTC_message::MJTC_setMessage(esc_html(__('Error file size too large', 'majestic-support')), 'error');
            return;
        }
        $filetyperesult = wp_check_filetype(sanitize_file_name($_FILES[$field]['name']));
        if(!empty($filetyperesult['ext']) && !empty($filetyperesult['type'])){
            $image_file_types = MJTC_includer::MJTC_getModel('configuration')->getConfigValue('file_extension');
            if(MJTC_majesticsupportphplib::MJTC_strstr($image_file_types, $filetyperesult['ext'])){

                $result = wp_handle_upload($file, array('test_form' => false));
                if (isset( $result['error'] ) ) {
                    /**
                     * Error generated by _wp_handle_upload()
                     * @see _wp_handle_upload() in wp-admin/includes/file.php
                     */
                    MJTC_message::MJTC_setMessage($result['error'], 'error');
                }else{
					$filename = MJTC_majesticsupportphplib::MJTC_basename( $result['file'] );
					$filesize = $file['size'];
                    // Get the folder where the file was uploaded
                    $file_directory = dirname($result['file']);
                    // generate index file
                    MJTC_includer::MJTC_getModel('majesticsupport')->generateIndexFile($file_directory);
				}
            }
        }
        // Set everything back to normal.
        remove_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
		if($filename != '' && $filesize != ''){
			$array = array('filename' => $filename, 'filesize' => $filesize);
			return $array;
		}else{
			return false;
		}
	}

    function MJTC_uploadDesktopNotificationLogo(){
        $filesize = majesticsupport::$_config['file_maximum_size'];
        if (!function_exists('wp_handle_upload')) {
            do_action('majesticsupport_load_wp_file');
        }
        $this->uploadfor = 'notificationlogo';
        // Register our path override.
        add_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        // Do our thing. WordPress will move the file to 'uploads/mycustomdir'.
        $result = array();
        $file = array(
                'name'     => sanitize_file_name($_FILES['logo_for_desktop_notfication']['name']),
                'type'     => majesticsupport::MJTC_sanitizeData($_FILES['logo_for_desktop_notfication']['type']),
                'tmp_name' => majesticsupport::MJTC_sanitizeData($_FILES['logo_for_desktop_notfication']['tmp_name']),
                'error'    => majesticsupport::MJTC_sanitizeData($_FILES['logo_for_desktop_notfication']['error']),
                'size'     => majesticsupport::MJTC_sanitizeData($_FILES['logo_for_desktop_notfication']['size']),
                );// MJTC_sanitizeData() function uses wordpress santize functions
        $MJTC_uploadfilesize = $file['size'] / 1024; //kb
        if($MJTC_uploadfilesize > $filesize){
            MJTC_message::MJTC_setMessage(esc_html(__('Error file size too large', 'majestic-support')), 'error');
            return;
        }
        $filetyperesult = wp_check_filetype(sanitize_file_name($_FILES['logo_for_desktop_notfication']['name']));
        if(!empty($filetyperesult['ext']) && !empty($filetyperesult['type'])){
            $image_file_types = MJTC_includer::MJTC_getModel('configuration')->getConfigValue('file_extension');
            if(MJTC_majesticsupportphplib::MJTC_stristr($image_file_types, $filetyperesult['ext'])){
                $result = wp_handle_upload($file, array('test_form' => false));
                if ( $result && ! isset( $result['error'] ) ) {
                    // Get the folder where the file was uploaded
                    $file_directory = dirname($result['file']);
                    $filename = MJTC_majesticsupportphplib::MJTC_basename( $result['file'] );
                    $result = MJTC_includer::MJTC_getModel('configuration')->storeDesktopNotificationLogo($filename);
                    // generate index file
                    MJTC_includer::MJTC_getModel('majesticsupport')->generateIndexFile($file_directory);
                } else {
                    MJTC_message::MJTC_setMessage($result['error'], 'error');
                }
            }
        }
        // Set everything back to normal.
        remove_filter( 'upload_dir', array($this,'MJTC_upload_dir'));
        return;
    }

}

?>
