<?php

namespace MailOptin\CtctConnect;

class Subscription extends AbstractCtctConnect
{
    public $email;
    public $name;
    public $list_id;
    public $extras;

    public function __construct($email, $name, $list_id, $extras)
    {
        $this->email   = $email;
        $this->name    = $name;
        $this->list_id = $list_id;
        $this->extras  = $extras;

        parent::__construct();
    }

    /**
     * @return mixed
     */
    public function subscribe()
    {
        try {
            $name_split = self::get_first_last_names($this->name);

            $custom_fields = [];
            if (isset($this->extras['mo-acceptance']) && $this->extras['mo-acceptance'] == 'yes') {
                $gdpr_tag        = apply_filters('mo_connections_constant_contact_acceptance_tag', 'GDPR');
                $custom_fields[] = $gdpr_tag;
            }

            $response = $this->ctctInstance()->addContactToList($this->email, $this->list_id, $name_split[0], $name_split[1], $custom_fields);

            if ($response) {
                return parent::ajax_success();
            }

            return parent::ajax_failure();

        } catch (\Exception $e) {
            self::save_optin_error_log($e->getCode() . ': ' . $e->getMessage(), 'constantcontact', $this->extras['optin_campaign_id'], $this->extras['optin_campaign_type']);

            return parent::ajax_failure();
        }
    }
}