# MailerSend - Official SMTP Integration

Improve your deliverability and avoid the spam box with MailerSend’s SMTP server. Check your analytics to improve your
emails for better conversion!

## Description

WordPress hosting companies are not optimized for high-volume email sending, which may result in some of your emails not
getting delivered. MailerSend’s [dedicated SMTP server](https://www.mailersend.com/features/smtp-relay) will ensure that
your forms, account notifications, e-commerce orders, and other transactional emails get delivered. By using this
official SMTP plugin, you will:

* Improve your email deliverability
* Protect your domain reputation
* Learn more about your recipients

### Deliverability

Improve inbox performance and ensure a smooth customer experience by letting MailerSend take care of email sending.
After a decade of email delivery experience, MailerSend’s deliverability experts understand what it takes to avoid spam
filters, stay off blocklists and lower bounce rates.

### Domain reputation

Keep your domain reputation safe with MailerSend’s email authentication practices. Give your customers the confidence
that they’re interacting with an established brand, and let MailerSend manage the emails that could potentially damage
your reputation.

### Analytics

Understand what happens after an email gets sent. Access a wide range of key metrics—like open rates, bounce rates and
click-through rates—to learn what works and what needs optimization so you can keep improving your email performance.

### Features

* Avoid spam filters, prevent blocklisting, and lower hard bounce rates with powerful sending infrastructure
* Automate the customer experience by connecting to thousands of other apps with Zapier
* Get instant push updates with webhooks
* Receive customer replies sent to your domain with an inbound route feature
* Monitor all email interactions such as opens, clicks, open locations and devices. Plus, use your own subdomain and get
  a custom tracking link!

### How it works

1. Install and activate the MailerSend plugin.
2. Add your [SMTP credentials](https://app.mailersend.com/domains) from MailerSend to establish the connection.
3. Test your connection to make sure it’s working.
4. And get sending!

### Support

Get help whenever you need it. [Contact us](https://www.mailersend.com/contact-us) or drop a message via live chat in
the app. MailerSend’s dedicated support team works 24/7 because transactional emails never stop.

## Frequently Asked Questions

### Why use MailerSend rather than WordPress to send emails?

* Most WordPress hosting services use the PHP mail() function to send emails. But different email configurations between
  web hosts mean that they may not be optimized for deliverability.
* MailerSend takes care of email delivery so your emails reach your customers safely. Plus, you get a dashboard that
  shows you important data about your emails and how their performance can be improved.
* For more information, read this blog article about why WordPress and
  WooCommerce [might not send your emails](https://www.mailersend.com/blog/woocommerce-not-sending-emails) every time.

### What do I need to get started?

To send emails, you only need to sign up for a MailerSend account and add a verified domain. For a step-by-step guide,
check out our help article on [getting started with MailerSend](https://www.mailersend.com/help/getting-started).

### How do I set up automatic transactional emails?

Create a MailerSend account, enable SMTP for your verified domain, and add it to your plugin. You can now focus on
growing your brand and let MailerSend take care of delivering your emails.

### Is this plugin free?

Yes! You can send up to 3,000 emails/month with MailerSend for free as well. For a higher volume of emails, you can
pick from pay-as-you-go plans without long-term commitments. Premium plans start from $30/month for 50,000 emails/month.
Compare the different plans [here](https://www.mailersend.com/pricing).

### Can you add a new feature to this plugin?

We’re open to suggestions and feedback to improve the plugin. You might see your request in a future version! Talk to
us [here](https://www.mailersend.com/contact-us).

## Installation

### Minimum requirements

Requires at least PHP 7.4 and WordPress 5.8.

### Installation

Install the official MailerSend SMTP plugin using any of the following methods.

**Using the WordPress Dashboard**

1. Go to the Plugins dashboard and click **Add New**.
2. Search for **MailerSend SMTP**.
3. Click **Install Now**.
4. Go to **Installed Plugins** and activate the plugin.

**Uploading in WordPress Dashboard**

1. Go to the Plugins dashboard and click **Add New**.
2. Click on the **Upload Plugin** button.
3. Select the plugin zip file from your computer.
4. Click **Install Now**.
5. Go to **Installed Plugins** and activate the plugin.

**Using FTP**

1. Download the plugin.
2. Extract the file to your computer.
3. Upload the contents to your `/wp-content/plugins/` directory.
4. Go to **Installed Plugins** and activate the plugin.
