<?php
    if ( ! defined( 'ABSPATH' ) ) exit;
    
    
    $post_types = isset($search_bar_data['post_types']) ? $search_bar_data['post_types'] : 'post';
    $submit_button_label = isset($search_bar_data['mnssp_settings']['submit_button_label']) ? $search_bar_data['mnssp_settings']['submit_button_label'] : 'Search';
    $placeholder_text = isset($search_bar_data['mnssp_settings']['placeholder_text']) ? $search_bar_data['mnssp_settings']['placeholder_text'] : 'Search...';
    $show_submit_button = isset($search_bar_data['mnssp_settings']['show_submit_button']) ? $search_bar_data['mnssp_settings']['show_submit_button'] : false;
    $border_color = isset($search_bar_data['mnssp_settings']['border_color']) ? $search_bar_data['mnssp_settings']['border_color'] : '#e7f5ff';
    $placeholder_color = isset($search_bar_data['mnssp_settings']['placeholder_color']) ? $search_bar_data['mnssp_settings']['placeholder_color'] : '';
    $icon_color = isset($search_bar_data['mnssp_settings']['icon_color']) ? $search_bar_data['mnssp_settings']['icon_color'] : '#ffffff';
    $icon_bg_color = isset($search_bar_data['mnssp_settings']['icon_bg_color']) ? $search_bar_data['mnssp_settings']['icon_bg_color'] : '#000000';
    $submit_button_bg_color = isset($search_bar_data['mnssp_settings']['submit_button_bg_color']) ? $search_bar_data['mnssp_settings']['submit_button_bg_color'] : '#000000';
    $submit_button_text_color = isset($search_bar_data['mnssp_settings']['submit_button_text_color']) ? $search_bar_data['mnssp_settings']['submit_button_text_color'] : '#ffffff';
    $submit_button_bg_hover_color = isset($search_bar_data['mnssp_settings']['submit_button_bg_hover_color']) ? $search_bar_data['mnssp_settings']['submit_button_bg_hover_color'] : '#000000';
    $submit_button_text_hover_color = isset($search_bar_data['mnssp_settings']['submit_button_text_hover_color']) ? $search_bar_data['mnssp_settings']['submit_button_text_hover_color'] : '#ffffff';


    $search_scope = isset($search_bar_data['search_scope']) ? $search_bar_data['search_scope'] : 'title';
    $priority = isset($search_bar_data['priority']) ? $search_bar_data['priority'] : 'relevance';
    $exclude_ids = isset( $search_bar_data['exclude_ids'] )           ? $search_bar_data['exclude_ids']           : '';
    $exclude_categories = isset( $search_bar_data['exclude_categories'] )    ? $search_bar_data['exclude_categories']    : '';
?>
<form action="<?php echo esc_url(home_url('/')); ?>" method="get" id="mnssp-autocomplete-form" style="border-color: <?php echo esc_attr($border_color); ?>;">
    <input type="text" name="s" id="mnssp-autocomplete-input" autocomplete="off" placeholder="<?php echo esc_html($placeholder_text); ?>" style="color: <?php echo esc_attr($placeholder_color); ?>;">
    <input type="hidden" name="post_type" value="<?php echo esc_attr($post_types); ?>">

    <input type="hidden" name="search_scope" value="<?php echo esc_attr($search_scope); ?>">
    <input type="hidden" name="priority" value="<?php echo esc_attr($priority); ?>">
    <input type="hidden" name="exclude_ids"        value="<?php echo esc_attr( $exclude_ids ); ?>">
    <input type="hidden" name="exclude_categories" value="<?php echo esc_attr( $exclude_categories ); ?>">

    <?php wp_nonce_field('mnssp_search_nonce'); ?>
    <?php if($show_submit_button) { ?>
        <button type="submit" class="search-button mnssp-btn" style="color: <?php echo esc_attr($submit_button_text_color); ?>; background: <?php echo esc_attr($submit_button_bg_color); ?>;"><?php echo esc_html($submit_button_label); ?></button>
    <?php } else { ?>
        <button type="submit" class="search-button" style="color: <?php echo esc_attr($icon_color); ?>; background: <?php echo esc_attr($icon_bg_color); ?>;"><i class="<?php echo esc_attr($icon_picker); ?>"></i></button>
    <?php } ?>
</form>
