function mpwem_initWpEditor(id) {
    try {
        if (typeof tinymce !== 'undefined') {
            if (tinymce.get(id)) {
                tinymce.get(id).remove();
            }
            // Enhanced settings for FAQ editor
            if (id === 'mep_faq_content') {
                tinymce.init({
                    selector: '#' + id,
                    toolbar1: 'formatselect | fontsize | bold italic underline strikethrough | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist | outdent indent | blockquote | link unlink | removeformat | undo redo | code',
                    toolbar2: '',
                    fontsize_formats: '8pt 10pt 12pt 14pt 16pt 18pt 20pt 24pt 28pt 32pt 36pt 48pt 60pt 72pt',
                    plugins: 'link,lists,textcolor,colorpicker,wordpress,wpeditimage,wplink,wpview',
                    menubar: false,
                    statusbar: true,
                    setup: function(editor) {
                        // Initialize WordPress link dialog when editor is ready
                        editor.on('init', function() {
                            // Wait a bit for WordPress scripts to be ready
                            setTimeout(function() {
                                // Ensure WordPress link dialog is initialized
                                if (typeof wp !== 'undefined' && wp.link && typeof wp.link.init === 'function') {
                                    wp.link.init();
                                } else if (typeof wpLink !== 'undefined' && typeof wpLink.init === 'function') {
                                    wpLink.init();
                                }
                            }, 100);
                        });
                    }
                });
            } else {
                tinymce.init({selector: '#' + id});
            }
        }
        if (typeof QTags !== 'undefined') {
            QTags({id: id});
        }
    } catch (error) {
        console.error('Error initializing WordPress editor:', error);
    }
}
//*************Un control js********************//
(function ($) {
    "use strict";
    // =====================sidebar modal open close=============
    $(document).on('click', '[data-modal]', function (e) {
        const modalTarget = $(this).data('modal');
        $(`[data-modal-target="${modalTarget}"]`).addClass('open');
    });
    $(document).on('click', '[data-modal-target] .mep-modal-close', function (e) {
        $(this).closest('[data-modal-target]').removeClass('open');
    });
    // ========Initialize visibility based on the current selection ===========
    var initialStatus = $('#mep_rich_text_status').val();
    if (initialStatus === 'enable') {
        $('#mep_rich_text_table').slideDown();
    } else {
        $('#mep_rich_text_table').slideUp();
    }
    $(document).on('change', '#mep_rich_text_status', function () {
        var status = $(this).val();
        if (status === 'enable') {
            $('#mep_rich_text_table').slideDown(); // Show the section
        } else {
            $('#mep_rich_text_table').slideUp(); // Hide the section
        }
    });
    // ================ Template slection ===============
    $(document).on('click', '.mep-template img', function (e) {
        $('[name="mep_event_template"]').val($(this).data('mep-template'));
        $('.mep-template').removeClass('active')
        $(this).parent('.mep-template').addClass('active');
    });
    // ==============toggle switch radio button=================
    $(document).on('click', '.mpev-switch .mpev-slider', function () {
        var checkbox = $(this).prev('input[type="checkbox"]');
        var toggleValues = checkbox.data('toggle-values').split(',');
        var currentValue = checkbox.val();
        var nextValue = toggleValues[0];
        if (currentValue === toggleValues[0]) {
            nextValue = toggleValues[1];

            if (checkbox.attr('name') === 'mep_disable_ticket_time') {
                $(".mep-special-datetime").slideUp(200);
            }
        } else {
            nextValue = toggleValues[0];
            if (checkbox.attr('name') === 'mep_disable_ticket_time') {
                $(".mep-special-datetime").slideDown(200);
            }
        }
        checkbox.val(nextValue);
        var target = checkbox.data('collapse-target');
        var close = checkbox.data('close-target');
        $(target).slideToggle();
        $(close).slideToggle();
    });
    /**************************/
    $(window).load(function () {
        $('.mp_tab_menu').each(function () {
            $(this).find('ul li:first-child').trigger('click');
        });
        if ($('[name="mep_org_address"]').val() > 0) {
            $('.mp_event_address').slideUp(250);
        }
    });
    $(document).on('click', '[data-target-tabs]', function () {
        if (!$(this).hasClass('active')) {
            let tabsTarget = $(this).attr('data-target-tabs');
            let targetParent = $(this).closest('.mp_event_tab_area').find('.mp_tab_details').first();
            targetParent.children('.mp_tab_item:visible').slideUp('fast');
            targetParent.children('.mp_tab_item[data-tab-item="' + tabsTarget + '"]').slideDown(250);
            $(this).siblings('li.active').removeClass('active');
            $(this).addClass('active');
        }
        return false;
    });
    $(document).on('click', 'label.mp_event_virtual_type_des_switch input', function () {
        if ($(this).is(":checked")) {
            $(this).parents('label.mp_event_virtual_type_des_switch').siblings('label.mp_event_virtual_type_des').slideDown(200);
            $(".mep_event_tab_location_content").hide(200);
        } else {
            $(this).parents('label.mp_event_virtual_type_des_switch').siblings('label.mp_event_virtual_type_des').val('').slideUp(200);
            $(".mep_event_tab_location_content").show(200);
        }
    });

    $(document).on('click', 'label.mep_enable_custom_dt_format input', function () {
        if ($(this).is(":checked")) {
            $(".mep_custom_timezone_setting").slideDown(200);
        } else {
            $(".mep_custom_timezone_setting").slideUp(200);
        }
    });
    $(document).on('click', 'label.mp_event_ticket_type_advance_col_switch input', function () {
        if ($(this).is(":checked")) {
            $(".mep_hide_on_load").slideDown(200);
        } else {
            $(".mep_hide_on_load").slideUp(200);
        }
    });
    $(document).ready(function () {


        $(document).find('.mp_event_type_sortable').sortable({
            handle: $(this).find('.mp_event_type_sortable_button')
        });

        $('#add-new-date-row').on('click', function () {
            var row = $('.empty-row-d.screen-reader-text').clone(true);
            row.removeClass('empty-row-d screen-reader-text');
            row.insertBefore('#repeatable-fieldset-one-d tbody>tr:last');
            return false;
        });
        $('.remove-row-d').on('click', function () {
            if (confirm('Are You Sure , Remove this row ? \n\n 1. Ok : To Remove . \n 2. Cancel : To Cancel .')) {
                $(this).parents('tr').remove();
            } else {
                return false;
            }
        });
    });
    $(document).on('keyup change', '.mpwem_ticket_pricing_settings [name="option_name_t[]"]', function () {
        let n = $(this).val();
        $(this).val(n.replace(/[@%'":;&_–]/g, ''));
    });
    /**************************/
    /**************************/
    $(document).on('click', '#publish,#save-post', function (e) {
        let exit = 1;
        let parent = $('#mp_event_all_info_in_tab');
        if (parent.length > 0 && parent.find('.data_required').length > 0) {
            parent.find('.data_required').each(function () {
                if ($(this).closest('.mpwem_hidden_content').length===0) {
                    $(this).find('[data-required]').each(function () {
                        if (!$(this).val()) {
                            let target_id = $(this).closest('.mp_tab_item').attr('data-tab-item');
                            parent.find('.mp_tab_menu').find('[data-target-tabs="' + target_id + '"]').trigger('click');
                            $(this).addClass('mpRequired').focus();
                            exit = 0;
                        }
                    });
                }
            }).promise().done(function () {
                if (exit === 0) {
                    e.preventDefault();
                }
            });
        }
    });
    ////// templete override js //////
    // Copy template to theme
    $(document).on('click', '.mpwem-copy-template', function (e) {
        e.preventDefault();
        var button = $(this);
        var templatePath = button.data('template');
        var templateItem = button.closest('.mpwem-template-item');
        templateItem.addClass('mpwem-loading');
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'mep_copy_template_to_theme',
                template_path: templatePath,
                nonce: typeof mpwem_template_override_nonce !== 'undefined' ? mpwem_template_override_nonce : ''
            },
            success: function (response) {
                if (response.success) {
                    templateItem.addClass('overridden');
                    templateItem.find('.mpwem-template-status').html('<span class="mpwem-status-badge mpwem-status-overridden">Overridden</span>');
                    button.addClass('mpwem-hidden');
                    templateItem.find('.mpwem-remove-template, .mpwem-edit-template').removeClass('mpwem-hidden');
                    alert('Template copied successfully!');
                } else {
                    alert('Error: ' + response.data);
                }
            },
            error: function (xhr, status, error) {
                console.log('AJAX Error:', xhr, status, error);
                alert('An error occurred while copying the template. Check browser console for details.');
            },
            complete: function () {
                templateItem.removeClass('mpwem-loading');
            }
        });
    });
    // Remove template from theme
    $(document).on('click', '.mpwem-remove-template', function (e) {
        e.preventDefault();
        if (!confirm('Are you sure you want to remove this template override? This will restore the default plugin template.')) {
            return;
        }
        var button = $(this);
        var templatePath = button.data('template');
        var templateItem = button.closest('.mpwem-template-item');
        templateItem.addClass('mpwem-loading');
        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'mep_remove_template_from_theme',
                template_path: templatePath,
                nonce: typeof mpwem_template_override_nonce !== 'undefined' ? mpwem_template_override_nonce : ''
            },
            success: function (response) {
                if (response.success) {
                    templateItem.removeClass('overridden');
                    templateItem.find('.mpwem-template-status').html('<span class="mpwem-status-badge mpwem-status-default">Default</span>');
                    button.addClass('mpwem-hidden');
                    templateItem.find('.mpwem-edit-template').addClass('mpwem-hidden');
                    templateItem.find('.mpwem-copy-template').removeClass('mpwem-hidden');
                    alert('Template override removed successfully!');
                } else {
                    alert('Error: ' + response.data);
                }
            },
            error: function (xhr, status, error) {
                console.log('AJAX Error:', xhr, status, error);
                alert('An error occurred while removing the template. Check browser console for details.');
            },
            complete: function () {
                templateItem.removeClass('mpwem-loading');
            }
        });
    });
}(jQuery));
//*************settings********************//
(function ($) {
    "use strict";
    $(document).on('click', 'button.mpwem_reset_booking', function (e) {
        e.preventDefault();
        let post_id = $('body').find('[name="post_ID"]').val();
        let target = $(this);
        jQuery.ajax({
            type: 'POST',
            url: mpwem_admin_var.url,
            data: {
                "action": "mpwem_reset_booking",
                "post_id": post_id,
                "nonce": mpwem_admin_var.nonce
            },
            beforeSend: function () {
                dLoader_xs(target);
            },
            success: function (data) {
                alert(data);
                dLoaderRemove(target);
            }
        });
    });
}(jQuery));
//*************date settings********************//
(function ($) {
    "use strict";
    $(document).on('click', '.ttbm_add_new_special_date', function () {
        let parent = $(this).closest('.mpwem_settings_area');
        let target_item = parent.find('>.mpwem_hidden_content').find('.mpwem_hidden_item');
        let item = target_item.html();
        mpwem_load_sortable_datepicker(parent, item);
        let unique_id = 'ttbm_hidden_name_' + Math.floor((Math.random() * 9999) + 999);
        target_item.find('[name="mep_special_date_hidden_name[]"]').val(unique_id);
        target_item.find('[name*="mep_special_time_label"]').attr('name', 'mep_special_time_label_' + unique_id + '[]');
        target_item.find('[name*="mep_special_time_value"]').attr('name', 'mep_special_time_value_' + unique_id + '[]');
    });
}(jQuery));
//*************Time Line Settings********************//
(function ($) {
    "use strict";
    function mpwem_timeline_save(parent) {
        let key = parent.find('[name="timeline_item_key"]').val();
        let title = parent.find('[name="mep_timeline_title"]').val();
        let time = parent.find('[name="mep_timeline_time"]').val();
        let content = tinyMCE.get('mep_timeline_content').getContent();
        let post_id = $('body').find('[name="post_ID"]').val();
        let target = parent.closest('.mpwem_timeline_settings').find('.mpwem_timeline_area');
        let popup_target = parent.find('.timeline_input');
        if(title===''){
            alert('Timeline Title is required');
            exit;
        }
        jQuery.ajax({
            type: 'POST',
            url: mpwem_admin_var.url,
            data: {
                "action": "mpwem_save_timeline",
                "key": key,
                "title": title,
                "time": time,
                "content": content,
                "post_id": post_id,
                "nonce": mpwem_admin_var.nonce
            },
            beforeSend: function () {
                dLoader_xs(target);
                dLoader_xs(popup_target);
            },
            success: function (data) {
                target.html(data).promise().done(function () {
                    dLoaderRemove();
                });
            }
        });
    }
    $(document).on('click', 'div.mpwem_timeline_settings [data-target-popup]', function (e) {
        e.preventDefault();
        let popup_id = $(this).attr('data-active-popup', '').data('target-popup');
        let key = $(this).data('key');
        let post_id = $('body').find('[name="post_ID"]').val();
        let target = $(this).closest('.mpwem_timeline_settings').find('.timeline_input');
        $('body').addClass('noScroll').find('[data-popup="' + popup_id + '"]').addClass('in').promise().done(function () {
            jQuery.ajax({
                type: 'POST',
                url: mpwem_admin_var.url,
                data: {
                    "action": "mpwem_load_timeline",
                    "key": key,
                    "post_id": post_id,
                    "nonce": mpwem_admin_var.nonce
                },
                beforeSend: function () {
                    dLoader_xs(target);
                },
                success: function (data) {
                    target.html(data).promise().done(function () {
                        mpwem_initWpEditor('mep_timeline_content');
                    });
                }
            });
        })
    });
    $(document).on('click', 'div.mpwem_timeline_popup .mpwem_timeline_save', function (e) {
        e.preventDefault();
        let parent = $(this).closest('.mpwem_timeline_popup');
        mpwem_timeline_save(parent);
    });
    $(document).on('click', 'div.mpwem_timeline_popup .mpwem_timeline_save_close', function (e) {
        e.preventDefault();
        let parent = $(this).closest('.mpwem_timeline_popup');
        mpwem_timeline_save(parent);
        parent.find('.popupClose').trigger('click');
    });
    $(document).on('click', 'div.mpwem_timeline_settings .mpwem_timeline_remove', function (e) {
        e.preventDefault();
        let key = $(this).data('key');
        let post_id = $('body').find('[name="post_ID"]').val();
        let target = $(this).closest('.mpwem_timeline_settings').find('.mpwem_timeline_area');
        jQuery.ajax({
            type: 'POST',
            url: mpwem_admin_var.url,
            data: {
                "action": "mpwem_remove_timeline",
                "key": key,
                "post_id": post_id,
                "nonce": mpwem_admin_var.nonce
            },
            beforeSend: function () {
                dLoader_xs(target);
            },
            success: function (data) {
                target.html(data);
            }
        });
    });
}(jQuery));
//*************Faq Settings********************//
(function ($) {
    "use strict";
    function mpwem_faq_save(parent) {
        let key = parent.find('[name="faq_item_key"]').val();
        let title = parent.find('[name="mep_faq_title"]').val();
        let des = $('body').find('[name="mep_faq_description"]').val();
        let content = tinyMCE.get('mep_faq_content').getContent();
        let post_id = $('body').find('[name="post_ID"]').val();
        let target = parent.closest('.mpwem_faq_settings').find('.mpwem_faq_area');
        let popup_target = parent.find('.faq_input');
        if(title===''){
            alert('FAQ Title is required');
            exit;
        }
        jQuery.ajax({
            type: 'POST',
            url: mpwem_admin_var.url,
            data: {
                "action": "mpwem_save_faq",
                "key": key,
                "title": title,
                "des": des,
                "content": content,
                "post_id": post_id,
                "nonce": mpwem_admin_var.nonce
            },
            beforeSend: function () {
                dLoader_xs(target);
                dLoader_xs(popup_target);
            },
            success: function (data) {
                target.html(data).promise().done(function () {
                    dLoaderRemove();
                });
            }
        });
    }
    $(document).on('click', 'div.mpwem_faq_settings [data-target-popup]', function (e) {
        e.preventDefault();
        let popup_id = $(this).attr('data-active-popup', '').data('target-popup');
        let key = $(this).data('key');
        let post_id = $('body').find('[name="post_ID"]').val();
        let target = $(this).closest('.mpwem_faq_settings').find('.faq_input');
        $('body').addClass('noScroll').find('[data-popup="' + popup_id + '"]').addClass('in').promise().done(function () {
            jQuery.ajax({
                type: 'POST',
                url: mpwem_admin_var.url,
                data: {
                    "action": "mpwem_load_faq",
                    "key": key,
                    "post_id": post_id,
                    "nonce": mpwem_admin_var.nonce
                },
                beforeSend: function () {
                    dLoader_xs(target);
                },
                success: function (data) {
                    target.html(data).promise().done(function () {
                        // Wait a bit for WordPress to potentially initialize, then ensure our enhanced settings are applied
                        setTimeout(function() {
                            mpwem_initWpEditor('mep_faq_content');
                            // Ensure WordPress link scripts are loaded and initialized after editor is ready
                            setTimeout(function() {
                                var editor = tinymce.get('mep_faq_content');
                                if (editor) {
                                    // Initialize WordPress link dialog
                                    if (typeof wp !== 'undefined' && wp.link) {
                                        if (typeof wp.link.init === 'function') {
                                            wp.link.init();
                                        }
                                    } else if (typeof wpLink !== 'undefined' && typeof wpLink.init === 'function') {
                                        wpLink.init();
                                    }
                                    
                                    // Ensure link button triggers WordPress dialog
                                    editor.on('ExecCommand', function(e) {
                                        if (e.command === 'mceLink' || e.command === 'WP_Link') {
                                            if (typeof wp !== 'undefined' && wp.link) {
                                                wp.link.init();
                                            }
                                        }
                                    });
                                }
                            }, 300);
                        }, 100);
                    });
                }
            });
        })
    });
    $(document).on('click', 'div.mpwem_faq_popup .mpwem_faq_save', function (e) {
        e.preventDefault();
        let parent = $(this).closest('.mpwem_faq_popup');
        mpwem_faq_save(parent);
    });
    $(document).on('click', 'div.mpwem_faq_popup .mpwem_faq_save_close', function (e) {
        e.preventDefault();
        let parent = $(this).closest('.mpwem_faq_popup');
        mpwem_faq_save(parent);
        parent.find('.popupClose').trigger('click');
    });
    $(document).on('click', 'div.mpwem_faq_settings .mpwem_faq_remove', function (e) {
        e.preventDefault();
        let key = $(this).data('key');
        let post_id = $('body').find('[name="post_ID"]').val();
        let target = $(this).closest('.mpwem_faq_settings').find('.mpwem_faq_area');
        jQuery.ajax({
            type: 'POST',
            url: mpwem_admin_var.url,
            data: {
                "action": "mpwem_remove_faq",
                "key": key,
                "post_id": post_id,
                "nonce": mpwem_admin_var.nonce
            },
            beforeSend: function () {
                dLoader_xs(target);
            },
            success: function (data) {
                target.html(data);
            }
        });
    });
}(jQuery));
//*********************************//
function mpwem_load_sortable_datepicker(parent, item) {
    parent.find('.mpwem_item_insert').first().append(item).promise().done(function () {
        parent.find('.mpwem_sortable_area').sortable({
            handle: jQuery(this).find('.mpwem_sortable_button')
        });
        mpwem_load_date_picker(parent);
    });
    return true;
}
(function ($) {
    "use strict";
    $(document).ready(function () {
        //=========Short able==============//
        $(document).find('.mpwem_sortable_area').sortable({
            handle: $(this).find('.mpwem_sortable_button')
        });
    });
    //=========Remove Setting Item ==============//
    $(document).on('click', '.mpwem_item_remove', function () {
        if (confirm('Are You Sure , Remove this row ? \n\n 1. Ok : To Remove . \n 2. Cancel : To Cancel .')) {
            $(this).closest('.mpwem_remove_area').slideUp(250, function () {
                $(this).remove();
            });
            return true;
        }
        return false;
    });
    //=========Add Setting Item==============//
    $(document).on('click', '.mpwem_add_item', function () {
        let parent = $(this).closest('.mpwem_settings_area');
        let item = $(this).next($('.mpwem_hidden_content')).find(' .mpwem_hidden_item').html();
        if (!item || item === "undefined" || item === " ") {
            item = parent.find('.mpwem_hidden_content').first().find('.mpwem_hidden_item').html();
        }
        mpwem_load_sortable_datepicker(parent, item);
        parent.find('.mpwem_item_insert').find('.add_mpwem_select2').select2({});
        return true;
    });
}(jQuery));
//=================select icon / image=========================//
(function ($) {
    "use strict";
    $(document).on('click', 'button.mpwem_image_add', function () {
        let $this = $(this);
        let parent = $this.closest('.mpwem_add_icon_image_area');
        wp.media.editor.send.attachment = function (props, attachment) {
            let attachment_id = attachment.id;
            let attachment_url = attachment.url;
            parent.find('input[type="hidden"]').val(attachment_id);
            parent.find('.mpwem_icon_item').slideUp('fast');
            parent.find('img').attr('src', attachment_url);
            parent.find('.mpwem_image_item').slideDown('fast');
            parent.find('.add_icon_image_button_area').slideUp('fast');
        }
        wp.media.editor.open($this);
        return false;
    });
    $(document).on('click', '.mpwem_add_icon_image_area .mpwem_image_remove', function () {
        let parent = $(this).closest('.mpwem_add_icon_image_area');
        parent.find('input[type="hidden"]').val('');
        parent.find('img').attr('src', '');
        parent.find('.mpwem_image_item').slideUp('fast');
        parent.find('.add_icon_image_button_area').slideDown('fast');
    });
    $(document).on('click', '.mpwem_add_icon_image_area button.mpwem_icon_add', function () {
        let target_popup = $('.mpwem_add_icon_popup');
        target_popup.find('.iconItem').click(function () {
            let parent = $('[data-active-popup]').closest('.mpwem_add_icon_image_area');
            let icon_class = $(this).data('icon-class');
            if (icon_class) {
                parent.find('input[type="hidden"]').val(icon_class);
                parent.find('.add_icon_image_button_area').slideUp('fast');
                parent.find('.mpwem_image_item').slideUp('fast');
                parent.find('.mpwem_icon_item').slideDown('fast');
                parent.find('[data-add-icon]').removeAttr('class').addClass(icon_class);
                target_popup.find('.iconItem').removeClass('active');
                target_popup.find('.popupClose').trigger('click');
            }
        });
        target_popup.find('[data-icon-menu]').click(function () {
            if (!$(this).hasClass('active')) {
                //target_popup.find('[name="mpwem_select_icon_name"]').val('');
                let target = $(this);
                let tabsTarget = target.data('icon-menu');
                target_popup.find('[data-icon-menu]').removeClass('active');
                target.addClass('active');
                target_popup.find('[data-icon-list]').each(function () {
                    let targetItem = $(this).data('icon-list');
                    if (tabsTarget === 'all_item' || targetItem === tabsTarget) {
                        $(this).slideDown(250);
                        $(this).find('.iconItem').each(function () {
                            $(this).slideDown('fast');
                        });
                    } else {
                        $(this).slideUp('fast');
                    }
                });
            }
            return false;
        });
        target_popup.find('.popupClose').click(function () {
            target_popup.find('[data-icon-menu="all_item"]').trigger('click');
            target_popup.find('.iconItem').removeClass('active');
        });
    });
    $(document).on('click', '.mpwem_add_icon_image_area .mpwem_icon_remove', function () {
        let parent = $(this).closest('.mpwem_add_icon_image_area');
        parent.find('input[type="hidden"]').val('');
        parent.find('[data-add-icon]').removeAttr('class');
        parent.find('.mpwem_icon_item').slideUp('fast');
        parent.find('.add_icon_image_button_area').slideDown('fast');
    });
    $(document).on('keyup change', '.mpwem_add_icon_popup [name="mpwem_select_icon_name"]', function () {
        let parent = $(this).closest('.mpwem_add_icon_popup');
        let input = $(this).val().toString().toLowerCase();
        parent.find('[data-icon-menu="all_item"]').trigger('click');
        if (input) {
            parent.find('.popupTabItem').each(function () {
                let tabItem = $(this);
                let count = 0;
                let icon_type = $(this).data('icon-title').toString().toLowerCase();
                let active = (icon_type && icon_type.match(new RegExp(input, "i"))) ? 1 : 0;
                if (active > 0) {
                    tabItem.slideDown(250);
                    tabItem.find('.iconItem').each(function () {
                        $(this).slideDown('fast');
                    });
                } else {
                    tabItem.find('.iconItem').each(function () {
                        let icon_class = $(this).data('icon-class').toString().toLowerCase();
                        let icon_name = $(this).data('icon-name').toString().toLowerCase();
                        active = (icon_class && icon_class.match(new RegExp(input, "i"))) ? 1 : active;
                        active = (icon_name && icon_name.match(new RegExp(input, "i"))) ? 1 : active;
                        if (active > 0) {
                            $(this).slideDown('fast');
                            count++;
                        } else {
                            $(this).slideUp('fast');
                        }
                    }).promise().done(function () {
                        if (count > 0) {
                            tabItem.slideDown('fast');
                        } else {
                            tabItem.slideUp('fast');
                        }
                    });
                }
            });
        } else {
            parent.find('.popupTabItem').each(function () {
                $(this).slideDown(250);
                $(this).find('.iconItem').each(function () {
                    $(this).slideDown(250);
                });
            });
        }
    });
}(jQuery));
//=========upload image==============//
(function ($) {
    "use strict";
    $(document).on('click', '.mpwem_add_single_image', function () {
        let parent = $(this);
        parent.find('.mp_single_image_item').remove();
        wp.media.editor.send.attachment = function (props, attachment) {
            let attachment_id = attachment.id;
            let attachment_url = attachment.url;
            let html = '<div class="mp_single_image_item" data-image-id="' + attachment_id + '"><span class="fas fa-times circleIcon_xs mpwem_remove_single_image"></span>';
            html += '<img src="' + attachment_url + '" alt="' + attachment_id + '"/>';
            html += '</div>';
            parent.append(html);
            parent.find('input').val(attachment_id);
            parent.find('button').slideUp('fast');
        }
        wp.media.editor.open($(this));
        return false;
    });
    $(document).on('click', '.mpwem_remove_single_image', function (e) {
        e.stopPropagation();
        let parent = $(this).closest('.mpwem_add_single_image');
        $(this).closest('.mp_single_image_item').remove();
        parent.find('input').val('');
        parent.find('button').slideDown('fast');
    });
    $(document).on('click', '.mpwem_remove_multi_image', function () {
        let parent = $(this).closest('.mp_multi_image_area');
        let current_parent = $(this).closest('.mp_multi_image_item');
        let img_id = current_parent.data('image-id');
        current_parent.remove();
        let all_img_ids = parent.find('.mp_multi_image_value').val();
        all_img_ids = all_img_ids.replace(',' + img_id, '')
        all_img_ids = all_img_ids.replace(img_id + ',', '')
        all_img_ids = all_img_ids.replace(img_id, '')
        parent.find('.mp_multi_image_value').val(all_img_ids);
    });
    $(document).on('click', '.mpwem_add_multi_image', function () {
        let parent = $(this).closest('.mp_multi_image_area');
        wp.media.editor.send.attachment = function (props, attachment) {
            let attachment_id = attachment.id;
            let attachment_url = attachment.url;
            let html = '<div class="mp_multi_image_item" data-image-id="' + attachment_id + '"><span class="fas fa-times circleIcon_xs mpwem_remove_multi_image"></span>';
            html += '<img src="' + attachment_url + '" alt="' + attachment_id + '"/>';
            html += '</div>';
            parent.find('.mp_multi_image').append(html);
            let value = parent.find('.mp_multi_image_value').val();
            value = value ? value + ',' + attachment_id : attachment_id;
            parent.find('.mp_multi_image_value').val(value);
        }
        wp.media.editor.open($(this));
        return false;
    });
}(jQuery));
//=======================//
function mpwem_load_post_date(parent){
    let post_id = parent.find('[name="mpwem_post_id"]').val();
    let target = parent.find('.date_time_area');
    if (post_id > 0) {
        jQuery.ajax({
            type: 'POST',
            url: mpwem_admin_var.url,
            data: {
                "action": "mpwem_load_date",
                "post_id": post_id,
                "nonce": mpwem_admin_var.nonce
            },
            beforeSend: function () {
                dLoader_xs(target);
            },
            success: function (data) {
                target.html(data);
                dLoaderRemove(target);
            }
        });
    }
}
function mpwem_load_past_date_time(parent){
    let target = parent.find('.mpwem_time_area');
    if (target.length > 0) {
        let post_id = parent.find('[name="mpwem_post_id"]').val();
        let dates = parent.find('[name="mpwem_date_time"]').val();
        if (post_id > 0 && dates) {
            jQuery.ajax({
                type: 'POST',
                url: mpwem_admin_var.url,
                data: {
                    "action": "mpwem_load_time",
                    "post_id": post_id,
                    "dates": dates,
                    "nonce": mpwem_admin_var.nonce
                },
                beforeSend: function () {
                    dLoader_xs(target);
                },
                success: function (data) {
                    target.html(data);
                    dLoaderRemove(target);
                }
            });
        }
    }
}
//=========Attendee Statistics==============//
(function ($) {
    "use strict";
    $(document).on('change', '#mpwem_recurring_statistics [name="mpwem_post_id"]', function () {
        let post_id = $(this).val();
        let parent = $(this).closest('#mpwem_recurring_statistics');
        if (post_id > 0) {
            mpwem_load_post_date(parent);
        } else {
            parent.find('.statistics_list').slideUp('fast');
        }
    });
    $(document).on('change', '#mpwem_recurring_statistics [name="mpwem_date_time"]', function () {
        let parent = $(this).closest('#mpwem_recurring_statistics');
        let target = parent.find('.mpwem_time_area');
        if (target.length > 0) {
            mpwem_load_past_date_time(parent);
        } else {
            parent.find('#mpwem_load_attendee_statistics').trigger('click');
        }
    });
    $(document).on('change', '#mpwem_recurring_statistics [name="mpwem_time"]', function () {
        let parent = $(this).closest('#mpwem_recurring_statistics');
        parent.find('#mpwem_load_attendee_statistics').trigger('click');
    });
    $(document).on('click', '#mpwem_load_attendee_statistics', function () {
        let parent = $(this).closest('#mpwem_recurring_statistics');
        let post_id = parent.find('[name="mpwem_post_id"]').val();
        let target = parent.find('.statistics_list');
        if (post_id > 0) {
            let dates = parent.find('[name="mpwem_date_time"]').val();
            let time_area = parent.find('.mpwem_time_area');
            if (time_area.length > 0) {
                dates = parent.find('[name="mpwem_time"]').val();
            }
            target.slideDown('fast');
            jQuery.ajax({
                type: 'POST',
                url: mpwem_admin_var.url,
                data: {
                    "action": "mpwem_load_attendee_statistics",
                    "post_id": post_id,
                    "dates": dates,
                    "nonce": mpwem_admin_var.nonce
                },
                beforeSend: function () {
                    dLoader_xs(target);
                },
                success: function (data) {
                    target.html(data);
                    dLoaderRemove(target);
                }
            });
        } else {
            target.slideUp('fast');
            alert('Please select event');
        }
    });

}(jQuery));
//=========Seat status==============//
(function ($) {
    "use strict";
    $(document).on('click', '.mpwem_reload_seat_status', function () {
        let current=$(this);
        let parent = $(this).closest('.status_action');
        let post_id = current.attr('data-post_id');
        let date = current.attr('data-date');
        let target = parent.find('.seat_status_area');
        if (post_id > 0) {
            jQuery.ajax({
                type: 'POST',
                url: mpwem_admin_var.url,
                data: {
                    "action": "mpwem_reload_seat_status",
                    "post_id": post_id,
                    "date": date,
                    "nonce": mpwem_admin_var.nonce
                },
                beforeSend: function () {
                    dLoader_xs(target);
                },
                success: function (data) {
                    target.html(data);
                    dLoaderRemove(target);
                }
            });
        } else {
            alert('Something Wrong!');
        }
    });
}(jQuery));