<?php

/**
 * An array of Intl.NumberFormat locales matched to names in US English
 * Tanky ou @umpirsky! https://github.com/umpirsky/locale-list
 */

return array(
	'af' => esc_html__( 'Afrikaans' ),
	'af-NA' => esc_html__( 'Afrikaans (Namibia)' ),
	'af-ZA' => esc_html__( 'Afrikaans (South Africa)' ),
	'ak' => esc_html__( 'Akan' ),
	'ak-GH' => esc_html__( 'Akan (Ghana)' ),
	'sq' => esc_html__( 'Albanian' ),
	'sq-AL' => esc_html__( 'Albanian (Albania)' ),
	'sq-XK' => esc_html__( 'Albanian (Kosovo)' ),
	'sq-MK' => esc_html__( 'Albanian (Macedonia)' ),
	'am' => esc_html__( 'Amharic' ),
	'am-ET' => esc_html__( 'Amharic (Ethiopia)' ),
	'ar' => esc_html__( 'Arabic' ),
	'ar-DZ' => esc_html__( 'Arabic (Algeria)' ),
	'ar-BH' => esc_html__( 'Arabic (Bahrain)' ),
	'ar-TD' => esc_html__( 'Arabic (Chad)' ),
	'ar-KM' => esc_html__( 'Arabic (Comoros)' ),
	'ar-DJ' => esc_html__( 'Arabic (Djibouti)' ),
	'ar-EG' => esc_html__( 'Arabic (Egypt)' ),
	'ar-ER' => esc_html__( 'Arabic (Eritrea)' ),
	'ar-IQ' => esc_html__( 'Arabic (Iraq)' ),
	'ar-IL' => esc_html__( 'Arabic (Israel)' ),
	'ar-JO' => esc_html__( 'Arabic (Jordan)' ),
	'ar-KW' => esc_html__( 'Arabic (Kuwait)' ),
	'ar-LB' => esc_html__( 'Arabic (Lebanon)' ),
	'ar-LY' => esc_html__( 'Arabic (Libya)' ),
	'ar-MR' => esc_html__( 'Arabic (Mauritania)' ),
	'ar-MA' => esc_html__( 'Arabic (Morocco)' ),
	'ar-OM' => esc_html__( 'Arabic (Oman)' ),
	'ar-PS' => esc_html__( 'Arabic (Palestinian Territories)' ),
	'ar-QA' => esc_html__( 'Arabic (Qatar)' ),
	'ar-SA' => esc_html__( 'Arabic (Saudi Arabia)' ),
	'ar-SO' => esc_html__( 'Arabic (Somalia)' ),
	'ar-SS' => esc_html__( 'Arabic (South Sudan)' ),
	'ar-SD' => esc_html__( 'Arabic (Sudan)' ),
	'ar-SY' => esc_html__( 'Arabic (Syria)' ),
	'ar-TN' => esc_html__( 'Arabic (Tunisia)' ),
	'ar-AE' => esc_html__( 'Arabic (United Arab Emirates)' ),
	'ar-EH' => esc_html__( 'Arabic (Western Sahara)' ),
	'ar-YE' => esc_html__( 'Arabic (Yemen)' ),
	'hy' => esc_html__( 'Armenian' ),
	'hy-AM' => esc_html__( 'Armenian (Armenia)' ),
	'as' => esc_html__( 'Assamese' ),
	'as-IN' => esc_html__( 'Assamese (India)' ),
	'az' => esc_html__( 'Azerbaijani' ),
	'az-AZ' => esc_html__( 'Azerbaijani (Azerbaijan)' ),
	'az-Cyrl-AZ' => esc_html__( 'Azerbaijani (Cyrillic, Azerbaijan)' ),
	'az-Cyrl' => esc_html__( 'Azerbaijani (Cyrillic)' ),
	'az-Latn-AZ' => esc_html__( 'Azerbaijani (Latin, Azerbaijan)' ),
	'az-Latn' => esc_html__( 'Azerbaijani (Latin)' ),
	'bm' => esc_html__( 'Bambara' ),
	'bm-Latn-ML' => esc_html__( 'Bambara (Latin, Mali)' ),
	'bm-Latn' => esc_html__( 'Bambara (Latin)' ),
	'eu' => esc_html__( 'Basque' ),
	'eu-ES' => esc_html__( 'Basque (Spain)' ),
	'be' => esc_html__( 'Belarusian' ),
	'be-BY' => esc_html__( 'Belarusian (Belarus)' ),
	'bn' => esc_html__( 'Bengali' ),
	'bn-BD' => esc_html__( 'Bengali (Bangladesh)' ),
	'bn-IN' => esc_html__( 'Bengali (India)' ),
	'bs' => esc_html__( 'Bosnian' ),
	'bs-BA' => esc_html__( 'Bosnian (Bosnia & Herzegovina)' ),
	'bs-Cyrl-BA' => esc_html__( 'Bosnian (Cyrillic, Bosnia & Herzegovina)' ),
	'bs-Cyrl' => esc_html__( 'Bosnian (Cyrillic)' ),
	'bs-Latn-BA' => esc_html__( 'Bosnian (Latin, Bosnia & Herzegovina)' ),
	'bs-Latn' => esc_html__( 'Bosnian (Latin)' ),
	'br' => esc_html__( 'Breton' ),
	'br-FR' => esc_html__( 'Breton (France)' ),
	'bg' => esc_html__( 'Bulgarian' ),
	'bg-BG' => esc_html__( 'Bulgarian (Bulgaria)' ),
	'my' => esc_html__( 'Burmese' ),
	'my-MM' => esc_html__( 'Burmese (Myanmar (Burma))' ),
	'ca' => esc_html__( 'Catalan' ),
	'ca-AD' => esc_html__( 'Catalan (Andorra)' ),
	'ca-FR' => esc_html__( 'Catalan (France)' ),
	'ca-IT' => esc_html__( 'Catalan (Italy)' ),
	'ca-ES' => esc_html__( 'Catalan (Spain)' ),
	'zh' => esc_html__( 'Chinese' ),
	'zh-CN' => esc_html__( 'Chinese (China)' ),
	'zh-HK' => esc_html__( 'Chinese (Hong Kong SAR China)' ),
	'zh-MO' => esc_html__( 'Chinese (Macau SAR China)' ),
	'zh-Hans-CN' => esc_html__( 'Chinese (Simplified, China)' ),
	'zh-Hans-HK' => esc_html__( 'Chinese (Simplified, Hong Kong SAR China)' ),
	'zh-Hans-MO' => esc_html__( 'Chinese (Simplified, Macau SAR China)' ),
	'zh-Hans-SG' => esc_html__( 'Chinese (Simplified, Singapore)' ),
	'zh-Hans' => esc_html__( 'Chinese (Simplified)' ),
	'zh-SG' => esc_html__( 'Chinese (Singapore)' ),
	'zh-TW' => esc_html__( 'Chinese (Taiwan)' ),
	'zh-Hant-HK' => esc_html__( 'Chinese (Traditional, Hong Kong SAR China)' ),
	'zh-Hant-MO' => esc_html__( 'Chinese (Traditional, Macau SAR China)' ),
	'zh-Hant-TW' => esc_html__( 'Chinese (Traditional, Taiwan)' ),
	'zh-Hant' => esc_html__( 'Chinese (Traditional)' ),
	'kw' => esc_html__( 'Cornish' ),
	'kw-GB' => esc_html__( 'Cornish (United Kingdom)' ),
	'hr' => esc_html__( 'Croatian' ),
	'hr-BA' => esc_html__( 'Croatian (Bosnia & Herzegovina)' ),
	'hr-HR' => esc_html__( 'Croatian (Croatia)' ),
	'cs' => esc_html__( 'Czech' ),
	'cs-CZ' => esc_html__( 'Czech (Czech Republic)' ),
	'da' => esc_html__( 'Danish' ),
	'da-DK' => esc_html__( 'Danish (Denmark)' ),
	'da-GL' => esc_html__( 'Danish (Greenland)' ),
	'nl' => esc_html__( 'Dutch' ),
	'nl-AW' => esc_html__( 'Dutch (Aruba)' ),
	'nl-BE' => esc_html__( 'Dutch (Belgium)' ),
	'nl-BQ' => esc_html__( 'Dutch (Caribbean Netherlands)' ),
	'nl-CW' => esc_html__( 'Dutch (Curaçao)' ),
	'nl-NL' => esc_html__( 'Dutch (Netherlands)' ),
	'nl-SX' => esc_html__( 'Dutch (Sint Maarten)' ),
	'nl-SR' => esc_html__( 'Dutch (Suriname)' ),
	'dz' => esc_html__( 'Dzongkha' ),
	'dz-BT' => esc_html__( 'Dzongkha (Bhutan)' ),
	'en' => esc_html__( 'English' ),
	'en-AS' => esc_html__( 'English (American Samoa)' ),
	'en-AI' => esc_html__( 'English (Anguilla)' ),
	'en-AG' => esc_html__( 'English (Antigua & Barbuda)' ),
	'en-AU' => esc_html__( 'English (Australia)' ),
	'en-BS' => esc_html__( 'English (Bahamas)' ),
	'en-BB' => esc_html__( 'English (Barbados)' ),
	'en-BE' => esc_html__( 'English (Belgium)' ),
	'en-BZ' => esc_html__( 'English (Belize)' ),
	'en-BM' => esc_html__( 'English (Bermuda)' ),
	'en-BW' => esc_html__( 'English (Botswana)' ),
	'en-IO' => esc_html__( 'English (British Indian Ocean Territory)' ),
	'en-VG' => esc_html__( 'English (British Virgin Islands)' ),
	'en-CM' => esc_html__( 'English (Cameroon)' ),
	'en-CA' => esc_html__( 'English (Canada)' ),
	'en-KY' => esc_html__( 'English (Cayman Islands)' ),
	'en-CX' => esc_html__( 'English (Christmas Island)' ),
	'en-CC' => esc_html__( 'English (Cocos (Keeling) Islands)' ),
	'en-CK' => esc_html__( 'English (Cook Islands)' ),
	'en-DG' => esc_html__( 'English (Diego Garcia)' ),
	'en-DM' => esc_html__( 'English (Dominica)' ),
	'en-ER' => esc_html__( 'English (Eritrea)' ),
	'en-FK' => esc_html__( 'English (Falkland Islands)' ),
	'en-FJ' => esc_html__( 'English (Fiji)' ),
	'en-GM' => esc_html__( 'English (Gambia)' ),
	'en-GH' => esc_html__( 'English (Ghana)' ),
	'en-GI' => esc_html__( 'English (Gibraltar)' ),
	'en-GD' => esc_html__( 'English (Grenada)' ),
	'en-GU' => esc_html__( 'English (Guam)' ),
	'en-GG' => esc_html__( 'English (Guernsey)' ),
	'en-GY' => esc_html__( 'English (Guyana)' ),
	'en-HK' => esc_html__( 'English (Hong Kong SAR China)' ),
	'en-IN' => esc_html__( 'English (India)' ),
	'en-IE' => esc_html__( 'English (Ireland)' ),
	'en-IM' => esc_html__( 'English (Isle of Man)' ),
	'en-JM' => esc_html__( 'English (Jamaica)' ),
	'en-JE' => esc_html__( 'English (Jersey)' ),
	'en-KE' => esc_html__( 'English (Kenya)' ),
	'en-KI' => esc_html__( 'English (Kiribati)' ),
	'en-LS' => esc_html__( 'English (Lesotho)' ),
	'en-LR' => esc_html__( 'English (Liberia)' ),
	'en-MO' => esc_html__( 'English (Macau SAR China)' ),
	'en-MG' => esc_html__( 'English (Madagascar)' ),
	'en-MW' => esc_html__( 'English (Malawi)' ),
	'en-MY' => esc_html__( 'English (Malaysia)' ),
	'en-MT' => esc_html__( 'English (Malta)' ),
	'en-MH' => esc_html__( 'English (Marshall Islands)' ),
	'en-MU' => esc_html__( 'English (Mauritius)' ),
	'en-FM' => esc_html__( 'English (Micronesia)' ),
	'en-MS' => esc_html__( 'English (Montserrat)' ),
	'en-NA' => esc_html__( 'English (Namibia)' ),
	'en-NR' => esc_html__( 'English (Nauru)' ),
	'en-NZ' => esc_html__( 'English (New Zealand)' ),
	'en-NG' => esc_html__( 'English (Nigeria)' ),
	'en-NU' => esc_html__( 'English (Niue)' ),
	'en-NF' => esc_html__( 'English (Norfolk Island)' ),
	'en-MP' => esc_html__( 'English (Northern Mariana Islands)' ),
	'en-PK' => esc_html__( 'English (Pakistan)' ),
	'en-PW' => esc_html__( 'English (Palau)' ),
	'en-PG' => esc_html__( 'English (Papua New Guinea)' ),
	'en-PH' => esc_html__( 'English (Philippines)' ),
	'en-PN' => esc_html__( 'English (Pitcairn Islands)' ),
	'en-PR' => esc_html__( 'English (Puerto Rico)' ),
	'en-RW' => esc_html__( 'English (Rwanda)' ),
	'en-WS' => esc_html__( 'English (Samoa)' ),
	'en-SC' => esc_html__( 'English (Seychelles)' ),
	'en-SL' => esc_html__( 'English (Sierra Leone)' ),
	'en-SG' => esc_html__( 'English (Singapore)' ),
	'en-SX' => esc_html__( 'English (Sint Maarten)' ),
	'en-SB' => esc_html__( 'English (Solomon Islands)' ),
	'en-ZA' => esc_html__( 'English (South Africa)' ),
	'en-SS' => esc_html__( 'English (South Sudan)' ),
	'en-SH' => esc_html__( 'English (St. Helena)' ),
	'en-KN' => esc_html__( 'English (St. Kitts & Nevis)' ),
	'en-LC' => esc_html__( 'English (St. Lucia)' ),
	'en-VC' => esc_html__( 'English (St. Vincent & Grenadines)' ),
	'en-SD' => esc_html__( 'English (Sudan)' ),
	'en-SZ' => esc_html__( 'English (Swaziland)' ),
	'en-TZ' => esc_html__( 'English (Tanzania)' ),
	'en-TK' => esc_html__( 'English (Tokelau)' ),
	'en-TO' => esc_html__( 'English (Tonga)' ),
	'en-TT' => esc_html__( 'English (Trinidad & Tobago)' ),
	'en-TC' => esc_html__( 'English (Turks & Caicos Islands)' ),
	'en-TV' => esc_html__( 'English (Tuvalu)' ),
	'en-UM' => esc_html__( 'English (U.S. Outlying Islands)' ),
	'en-VI' => esc_html__( 'English (U.S. Virgin Islands)' ),
	'en-UG' => esc_html__( 'English (Uganda)' ),
	'en-GB' => esc_html__( 'English (United Kingdom)' ),
	'en-US' => esc_html__( 'English (United States)' ),
	'en-VU' => esc_html__( 'English (Vanuatu)' ),
	'en-ZM' => esc_html__( 'English (Zambia)' ),
	'en-ZW' => esc_html__( 'English (Zimbabwe)' ),
	'eo' => esc_html__( 'Esperanto' ),
	'et' => esc_html__( 'Estonian' ),
	'et-EE' => esc_html__( 'Estonian (Estonia)' ),
	'ee' => esc_html__( 'Ewe' ),
	'ee-GH' => esc_html__( 'Ewe (Ghana)' ),
	'ee-TG' => esc_html__( 'Ewe (Togo)' ),
	'fo' => esc_html__( 'Faroese' ),
	'fo-FO' => esc_html__( 'Faroese (Faroe Islands)' ),
	'fi' => esc_html__( 'Finnish' ),
	'fi-FI' => esc_html__( 'Finnish (Finland)' ),
	'fr' => esc_html__( 'French' ),
	'fr-DZ' => esc_html__( 'French (Algeria)' ),
	'fr-BE' => esc_html__( 'French (Belgium)' ),
	'fr-BJ' => esc_html__( 'French (Benin)' ),
	'fr-BF' => esc_html__( 'French (Burkina Faso)' ),
	'fr-BI' => esc_html__( 'French (Burundi)' ),
	'fr-CM' => esc_html__( 'French (Cameroon)' ),
	'fr-CA' => esc_html__( 'French (Canada)' ),
	'fr-CF' => esc_html__( 'French (Central African Republic)' ),
	'fr-TD' => esc_html__( 'French (Chad)' ),
	'fr-KM' => esc_html__( 'French (Comoros)' ),
	'fr-CG' => esc_html__( 'French (Congo - Brazzaville)' ),
	'fr-CD' => esc_html__( 'French (Congo - Kinshasa)' ),
	'fr-CI' => esc_html__( 'French (Côte d’Ivoire)' ),
	'fr-DJ' => esc_html__( 'French (Djibouti)' ),
	'fr-GQ' => esc_html__( 'French (Equatorial Guinea)' ),
	'fr-FR' => esc_html__( 'French (France)' ),
	'fr-GF' => esc_html__( 'French (French Guiana)' ),
	'fr-PF' => esc_html__( 'French (French Polynesia)' ),
	'fr-GA' => esc_html__( 'French (Gabon)' ),
	'fr-GP' => esc_html__( 'French (Guadeloupe)' ),
	'fr-GN' => esc_html__( 'French (Guinea)' ),
	'fr-HT' => esc_html__( 'French (Haiti)' ),
	'fr-LU' => esc_html__( 'French (Luxembourg)' ),
	'fr-MG' => esc_html__( 'French (Madagascar)' ),
	'fr-ML' => esc_html__( 'French (Mali)' ),
	'fr-MQ' => esc_html__( 'French (Martinique)' ),
	'fr-MR' => esc_html__( 'French (Mauritania)' ),
	'fr-MU' => esc_html__( 'French (Mauritius)' ),
	'fr-YT' => esc_html__( 'French (Mayotte)' ),
	'fr-MC' => esc_html__( 'French (Monaco)' ),
	'fr-MA' => esc_html__( 'French (Morocco)' ),
	'fr-NC' => esc_html__( 'French (New Caledonia)' ),
	'fr-NE' => esc_html__( 'French (Niger)' ),
	'fr-RE' => esc_html__( 'French (Réunion)' ),
	'fr-RW' => esc_html__( 'French (Rwanda)' ),
	'fr-SN' => esc_html__( 'French (Senegal)' ),
	'fr-SC' => esc_html__( 'French (Seychelles)' ),
	'fr-BL' => esc_html__( 'French (St. Barthélemy)' ),
	'fr-MF' => esc_html__( 'French (St. Martin)' ),
	'fr-PM' => esc_html__( 'French (St. Pierre & Miquelon)' ),
	'fr-CH' => esc_html__( 'French (Switzerland)' ),
	'fr-SY' => esc_html__( 'French (Syria)' ),
	'fr-TG' => esc_html__( 'French (Togo)' ),
	'fr-TN' => esc_html__( 'French (Tunisia)' ),
	'fr-VU' => esc_html__( 'French (Vanuatu)' ),
	'fr-WF' => esc_html__( 'French (Wallis & Futuna)' ),
	'ff' => esc_html__( 'Fulah' ),
	'ff-CM' => esc_html__( 'Fulah (Cameroon)' ),
	'ff-GN' => esc_html__( 'Fulah (Guinea)' ),
	'ff-MR' => esc_html__( 'Fulah (Mauritania)' ),
	'ff-SN' => esc_html__( 'Fulah (Senegal)' ),
	'gl' => esc_html__( 'Galician' ),
	'gl-ES' => esc_html__( 'Galician (Spain)' ),
	'lg' => esc_html__( 'Ganda' ),
	'lg-UG' => esc_html__( 'Ganda (Uganda)' ),
	'ka' => esc_html__( 'Georgian' ),
	'ka-GE' => esc_html__( 'Georgian (Georgia)' ),
	'de' => esc_html__( 'German' ),
	'de-AT' => esc_html__( 'German (Austria)' ),
	'de-BE' => esc_html__( 'German (Belgium)' ),
	'de-DE' => esc_html__( 'German (Germany)' ),
	'de-LI' => esc_html__( 'German (Liechtenstein)' ),
	'de-LU' => esc_html__( 'German (Luxembourg)' ),
	'de-CH' => esc_html__( 'German (Switzerland)' ),
	'el' => esc_html__( 'Greek' ),
	'el-CY' => esc_html__( 'Greek (Cyprus)' ),
	'el-GR' => esc_html__( 'Greek (Greece)' ),
	'gu' => esc_html__( 'Gujarati' ),
	'gu-IN' => esc_html__( 'Gujarati (India)' ),
	'ha' => esc_html__( 'Hausa' ),
	'ha-GH' => esc_html__( 'Hausa (Ghana)' ),
	'ha-Latn-GH' => esc_html__( 'Hausa (Latin, Ghana)' ),
	'ha-Latn-NE' => esc_html__( 'Hausa (Latin, Niger)' ),
	'ha-Latn-NG' => esc_html__( 'Hausa (Latin, Nigeria)' ),
	'ha-Latn' => esc_html__( 'Hausa (Latin)' ),
	'ha-NE' => esc_html__( 'Hausa (Niger)' ),
	'ha-NG' => esc_html__( 'Hausa (Nigeria)' ),
	'he' => esc_html__( 'Hebrew' ),
	'he-IL' => esc_html__( 'Hebrew (Israel)' ),
	'hi' => esc_html__( 'Hindi' ),
	'hi-IN' => esc_html__( 'Hindi (India)' ),
	'hu' => esc_html__( 'Hungarian' ),
	'hu-HU' => esc_html__( 'Hungarian (Hungary)' ),
	'is' => esc_html__( 'Icelandic' ),
	'is-IS' => esc_html__( 'Icelandic (Iceland)' ),
	'ig' => esc_html__( 'Igbo' ),
	'ig-NG' => esc_html__( 'Igbo (Nigeria)' ),
	'id' => esc_html__( 'Indonesian' ),
	'id-ID' => esc_html__( 'Indonesian (Indonesia)' ),
	'ga' => esc_html__( 'Irish' ),
	'ga-IE' => esc_html__( 'Irish (Ireland)' ),
	'it' => esc_html__( 'Italian' ),
	'it-IT' => esc_html__( 'Italian (Italy)' ),
	'it-SM' => esc_html__( 'Italian (San Marino)' ),
	'it-CH' => esc_html__( 'Italian (Switzerland)' ),
	'ja' => esc_html__( 'Japanese' ),
	'ja-JP' => esc_html__( 'Japanese (Japan)' ),
	'kl' => esc_html__( 'Kalaallisut' ),
	'kl-GL' => esc_html__( 'Kalaallisut (Greenland)' ),
	'kn' => esc_html__( 'Kannada' ),
	'kn-IN' => esc_html__( 'Kannada (India)' ),
	'ks' => esc_html__( 'Kashmiri' ),
	'ks-Arab-IN' => esc_html__( 'Kashmiri (Arabic, India)' ),
	'ks-Arab' => esc_html__( 'Kashmiri (Arabic)' ),
	'ks-IN' => esc_html__( 'Kashmiri (India)' ),
	'kk' => esc_html__( 'Kazakh' ),
	'kk-Cyrl-KZ' => esc_html__( 'Kazakh (Cyrillic, Kazakhstan)' ),
	'kk-Cyrl' => esc_html__( 'Kazakh (Cyrillic)' ),
	'kk-KZ' => esc_html__( 'Kazakh (Kazakhstan)' ),
	'km' => esc_html__( 'Khmer' ),
	'km-KH' => esc_html__( 'Khmer (Cambodia)' ),
	'ki' => esc_html__( 'Kikuyu' ),
	'ki-KE' => esc_html__( 'Kikuyu (Kenya)' ),
	'rw' => esc_html__( 'Kinyarwanda' ),
	'rw-RW' => esc_html__( 'Kinyarwanda (Rwanda)' ),
	'ko' => esc_html__( 'Korean' ),
	'ko-KP' => esc_html__( 'Korean (North Korea)' ),
	'ko-KR' => esc_html__( 'Korean (South Korea)' ),
	'ky' => esc_html__( 'Kyrgyz' ),
	'ky-Cyrl-KG' => esc_html__( 'Kyrgyz (Cyrillic, Kyrgyzstan)' ),
	'ky-Cyrl' => esc_html__( 'Kyrgyz (Cyrillic)' ),
	'ky-KG' => esc_html__( 'Kyrgyz (Kyrgyzstan)' ),
	'lo' => esc_html__( 'Lao' ),
	'lo-LA' => esc_html__( 'Lao (Laos)' ),
	'lv' => esc_html__( 'Latvian' ),
	'lv-LV' => esc_html__( 'Latvian (Latvia)' ),
	'ln' => esc_html__( 'Lingala' ),
	'ln-AO' => esc_html__( 'Lingala (Angola)' ),
	'ln-CF' => esc_html__( 'Lingala (Central African Republic)' ),
	'ln-CG' => esc_html__( 'Lingala (Congo - Brazzaville)' ),
	'ln-CD' => esc_html__( 'Lingala (Congo - Kinshasa)' ),
	'lt' => esc_html__( 'Lithuanian' ),
	'lt-LT' => esc_html__( 'Lithuanian (Lithuania)' ),
	'lu' => esc_html__( 'Luba-Katanga' ),
	'lu-CD' => esc_html__( 'Luba-Katanga (Congo - Kinshasa)' ),
	'lb' => esc_html__( 'Luxembourgish' ),
	'lb-LU' => esc_html__( 'Luxembourgish (Luxembourg)' ),
	'mk' => esc_html__( 'Macedonian' ),
	'mk-MK' => esc_html__( 'Macedonian (Macedonia)' ),
	'mg' => esc_html__( 'Malagasy' ),
	'mg-MG' => esc_html__( 'Malagasy (Madagascar)' ),
	'ms' => esc_html__( 'Malay' ),
	'ms-BN' => esc_html__( 'Malay (Brunei)' ),
	'ms-Latn-BN' => esc_html__( 'Malay (Latin, Brunei)' ),
	'ms-Latn-MY' => esc_html__( 'Malay (Latin, Malaysia)' ),
	'ms-Latn-SG' => esc_html__( 'Malay (Latin, Singapore)' ),
	'ms-Latn' => esc_html__( 'Malay (Latin)' ),
	'ms-MY' => esc_html__( 'Malay (Malaysia)' ),
	'ms-SG' => esc_html__( 'Malay (Singapore)' ),
	'ml' => esc_html__( 'Malayalam' ),
	'ml-IN' => esc_html__( 'Malayalam (India)' ),
	'mt' => esc_html__( 'Maltese' ),
	'mt-MT' => esc_html__( 'Maltese (Malta)' ),
	'gv' => esc_html__( 'Manx' ),
	'gv-IM' => esc_html__( 'Manx (Isle of Man)' ),
	'mr' => esc_html__( 'Marathi' ),
	'mr-IN' => esc_html__( 'Marathi (India)' ),
	'mn' => esc_html__( 'Mongolian' ),
	'mn-Cyrl-MN' => esc_html__( 'Mongolian (Cyrillic, Mongolia)' ),
	'mn-Cyrl' => esc_html__( 'Mongolian (Cyrillic)' ),
	'mn-MN' => esc_html__( 'Mongolian (Mongolia)' ),
	'ne' => esc_html__( 'Nepali' ),
	'ne-IN' => esc_html__( 'Nepali (India)' ),
	'ne-NP' => esc_html__( 'Nepali (Nepal)' ),
	'nd' => esc_html__( 'North Ndebele' ),
	'nd-ZW' => esc_html__( 'North Ndebele (Zimbabwe)' ),
	'se' => esc_html__( 'Northern Sami' ),
	'se-FI' => esc_html__( 'Northern Sami (Finland)' ),
	'se-NO' => esc_html__( 'Northern Sami (Norway)' ),
	'se-SE' => esc_html__( 'Northern Sami (Sweden)' ),
	'no' => esc_html__( 'Norwegian' ),
	'no-NO' => esc_html__( 'Norwegian (Norway)' ),
	'nb' => esc_html__( 'Norwegian Bokmål' ),
	'nb-NO' => esc_html__( 'Norwegian Bokmål (Norway)' ),
	'nb-SJ' => esc_html__( 'Norwegian Bokmål (Svalbard & Jan Mayen)' ),
	'nn' => esc_html__( 'Norwegian Nynorsk' ),
	'nn-NO' => esc_html__( 'Norwegian Nynorsk (Norway)' ),
	'or' => esc_html__( 'Oriya' ),
	'or-IN' => esc_html__( 'Oriya (India)' ),
	'om' => esc_html__( 'Oromo' ),
	'om-ET' => esc_html__( 'Oromo (Ethiopia)' ),
	'om-KE' => esc_html__( 'Oromo (Kenya)' ),
	'os' => esc_html__( 'Ossetic' ),
	'os-GE' => esc_html__( 'Ossetic (Georgia)' ),
	'os-RU' => esc_html__( 'Ossetic (Russia)' ),
	'ps' => esc_html__( 'Pashto' ),
	'ps-AF' => esc_html__( 'Pashto (Afghanistan)' ),
	'fa' => esc_html__( 'Persian' ),
	'fa-AF' => esc_html__( 'Persian (Afghanistan)' ),
	'fa-IR' => esc_html__( 'Persian (Iran)' ),
	'pl' => esc_html__( 'Polish' ),
	'pl-PL' => esc_html__( 'Polish (Poland)' ),
	'pt' => esc_html__( 'Portuguese' ),
	'pt-AO' => esc_html__( 'Portuguese (Angola)' ),
	'pt-BR' => esc_html__( 'Portuguese (Brazil)' ),
	'pt-CV' => esc_html__( 'Portuguese (Cape Verde)' ),
	'pt-GW' => esc_html__( 'Portuguese (Guinea-Bissau)' ),
	'pt-MO' => esc_html__( 'Portuguese (Macau SAR China)' ),
	'pt-MZ' => esc_html__( 'Portuguese (Mozambique)' ),
	'pt-PT' => esc_html__( 'Portuguese (Portugal)' ),
	'pt-ST' => esc_html__( 'Portuguese (São Tomé & Príncipe)' ),
	'pt-TL' => esc_html__( 'Portuguese (Timor-Leste)' ),
	'pa' => esc_html__( 'Punjabi' ),
	'pa-Arab-PK' => esc_html__( 'Punjabi (Arabic, Pakistan)' ),
	'pa-Arab' => esc_html__( 'Punjabi (Arabic)' ),
	'pa-Guru-IN' => esc_html__( 'Punjabi (Gurmukhi, India)' ),
	'pa-Guru' => esc_html__( 'Punjabi (Gurmukhi)' ),
	'pa-IN' => esc_html__( 'Punjabi (India)' ),
	'pa-PK' => esc_html__( 'Punjabi (Pakistan)' ),
	'qu' => esc_html__( 'Quechua' ),
	'qu-BO' => esc_html__( 'Quechua (Bolivia)' ),
	'qu-EC' => esc_html__( 'Quechua (Ecuador)' ),
	'qu-PE' => esc_html__( 'Quechua (Peru)' ),
	'ro' => esc_html__( 'Romanian' ),
	'ro-MD' => esc_html__( 'Romanian (Moldova)' ),
	'ro-RO' => esc_html__( 'Romanian (Romania)' ),
	'rm' => esc_html__( 'Romansh' ),
	'rm-CH' => esc_html__( 'Romansh (Switzerland)' ),
	'rn' => esc_html__( 'Rundi' ),
	'rn-BI' => esc_html__( 'Rundi (Burundi)' ),
	'ru' => esc_html__( 'Russian' ),
	'ru-BY' => esc_html__( 'Russian (Belarus)' ),
	'ru-KZ' => esc_html__( 'Russian (Kazakhstan)' ),
	'ru-KG' => esc_html__( 'Russian (Kyrgyzstan)' ),
	'ru-MD' => esc_html__( 'Russian (Moldova)' ),
	'ru-RU' => esc_html__( 'Russian (Russia)' ),
	'ru-UA' => esc_html__( 'Russian (Ukraine)' ),
	'sg' => esc_html__( 'Sango' ),
	'sg-CF' => esc_html__( 'Sango (Central African Republic)' ),
	'gd' => esc_html__( 'Scottish Gaelic' ),
	'gd-GB' => esc_html__( 'Scottish Gaelic (United Kingdom)' ),
	'sr' => esc_html__( 'Serbian' ),
	'sr-BA' => esc_html__( 'Serbian (Bosnia & Herzegovina)' ),
	'sr-Cyrl-BA' => esc_html__( 'Serbian (Cyrillic, Bosnia & Herzegovina)' ),
	'sr-Cyrl-XK' => esc_html__( 'Serbian (Cyrillic, Kosovo)' ),
	'sr-Cyrl-ME' => esc_html__( 'Serbian (Cyrillic, Montenegro)' ),
	'sr-Cyrl-RS' => esc_html__( 'Serbian (Cyrillic, Serbia)' ),
	'sr-Cyrl' => esc_html__( 'Serbian (Cyrillic)' ),
	'sr-XK' => esc_html__( 'Serbian (Kosovo)' ),
	'sr-Latn-BA' => esc_html__( 'Serbian (Latin, Bosnia & Herzegovina)' ),
	'sr-Latn-XK' => esc_html__( 'Serbian (Latin, Kosovo)' ),
	'sr-Latn-ME' => esc_html__( 'Serbian (Latin, Montenegro)' ),
	'sr-Latn-RS' => esc_html__( 'Serbian (Latin, Serbia)' ),
	'sr-Latn' => esc_html__( 'Serbian (Latin)' ),
	'sr-ME' => esc_html__( 'Serbian (Montenegro)' ),
	'sr-RS' => esc_html__( 'Serbian (Serbia)' ),
	'sh' => esc_html__( 'Serbo-Croatian' ),
	'sh-BA' => esc_html__( 'Serbo-Croatian (Bosnia & Herzegovina)' ),
	'sn' => esc_html__( 'Shona' ),
	'sn-ZW' => esc_html__( 'Shona (Zimbabwe)' ),
	'ii' => esc_html__( 'Sichuan Yi' ),
	'ii-CN' => esc_html__( 'Sichuan Yi (China)' ),
	'si' => esc_html__( 'Sinhala' ),
	'si-LK' => esc_html__( 'Sinhala (Sri Lanka)' ),
	'sk' => esc_html__( 'Slovak' ),
	'sk-SK' => esc_html__( 'Slovak (Slovakia)' ),
	'sl' => esc_html__( 'Slovenian' ),
	'sl-SI' => esc_html__( 'Slovenian (Slovenia)' ),
	'so' => esc_html__( 'Somali' ),
	'so-DJ' => esc_html__( 'Somali (Djibouti)' ),
	'so-ET' => esc_html__( 'Somali (Ethiopia)' ),
	'so-KE' => esc_html__( 'Somali (Kenya)' ),
	'so-SO' => esc_html__( 'Somali (Somalia)' ),
	'es' => esc_html__( 'Spanish' ),
	'es-AR' => esc_html__( 'Spanish (Argentina)' ),
	'es-BO' => esc_html__( 'Spanish (Bolivia)' ),
	'es-IC' => esc_html__( 'Spanish (Canary Islands)' ),
	'es-EA' => esc_html__( 'Spanish (Ceuta & Melilla)' ),
	'es-CL' => esc_html__( 'Spanish (Chile)' ),
	'es-CO' => esc_html__( 'Spanish (Colombia)' ),
	'es-CR' => esc_html__( 'Spanish (Costa Rica)' ),
	'es-CU' => esc_html__( 'Spanish (Cuba)' ),
	'es-DO' => esc_html__( 'Spanish (Dominican Republic)' ),
	'es-EC' => esc_html__( 'Spanish (Ecuador)' ),
	'es-SV' => esc_html__( 'Spanish (El Salvador)' ),
	'es-GQ' => esc_html__( 'Spanish (Equatorial Guinea)' ),
	'es-GT' => esc_html__( 'Spanish (Guatemala)' ),
	'es-HN' => esc_html__( 'Spanish (Honduras)' ),
	'es-MX' => esc_html__( 'Spanish (Mexico)' ),
	'es-NI' => esc_html__( 'Spanish (Nicaragua)' ),
	'es-PA' => esc_html__( 'Spanish (Panama)' ),
	'es-PY' => esc_html__( 'Spanish (Paraguay)' ),
	'es-PE' => esc_html__( 'Spanish (Peru)' ),
	'es-PH' => esc_html__( 'Spanish (Philippines)' ),
	'es-PR' => esc_html__( 'Spanish (Puerto Rico)' ),
	'es-ES' => esc_html__( 'Spanish (Spain)' ),
	'es-US' => esc_html__( 'Spanish (United States)' ),
	'es-UY' => esc_html__( 'Spanish (Uruguay)' ),
	'es-VE' => esc_html__( 'Spanish (Venezuela)' ),
	'sw' => esc_html__( 'Swahili' ),
	'sw-KE' => esc_html__( 'Swahili (Kenya)' ),
	'sw-TZ' => esc_html__( 'Swahili (Tanzania)' ),
	'sw-UG' => esc_html__( 'Swahili (Uganda)' ),
	'sv' => esc_html__( 'Swedish' ),
	'sv-AX' => esc_html__( 'Swedish (Åland Islands)' ),
	'sv-FI' => esc_html__( 'Swedish (Finland)' ),
	'sv-SE' => esc_html__( 'Swedish (Sweden)' ),
	'tl' => esc_html__( 'Tagalog' ),
	'tl-PH' => esc_html__( 'Tagalog (Philippines)' ),
	'ta' => esc_html__( 'Tamil' ),
	'ta-IN' => esc_html__( 'Tamil (India)' ),
	'ta-MY' => esc_html__( 'Tamil (Malaysia)' ),
	'ta-SG' => esc_html__( 'Tamil (Singapore)' ),
	'ta-LK' => esc_html__( 'Tamil (Sri Lanka)' ),
	'te' => esc_html__( 'Telugu' ),
	'te-IN' => esc_html__( 'Telugu (India)' ),
	'th' => esc_html__( 'Thai' ),
	'th-TH' => esc_html__( 'Thai (Thailand)' ),
	'bo' => esc_html__( 'Tibetan' ),
	'bo-CN' => esc_html__( 'Tibetan (China)' ),
	'bo-IN' => esc_html__( 'Tibetan (India)' ),
	'ti' => esc_html__( 'Tigrinya' ),
	'ti-ER' => esc_html__( 'Tigrinya (Eritrea)' ),
	'ti-ET' => esc_html__( 'Tigrinya (Ethiopia)' ),
	'to' => esc_html__( 'Tongan' ),
	'to-TO' => esc_html__( 'Tongan (Tonga)' ),
	'tr' => esc_html__( 'Turkish' ),
	'tr-CY' => esc_html__( 'Turkish (Cyprus)' ),
	'tr-TR' => esc_html__( 'Turkish (Turkey)' ),
	'uk' => esc_html__( 'Ukrainian' ),
	'uk-UA' => esc_html__( 'Ukrainian (Ukraine)' ),
	'ur' => esc_html__( 'Urdu' ),
	'ur-IN' => esc_html__( 'Urdu (India)' ),
	'ur-PK' => esc_html__( 'Urdu (Pakistan)' ),
	'ug' => esc_html__( 'Uyghur' ),
	'ug-Arab-CN' => esc_html__( 'Uyghur (Arabic, China)' ),
	'ug-Arab' => esc_html__( 'Uyghur (Arabic)' ),
	'ug-CN' => esc_html__( 'Uyghur (China)' ),
	'uz' => esc_html__( 'Uzbek' ),
	'uz-AF' => esc_html__( 'Uzbek (Afghanistan)' ),
	'uz-Arab-AF' => esc_html__( 'Uzbek (Arabic, Afghanistan)' ),
	'uz-Arab' => esc_html__( 'Uzbek (Arabic)' ),
	'uz-Cyrl-UZ' => esc_html__( 'Uzbek (Cyrillic, Uzbekistan)' ),
	'uz-Cyrl' => esc_html__( 'Uzbek (Cyrillic)' ),
	'uz-Latn-UZ' => esc_html__( 'Uzbek (Latin, Uzbekistan)' ),
	'uz-Latn' => esc_html__( 'Uzbek (Latin)' ),
	'uz-UZ' => esc_html__( 'Uzbek (Uzbekistan)' ),
	'vi' => esc_html__( 'Vietnamese' ),
	'vi-VN' => esc_html__( 'Vietnamese (Vietnam)' ),
	'cy' => esc_html__( 'Welsh' ),
	'cy-GB' => esc_html__( 'Welsh (United Kingdom)' ),
	'fy' => esc_html__( 'Western Frisian' ),
	'fy-NL' => esc_html__( 'Western Frisian (Netherlands)' ),
	'yi' => esc_html__( 'Yiddish' ),
	'yo' => esc_html__( 'Yoruba' ),
	'yo-BJ' => esc_html__( 'Yoruba (Benin)' ),
	'yo-NG' => esc_html__( 'Yoruba (Nigeria)' ),
	'zu' => esc_html__( 'Zulu' ),
	'zu-ZA' => esc_html__( 'Zulu (South Africa)' ),
);