<?php

/**
 * Blocks Initializer
 *
 * Enqueue CSS/JS of all the blocks.
 *
 * @since   1.0.0
 * @package CGB
 */

// Exit if accessed directly.
if (!defined('ABSPATH')) {
  exit;
}

/**
 * Enqueue Gutenberg block assets for both frontend + backend.
 *
 * Assets enqueued:
 * 1. blocks.style.css - Frontend + Backend.
 * 2. blocks.js - Backend.
 * 3. blocks.editor.css - Backend.
 *
 * @uses {wp-blocks} for block type registration & related functions.
 * @uses {wp-element} for WP Element abstraction — structure of blocks.
 * @uses {wp-i18n} to internationalize the block's text.
 * @uses {wp-editor} for WP editor styles.
 * @since 1.0.0
 */
function lottiefiles_register_block()
{ // phpcs:ignore
  // Load the dependencies and version information generated by build process
  $asset_file = include(plugin_dir_path(__FILE__) . '../../build/index.asset.php');

  // Register block editor script for backend.
  wp_register_script(
    'lottiefiles-block-js', // Handle.
    plugins_url('../build/index.js', dirname(__FILE__)), // Block.js: We register the block here. Built with Webpack.
    $asset_file['dependencies'],
    $asset_file['version'],
    true // Enqueue the script in the footer.
  );


  if (strstr($_SERVER['REQUEST_URI'], 'wp-admin/post-new.php') || strstr($_SERVER['REQUEST_URI'], 'wp-admin/post.php') || strstr($_SERVER['REQUEST_URI'], 'lottiefiles-admin-settings') || strstr($_SERVER['REQUEST_URI'], 'site-editor.php')) {
    wp_enqueue_style(
      'lottiefiles-style-css',
      plugins_url("../build/index.css", dirname(__FILE__)),
      array('wp-components'),
      $asset_file['version']
    );
  }

  // WP Localized globals. Use dynamic PHP stuff in JavaScript via `lottiefiles` object.
  wp_localize_script(
    'lottiefiles-block-js',
    'lottiefiles', // Array containing dynamic data for a JS Global.
    [
      'pluginDirPath' => plugin_dir_path(__DIR__),
      'pluginDirUrl'  => plugin_dir_url(__DIR__),
      // Add more data here that you want to access from `lottiefiles` object.
    ]
  );


  $userSettings = json_decode(get_option('lottie_config_admin'));

  if (!empty($userSettings)) {
    if ($userSettings->enableCdn) {
      wp_register_script('lottieFilesCDN', 'https://unpkg.com/@lottiefiles/lottie-player@1.5.5/dist/lottie-player.js', null, null, true);
      wp_enqueue_script('lottieFilesCDN');
    } else {
      wp_register_script('lottieFilesLocalPlayer', plugins_url("../build/lottiefiles-player.js", dirname(__FILE__)), null, null, true);
      wp_enqueue_script('lottieFilesLocalPlayer');
    }
  } else {
    wp_register_script('lottieFilesLocalPlayer', plugins_url("../build/lottiefiles-player.js", dirname(__FILE__)), null, null, true);
    wp_enqueue_script('lottieFilesLocalPlayer');
  }

  // Not longer need it since for interactivity features we are using lottie player
  // wp_register_script('lottieFilesDLCDN', 'https://unpkg.com/@dotlottie/player-component@1.0.0/dist/dotlottie-player.js', null, null, true);
  // wp_enqueue_script('lottieFilesDLCDN');

  wp_register_script('lottieFilesInteractivityCDN',  plugins_url("../build/lottiefiles-interactivity.js", dirname(__FILE__)), null, null, true);
  wp_enqueue_script('lottieFilesInteractivityCDN');

  function cc_mime_types($mimes)
  {
    $mimes['json'] = 'application/json';
    $mimes['json'] = 'text/plain';
    $mimes['lottie'] = 'lottie';
    return $mimes;
  }

  add_filter('upload_mimes', 'cc_mime_types');

  /**
   * Register Gutenberg block on server-side.
   *
   * Register the block on server-side to ensure that the block
   * scripts and styles for both frontend and backend are
   * enqueued when the editor loads.
   *
   * @link https://wordpress.org/gutenberg/handbook/blocks/writing-your-first-block-type#enqueuing-block-scripts
   * @since 1.16.0
   */
  register_block_type(
    'lottiefiles/block-lottiefiles',
    array(
      // Enqueue blocks.style.css on both frontend & backend.
      'style'         => 'lottiefiles-style-css',
      // Enqueue blocks.js in the editor only.
      'editor_script' => 'lottiefiles-block-js',
      // Enqueue blocks.editor.css in the editor only.
      // 'editor_style'  => 'lottiefiles-block-editor-css',
    )
  );
}

// Hook: Block assets.
add_action('init', 'lottiefiles_register_block');

/**
 * Registers front-end hydration scripts for block
 */
function lottiefiles_register_front()
{

  $asset_file_front = include(plugin_dir_path(__FILE__) . '../../build/frontend-helper.asset.php');
  wp_enqueue_script(
    'lottiefiles-block-frontend',
    plugins_url('../build/frontend-helper.js',  dirname(__FILE__)),
    $asset_file_front['dependencies'],
    $asset_file_front['version']
  );

  wp_enqueue_style(
    'lottiefiles-css',
    plugins_url("../build/lottiefiles-frontend.css.css", dirname(__FILE__)),
    array('wp-components'),
    $asset_file_front['version']
  );
}
add_action('wp_enqueue_scripts', 'lottiefiles_register_front');
