/**
 * Copyright 2022 Design Barn Inc.
 */

import * as React from 'react';

interface ILottieIconProps {
  size: number;
}

export const Lottie: React.FC<ILottieIconProps> = ({ size = 24 }: ILottieIconProps) => (
  <svg width={`${size}px`} height={`${size}px`} viewBox="0 0 80 80" fill="none">
    <path
      d="M59.7566 0H20.2433C9.06324 0 0 9.06331 0 20.2434V59.7566C0 70.9367 9.06324 80 20.2433 80H59.7566C70.9367 80 79.9999 70.9367 79.9999 59.7566V20.2434C79.9999 9.06331 70.9367 0 59.7566 0Z"
      fill="#00DDB3"
    />
    <path
      d="M60.8068 17.9194C47.0165 17.9194 41.9304 27.7511 37.8298 35.6521L35.1326 40.7018C30.7846 49.0814 27.5398 54.1716 19.1764 54.1716C18.6567 54.1711 18.1421 54.273 17.6618 54.4715C17.1815 54.67 16.7451 54.9612 16.3775 55.3285C16.0098 55.6958 15.7182 56.1319 15.5192 56.6119C15.3202 57.092 15.2178 57.6065 15.2178 58.1262C15.2178 58.6459 15.3202 59.1605 15.5192 59.6405C15.7182 60.1206 16.0098 60.5567 16.3775 60.924C16.7451 61.2912 17.1815 61.5824 17.6618 61.7809C18.1421 61.9794 18.6567 62.0813 19.1764 62.0808C32.9667 62.0808 38.0529 52.2491 42.1534 44.3481L44.8344 39.2984C49.1824 30.9188 52.4272 25.8286 60.7906 25.8286C61.3103 25.8291 61.825 25.7272 62.3052 25.5287C62.7855 25.3302 63.2219 25.039 63.5895 24.6717C63.9572 24.3044 64.2488 23.8683 64.4478 23.3883C64.6468 22.9082 64.7492 22.3937 64.7492 21.874C64.7492 21.3543 64.6468 20.8397 64.4478 20.3597C64.2488 19.8796 63.9572 19.4435 63.5895 19.0762C63.2219 18.7089 62.7855 18.4178 62.3052 18.2193C61.825 18.0208 61.3103 17.9189 60.7906 17.9194H60.8068Z"
      fill="white"
    />
  </svg>
);
