/**
 * Copyright 2022 Design Barn Inc.
 */

import * as React from 'react';

export const LinkIcon: React.FC<{ color: string }> = ({ color }): JSX.Element => (
  <svg width="13" height="12" viewBox="0 0 13 12" fill="none" xmlns="http://www.w3.org/2000/svg">
    <path
      d="M4.52931 2.08789C4.80545 2.08789 5.02931 1.86403 5.02931 1.58789C5.02931 1.31175 4.80545 1.08789 4.52931 1.08789V2.08789ZM10.9115 7.47007C10.9115 7.19393 10.6876 6.97007 10.4115 6.97007C10.1354 6.97007 9.91149 7.19393 9.91149 7.47007H10.9115ZM9.23506 10.4994H2.17644V11.4994H9.23506V10.4994ZM1.5 9.82295V2.76433H0.5V9.82295H1.5ZM2.17644 2.08789H4.52931V1.08789H2.17644V2.08789ZM9.91149 7.47007V9.82295H10.9115V7.47007H9.91149ZM2.17644 10.4994C1.80285 10.4994 1.5 10.1965 1.5 9.82295H0.5C0.5 10.7488 1.25056 11.4994 2.17644 11.4994V10.4994ZM9.23506 11.4994C10.1609 11.4994 10.9115 10.7488 10.9115 9.82295H9.91149C9.91149 10.1965 9.60864 10.4994 9.23506 10.4994V11.4994ZM1.5 2.76433C1.5 2.39074 1.80285 2.08789 2.17644 2.08789V1.08789C1.25057 1.08789 0.5 1.83846 0.5 2.76433H1.5Z"
      fill={color}
    />
    <path
      d="M8.05859 0.5C7.78245 0.5 7.55859 0.723858 7.55859 1C7.55859 1.27614 7.78245 1.5 8.05859 1.5V0.5ZM11.5879 1H12.0879C12.0879 0.723858 11.864 0.5 11.5879 0.5V1ZM11.0879 4.52931C11.0879 4.80545 11.3118 5.02931 11.5879 5.02931C11.864 5.02931 12.0879 4.80545 12.0879 4.52931H11.0879ZM8.05859 1.5H11.5879V0.5H8.05859V1.5ZM11.0879 1V4.52931H12.0879V1H11.0879Z"
      fill={color}
    />
    <path d="M10.9998 1.58819L3.94114 8.05859" stroke={color} strokeLinecap="round" strokeLinejoin="round" />
  </svg>
);
