/**
 * Copyright 2022 Design Barn Inc.
 */

import * as React from 'react';

export const Illustration: React.FC = () => (
  <svg width="712" height="279" viewBox="0 0 712 279" fill="none">
    <path
      d="M611.474 28.9258C611.395 28.7751 611.309 28.6252 611.215 28.4763C611.238 27.7778 611.225 27.077 611.204 26.3872C611.167 25.2149 611.156 23.9877 610.611 22.9181C610.392 22.4513 610.05 22.0535 609.62 21.7686C609.191 21.4836 608.691 21.3223 608.176 21.3025C607.58 21.2963 607.004 21.488 606.41 21.4939C606.128 21.4898 605.853 21.4121 605.611 21.2685C605.369 21.1249 605.168 20.9204 605.03 20.6754C604.454 19.8406 604.066 18.9737 603.079 18.5444C600.554 17.4471 597.886 19.2793 595.934 20.7312C595.171 21.2999 594.437 21.9081 593.737 22.5532C593.324 22.8912 592.942 23.2645 592.594 23.6688C591.912 24.3721 591.268 25.111 590.664 25.8823C590.002 26.2719 589.482 26.8633 589.18 27.5699C588.878 28.2764 588.81 29.0611 588.986 29.809C589.32 30.9134 589.88 31.936 590.632 32.8112C591.486 33.9275 592.355 35.0332 593.216 36.1438L595.839 39.5245C596.457 40.3206 597.115 41.4795 598.152 41.7774C599.331 42.1162 600.413 41.2003 601.3 40.5626C601.81 40.1961 602.32 39.8296 602.83 39.4631C605.203 38.5504 607.682 37.4613 609.643 35.875C610.928 35.6524 612.084 34.9625 612.89 33.9381C614.361 31.8983 613.392 29.8754 611.474 28.9258ZM603.412 20.3637C603.44 20.4054 603.467 20.4496 603.495 20.4927C602.007 19.329 600.215 19.3305 598.521 19.8632C599.258 19.4087 600.1 19.1508 600.965 19.1142C601.445 19.1019 601.92 19.2098 602.347 19.428C602.775 19.6462 603.141 19.9679 603.412 20.3637ZM589.95 28.3859C589.973 27.9209 590.116 27.4698 590.365 27.0769C590.377 27.0766 590.39 27.0706 590.402 27.0694C590.359 27.1727 590.33 27.2815 590.316 27.3926C590.159 28.9304 590.529 30.4759 591.365 31.7759C591.317 31.7104 591.267 31.6464 591.22 31.5807C590.561 30.6644 589.885 29.5611 589.95 28.3859ZM598.291 40.5826C597.926 40.2484 597.601 39.8738 597.321 39.4659C596.914 38.9418 596.508 38.4177 596.101 37.8935C595.312 36.8772 594.507 35.8698 593.709 34.8563C595.303 36.6804 597.125 38.3709 599.564 38.9109C599.633 38.9263 599.702 38.9365 599.771 38.9498C599.77 38.9643 599.767 38.9782 599.765 38.9928C599.745 39.1323 599.756 39.2745 599.796 39.4094C599.837 39.5444 599.907 39.6687 600.001 39.7738C600.095 39.8789 600.211 39.9621 600.34 40.0176C600.47 40.0731 600.61 40.0996 600.751 40.0952C599.989 40.6658 599.185 41.3065 598.291 40.5826Z"
      fill="#0FCCCE"
    />
    <path
      d="M126.805 230.498H134.073L117.805 234.291C117.805 234.291 129.752 239.409 131.478 250.212C133.204 261.015 133.68 265.851 132.278 270.979L143.644 269.127L206.582 217.777C206.582 217.777 231.956 197.085 231.059 195.447C230.162 193.81 207.097 162.82 207.097 162.82L205.737 168.429L208.521 180.743C208.521 180.743 210.356 182.786 209.841 187.913C209.327 193.041 208.344 200.093 201.797 204.818C191.722 212.088 187.301 210.759 187.301 210.759V213.528C187.301 213.528 181.638 210.94 175.55 211.733L169.462 212.525L175.55 206.344L159.253 189.591L126.805 230.498Z"
      fill="#F0DC01"
    />
    <path
      d="M474.418 193.52C469.257 193.888 463.899 193.122 459.544 190.148C455.511 187.394 452.705 182.67 453.014 177.706C453.036 177.573 453.024 177.437 452.978 177.311C452.932 177.184 452.854 177.072 452.752 176.984C452.819 176.49 452.887 175.996 452.956 175.503C453.205 173.708 449.957 175.094 449.775 176.407C448.946 182.377 448.155 188.402 448.469 194.442C448.689 198.671 448.983 206.578 454.225 207.688C454.806 207.812 455.628 207.355 456.189 206.783C456.484 206.577 456.751 206.335 456.985 206.062C460.82 201.513 466.561 199.256 471.933 197.08C472.329 196.895 472.66 196.597 472.884 196.223C472.976 196.217 473.068 196.214 473.16 196.207C474.493 196.112 476.532 193.37 474.418 193.52ZM455.257 204.686C453.772 203.881 453.138 202.079 452.729 200.391C452.963 200.74 453.231 201.064 453.53 201.358C454.015 201.841 454.596 202.218 455.236 202.463C455.876 202.708 456.56 202.816 457.244 202.78C456.549 203.38 455.885 204.016 455.257 204.686Z"
      fill="#0FCCCE"
    />
    <path
      d="M393.65 100.242C393.65 100.242 390.519 109.913 389.878 111.643C389.237 113.374 387.699 119.976 388.468 122.924C389.237 125.872 391.248 125.251 392.275 122.479C393.302 119.708 395.133 112.247 396.331 111.657C397.529 111.067 398.274 110.49 399.748 113.31C401.222 116.13 402.184 123.885 404.747 122.796C407.311 121.706 406.403 114.982 406.403 114.982C406.403 114.982 413.24 116.407 414.922 117.775C414.922 117.775 413.913 112.861 411.157 111.259C408.401 109.657 404.427 107.761 403.402 104.273C402.376 100.785 402.116 100.476 402.116 100.476C402.116 100.476 399.793 101.916 393.65 100.242Z"
      fill="#FACA91"
    />
    <path
      d="M403.701 104.561C403.672 104.504 403.643 104.447 403.614 104.391C403.583 104.342 403.541 104.3 403.493 104.267C403.445 104.234 403.391 104.211 403.334 104.199C403.212 104.144 403.076 104.126 402.944 104.148C402.781 104.158 402.622 104.199 402.474 104.266C402.299 104.323 402.135 104.408 401.987 104.517C401.89 104.596 401.793 104.675 401.696 104.755C401.534 104.905 401.401 105.084 401.304 105.282L401.217 105.544C401.199 105.621 401.197 105.7 401.21 105.778C401.224 105.855 401.252 105.929 401.295 105.995C401.324 106.052 401.353 106.108 401.381 106.165C401.413 106.214 401.454 106.256 401.502 106.289C401.55 106.322 401.604 106.345 401.661 106.356C401.783 106.412 401.919 106.43 402.051 106.408C402.214 106.397 402.373 106.357 402.521 106.29C402.696 106.233 402.861 106.148 403.008 106.039C403.106 105.96 403.203 105.88 403.3 105.801C403.461 105.651 403.594 105.472 403.691 105.274L403.778 105.011C403.796 104.935 403.798 104.856 403.785 104.778C403.772 104.701 403.743 104.627 403.701 104.561Z"
      fill="black"
    />
    <path
      d="M402.772 108.739C402.471 108.739 402.017 109.336 402.492 109.336C402.793 109.336 403.247 108.739 402.772 108.739Z"
      fill="black"
    />
    <path
      d="M407.939 109.743L407.937 109.739C407.931 109.721 407.921 109.696 407.913 109.677L407.909 109.67C407.9 109.656 407.888 109.644 407.874 109.634C407.861 109.625 407.845 109.618 407.829 109.615C407.794 109.599 407.755 109.594 407.717 109.6C407.697 109.604 407.676 109.609 407.657 109.616C407.634 109.608 407.61 109.605 407.586 109.606L407.498 109.622C407.432 109.642 407.369 109.672 407.313 109.712L407.23 109.78C407.183 109.823 407.146 109.874 407.118 109.93C407.105 109.958 407.095 109.988 407.088 110.018L407.087 110.024L407.087 110.027C407.087 110.037 407.085 110.086 407.086 110.097V110.098C407.086 110.102 407.087 110.105 407.088 110.109C407.089 110.112 407.11 110.165 407.112 110.168L407.112 110.17L407.113 110.172L407.116 110.176C407.132 110.195 407.15 110.212 407.17 110.227C407.173 110.229 407.177 110.231 407.18 110.233L407.185 110.235L407.188 110.236C407.21 110.244 407.234 110.253 407.256 110.26C407.26 110.261 407.264 110.262 407.268 110.263C407.273 110.264 407.277 110.264 407.282 110.264C407.309 110.266 407.338 110.268 407.366 110.268C407.368 110.268 407.371 110.268 407.373 110.268L407.387 110.267C407.421 110.262 407.454 110.256 407.487 110.248C407.528 110.238 407.566 110.224 407.603 110.204L407.604 110.204C407.612 110.199 407.689 110.154 407.697 110.149L407.7 110.148L407.704 110.145C407.764 110.103 407.816 110.053 407.86 109.996C407.9 109.946 407.927 109.887 407.939 109.824C407.942 109.797 407.942 109.77 407.939 109.743Z"
      fill="black"
    />
    <path
      d="M410.502 111.195C410.254 111.219 410.016 111.306 409.811 111.448C409.606 111.59 409.441 111.782 409.331 112.006C409.151 112.421 409.375 112.688 409.803 112.688C410.051 112.664 410.289 112.577 410.494 112.435C410.699 112.293 410.864 112.101 410.974 111.878C411.154 111.463 410.93 111.195 410.502 111.195Z"
      fill="black"
    />
    <path
      d="M405.934 107.628C405.633 107.628 405.18 108.225 405.654 108.225C405.955 108.225 406.409 107.628 405.934 107.628Z"
      fill="black"
    />
    <path
      d="M475.15 193.644C475.15 193.644 460.341 206.929 458.927 223.808L457.513 240.686C457.513 240.686 459.823 241.892 459.879 248.815C459.935 255.739 458.927 268.452 458.927 268.452C458.927 268.452 460.171 263.889 469.217 257.778C478.262 251.667 496.721 247.155 496.721 247.155L490.055 231.678C490.055 231.678 502.831 231.306 507.852 223.825C512.873 216.344 513.642 211.41 513.642 211.41C513.642 211.41 499.122 189.958 483.17 191.901C483.17 191.901 488.102 195.682 484.916 197.65C481.73 199.619 478.248 201.611 476.07 199.954C474.231 198.555 475.15 193.644 475.15 193.644Z"
      fill="#F04B2D"
    />
    <path
      d="M459.147 215.745C458.778 216.704 455.8 211.261 457.04 208.595C458.28 205.929 464.923 198.919 471.554 197.013C471.554 197.013 465.183 200.051 459.147 215.745Z"
      fill="#F04B2D"
    />
    <path
      d="M462.367 220.457C463.664 220.457 463.666 218.442 462.367 218.442C461.071 218.442 461.069 220.457 462.367 220.457Z"
      fill="#231F20"
    />
    <path
      d="M468.906 210.713C470.202 210.713 470.204 208.698 468.906 208.698C467.61 208.698 467.607 210.713 468.906 210.713Z"
      fill="#231F20"
    />
    <path
      d="M475.828 225.199C477.124 225.199 477.126 223.185 475.828 223.185C474.531 223.185 474.529 225.199 475.828 225.199Z"
      fill="#231F20"
    />
    <path
      d="M469.546 238.786C470.842 238.786 470.844 236.771 469.546 236.771C468.25 236.771 468.248 238.786 469.546 238.786Z"
      fill="#231F20"
    />
    <path
      d="M486.21 246.219C487.506 246.219 487.508 244.205 486.21 244.205C484.914 244.205 484.912 246.219 486.21 246.219Z"
      fill="#231F20"
    />
    <path
      d="M471.469 250.58C472.765 250.58 472.767 248.565 471.469 248.565C470.173 248.565 470.171 250.58 471.469 250.58Z"
      fill="#231F20"
    />
    <path
      d="M461.086 237.248C462.382 237.248 462.384 235.233 461.086 235.233C459.79 235.233 459.787 237.248 461.086 237.248Z"
      fill="#231F20"
    />
    <path
      d="M491.338 207.251C492.634 207.251 492.636 205.236 491.338 205.236C490.042 205.236 490.039 207.251 491.338 207.251Z"
      fill="#231F20"
    />
    <path
      d="M492.748 197.769C494.045 197.769 494.047 195.755 492.748 195.755C491.452 195.755 491.45 197.769 492.748 197.769Z"
      fill="#231F20"
    />
    <path
      d="M486.723 220.712C488.019 220.712 488.022 218.697 486.723 218.697C485.427 218.697 485.425 220.712 486.723 220.712Z"
      fill="#231F20"
    />
    <path
      d="M499.927 224.942C501.223 224.942 501.225 222.928 499.927 222.928C498.63 222.928 498.628 224.942 499.927 224.942Z"
      fill="#231F20"
    />
    <path
      d="M510.309 214.43C511.605 214.43 511.608 212.416 510.309 212.416C509.013 212.416 509.011 214.43 510.309 214.43Z"
      fill="#231F20"
    />
    <path
      d="M500.953 209.048C502.249 209.048 502.251 207.034 500.953 207.034C499.657 207.034 499.654 209.048 500.953 209.048Z"
      fill="#231F20"
    />
    <path
      d="M475.828 204.56C477.124 204.56 477.126 202.546 475.828 202.546C474.531 202.546 474.529 204.56 475.828 204.56Z"
      fill="#231F20"
    />
    <path
      d="M476.782 114.942C474.634 108.709 470.281 103.478 464.542 100.233C464.445 100.179 464.345 100.13 464.242 100.086C463.304 99.0489 462.352 98.0336 461.399 97.0424C459.879 95.4633 456.801 96.6087 456.928 98.8941C457.468 108.571 451.91 116.957 448.337 125.665C447.107 127.678 446.493 130.007 446.57 132.365C446.647 134.723 447.412 137.007 448.77 138.936C449.468 139.907 450.302 140.773 451.245 141.509C451.769 142.07 452.351 142.576 452.98 143.017C454.977 145.422 459.24 142.873 457.348 140.176C453.838 135.17 455.74 130.033 459.416 126.217C461.388 125.855 463.396 125.733 465.397 125.854C465.651 125.87 465.914 125.892 466.184 125.916C466.202 125.923 466.219 125.929 466.237 125.936C467.495 126.406 468.632 127.149 469.568 128.111C470.504 129.074 471.216 130.232 471.65 131.502C471.539 131.965 471.581 132.452 471.77 132.889C471.082 135.304 474.942 137.192 476.686 134.728C478.716 131.833 479.813 128.386 479.83 124.85C479.847 121.314 478.784 117.857 476.782 114.942Z"
      fill="#E5E6E7"
    />
    <path
      d="M577.772 167.039C577.772 167.039 566.576 170.317 563.395 181.518C560.215 192.719 562.441 200.183 567.368 204.355C572.294 208.527 581.82 209.911 581.82 209.911C581.82 209.911 582.677 206.857 586.976 207.99C592.297 209.393 592.283 209.444 592.283 209.444C592.283 209.444 589.071 207.208 597.301 201.92C605.532 196.632 605.608 195.145 616.027 195.889C616.027 195.889 608.02 167.073 591.981 164.419C591.981 164.419 595.197 167.054 594.696 168.912C594.196 170.769 590.554 175.24 586.452 175.168C582.35 175.096 583.888 166.9 583.888 166.9L577.772 167.039Z"
      fill="#AFDDFF"
    />
    <path
      d="M520.96 163.35C522.603 164.206 546.459 176.632 563.62 199.453C571.498 209.93 574.169 209.405 574.169 209.405L577.774 217.352C577.774 217.352 571.757 232.49 570.302 235.105C569.362 236.795 569.546 239.037 572.223 240.261L591.565 249.104C592.564 250.99 594.044 252.577 595.855 253.705C598.736 255.401 607.636 260.045 611.367 260.344C615.098 260.642 618.833 261.525 623.145 257.174C627.457 252.823 631.031 247.152 631.031 247.152L629.196 261.783C629.196 261.783 622.278 262.876 620.12 264.606C617.963 266.335 610.127 267.281 595.409 265.943C580.691 264.606 579.601 262.086 579.601 262.086C579.016 260.728 578.02 259.588 576.754 258.825C574.333 257.471 571.622 256.715 568.849 256.621C568.849 256.621 557.728 256.332 548.739 258.448C539.751 260.563 536.633 262.565 536.633 262.565C536.633 262.565 538.039 261.961 532.452 252.059C526.865 242.156 512.45 215.547 512.45 215.547L513.643 211.408C513.643 211.408 505.183 198.498 499.927 195.897C494.672 193.297 494.322 192.664 489.353 192.168C484.071 191.64 483.79 192.294 483.79 192.294L481.706 190.113C481.706 190.113 486.132 187.693 489.16 181.792C492.309 175.652 495.012 168.909 495.012 168.909C495.012 168.909 495.461 150.067 520.96 163.35Z"
      fill="#F6BED7"
    />
    <path
      d="M602.94 228.034C599.117 219.999 596.294 213.424 596.294 213.424C596.294 213.424 587.136 209.193 585.256 209.407C583.376 209.621 571.924 234.66 571.753 236.241C571.583 237.822 594.054 250.47 594.054 250.47C594.054 250.47 601.533 250.174 603.204 247.665C604.874 245.156 606.763 236.069 602.94 228.034Z"
      fill="#D0D2D3"
    />
    <g opacity="0.24">
      <path
        d="M604.863 237.364C604.658 234.116 603.235 230.753 602.267 227.809C600.973 223.875 599.549 219.986 598.127 216.097C597.409 214.136 595.164 214.454 593.577 215.208C593.162 215.414 592.766 215.655 592.392 215.928C593.076 214.932 591.491 214.565 590.549 215.42C584.169 221.215 577.356 227.763 576.524 236.848C576.467 237.47 576.843 237.605 577.313 237.504C577.272 237.721 577.282 237.945 577.344 238.157C577.406 238.369 577.518 238.564 577.67 238.724C581.928 243.121 587.153 246.464 592.929 248.487C594.621 249.119 596.46 249.243 598.222 248.844C599.983 248.446 601.59 247.542 602.846 246.244C605.38 243.698 605.734 240.638 604.863 237.364ZM590.483 228.888C590.604 228.75 590.728 228.615 590.851 228.479C590.88 228.546 590.906 228.615 590.935 228.683L590.483 228.888ZM587.25 220.865C587.19 221.142 587.187 221.429 587.241 221.707C587.295 221.985 587.406 222.25 587.566 222.484C587.582 222.508 587.597 222.532 587.613 222.556C585.222 224.346 583.073 226.438 581.22 228.78C582.744 225.864 584.892 223.274 587.25 220.865Z"
        fill="#BBBDBF"
      />
    </g>
    <path
      d="M578.672 261.36C567.373 254.465 553.79 257.576 541.823 260.689C541.03 260.913 540.287 261.285 539.632 261.785C538.271 262.306 537.156 263.322 536.511 264.628C535.845 266.165 536.64 267.52 538.399 267.358C550.118 266.265 561.908 266.157 573.645 267.036C574.533 267.078 575.419 266.913 576.232 266.553C577.045 266.193 577.763 265.649 578.329 264.964C579.12 264.039 580.11 262.237 578.672 261.36Z"
      fill="#D0D2D3"
    />
    <path
      d="M520.51 172.567C520.51 172.567 550.529 186.166 574.539 224.191"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M521.195 172.295C521.195 172.295 486.583 164.133 502.618 182.682C519.453 202.158 557.268 256.697 557.268 256.697"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M560.977 68.4673C560.933 68.3457 560.888 68.224 560.844 68.1023C560.83 68.0597 560.802 68.0233 560.764 67.9995C560.725 67.9756 560.68 67.9657 560.636 67.9716C559.996 66.8987 559.281 65.8719 558.498 64.8987C558.477 64.8751 558.45 64.8573 558.42 64.8471C558.397 64.8166 558.375 64.7845 558.352 64.7542C555.146 59.1989 548.834 56.3009 542.4 57.3168C541.852 57.4052 541.335 57.6307 540.897 57.9723C540.736 57.7384 540.375 57.6286 539.736 57.7655C537.142 58.3233 534.751 59.5818 532.823 61.4041C532.543 61.522 532.29 61.6936 532.077 61.9092C531.398 62.5964 530.785 63.3453 530.245 64.1464C529.104 65.371 528.137 66.7462 527.37 68.2337C526.39 70.2573 526.15 72.4769 526.138 74.6974C526.112 79.5217 526.223 84.1543 525.55 88.8927C525.52 88.9877 525.494 89.0837 525.464 89.1787C525.444 89.2396 525.433 89.3029 525.431 89.3667C525.113 90.5885 524.751 91.7981 524.345 92.9954C524.251 93.273 524.509 93.3047 524.715 93.2169C527.288 92.1188 529.963 91.2766 532.701 90.7024C532.832 90.6654 532.945 90.5802 533.017 90.4638C536.721 89.6009 540.443 88.8153 544.182 88.1069C544.622 88.1835 545.068 88.2177 545.514 88.2092C546.285 88.1862 547.026 87.9028 547.615 87.4052C548.414 87.0687 549.122 86.2828 548.956 85.3638C548.923 85.1858 548.651 85.3879 548.614 85.4614C548.604 85.4812 548.591 85.4994 548.581 85.519C548.545 85.5185 548.509 85.524 548.475 85.5354C547.666 85.8013 546.791 85.7884 545.99 85.4987C545.974 85.4829 545.957 85.4691 545.938 85.4574C544.863 84.9078 544.028 83.9829 543.589 82.8582C543.573 82.829 543.55 82.8038 543.523 82.7844C543.496 82.765 543.465 82.7518 543.432 82.7459C543.417 82.7039 543.399 82.6635 543.385 82.6212C543.295 82.3349 542.803 82.5647 542.694 82.8146L542.571 82.8493C541.096 82.364 539.875 81.3128 539.175 79.9271C539.191 79.8595 539.197 79.7898 539.19 79.7205C539.073 78.6886 539.088 77.6458 539.236 76.6178C539.364 76.4645 539.456 76.2847 539.506 76.0915C539.563 76.0904 539.619 76.0726 539.666 76.0401C539.944 75.8478 540.222 75.6555 540.499 75.4633C540.537 75.4364 540.569 75.4019 540.592 75.362C541.105 75.2478 541.635 75.2411 542.15 75.3422C542.193 75.3421 542.236 75.3327 542.275 75.3146C542.314 75.2966 542.349 75.2705 542.377 75.2379C542.663 75.3973 542.928 75.5926 543.165 75.8191C543.711 76.3498 544.098 77.0745 544.876 77.2936C545.022 77.3045 545.166 77.2573 545.277 77.1623C545.279 77.1617 545.284 77.1617 545.286 77.1609C545.336 77.1459 545.383 77.119 545.42 77.0824C545.489 77.0179 545.539 76.9359 545.565 76.8451C545.59 76.7543 545.59 76.6583 545.565 76.5674C545.544 76.4894 545.502 76.4185 545.445 76.362C545.387 76.3056 545.315 76.2657 545.237 76.2466C545.124 75.4597 545.066 74.6657 545.066 73.8706L545.069 73.854C545.069 73.8523 545.068 73.8512 545.069 73.8495C545.098 73.8086 545.121 73.7642 545.139 73.7172C545.308 73.2465 545.477 72.7759 545.646 72.3052C545.68 72.2433 545.698 72.1741 545.699 72.1037C545.7 72.0332 545.684 71.9635 545.652 71.9005L545.701 71.8194C545.987 71.6647 546.274 71.5099 546.56 71.3552C546.965 71.1468 547.335 70.8756 547.655 70.5517C550.388 69.32 553.343 68.6583 556.34 68.607C556.383 68.6059 556.426 68.6024 556.469 68.5964C556.876 68.692 557.304 68.6258 557.664 68.4117C558.215 68.5159 558.766 68.6201 559.317 68.7242C559.388 68.7311 559.461 68.7228 559.529 68.6999C559.597 68.677 559.66 68.64 559.713 68.5913C559.733 68.5994 559.754 68.6046 559.775 68.6131C559.873 68.644 559.979 68.6375 560.073 68.5948C560.112 68.6615 560.154 68.7266 560.193 68.7937C560.205 68.8129 560.222 68.829 560.241 68.8405C560.261 68.8519 560.283 68.8586 560.306 68.8598C560.355 68.902 560.416 68.9271 560.48 68.9315C560.545 68.9359 560.609 68.9193 560.663 68.8841C560.778 68.8293 561.037 68.633 560.977 68.4673ZM531.236 73.4366C531.152 73.9846 531.091 74.5428 531.04 75.106C531.031 75.1103 531.023 75.1151 531.014 75.1194C531.113 73.9924 531.2 72.8575 531.282 71.711C531.507 68.5694 532.275 65.5885 534.041 63.4208C532.72 66.639 531.778 70.0003 531.236 73.4366V73.4366ZM539.424 61.5329C538.727 62.2795 538.118 63.1032 537.609 63.9881C537.591 64.0163 537.572 64.0441 537.556 64.0724C537.519 64.1362 537.49 64.2026 537.455 64.2668C537.415 64.3427 537.376 64.4192 537.337 64.4959C537.104 64.9396 536.899 65.398 536.725 65.8682C536.685 65.9283 536.649 65.9899 536.61 66.0505C537.237 63.4659 538.246 61.3443 539.915 61.125C539.737 61.2424 539.572 61.3792 539.424 61.533V61.5329Z"
      fill="black"
    />
    <path
      d="M569.649 83.8808C569.642 83.8491 569.624 83.8209 569.598 83.801C569.587 83.7823 569.572 83.7664 569.554 83.7547C569.536 83.7429 569.516 83.7356 569.494 83.7334C569.323 83.7242 569.152 83.7149 568.981 83.7056C568.973 83.6769 568.956 83.6513 568.934 83.6318C568.911 83.6123 568.883 83.5997 568.854 83.5955C568.679 83.5722 568.504 83.5488 568.328 83.5255C565.98 82.4406 564.788 79.8259 563.801 77.5681C563.789 77.5452 563.771 77.5262 563.749 77.5136C563.11 75.4593 562.635 73.3578 562.328 71.2286C562.284 70.8909 561.579 71.2625 561.618 71.568C561.806 72.9406 562.075 74.3008 562.426 75.6409C562.366 75.6787 562.314 75.7281 562.274 75.7863C562.233 75.8445 562.204 75.9102 562.189 75.9796C562.183 76.3636 562.179 76.7533 562.18 77.1441C562.074 78.0357 561.786 78.9345 561.638 79.8119C561.596 79.852 561.561 79.8998 561.537 79.9527C561.429 80.2131 561.358 80.4873 561.325 80.7673C561.282 80.8073 561.248 80.8557 561.224 80.9095C561.199 80.9766 561.173 81.0451 561.147 81.1137C561.038 81.1094 560.929 81.1349 560.833 81.1875C560.738 81.2402 560.658 81.3179 560.603 81.4123C560.297 82.2374 559.97 83.1015 559.581 83.9331C559.436 84.0792 559.331 84.2599 559.275 84.4579C559.26 84.5165 559.244 84.5751 559.229 84.6337C558.794 85.4888 558.216 86.2625 557.518 86.9208C557.337 86.9859 557.168 87.0798 557.017 87.1987C556.636 87.27 556.257 87.3479 555.878 87.4325C555.783 87.4548 555.695 87.5019 555.624 87.5692C555.553 87.6364 555.5 87.7214 555.473 87.8154C555.468 87.8358 555.467 87.8571 555.471 87.8778C555.475 87.8985 555.483 87.9181 555.496 87.9354C555.508 87.9526 555.523 87.9671 555.541 87.9778C555.56 87.9885 555.58 87.9953 555.601 87.9976C555.585 88.0126 555.57 88.0285 555.557 88.0452C555.483 88.148 555.425 88.3747 555.62 88.3915C555.931 88.4182 556.242 88.4439 556.554 88.4686C556.869 88.5185 557.186 88.5534 557.502 88.588C559.924 89.1512 562.453 89.0447 564.819 88.2799C565.132 88.1843 565.442 88.0792 565.75 87.9645C565.797 87.9678 565.845 87.9644 565.891 87.9543C566.297 87.8688 566.703 87.7834 567.109 87.6979C567.211 87.669 567.303 87.6149 567.378 87.5408C567.432 87.4901 567.474 87.4284 567.502 87.3598C567.583 87.3392 567.658 87.3015 567.723 87.2492C567.788 87.197 567.842 87.1315 567.879 87.0571C567.945 86.9025 567.867 86.7689 567.69 86.7841C566.543 86.8742 565.398 86.5823 564.434 85.9538C563.469 85.3253 562.74 84.3956 562.359 83.3094C562.695 83.5771 563.087 83.7678 563.505 83.8679C564.05 84.204 564.629 84.48 565.233 84.6908C565.519 84.791 565.818 84.8437 566.121 84.8467C566.692 85.0271 567.303 85.0453 567.884 84.8992C567.984 84.8706 568.077 84.8177 568.152 84.7453C568.566 84.6533 568.964 84.5025 569.335 84.2975C569.47 84.2223 569.688 84.0654 569.649 83.8808Z"
      fill="black"
    />
    <path
      d="M543.639 123.531C543.639 123.531 540.39 119.611 532.529 118.312C527.584 117.519 522.583 117.132 517.574 117.154C517.574 117.154 519.356 102.34 529.254 97.5691C539.152 92.7985 551.218 92.4904 560.391 98.3452C569.565 104.2 571.926 116.606 571.926 116.606L574.169 125.605C574.169 125.605 571.451 132.611 570.944 134.844C570.438 137.076 570.335 136.469 570.335 136.469C570.335 136.469 566.439 136.138 564.918 138.012C563.397 139.886 560.953 143.118 561.59 146.416C562.226 149.714 563.397 148.944 563.397 148.944C563.397 148.944 563.347 155.88 565.135 158.609C566.924 161.338 569.843 164.859 573.149 165.939L576.455 167.019L570.335 172.567L560.039 151.654L558.252 148.494C558.252 148.494 561.985 135.346 561.787 131.634C561.59 127.922 561.064 125.995 559.262 127.537C557.355 129.171 554.762 136.653 554.113 138.012C553.464 139.372 550.903 143.817 550.903 143.817L548.89 143.239C548.89 143.239 548.776 141.055 547.527 142.008C546.277 142.961 544.823 145.282 544.823 145.282C544.823 145.282 544.612 142.314 543.717 142.424C542.822 142.535 540.02 145.282 540.02 145.282C540.02 145.282 540.627 142.008 537.436 143.667C535.917 144.457 543.639 123.531 543.639 123.531Z"
      fill="black"
    />
    <path
      d="M132.278 270.979C132.278 270.979 157.612 220.682 164.548 214.571C172.164 207.86 189.735 210.101 201.325 224.05C212.916 238 213.856 234.916 213.856 234.916C213.856 234.916 212.001 249.626 194.897 253.637C177.792 257.648 183.173 256.053 183.173 256.053C183.173 256.053 190.069 266.123 194.16 269.128C198.251 272.132 196.129 270.979 196.129 270.979H132.278Z"
      fill="black"
    />
    <path
      d="M136.658 164.362C136.658 164.362 155.154 168.54 160.658 186.91C160.312 187.648 159.883 188.343 159.378 188.983C158.743 189.8 158.094 190.521 154.24 195.33C150.386 200.139 126.805 230.499 126.805 230.499H102.897C102.897 230.499 100.435 229.368 102.098 226.385C103.761 223.403 117.288 200.349 117.288 200.349C117.288 200.349 115.753 195.283 114.033 193.403C112.313 191.523 110.18 176.976 115.529 176.805C120.877 176.634 125.874 166.792 125.874 166.792C125.874 166.792 129.936 170.823 133.867 170.31C137.798 169.798 136.922 168.304 136.658 164.362Z"
      fill="#F04B2D"
    />
    <path
      d="M167.151 122.533C167.151 122.533 181.895 109.161 193.288 113.323L195.602 107.413C195.602 107.413 187.878 91.7723 182.322 88.1841C176.767 84.5959 165.512 83.707 165.512 83.707C165.512 83.707 164.968 88.0618 160.42 89.0849C155.873 90.108 154.247 89.0351 154.284 87.1403C154.321 85.2456 154.284 84.3395 154.284 84.3395C154.284 84.3395 148.719 84.184 146.086 86.1935C143.453 88.203 140.106 92.0308 140.106 92.0308C140.106 92.0308 142.833 92.6447 143.841 95.1579C144.848 97.671 145.798 98.7183 145.798 98.7183L159.253 108.311C159.253 108.311 166.379 115.093 167.151 122.533Z"
      fill="#AFDDFF"
    />
    <path
      d="M198.662 205.876C198.177 205.779 197.702 206.151 197.409 206.487C197.54 206.337 197.353 206.545 197.307 206.592C197.225 206.677 197.141 206.76 197.054 206.841C196.977 206.912 196.899 206.982 196.819 207.051C196.811 207.058 196.782 207.082 196.759 207.1L196.722 207.129C196.544 207.265 196.361 207.393 196.172 207.512C196.161 207.519 196.138 207.537 196.114 207.554C196.098 207.561 196.081 207.569 196.066 207.578C195.962 207.635 195.858 207.691 195.752 207.744C195.567 207.837 195.377 207.917 195.186 207.997C195.136 208.013 195.087 208.032 195.038 208.049C194.926 208.086 194.813 208.121 194.699 208.154C194.507 208.208 194.311 208.254 194.115 208.292C194.092 208.296 194.06 208.301 194.034 208.305C193.982 208.313 193.93 208.32 193.878 208.327C193.761 208.342 193.643 208.353 193.525 208.363C193.278 208.391 193.042 208.479 192.837 208.621C192.633 208.762 192.467 208.952 192.354 209.173C192.305 209.248 192.28 209.335 192.282 209.424C192.283 209.513 192.311 209.6 192.361 209.673C192.412 209.746 192.483 209.802 192.566 209.835C192.648 209.867 192.739 209.875 192.826 209.856C195.153 209.635 197.303 208.518 198.821 206.742C199.064 206.464 199.095 205.962 198.662 205.876Z"
      fill="black"
    />
    <path
      d="M23.8333 81.3902C23.8333 81.3902 35.6631 87.8603 47.4197 83.7072C47.4197 83.7072 47.1645 97.6166 46.7246 101.109C46.2847 104.601 44.4458 117.324 40.0861 120.8L35.7264 124.277C35.7264 124.277 41.1891 120.801 48.8154 124.277C56.4418 127.752 61.0565 128.287 67.5513 127.165C74.0461 126.043 78.7155 126.076 80.3868 124.019C82.0581 121.962 82.3076 113.293 81.3101 109.161C80.3125 105.029 75.4134 79.385 75.4134 79.385L83.1624 73.967C83.1624 73.967 79.0154 62.1808 71.9343 58.3737C64.8533 54.5666 58.7367 50.504 45.0269 50.672C31.3171 50.8401 23.1862 64.4255 23.8333 81.3902Z"
      fill="#15A97D"
    />
    <path
      d="M90.7525 264.824C90.6079 263.175 90.3354 261.527 90.1277 259.885C90.1109 259.714 90.0488 259.551 89.9479 259.413C89.9697 256.349 89.2762 253.058 88.6938 250.321C88.4709 249.273 87.0078 249.467 86.3199 249.857C80.1908 253.326 72.5325 252.051 67.3864 247.397C66.2992 246.414 63.6147 248.425 63.5616 249.634C63.4305 252.618 64.1637 255.528 66.0606 257.892C66.3095 258.203 67.5076 259.164 68.2935 259.959C67.424 260.437 66.6107 261.011 65.8687 261.67C65.3222 261.717 64.7736 261.735 64.2253 261.722C63.6495 261.712 62.7717 262.26 62.1133 262.931C61.6729 262.929 61.2387 263.035 60.8487 263.24C60.5591 263.397 60.2669 263.549 59.9758 263.703C59.8371 263.601 59.676 263.534 59.506 263.508C59.336 263.482 59.1622 263.497 58.9994 263.553C51.3093 265.693 43.202 265.847 35.4361 264.001C35.2039 263.98 34.9698 264.005 34.7473 264.075C34.5248 264.144 34.3182 264.257 34.1393 264.407C33.4208 264.47 32.4248 264.989 32.1582 265.591C31.5639 267.015 30.6506 268.284 29.4886 269.3C28.3265 270.316 26.9469 271.051 25.4558 271.45C23.5597 271.933 20.8111 271.765 19.9758 274.044C18.4213 278.285 29.2164 278.193 31.3941 278.166C40.3075 278.002 48.8919 274.771 55.7016 269.018C56.4789 268.661 57.2515 268.294 58.0194 267.914C65.3172 267.796 72.6214 267.733 79.9173 267.534C80.0765 267.646 80.2553 267.729 80.4446 267.776C83.2613 268.557 87.0784 270.54 89.5913 268.116C90.0367 267.702 90.375 267.187 90.5773 266.613C90.7796 266.04 90.8397 265.426 90.7525 264.824ZM32.8648 269.598C32.3948 269.952 31.9952 270.39 31.6868 270.891C31.1965 270.987 30.7033 271.075 30.2071 271.153C31.861 269.894 33.2342 268.303 34.2389 266.484C35.2186 266.702 36.2029 266.881 37.1892 267.038C35.6354 267.686 34.1799 268.547 32.8648 269.598ZM42.7506 270.107C43.1754 269.884 43.5972 269.654 44.0159 269.416C44.1923 269.397 44.3687 269.379 44.5451 269.36C43.9513 269.622 43.3541 269.874 42.7506 270.107H42.7506Z"
      fill="#15A97D"
    />
    <path
      d="M84.9844 29.212C87.1887 29.1391 89.3929 29.1076 91.5971 29.0543L98.2098 28.9643C102.618 28.9051 107.027 28.8968 111.435 28.8887C115.844 28.8959 120.252 28.9045 124.66 28.9631L131.273 29.0534C133.477 29.1071 135.682 29.1386 137.886 29.212C135.682 29.2853 133.477 29.3168 131.273 29.3705L124.66 29.4608C120.252 29.5194 115.844 29.528 111.435 29.5353C107.027 29.5271 102.618 29.5188 98.2098 29.4597L91.5971 29.3696C89.3929 29.3163 87.1887 29.2848 84.9844 29.212Z"
      fill="black"
    />
    <path
      d="M119.446 28.8866C119.447 29.0355 119.443 29.1849 119.434 29.3349C119.211 32.8958 115.966 36.0046 112.399 36.0745C106.277 36.1944 102.927 28.5232 107.035 24.0371C111.338 19.3378 119.404 22.5653 119.446 28.8866Z"
      fill="#0FCCCE"
    />
    <path
      d="M537.065 261.841C537.065 261.841 559.565 251.853 576.37 257.989C581.859 259.994 535.689 214.406 530.562 206.442C525.434 198.477 530.562 199.454 530.562 199.454"
      stroke="#231F20"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M272.363 102.912L263.369 93.2225C262.364 92.1399 261.594 90.8607 261.108 89.4656C260.623 88.0706 260.431 86.59 260.546 85.1173C260.662 83.6446 261.081 82.2117 261.778 80.9091C262.474 79.6066 263.433 78.4626 264.595 77.5493L306.991 45.4964C308.187 44.556 309.57 43.8816 311.047 43.5183C312.524 43.155 314.062 43.1112 315.557 43.3898C317.052 43.6683 318.471 44.2629 319.718 45.1337C320.966 46.0045 322.013 47.1315 322.79 48.4393L345.649 84.6363C346.96 86.8436 347.433 89.449 346.981 91.9761C346.529 94.5033 345.183 96.7834 343.188 98.3996L308.139 126.798C306.034 128.504 303.358 129.347 300.654 129.155C297.95 128.963 295.421 127.751 293.577 125.765L288.576 120.378"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M307.288 50.0058C308.29 49.2702 309.447 48.7737 310.67 48.5542C311.283 48.4666 311.901 48.4291 312.52 48.4419C313.136 48.4363 313.752 48.4723 314.364 48.5496C315.607 48.7283 316.783 49.2234 317.779 49.9873C318.753 50.7618 319.555 51.7305 320.134 52.8318C320.136 52.8362 320.137 52.8414 320.136 52.8462C320.134 52.8511 320.131 52.8553 320.127 52.8581C320.123 52.8608 320.118 52.862 320.113 52.8612C320.108 52.8605 320.104 52.858 320.1 52.8541C319.344 51.9128 318.478 51.0654 317.52 50.33C317.045 49.9703 316.537 49.6564 316.003 49.3924C315.462 49.134 314.899 48.9244 314.321 48.766C313.734 48.6159 313.128 48.5507 312.522 48.5725C311.919 48.6135 311.321 48.7173 310.739 48.8825C309.563 49.1639 308.415 49.5512 307.309 50.0399C307.307 50.0411 307.304 50.0419 307.302 50.0421C307.299 50.0424 307.296 50.0421 307.294 50.0413C307.291 50.0406 307.289 50.0393 307.287 50.0376C307.285 50.0359 307.283 50.0338 307.282 50.0315C307.28 50.0272 307.279 50.0223 307.28 50.0177C307.281 50.013 307.284 50.0089 307.288 50.0058Z"
      fill="black"
    />
    <path
      d="M322.466 56.1758C324.092 58.5233 325.681 60.8949 327.264 63.2702L331.971 70.423L336.601 77.6267L338.888 81.2466C339.638 82.4613 340.399 83.6684 341.139 84.8897C340.323 83.7182 339.528 82.5325 338.722 81.3543L336.341 77.7957L331.634 70.6425L327.005 63.4384C325.476 61.0279 323.953 58.6139 322.466 56.1758Z"
      fill="black"
    />
    <path
      d="M344.11 82.6964C344.046 82.6063 343.975 82.5216 343.898 82.4432C342.873 80.1391 341.236 78.0705 339.516 76.2062C336.336 72.7596 333.744 69.4239 331.853 65.0947C328.632 57.7218 325.821 49.0236 317.391 46.1657C308.378 43.1101 300.857 50.4147 295.634 56.7611C292.771 60.2396 289.731 63.5326 286.141 66.2824C282.394 69.1521 278.392 71.156 274.218 73.2922C272.285 74.2577 270.524 75.5333 269.004 77.0684C267.841 77.5677 266.791 78.2965 265.916 79.2114C265.041 80.1263 264.359 81.2083 263.912 82.3927C262.774 85.6395 264.245 88.547 266.035 91.2103C266.207 91.4707 266.442 91.6841 266.718 91.8314C267.29 92.6127 267.961 93.3166 268.714 93.9258C269.391 94.471 270.123 94.9431 270.899 95.3344C271.796 96.9082 272.875 98.3706 274.115 99.6914C275.463 101.129 277.846 100.304 279.228 99.2934C279.281 99.2547 279.344 99.204 279.406 99.1555C279.712 99.2216 280.026 99.2449 280.338 99.2245C281.773 99.1404 283.201 99.4807 284.443 100.203L285.596 101.552C285.693 101.663 285.8 101.764 285.918 101.853C286.966 103.809 288.015 105.765 289.064 107.722C289.293 111.034 288.802 114.397 289.496 117.677C290.294 121.448 292.422 124.734 296.309 125.767C296.852 125.911 297.406 126.007 297.966 126.056C300.811 127.61 304.169 126.924 306.91 125.445C309.636 123.974 311.502 121.71 313.452 119.438C314.819 119.132 316.078 118.462 317.096 117.5C320.126 114.575 323.353 111.86 326.754 109.374C330.06 106.974 333.654 104.993 336.933 102.561C342.687 98.2939 349.197 89.8957 344.11 82.6964ZM283.462 74.3488C283.421 74.5916 283.409 74.8385 283.426 75.0842C283.363 75.0433 283.302 75.0007 283.239 74.96C283.104 74.8742 282.963 74.7999 282.815 74.7379C283.032 74.6094 283.247 74.4797 283.462 74.3488ZM282.395 91.0379C282.574 90.8805 282.742 90.7172 282.899 90.5517C283.129 90.8028 283.356 91.0565 283.581 91.3128C283.186 91.2219 282.79 91.1303 282.395 91.0379ZM295.612 66.465C295.05 67.0801 294.488 67.6951 293.926 68.3101C293.402 68.2395 292.876 68.1881 292.35 68.1595C292.252 68.1541 292.155 68.1537 292.058 68.1517C293.444 66.9746 294.776 65.7396 296.054 64.4468C295.878 65.1084 295.732 65.7818 295.612 66.465H295.612ZM310.953 52.2013C311.221 52.2548 311.481 52.3211 311.737 52.3936C310.013 52.2222 308.274 52.4377 306.644 53.0246C307.267 52.5982 307.971 52.3049 308.713 52.1633C309.454 52.0216 310.217 52.0346 310.953 52.2013ZM312.354 70.5388C309.724 71.8794 308.797 78.1208 310.228 88.5786C312.055 101.929 310.611 109.937 305.355 113.12C304.67 113.534 303.849 113.658 303.072 113.467C302.294 113.275 301.625 112.783 301.21 112.099C300.795 111.414 300.669 110.593 300.859 109.815C301.049 109.038 301.539 108.367 302.223 107.951C304.818 106.379 305.69 99.9399 304.246 89.3885C302.408 75.9525 303.998 68.0144 309.607 65.1556C310.32 64.7913 311.15 64.7254 311.912 64.9726C312.675 65.2197 313.308 65.7596 313.672 66.4735C314.036 67.1873 314.102 68.0167 313.855 68.7791C313.608 69.5414 313.068 70.1744 312.354 70.5388ZM315.377 107.642C315.45 107.037 315.475 106.428 315.45 105.82C316.283 105.756 317.108 105.612 317.913 105.391C317.048 106.118 316.203 106.868 315.377 107.642ZM335.373 94.097C334.917 94.4866 334.434 94.8435 333.927 95.165C335.541 92.4913 336.416 89.5312 336.119 86.4354C337.442 89.0804 337.619 92.1385 335.373 94.097Z"
      fill="#0FCCCE"
    />
    <path
      d="M309.606 65.1545C310.32 64.7902 311.149 64.7243 311.912 64.9715C312.674 65.2186 313.307 65.7585 313.671 66.4724C314.036 67.1862 314.102 68.0156 313.854 68.778C313.607 69.5404 313.067 70.1734 312.353 70.5377C309.724 71.8784 308.796 78.1197 310.227 88.5775C312.054 101.928 310.61 109.936 305.355 113.119C304.67 113.532 303.848 113.657 303.071 113.466C302.294 113.274 301.624 112.782 301.209 112.098C300.795 111.413 300.668 110.592 300.858 109.814C301.048 109.037 301.539 108.366 302.223 107.95C304.818 106.378 305.69 99.9388 304.246 89.3875C302.407 75.9515 303.998 68.0134 309.606 65.1545Z"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M102.419 94.4731C103.525 95.6914 104.918 96.6142 106.471 97.1579C108.023 97.7016 109.687 97.849 111.312 97.5867C112.936 97.3244 114.469 96.6607 115.772 95.6558C117.075 94.6509 118.106 93.3366 118.772 91.8322C119.438 90.3278 119.718 88.6809 119.587 87.0409C119.455 85.4009 118.916 83.8196 118.018 82.4407C117.121 81.0617 115.893 79.9287 114.447 79.1444C113.001 78.36 111.382 77.9492 109.736 77.9492L102.419 94.4731Z"
      fill="#0FCACC"
    />
    <path
      d="M109.219 81.0498C109.679 81.0498 110.051 80.6773 110.051 80.2178C110.051 79.7583 109.679 79.3857 109.219 79.3857C108.76 79.3857 108.387 79.7583 108.387 80.2178C108.387 80.6773 108.76 81.0498 109.219 81.0498Z"
      fill="white"
    />
    <path
      d="M110.052 80.2156C110.051 80.4436 109.966 80.6632 109.812 80.8314C109.658 80.9995 109.447 81.1041 109.219 81.1246C109.094 81.1352 108.967 81.1195 108.847 81.0786C108.728 81.0378 108.618 80.9725 108.525 80.8871C108.432 80.8016 108.358 80.6977 108.307 80.5821C108.257 80.4665 108.23 80.3416 108.23 80.2153C108.23 80.089 108.257 79.9641 108.307 79.8484C108.358 79.7328 108.432 79.6289 108.525 79.5435C108.618 79.458 108.728 79.3928 108.847 79.3519C108.967 79.311 109.094 79.2954 109.219 79.306C109.447 79.3266 109.658 79.4313 109.812 79.5996C109.966 79.7679 110.051 79.9876 110.052 80.2156ZM110.052 80.2156C110.052 80.1097 110.03 80.0048 109.988 79.9078C109.945 79.8108 109.882 79.7239 109.804 79.6527C109.725 79.5816 109.633 79.5277 109.532 79.4947C109.431 79.4617 109.325 79.4503 109.219 79.4612C109.033 79.4813 108.861 79.5695 108.736 79.7088C108.611 79.8482 108.542 80.0288 108.542 80.216C108.542 80.4032 108.611 80.5838 108.736 80.7231C108.861 80.8625 109.033 80.9506 109.219 80.9708C109.325 80.9816 109.431 80.9701 109.532 80.937C109.633 80.9039 109.725 80.85 109.804 80.7788C109.882 80.7075 109.945 80.6206 109.988 80.5235C110.03 80.4265 110.052 80.3216 110.052 80.2156V80.2156Z"
      fill="white"
    />
    <path
      d="M103.536 93.49C103.675 93.49 103.788 93.3768 103.788 93.2372C103.788 93.0976 103.675 92.9844 103.536 92.9844C103.396 92.9844 103.283 93.0976 103.283 93.2372C103.283 93.3768 103.396 93.49 103.536 93.49Z"
      fill="white"
    />
    <path
      d="M103.789 93.2357C103.79 93.3111 103.766 93.3848 103.72 93.4446C103.674 93.5045 103.609 93.5471 103.536 93.5654C103.489 93.5754 103.441 93.5755 103.394 93.5657C103.347 93.5558 103.302 93.5363 103.264 93.5082C103.222 93.4761 103.188 93.4348 103.164 93.3876C103.141 93.3403 103.129 93.2883 103.129 93.2355C103.129 93.1828 103.141 93.1308 103.164 93.0835C103.187 93.0362 103.221 92.9948 103.263 92.9627C103.302 92.9344 103.346 92.9147 103.393 92.9048C103.441 92.8949 103.489 92.895 103.536 92.9052C103.609 92.9237 103.674 92.9664 103.72 93.0264C103.766 93.0864 103.79 93.1601 103.789 93.2357ZM103.789 93.2357C103.788 93.2032 103.78 93.1714 103.764 93.1429C103.749 93.1144 103.727 93.0902 103.7 93.0722C103.675 93.058 103.647 93.0495 103.619 93.0475C103.591 93.0454 103.562 93.0499 103.536 93.0605C103.506 93.0789 103.481 93.1047 103.464 93.1354C103.447 93.1661 103.438 93.2008 103.438 93.236C103.438 93.2713 103.447 93.3059 103.464 93.3367C103.481 93.3674 103.506 93.3932 103.536 93.4116C103.562 93.4221 103.591 93.4265 103.619 93.4244C103.648 93.4222 103.675 93.4136 103.7 93.3993C103.727 93.3813 103.749 93.357 103.764 93.3285C103.78 93.3 103.788 93.2681 103.789 93.2357Z"
      fill="white"
    />
    <path
      d="M111.046 94.4366C112.168 94.4366 113.078 93.5267 113.078 92.4043C113.078 91.282 112.168 90.3721 111.046 90.3721C109.924 90.3721 109.014 91.282 109.014 92.4043C109.014 93.5267 109.924 94.4366 111.046 94.4366Z"
      fill="white"
    />
    <path
      d="M113.079 92.4053C113.079 92.9514 112.867 93.476 112.488 93.8693C112.109 94.2625 111.593 94.4937 111.047 94.5145C110.763 94.525 110.481 94.4782 110.215 94.377C109.95 94.2757 109.708 94.122 109.504 93.9251C109.3 93.7281 109.137 93.492 109.026 93.2308C108.915 92.9696 108.858 92.6888 108.858 92.405C108.858 92.1211 108.915 91.8402 109.026 91.5791C109.137 91.3179 109.3 91.0818 109.504 90.8848C109.708 90.6879 109.95 90.5342 110.215 90.4329C110.481 90.3317 110.763 90.2849 111.047 90.2954C111.593 90.3163 112.109 90.5477 112.488 90.9411C112.867 91.3344 113.079 91.8592 113.079 92.4053ZM113.079 92.4053C113.08 92.1419 113.027 91.8811 112.924 91.6387C112.821 91.3962 112.67 91.1771 112.48 90.9945C112.29 90.8119 112.065 90.6696 111.819 90.5761C111.573 90.4827 111.31 90.44 111.047 90.4507C110.542 90.4713 110.065 90.6862 109.715 91.0506C109.365 91.415 109.17 91.9006 109.17 92.4057C109.17 92.9108 109.365 93.3964 109.715 93.7607C110.065 94.1251 110.542 94.3401 111.047 94.3607C111.31 94.3713 111.573 94.3285 111.819 94.235C112.065 94.1415 112.29 93.9991 112.48 93.8164C112.67 93.6337 112.821 93.4146 112.924 93.1721C113.027 92.9296 113.08 92.6688 113.079 92.4053Z"
      fill="white"
    />
    <path
      d="M116.262 86.7951C116.834 86.7951 117.298 86.3314 117.298 85.7594C117.298 85.1874 116.834 84.7236 116.262 84.7236C115.69 84.7236 115.226 85.1874 115.226 85.7594C115.226 86.3314 115.69 86.7951 116.262 86.7951Z"
      fill="white"
    />
    <path
      d="M117.298 85.7606C117.297 86.0424 117.19 86.3136 116.998 86.5199C116.806 86.7262 116.543 86.8524 116.262 86.8732C116.11 86.8838 115.956 86.8629 115.812 86.8117C115.668 86.7605 115.536 86.6803 115.424 86.5759C115.312 86.4715 115.223 86.3452 115.162 86.2049C115.101 86.0646 115.07 85.9132 115.07 85.7602C115.07 85.6072 115.101 85.4559 115.162 85.3155C115.223 85.1752 115.312 85.0489 115.424 84.9445C115.536 84.8402 115.668 84.7599 115.812 84.7087C115.956 84.6576 116.11 84.6366 116.262 84.6472C116.543 84.6682 116.806 84.7946 116.998 85.001C117.19 85.2074 117.297 85.4787 117.298 85.7606ZM117.298 85.7606C117.298 85.6279 117.271 85.4966 117.219 85.375C117.166 85.2533 117.088 85.144 116.991 85.0539C116.893 84.9638 116.778 84.8949 116.653 84.8517C116.527 84.8084 116.394 84.7916 116.262 84.8025C116.022 84.8226 115.798 84.9324 115.635 85.1099C115.471 85.2874 115.381 85.5198 115.381 85.7609C115.381 86.0021 115.471 86.2345 115.635 86.412C115.798 86.5895 116.022 86.6993 116.262 86.7194C116.394 86.7302 116.527 86.7133 116.653 86.67C116.778 86.6266 116.893 86.5577 116.991 86.4675C117.088 86.3774 117.166 86.268 117.219 86.1463C117.271 86.0246 117.298 85.8933 117.298 85.7606Z"
      fill="white"
    />
    <path
      d="M156.32 143.946L155.765 147.07C155.765 147.07 154.221 154.748 149.22 157.587C144.218 160.426 141.894 161.703 138.823 161.594L135.752 161.486C135.752 161.486 134.208 164.362 136.658 164.362C138.73 164.362 148.636 167.597 152.487 172.174C156.338 176.751 159.226 180.967 159.944 184.794C159.944 184.794 160.515 179.701 160.682 178C160.848 176.299 160.657 172.788 163.011 170.993C165.04 169.445 165.318 169.903 165.318 169.903L168.885 148.7C168.885 148.7 164.03 151.571 161.103 149.075C159.355 147.516 157.754 145.799 156.32 143.946Z"
      fill="#AFDDFF"
    />
    <path
      d="M114.214 60.2412H129.085C130.482 60.2412 131.821 60.796 132.809 61.7836C133.797 62.7712 134.351 64.1107 134.351 65.5074V89.1627"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M76.8592 63.2154C77.5007 61.0307 79.5204 60.2412 81.9127 60.2412H89.508"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M122.537 109.271H93.2021"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M457.954 160.429C457.954 160.429 442.298 181.283 449 204.938"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M452.685 139.03L458.572 156.024C459.45 158.558 461.298 160.64 463.711 161.811C466.123 162.982 468.902 163.146 471.436 162.269V162.269C473.97 161.391 476.051 159.542 477.222 157.13C478.393 154.718 478.558 151.939 477.68 149.405L471.793 132.411C471.358 131.156 470.681 129.999 469.799 129.006C468.918 128.014 467.849 127.204 466.654 126.624C465.46 126.045 464.163 125.706 462.837 125.627C461.512 125.549 460.184 125.732 458.929 126.166V126.166"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M457.432 126.833C457.432 126.833 456.174 124.962 457.768 121.244"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M452.685 139.031C452.098 137.339 451.971 135.52 452.318 133.763C452.665 132.005 453.472 130.371 454.658 129.028"
      stroke="black"
      strokeWidth="0.144286"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M306.192 252.241C277.587 240.596 267.218 212.041 269.083 182.028C269.913 168.665 274.828 156.134 279.608 143.779C283.014 134.976 287.92 126.435 289.196 116.947C290.236 109.216 287.371 96.0783 277.023 100.006C270.094 102.636 264.398 110.034 260.279 115.912C253.386 125.747 249.123 137.117 244.592 148.153C234.461 172.83 230.834 201.048 242.237 226.271C252.947 249.96 269.07 264.485 291.879 277.389"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M318.84 193.165C318.84 193.165 319.749 170.347 354.742 160.641C389.735 150.936 406.55 167.75 406.55 167.75C406.55 167.75 395.643 195.017 367.921 202.289C340.2 209.56 318.84 193.165 318.84 193.165Z"
      stroke="black"
      strokeWidth="0.577143"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M442.409 219.98C442.409 219.98 458.128 236.707 459.667 246.962C461.205 257.217 457.24 275.35 457.24 275.35"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M367.416 203.522C373.673 202.144 376.602 191.295 373.959 179.289C371.315 167.284 364.099 158.668 357.842 160.046C351.585 161.424 348.656 172.273 351.3 184.279C353.944 196.285 361.159 204.9 367.416 203.522Z"
      stroke="black"
      strokeWidth="0.577143"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M365.15 163.449C364.823 163.101 364.397 162.861 363.929 162.761C363.296 162.07 362.622 161.419 361.909 160.812C361.559 160.528 361.126 160.367 360.676 160.354C359.677 159.965 358.203 160.364 357.328 160.728C355.804 161.329 354.462 162.314 353.431 163.587C352.401 164.86 351.717 166.378 351.447 167.993C351.153 168.477 351.019 169.041 351.063 169.605C351.15 170.351 351.252 171.094 351.365 171.835C350.57 178.484 352.121 185.202 355.751 190.828C357.38 194.849 359.566 198.62 362.247 202.03C363.264 203.322 365.373 202.928 367.124 201.865C368.403 202.11 370.099 201.312 370.983 200.713C372.325 199.802 373.445 198.454 373.419 196.799C373.406 196.013 373.373 195.229 373.33 194.445C375.948 183.613 372.894 171.649 365.15 163.449Z"
      fill="black"
    />
    <path
      d="M355.774 231.774C355.774 231.774 362.953 246.131 381.668 239.465C400.383 232.799 396.281 219.98 396.281 219.98"
      stroke="black"
      strokeWidth="0.577143"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M376.21 240.858C376.227 240.85 376.262 240.88 376.259 240.887L376.263 240.897L376.268 240.915L376.275 240.945L376.284 241.001L376.3 241.113L376.326 241.334C376.343 241.482 376.351 241.629 376.363 241.776L376.424 242.661C376.465 243.25 376.484 243.84 376.507 244.429C376.545 245.608 376.564 246.787 376.564 247.966L376.217 247.614C377.27 247.601 378.322 247.588 379.375 247.618C379.901 247.625 380.428 247.655 380.954 247.676L382.533 247.745L382.318 247.983C382.279 247.272 382.238 246.561 382.18 245.851C382.121 245.142 382.055 244.433 381.975 243.726C381.821 242.311 381.614 240.902 381.415 239.492C381.406 239.433 381.419 239.373 381.45 239.323C381.481 239.273 381.529 239.236 381.586 239.217C381.642 239.199 381.703 239.201 381.758 239.223C381.813 239.245 381.858 239.286 381.886 239.338L381.896 239.357C382.207 239.946 382.518 240.535 382.817 241.13C383.117 241.724 383.425 242.315 383.717 242.913L385.484 246.495L384.856 246.325C385.581 245.829 386.305 245.331 387.041 244.85C387.771 244.362 388.507 243.881 389.247 243.407L389.15 243.923C388.507 242.937 387.875 241.943 387.254 240.941C386.945 240.439 386.625 239.944 386.325 239.437C386.023 238.93 385.714 238.428 385.421 237.915C385.416 237.906 385.415 237.896 385.417 237.886C385.419 237.876 385.425 237.867 385.433 237.862C385.442 237.856 385.452 237.853 385.462 237.855C385.472 237.856 385.481 237.862 385.488 237.869C385.861 238.327 386.22 238.795 386.584 239.258C386.951 239.721 387.298 240.196 387.656 240.665C388.37 241.602 389.072 242.549 389.76 243.504C389.817 243.581 389.84 243.678 389.825 243.773C389.809 243.867 389.757 243.952 389.68 244.008L389.679 244.009L389.664 244.02C388.95 244.533 388.233 245.041 387.512 245.543C386.795 246.05 386.066 246.541 385.338 247.034L385.332 247.038C385.286 247.069 385.234 247.09 385.18 247.102C385.126 247.113 385.069 247.113 385.015 247.103C384.96 247.092 384.908 247.071 384.862 247.04C384.815 247.01 384.775 246.97 384.744 246.924C384.731 246.905 384.72 246.884 384.71 246.863L383.046 243.232C382.767 242.628 382.503 242.016 382.232 241.408C381.959 240.801 381.698 240.188 381.438 239.575L381.919 239.44C382.008 240.862 382.09 242.284 382.225 243.701C382.289 244.409 382.368 245.117 382.453 245.823C382.539 246.53 382.643 247.234 382.748 247.939C382.752 247.966 382.751 247.993 382.744 248.02C382.738 248.046 382.726 248.071 382.71 248.093C382.694 248.115 382.673 248.133 382.65 248.147C382.627 248.161 382.601 248.17 382.574 248.174L382.553 248.176L382.533 248.177L380.954 248.246C380.428 248.267 379.901 248.297 379.375 248.304C378.322 248.334 377.27 248.321 376.217 248.308L376.209 248.308C376.164 248.308 376.119 248.298 376.078 248.281C376.036 248.263 375.999 248.237 375.967 248.205C375.936 248.172 375.911 248.134 375.894 248.092C375.877 248.051 375.869 248.006 375.87 247.961L375.87 247.956C375.899 246.78 375.943 245.603 375.997 244.426C376.028 243.838 376.052 243.249 376.093 242.661L376.146 241.779L376.17 241.338L376.182 241.118L376.185 241.009L376.185 240.955L376.184 240.93L376.184 240.921L376.184 240.918C376.179 240.921 376.21 240.948 376.224 240.937C376.218 240.938 376.213 240.938 376.208 240.937C376.203 240.935 376.198 240.933 376.194 240.93C376.189 240.927 376.186 240.923 376.183 240.919C376.18 240.914 376.178 240.909 376.177 240.904C376.176 240.899 376.176 240.893 376.178 240.888C376.179 240.883 376.181 240.878 376.184 240.874C376.187 240.87 376.191 240.866 376.196 240.863C376.2 240.86 376.205 240.859 376.21 240.858H376.21Z"
      fill="black"
    />
    <path
      d="M289.315 150.01C289.315 150.01 279.392 170.14 284.519 189.624C289.647 209.108 291.879 209.489 291.879 209.489"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M392.21 67.7124C392.21 67.7124 365.449 86.6841 366.674 91.8116C367.849 96.7313 394.599 100.785 399.416 100.785C404.232 100.785 408.847 98.0928 407.693 90.7861C406.848 85.4327 403.732 73.6797 402.126 67.7786C401.957 67.1533 401.648 66.5746 401.223 66.0863C400.797 65.5981 400.266 65.2129 399.669 64.9601C399.073 64.7072 398.427 64.5933 397.78 64.6268C397.133 64.6604 396.502 64.8405 395.935 65.1537C394.625 65.9029 393.379 66.7587 392.21 67.7124Z"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M393.146 100.785C393.146 100.785 391.413 107 389.456 111.04C387.5 115.081 386.279 123.217 389.456 124.948C392.634 126.679 394.281 113.347 396.662 111.296C399.043 109.245 400.171 119.319 401.35 121.551C403.145 124.948 406.822 124.291 406.238 116.087C405.653 107.883 407.152 114.77 407.152 114.77"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M402.376 100.785C402.376 100.785 404.683 106.682 410.067 109.758C415.451 112.835 415.323 117.97 415.323 117.97"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M406.403 114.981C425.977 118.847 436.876 137.101 439.49 153.22C442.567 172.192 442.883 264.608 442.883 264.608"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M321.363 275.349C321.363 275.349 296.751 238.457 285.47 209.743C274.19 181.029 278.764 157.296 291.111 144.112C307.304 126.819 359.833 117.996 387.254 115.105"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M208.652 181.058C209.92 183.893 210.441 187.005 210.166 190.099C210.1 190.872 209.991 191.64 209.84 192.401C209.683 193.159 209.481 193.907 209.234 194.641C208.749 196.106 208.064 197.496 207.199 198.773C207.772 197.37 208.251 195.93 208.631 194.464C209 193.01 209.244 191.529 209.363 190.034C209.488 188.54 209.487 187.037 209.361 185.543C209.227 184.034 208.99 182.535 208.652 181.058Z"
      fill="black"
    />
    <path
      d="M164.679 75.9914C161.516 79.1522 157.312 81.0557 152.85 81.3474C148.388 81.639 143.972 80.2988 140.425 77.5765C136.878 74.8542 134.441 70.9353 133.568 66.5497C132.696 62.1642 133.447 57.611 135.682 53.7383"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M70.7499 30.2256C70.8226 30.8949 70.8589 31.5677 70.8588 32.241C70.8588 37.1293 68.9169 41.8175 65.4603 45.2741C62.0038 48.7307 57.3156 50.6726 52.4273 50.6726C46.5369 50.6726 41.7548 48.4737 38.3806 44.1729"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M156.129 141.744C156.164 142.212 156.182 142.684 156.182 143.161C156.18 145.998 155.523 148.796 154.264 151.338C153.004 153.879 151.175 156.096 148.919 157.816C146.663 159.536 144.041 160.712 141.256 161.254C138.472 161.795 135.6 161.687 132.864 160.938"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M560.867 68.9422C561.644 70.3963 562.143 71.9826 562.339 73.6198C562.391 74.0299 562.423 74.4427 562.44 74.8561C562.463 75.27 562.42 75.6832 562.412 76.0973L562.386 76.7184C562.372 76.9249 562.326 77.1284 562.298 77.3335C562.231 77.7422 562.174 78.1535 562.072 78.5544C561.638 80.1438 560.978 81.6628 560.113 83.0649C559.285 84.4785 558.277 85.7789 557.115 86.9334C555.956 88.1191 554.594 89.0878 553.094 89.7934C551.597 90.5268 549.987 91.0016 548.332 91.1978C545.019 91.5995 541.67 90.8363 538.859 89.0391C538.85 89.0335 538.844 89.025 538.842 89.0151C538.839 89.0053 538.84 88.9948 538.845 88.9859C538.85 88.977 538.858 88.9702 538.868 88.9669C538.877 88.9636 538.888 88.9641 538.897 88.9682C541.818 90.2886 545.05 90.7654 548.228 90.3447C551.392 89.9548 554.375 88.6568 556.817 86.6077C558.066 85.5912 559.108 84.3442 559.887 82.9345C560.087 82.5866 560.263 82.2246 560.411 81.8515L560.645 81.2982C560.722 81.1137 560.769 80.9171 560.833 80.7276C560.943 80.343 561.088 79.9708 561.172 79.5808L561.417 78.4136C561.497 78.0257 561.519 77.6272 561.587 77.2376C561.612 77.0413 561.654 76.847 561.665 76.6493L561.7 76.0565C561.767 75.2657 561.773 74.4709 561.718 73.6792C561.607 72.0784 561.296 70.4978 560.793 68.974C560.789 68.9644 560.79 68.9539 560.794 68.9447C560.798 68.9355 560.806 68.9282 560.815 68.9242C560.824 68.9202 560.835 68.9198 560.844 68.9232C560.854 68.9265 560.862 68.9333 560.867 68.9422V68.9422Z"
      fill="black"
    />
    <path
      d="M592.149 160.013C590.268 163.261 587.247 165.694 583.672 166.839C580.047 168.007 576.12 167.817 572.625 166.304C569.129 164.792 566.303 162.06 564.672 158.618C563.048 155.233 562.747 151.363 563.829 147.769C563.188 151.339 563.754 155.021 565.438 158.235C566.269 159.8 567.357 161.216 568.655 162.422C569.941 163.635 571.431 164.611 573.056 165.305C574.678 166.004 576.408 166.418 578.17 166.532C579.939 166.671 581.718 166.499 583.427 166.022C586.919 165.038 589.986 162.925 592.149 160.013Z"
      fill="black"
    />
    <path
      d="M196.128 189.592C196.525 189.899 197.64 191.488 196.691 192.423"
      stroke="black"
      strokeWidth="0.226548"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M152.286 147.495C152.457 147.874 152.656 149.47 151.599 149.786"
      stroke="black"
      strokeWidth="0.187679"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M144.31 62.9688C143.912 63.0892 142.58 63.9907 143.039 64.9946"
      stroke="black"
      strokeWidth="0.187679"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M68.2424 29.2119C68.6404 29.3324 69.972 30.2339 69.5132 31.2377"
      stroke="black"
      strokeWidth="0.187679"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M177.099 197.596C177.099 197.596 176.989 201.632 180.339 201.926"
      stroke="black"
      strokeWidth="0.362377"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M141.489 149.864C141.489 149.864 141.984 154.421 145.797 154.238"
      stroke="black"
      strokeWidth="0.41133"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M59.9461 41.1543C59.9461 41.1543 62.8247 44.7209 65.9344 42.5066"
      stroke="black"
      strokeWidth="0.41133"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M575.933 159.413C575.933 159.413 574.627 161.113 573.148 160.113"
      stroke="black"
      strokeWidth="0.192391"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M551.873 83.5659C551.873 83.5659 549.832 84.2216 549.185 82.5576"
      stroke="black"
      strokeWidth="0.192391"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M540.594 94.847C540.436 94.7615 540.301 94.6395 540.2 94.4911C540.098 94.3427 540.034 94.1722 540.012 93.9938C539.983 93.8225 539.986 93.6473 540.02 93.477C540.055 93.3015 540.123 93.1344 540.222 92.9851L540.215 93.0086C540.462 92.2368 540.716 91.4666 541.026 90.71C540.959 91.525 540.835 92.3265 540.705 93.1263L540.698 93.15C540.712 93.2835 540.72 93.4177 540.72 93.552C540.721 93.6852 540.719 93.8153 540.711 93.9469C540.703 94.0789 540.69 94.2126 540.675 94.3567C540.649 94.5049 540.64 94.655 540.594 94.847Z"
      fill="black"
    />
    <path
      d="M547.736 90.9219C548.193 91.5255 548.589 92.1734 548.917 92.856C549.262 93.5306 549.537 94.2384 549.738 94.9686C549.28 94.3655 548.884 93.7175 548.557 93.0345C548.213 92.3595 547.938 91.6517 547.736 90.9219Z"
      fill="black"
    />
    <path
      d="M590.136 162.491C590.812 163.174 591.476 163.866 592.127 164.568C592.786 165.265 593.424 165.979 594.07 166.687L594.048 166.663C594.622 167.22 594.986 167.96 595.077 168.755C595.168 169.551 594.98 170.353 594.547 171.026L594.229 171.513L593.853 171.94C593.599 172.214 593.323 172.468 593.028 172.699C592.453 173.152 591.839 173.552 591.193 173.896L590.715 174.155C590.551 174.234 590.383 174.305 590.217 174.38C589.887 174.538 589.547 174.676 589.2 174.791L588.676 174.969C588.5 175.024 588.313 175.055 588.131 175.099C587.76 175.181 587.383 175.229 587.004 175.243C586.201 175.279 585.409 175.049 584.75 174.588C584.433 174.339 584.167 174.032 583.966 173.682C583.766 173.337 583.629 172.959 583.562 172.565L583.56 172.558C583.558 172.544 583.557 172.53 583.558 172.515C583.602 171.579 583.634 170.644 583.692 169.708C583.741 168.772 583.807 167.836 583.888 166.9C583.968 167.836 584.034 168.772 584.084 169.708C584.142 170.644 584.174 171.579 584.219 172.515L584.215 172.466C584.361 173.063 584.717 173.588 585.218 173.944C585.744 174.265 586.358 174.41 586.971 174.358C588.3 174.182 589.58 173.736 590.731 173.049C591.936 172.478 592.986 171.625 593.79 170.562C594.138 170.053 594.31 169.444 594.279 168.828C594.26 168.519 594.189 168.215 594.067 167.93C593.944 167.644 593.779 167.377 593.58 167.137L593.558 167.113C592.978 166.351 592.39 165.595 591.822 164.823C591.248 164.056 590.686 163.279 590.136 162.491Z"
      fill="black"
    />
    <path
      d="M154.386 81.2925L154.293 86.6148C154.293 86.6148 153.764 91.1769 160.803 88.7379C166.93 86.6148 164.912 83.4878 164.912 83.4878L161.588 79.8848"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M187.3 213.529V210.649"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M175.549 206.344C175.342 206.86 175.073 207.349 174.748 207.8C174.437 208.239 174.095 208.654 173.723 209.043C173.353 209.432 172.954 209.794 172.529 210.124C172.094 210.47 171.617 210.761 171.11 210.989C171.316 210.473 171.584 209.983 171.91 209.532C172.221 209.093 172.564 208.678 172.936 208.291C173.307 207.902 173.707 207.541 174.131 207.21C174.567 206.865 175.043 206.574 175.549 206.344Z"
      fill="black"
    />
    <path
      d="M485.714 191.831C499.065 191.225 508.254 203.53 513.641 211.41C513.641 211.41 510.436 229.484 494.413 231.279C494.413 231.279 489.926 232.176 487.491 231.279C487.491 231.279 479.394 210.681 485.365 202.841"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M457.514 240.686C457.514 240.686 451.567 208.501 474.945 194.123"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M512.449 215.548C512.449 215.548 531.394 251.1 534.853 255.948C538.312 260.796 537.248 271.34 529.266 273.722C529.266 273.722 464.17 277.381 461.446 273.722C460.249 272.115 469.091 268.706 469.091 268.706"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M490.056 231.679C490.056 231.679 494.515 242.245 496.566 246.587"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M503.59 245.159C503.59 245.159 483.834 249.769 473.127 255.684C465.683 259.797 458.937 265.888 458.927 268.452C458.919 270.408 465.876 266.156 465.876 266.156C465.876 266.156 458.05 269.983 459.018 272.279C459.71 273.923 462.003 272.578 462.003 272.578"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M456.014 210.419L441.983 199.453"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M471.553 197.014C469.39 197.856 467.31 198.898 465.34 200.126C463.392 201.365 461.555 202.77 459.85 204.326C458.984 205.089 458.151 205.9 457.329 206.71C456.929 207.069 456.602 207.502 456.366 207.985C456.171 208.477 456.097 209.008 456.149 209.535C456.209 210.087 456.348 210.628 456.561 211.141C456.774 211.674 457.017 212.194 457.29 212.698C457.875 213.712 458.372 214.774 458.778 215.871C458.232 214.842 457.621 213.848 456.949 212.897C456.331 211.904 455.71 210.859 455.525 209.606C455.424 208.972 455.489 208.322 455.712 207.72C455.965 207.141 456.329 206.617 456.782 206.177C457.604 205.335 458.438 204.515 459.312 203.726C461.057 202.14 462.971 200.752 465.021 199.587C466.046 199.009 467.11 198.503 468.205 198.071C469.298 197.649 470.416 197.296 471.553 197.014Z"
      fill="black"
    />
    <path
      d="M570.334 137.631C570.334 137.631 573.096 120.964 582.032 118.946C590.967 116.929 588.193 130.251 589.552 135.861C590.91 141.471 589.526 129.501 599.903 141.519C610.28 153.537 611.722 144.889 616.622 148.637C621.522 152.384 613.739 159.878 626.423 161.896C639.106 163.914 624.117 181.856 632.476 188.595C640.835 195.334 646.312 191.875 640.835 195.334C635.358 198.793 640.259 207.736 630.746 207.444L621.234 207.152"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M591.921 150.827C592.596 150.571 593.317 150.461 594.037 150.503C594.43 150.552 594.8 150.713 595.104 150.966C595.406 151.222 595.646 151.542 595.809 151.902C596.376 153.3 596.448 154.849 596.013 156.294C595.774 157.018 595.396 157.688 594.899 158.267C594.394 158.837 593.784 159.305 593.103 159.645C592.413 159.984 591.655 160.16 590.887 160.16C590.096 160.161 589.33 159.88 588.728 159.367L589.198 158.938C589.302 159.136 589.358 159.356 589.361 159.58C589.364 159.804 589.313 160.025 589.213 160.225C589.03 160.57 588.761 160.862 588.431 161.071C587.824 161.448 587.153 161.713 586.452 161.851C587.081 161.575 587.668 161.212 588.196 160.773C588.433 160.57 588.616 160.312 588.729 160.022C588.774 159.894 588.79 159.759 588.777 159.624C588.766 159.507 588.727 159.394 588.663 159.295C588.615 159.235 588.591 159.161 588.594 159.085C588.597 159.009 588.627 158.937 588.679 158.881C588.731 158.826 588.801 158.791 588.877 158.783C588.952 158.775 589.028 158.794 589.091 158.838L589.132 158.866C589.645 159.21 590.26 159.367 590.875 159.312C591.504 159.274 592.116 159.094 592.666 158.785C593.797 158.187 594.663 157.186 595.092 155.981C595.304 155.374 595.412 154.736 595.412 154.093C595.437 153.443 595.353 152.793 595.164 152.17C595.083 151.875 594.929 151.605 594.717 151.385C594.505 151.165 594.24 151.002 593.948 150.91C593.629 150.821 593.298 150.779 592.966 150.787C592.624 150.789 592.273 150.827 591.921 150.827Z"
      fill="black"
    />
    <path
      d="M577.736 138.997C577.092 139.085 576.478 139.322 575.941 139.689C575.713 139.855 575.537 140.082 575.434 140.345C575.332 140.608 575.307 140.895 575.363 141.171C575.389 141.281 575.44 141.383 575.514 141.469C575.588 141.555 575.681 141.621 575.786 141.663C576.059 141.778 576.348 141.855 576.643 141.89C577.335 141.968 578.02 142.101 578.691 142.288C579.069 142.413 579.417 142.614 579.715 142.878C580.017 143.163 580.237 143.524 580.35 143.924C580.456 144.327 580.437 144.753 580.294 145.145C580.175 145.488 580.021 145.817 579.833 146.128C579.476 146.73 579.069 147.273 578.68 147.822C578.285 148.354 577.958 148.933 577.708 149.545C577.59 149.827 577.572 150.14 577.657 150.432C577.719 150.564 577.809 150.68 577.92 150.774C578.031 150.868 578.16 150.938 578.3 150.978C578.924 151.155 579.576 151.219 580.223 151.167C581.547 151.102 582.865 150.947 584.168 150.701C584.815 150.565 585.454 150.389 586.08 150.173C586.159 150.145 586.28 150.125 586.378 150.102C586.506 150.082 586.636 150.076 586.765 150.087C586.908 150.104 587.046 150.147 587.174 150.215C587.232 150.246 587.296 150.279 587.346 150.313L587.475 150.415C587.556 150.478 587.631 150.547 587.701 150.621C587.765 150.688 587.84 150.758 587.894 150.823C588.024 150.961 588.145 151.107 588.254 151.26C588.498 151.607 588.648 152.011 588.69 152.433C588.738 152.815 588.733 153.202 588.676 153.583C588.558 154.303 588.337 155.003 588.019 155.66L587.132 155.174C587.53 154.573 587.949 154.019 588.388 153.465C588.831 152.916 589.303 152.39 589.801 151.89C590.297 151.383 590.839 150.923 591.421 150.516C591.995 150.088 592.659 149.797 593.363 149.665C593.37 149.664 593.377 149.664 593.383 149.666C593.389 149.668 593.395 149.671 593.401 149.675C593.406 149.679 593.41 149.684 593.414 149.69C593.417 149.696 593.419 149.702 593.42 149.709C593.421 149.72 593.418 149.732 593.412 149.742C593.406 149.752 593.396 149.759 593.385 149.763C592.754 150.013 592.181 150.391 591.703 150.872C591.206 151.334 590.744 151.832 590.322 152.363C589.898 152.894 589.482 153.433 589.101 153.999C588.712 154.555 588.335 155.135 587.994 155.705C587.929 155.816 587.823 155.897 587.7 155.932C587.576 155.968 587.444 155.955 587.33 155.897C587.215 155.838 587.128 155.739 587.084 155.618C587.041 155.497 587.045 155.364 587.096 155.246L587.107 155.219C587.356 154.651 587.524 154.051 587.607 153.436C587.724 152.902 587.643 152.344 587.379 151.865C587.298 151.741 587.208 151.623 587.11 151.512C587.059 151.446 587.011 151.4 586.961 151.343C586.919 151.292 586.872 151.244 586.82 151.202L586.756 151.142C586.737 151.129 586.724 151.126 586.709 151.115C586.678 151.084 586.66 151.097 586.643 151.082C586.604 151.079 586.565 151.08 586.527 151.084C586.461 151.099 586.414 151.098 586.332 151.123C585.674 151.32 585.005 151.475 584.327 151.586C582.964 151.767 581.587 151.808 580.217 151.708C579.514 151.694 578.819 151.561 578.161 151.314C577.982 151.246 577.818 151.143 577.679 151.01C577.541 150.877 577.432 150.717 577.357 150.541C577.255 150.18 577.277 149.795 577.419 149.448C577.533 149.121 577.677 148.804 577.847 148.502C578.005 148.198 578.174 147.903 578.345 147.611C578.675 147.021 579.009 146.435 579.275 145.841C579.524 145.257 579.724 144.605 579.549 144.181C579.451 143.929 579.295 143.704 579.094 143.523C578.893 143.342 578.652 143.212 578.39 143.142C577.766 142.956 577.129 142.813 576.485 142.716C576.113 142.646 575.753 142.522 575.417 142.349C575.222 142.242 575.051 142.094 574.917 141.917C574.787 141.728 574.704 141.512 574.674 141.285C574.658 141.085 574.665 140.883 574.693 140.684C574.726 140.486 574.79 140.295 574.883 140.118C575.063 139.771 575.342 139.486 575.683 139.297C576.316 138.974 577.027 138.835 577.735 138.896C577.747 138.897 577.759 138.902 577.767 138.911C577.776 138.92 577.781 138.931 577.782 138.944C577.783 138.956 577.779 138.968 577.771 138.978C577.763 138.987 577.752 138.994 577.74 138.996L577.736 138.997Z"
      fill="black"
    />
    <path
      d="M571.272 137.308C569.756 137.032 568.194 137.184 566.76 137.747C565.374 138.354 564.173 139.317 563.279 140.537C562.325 141.76 561.777 143.252 561.714 144.802C561.69 145.574 561.826 146.343 562.112 147.061C562.381 147.762 562.876 148.354 563.519 148.742L563.157 148.946C563.14 148.213 563.188 147.48 563.301 146.755C563.406 146.027 563.579 145.309 563.817 144.613C564.263 143.158 565.134 141.87 566.318 140.914C566.625 140.681 566.957 140.481 567.307 140.32C567.666 140.139 568.05 140.013 568.447 139.948C568.727 139.901 569.014 139.964 569.249 140.125C569.376 140.225 569.472 140.359 569.526 140.512C569.567 140.629 569.591 140.752 569.598 140.876C569.607 141.074 569.599 141.272 569.575 141.468C569.555 141.606 569.548 141.746 569.554 141.886C569.554 141.897 569.552 141.881 569.52 141.854C569.497 141.834 569.468 141.823 569.437 141.823C569.48 141.823 569.523 141.813 569.561 141.793C569.69 141.742 569.867 141.655 570.016 141.579C570.327 141.42 570.634 141.241 570.953 141.066C571.276 140.867 571.633 140.729 572.006 140.661C572.202 140.635 572.403 140.656 572.589 140.724C572.764 140.794 572.924 140.898 573.06 141.03C573.067 141.037 573.072 141.046 573.072 141.056C573.073 141.066 573.07 141.076 573.064 141.084C573.058 141.092 573.049 141.098 573.039 141.1C573.029 141.101 573.019 141.099 573.01 141.094C572.874 140.998 572.718 140.933 572.553 140.904C572.389 140.875 572.22 140.883 572.059 140.927C571.742 141.049 571.445 141.217 571.178 141.426C570.891 141.631 570.602 141.85 570.297 142.054C570.14 142.163 569.978 142.263 569.81 142.354C569.689 142.418 569.555 142.454 569.419 142.459C569.298 142.459 569.181 142.416 569.089 142.337C569.011 142.267 568.954 142.177 568.923 142.076C568.873 141.863 568.855 141.644 568.871 141.426C568.879 141.266 568.875 141.105 568.86 140.946C568.844 140.805 568.793 140.735 568.785 140.746C568.709 140.73 568.63 140.73 568.554 140.748C568.247 140.816 567.951 140.927 567.675 141.077C567.38 141.227 567.1 141.403 566.837 141.602C565.78 142.457 564.98 143.589 564.528 144.871C564.042 146.181 563.741 147.553 563.633 148.946L563.631 148.976C563.626 149.037 563.597 149.094 563.55 149.134C563.504 149.173 563.443 149.193 563.382 149.188C563.343 149.185 563.305 149.172 563.272 149.15C562.589 148.664 562.084 147.969 561.833 147.169C561.572 146.406 561.449 145.603 561.467 144.798C561.491 143.177 561.953 141.593 562.804 140.213C563.225 139.509 563.76 138.88 564.386 138.349C565.331 137.558 566.472 137.036 567.688 136.84C568.905 136.643 570.152 136.778 571.298 137.231C571.307 137.235 571.315 137.242 571.319 137.251C571.323 137.26 571.324 137.27 571.322 137.28C571.319 137.289 571.313 137.298 571.304 137.303C571.296 137.308 571.286 137.31 571.276 137.308L571.272 137.308Z"
      fill="black"
    />
    <path
      d="M594.054 153.03C594.054 153.03 592.04 151.66 591.153 153.836"
      stroke="black"
      strokeWidth="0.207516"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M567.515 148.494C567.974 148.494 568.346 148.122 568.346 147.663C568.346 147.203 567.974 146.831 567.515 146.831C567.055 146.831 566.683 147.203 566.683 147.663C566.683 148.122 567.055 148.494 567.515 148.494Z"
      fill="black"
    />
    <path
      d="M566.683 147.663C566.683 147.827 566.732 147.988 566.823 148.125C566.915 148.261 567.044 148.368 567.196 148.431C567.348 148.494 567.515 148.51 567.677 148.478C567.838 148.446 567.986 148.367 568.103 148.251C568.219 148.134 568.298 147.986 568.33 147.825C568.362 147.664 568.346 147.496 568.283 147.344C568.22 147.192 568.113 147.063 567.977 146.971C567.84 146.88 567.679 146.831 567.515 146.831C567.405 146.831 567.297 146.853 567.196 146.894C567.095 146.936 567.004 146.997 566.927 147.075C566.849 147.152 566.788 147.243 566.746 147.344C566.704 147.445 566.683 147.553 566.683 147.663V147.663Z"
      stroke="black"
      strokeWidth="0.232125"
      strokeLinejoin="round"
    />
    <path
      d="M554.568 73.8281C555.027 73.8281 555.399 73.4558 555.399 72.9966C555.399 72.5373 555.027 72.165 554.568 72.165C554.108 72.165 553.736 72.5373 553.736 72.9966C553.736 73.4558 554.108 73.8281 554.568 73.8281Z"
      fill="black"
    />
    <path
      d="M554.032 73.6309C554.158 73.7368 554.313 73.803 554.476 73.8211C554.639 73.8392 554.805 73.8084 554.951 73.7327C555.097 73.6569 555.217 73.5396 555.296 73.3955C555.375 73.2514 555.41 73.087 555.396 72.9232C555.382 72.7593 555.32 72.6034 555.217 72.475C555.114 72.3466 554.975 72.2515 554.819 72.2019C554.662 72.1522 554.494 72.1502 554.336 72.196C554.178 72.2418 554.037 72.3335 553.931 72.4593C553.861 72.5429 553.808 72.6395 553.775 72.7436C553.742 72.8477 553.73 72.9572 553.739 73.066C553.748 73.1748 553.779 73.2807 553.83 73.3777C553.88 73.4746 553.949 73.5607 554.032 73.6309V73.6309Z"
      stroke="black"
      strokeWidth="0.232125"
      strokeLinejoin="round"
    />
    <path
      d="M574.998 150.159C575.458 150.159 575.83 149.787 575.83 149.328C575.83 148.868 575.458 148.496 574.998 148.496C574.539 148.496 574.167 148.868 574.167 149.328C574.167 149.787 574.539 150.159 574.998 150.159Z"
      fill="black"
    />
    <path
      d="M574.167 149.328C574.167 149.492 574.215 149.653 574.307 149.79C574.398 149.926 574.528 150.033 574.68 150.096C574.832 150.159 574.999 150.175 575.161 150.143C575.322 150.111 575.47 150.032 575.586 149.916C575.703 149.799 575.782 149.651 575.814 149.49C575.846 149.329 575.83 149.161 575.767 149.009C575.704 148.858 575.597 148.728 575.46 148.636C575.324 148.545 575.163 148.496 574.998 148.496C574.778 148.496 574.566 148.584 574.41 148.74C574.254 148.896 574.167 149.107 574.167 149.328V149.328Z"
      stroke="black"
      strokeWidth="0.232125"
      strokeLinejoin="round"
    />
    <path
      d="M568.708 152.124C568.4 152.362 567.537 153.593 568.272 154.318"
      stroke="black"
      strokeWidth="0.175557"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M578.931 210.421C566.565 209.737 562.865 195.9 562.865 195.9C562.865 195.9 562.182 187.915 567.514 177.336C572.846 166.757 579.048 167.095 579.048 167.095"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M592.604 164.862C592.604 164.862 602.519 165.676 609.526 179.53C616.534 193.384 616.705 195.9 616.705 195.9C613.845 195.31 610.895 195.322 608.04 195.935C605.186 196.549 602.491 197.749 600.126 199.461C592.648 204.895 594.054 210.42 594.054 210.42C594.054 210.42 587.649 208.67 586.452 195.9C585.256 183.129 588.133 176.078 593.375 173.585"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M535.05 152.375C534.341 153.789 534.086 155.388 534.321 156.952C534.492 159.03 546.456 176.634 546.456 176.634"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M570.334 172.754C569.874 171.678 560.473 151.806 558.251 148.496C558.251 148.496 563.127 130.658 561.589 127.924C560.05 125.189 557.568 128.389 555.688 134.029C554.522 137.486 552.914 140.776 550.902 143.819C550.902 143.819 550.586 143.209 548.889 143.241"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M496.722 162.555C496.722 162.555 521.505 145.243 562.866 195.9"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M574.167 209.408C574.167 209.408 574.903 214.129 577.772 215.55"
      stroke="black"
      strokeWidth="0.577143"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M591.564 249.106L572.222 240.263C571.757 240.051 571.339 239.749 570.991 239.375C570.643 239.001 570.372 238.562 570.194 238.083C570.015 237.604 569.933 237.095 569.951 236.584C569.97 236.074 570.089 235.572 570.301 235.107L581.821 209.911C582.033 209.446 582.335 209.028 582.709 208.68C583.083 208.332 583.522 208.061 584.001 207.882C584.48 207.704 584.989 207.622 585.5 207.64C586.01 207.659 586.512 207.778 586.977 207.99L595.408 211.845"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M627.911 225.686L629.305 226.323C631.446 227.302 632.159 229.44 631.226 231.479L629.914 234.35"
      fill="white"
    />
    <path
      d="M627.911 225.686L629.305 226.323C631.446 227.302 632.159 229.44 631.226 231.479L629.914 234.35"
      stroke="#231F20"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M536.631 262.567C536.631 262.567 564.221 250.356 577.772 259.701C577.772 259.701 580.555 261.983 581.324 267.391H536.719"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M594.109 208.003C596.118 211.907 597.899 215.9 599.662 219.897C600.54 221.896 601.322 223.937 602.19 225.937C602.407 226.44 602.646 226.921 602.881 227.417L603.243 228.161C603.355 228.413 603.47 228.663 603.589 228.911C604.041 229.916 604.46 230.933 604.838 231.97C605.202 233.011 605.533 234.068 605.794 235.149C606.052 236.236 606.224 237.341 606.309 238.454C606.38 239.575 606.357 240.7 606.24 241.817C606.175 242.376 606.108 242.935 605.993 243.487C605.896 244.059 605.751 244.623 605.561 245.171C605.35 245.724 605.085 246.256 604.769 246.757C604.444 247.254 604.063 247.712 603.632 248.121C602.781 248.924 601.781 249.552 600.687 249.969C599.625 250.373 598.51 250.624 597.377 250.714C596.264 250.814 595.142 250.752 594.047 250.53C594.039 250.528 594.032 250.525 594.025 250.521C594.018 250.516 594.013 250.51 594.008 250.503C594.004 250.497 594.001 250.489 594 250.481C593.998 250.474 593.998 250.466 594 250.458C594.003 250.444 594.011 250.432 594.022 250.423C594.033 250.415 594.046 250.41 594.06 250.41C595.142 250.394 596.219 250.263 597.273 250.021C598.306 249.799 599.31 249.455 600.263 248.998C601.188 248.557 602.03 247.959 602.751 247.232C603.096 246.868 603.408 246.475 603.683 246.056C603.951 245.632 604.179 245.183 604.365 244.717C604.553 244.238 604.698 243.744 604.799 243.24C604.852 242.98 604.92 242.723 604.965 242.461L605.095 241.675C605.244 240.619 605.318 239.554 605.317 238.488C605.318 237.414 605.251 236.341 605.115 235.275C604.969 234.202 604.742 233.142 604.435 232.103C604.117 231.064 603.718 230.052 603.241 229.075C603.01 228.583 602.738 228.112 602.467 227.642C602.2 227.166 601.906 226.692 601.648 226.208C600.575 224.286 599.566 222.334 598.675 220.332C597.785 218.329 596.96 216.299 596.171 214.256C595.387 212.21 594.642 210.149 593.998 208.048C593.993 208.034 593.994 208.018 594.001 208.004C594.007 207.991 594.019 207.98 594.033 207.974C594.047 207.968 594.062 207.968 594.077 207.973C594.091 207.979 594.103 207.989 594.109 208.003V208.003Z"
      fill="black"
    />
    <path
      d="M614.953 195.341C616.315 197.961 617.622 200.608 618.915 203.262L620.84 207.252C621.467 208.589 622.086 209.93 622.696 211.275C623.913 213.967 625.121 216.663 626.242 219.404C626.532 220.084 626.797 220.777 627.069 221.466L627.474 222.502L627.845 223.554L628.216 224.607L628.542 225.684C628.767 226.416 628.946 227.161 629.079 227.915L629.063 227.833C629.838 230.581 630.487 233.343 630.992 236.151C631.249 237.553 631.448 238.969 631.598 240.396C631.763 241.842 631.788 243.299 631.672 244.749C631.496 246.22 631.081 247.652 630.443 248.988C629.835 250.309 629.097 251.565 628.238 252.738C627.39 253.915 626.434 255.01 625.383 256.01C624.835 256.485 624.316 256.993 623.723 257.416C623.431 257.632 623.152 257.864 622.85 258.067L621.933 258.656C621.629 258.856 621.313 259.036 620.986 259.197C620.663 259.363 620.346 259.543 620.017 259.698L619.007 260.116C618.838 260.184 618.671 260.258 618.501 260.321L617.977 260.48L616.929 260.791C616.572 260.866 616.212 260.926 615.854 260.993C615.13 261.152 614.388 261.216 613.648 261.185C612.904 261.154 612.167 261.032 611.453 260.823C610.756 260.607 610.096 260.385 609.42 260.156C608.076 259.698 606.743 259.212 605.419 258.698C602.757 257.697 600.179 256.487 597.708 255.079C596.466 254.377 595.302 253.547 594.233 252.602C593.696 252.128 593.234 251.575 592.861 250.963C592.473 250.358 592.3 249.639 592.37 248.923C592.339 249.63 592.548 250.327 592.963 250.9C593.363 251.474 593.841 251.99 594.384 252.433C595.475 253.318 596.655 254.086 597.906 254.725C599.149 255.382 600.429 255.97 601.729 256.508C603.028 257.051 604.34 257.562 605.665 258.041C606.991 258.517 608.327 258.964 609.672 259.385C610.34 259.593 611.027 259.803 611.686 259.99C612.335 260.162 613.003 260.254 613.674 260.265C614.349 260.276 615.022 260.199 615.677 260.035C616.011 259.962 616.348 259.899 616.681 259.82L617.659 259.506L618.149 259.352C618.308 259.289 618.465 259.217 618.622 259.151L619.567 258.746C619.875 258.595 620.172 258.421 620.475 258.261C620.781 258.106 621.078 257.931 621.362 257.739L622.222 257.17C622.504 256.976 622.766 256.75 623.04 256.542C623.597 256.137 624.083 255.645 624.597 255.188C624.847 254.95 625.076 254.692 625.316 254.445C625.556 254.197 625.795 253.949 626.01 253.679L626.676 252.888L627.289 252.056C628.098 250.942 628.792 249.75 629.362 248.497C629.941 247.276 630.316 245.968 630.472 244.625C630.58 243.255 630.56 241.877 630.411 240.51C630.271 239.124 630.083 237.737 629.836 236.356C629.344 233.597 628.726 230.84 628.007 228.133L628.006 228.132L627.99 228.051C627.873 227.351 627.714 226.658 627.515 225.977L627.213 224.931L626.862 223.892L626.511 222.852L626.132 221.818C625.88 221.128 625.636 220.436 625.364 219.752C624.321 217.001 623.184 214.28 622.039 211.563C621.464 210.206 620.88 208.852 620.289 207.501L618.535 203.438L614.953 195.341Z"
      fill="black"
    />
    <path
      d="M543.847 147.899C544.821 145.264 544.761 142.814 543.713 142.427C542.665 142.039 541.025 143.861 540.052 146.496C539.078 149.131 539.138 151.582 540.186 151.969C541.234 152.356 542.873 150.534 543.847 147.899Z"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M539.332 148.451C540.306 145.816 540.246 143.366 539.198 142.978C538.149 142.591 536.51 144.413 535.537 147.048C534.563 149.683 534.623 152.133 535.671 152.521C536.719 152.908 538.358 151.086 539.332 148.451Z"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M548.889 143.241C549.085 144.284 548.883 145.873 548.268 147.534C547.295 150.169 545.655 151.991 544.607 151.604C543.559 151.217 543.499 148.767 544.473 146.131C545.447 143.496 547.086 141.674 548.134 142.062C548.521 142.205 548.773 142.629 548.889 143.241Z"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M473.274 136.685C473.274 136.685 481.536 136.111 479.644 121C477.752 105.89 457.064 94.0811 457.064 94.0811C456.119 103.054 453.907 103.567 446.216 122.282C438.525 140.998 454.482 144.217 454.482 144.217"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M457.329 127.009C456.832 126.416 449.872 122.952 456.78 115.266"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M457.329 127.007C456.833 126.413 451.613 120.307 459.488 114.154"
      stroke="black"
      strokeWidth="0.0961905"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M475.094 117.156C474.821 116.179 474.459 115.229 474.011 114.319C473.576 113.406 473.077 112.524 472.519 111.681C471.412 109.986 470.176 108.38 468.822 106.875C467.496 105.343 466.067 103.903 464.603 102.5C463.872 101.796 463.126 101.108 462.365 100.435C461.613 99.7526 460.841 99.0924 460.06 98.4404C461.718 99.6238 463.305 100.903 464.813 102.273C466.328 103.639 467.767 105.086 469.124 106.609C470.48 108.138 471.703 109.781 472.78 111.517C473.879 113.245 474.663 115.154 475.094 117.156Z"
      fill="black"
    />
    <path
      d="M457.383 126.844C457.383 126.844 455.181 123.098 457.072 119.739"
      stroke="black"
      strokeWidth="0.184517"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M560.391 75.5361C560.699 75.774 561.562 77.0055 560.827 77.7302"
      stroke="black"
      strokeWidth="0.175557"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M546.35 87.0328C545.867 86.945 545.41 86.7482 545.014 86.4572C544.621 86.1518 544.284 85.7809 544.017 85.3607C543.757 84.9376 543.547 84.4853 543.393 84.0131C543.234 83.5418 543.123 83.0557 543.062 82.5622L543.164 82.6051C543.015 82.7094 542.843 82.778 542.662 82.8054C542.482 82.8328 542.298 82.8183 542.124 82.7631C541.782 82.6763 541.457 82.5334 541.162 82.3403C540.575 81.9568 540.071 81.4598 539.68 80.8785C539.283 80.2987 539.009 79.6435 538.876 78.9536C538.73 78.2591 538.775 77.5378 539.008 76.8672C539.136 76.5326 539.326 76.225 539.567 75.9604C539.946 75.5746 540.429 75.3075 540.957 75.1918C541.485 75.0761 542.035 75.1167 542.54 75.3088C542.708 75.3715 542.87 75.4509 543.023 75.5457C543.171 75.6462 543.313 75.7565 543.447 75.876C543.565 76.0071 543.698 76.1437 543.801 76.272C543.905 76.4038 544.016 76.5291 544.134 76.6472C544.346 76.8878 544.62 77.0641 544.927 77.1559C545.07 77.1815 545.217 77.1591 545.345 77.0921C545.473 77.0251 545.576 76.9174 545.636 76.7858L545.659 76.9304C545.356 76.5883 545.153 76.1694 545.072 75.7195C544.988 75.284 544.969 74.8385 545.016 74.3974C545.053 73.9615 545.125 73.5292 545.231 73.1048C545.334 72.68 545.464 72.2621 545.62 71.8536C545.629 71.8308 545.643 71.8108 545.663 71.7958C546.738 71.005 547.904 70.344 549.134 69.8267C550.356 69.2954 551.632 68.8985 552.94 68.643C554.246 68.3731 555.579 68.2534 556.912 68.2864C557.579 68.293 558.244 68.3409 558.905 68.43C559.236 68.4659 559.565 68.5211 559.89 68.5952L560.87 68.7896L560.836 68.7848C560.888 68.7893 560.938 68.8041 560.984 68.8283C561.019 68.844 561.053 68.864 561.083 68.8878C561.139 68.9286 561.191 68.9751 561.238 69.0267C561.322 69.1221 561.395 69.2265 561.455 69.338C561.57 69.5486 561.664 69.7699 561.735 69.9988C561.87 70.444 561.97 70.899 562.034 71.3598C562.159 72.2701 562.23 73.187 562.248 74.1056C562.245 74.5639 562.276 75.0198 562.244 75.4798L562.174 76.8575L561.976 78.2234C561.898 78.6764 561.768 79.1195 561.666 79.5678C561.182 81.3482 560.374 83.024 559.282 84.511C558.203 86.0091 556.845 87.2851 555.282 88.2688L555.267 88.0647C555.81 88.2322 556.343 88.4385 556.895 88.5748C557.446 88.7184 558.004 88.8294 558.568 88.9071C560.831 89.2398 563.141 89.0162 565.298 88.2556C566.377 87.8873 567.398 87.3706 568.334 86.7203L568.402 86.8418C567.742 87.0671 567.025 87.0661 566.366 86.8392C565.719 86.6154 565.113 86.2861 564.573 85.8645C564.032 85.4512 563.528 84.9912 563.067 84.4898C562.604 83.992 562.174 83.463 561.783 82.9064L561.915 82.8562C561.959 82.9171 562.01 82.9726 562.067 83.0214C562.134 83.0791 562.206 83.1333 562.279 83.1863C562.428 83.2891 562.582 83.3874 562.74 83.4779C563.057 83.6611 563.383 83.8297 563.714 83.9885C564.361 84.3275 565.042 84.5991 565.745 84.7992C566.451 84.9689 567.19 84.9448 567.883 84.7293C568.575 84.5179 569.205 84.1403 569.718 83.6293L569.787 83.7861C568.853 83.7971 567.939 83.5066 567.183 82.9576C566.461 82.3797 565.872 81.6535 565.455 80.8281C564.655 79.1914 564.008 77.4841 563.523 75.7282C562.464 72.2696 561.403 68.7676 559.489 65.6994C559.015 64.9355 558.488 64.206 557.911 63.5162C557.632 63.1646 557.305 62.8511 557.004 62.5167L556.544 62.0225C556.392 61.8571 556.217 61.7147 556.054 61.5597C555.719 61.2611 555.404 60.9369 555.053 60.6575L553.991 59.8299L552.862 59.0996C552.478 58.8705 552.071 58.6807 551.677 58.469C551.274 58.2744 550.851 58.126 550.439 57.9518C550.016 57.8084 549.585 57.6873 549.157 57.5605C548.717 57.4781 548.284 57.363 547.84 57.3067C547.395 57.2579 546.953 57.1817 546.504 57.1754C544.702 57.1152 542.9 57.2434 541.125 57.5581C537.526 57.937 534.149 59.4836 531.512 61.9618L531.015 62.4152C530.856 62.5734 530.711 62.7444 530.558 62.9084L530.105 63.4051C530.031 63.4886 529.952 63.569 529.881 63.655L529.679 63.9241C529.413 64.2843 529.138 64.6388 528.878 65.0031L528.186 66.1556L528.014 66.444L527.873 66.7488L527.59 67.3584L527.306 67.9679C527.212 68.1711 527.156 68.39 527.079 68.6002L526.649 69.8741L526.358 71.1878L526.214 71.845L526.139 72.5143L525.989 73.8527C525.963 74.7539 525.958 75.6461 525.949 76.5588C525.941 78.3745 525.908 80.1893 525.851 82.0032C525.793 83.8175 525.71 85.6315 525.568 87.4432C525.498 88.3491 525.407 89.2541 525.288 90.1572C525.222 90.6081 525.152 91.0591 525.059 91.5078L524.901 92.179C524.827 92.4005 524.739 92.6205 524.658 92.8406L524.503 92.6507L546.35 87.0328ZM546.39 87.0315L524.572 92.911C524.548 92.9173 524.524 92.9171 524.5 92.9104C524.477 92.9037 524.456 92.8907 524.439 92.8729C524.423 92.855 524.411 92.833 524.406 92.8092C524.401 92.7854 524.403 92.7607 524.411 92.7378L524.417 92.721C524.489 92.5147 524.568 92.3123 524.637 92.1042L524.787 91.4507C524.874 91.0116 524.94 90.5646 525.002 90.1187C525.114 89.223 525.197 88.3226 525.261 87.42C525.389 85.6149 525.458 83.8043 525.504 81.9934C525.548 80.1824 525.568 78.3709 525.562 76.5589C525.567 75.6588 525.559 74.736 525.587 73.8263L525.742 72.4617L525.819 71.7794L525.966 71.1082L526.265 69.7667L526.706 68.4641C526.785 68.2491 526.843 68.0256 526.94 67.8177L527.23 67.194L527.52 66.5704L527.666 66.2587L527.842 65.9634L528.552 64.7844C528.818 64.4115 529.099 64.0487 529.373 63.6806L529.579 63.4055C529.652 63.3176 529.733 63.2353 529.809 63.1499L530.273 62.6421C530.429 62.4746 530.578 62.2999 530.741 62.1383L531.249 61.6751C532.601 60.4331 534.134 59.4047 535.796 58.6254C536.218 58.4452 536.626 58.2344 537.064 58.0941L537.712 57.8618C537.929 57.7861 538.154 57.7363 538.375 57.6724C538.819 57.5482 539.27 57.4506 539.725 57.3803L541.071 57.1837C542.871 56.867 544.698 56.7394 546.525 56.803C546.984 56.8103 547.438 56.888 547.894 56.9389C548.349 56.9974 548.795 57.1154 549.246 57.2011C549.687 57.3313 550.13 57.4565 550.564 57.6045C550.987 57.7831 551.422 57.9368 551.835 58.1367C553.488 58.937 554.998 60.005 556.303 61.2977C556.467 61.4564 556.644 61.6029 556.798 61.7717L557.261 62.276C557.564 62.6177 557.892 62.9362 558.174 63.297C558.756 64.0028 559.288 64.7489 559.765 65.5295C561.685 68.6585 562.726 72.1928 563.761 75.6555C564.229 77.4007 564.859 79.0983 565.643 80.7261C566.042 81.5271 566.608 82.2333 567.303 82.7968C568.023 83.3244 568.895 83.6055 569.788 83.5986H569.793C569.811 83.5986 569.829 83.604 569.844 83.6141C569.859 83.6242 569.871 83.6386 569.877 83.6555C569.884 83.6723 569.886 83.6908 569.882 83.7086C569.879 83.7264 569.87 83.7427 569.857 83.7555C569.32 84.2887 568.659 84.6813 567.934 84.8985C567.211 85.1193 566.442 85.1409 565.708 84.9611C564.994 84.7551 564.303 84.476 563.646 84.1282C563.313 83.9667 562.985 83.795 562.665 83.6074C562.504 83.5146 562.347 83.4134 562.193 83.3063C562.118 83.2508 562.043 83.1936 561.97 83.131C561.884 83.0641 561.815 82.9763 561.771 82.8759C561.765 82.8601 561.765 82.8425 561.771 82.8266C561.777 82.8106 561.788 82.7973 561.803 82.7893C561.818 82.7813 561.836 82.7791 561.852 82.783C561.869 82.787 561.883 82.797 561.893 82.811L561.903 82.8258C562.288 83.3782 562.71 83.9036 563.166 84.3983C563.619 84.8962 564.115 85.3535 564.648 85.7648C565.174 86.1814 565.768 86.5036 566.404 86.7169C567.037 86.9312 567.722 86.9286 568.353 86.7098L568.356 86.7088C568.372 86.703 568.389 86.7032 568.405 86.7093C568.421 86.7153 568.434 86.7269 568.442 86.7418C568.449 86.7567 568.452 86.774 568.448 86.7904C568.444 86.8069 568.434 86.8214 568.421 86.8313C567.476 87.4972 566.444 88.028 565.353 88.4081C563.172 89.1917 560.834 89.4324 558.54 89.1094C557.968 89.0342 557.401 88.9251 556.842 88.7829C556.281 88.6481 555.74 88.4429 555.188 88.276C555.168 88.2699 555.15 88.2581 555.136 88.2421C555.123 88.226 555.114 88.2064 555.111 88.1855C555.109 88.1646 555.112 88.1434 555.121 88.1244C555.13 88.1054 555.144 88.0894 555.162 88.0783L555.173 88.0718C556.698 87.095 558.022 85.8346 559.073 84.3591C560.137 82.893 560.922 81.2429 561.387 79.4919C561.484 79.051 561.61 78.6159 561.684 78.1707L561.871 76.8286C561.916 75.9259 561.965 75.0242 561.929 74.1142C561.906 73.2095 561.831 72.3069 561.704 71.4109C561.64 70.9686 561.542 70.532 561.41 70.1049C561.344 69.8989 561.259 69.6997 561.155 69.5101C561.107 69.4214 561.049 69.3383 560.982 69.2622C560.952 69.2295 560.919 69.1998 560.883 69.1737C560.858 69.1463 560.799 69.1348 560.823 69.1344L560.788 69.1296C559.513 68.8395 558.212 68.6753 556.905 68.6395C555.596 68.5997 554.288 68.7098 553.005 68.9678C551.717 69.2117 550.46 69.595 549.256 70.1109C548.047 70.6111 546.901 71.2518 545.842 72.0196L545.885 71.9619C545.575 72.7504 545.374 73.5776 545.287 74.4205C545.24 74.8361 545.256 75.2562 545.332 75.6673C545.401 76.069 545.579 76.4442 545.846 76.7521L545.851 76.7582C545.868 76.7766 545.879 76.7999 545.882 76.8247C545.885 76.8495 545.881 76.8747 545.869 76.8968C545.777 77.0739 545.636 77.2207 545.463 77.3197C545.285 77.4168 545.077 77.4465 544.879 77.4034C544.523 77.3015 544.204 77.0994 543.96 76.8211C543.835 76.6959 543.719 76.5633 543.611 76.4239C543.499 76.2845 543.39 76.176 543.281 76.0497C543.159 75.9404 543.03 75.8391 542.895 75.7464C542.756 75.6592 542.609 75.586 542.456 75.528C542.15 75.4072 541.822 75.3479 541.493 75.3537C541.164 75.3595 540.839 75.4301 540.537 75.5617C540.235 75.6932 539.962 75.883 539.734 76.1202C539.505 76.3574 539.326 76.6373 539.206 76.9439C538.983 77.5773 538.938 78.2592 539.073 78.9166C539.335 80.2577 540.116 81.4413 541.246 82.2102C541.524 82.3984 541.832 82.5392 542.156 82.6269C542.31 82.6794 542.473 82.696 542.634 82.6754C542.795 82.6549 542.949 82.5978 543.085 82.5084C543.094 82.5013 543.104 82.4967 543.116 82.4951C543.127 82.4935 543.138 82.495 543.149 82.4994C543.159 82.5038 543.168 82.5109 543.175 82.5201C543.182 82.5292 543.186 82.5401 543.187 82.5514C543.24 83.0369 543.343 83.5158 543.492 83.9809C543.637 84.4481 543.837 84.8966 544.087 85.317C544.343 85.7334 544.669 86.1025 545.051 86.408C545.454 86.6981 545.909 86.9097 546.39 87.0315V87.0315Z"
      fill="black"
    />
    <path
      d="M574.109 125.622C573.004 122.139 572.152 118.583 571.081 115.119C570.004 111.665 568.7 108.268 566.724 105.29C564.773 102.286 562.135 99.7901 559.029 98.0071C557.458 97.1215 555.801 96.3988 554.083 95.8502C552.353 95.3041 550.581 94.9052 548.784 94.6577C547.886 94.5203 546.981 94.4377 546.076 94.3637C545.624 94.3267 545.17 94.304 544.717 94.2758C544.264 94.2663 543.811 94.2433 543.358 94.2448C541.548 94.2297 539.741 94.3857 537.962 94.7109C534.421 95.3331 531.075 96.776 528.192 98.9239C525.358 101.102 523.051 103.891 521.444 107.084C520.626 108.672 519.941 110.325 519.396 112.027C518.841 113.717 518.437 115.453 518.187 117.215L517.47 116.548C518.501 116.407 519.54 116.335 520.581 116.331C521.609 116.319 522.635 116.347 523.659 116.414C525.702 116.547 527.733 116.825 529.736 117.247C531.731 117.677 533.696 118.237 535.617 118.924C537.527 119.622 539.388 120.448 541.186 121.398C541.199 121.405 541.21 121.417 541.215 121.432C541.219 121.447 541.218 121.463 541.212 121.477C541.205 121.491 541.193 121.502 541.179 121.508C541.164 121.513 541.148 121.513 541.133 121.507C539.276 120.717 537.376 120.032 535.442 119.457C531.593 118.311 527.617 117.649 523.606 117.486C521.625 117.407 519.641 117.5 517.677 117.763L517.654 117.766C517.493 117.789 517.33 117.748 517.201 117.65C517.071 117.553 516.985 117.409 516.962 117.248C516.955 117.198 516.954 117.147 516.96 117.096C517.066 116.163 517.225 115.237 517.434 114.322C517.636 113.414 517.876 112.515 518.165 111.632C518.728 109.857 519.454 108.138 520.332 106.496C522.071 103.174 524.547 100.295 527.571 98.0785C529.09 96.9945 530.743 96.1108 532.487 95.4492C534.223 94.8009 536.026 94.3483 537.863 94.0997C541.524 93.5844 545.214 93.8161 548.835 94.2899C549.743 94.4097 550.646 94.5642 551.545 94.7431C552.446 94.9122 553.338 95.1317 554.225 95.3722C556.011 95.8446 557.743 96.4991 559.395 97.3255C561.061 98.162 562.611 99.211 564.007 100.446C565.397 101.697 566.615 103.126 567.629 104.696C569.662 107.832 570.939 111.352 571.88 114.889C572.835 118.433 573.453 122.028 574.226 125.591C574.229 125.606 574.227 125.622 574.218 125.635C574.21 125.649 574.197 125.658 574.182 125.662C574.167 125.666 574.151 125.664 574.138 125.657C574.124 125.65 574.114 125.637 574.109 125.622L574.109 125.622Z"
      fill="black"
    />
    <path
      d="M540.355 104.507C540.9 105.029 541.392 105.604 541.824 106.223C543.111 108.108 543.979 110.248 544.368 112.497C544.439 112.87 544.465 113.25 544.515 113.626L544.581 114.191L544.598 114.759C544.604 115.138 544.62 115.517 544.619 115.896L544.539 117.029L544.496 117.594L544.405 118.153L544.22 119.27C544.157 119.642 544.032 120.001 543.941 120.366C543.844 120.729 543.743 121.091 543.638 121.452C543.753 120.707 543.927 119.977 544.026 119.236L544.152 118.123L544.215 117.567L544.23 117.008L544.266 115.892C544.258 115.521 544.232 115.149 544.217 114.778L544.193 114.221L544.124 113.669C544.071 113.302 544.043 112.93 543.972 112.566C543.715 111.102 543.284 109.674 542.687 108.312C542.097 106.938 541.312 105.656 540.355 104.507Z"
      fill="black"
    />
    <path
      d="M519.453 117.154C519.453 117.154 512.446 133.518 511.42 141.061"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M541.953 127.924C541.246 130.763 540.432 133.574 539.567 136.37C538.7 139.165 537.748 141.934 536.734 144.681C535.714 147.428 534.553 150.121 533.257 152.75C532.6 154.063 531.857 155.331 531.034 156.547C530.614 157.151 530.145 157.719 529.63 158.246C529.134 158.794 528.499 159.197 527.792 159.414C528.14 159.304 528.465 159.132 528.751 158.905C529.041 158.687 529.31 158.441 529.554 158.171C530.04 157.631 530.48 157.05 530.87 156.436C531.655 155.208 532.36 153.931 532.979 152.612C534.239 149.982 535.342 147.276 536.358 144.539C537.401 141.811 538.345 139.046 539.274 136.275C539.74 134.89 540.193 133.501 540.633 132.107C541.087 130.717 541.518 129.32 541.953 127.924Z"
      fill="black"
    />
    <path
      d="M502.607 151.687C500.584 148.548 498.629 145.368 496.694 142.174C494.757 138.981 492.875 135.754 491.048 132.494C489.236 129.224 487.458 125.934 485.925 122.498C485.548 121.635 485.189 120.763 484.883 119.856C484.726 119.396 484.596 118.927 484.494 118.451C484.441 118.197 484.409 117.939 484.397 117.68C484.391 117.535 484.398 117.389 484.418 117.245C484.43 117.164 484.447 117.084 484.47 117.006L484.528 116.825C484.679 116.312 484.929 115.835 485.266 115.419C485.462 115.188 485.703 114.999 485.974 114.864C486.246 114.729 486.542 114.652 486.845 114.636C487.404 114.629 487.956 114.764 488.448 115.028C488.912 115.263 489.342 115.558 489.727 115.907C489.831 116.001 489.895 116.131 489.906 116.271C489.916 116.411 489.872 116.549 489.782 116.657C489.693 116.765 489.565 116.834 489.426 116.85C489.286 116.866 489.146 116.827 489.035 116.742C488.265 116.161 487.562 115.495 486.941 114.758C486.298 114.015 485.798 113.16 485.465 112.236C485.11 111.271 485.108 110.213 485.459 109.247C485.833 108.319 486.483 107.529 487.322 106.984C488.172 106.462 489.194 106.296 490.165 106.522C491.088 106.743 491.963 107.127 492.749 107.657C493.53 108.167 494.266 108.74 494.952 109.372C495.643 109.997 496.296 110.663 496.905 111.368C496.946 111.414 496.966 111.474 496.963 111.536C496.959 111.597 496.931 111.655 496.886 111.696C496.841 111.737 496.781 111.759 496.719 111.757C496.658 111.755 496.6 111.729 496.557 111.685L496.548 111.675C495.869 110.965 495.232 110.216 494.64 109.432C494.013 108.642 493.499 107.77 493.11 106.84C493.014 106.583 492.947 106.316 492.91 106.045C492.865 105.732 492.9 105.414 493.009 105.119C493.138 104.798 493.373 104.532 493.675 104.365C493.937 104.219 494.223 104.122 494.52 104.079C495.046 104.004 495.58 104 496.108 104.067C496.625 104.128 497.135 104.242 497.629 104.407C499.606 105.073 501.202 106.383 502.678 107.641C503.048 107.956 503.413 108.272 503.776 108.559C504.08 108.825 504.424 109.04 504.796 109.195C504.827 109.207 504.861 109.211 504.893 109.207C504.841 109.223 505.005 109.17 505.109 109.132L505.796 108.889C506.26 108.726 506.732 108.568 507.216 108.429C508.227 108.085 509.3 107.962 510.363 108.069C510.679 108.118 510.984 108.224 511.261 108.384C511.571 108.565 511.825 108.826 511.999 109.14C512.172 109.476 512.231 109.859 512.166 110.231C512.114 110.528 512.02 110.817 511.887 111.088C511.388 111.96 510.82 112.791 510.188 113.572C509.918 113.925 509.685 114.306 509.495 114.708C509.423 114.859 509.383 115.023 509.377 115.19C509.378 115.244 509.39 115.297 509.411 115.346C509.459 115.428 509.512 115.509 509.57 115.586C511.834 118.667 514.351 121.708 516.317 125.069C516.321 125.076 516.323 125.083 516.324 125.091C516.325 125.099 516.325 125.107 516.323 125.115C516.321 125.122 516.317 125.129 516.312 125.136C516.308 125.142 516.302 125.147 516.295 125.151C516.282 125.159 516.266 125.161 516.252 125.158C516.237 125.155 516.224 125.147 516.215 125.134C515.065 123.572 513.802 122.104 512.554 120.623C511.303 119.135 509.995 117.728 508.775 116.163C508.683 116.049 508.599 115.928 508.525 115.802C508.437 115.634 508.383 115.45 508.368 115.26C508.351 114.941 508.405 114.622 508.526 114.326C508.727 113.84 508.981 113.377 509.283 112.946C509.839 112.192 510.342 111.401 510.786 110.576C510.865 110.41 510.921 110.234 510.952 110.053C510.974 109.944 510.959 109.829 510.907 109.73C510.822 109.61 510.71 109.51 510.58 109.439C510.45 109.368 510.306 109.327 510.158 109.32C509.742 109.274 509.321 109.29 508.91 109.368C508.458 109.441 508.01 109.542 507.571 109.671C507.122 109.798 506.672 109.947 506.22 110.104L505.535 110.344C505.38 110.406 505.22 110.451 505.056 110.48C504.846 110.503 504.635 110.482 504.434 110.417C504.144 110.319 503.87 110.179 503.621 110.001C503.394 109.847 503.193 109.686 502.996 109.525C502.606 109.201 502.245 108.873 501.883 108.551C500.456 107.266 498.987 106.048 497.276 105.412C496.855 105.253 496.418 105.136 495.974 105.065C495.54 104.992 495.098 104.976 494.66 105.018C494.495 105.015 494.331 105.055 494.185 105.133C494.039 105.211 493.915 105.324 493.824 105.462C493.709 105.831 493.724 106.228 493.866 106.587C494.176 107.471 494.608 108.306 495.149 109.07C495.686 109.864 496.269 110.627 496.894 111.355L496.537 111.662C495.414 110.226 494.068 108.979 492.55 107.969C491.804 107.47 490.966 107.122 490.086 106.944C489.659 106.868 489.221 106.87 488.794 106.949C488.378 107.037 487.986 107.212 487.643 107.463C486.959 107.977 486.446 108.686 486.174 109.497C485.94 110.297 485.998 111.154 486.34 111.914C486.687 112.705 487.161 113.433 487.743 114.071C488.324 114.73 488.969 115.329 489.669 115.859L488.977 116.694C488.386 116.158 487.564 115.66 486.887 115.679C486.723 115.685 486.561 115.725 486.413 115.797C486.265 115.869 486.133 115.971 486.026 116.096C485.767 116.402 485.57 116.756 485.446 117.137L485.391 117.288C485.381 117.322 485.373 117.356 485.368 117.39C485.355 117.477 485.351 117.565 485.354 117.653C485.362 117.86 485.386 118.066 485.427 118.27C485.516 118.707 485.632 119.14 485.773 119.564C486.054 120.429 486.396 121.288 486.758 122.139C488.216 125.543 489.941 128.855 491.689 132.144C493.44 135.434 495.265 138.688 497.099 141.937C498.939 145.182 500.818 148.406 502.709 151.623C502.717 151.637 502.72 151.653 502.716 151.669C502.712 151.684 502.703 151.697 502.689 151.706C502.676 151.714 502.659 151.717 502.644 151.713C502.629 151.71 502.615 151.7 502.607 151.687V151.687Z"
      fill="black"
    />
    <path
      d="M561.15 98.6582C562.94 98.9146 570.001 104.811 572.709 108.016L571.486 116.825"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M572.867 109.818C574.631 107.482 575.694 104.692 575.932 101.774C576.197 97.1597 576.881 72.0351 584.914 62.122C592.947 52.2088 594.823 50.8415 592.603 62.8056C590.383 74.7697 592.434 61.1938 596.365 59.436C600.296 57.6781 598.929 66.053 597.391 70.8387C595.853 75.6243 600.296 64.002 602.347 67.9331C604.398 71.8642 596.536 92.3741 597.049 99.5526C597.562 106.731 602.176 116.644 603.544 117.157"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M630.378 37.6992C630.378 37.6992 625.25 39.047 625.934 47.7637L626.618 56.4804"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M609.782 130.743C609.782 130.743 614.483 146.158 603.544 145.245"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M584.186 72.9952C584.186 72.9952 591.158 69.2139 594.701 76.2641"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M580.689 264.608C580.689 264.608 599.281 270.41 620.17 264.927"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M606.742 20.8549L606.588 20.9786L604.705 18.6407C603.114 16.6647 600.333 16.2632 598.495 17.7438L588.297 25.9577C586.458 27.4383 586.258 30.2405 587.85 32.2164L595.73 42.0001C597.321 43.976 600.101 44.3776 601.94 42.8969L612.138 34.6831C613.976 33.2025 614.177 30.4003 612.585 28.4243L612.037 27.7442L612.191 27.6206C613.696 26.4083 613.86 24.1141 612.557 22.4963L611.826 21.5892C610.523 19.9715 608.247 19.6427 606.742 20.8549Z"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M506.348 83.8571L506.206 83.9115L505.378 81.7475C504.678 79.9185 502.731 78.9636 501.029 79.6147L491.589 83.2268C489.888 83.8779 489.076 85.8885 489.775 87.7175L493.241 96.7736C493.941 98.6026 495.887 99.5575 497.589 98.9063L507.029 95.2943C508.731 94.6432 509.543 92.6326 508.843 90.8036L508.602 90.174L508.744 90.1196C509.428 89.8282 509.968 89.2775 510.247 88.5883C510.525 87.899 510.519 87.1275 510.229 86.4429L509.908 85.6033C509.666 84.9002 509.156 84.3216 508.489 83.9942C507.821 83.6669 507.051 83.6176 506.348 83.8571V83.8571Z"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M177.34 204.15C177.743 204.309 178.132 204.476 178.521 204.637C178.911 204.795 179.297 204.956 179.69 205.079C180.07 205.217 180.467 205.3 180.87 205.326C181.069 205.344 181.269 205.308 181.449 205.221C181.63 205.135 181.783 205.001 181.894 204.835C181.847 205.059 181.72 205.259 181.538 205.398C181.347 205.536 181.122 205.619 180.887 205.64C180.439 205.674 179.988 205.613 179.564 205.462C179.152 205.323 178.755 205.14 178.381 204.918C178.006 204.702 177.656 204.445 177.34 204.15Z"
      fill="black"
    />
    <path
      d="M188.264 185.698C188.819 185.698 189.268 185.249 189.268 184.694C189.268 184.14 188.819 183.69 188.264 183.69C187.71 183.69 187.26 184.14 187.26 184.694C187.26 185.249 187.71 185.698 188.264 185.698Z"
      fill="black"
    />
    <path
      d="M189.229 184.974C189.383 184.442 189.076 183.885 188.543 183.732C188.011 183.578 187.454 183.885 187.3 184.417C187.147 184.95 187.454 185.507 187.986 185.66C188.519 185.814 189.075 185.507 189.229 184.974Z"
      stroke="black"
      strokeWidth="0.280199"
      strokeLinejoin="round"
    />
    <path
      d="M139.275 57.1777C139.734 57.1777 140.106 56.8055 140.106 56.3462C140.106 55.8869 139.734 55.5146 139.275 55.5146C138.815 55.5146 138.443 55.8869 138.443 56.3462C138.443 56.8055 138.815 57.1777 139.275 57.1777Z"
      fill="black"
    />
    <path
      d="M138.548 56.7502C138.628 56.8939 138.748 57.0108 138.895 57.0859C139.041 57.161 139.206 57.1911 139.37 57.1723C139.533 57.1535 139.687 57.0867 139.813 56.9802C139.938 56.8738 140.029 56.7326 140.074 56.5745C140.119 56.4163 140.117 56.2483 140.066 56.0918C140.016 55.9352 139.92 55.7971 139.791 55.6948C139.663 55.5926 139.506 55.5309 139.342 55.5174C139.179 55.504 139.014 55.5395 138.871 55.6194C138.678 55.7265 138.535 55.9058 138.475 56.1179C138.414 56.33 138.441 56.5574 138.548 56.7502Z"
      stroke="black"
      strokeWidth="0.232125"
      strokeLinejoin="round"
    />
    <path
      d="M63.4293 26.9111C63.8886 26.9111 64.2609 26.5389 64.2609 26.0796C64.2609 25.6203 63.8886 25.248 63.4293 25.248C62.9701 25.248 62.5978 25.6203 62.5978 26.0796C62.5978 26.5389 62.9701 26.9111 63.4293 26.9111Z"
      fill="black"
    />
    <path
      d="M62.7025 26.4836C62.7824 26.6273 62.9031 26.7442 63.0494 26.8193C63.1957 26.8944 63.361 26.9245 63.5244 26.9057C63.6878 26.8869 63.8419 26.82 63.9673 26.7136C64.0927 26.6072 64.1838 26.466 64.2289 26.3079C64.2741 26.1497 64.2713 25.9817 64.221 25.8252C64.1707 25.6686 64.075 25.5304 63.9462 25.4282C63.8174 25.326 63.6611 25.2643 63.4972 25.2508C63.3333 25.2374 63.1691 25.2729 63.0253 25.3528C62.9299 25.4058 62.8458 25.4772 62.7779 25.5627C62.7101 25.6482 62.6597 25.7463 62.6297 25.8513C62.5998 25.9563 62.5907 26.0662 62.6032 26.1747C62.6157 26.2832 62.6495 26.3881 62.7025 26.4836V26.4836Z"
      stroke="black"
      strokeWidth="0.232125"
      strokeLinejoin="round"
    />
    <path
      d="M150.504 60.8819C150.963 60.8819 151.335 60.5096 151.335 60.0503C151.335 59.591 150.963 59.2188 150.504 59.2188C150.045 59.2188 149.672 59.591 149.672 60.0503C149.672 60.5096 150.045 60.8819 150.504 60.8819Z"
      fill="black"
    />
    <path
      d="M149.777 60.4543C149.857 60.598 149.978 60.7149 150.124 60.79C150.27 60.8651 150.436 60.8952 150.599 60.8764C150.762 60.8576 150.916 60.7908 151.042 60.6843C151.167 60.5779 151.258 60.4367 151.303 60.2786C151.349 60.1204 151.346 59.9525 151.296 59.7959C151.245 59.6393 151.15 59.5012 151.021 59.3989C150.892 59.2967 150.736 59.235 150.572 59.2215C150.408 59.2081 150.244 59.2436 150.1 59.3235C150.004 59.3765 149.92 59.4479 149.852 59.5334C149.785 59.6189 149.734 59.717 149.704 59.822C149.674 59.927 149.665 60.0369 149.678 60.1454C149.69 60.2539 149.724 60.3588 149.777 60.4543V60.4543Z"
      stroke="black"
      strokeWidth="0.232125"
      strokeLinejoin="round"
    />
    <path
      d="M147.194 142.935C147.653 142.935 148.025 142.562 148.025 142.103C148.025 141.644 147.653 141.271 147.194 141.271C146.734 141.271 146.362 141.644 146.362 142.103C146.362 142.562 146.734 142.935 147.194 142.935Z"
      fill="black"
    />
    <path
      d="M146.658 142.739C146.784 142.845 146.939 142.911 147.102 142.93C147.266 142.948 147.431 142.917 147.577 142.841C147.723 142.765 147.843 142.648 147.922 142.504C148.002 142.36 148.036 142.196 148.022 142.032C148.008 141.868 147.946 141.712 147.843 141.583C147.74 141.455 147.602 141.36 147.445 141.31C147.288 141.261 147.12 141.259 146.962 141.304C146.804 141.35 146.663 141.442 146.557 141.568C146.415 141.736 146.346 141.955 146.365 142.174C146.384 142.394 146.49 142.597 146.658 142.739Z"
      stroke="black"
      strokeWidth="0.232125"
      strokeLinejoin="round"
    />
    <path
      d="M200.864 184.934C201.418 184.934 201.868 184.485 201.868 183.931C201.868 183.376 201.418 182.927 200.864 182.927C200.309 182.927 199.86 183.376 199.86 183.931C199.86 184.485 200.309 184.934 200.864 184.934Z"
      fill="black"
    />
    <path
      d="M200.218 184.699C200.37 184.826 200.556 184.906 200.753 184.928C200.951 184.95 201.15 184.913 201.326 184.821C201.502 184.73 201.648 184.588 201.743 184.414C201.839 184.241 201.881 184.042 201.864 183.844C201.847 183.647 201.772 183.458 201.648 183.303C201.523 183.148 201.356 183.034 201.167 182.974C200.978 182.914 200.775 182.911 200.584 182.966C200.394 183.022 200.224 183.132 200.096 183.284C199.924 183.488 199.841 183.751 199.864 184.017C199.887 184.282 200.014 184.527 200.218 184.699V184.699Z"
      stroke="black"
      strokeWidth="0.280199"
      strokeLinejoin="round"
    />
    <path
      d="M173.562 231.242L173.651 232.06C173.672 232.333 173.711 232.604 173.769 232.871C173.887 233.407 173.963 233.949 174.115 234.476C174.258 235.004 174.384 235.537 174.541 236.061L175.017 237.632C175.684 239.717 176.427 241.778 177.207 243.824C178.779 247.911 180.506 251.943 182.286 255.938L181.881 255.682C185.153 255.563 188.399 255.056 191.551 254.174C192.343 253.976 193.103 253.677 193.878 253.429C194.259 253.286 194.635 253.13 195.013 252.982L195.58 252.756L196.134 252.502C197.617 251.84 199.044 251.059 200.4 250.166C204.473 247.487 207.848 243.875 210.246 239.629C210.641 238.925 211.005 238.206 211.339 237.473C211.67 236.755 211.957 236.017 212.199 235.264L212.707 236.188C212.281 236.044 211.876 235.844 211.503 235.594C211.162 235.368 210.842 235.132 210.535 234.888C209.921 234.401 209.35 233.888 208.793 233.365C207.68 232.318 206.632 231.223 205.602 230.116C203.548 227.894 201.583 225.617 199.661 223.281L199.729 223.354C196.772 220.496 193.504 217.978 189.986 215.848C186.468 213.784 182.609 212.256 178.592 211.803C176.591 211.578 174.568 211.64 172.585 211.99C170.605 212.343 168.692 213.003 166.917 213.948C166.034 214.419 165.193 214.965 164.404 215.579C164.219 215.715 164.048 215.87 163.895 216.041C163.823 216.114 163.756 216.191 163.693 216.273L163.486 216.569L163.279 216.866L163.084 217.19C162.954 217.408 162.82 217.619 162.694 217.841C161.689 219.624 160.782 221.498 159.879 223.367C156.316 230.883 153.056 238.567 149.815 246.248L144.956 257.777C143.346 261.625 141.764 265.485 140.105 269.314C143.032 261.501 146.011 253.707 149.042 245.932C152.139 238.182 155.248 230.439 158.685 222.81C159.553 220.903 160.452 219.014 161.476 217.152C161.605 216.919 161.747 216.688 161.883 216.457L162.088 216.109L162.324 215.762L162.562 215.415C162.658 215.289 162.76 215.169 162.869 215.055C163.064 214.837 163.279 214.639 163.511 214.462C164.361 213.786 165.267 213.184 166.22 212.663C168.124 211.626 170.178 210.893 172.308 210.491C173.371 210.288 174.448 210.17 175.529 210.137C176.069 210.103 176.608 210.133 177.148 210.136C177.686 210.167 178.226 210.198 178.761 210.256C183.059 210.726 187.127 212.335 190.793 214.469C194.426 216.65 197.792 219.248 200.824 222.209C200.845 222.23 200.866 222.251 200.885 222.274L200.892 222.283C202.776 224.59 204.729 226.867 206.744 229.06C207.753 230.156 208.784 231.23 209.849 232.25C210.381 232.759 210.923 233.256 211.481 233.707C211.76 233.932 212.043 234.144 212.326 234.336C212.575 234.507 212.843 234.648 213.124 234.756L213.165 234.769C213.255 234.799 213.339 234.845 213.412 234.907C213.484 234.968 213.544 235.044 213.587 235.128C213.631 235.213 213.657 235.305 213.664 235.4C213.672 235.495 213.661 235.59 213.632 235.68C213.362 236.501 213.042 237.304 212.673 238.085C212.312 238.854 211.921 239.607 211.5 240.342C210.655 241.808 209.693 243.205 208.625 244.518C206.494 247.151 203.94 249.411 201.068 251.206C199.642 252.106 198.146 252.889 196.593 253.547L196.015 253.799L195.424 254.021C195.03 254.167 194.639 254.32 194.243 254.46C193.438 254.702 192.648 254.993 191.83 255.182C188.588 256.024 185.257 256.479 181.907 256.538L181.898 256.539C181.814 256.54 181.732 256.517 181.661 256.471C181.591 256.426 181.536 256.36 181.502 256.283C179.779 252.236 178.222 248.13 176.759 243.988C176.041 241.912 175.362 239.822 174.758 237.709L174.34 236.115C174.205 235.582 174.101 235.041 173.98 234.506C173.85 233.972 173.796 233.422 173.7 232.882C173.654 232.611 173.626 232.338 173.616 232.063L173.562 231.242Z"
      fill="black"
    />
    <path
      d="M212.916 237.999C212.916 237.999 233.637 254.571 250.006 258.032C266.375 261.493 272.232 262.903 277.488 269.953C282.745 277.004 273.133 272.389 269.379 270.594C269.379 270.594 276.137 275.607 267.126 273.742C258.116 271.876 257.815 270.722 257.815 270.722C257.815 270.722 268.027 274.975 264.723 275.349C261.419 275.722 251.927 273.671 247.287 273.158C242.647 272.645 213.933 277.132 203.21 274.312C192.488 271.492 183.173 256.053 183.173 256.053"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M200.276 222.781C200.276 222.781 231.05 199.114 235.186 189.54"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M222.005 244.557C222.005 244.557 225.768 242.676 229.358 235.257C232.947 227.839 238.317 215.548 238.317 215.548"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M271.594 190.295C272.073 189.285 270.404 187.49 267.866 186.286C265.328 185.082 262.882 184.924 262.403 185.934C261.924 186.943 263.593 188.738 266.131 189.942C268.669 191.146 271.115 191.304 271.594 190.295Z"
      fill="white"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M271.446 185.748C271.925 184.738 270.255 182.944 267.717 181.739C265.179 180.535 262.733 180.377 262.254 181.387C261.775 182.396 263.445 184.191 265.983 185.395C268.521 186.599 270.967 186.757 271.446 185.748Z"
      fill="white"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M270.323 195.377C269.265 195.48 267.702 195.137 266.101 194.377C263.563 193.173 261.894 191.379 262.373 190.369C262.852 189.359 265.298 189.517 267.836 190.721C270.374 191.926 272.043 193.72 271.564 194.73C271.387 195.103 270.942 195.316 270.323 195.377Z"
      fill="white"
    />
    <path
      d="M270.323 195.377C269.265 195.48 267.702 195.137 266.101 194.377C263.563 193.173 261.894 191.379 262.373 190.369C262.852 189.359 265.298 189.517 267.836 190.721C270.374 191.926 272.043 193.72 271.564 194.73C271.387 195.103 270.942 195.316 270.323 195.377"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M128.189 162.024C124.571 160.881 120.781 160.222 117.035 160.517C113.296 160.803 109.687 162.013 106.533 164.04C104.961 165.043 103.492 166.199 102.147 167.491C100.807 168.795 99.5716 170.202 98.4513 171.698C97.3243 173.194 96.301 174.766 95.3884 176.402C94.4711 178.027 93.6666 179.713 92.9806 181.448L92.5675 180.672C93.9242 181.039 95.2268 181.465 96.5327 181.927C97.8352 182.388 99.1202 182.894 100.388 183.447C102.934 184.535 105.385 185.835 107.714 187.333C108.874 188.097 109.989 188.927 111.053 189.818C112.117 190.718 113.098 191.711 113.984 192.787C115.818 194.915 116.982 197.539 117.329 200.327L117.32 200.289C117.436 200.773 117.45 201.275 117.359 201.764C117.277 202.238 117.136 202.699 116.939 203.138C116.743 203.57 116.51 203.985 116.241 204.377L115.821 204.947L115.366 205.487L115.782 204.918L116.158 204.324C116.394 203.922 116.595 203.501 116.759 203.064C116.926 202.635 117.039 202.186 117.094 201.728C117.152 201.286 117.121 200.837 117.001 200.407C116.997 200.395 116.994 200.382 116.991 200.369C116.508 197.707 115.274 195.238 113.435 193.253C111.61 191.261 109.507 189.543 107.192 188.152C104.877 186.741 102.455 185.514 99.9475 184.481C97.4481 183.434 94.8847 182.547 92.2728 181.825L92.2561 181.82C92.1061 181.78 91.9781 181.682 91.9005 181.547C91.8228 181.413 91.8018 181.253 91.8421 181.103C91.847 181.084 91.8531 181.066 91.8596 181.048C92.5521 179.242 93.3834 177.492 94.3461 175.815C95.2938 174.137 96.3552 172.526 97.5226 170.993C99.8364 167.883 102.718 165.239 106.015 163.2C109.331 161.17 113.114 160.03 117 159.892C117.48 159.851 117.962 159.897 118.442 159.899C118.922 159.897 119.402 159.925 119.879 159.981L121.308 160.135C121.78 160.207 122.249 160.309 122.719 160.394C123.656 160.576 124.583 160.804 125.497 161.078C125.96 161.188 126.398 161.386 126.849 161.538L128.189 162.024Z"
      fill="black"
    />
    <path
      d="M209.914 166.729C212.694 169.849 215.621 173.867 219.068 178.687L231.058 195.45"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M126.804 230.5C126.804 230.5 143.627 208.631 159.252 189.623"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M157.283 222.781C157.283 222.781 126.262 234.062 117.289 234.318C117.289 234.318 130.091 238.676 132.278 252.264C134.466 265.852 132.278 270.98 132.278 270.98"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M123.71 237.999L99.0852 246.88C99.0852 246.88 93.9578 245.854 93.445 246.88"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M98.0603 267.647C98.0603 267.647 115.635 274.313 132.998 267.647"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M97.4907 250.214C97.4907 250.214 96.2088 264.827 97.4907 267.647"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M114.727 204.549C112.245 208.836 111.344 210.221 108.91 214.537C106.978 217.964 105.627 219.936 103.761 223.402C101.9 226.859 98.9052 230.662 104.459 230.627L132.864 230.445"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M165.319 169.902C165.319 169.902 168.941 141.509 172.598 137.92C176.254 134.331 183.436 118.184 185.999 117.671C188.563 117.158 186.477 122.538 184.426 126.127C182.375 129.716 191.332 116.353 192.101 119.288C192.87 122.224 190.422 137.664 191.029 139.715C191.637 141.766 202.148 145.07 205.994 143.161C209.839 141.253 212.682 144.33 209.338 146.381C205.994 148.432 193.944 146.874 193.432 150.088L193.038 152.556"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M233.588 119.286C233.499 122.237 233.02 125.164 232.163 127.989C231.319 130.844 230.014 133.541 228.299 135.973C226.571 138.453 224.296 140.502 221.65 141.96C218.967 143.39 215.966 144.118 212.927 144.075C209.908 144.089 206.93 143.391 204.232 142.037C202.899 141.358 201.658 140.512 200.539 139.519C199.419 138.539 198.409 137.442 197.525 136.245C195.778 133.844 194.454 131.162 193.611 128.314C192.767 125.467 192.322 122.517 192.287 119.548C192.237 116.563 192.637 113.587 193.472 110.721C194.297 107.826 195.638 105.105 197.43 102.687C199.243 100.252 201.554 98.2315 204.21 96.7613C206.895 95.2882 209.908 94.5187 212.97 94.5244C216.019 94.5952 219.009 95.3858 221.694 96.8318C224.334 98.2897 226.653 100.264 228.514 102.637C230.384 104.967 231.762 107.651 232.567 110.527C233.35 113.378 233.694 116.331 233.588 119.286ZM233.468 119.282C233.501 117.816 233.423 116.349 233.234 114.895C233.037 113.444 232.707 112.015 232.246 110.626C231.328 107.86 229.849 105.314 227.903 103.145C225.993 100.989 223.706 99.199 221.154 97.8627C218.615 96.5618 215.812 95.8607 212.96 95.8135L212.695 95.8039L212.431 95.8221L211.902 95.8546C211.55 95.8819 211.195 95.8843 210.845 95.9306L209.8 96.1099L209.277 96.1986C209.104 96.231 208.936 96.2921 208.766 96.3373C208.078 96.5071 207.405 96.7289 206.752 97.0007L205.766 97.3993C205.443 97.5473 205.128 97.7139 204.808 97.87C202.283 99.2235 200.076 101.1 198.335 103.375C196.589 105.671 195.254 108.252 194.388 111.003C193.504 113.769 193.019 116.648 192.949 119.552C192.87 122.47 193.231 125.384 194.019 128.195C194.797 131.014 196.092 133.664 197.838 136.01C199.591 138.336 201.888 140.198 204.527 141.432C207.158 142.622 210.03 143.182 212.915 143.069C214.346 143.042 215.77 142.86 217.162 142.526C218.547 142.184 219.886 141.679 221.152 141.021C223.688 139.656 225.915 137.782 227.693 135.517C231.296 130.857 233.318 125.17 233.468 119.282Z"
      fill="black"
    />
    <path
      d="M209.337 129.631C209.338 130.57 209.066 131.489 208.554 132.276C208.041 133.062 207.311 133.683 206.452 134.062C205.593 134.44 204.642 134.561 203.716 134.408C202.79 134.255 201.928 133.836 201.236 133.202C200.747 132.746 200.355 132.198 200.083 131.588C199.675 130.661 199.566 129.63 199.772 128.639C199.979 127.648 200.49 126.746 201.234 126.059C201.927 125.426 202.789 125.008 203.715 124.857C204.641 124.705 205.591 124.826 206.45 125.204C207.308 125.583 208.038 126.203 208.551 126.989C209.064 127.775 209.337 128.693 209.337 129.631ZM209.337 129.631C209.337 129.04 209.214 128.454 208.975 127.913C208.736 127.372 208.387 126.886 207.95 126.488C207.527 126.103 207.03 125.809 206.489 125.623C205.949 125.436 205.376 125.362 204.806 125.404C203.739 125.484 202.742 125.964 202.014 126.748C201.286 127.533 200.882 128.563 200.882 129.633C200.882 130.703 201.286 131.733 202.014 132.517C202.742 133.302 203.739 133.782 204.806 133.861C205.376 133.903 205.949 133.829 206.49 133.642C207.03 133.455 207.527 133.161 207.95 132.776C208.386 132.376 208.735 131.89 208.973 131.349C209.212 130.808 209.336 130.223 209.337 129.631Z"
      fill="black"
    />
    <path
      d="M195.398 107.087C195.398 107.087 195.255 106.701 189.581 97.2086C180.766 82.4624 170.785 86.1935 166.505 88.9622C159.37 93.5792 159.253 107.47 159.253 107.47C159.253 107.47 168.386 118.605 167.018 124.019"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M158.451 107.754C158.451 107.754 149.444 100.899 147.051 99.6224C144.658 98.3458 144.526 93.7505 140.105 92.0299C135.277 90.1508 128.202 86.1909 131.645 92.0299C133.241 94.7367 139.678 97.3283 140.105 97.4993"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M132.563 93.2565C132.563 93.2565 125.235 87.7997 128.188 95.157C129.748 99.0441 131.816 103.364 136.088 102.91"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M129.434 98.0861C129.434 98.0861 125.772 93.5125 123.891 95.3422C122.689 96.5133 124.001 99.7833 124.495 100.995C125.845 104.309 126.022 105.965 128.485 108.67C133.097 113.733 135.76 118.111 137.75 124.731"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M156.182 143.164C156.511 143.798 156.878 144.411 157.284 144.999C157.677 145.591 158.11 146.154 158.581 146.686C159.492 147.76 160.616 148.633 161.882 149.25C163.155 149.839 164.581 150.011 165.958 149.744C167.344 149.427 168.66 148.858 169.841 148.065C169.556 148.281 169.273 148.504 168.976 148.706C168.667 148.889 168.375 149.106 168.05 149.264C167.408 149.604 166.727 149.867 166.023 150.047C165.306 150.211 164.568 150.262 163.835 150.198C163.101 150.124 162.384 149.927 161.715 149.616C160.397 148.976 159.244 148.042 158.345 146.885C157.438 145.763 156.708 144.508 156.182 143.164Z"
      fill="black"
    />
    <path
      d="M153.965 84.2571C151.243 84.2404 148.562 84.923 146.179 86.2394C143.796 87.5558 141.791 89.462 140.355 91.7754"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M165.27 83.708C165.27 83.708 181.404 84.0921 187.166 93.6957"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M45.0267 50.6716C34.9098 50.2849 25.8797 56.5389 24.3095 66.6674C23.7789 70.0702 23.5425 73.5124 23.6028 76.9557C23.6106 77.3973 23.4009 81.1591 23.8331 81.3897C35.2845 87.4988 47.4195 83.7067 47.4195 83.7067C46.394 85.7065 51.3505 127.581 27.5932 125.701C3.83587 123.821 7.42511 99.7538 7.59603 93.072C7.76695 86.3902 8.27969 70.6659 4.51954 65.5385C0.759392 60.411 -0.26611 53.7452 2.81039 53.7452C5.88688 53.7452 9.47611 58.8727 9.47611 58.8727C9.47611 58.8727 3.66497 46.9086 8.10879 46.054C12.5526 45.1994 18.1928 56.8217 18.1928 56.8217C18.1928 56.8217 19.2183 44.5968 22.4657 46.0091C25.7132 47.4213 24.004 59.5564 25.0295 59.0436C26.055 58.5309 26.7876 55.2407 29.1315 54.5998C30.8307 54.1352 30.5451 55.2817 30.5451 55.2817"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M54.5031 51.3037C57.6878 51.7942 60.8149 52.604 63.8374 53.7209C65.3561 54.2788 66.8447 54.9153 68.2973 55.6279C69.7534 56.3519 71.1607 57.1703 72.5102 58.0779C75.1874 59.9187 77.6648 62.2072 79.3392 65.0879C79.5473 65.4457 79.7435 65.8146 79.9276 66.1823L80.4585 67.2602L81.4989 69.4268C82.1982 70.8683 82.877 72.32 83.5545 73.7724L83.5619 73.7881C83.6054 73.8816 83.6141 73.9876 83.5864 74.0869C83.5587 74.1862 83.4964 74.2724 83.4107 74.3298C82.6621 74.8312 81.9098 75.3567 81.174 75.8927C80.4369 76.43 79.7168 76.9898 79.0042 77.5595C78.2936 78.1317 77.6058 78.7305 76.9408 79.3559C76.2694 79.9776 75.6559 80.6589 75.1078 81.3916C75.566 80.5891 76.1077 79.8374 76.7239 79.1488C77.3274 78.4477 77.9827 77.7941 78.6517 77.1568C79.3201 76.5181 80.0197 75.9144 80.7286 75.3223C81.4401 74.7304 82.1577 74.1565 82.9133 73.6071L82.7696 74.1643C82.0158 72.75 81.2633 71.3351 80.5313 69.9099L79.4247 67.7764L78.8821 66.7043C78.7042 66.3574 78.5212 66.0207 78.3237 65.6875C76.6513 63.0415 74.4492 60.7703 71.8562 59.017C70.569 58.102 69.2243 57.2706 67.8306 56.5279C66.4419 55.7661 65.0051 55.0863 63.5443 54.4568C60.6079 53.1958 57.5868 52.1422 54.5031 51.3037Z"
      fill="black"
    />
    <path
      d="M74.0347 84.8896C73.1625 86.0569 72.3805 87.2888 71.6954 88.5748C71.3512 89.2088 71.0762 89.878 70.8753 90.5709C70.7808 90.9072 70.7445 91.2573 70.7682 91.6058C70.7767 91.7664 70.8233 91.9227 70.904 92.0617C70.9847 92.2008 71.0973 92.3187 71.2325 92.4058C71.8044 92.7476 72.5604 92.7145 73.2557 92.6291C73.9695 92.519 74.6757 92.3643 75.3702 92.1658C76.0818 91.9426 76.8141 91.7919 77.556 91.7161C77.7833 91.6974 78.0103 91.7565 78.1996 91.8836C78.2515 91.9286 78.2975 91.9799 78.3365 92.0363C78.3655 92.0959 78.3902 92.1575 78.4102 92.2207C78.4304 92.3331 78.4319 92.448 78.4148 92.5609C78.341 92.9451 78.1995 93.313 77.9969 93.6476C77.6106 94.2909 77.1314 94.8736 76.5749 95.3768C76.0327 95.877 75.46 96.3431 74.8602 96.7725C74.2703 97.2066 73.6561 97.6108 73.0906 98.049C72.9536 98.1535 72.8251 98.2688 72.7065 98.3938C72.6593 98.4414 72.621 98.4972 72.5935 98.5583C72.5905 98.5925 72.5811 98.5647 72.6145 98.6007C72.7441 98.6573 72.8891 98.6681 73.0257 98.6313C73.1974 98.6006 73.3666 98.557 73.5318 98.5009C73.8715 98.3916 74.2089 98.2544 74.5541 98.128C74.7271 98.0649 74.9015 98.0027 75.0837 97.9515C75.2799 97.8826 75.4904 97.8651 75.6953 97.9005C75.7622 97.9204 75.8215 97.9601 75.8655 98.0143C75.9095 98.0685 75.9361 98.1348 75.9418 98.2043C75.9501 98.3117 75.9362 98.4196 75.901 98.5213C75.8432 98.7027 75.7679 98.878 75.6761 99.0448C75.4988 99.3716 75.3141 99.6845 75.1171 99.9954C74.7275 100.618 74.2857 101.206 73.7967 101.754C73.5528 102.029 73.2839 102.281 72.9934 102.506C72.8459 102.617 72.6866 102.711 72.5183 102.786C72.4372 102.83 72.348 102.857 72.2562 102.866C72.1643 102.874 72.0716 102.864 71.9837 102.836C72.0715 102.859 72.163 102.864 72.2528 102.851C72.3425 102.837 72.4286 102.806 72.5058 102.758C72.6665 102.675 72.8175 102.575 72.9559 102.458C73.2325 102.224 73.4871 101.965 73.7164 101.684C74.177 101.122 74.5892 100.523 74.9486 99.8923C75.1319 99.5806 75.312 99.261 75.474 98.9421C75.5544 98.7871 75.6197 98.6247 75.6691 98.4572C75.6927 98.3858 75.702 98.3104 75.6962 98.2355C75.6843 98.1745 75.6728 98.1611 75.6227 98.1444C75.4651 98.1307 75.3064 98.1528 75.1586 98.2091C74.9907 98.2609 74.8227 98.3254 74.6546 98.3916C74.318 98.5246 73.9825 98.6713 73.6305 98.7947C73.4516 98.8603 73.268 98.9123 73.0812 98.9503C72.8626 99.01 72.6296 98.9857 72.428 98.8822C72.3568 98.8406 72.302 98.7759 72.2727 98.6988C72.2434 98.6217 72.2413 98.537 72.2669 98.4586C72.3066 98.3499 72.3684 98.2505 72.4483 98.1668C72.5791 98.0254 72.7212 97.895 72.8733 97.7768C73.4579 97.3162 74.0612 96.9131 74.6428 96.4773C75.7929 95.6113 76.9422 94.6735 77.647 93.449C77.8256 93.1599 77.9534 92.8424 78.0249 92.5102C78.0516 92.3531 78.0304 92.2347 77.9569 92.1873C77.8362 92.1172 77.6965 92.0867 77.5575 92.1003C76.8472 92.1717 76.1456 92.3123 75.4626 92.52C74.7519 92.7165 74.0295 92.8681 73.2998 92.974C72.5413 93.1288 71.7526 93.0196 71.0646 92.6646C70.8948 92.5494 70.7543 92.3962 70.6543 92.2171C70.5543 92.038 70.4975 91.838 70.4886 91.633C70.4705 91.2515 70.5186 90.8697 70.6308 90.5046C70.8528 89.7995 71.1519 89.121 71.5227 88.4815C72.2573 87.2155 73.0976 86.014 74.0347 84.8896Z"
      fill="black"
    />
    <path
      d="M83.9963 75.7061C84.6041 76.3647 85.1491 77.0785 85.6242 77.8384C86.1085 78.5961 86.5304 79.392 86.8856 80.2181C87.2336 81.051 87.4953 81.9174 87.6666 82.8037C87.7383 83.2492 87.7824 83.6987 87.7986 84.1496C87.8075 84.5983 87.7791 85.047 87.7138 85.491C87.7012 85.0472 87.6638 84.6045 87.6017 84.1649C87.5479 83.7284 87.4683 83.2954 87.3635 82.8681C87.1359 82.0191 86.8523 81.186 86.5146 80.3745C86.1723 79.5633 85.7752 78.7755 85.3586 77.9953C85.151 77.6045 84.9294 77.2206 84.6978 76.8424C84.4787 76.4554 84.2363 76.0833 83.9963 75.7061Z"
      fill="black"
    />
    <path
      d="M83.4415 221.434C84.9809 234.072 86.6807 244.328 88.153 245.385C88.153 245.385 84.2775 250.776 77.8483 251.08C71.419 251.384 72.1864 245.249 61.4276 245.737"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M46.8744 123.628C46.8744 123.628 54.4188 126.598 61.1503 125.451C67.8818 124.304 76.6822 124.94 76.6822 124.94C76.6822 124.94 82.5265 139.064 81.5808 148.082C81.0189 153.439 80.2383 158.597 79.6567 162.822"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M62.3661 127.669C62.3661 127.669 67.2664 146.437 59.9275 155.961C52.5886 165.485 54.3476 189.652 54.3476 189.652C54.3476 189.652 58.204 253.833 68.264 260.154C68.264 260.154 54.8906 267.609 40.1996 265.279C25.5086 262.948 17.7857 263.631 17.7857 263.631C17.7857 263.631 17.8678 222.964 16.6962 205.727C15.4873 187.941 17.2411 173.62 18.8454 165.057C20.8717 154.242 24.1029 133.487 27.5947 125.701"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M32.3009 264.476C32.3009 264.476 29.2498 269.186 20.5837 270.981C11.9176 272.775 16.4311 276.365 20.5837 277.39C24.7363 278.416 40.1188 279.185 47.0409 276.365C53.963 273.544 59.5136 266.374 65.6665 261.403"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M87.9059 244.258C87.9059 244.258 94.4529 267.729 89.8382 269.267C85.2235 270.805 63.688 269.011 57.7914 269.267"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M87.9064 244.258C87.9064 244.258 93.4455 244.763 93.4455 249.026V267.647L89.8387 269.267"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M92.4199 181.25C91.9257 182.73 91.3905 184.194 90.8489 185.656C90.3083 187.118 89.734 188.567 89.1782 190.023C88.592 191.467 88.022 192.917 87.4206 194.355L86.5111 196.509C86.1942 197.222 85.8903 197.94 85.562 198.648C85.8053 197.906 86.0728 197.174 86.3274 196.437L87.1323 194.242C87.674 192.78 88.247 191.331 88.8038 189.875C89.3909 188.432 89.9596 186.981 90.562 185.543C91.1634 184.105 91.7711 182.669 92.4199 181.25Z"
      fill="black"
    />
    <path
      d="M126.28 157.589C126.144 158.146 126.077 158.737 125.941 159.305C125.816 159.88 125.653 160.445 125.454 160.998C125.258 161.561 124.989 162.095 124.656 162.589C124.482 162.84 124.275 163.067 124.041 163.264C123.766 163.475 123.578 163.561 123.588 163.796C123.61 164.051 123.703 164.294 123.858 164.498C124.013 164.731 124.188 164.951 124.38 165.155C124.773 165.571 125.197 165.958 125.648 166.312C126.556 167.026 127.52 167.665 128.531 168.222C129.533 168.787 130.584 169.259 131.672 169.633C132.205 169.817 132.754 169.958 133.31 170.053C133.842 170.154 134.387 170.154 134.918 170.053C135.163 169.997 135.398 169.902 135.612 169.771C135.817 169.635 135.994 169.461 136.136 169.26C136.42 168.817 136.59 168.311 136.631 167.787C136.72 166.671 136.603 165.548 136.287 164.474L136.282 164.455C136.269 164.407 136.265 164.357 136.272 164.307C136.278 164.258 136.294 164.21 136.319 164.166C136.344 164.123 136.377 164.085 136.416 164.055C136.456 164.024 136.501 164.001 136.549 163.988C136.601 163.974 136.654 163.971 136.707 163.979C142.531 164.981 147.95 167.616 152.335 171.576C153.398 172.586 154.383 173.675 155.281 174.833C157.957 178.321 159.723 182.421 160.42 186.762C159.751 183.95 158.695 181.243 157.282 178.721C155.859 176.224 154.036 173.976 151.886 172.069C149.742 170.165 147.336 168.578 144.743 167.355C143.448 166.744 142.114 166.218 140.75 165.782C139.397 165.334 138.013 164.988 136.609 164.747L137.029 164.253C137.365 165.429 137.479 166.657 137.367 167.875C137.307 168.52 137.087 169.14 136.727 169.679C136.529 169.955 136.282 170.191 135.997 170.376C135.712 170.549 135.399 170.674 135.073 170.745C134.453 170.861 133.817 170.858 133.198 170.736C132.603 170.633 132.018 170.474 131.452 170.264C130.339 169.846 129.266 169.328 128.248 168.716C127.228 168.116 126.258 167.434 125.349 166.676C124.891 166.295 124.462 165.881 124.065 165.436C123.862 165.21 123.68 164.965 123.522 164.705C123.336 164.43 123.236 164.106 123.235 163.774C123.246 163.68 123.269 163.589 123.304 163.501C123.348 163.418 123.406 163.343 123.476 163.279C123.63 163.149 123.736 163.104 123.847 163.017C124.069 162.847 124.267 162.648 124.436 162.426C124.779 161.965 125.06 161.461 125.274 160.928C125.687 159.84 126.023 158.724 126.28 157.589Z"
      fill="black"
    />
    <path
      d="M177.075 50.7154C175.319 40.3839 166.469 31.7504 157.154 31.2388C148.654 30.7719 144.669 35.4113 144.567 37.8263C143.467 37.7119 141.552 37.7655 138.307 38.1618C127.809 39.4437 134.465 51.3029 134.465 51.3029C130.206 56.8617 152.198 48.6644 156.738 48.9557C161.279 49.2469 158.386 63.9996 158.386 63.9996C158.631 63.3601 159.021 62.7862 159.526 62.3232C160.426 60.4175 162.521 59.4489 164.36 60.1499C166.301 60.8893 167.22 63.2049 166.413 65.3218C166.2 65.8994 165.864 66.4236 165.428 66.8579C164.992 67.2922 164.466 67.6262 163.887 67.8365C163.526 67.961 163.223 68.2126 163.033 68.5443C162.844 68.876 162.781 69.2653 162.857 69.6396C163.28 71.6942 163.766 73.7554 164.074 75.0229C164.11 75.1748 164.181 75.3164 164.28 75.4367C164.38 75.557 164.506 75.6528 164.648 75.7167C164.791 75.7806 164.946 75.811 165.102 75.8054C165.258 75.7998 165.411 75.7585 165.549 75.6846C173.442 71.3489 178.888 61.3761 177.075 50.7154Z"
      stroke="black"
      strokeWidth="0.144286"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M163.088 62.1032C163.088 62.1032 165.621 61.5016 165.679 64.0123"
      stroke="black"
      strokeWidth="0.221844"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M135.637 113.426C118.033 112.571 113.455 117.094 111.276 125.218C110.144 129.437 110.617 135.593 105.82 136.014C101.16 136.422 99.5765 139.498 102.623 143.748C98.3099 143.265 92.8783 142.269 90.3557 147.154C86.4041 154.805 96.9807 155.191 95.7076 159.781C94.4345 164.37 81.4587 159.153 78.4472 165.935C75.4357 172.718 78.6675 174.88 78.8144 179.712C78.9613 184.543 68.5607 183.557 74.6423 194.31C76.7306 198.003 76.3032 201.355 73.1508 204.372C69.8967 207.485 67.804 209.385 71.8201 212.926C74.2375 215.058 76.6962 217.217 79.6863 218.695C84.4894 221.069 92.4278 221.143 95.3305 216.126C93.1595 215.192 90.9449 214.509 89.4673 212.695C85.129 207.368 92.3712 196.984 99.4825 196.872C104.231 196.798 108.038 199.344 112.497 196.67C117.193 193.852 116.659 189.512 115.726 185.273C115.49 184.202 115.489 183.016 116.183 182.109C117.071 180.947 118.822 180.57 120.42 180.479C123.492 180.372 126.563 180.708 129.54 181.476C130.544 181.712 136.473 184.02 137.11 183.178C137.348 182.863 137.154 182.445 136.953 182.111C135.775 180.152 134.542 178.247 133.362 176.328C137.237 176.495 138.648 174.296 138.648 174.296C134.942 174.852 131.355 171.093 128.844 167.53C128.811 167.441 128.775 167.354 128.743 167.265C128.276 165.978 127.812 164.525 127.397 162.969C131.799 165.001 134.722 160.898 134.722 160.898C129.41 160.942 126.878 154.865 125.89 151.542C125.897 151.317 125.904 151.092 125.916 150.868C126.463 151.78 127.552 153.09 129.722 154.688C134.081 157.897 136.65 155.457 136.65 155.457C136.65 155.457 133.183 153.658 131.096 148.259C130.226 146.008 129.492 143.999 128.932 142.419C128.275 141.954 127.741 141.336 127.375 140.618C127.01 139.901 126.825 139.105 126.836 138.3C126.836 135.614 128.832 133.436 131.294 133.436C133.756 133.436 135.753 135.614 135.753 138.3C135.753 138.637 135.72 138.973 135.656 139.305C136.695 139.766 138.349 139.765 140.952 138.313C146.926 134.98 147.061 131.676 150.617 134.98C151.937 136.207 153.176 135.707 154.284 135.599C154.87 137.549 155.345 137.88 154.284 140.657C152.829 144.463 158.393 142.537 158.451 134.697C158.513 126.268 153.242 114.281 135.637 113.426Z"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M131.879 136.137C131.879 136.137 129.325 134.401 128.202 137.158"
      stroke="black"
      strokeWidth="0.263046"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M21.9523 96.987C21.8258 95.6763 21.8288 94.3564 21.9612 93.0463C22.0574 91.735 22.2218 90.4315 22.3951 89.1302C22.5816 87.8307 22.7845 86.534 23.0267 85.244L23.4004 83.3113C23.5429 82.6703 23.6722 82.0271 23.8324 81.3896L23.5951 83.344L23.3327 85.2929L22.7939 89.1858L22.2681 93.0773C22.1885 93.7263 22.1087 94.3761 22.0552 95.0273C21.9837 95.6781 21.9494 96.3323 21.9523 96.987Z"
      fill="black"
    />
    <path
      d="M135.752 161.485C135.752 161.485 134.846 163.952 135.752 164.157"
      stroke="black"
      strokeWidth="0.187679"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M37.4274 44.5262L43.6949 42.1927V37.3032C42.7574 36.8133 42.0343 35.9939 41.6648 35.0029C40.8581 32.8859 41.7773 30.5703 43.7179 29.8308C45.6585 29.0914 47.8855 30.2081 48.6922 32.3251C48.9642 33.0339 49.0461 33.8014 48.9298 34.5516L51.8543 33.664C51.8543 33.664 45.9535 22.4782 51.8543 16.7843C57.1682 11.6568 69.6085 20.8862 70.7469 30.2244C70.6687 29.5835 71.1103 28.5715 71.2232 27.9376C71.5662 26.0229 71.787 24.0883 71.8843 22.1456C72.1239 17.2691 71.6439 11.8776 68.8204 7.73293C66.102 3.74246 61.4896 2.02656 56.7719 1.95041C51.3761 1.86332 44.1631 6.5618 41.6575 11.2722C41.6575 11.2722 34.7828 9.74128 31.1559 15.8915C24.1056 27.8468 37.4274 44.5262 37.4274 44.5262"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M44.991 31.7878C44.991 31.7878 42.4573 31.1861 42.4 33.6969"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M75.5452 77.5615C76.0803 81.2019 82.4211 119.367 82.4211 119.367C82.4211 119.367 83.1535 124.94 76.6823 124.939"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M77.4876 34.1885C78.0037 33.8667 82.5982 29.2119 82.5979 29.2116C80.9951 27.6088 79.3652 25.4266 77.4882 24.2305C76.7704 27.0648 76.7508 31.3891 77.4876 34.1885Z"
      fill="black"
    />
    <path
      d="M143.085 32.6325C142.95 32.8083 142.755 32.7489 142.139 32.7673C140.431 32.8141 140.738 32.1624 140.734 30.5786C140.73 29.4848 140.735 28.3912 140.747 27.2975C140.76 25.96 140.584 25.6425 141.975 25.6577C143.02 25.6691 143.064 25.4948 143.297 26.4771C143.65 27.9662 143.8 30.6048 143.313 32.07C143.263 32.267 143.186 32.4563 143.085 32.6325Z"
      fill="black"
    />
    <path
      d="M147.72 32.5977C147.561 32.7657 147.234 32.7686 146.557 32.7686C145.513 32.7441 145.617 32.8716 145.342 31.9418C144.901 30.1705 144.884 28.32 145.292 26.5407C145.552 25.5667 145.441 25.7143 146.48 25.6589C148.198 25.5751 147.875 26.2935 147.875 27.8472C147.875 29.0316 147.884 30.2164 147.875 31.4008C147.87 32.0847 147.882 32.4267 147.72 32.5977Z"
      fill="black"
    />
    <path
      d="M210.539 175.227C210.489 174.56 210.355 173.902 210.14 173.268C209.684 171.976 208.916 170.816 207.905 169.892C206.894 168.967 205.67 168.307 204.343 167.968C205.156 169.223 208.13 167.993 208.36 164.141C208.444 162.732 207.908 160.349 207.175 159.176C205.544 156.569 202.308 155.067 199.524 154.051C195.071 152.45 190.172 152.626 185.844 154.541C183.693 155.49 181.685 156.737 179.88 158.244C178.137 159.678 176.708 162.102 174.479 162.551C173.425 162.793 172.456 163.314 171.673 164.06C169.527 166.008 168.537 169.438 165.319 169.904C162.161 170.36 161.228 173.577 160.848 176.299C160.639 177.797 160.643 179.313 160.462 180.809C160.325 181.943 159.828 183.148 159.945 184.302C160.042 185.259 160.811 186.156 160.564 187.143C160.231 188.471 158.703 189.001 159.725 190.513C160.176 191.128 160.496 191.828 160.666 192.571C160.846 193.522 160.571 194.536 160.992 195.461C164.362 202.881 168.138 202.572 168.941 202.849C169.102 202.904 169.21 202.884 169.279 202.806C172.081 206.279 175.899 208.788 180.199 209.982C192.071 213.442 201.639 207.09 208.056 197.615C207.411 198.566 206.235 198.988 205.123 199.279C201.235 200.26 197.176 200.356 193.246 199.559C184.677 197.861 175.14 191.705 175.745 181.903C175.766 180.96 176.1 180.051 176.694 179.318C177.503 178.437 178.603 178.633 179.632 178.195C180.475 177.836 181.006 177.111 181.498 176.375C181.752 175.996 182.307 174.871 182.875 174.861C183.656 174.847 183.873 176.738 184.398 177.271C186.239 179.139 187.399 177.105 188.071 175.52C188.728 173.971 189.255 171.127 190.823 170.252C191.919 169.64 193.413 170 194.534 170.334C199.84 171.914 205.466 175.472 207.804 180.669C207.942 180.975 208.193 181.349 208.512 181.246C208.629 181.196 208.728 181.113 208.798 181.007C210.079 179.365 210.701 177.304 210.539 175.227ZM170.132 189.836C167.58 189.836 165.511 187.579 165.511 184.795C165.511 182.011 167.58 179.754 170.132 179.754C172.685 179.754 174.754 182.011 174.754 184.795C174.754 187.579 172.685 189.836 170.132 189.836ZM178.54 197.324C179.381 197.921 180.229 198.5 181.075 199.09C182.283 199.932 183.141 201.804 182.429 202.931C182.241 203.19 181.997 203.403 181.715 203.555C181.433 203.706 181.12 203.792 180.801 203.806C178.98 204.04 177.399 202.616 176.118 201.528C174.935 200.525 173.023 199.381 173.613 197.517C173.721 197.188 173.906 196.89 174.154 196.649C174.402 196.408 174.705 196.23 175.036 196.131C176.181 195.802 177.638 196.684 178.54 197.324V197.324Z"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M171.606 182.5C171.606 182.5 169.007 180.733 167.863 183.54"
      stroke="black"
      strokeWidth="0.267789"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M481.399 189.795C482.064 190.386 482.705 191.001 483.355 191.607C484.008 192.21 484.637 192.836 485.277 193.451L485.257 193.433C485.533 193.68 485.767 193.97 485.949 194.292C486.132 194.623 486.246 194.987 486.284 195.362C486.334 196.122 486.084 196.871 485.588 197.448L485.423 197.666C485.364 197.732 485.298 197.792 485.236 197.855L484.854 198.228C484.579 198.444 484.298 198.652 484.016 198.854L483.13 199.383C482.827 199.54 482.519 199.685 482.212 199.833C480.969 200.446 479.619 200.811 478.236 200.908C477.502 200.933 476.775 200.752 476.139 200.384C475.981 200.284 475.832 200.17 475.694 200.044C475.562 199.913 475.441 199.77 475.334 199.617C475.114 199.311 474.963 198.961 474.891 198.591L474.89 198.586C474.887 198.573 474.886 198.559 474.887 198.546C474.92 197.729 474.948 196.912 474.999 196.095C475.045 195.278 475.083 194.461 475.151 193.644C475.218 194.461 475.256 195.278 475.303 196.095C475.353 196.912 475.381 197.729 475.414 198.546L475.41 198.5C475.576 199.066 475.958 199.543 476.473 199.828C477.013 200.096 477.614 200.216 478.215 200.177C479.489 200.039 480.729 199.675 481.875 199.103C482.166 198.959 482.465 198.828 482.753 198.681L483.587 198.197C483.846 198.015 484.103 197.829 484.354 197.638L484.694 197.322C484.75 197.269 484.811 197.218 484.864 197.164L485.005 196.987C485.407 196.562 485.627 195.996 485.616 195.411C485.603 195.121 485.531 194.838 485.406 194.576C485.273 194.311 485.101 194.068 484.895 193.854L484.875 193.836C484.289 193.169 483.693 192.511 483.12 191.832C482.544 191.155 481.959 190.487 481.399 189.795Z"
      fill="black"
    />
    <path
      d="M482.746 170.036C482.746 170.036 480.592 168.572 479.645 170.897"
      stroke="black"
      strokeWidth="0.221844"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M470.921 193.599C481.1 193.599 489.352 185.347 489.352 175.168C489.352 164.988 481.1 156.736 470.921 156.736C460.741 156.736 452.489 164.988 452.489 175.168C452.489 185.347 460.741 193.599 470.921 193.599Z"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M457.953 175.408C458.444 175.408 458.842 175.01 458.842 174.519C458.842 174.028 458.444 173.63 457.953 173.63C457.462 173.63 457.064 174.028 457.064 174.519C457.064 175.01 457.462 175.408 457.953 175.408Z"
      fill="black"
    />
    <path
      d="M457.064 174.519C457.064 174.695 457.116 174.867 457.214 175.013C457.312 175.159 457.45 175.273 457.613 175.34C457.775 175.407 457.954 175.425 458.126 175.391C458.299 175.356 458.457 175.272 458.582 175.147C458.706 175.023 458.791 174.865 458.825 174.692C458.859 174.52 458.842 174.341 458.774 174.179C458.707 174.016 458.593 173.877 458.447 173.78C458.301 173.682 458.129 173.63 457.953 173.63C457.836 173.63 457.721 173.653 457.613 173.698C457.505 173.742 457.407 173.808 457.324 173.89C457.242 173.973 457.176 174.071 457.132 174.179C457.087 174.287 457.064 174.402 457.064 174.519Z"
      stroke="black"
      strokeWidth="0.248154"
      strokeLinejoin="round"
    />
    <path
      d="M467.245 176.946C467.736 176.946 468.134 176.548 468.134 176.057C468.134 175.566 467.736 175.168 467.245 175.168C466.754 175.168 466.356 175.566 466.356 176.057C466.356 176.548 466.754 176.946 467.245 176.946Z"
      fill="black"
    />
    <path
      d="M466.356 176.057C466.356 176.233 466.408 176.405 466.506 176.551C466.604 176.697 466.743 176.811 466.905 176.878C467.067 176.946 467.246 176.963 467.419 176.929C467.591 176.895 467.749 176.81 467.874 176.686C467.998 176.561 468.083 176.403 468.117 176.23C468.151 176.058 468.134 175.879 468.066 175.717C467.999 175.554 467.885 175.415 467.739 175.318C467.593 175.22 467.421 175.168 467.245 175.168C467.009 175.168 466.783 175.262 466.617 175.428C466.45 175.595 466.356 175.821 466.356 176.057V176.057Z"
      stroke="black"
      strokeWidth="0.248154"
      strokeLinejoin="round"
    />
    <path
      d="M462.393 178.528C462.064 178.783 461.141 180.099 461.927 180.874"
      stroke="black"
      strokeWidth="0.187679"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M476.071 181.793C476.071 181.793 476.195 186.375 472.392 186.708"
      stroke="black"
      strokeWidth="0.41133"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M509.792 151.428C507.105 151.254 504.408 151.402 501.756 151.87C499.103 152.317 496.545 153.212 494.191 154.516C494.182 154.522 494.171 154.525 494.16 154.527C494.149 154.528 494.138 154.527 494.127 154.524C494.116 154.522 494.106 154.517 494.097 154.51C494.088 154.503 494.081 154.494 494.075 154.485L494.074 154.483C493.02 152.602 491.605 150.947 489.911 149.612C489.892 149.597 489.877 149.577 489.869 149.555C489.861 149.532 489.858 149.508 489.863 149.484C489.867 149.46 489.878 149.438 489.893 149.42C489.909 149.402 489.93 149.388 489.953 149.381L489.955 149.38C492.624 148.478 495.105 147.094 497.275 145.298C499.464 143.537 501.317 141.397 502.748 138.98C503.455 137.78 504.01 136.497 504.4 135.16C504.798 133.839 504.946 132.456 504.836 131.081C504.74 129.723 504.222 128.428 503.354 127.378C502.487 126.328 501.312 125.576 499.996 125.226C498.672 124.861 497.291 124.746 495.925 124.887C494.544 125.015 493.184 125.314 491.878 125.779C486.59 127.715 482.14 131.429 479.29 136.286C478.6 137.494 478.07 138.788 477.715 140.134C477.355 141.47 477.262 142.864 477.441 144.236L477.442 144.241C477.447 144.273 477.445 144.306 477.437 144.337C477.429 144.368 477.415 144.398 477.396 144.424C477.376 144.45 477.352 144.472 477.324 144.488C477.297 144.505 477.266 144.516 477.234 144.521C477.216 144.523 477.198 144.524 477.18 144.523C472.79 144.193 468.364 145.276 464.409 147.21C460.436 149.179 456.905 151.934 454.028 155.307C452.582 156.982 451.339 158.821 450.324 160.786C449.299 162.743 448.592 164.85 448.231 167.03C447.872 169.206 448.067 171.438 448.798 173.519C449.566 175.583 450.883 177.398 452.606 178.769L452.307 178.874C452.6 177.506 452.952 176.158 453.357 174.821C453.754 173.478 454.241 172.163 454.816 170.885C455.106 170.24 455.45 169.619 455.844 169.03C456.233 168.401 456.771 167.878 457.41 167.506C458.109 167.209 458.891 167.166 459.618 167.386C460.302 167.568 460.972 167.797 461.624 168.073C462.87 168.637 464.183 169.043 465.53 169.281C466.853 169.478 468.204 169.207 469.349 168.517C469.922 168.163 470.451 167.744 470.927 167.268C471.433 166.789 471.943 166.314 472.457 165.843C472.975 165.375 473.493 164.907 474.032 164.456C474.3 164.229 474.573 164.006 474.859 163.791C475.003 163.683 475.147 163.578 475.311 163.476C475.396 163.42 475.485 163.371 475.578 163.327C475.608 163.313 475.64 163.301 475.672 163.291L475.724 163.274C475.749 163.265 475.774 163.26 475.801 163.259C475.836 163.255 475.871 163.254 475.906 163.256C475.976 163.262 476.044 163.286 476.102 163.326C476.18 163.379 476.235 163.46 476.257 163.551C476.274 163.621 476.272 163.693 476.252 163.762L476.255 163.575C476.945 166.124 477.468 168.716 477.821 171.333C477.864 171.661 477.895 171.993 477.924 172.325L477.966 172.81L477.991 173.032L477.997 173.066L477.996 173.06C477.99 173.046 477.984 173.032 477.978 173.018C477.972 173.008 477.966 172.998 477.959 172.989C477.947 172.972 477.933 172.956 477.918 172.941C477.858 172.88 477.778 172.842 477.692 172.836C477.635 172.832 477.577 172.841 477.523 172.862C477.482 172.878 477.445 172.902 477.413 172.932C477.396 172.95 477.38 172.968 477.366 172.988C477.357 173 477.35 173.013 477.344 173.027L477.351 173.003L477.579 172.061C477.664 171.736 477.76 171.411 477.874 171.089C478.096 170.427 478.422 169.805 478.839 169.245C479.282 168.645 479.912 168.209 480.629 168.005C481.344 167.838 482.092 167.879 482.784 168.123C483.439 168.344 484.062 168.648 484.638 169.029C484.925 169.208 485.197 169.419 485.474 169.621C485.745 169.84 486 170.076 486.239 170.329C486.746 170.85 487.115 171.488 487.313 172.187C487.483 172.909 487.434 173.665 487.172 174.359C486.915 175.015 486.551 175.623 486.096 176.16C485.205 177.192 484.155 178.075 482.985 178.776L482.922 178.014C483.31 178.174 483.679 178.375 484.025 178.613C484.198 178.725 484.356 178.858 484.521 178.981C484.674 179.119 484.832 179.253 484.979 179.398C485.574 179.987 486.028 180.703 486.306 181.493C486.378 181.689 486.435 181.889 486.477 182.094L486.552 182.397L486.585 182.706C486.602 182.912 486.637 183.119 486.637 183.324L486.616 183.94C486.612 184.144 486.588 184.347 486.546 184.547L486.444 185.148C486.344 185.538 486.221 185.921 486.109 186.307L485.387 185.895C486.309 184.759 487.187 183.552 488.017 182.328C488.849 181.102 489.632 179.845 490.368 178.558C491.111 177.276 491.79 175.959 492.414 174.619C493.038 173.28 493.593 171.91 494.077 170.514L494.079 170.508C494.097 170.457 494.125 170.411 494.161 170.371C494.197 170.332 494.241 170.299 494.289 170.276C494.338 170.254 494.39 170.24 494.444 170.238C494.497 170.235 494.551 170.243 494.601 170.261C494.63 170.272 494.657 170.285 494.682 170.301C496.986 171.722 499.495 172.78 502.12 173.437C504.751 174.118 507.454 174.483 510.172 174.525C512.891 174.583 515.606 174.293 518.251 173.66C520.904 173.069 523.405 171.935 525.598 170.33C526.134 169.922 526.631 169.464 527.083 168.964C527.539 168.47 527.935 167.925 528.264 167.339C528.935 166.17 529.247 164.829 529.163 163.484C529.117 162.813 528.979 162.151 528.753 161.517C528.516 160.884 528.211 160.278 527.843 159.71C527.085 158.577 526.156 157.569 525.088 156.722C522.914 155.052 520.462 153.78 517.845 152.965C515.234 152.123 512.529 151.606 509.792 151.428ZM509.797 151.347C512.544 151.509 515.261 152.011 517.885 152.84C520.526 153.645 523.004 154.91 525.204 156.577C526.303 157.421 527.264 158.432 528.053 159.572C528.44 160.151 528.764 160.771 529.018 161.419C529.264 162.076 529.418 162.763 529.477 163.461C529.587 164.872 529.281 166.284 528.597 167.522C528.263 168.139 527.858 168.715 527.391 169.238C526.932 169.765 526.425 170.248 525.876 170.681C523.655 172.369 521.108 173.578 518.397 174.232C515.708 174.925 512.94 175.257 510.163 175.219C507.387 175.205 504.622 174.86 501.927 174.191C499.212 173.539 496.618 172.458 494.244 170.988L494.849 170.775C494.358 172.2 493.794 173.598 493.16 174.965C492.527 176.33 491.84 177.669 491.088 178.97C490.342 180.275 489.55 181.55 488.71 182.797C487.867 184.044 486.992 185.254 486.035 186.437C485.974 186.512 485.889 186.564 485.794 186.584C485.7 186.604 485.601 186.59 485.515 186.546C485.429 186.501 485.361 186.429 485.322 186.34C485.284 186.251 485.277 186.152 485.303 186.058L485.313 186.025C485.413 185.67 485.526 185.318 485.618 184.963L485.707 184.424C485.746 184.246 485.766 184.066 485.769 183.884L485.788 183.344C485.787 183.165 485.755 182.989 485.741 182.812L485.714 182.546L485.648 182.288C485.613 182.115 485.564 181.945 485.503 181.779C485.266 181.108 484.879 180.501 484.372 180.002C483.871 179.497 483.278 179.091 482.626 178.806L482.616 178.801C482.544 178.77 482.482 178.72 482.436 178.656C482.391 178.592 482.364 178.517 482.359 178.439C482.353 178.36 482.37 178.282 482.406 178.213C482.442 178.143 482.496 178.084 482.563 178.044C483.649 177.397 484.627 176.582 485.459 175.63C485.856 175.168 486.175 174.643 486.403 174.077C486.611 173.537 486.654 172.948 486.526 172.384C486.363 171.816 486.062 171.297 485.65 170.874C485.44 170.65 485.215 170.44 484.976 170.245C484.723 170.06 484.479 169.866 484.209 169.697C483.692 169.351 483.132 169.073 482.544 168.871C481.994 168.67 481.398 168.63 480.826 168.756C480.271 168.915 479.785 169.254 479.444 169.719C479.075 170.213 478.787 170.761 478.59 171.345C478.483 171.641 478.391 171.944 478.31 172.253L478.07 173.221C478.064 173.243 478.052 173.278 478.038 173.314C478.024 173.347 478.007 173.378 477.988 173.408C477.957 173.457 477.915 173.498 477.866 173.529C477.816 173.559 477.761 173.578 477.703 173.585C477.645 173.591 477.587 173.584 477.532 173.564C477.478 173.545 477.428 173.513 477.388 173.472C477.369 173.454 477.352 173.434 477.339 173.412L477.314 173.368C477.302 173.346 477.292 173.322 477.284 173.298L477.266 173.233L477.25 173.146C477.236 173.049 477.228 172.964 477.22 172.879L477.179 172.385C477.153 172.063 477.124 171.742 477.084 171.42C476.935 170.133 476.706 168.848 476.452 167.569C476.196 166.291 475.91 165.012 475.589 163.753L475.592 163.566C475.576 163.613 475.575 163.664 475.587 163.712C475.605 163.783 475.647 163.845 475.705 163.889C475.746 163.916 475.792 163.934 475.84 163.941C475.853 163.944 475.867 163.944 475.88 163.942C475.899 163.938 475.902 163.936 475.894 163.94L475.884 163.945C475.875 163.949 475.874 163.945 475.857 163.954C475.792 163.985 475.729 164.02 475.669 164.059C475.537 164.139 475.398 164.237 475.264 164.337C474.993 164.537 474.724 164.751 474.46 164.97C473.929 165.407 473.411 165.866 472.893 166.325C472.378 166.788 471.866 167.256 471.358 167.728C470.844 168.23 470.274 168.671 469.659 169.043C469.029 169.414 468.341 169.674 467.623 169.813C466.907 169.944 466.175 169.955 465.455 169.847C464.063 169.592 462.709 169.161 461.426 168.567C460.8 168.295 460.155 168.067 459.497 167.885C458.885 167.687 458.224 167.71 457.627 167.949C457.06 168.28 456.582 168.743 456.233 169.299C455.849 169.863 455.512 170.458 455.226 171.078C454.649 172.332 454.156 173.623 453.751 174.943C453.337 176.262 452.973 177.603 452.67 178.95L452.67 178.953C452.664 178.977 452.654 178.999 452.64 179.019C452.626 179.039 452.608 179.056 452.588 179.069C452.567 179.082 452.544 179.091 452.52 179.095C452.496 179.099 452.472 179.099 452.448 179.093C452.42 179.087 452.393 179.074 452.371 179.056C450.615 177.629 449.28 175.751 448.512 173.622C447.774 171.492 447.583 169.211 447.956 166.988C448.329 164.782 449.053 162.649 450.099 160.67C451.134 158.694 452.386 156.84 453.83 155.14C456.718 151.723 460.267 148.926 464.263 146.916C468.235 144.912 472.715 143.748 477.215 144.029L476.953 144.316C476.746 142.877 476.825 141.411 477.186 140.002C477.536 138.604 478.068 137.258 478.767 135.997C480.169 133.485 482.024 131.254 484.239 129.418C486.428 127.548 488.937 126.089 491.645 125.111C493.006 124.622 494.422 124.305 495.862 124.166C497.319 124.021 498.79 124.154 500.198 124.558C501.639 124.954 502.92 125.79 503.865 126.948C504.81 128.105 505.371 129.529 505.47 131.02C505.579 132.474 505.413 133.936 504.98 135.329C504.556 136.705 503.961 138.024 503.21 139.253C501.712 141.696 499.787 143.849 497.526 145.61C495.296 147.398 492.758 148.762 490.036 149.636L490.081 149.404C491.776 150.782 493.184 152.481 494.224 154.402L494.107 154.369C496.482 153.069 499.062 152.182 501.734 151.747C504.396 151.292 507.103 151.158 509.797 151.347Z"
      fill="black"
    />
    <path
      d="M528.863 162.759C528.557 156.573 519.188 153.582 514.217 152.423C510.564 151.574 506.803 151.294 503.065 151.594C500.08 151.836 497.17 152.367 495.052 154.525C494.857 154.618 494.67 154.728 494.493 154.852C493.717 153.394 492.727 152.06 491.556 150.895C495.572 149.35 498.963 146.521 501.203 142.848C503.153 139.656 505.369 133.899 503.759 129.939C503.493 128.278 502.785 126.763 501.207 125.755C498.409 123.968 494.844 124.888 491.91 125.743C491.896 125.747 491.882 125.755 491.868 125.76C491.109 125.911 490.366 126.126 489.644 126.402C488.112 127.028 486.752 128.012 485.678 129.271C483.529 130.976 481.774 133.124 480.532 135.569C479.29 138.013 478.59 140.698 478.48 143.438C478.462 143.648 478.517 143.857 478.637 144.03C475.738 144.062 472.852 144.424 470.034 145.108C467.089 145.827 463.874 146.914 461.892 149.233C460.07 149.922 458.402 150.966 456.985 152.303C455.568 153.64 454.43 155.244 453.636 157.024C452.848 157.782 452.18 158.655 451.655 159.614C450.083 161.785 449.125 164.339 448.882 167.009C448.768 168.313 448.824 169.626 449.047 170.916C448.94 172.027 449.061 173.147 449.401 174.21C449.574 174.733 449.799 175.238 450.073 175.717C450.024 175.773 449.991 175.841 449.979 175.914C449.967 175.986 449.975 176.061 450.003 176.13C450.483 177.172 451.199 178.089 452.095 178.806C452.205 178.856 452.33 178.861 452.444 178.821C452.595 178.777 452.734 178.696 452.847 178.585C452.854 178.578 452.861 178.569 452.868 178.561C453.055 178.456 453.195 178.284 453.26 178.079C453.681 176.576 453.975 174.909 454.484 173.352C454.66 173.174 454.786 172.953 454.85 172.711C454.91 172.437 454.977 172.168 455.053 171.905C455.501 170.888 456.174 169.986 457.02 169.266C457.537 168.831 458.146 168.518 458.801 168.352C459.371 168.232 459.957 168.202 460.537 168.262C462.851 168.903 465.224 169.141 467.646 168.411C470.405 167.579 472.724 165.864 474.846 163.956C475.034 163.931 475.224 163.935 475.411 163.966C475.73 164.016 476.038 164.125 476.317 164.287C476.411 164.337 476.512 164.373 476.617 164.394L476.974 168.319C476.971 168.436 476.999 168.551 477.056 168.653C477.113 168.755 477.197 168.84 477.298 168.898C477.187 169.669 477.163 170.451 477.228 171.228C477.249 171.477 477.603 171.427 477.752 171.37C477.878 171.327 477.992 171.255 478.086 171.16C478.179 171.065 478.249 170.949 478.29 170.822C478.333 170.661 478.376 170.5 478.419 170.338C478.434 170.297 478.435 170.251 478.421 170.209C478.406 170.167 478.378 170.131 478.341 170.107C478.462 170.016 478.546 169.884 478.579 169.735C478.596 169.629 478.62 169.524 478.651 169.42L478.656 169.402L478.659 169.394L478.67 169.366C478.688 169.316 478.709 169.266 478.731 169.217C478.773 169.122 478.828 169.036 478.872 168.943C478.801 169.092 478.879 168.936 478.906 168.897C478.937 168.853 478.969 168.81 479.002 168.767C479.032 168.729 479.065 168.692 479.096 168.654C478.974 168.807 479.092 168.662 479.128 168.626C479.154 168.601 479.181 168.576 479.208 168.552C479.26 168.558 479.313 168.56 479.366 168.559C479.834 168.516 480.28 168.339 480.649 168.049C480.881 168.08 481.124 168.139 481.292 168.159L482.713 168.329C482.894 168.348 483.077 168.341 483.256 168.31C484.254 168.826 485.131 169.55 485.828 170.432C486.524 171.314 487.025 172.335 487.297 173.425C487.108 173.647 486.978 173.912 486.919 174.197C486.869 174.482 486.82 174.773 486.761 175.061C486.596 175.187 486.454 175.339 486.34 175.513C486.055 176.04 485.603 176.458 485.055 176.701C484.468 176.97 482.867 178.407 483.96 179.038C484.533 179.345 485.015 179.8 485.355 180.354C485.695 180.909 485.882 181.544 485.896 182.195C485.889 182.288 485.903 182.381 485.939 182.468C485.974 182.554 486.03 182.63 486.101 182.691C486.172 182.752 486.256 182.795 486.346 182.817C486.437 182.839 486.532 182.839 486.622 182.818C486.609 182.988 486.595 183.157 486.582 183.327C486.509 183.417 486.473 183.531 486.48 183.646C486.49 183.692 486.513 183.733 486.546 183.765L486.496 184.393C486.474 184.66 486.723 184.735 486.948 184.665C487.18 184.594 487.534 184.369 487.556 184.091L487.627 183.214L488.716 181.757C488.764 181.692 488.799 181.618 488.818 181.539C488.879 181.472 488.931 181.397 488.972 181.316C489.824 179.362 490.658 177.397 491.416 175.406C491.499 175.337 491.577 175.264 491.658 175.192C492.251 174.894 492.796 174.509 493.275 174.05C493.415 173.915 493.613 173.597 493.375 173.453C493.339 173.432 493.298 173.419 493.256 173.413C493.273 173.371 493.283 173.327 493.288 173.282C493.877 172.326 494.359 171.308 494.724 170.246C495.232 170.369 495.741 170.487 496.252 170.598C496.253 170.603 496.255 170.608 496.256 170.613C496.239 170.666 496.239 170.724 496.258 170.777C496.277 170.829 496.313 170.874 496.36 170.905C497.562 171.752 498.879 172.631 500.315 172.969C503.321 174.376 506.648 174.957 509.953 174.655C511.51 174.726 513.07 174.616 514.601 174.325C514.617 174.547 514.849 174.585 515.052 174.534C516.965 174.051 518.829 173.393 520.621 172.568C520.852 172.484 521.081 172.395 521.306 172.296C521.938 172.085 522.568 171.858 523.194 171.595C523.572 171.439 523.9 171.181 524.142 170.852C526.042 170.048 527.569 168.377 528.837 166.772C528.975 166.618 529.07 166.431 529.112 166.229C529.154 166.027 529.143 165.818 529.079 165.622C529.298 165.168 529.394 164.664 529.356 164.161C529.318 163.659 529.148 163.175 528.863 162.759ZM494.266 128.732C495.024 128.579 495.803 128.547 496.571 128.64C496.241 128.764 495.936 128.883 495.675 128.981C495.19 129.161 494.71 129.357 494.233 129.562C494.311 129.439 494.355 129.297 494.361 129.152C494.367 129.006 494.334 128.861 494.266 128.732ZM452.522 177.152C452.446 177.053 452.369 176.955 452.293 176.856C452.412 176.805 452.527 176.748 452.638 176.683C452.599 176.839 452.561 176.996 452.522 177.152ZM456.353 168.911C456.591 168.512 456.854 168.132 457.127 167.76C457.151 167.747 457.174 167.734 457.197 167.722C457.283 167.677 457.371 167.635 457.459 167.596C457.504 167.576 457.549 167.558 457.593 167.539L457.602 167.536L457.624 167.528C457.704 167.499 457.785 167.473 457.866 167.449C457.912 167.436 457.959 167.425 458.005 167.413C458.195 167.485 458.384 167.559 458.574 167.628C457.757 167.907 457.003 168.343 456.353 168.911V168.911ZM464.613 149.656L464.608 149.655C464.762 149.516 464.923 149.386 465.092 149.266L465.101 149.265C465.236 149.248 465.365 149.201 465.48 149.128C465.594 149.055 465.691 148.957 465.763 148.841C466.626 148.384 467.544 148.038 468.494 147.813C467.168 148.357 465.872 148.972 464.613 149.656L464.613 149.656ZM473.646 147.937C473.187 148.056 472.73 148.181 472.274 148.311C472.406 148.138 472.495 147.936 472.535 147.722C472.575 147.508 472.564 147.288 472.503 147.079C473.049 146.998 473.596 146.935 474.144 146.881C473.853 147.159 473.676 147.535 473.646 147.937V147.937ZM484.194 135.743C484.856 134.649 485.676 133.66 486.627 132.807C485.729 133.71 484.915 134.692 484.194 135.743V135.743ZM487.814 147.946C487.649 147.849 487.483 147.756 487.315 147.667C487.428 147.636 487.542 147.598 487.656 147.556C487.687 147.693 487.741 147.823 487.816 147.941L487.814 147.946ZM488.262 139.944C488.232 139.976 488.201 140.006 488.171 140.038C487.613 140.671 487.096 141.338 486.622 142.035C486.563 141.986 486.508 141.932 486.457 141.875C486.413 141.821 486.372 141.764 486.336 141.704C487.241 140.649 488.104 139.563 488.924 138.445C489.007 138.396 489.088 138.345 489.171 138.297C488.844 138.831 488.538 139.378 488.262 139.944V139.944ZM495.836 156.651C495.7 156.772 495.582 156.91 495.483 157.062C495.448 156.969 495.415 156.875 495.379 156.783C495.531 156.737 495.683 156.695 495.836 156.651V156.651ZM497.132 161.793C496.853 161.831 496.573 161.861 496.294 161.903C495.989 161.982 495.703 162.118 495.449 162.304C495.46 162.091 495.466 161.877 495.47 161.663C496.024 161.702 496.578 161.748 497.132 161.793V161.793ZM496.749 165.752C496.551 165.588 496.355 165.42 496.162 165.248C496.014 165.14 495.84 165.072 495.658 165.05C495.476 165.028 495.291 165.054 495.121 165.125C495.149 164.974 495.173 164.824 495.197 164.673C495.933 164.812 496.668 164.951 497.403 165.09C497.162 165.287 496.943 165.509 496.749 165.752V165.752ZM500.855 155.565C504.073 155.093 507.343 155.092 510.561 155.561C507.33 155.342 504.087 155.344 500.855 155.565V155.565ZM522.984 162.256C523.142 162.378 523.3 162.5 523.458 162.622C523.487 162.678 523.517 162.733 523.544 162.789C523.258 162.665 522.971 162.547 522.681 162.437C522.782 162.383 522.884 162.322 522.984 162.256V162.256ZM517.201 159.922C517.285 159.875 517.368 159.823 517.45 159.768C517.571 159.821 517.691 159.876 517.809 159.934C517.607 159.93 517.404 159.926 517.201 159.922V159.922ZM523.598 166.15C522.083 166.178 520.569 166.181 519.057 166.158C518.822 166.113 518.587 166.068 518.352 166.024C519.887 166.011 521.422 166.002 522.957 165.996C523.253 165.959 523.537 165.856 523.788 165.694C523.736 165.85 523.672 166.002 523.598 166.15V166.15Z"
      fill="black"
      stroke="black"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M494.149 154.442C494.149 154.442 494.798 152.829 495.952 153.835C497.105 154.841 498.131 171.51 495.952 171.509C493.836 171.508 494.463 170.644 494.463 170.644C494.463 170.644 495.679 161.607 494.149 154.442Z"
      fill="#F04B2D"
    />
    <path
      d="M476.699 144.191C476.699 144.191 475.547 142.889 476.963 142.307C478.378 141.725 493.746 148.262 492.771 150.211C491.823 152.103 491.331 151.156 491.331 151.156C491.331 151.156 483.792 146.026 476.699 144.191Z"
      fill="#F04B2D"
    />
    <path
      d="M571.433 140.715L571.431 140.715C571.454 140.716 571.477 140.709 571.496 140.697C571.476 140.705 571.455 140.711 571.433 140.715L571.433 140.715Z"
      fill="black"
    />
    <path
      d="M641.891 193.109C641.72 193.214 641.519 193.259 641.319 193.237C641.119 193.215 640.932 193.127 640.788 192.988C637.512 192.424 633.363 192.308 630.622 190.225C628.707 188.771 627.946 186.563 627.665 184.247C628.139 184.058 628.565 183.766 628.913 183.393C629.261 183.02 629.522 182.574 629.678 182.088C631.498 175.632 633.348 167.692 628.388 162.089C626.067 159.467 623.449 159.088 620.193 158.448C618.361 158.088 617.034 157.35 616.786 155.377C616.634 154.168 616.77 152.888 616.108 151.798C615.408 150.647 614.228 150.281 612.973 150.034C611.31 149.775 609.677 149.348 608.1 148.76C604.986 147.48 602.245 145.437 600.128 142.819C598.92 141.311 597.898 138.959 596.17 137.903C595.754 137.439 595.23 137.085 594.644 136.874C594.057 136.662 593.428 136.6 592.812 136.693C592.112 136.802 591.446 137.07 590.866 137.477C590.573 137.5 590.293 137.608 590.062 137.789C589.311 135.718 588.805 133.565 588.554 131.376C588.186 128.126 589.179 123.534 585.957 121.421C585.396 121.062 584.761 120.835 584.1 120.758C583.439 120.68 582.769 120.753 582.14 120.972C579.662 121.328 577.524 123.048 576.065 125.032C575.217 126.236 574.484 127.518 573.874 128.858C573.569 129.387 573.306 129.939 573.089 130.51C572.341 132.464 571.829 134.501 571.566 136.577C569.183 136.14 566.708 137.052 564.878 138.706C564.708 138.748 564.548 138.826 564.409 138.934C564.271 139.042 564.157 139.179 564.075 139.334C563.44 140.615 563.005 141.985 562.783 143.398C562.378 145.046 562.25 146.75 562.404 148.44C562.465 149.108 563.88 148.376 563.824 147.762C563.807 147.58 563.804 147.399 563.794 147.217C563.913 147.108 563.993 146.964 564.021 146.805C564.272 144.862 564.899 142.985 565.868 141.282C566.391 141.072 566.871 140.768 567.284 140.385C567.707 139.98 568.354 139.982 568.919 140.078C568.985 140.092 569.049 140.11 569.113 140.131C569.111 140.323 569.153 140.512 569.235 140.685C569.316 140.858 569.436 141.011 569.585 141.131C570.061 141.473 570.701 141.209 571.12 140.908C571.185 140.861 571.251 140.816 571.317 140.771C571.355 140.752 571.393 140.733 571.431 140.716C571.428 140.717 571.424 140.717 571.42 140.717C571.425 140.717 571.429 140.716 571.433 140.715C571.489 140.69 571.501 140.692 571.493 140.699C571.525 140.687 571.557 140.673 571.572 140.669C571.615 140.657 571.659 140.649 571.701 140.637L571.702 140.637L571.709 140.636C571.797 140.626 571.885 140.616 571.974 140.614C571.973 140.614 572.019 140.614 572.05 140.613C572.076 140.615 572.126 140.618 572.135 140.619C572.232 140.629 572.328 140.645 572.423 140.667C572.467 140.677 572.509 140.689 572.552 140.701C572.568 140.705 572.577 140.707 572.583 140.708C572.589 140.711 572.599 140.716 572.622 140.725C572.652 140.735 572.683 140.744 572.714 140.75C572.775 140.804 572.853 140.836 572.935 140.842C572.94 141.045 573.082 141.187 573.351 141.169C573.549 141.148 573.739 141.077 573.903 140.964C574.066 140.851 574.199 140.698 574.289 140.521C574.659 139.505 575.689 139.208 576.654 138.979C576.711 138.966 576.768 138.956 576.825 138.944L576.863 138.958C576.276 140.027 576.285 141.205 577.794 141.871C578.906 142.33 579.975 142.887 580.989 143.536C581.04 143.602 581.092 143.667 581.138 143.737C581.926 144.943 581.448 145.666 580.73 146.688C579.948 147.8 578.746 149.592 579.892 150.86C580.957 152.037 583.569 151.486 584.9 151.307C585.817 151.181 586.725 151.005 587.622 150.779C587.957 151.154 588.229 151.581 588.425 152.044C588.476 152.179 588.517 152.316 588.557 152.454C588.458 152.577 588.407 152.732 588.415 152.89C588.429 152.955 588.463 153.014 588.512 153.059C588.56 153.104 588.622 153.133 588.688 153.141C588.866 153.163 589.047 153.129 589.206 153.045C589.399 152.958 589.565 152.823 589.69 152.653C589.836 152.424 589.982 152.195 590.128 151.965C590.14 151.949 590.153 151.934 590.165 151.917C590.231 151.916 590.296 151.905 590.357 151.883C591.527 151.463 592.796 151.401 594.002 151.705C594.284 151.858 594.557 152.028 594.819 152.214C594.829 152.219 594.84 152.223 594.851 152.227C595.147 152.576 595.384 152.972 595.551 153.398C595.78 153.979 595.938 154.585 596.023 155.203C595.779 155.472 595.625 155.811 595.583 156.171C595.57 156.385 595.545 156.597 595.514 156.806C594.141 158.175 592.768 159.544 591.396 160.913C591.156 161.148 590.952 161.417 590.79 161.711C590.705 161.745 590.624 161.788 590.548 161.839C590.382 161.948 590.247 162.099 590.158 162.277C590.121 162.338 590.102 162.408 590.101 162.48C590.1 162.551 590.118 162.621 590.152 162.684C590.192 162.729 590.24 162.765 590.295 162.789C590.35 162.814 590.409 162.825 590.469 162.824C590.499 162.862 590.538 162.893 590.583 162.913C590.633 162.938 590.681 162.966 590.727 162.996C590.798 163.111 590.888 163.213 590.993 163.298C591.187 163.466 591.365 163.651 591.523 163.853C591.658 164.055 591.811 164.245 591.981 164.419C592.589 165.007 593.41 165.094 594.214 165.164C596.451 166.204 598.771 167.233 600.994 168.414C601.065 168.643 601.21 168.842 601.408 168.978C603.844 170.771 605.812 173.012 607.669 175.362C607.64 175.593 607.676 175.827 607.773 176.038C610.094 181.053 612.577 185.986 615.222 190.836C615.671 192.463 616.229 194.058 616.893 195.61C616.857 195.642 616.827 195.676 616.793 195.708C616.66 195.68 616.523 195.682 616.39 195.713C616.258 195.744 616.134 195.804 616.028 195.889C616.021 195.894 616.01 195.904 616.002 195.91L615.788 195.886C615.739 195.882 615.689 195.893 615.645 195.916L615.571 195.756C615.534 195.675 615.385 195.742 615.339 195.774C615.273 195.82 615.202 195.902 615.24 195.985C615.474 196.495 615.709 197.005 615.943 197.515C615.947 197.522 615.952 197.528 615.958 197.533C615.964 197.538 615.971 197.541 615.979 197.543C615.969 197.569 615.97 197.597 615.98 197.623C616.36 198.444 616.739 199.266 617.119 200.088C617.14 200.133 617.192 200.137 617.248 200.121C617.724 201.436 618.354 202.69 619.123 203.859C619.064 204.003 619.057 204.163 619.103 204.313C620.241 207.624 625.952 207.12 628.864 206.652C632.656 206.963 636.802 205.977 637.526 202.01C637.585 201.84 637.589 201.655 637.538 201.481C637.487 201.308 637.384 201.155 637.241 201.043C638.078 199.209 638.643 197.226 640.276 195.918C640.532 195.701 640.763 195.458 640.967 195.192C642.019 195.124 643.525 193.109 641.891 193.109ZM617.144 162.694C616.254 162.406 615.365 162.119 614.476 161.832C614.127 161.468 613.786 161.093 613.459 160.698C612.986 159.827 612.571 158.926 612.219 158C611.995 156.65 611.319 155.416 610.3 154.502C609.281 153.588 607.982 153.048 606.615 152.972C606.2 152.704 605.761 152.475 605.304 152.288L605.295 152.272C606.556 152.764 607.86 153.139 609.191 153.392C610.491 153.637 611.89 153.571 612.31 155.094C612.608 156.176 612.399 157.34 612.712 158.428C613.424 160.91 615.93 161.744 618.232 162.093C621.126 162.53 623.35 163.251 625.121 165.735C626.011 166.986 626.641 168.403 626.972 169.903C626.276 168.505 625.337 167.243 624.2 166.173C622.855 164.908 621.244 163.961 619.485 163.402C618.718 163.124 617.936 162.888 617.144 162.694ZM630.158 195.752C629.491 195.306 628.882 194.78 628.345 194.185C630.138 195.149 632.242 195.609 634.327 195.946C632.935 196.075 631.532 196.01 630.158 195.752Z"
      fill="black"
    />
    <path
      d="M203.233 116.246L203 116.335C203.217 115.854 203.434 115.374 203.652 114.894C204.185 113.715 203.114 113.537 202.334 113.954C202.708 113.545 203.099 112.956 203.005 112.392C202.988 112.279 202.944 112.171 202.876 112.078C202.808 111.985 202.719 111.91 202.616 111.86C202.512 111.81 202.398 111.786 202.284 111.789C202.169 111.793 202.057 111.825 201.957 111.882C200.302 112.574 198.885 113.732 197.877 115.216C196.87 116.7 196.317 118.445 196.285 120.238C196.273 121.016 197.233 120.835 197.65 120.584C198.103 120.303 198.446 119.875 198.621 119.371C198.766 119.305 198.903 119.221 199.027 119.12C199.318 118.883 199.609 118.647 199.9 118.41L199.88 118.454C199.544 119.196 200.01 119.939 200.832 119.626C201.506 119.37 202.181 119.113 202.855 118.857C203.222 118.701 203.544 118.457 203.792 118.145C204.039 117.833 204.204 117.464 204.272 117.072C204.345 116.394 203.892 115.995 203.233 116.246Z"
      fill="#F04B2D"
    />
    <path
      d="M218.487 104.311C218.345 104.144 218.171 104.008 217.975 103.911C217.78 103.813 217.566 103.757 217.348 103.744C216.108 102.215 214.483 101.043 212.641 100.351C211.219 99.825 209.683 100.516 208.634 101.527C208.114 102.029 206.915 103.816 207.788 104.529C207.661 104.734 207.577 104.962 207.541 105.201C207.505 105.439 207.518 105.682 207.579 105.915C207.692 106.252 207.787 106.595 207.862 106.942C207.48 107.252 207.168 107.64 206.947 108.08C206.727 108.52 206.602 109.001 206.582 109.493C206.591 110.112 206.599 110.73 206.608 111.348C206.62 112.179 207.702 112.437 208.329 112.379C209.909 112.233 211.489 112.087 213.069 111.94C214.577 111.801 216.05 111.656 217.341 110.763C219.716 109.12 220.354 106.573 218.487 104.311Z"
      fill="#F6BED7"
    />
    <path
      d="M230.831 118.563C230.636 117.402 230.194 116.297 229.534 115.322C228.875 114.348 228.013 113.527 227.008 112.914C225.539 112.002 222.325 114.481 222.852 115.918C221.773 115.915 220.339 116.875 219.886 117.555C219.065 118.789 218.526 120.339 219.353 121.73C220.057 122.914 221.432 123.291 222.723 123.217C223.366 123.149 223.983 122.921 224.515 122.553C225.047 122.185 225.478 121.688 225.768 121.11C225.824 120.984 225.866 120.852 225.893 120.717C226.052 120.863 226.211 121.009 226.371 121.155C227.795 122.465 231.161 120.461 230.831 118.563Z"
      fill="#F0DC01"
    />
    <path
      d="M226.176 130.797C226.069 130.649 225.927 130.528 225.764 130.446C225.6 130.364 225.419 130.323 225.236 130.325C224.774 129.419 222.838 129.989 222.147 130.492C222.073 130.545 221.999 130.599 221.925 130.653C221.496 129.828 219.405 130.42 218.8 130.821C218.485 130.432 217.86 130.258 217.076 130.439C215.231 130.9 213.592 131.961 212.416 133.455C211.762 134.223 211.732 135.416 212.831 135.706C212.885 135.72 212.939 135.728 212.994 135.737C213.242 136.275 213.896 136.564 214.801 136.256C215.358 136.066 215.903 135.858 216.436 135.631C216.029 137.369 218.971 136.574 219.632 136.093C220.125 135.734 220.619 135.375 221.113 135.016C221.885 135.217 223.118 134.79 223.64 134.422C224.057 134.128 224.473 133.835 224.89 133.541C225.612 133.033 226.845 131.764 226.176 130.797Z"
      fill="#15A97D"
    />
    <path
      d="M209.976 178.249C210.019 178.159 210.048 178.063 210.06 177.965C210.208 176.643 210.172 175.308 209.953 173.996C209.782 173.035 209.57 171.961 208.74 171.384C208.349 170.27 207.618 169.308 206.651 168.631C206.574 168.585 206.486 168.563 206.397 168.566C206.384 168.553 206.374 168.54 206.361 168.527C206.431 168.491 206.496 168.455 206.553 168.422C209.136 166.92 210.486 164.202 208.714 161.523C207.783 160.162 206.579 159.009 205.178 158.138C203.499 156.644 201.531 155.51 199.395 154.808C197.26 154.106 195.003 153.85 192.764 154.057C190.429 153.85 188.078 154.172 185.885 154.999C183.321 155.962 181.124 157.706 179.604 159.985C178.836 160.782 178.144 161.65 177.539 162.577C175.534 162.668 173.627 163.467 172.157 164.832C170.567 165.989 169.352 167.707 168.411 169.562C167.663 169.721 166.947 170.005 166.292 170.4C165.216 170.672 164.238 171.237 163.466 172.034C162.014 173.578 161.595 175.528 161.467 177.535C161.069 179.184 160.824 180.866 160.735 182.56C160.509 183.103 160.408 183.689 160.44 184.277C160.553 185.227 160.781 186.161 161.119 187.057C160.916 187.39 160.763 187.751 160.664 188.129C160.526 188.703 160.506 189.299 160.606 189.881C160.597 190.128 160.617 190.376 160.664 190.618C160.638 191.41 161.03 192.093 161.2 192.969C161.38 193.895 161.474 194.769 161.612 195.601C161.544 196.074 161.636 196.556 161.871 196.971C161.892 197.004 161.916 197.032 161.939 197.062C162.256 198.148 162.876 199.121 163.726 199.868C164.004 200.116 164.3 200.341 164.614 200.541C164.98 201.097 165.45 201.576 166 201.951C166.961 202.583 168.101 202.889 169.249 202.824C169.841 204.396 171.115 205.505 172.671 206.245C174.02 207.446 175.628 208.319 177.371 208.794C177.919 209.316 178.569 209.719 179.281 209.977C179.993 210.235 180.75 210.343 181.506 210.294C181.564 210.289 181.622 210.281 181.679 210.27C186.139 211.55 190.925 211.011 194.989 208.771C195.811 208.376 196.608 207.933 197.377 207.444C201.361 206.265 204.779 203.676 206.992 200.16C207.194 199.992 207.347 199.772 207.434 199.525C207.885 198.916 208.177 198.204 208.284 197.455C208.325 197.167 207.93 197.256 207.797 197.362C207.312 197.75 206.799 198.102 206.261 198.413C206.003 198.49 205.761 198.617 205.551 198.786C203.236 199.52 200.833 199.939 198.406 200.032C194.106 199.744 189.602 199.444 185.663 197.543C183.455 196.418 181.471 194.898 179.81 193.058C178.658 191.684 177.737 190.132 177.084 188.462C177.023 188.298 176.908 188.161 176.758 188.073C176.785 187.999 176.796 187.92 176.789 187.841C176.782 187.763 176.757 187.687 176.717 187.619C176.676 187.551 176.621 187.494 176.556 187.45C176.49 187.406 176.416 187.378 176.338 187.367C176.33 187.259 176.322 187.151 176.318 187.041C176.326 186.945 176.309 186.849 176.268 186.761C176.227 186.674 176.163 186.599 176.083 186.545L175.98 184.266C175.98 184.231 175.967 184.198 175.943 184.173C175.903 183.484 175.862 182.795 175.822 182.106C175.805 181.811 175.759 181.416 175.732 180.993C175.831 180.946 175.917 180.873 175.979 180.782C176.331 179.986 176.928 179.324 177.683 178.891C177.777 178.829 177.858 178.751 177.924 178.661C178.007 178.673 178.09 178.679 178.174 178.679C178.819 178.648 179.447 178.465 180.009 178.146C180.57 177.826 181.048 177.379 181.404 176.84C181.562 176.627 181.664 176.378 181.702 176.116C182.059 175.736 182.395 175.337 182.709 174.92C182.782 175.347 182.905 175.763 183.077 176.161C183.213 176.545 183.425 176.897 183.701 177.196C183.977 177.495 184.311 177.735 184.683 177.902C184.717 177.913 184.751 177.921 184.785 177.931C184.789 177.938 184.794 177.944 184.799 177.95C184.841 178.003 184.894 178.046 184.955 178.077C185.015 178.107 185.082 178.124 185.15 178.126C185.522 178.208 185.911 178.151 186.244 177.965C186.626 177.787 186.959 177.518 187.212 177.18C187.302 177.052 187.381 176.915 187.446 176.772C187.7 176.424 187.913 176.047 188.079 175.649C188.386 175.192 188.613 174.685 188.749 174.151C188.959 173.877 189.089 173.549 189.124 173.205C189.125 173.192 189.124 173.176 189.125 173.163L189.611 172.016C190.188 171.106 190.942 170.364 192.083 170.153C194.124 169.776 196.253 170.879 198.038 171.709C198.076 171.724 198.115 171.735 198.155 171.744C198.94 172.237 199.676 172.748 200.337 173.195C200.57 173.343 200.843 173.417 201.119 173.408C203.699 175.126 205.836 177.43 207.356 180.133C207.422 180.242 207.518 180.332 207.632 180.39C207.746 180.449 207.874 180.475 208.002 180.464C208 180.471 207.999 180.478 207.999 180.486L208.028 180.824C208.035 180.898 208.124 180.895 208.186 180.877L208.194 180.889L208.204 180.97C208.21 181.02 208.261 181.033 208.306 181.032C208.361 181.097 208.422 181.157 208.486 181.213C208.527 181.247 208.609 181.219 208.649 181.2C208.71 181.171 208.761 181.123 208.793 181.064C208.889 180.89 208.985 180.717 209.081 180.543C209.218 180.348 209.334 180.139 209.426 179.919C209.437 179.894 209.438 179.866 209.43 179.84C209.95 179.393 210.284 178.79 210.006 178.299C209.996 178.282 209.985 178.266 209.976 178.249ZM207.461 198.196C207.423 198.329 207.379 198.461 207.328 198.589C207.259 198.53 207.181 198.482 207.097 198.447C207.22 198.365 207.341 198.282 207.461 198.196ZM174.444 187.044C174.111 187.247 173.819 187.511 173.583 187.822C172.711 189.518 171.156 189.94 169.353 189.552C169.087 189.513 168.815 189.556 168.573 189.675L167.392 188.876C167.248 188.785 167.079 188.739 166.908 188.745C166.791 188.591 166.682 188.431 166.581 188.266C166.537 188.195 166.48 188.133 166.412 188.084C166.408 188.06 166.403 188.035 166.398 188.011C166.385 187.896 166.338 187.788 166.263 187.7C166.188 187.611 166.089 187.547 165.978 187.515L165.974 187.502C165.975 187.475 165.974 187.449 165.975 187.423C165.986 187.253 165.947 187.083 165.862 186.935C165.524 184.932 165.831 182.872 166.74 181.055C166.794 181.025 166.846 180.99 166.895 180.951L166.875 180.967C166.888 180.957 166.901 180.946 166.914 180.936C166.941 180.915 166.967 180.895 166.994 180.875C167.048 180.835 167.103 180.797 167.158 180.76C167.212 180.724 167.266 180.69 167.321 180.657L167.344 180.644C167.37 180.63 167.395 180.616 167.421 180.602C167.536 180.542 167.653 180.487 167.774 180.439L167.807 180.426C167.835 180.415 167.864 180.405 167.893 180.395C167.956 180.373 168.02 180.354 168.084 180.335C168.185 180.305 168.277 180.251 168.353 180.178C168.421 180.118 168.468 180.04 168.49 179.952C168.49 179.934 168.487 179.917 168.481 179.9C169.803 179.564 171.2 179.684 172.445 180.241C172.645 180.514 172.845 180.787 173.045 181.06C173.105 181.126 173.179 181.177 173.263 181.207C173.346 181.237 173.436 181.246 173.524 181.233L173.528 181.233C174.439 183.025 174.76 185.059 174.444 187.044V187.044ZM176.991 196.54C177.987 197.077 178.893 197.767 179.676 198.584C180.487 199.365 181.262 200.186 182.05 200.992C182.101 201.424 182.126 201.858 182.125 202.293C182.093 202.443 182.053 202.59 182.01 202.736C181.916 202.831 181.837 202.939 181.777 203.058C181.692 203.186 181.608 203.315 181.524 203.444C181.261 203.467 180.997 203.463 180.735 203.432C179.44 203.273 178.696 202.297 177.674 201.616C177.382 201.43 177.075 201.269 176.755 201.136C175.35 199.818 174.51 198.168 175.371 196.211C175.419 196.162 175.468 196.112 175.509 196.062C176.023 196.15 176.522 196.311 176.991 196.54V196.54ZM181.722 165.765C181.529 165.866 181.341 165.977 181.16 166.099C180.654 166.447 180.187 166.849 179.767 167.297C179.539 167.289 179.311 167.294 179.084 167.311C178.863 167.222 178.635 167.149 178.404 167.091C177.508 166.886 176.568 167.022 175.768 167.474C174.317 168.26 173.786 169.578 173.748 171.043C173.718 171.124 173.687 171.205 173.663 171.288C173.651 169.719 173.709 167.629 174.758 166.713C175.782 165.818 178.456 166.633 179.83 166.31C180.643 166.112 181.418 165.778 182.119 165.321C181.985 165.467 181.853 165.615 181.722 165.765V165.765ZM194.121 159.513C190.657 159.617 187.321 160.847 184.619 163.018C185.524 161.908 186.284 160.78 187.652 160.132C190.505 158.783 194.004 158.868 197.019 159.743C196.062 159.58 195.092 159.503 194.121 159.513V159.513Z"
      fill="black"
    />
    <path
      d="M158.907 134.526C159.012 133.159 158.757 131.789 158.165 130.553C157.573 129.317 156.666 128.258 155.535 127.483C155.198 125.202 154.245 123.057 152.777 121.278C150.772 118.801 148.013 117.076 145.083 115.896C143.35 115.213 141.571 114.654 139.76 114.222C139.743 114.217 139.725 114.218 139.707 114.216C137.348 113.415 134.87 113.018 132.379 113.042C128.83 113.089 125.357 113.989 122.066 115.269C122.049 115.251 122.033 115.232 122.016 115.214C122.016 115.214 119.47 107.291 107.943 113.043C96.4155 118.795 97.603 124.765 92.7236 126.256C87.8442 127.746 85.4065 122.918 85.4065 122.918C85.4065 122.918 81.4223 131.478 86.5226 136.378C90.1442 139.857 95.9411 142.36 101.851 141.266C102.725 142.508 103.645 143.705 104.612 144.857C104.618 144.955 104.628 145.053 104.635 145.151C103.411 144.88 102.171 144.688 100.922 144.576C100.12 144.518 99.314 144.572 98.527 144.737C97.2889 144.567 96.0283 144.694 94.8484 145.105C92.0849 146.099 91.005 148.309 91.0212 150.948C90.6034 153.042 91.9591 154.691 93.8112 155.991C94.8585 156.72 95.9615 157.365 97.11 157.921C97.1462 159.067 97.0153 160.213 96.7214 161.321C96.2978 161.662 95.838 161.955 95.3503 162.195C94.3771 162.444 93.4 162.691 92.4251 162.953C92.2841 162.961 92.1432 162.969 92.0008 162.969C91.9166 162.971 91.8331 162.984 91.7525 163.008C88.0615 162.551 83.9288 162.627 81.1468 165.447C79.6289 166.577 78.6131 168.256 78.3163 170.125C77.8454 173.041 78.6236 176.212 79.6802 178.942C79.5054 179.686 79.3118 180.426 79.0993 181.161C77.8681 181.733 76.7185 182.465 75.6806 183.34C73.7534 184.987 71.9559 187.484 72.4877 190.166C72.8627 192.057 74.2849 193.198 75.7539 194.244C76.8251 196.498 77.5382 198.905 77.8675 201.379C76.6964 203.875 74.2366 205.323 73.0813 207.847C71.5771 211.135 73.4495 213.526 75.9559 215.526C78.6259 217.657 81.486 219.54 84.9136 220.119C86.8731 220.451 89.0596 219.086 90.1762 217.554C90.9433 216.502 91.2447 215.168 90.4132 214.398C90.4162 214.227 90.3829 214.058 90.3156 213.901C90.2483 213.745 90.1486 213.604 90.0229 213.489C89.4051 212.907 88.8523 212.259 88.374 211.558C88.2505 207.323 89.0563 202.165 92.4506 199.261C95.9811 196.239 101.348 198.201 105.557 197.212C110.876 195.963 114.769 192.003 115.2 186.522C115.282 185.479 115.384 184.442 115.507 183.409C116.095 182.812 116.509 182.066 116.705 181.251C117.211 178.876 118.561 178.435 120.846 179.12C123.79 180.002 126.026 181.575 129.157 181.692C130.011 182.079 130.895 182.397 131.799 182.645C133.168 183.071 134.537 183.496 135.906 183.922C136.259 184.032 136.756 183.727 136.995 183.497C137.183 183.316 137.507 182.875 137.281 182.611C136.156 181.298 134.971 179.921 134.486 178.227C134.54 178.099 134.586 177.968 134.623 177.834C135.457 177.671 136.244 177.324 136.928 176.819C137.611 176.314 138.174 175.663 138.575 174.913C138.629 174.839 138.658 174.751 138.659 174.66C138.661 174.568 138.633 174.479 138.581 174.404C138.53 174.329 138.456 174.272 138.37 174.241C138.284 174.21 138.191 174.206 138.103 174.231C138.069 174.234 138.036 174.242 138.002 174.248C137.925 174.223 137.844 174.211 137.762 174.214C137.569 174.22 137.377 174.222 137.184 174.215C137.243 174.219 137.226 174.218 137.133 174.213C137.078 174.21 137.023 174.206 136.968 174.202C136.886 174.196 136.803 174.188 136.721 174.18C136.337 174.14 135.956 174.076 135.58 173.987C135.235 173.906 134.896 173.802 134.564 173.677C133.476 172.926 132.469 172.063 131.559 171.104C131.51 170.857 131.389 170.629 131.21 170.451C129.242 168.484 127.901 165.977 127.358 163.248C127.647 163.351 127.943 163.435 128.243 163.501C128.723 163.575 129.214 163.482 129.633 163.238C129.94 163.341 130.254 163.423 130.573 163.482C132.005 163.747 134.728 160.892 132.76 160.529C128.892 159.815 127.904 155.103 125.982 152.015C125.957 151.441 125.942 150.867 125.936 150.293C126.285 150.868 126.708 151.394 127.196 151.857C127.775 152.392 128.418 152.853 129.112 153.228C130.677 154.76 132.616 155.857 134.736 156.409C135.183 156.525 135.74 156.138 135.989 155.798C136.216 155.486 136.279 155.049 135.829 154.932C135.646 154.884 135.467 154.821 135.287 154.764C135.472 154.498 135.511 154.226 135.221 154.071C134.662 153.773 134.078 153.512 133.488 153.258C133.054 152.971 132.649 152.642 132.281 152.275C132.276 152.208 132.258 152.143 132.227 152.084C130.679 149.262 129.727 146.152 129.43 142.947C129.402 142.65 129.16 142.577 128.864 142.638C128.865 142.628 128.87 142.619 128.871 142.609L128.875 142.436C128.867 142.382 128.847 142.332 128.816 142.287C128.785 142.243 128.745 142.206 128.698 142.179L128.693 142.176C128.69 142.133 128.686 142.09 128.682 142.048C128.66 141.783 128.465 141.698 128.212 141.726C127.85 141.373 127.507 141 127.186 140.61C126.825 139.402 126.671 138.141 126.732 136.882C126.784 136.673 126.839 136.465 126.907 136.26C126.984 136.145 127.065 136.034 127.15 135.926C127.169 135.903 127.188 135.88 127.207 135.857C127.242 135.82 127.276 135.779 127.311 135.743C127.409 135.643 127.513 135.548 127.619 135.456C127.628 135.449 127.637 135.442 127.646 135.435C127.708 135.388 127.772 135.343 127.836 135.299C128.044 135.162 128.212 134.974 128.324 134.752C128.368 134.654 128.391 134.547 128.39 134.439C128.402 134.431 128.415 134.422 128.428 134.414C128.5 134.366 128.575 134.317 128.65 134.273C128.659 134.269 128.665 134.266 128.683 134.256C128.739 134.227 128.794 134.196 128.85 134.167C129.061 134.058 129.279 133.967 129.496 133.872C129.552 133.852 129.609 133.832 129.665 133.814C129.773 133.778 129.882 133.744 129.991 133.713C130.113 133.679 130.235 133.648 130.358 133.621C130.374 133.617 130.39 133.614 130.405 133.611C130.984 133.723 131.538 133.936 132.043 134.24C132.367 134.47 132.678 134.718 132.974 134.982C133.03 135.04 133.088 135.095 133.14 135.155C133.913 136.067 134.347 137.218 134.371 138.412C134.402 139.025 134.662 139.528 135.326 139.606C135.722 139.637 136.121 139.583 136.495 139.448C138.241 139.326 139.944 138.846 141.497 138.039C143.05 137.232 144.42 136.114 145.524 134.755C145.526 134.753 145.528 134.749 145.53 134.746C145.9 134.456 146.259 134.156 146.607 133.845C147.158 133.631 147.752 133.548 148.341 133.604C149.087 134.403 150.025 134.998 151.066 135.335C151.077 135.368 151.096 135.398 151.12 135.424C151.144 135.45 151.173 135.47 151.205 135.485C151.852 135.747 152.553 135.845 153.247 135.77C153.524 135.838 153.806 135.88 154.09 135.896C154.665 137.844 154.753 139.904 154.346 141.894C154.248 142.37 154.77 142.422 155.1 142.349C155.406 142.28 155.699 142.166 155.971 142.012C155.946 143.058 155.866 144.102 155.732 145.14C157.647 144.214 159.205 142.687 160.169 140.791C161.085 139.037 160.053 136.51 158.907 134.526ZM101.776 174.77C100.692 175.569 97.2756 178.603 95.7309 177.167C98.9189 175.35 102.051 173.439 105.126 171.435C104.206 172.728 103.073 173.856 101.776 174.77H101.776ZM119.533 132.759C121.557 130.001 123.955 127.351 127.31 127.164C127.326 127.267 127.35 127.367 127.384 127.465C124.316 128.447 121.593 130.284 119.533 132.759H119.533Z"
      fill="black"
    />
    <path
      d="M112.96 65.54H129.338"
      stroke="black"
      strokeWidth="0.144286"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M81.3094 65.54H87.0627"
      stroke="black"
      strokeWidth="0.144286"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M81.7359 63.9022C82.1161 63.9022 82.4243 63.594 82.4243 63.2138C82.4243 62.8336 82.1161 62.5254 81.7359 62.5254C81.3557 62.5254 81.0475 62.8336 81.0475 63.2138C81.0475 63.594 81.3557 63.9022 81.7359 63.9022Z"
      fill="black"
    />
    <path
      d="M82.424 63.2147C82.4238 63.4046 82.3534 63.5877 82.2263 63.7288C82.0992 63.8699 81.9244 63.9589 81.7356 63.9788C81.6289 63.9893 81.5212 63.9773 81.4194 63.9436C81.3177 63.91 81.2241 63.8554 81.1447 63.7834C81.0653 63.7114 81.0018 63.6236 80.9584 63.5256C80.915 63.4276 80.8925 63.3216 80.8925 63.2144C80.8925 63.1072 80.915 63.0012 80.9584 62.9032C81.0018 62.8052 81.0653 62.7174 81.1447 62.6454C81.2241 62.5734 81.3177 62.5188 81.4194 62.4851C81.5212 62.4515 81.6289 62.4395 81.7356 62.45C81.9245 62.47 82.0993 62.5592 82.2264 62.7004C82.3535 62.8416 82.4238 63.0248 82.424 63.2147ZM82.424 63.2147C82.4246 63.1275 82.4065 63.0412 82.3711 62.9616C82.3356 62.8819 82.2836 62.8107 82.2184 62.7528C82.1533 62.6948 82.0765 62.6515 81.9932 62.6256C81.9099 62.5997 81.8221 62.5919 81.7356 62.6027C81.5871 62.6224 81.4509 62.6954 81.3522 62.808C81.2535 62.9207 81.1991 63.0653 81.1991 63.2151C81.1991 63.3649 81.2535 63.5095 81.3522 63.6222C81.4509 63.7348 81.5871 63.8078 81.7356 63.8275C81.8221 63.8382 81.91 63.8303 81.9933 63.8043C82.0765 63.7784 82.1533 63.7349 82.2185 63.6769C82.2836 63.619 82.3357 63.5477 82.3711 63.468C82.4065 63.3883 82.4246 63.302 82.424 63.2147Z"
      fill="black"
    />
    <path
      d="M83.9258 63.9022C84.3059 63.9022 84.6141 63.594 84.6141 63.2138C84.6141 62.8336 84.3059 62.5254 83.9258 62.5254C83.5456 62.5254 83.2374 62.8336 83.2374 63.2138C83.2374 63.594 83.5456 63.9022 83.9258 63.9022Z"
      fill="black"
    />
    <path
      d="M84.6139 63.2147C84.6137 63.4046 84.5433 63.5877 84.4162 63.7288C84.2891 63.8699 84.1143 63.9589 83.9255 63.9788C83.8188 63.9893 83.7111 63.9773 83.6093 63.9436C83.5076 63.91 83.414 63.8554 83.3346 63.7834C83.2551 63.7114 83.1917 63.6236 83.1483 63.5256C83.1048 63.4276 83.0824 63.3216 83.0824 63.2144C83.0824 63.1072 83.1048 63.0012 83.1483 62.9032C83.1917 62.8052 83.2551 62.7174 83.3346 62.6454C83.414 62.5734 83.5076 62.5188 83.6093 62.4851C83.7111 62.4515 83.8188 62.4395 83.9255 62.45C84.1144 62.47 84.2892 62.5592 84.4163 62.7004C84.5434 62.8416 84.6138 63.0248 84.6139 63.2147ZM84.6139 63.2147C84.6145 63.1275 84.5964 63.0412 84.561 62.9616C84.5256 62.8819 84.4735 62.8107 84.4083 62.7528C84.3432 62.6948 84.2664 62.6515 84.1831 62.6256C84.0998 62.5997 84.012 62.5919 83.9255 62.6027C83.777 62.6224 83.6408 62.6954 83.5421 62.808C83.4434 62.9207 83.389 63.0653 83.389 63.2151C83.389 63.3649 83.4434 63.5095 83.5421 63.6222C83.6408 63.7348 83.777 63.8078 83.9255 63.8275C84.012 63.8382 84.0999 63.8303 84.1832 63.8043C84.2665 63.7784 84.3432 63.7349 84.4084 63.677C84.4735 63.619 84.5256 63.5477 84.561 63.468C84.5964 63.3883 84.6145 63.302 84.6139 63.2147Z"
      fill="black"
    />
    <path
      d="M86.1156 63.9022C86.4958 63.9022 86.804 63.594 86.804 63.2138C86.804 62.8336 86.4958 62.5254 86.1156 62.5254C85.7355 62.5254 85.4272 62.8336 85.4272 63.2138C85.4272 63.594 85.7355 63.9022 86.1156 63.9022Z"
      fill="black"
    />
    <path
      d="M86.8032 63.2147C86.8031 63.4046 86.7327 63.5877 86.6056 63.7288C86.4785 63.8699 86.3037 63.9589 86.1149 63.9788C86.0082 63.9893 85.9005 63.9773 85.7987 63.9436C85.6969 63.91 85.6034 63.8554 85.5239 63.7834C85.4445 63.7114 85.3811 63.6236 85.3377 63.5256C85.2942 63.4276 85.2718 63.3216 85.2718 63.2144C85.2718 63.1072 85.2942 63.0012 85.3377 62.9032C85.3811 62.8052 85.4445 62.7174 85.5239 62.6454C85.6034 62.5734 85.6969 62.5188 85.7987 62.4851C85.9005 62.4515 86.0082 62.4395 86.1149 62.45C86.3038 62.47 86.4786 62.5592 86.6057 62.7004C86.7328 62.8416 86.8031 63.0248 86.8032 63.2147ZM86.8032 63.2147C86.8038 63.1275 86.7858 63.0412 86.7504 62.9616C86.7149 62.8819 86.6629 62.8107 86.5977 62.7528C86.5325 62.6948 86.4558 62.6515 86.3725 62.6256C86.2892 62.5997 86.2014 62.5919 86.1149 62.6027C85.9664 62.6224 85.8301 62.6954 85.7315 62.808C85.6328 62.9207 85.5784 63.0653 85.5784 63.2151C85.5784 63.3649 85.6328 63.5095 85.7315 63.6222C85.8301 63.7348 85.9664 63.8078 86.1149 63.8275C86.2014 63.8382 86.2893 63.8303 86.3726 63.8043C86.4558 63.7784 86.5326 63.7349 86.5978 63.677C86.6629 63.619 86.715 63.5477 86.7504 63.468C86.7858 63.3883 86.8038 63.302 86.8032 63.2147Z"
      fill="black"
    />
    <g opacity="0.52">
      <path
        d="M209.426 179.919L222.91 202.94"
        stroke="#BBBDBF"
        strokeWidth="0.384762"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <g opacity="0.52">
      <path
        d="M208.569 196.06L216.032 208.938"
        stroke="#BBBDBF"
        strokeWidth="0.384762"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <g opacity="0.52">
      <path
        d="M201.396 201.244L209.593 214.94"
        stroke="#BBBDBF"
        strokeWidth="0.384762"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <g opacity="0.52">
      <path
        d="M194.655 206.993L202.714 220.647"
        stroke="#BBBDBF"
        strokeWidth="0.384762"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <g opacity="0.52">
      <path
        d="M161.939 197.063L138.564 228.863"
        stroke="#BBBDBF"
        strokeWidth="0.384762"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <g opacity="0.52">
      <path
        d="M169.278 202.808L153.631 223.763"
        stroke="#BBBDBF"
        strokeWidth="0.384762"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <g opacity="0.52">
      <path
        d="M152.591 234.114L127.619 241.883"
        stroke="#BBBDBF"
        strokeWidth="0.384762"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <g opacity="0.52">
      <path
        d="M157.594 245.4L132.622 253.169"
        stroke="#BBBDBF"
        strokeWidth="0.384762"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <g opacity="0.52">
      <path
        d="M158.284 256.392L133.311 264.16"
        stroke="#BBBDBF"
        strokeWidth="0.382305"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <path
      d="M172.487 40.0959C173.799 39.1311 174.863 37.8695 175.593 36.4144C176.323 34.9593 176.698 33.352 176.687 31.7241C176.687 26.0958 172.325 21.5332 166.945 21.5332C161.849 21.5332 157.67 25.6255 157.241 30.8391C156.079 30.5192 154.867 30.4155 153.667 30.5332C151.957 30.7727 150.376 31.5761 149.175 32.8161C147.982 34.0747 147.062 35.566 146.473 37.1967C146.43 37.238 146.389 37.2821 146.347 37.324C145.706 37.6029 145.093 37.9394 144.513 38.3293C143.913 38.3551 143.316 38.4294 142.728 38.5516C141.327 38.6198 139.944 38.9045 138.629 39.3955C138.545 39.4275 138.463 39.4668 138.385 39.513C137.467 39.3135 136.512 39.377 135.628 39.6963C135.053 39.9558 134.549 40.349 134.157 40.843C133.765 41.3371 133.497 41.9177 133.375 42.5364C133.083 43.8487 133.077 45.2087 133.358 46.5233C133.64 47.838 134.202 49.0764 135.006 50.154C135.077 50.3709 135.15 50.5868 135.228 50.801C135.25 50.8674 135.287 50.928 135.336 50.978C135.385 51.0281 135.445 51.0662 135.511 51.0896C135.503 51.1005 135.492 51.1092 135.484 51.1205C135.388 51.2608 135.238 51.4945 135.303 51.6722C135.427 52.0503 135.638 52.3941 135.918 52.6761C136.231 52.9838 136.612 53.2132 137.03 53.3453C137.524 53.474 138.04 53.4883 138.54 53.3871C139.04 53.2859 139.51 53.0719 139.915 52.7614C139.995 52.7022 140.072 52.6373 140.143 52.5672C145.26 51.7993 150.287 50.5174 155.148 48.741C155.641 48.7816 156.13 48.8406 156.616 48.918C157.005 49.0613 157.403 49.1801 157.808 49.2736C158.029 49.3221 158.257 49.3351 158.482 49.3119C158.516 49.3211 158.549 49.3335 158.583 49.3428C159.006 49.692 159.395 50.0813 159.743 50.5052C160.403 52.4032 160.726 54.4017 160.698 56.4107C160.496 57.0757 160.255 57.7279 159.975 58.3639C159.895 58.4638 159.821 58.5684 159.753 58.6772L159.143 58.4525C159.143 58.4525 155.11 69.8498 154.283 69.7009C153.457 69.5519 133.824 65.4974 133.215 59.088C133.215 59.088 131.833 62.8235 130.603 66.8677C130.048 68.1671 129.497 69.4686 128.973 70.7794C128.324 72.401 127.535 74.4023 128.466 76.0807C129.027 77.0335 129.871 77.7882 130.88 78.2401C136.711 81.7146 153.016 85.3563 157.411 81.3914L157.416 81.3519C157.543 81.2809 157.66 81.195 157.766 81.0959C160.252 78.7386 159.36 74.9611 159.519 71.8721C159.721 68.1393 160.258 64.4323 161.124 60.7958C161.517 60.7412 161.9 60.6312 162.261 60.4692C162.681 60.2809 163.083 60.0553 163.463 59.795C164.354 60.1194 165.121 60.7137 165.657 61.495C166.194 62.2763 166.474 63.2057 166.457 64.1534C166.449 64.3247 166.466 64.4962 166.507 64.6628C166.458 64.751 166.414 64.8422 166.375 64.9358C166.113 65.6152 165.797 66.273 165.432 66.9029C165.413 66.9338 165.391 66.9664 165.368 66.9994C165.067 67.1229 164.782 67.281 164.518 67.4705C164.342 67.4858 164.171 67.5372 164.016 67.6215L164.005 67.627C163.953 67.6541 163.902 67.684 163.851 67.7164L163.824 67.7338C163.774 67.7669 163.724 67.8013 163.676 67.8387L163.662 67.8498C163.456 68.0103 163.274 68.2007 163.124 68.4145L163.11 68.4348C163.077 68.4836 163.047 68.5321 163.02 68.5809L163.014 68.5934C162.943 68.6928 162.898 68.8081 162.882 68.9292C162.867 69.0502 162.882 69.1731 162.925 69.2871L162.93 69.295C162.951 69.3311 162.978 69.3636 163.009 69.3913C162.943 69.5784 162.927 69.7796 162.962 69.975C162.998 70.1704 163.083 70.3531 163.211 70.5051C163.127 70.7627 163.121 71.0394 163.194 71.3004C163.471 72.2188 163.625 73.17 163.651 74.129C163.715 76.1425 167.072 74.3779 167.654 73.8175C172.175 69.4915 175.075 63.746 175.871 57.5398C176.106 56.2318 176.225 54.9055 176.226 53.5765C176.28 49.7967 175.266 46.0783 173.302 42.8483C173.062 41.9238 172.798 41.0041 172.487 40.0959ZM136.697 40.8051C135.878 41.1249 135.176 41.6868 134.684 42.4159C134.489 42.7265 134.345 43.0665 134.257 43.4228C134.265 43.3218 134.265 43.2206 134.277 43.1197C134.389 42.1799 134.651 40.9184 135.617 40.4934C136.375 40.2308 137.196 40.2078 137.967 40.4275C137.533 40.512 137.107 40.6384 136.697 40.8051ZM155.069 32.4738C153.408 31.9779 151.554 32.5372 150.079 33.6316C150.862 32.7232 151.959 32.1427 153.15 32.0056C154.15 31.9354 155.155 32.0354 156.121 32.3013C155.766 32.3452 155.416 32.4046 155.069 32.4738ZM146.336 71.964C145.647 72.4765 144.813 72.7564 143.955 72.7631C142.125 72.7631 140.526 71.4776 139.762 70.5316C139.727 70.4876 139.7 70.437 139.684 70.3828C139.668 70.3285 139.663 70.2717 139.669 70.2154C139.675 70.1592 139.692 70.1047 139.719 70.055C139.746 70.0053 139.783 69.9615 139.827 69.9259C139.871 69.8904 139.921 69.8638 139.975 69.8478C140.03 69.8318 140.087 69.8267 140.143 69.8326C140.199 69.8386 140.254 69.8556 140.303 69.8826C140.353 69.9097 140.397 69.9463 140.432 69.9902C140.54 70.1224 143.098 73.2112 145.836 71.2626C145.929 71.1967 146.044 71.1704 146.157 71.1894C146.269 71.2085 146.369 71.2713 146.436 71.3642C146.502 71.457 146.528 71.5723 146.51 71.6848C146.491 71.7972 146.428 71.8976 146.336 71.964Z"
      fill="black"
    />
    <path
      d="M43.1684 48.3662C43.216 48.5929 43.2244 48.826 43.1932 49.0555C43.1669 49.2845 43.1109 49.5091 43.0268 49.7238C42.9424 49.9454 42.818 50.1496 42.6597 50.3261C42.5047 50.5149 42.2843 50.6384 42.0424 50.672C42.1881 50.5147 42.3098 50.3368 42.4035 50.1439C42.497 49.9589 42.5802 49.7689 42.6528 49.5747C42.8041 49.1634 42.9762 48.76 43.1684 48.3662Z"
      fill="black"
    />
    <path
      d="M71.2806 7.89402C69.2466 3.75152 64.877 2.08263 60.5333 3.07255C59.7133 3.10048 58.8973 3.20005 58.0946 3.37013C52.8485 3.75143 47.6463 5.52945 44.9583 9.96087C44.9263 9.98017 44.8938 9.99962 44.8648 10.018C43.6541 10.7862 42.6065 11.7853 41.782 12.9584C39.8681 12.2796 37.8865 12.0897 35.8686 13.0493C34.6138 13.6708 33.5243 14.5808 32.6893 15.7048C31.8544 16.8288 31.2978 18.1348 31.0653 19.5156C29.9093 22.1694 29.5193 25.0939 29.9393 27.9579C30.3833 31.3368 31.8094 34.5168 33.6061 37.3845C34.2431 38.4012 34.9333 39.3822 35.6497 40.3439C36.3033 42.126 37.2254 43.8847 39.1272 43.7777C39.9889 43.7238 40.8097 43.3914 41.4661 42.8306C41.7441 42.8149 42.022 42.7992 42.3 42.7835C42.5807 42.7566 42.8474 42.6477 43.0667 42.4703C43.286 42.2929 43.4483 42.0549 43.5333 41.786C43.7179 40.7835 43.7789 39.7621 43.7151 38.7447C43.5875 37.7673 43.2103 36.8392 42.6198 36.0499C42.0243 35.304 41.6551 34.403 41.5561 33.4537C41.5361 32.4732 41.7663 31.5038 42.2249 30.6369C42.4182 30.5526 42.6021 30.4482 42.7737 30.3256C42.8519 30.3012 42.931 30.28 43.0109 30.2618C43.0979 30.249 43.1849 30.2359 43.2729 30.2303C43.5196 30.2025 43.755 30.1117 43.9563 29.9665C44.1156 29.8574 44.2541 29.7207 44.3652 29.5628C44.9177 29.7712 45.5044 29.8738 46.0948 29.865L46.1123 29.8618C46.269 30.0608 46.4543 30.2353 46.6623 30.3797C46.7979 30.4478 46.9494 30.4779 47.1007 30.4668C47.252 30.4557 47.3975 30.4038 47.5217 30.3167C48.0125 30.9332 48.4344 31.6015 48.7801 32.3097C48.923 32.7187 49.0806 33.1232 49.2469 33.5248C49.1561 33.5827 49.0769 33.6569 49.0132 33.7436C48.9738 33.7887 48.9439 33.8413 48.9252 33.8981C48.9065 33.955 48.8995 34.015 48.9045 34.0747C48.916 34.1228 48.9416 34.1664 48.978 34.2C49.0144 34.2336 49.06 34.2555 49.1089 34.2631C49.5022 34.3419 49.9086 34.3249 50.294 34.2137C50.6794 34.1025 51.0323 33.9002 51.3231 33.624C51.4245 33.5348 51.4961 33.4166 51.5281 33.2855C51.5394 33.237 51.5355 33.1862 51.5168 33.1401C51.4982 33.0939 51.4657 33.0547 51.4239 33.0277C51.3427 32.988 51.2508 32.9757 51.162 32.9925C50.9799 32.402 50.752 31.8267 50.4802 31.2718C49.0773 27.2162 48.9639 22.8259 50.1557 18.7033C50.3529 18.5924 50.5244 18.4409 50.6587 18.2588C52.4789 15.5831 56.0256 15.3235 58.8817 16.23C61.7372 17.1364 64.0633 19.0938 66.1691 21.1879C66.7308 21.9236 67.3491 22.4745 67.8246 23.2706C68.0031 23.5693 68.1905 23.5998 68.4662 23.9925C68.531 24.1267 68.5927 24.2622 68.654 24.3979C68.6945 24.5504 68.7589 24.6955 68.8449 24.8278C69.6054 26.6392 70.5894 28.1007 70.7149 30.0754C70.7468 30.5784 71.7513 30.0275 71.7775 29.6701C71.8717 28.3881 71.8477 27.4006 71.9953 26.1242C73.1141 24.2501 73.3883 22.3148 73.5278 20.1358C74.3291 15.8146 73.9218 11.3474 71.2806 7.89402ZM35.2134 19.02C35.326 17.8519 35.5586 16.1859 36.8617 15.9885C37.9073 15.8301 39.0303 16.3583 40.017 16.8905C38.8444 17.358 37.7994 18.0972 36.9679 19.0471C36.2011 19.9378 35.6188 20.9719 35.2549 22.0895C35.1405 21.0701 35.1266 20.042 35.2134 19.02L35.2134 19.02ZM54.2566 8.48696C54.4144 8.2981 54.5452 8.08819 54.6451 7.86329C56.2671 7.42149 57.967 7.34549 59.6219 7.64076C61.3522 7.93662 62.9944 8.6157 64.4283 9.62827C61.0762 8.45226 57.657 7.85323 54.2566 8.48698L54.2566 8.48696Z"
      fill="black"
    />
    <path
      d="M543.017 77.0877C543.017 77.0877 540.864 75.6234 539.916 77.9491"
      stroke="black"
      strokeWidth="0.221844"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M660.213 43.4726C660.213 43.4726 654.855 45.2147 650.954 51.1819C647.052 57.1491 644.564 65.3683 644.564 65.3683L646.672 72.9954C646.672 72.9954 648.737 73.9907 650.018 72.75C651.298 71.5094 653.28 65.3683 653.28 65.3683C653.28 65.3683 661.831 64.2398 667.452 68.2043C673.074 72.1687 676.028 75.1884 676.028 75.1884C676.028 75.1884 666.131 99.7224 664.732 102.115C663.332 104.508 663.886 104.394 663.886 104.394C663.886 104.394 685.061 105.421 688.89 105.072C692.719 104.722 691.012 100.594 690.814 98.9511C690.617 97.3079 687.096 56.1718 685.31 52.2362C683.524 48.3006 676.995 39.6988 673.449 39.2021C669.902 38.7054 670.289 43.9538 670.289 43.9538C670.289 43.9538 669.83 45.7669 665.315 46.0177C660.801 46.2684 660.213 43.4726 660.213 43.4726Z"
      fill="#F0DC01"
    />
    <path
      d="M679.078 266.05C679.032 265.893 678.93 265.76 678.79 265.676C678.65 265.593 678.484 265.565 678.325 265.599C658.08 267.99 631.771 252.297 615.627 271.287C614.808 272.251 615.7 272.471 616.579 272.228C616.67 272.392 616.872 272.504 617.241 272.514C626.855 272.765 636.469 273.017 646.083 273.268C646.643 273.283 647.346 272.708 647.642 272.158C657.655 272.948 667.688 273.345 677.741 273.35C678.135 273.314 678.508 273.162 678.816 272.913C679.123 272.665 679.35 272.331 679.468 271.954C679.819 269.983 679.685 267.957 679.078 266.05ZM626.705 266.585C626.48 266.669 626.26 266.765 626.046 266.874C625.085 266.952 624.124 267.036 623.164 267.132C629.82 263.46 638.324 263.398 645.735 264.375C645.797 264.384 645.859 264.393 645.922 264.401C639.425 263.938 632.876 264.302 626.705 266.585H626.705Z"
      fill="black"
    />
    <path
      d="M708.28 242.452C706.596 240.594 703.549 242.69 701.937 243.615C696.945 246.487 692.541 250.278 688.958 254.787C688.461 255.409 688.354 256.237 688.932 256.665C689.302 258.723 689.671 260.781 690.041 262.839C689.212 263.473 688.384 264.106 687.555 264.739C687.434 264.688 687.303 264.662 687.171 264.664C687.039 264.665 686.909 264.695 686.789 264.75C686.094 264.972 685.417 265.249 684.765 265.577C684.054 265.618 683.345 265.451 682.727 265.095C682.601 265.042 682.466 265.014 682.329 265.013C682.192 265.012 682.057 265.038 681.93 265.09L681.927 264.998C681.918 264.622 681.331 264.751 681.136 264.843C680.964 264.909 680.813 265.022 680.702 265.169C680.591 265.317 680.524 265.492 680.508 265.676C680.509 265.72 680.51 265.763 680.511 265.806C680.47 265.886 680.455 265.976 680.471 266.065L680.518 266.272C680.473 266.357 680.451 266.452 680.454 266.549C680.458 266.645 680.487 266.738 680.538 266.82C680.565 267.851 680.593 268.883 680.62 269.915C680.633 270.408 681.431 270.065 681.597 269.962C682.352 269.493 683.108 269.024 683.863 268.555C687.207 267.192 690.437 265.617 693.026 263.016C693.108 262.934 693.184 262.846 693.253 262.753C693.88 262.251 694.503 261.744 695.12 261.231C695.382 261.176 695.638 261.095 695.884 260.988C699.012 259.622 701.743 257.483 703.819 254.772C704.888 254.385 705.863 253.775 706.678 252.983C707.026 252.646 707.291 252.232 707.452 251.775C708.293 251.258 709.044 250.416 709.197 249.793C709.728 247.641 709.901 244.242 708.28 242.452Z"
      fill="black"
    />
    <g opacity="0.52">
      <path
        d="M657.353 54.2553C658.113 53.4508 672.265 47.3728 680.206 61.9246"
        stroke="#F6931D"
        strokeWidth="0.192381"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <g opacity="0.52">
      <path
        d="M653.876 59.0595C654.636 58.2551 671.74 56.542 679.681 71.0938"
        stroke="#F6931D"
        strokeWidth="0.192381"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <path
      d="M673.448 49.9834C673.448 49.9834 664.582 50.6671 660.213 65.3658"
      stroke="#F6931D"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <g opacity="0.52">
      <path
        d="M648.944 54.2578C648.944 54.2578 649.913 56.9945 655.528 56.4817"
        stroke="#F6931D"
        strokeWidth="0.192381"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <g opacity="0.52">
      <path
        d="M645.29 61.9053C645.29 61.9053 646.258 64.6419 651.873 64.1292"
        stroke="#F6931D"
        strokeWidth="0.192381"
        strokeLinecap="round"
        strokeLinejoin="round"
      />
    </g>
    <path
      d="M680.265 60.239C680.265 60.239 684.595 61.4695 687.14 58.5469"
      stroke="#F6931D"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M681.11 70.8386C681.11 70.8386 685.44 72.0691 687.985 69.1465"
      stroke="#F6931D"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M673.449 82.3501C678.635 83.8988 684.201 83.5743 689.173 81.4336"
      stroke="#F6931D"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M668.78 93.2417C675.937 94.786 683.37 94.4705 690.371 92.3252"
      stroke="#F6931D"
      strokeWidth="0.192381"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M679.747 104.507C679.747 104.507 687.335 121.952 681.31 133.269C675.285 144.587 675.44 219.109 677.285 231.841C679.131 244.573 684.547 258.826 684.547 258.826"
      stroke="#F0DC01"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M683.024 18.6718C682.92 18.2404 682.441 18.2 681.904 18.3853C681.139 15.9421 679.895 13.6758 678.245 11.719C676.594 9.76206 674.57 8.1538 672.291 6.98818C672.048 6.88233 671.776 6.86653 671.523 6.9436C670.287 6.53656 669.016 6.24711 667.726 6.07911C664.63 5.15184 661.1 5.06656 658.744 6.93637C658.702 6.93211 658.658 6.93214 658.616 6.93647C657.07 7.16652 655.602 7.76477 654.335 8.68081C653.069 9.59686 652.041 10.8039 651.338 12.2002C650.813 12.7881 650.332 13.4135 649.898 14.0715C649.869 14.1149 649.852 14.1525 649.829 14.1928C649.814 14.2025 649.797 14.213 649.782 14.2218C649.707 14.2728 649.635 14.3291 649.568 14.3905C649.551 14.4043 649.535 14.4193 649.521 14.4354C649.46 14.4966 649.404 14.5622 649.352 14.6316C649.307 14.6965 649.267 14.7645 649.232 14.8352C649.204 14.9013 649.18 14.9694 649.162 15.039C649.156 15.0607 649.152 15.0828 649.149 15.1052C649.14 15.1379 649.136 15.1723 649.14 15.2062C649.143 15.2402 649.154 15.2732 649.17 15.3031C649.175 15.3185 649.183 15.3331 649.191 15.3468L648.694 16.1183C648.665 16.1632 648.645 16.2283 648.678 16.2655C648.658 16.3366 648.654 16.4109 648.665 16.4838C648.691 16.6537 649.043 16.4661 649.02 16.3141C649.013 16.2643 649.017 16.2137 649.031 16.1656C649.046 16.1175 649.07 16.0729 649.103 16.0347C649.135 15.9904 649.171 15.9493 649.212 15.9122C649.258 15.8668 649.306 15.8242 649.353 15.7792C649.441 15.6948 649.519 15.6004 649.586 15.4979C649.643 15.4964 649.699 15.4866 649.753 15.4689C649.814 15.4454 649.876 15.4219 649.938 15.3983C650.067 15.336 650.186 15.2537 650.29 15.1546L650.399 15.032C650.619 15.0063 650.834 14.942 651.032 14.8419C651.302 14.8053 651.552 14.6811 651.744 14.4884C651.861 14.3597 651.985 14.2372 652.106 14.1127C652.133 14.1147 652.16 14.1127 652.188 14.1131C652.847 14.4768 653.608 14.613 654.353 14.5006C654.454 14.4852 654.555 14.4645 654.654 14.4388C658.32 15.8301 661.658 17.9654 664.459 20.7101C664.43 20.7608 664.413 20.8174 664.409 20.8757C664.405 20.9339 664.414 20.9923 664.436 21.0465C664.85 22.088 664.859 23.2465 664.461 24.2942C664.424 24.3224 664.39 24.3547 664.36 24.3904L664.231 24.5503C664.203 24.5835 664.183 24.6224 664.173 24.6643C664.157 24.6977 664.153 24.7349 664.159 24.771C664.16 24.7872 664.165 24.8029 664.173 24.817C664.181 24.831 664.193 24.843 664.206 24.8521C664.217 24.865 664.231 24.8757 664.246 24.8833C664.261 24.891 664.278 24.8955 664.295 24.8966L664.374 24.8999C664.414 24.8934 664.453 24.8822 664.491 24.8664C664.725 24.9367 664.975 24.9365 665.209 24.866C665.444 24.7955 665.652 24.6577 665.809 24.4698C665.981 24.2804 666.116 24.0604 666.208 23.8212C666.244 23.7278 666.285 23.6366 666.332 23.5482C666.31 23.5868 666.467 23.3816 666.405 23.4468C666.422 23.4287 666.44 23.4119 666.458 23.3948C666.453 23.401 666.508 23.3508 666.523 23.3401C666.556 23.3166 666.59 23.2943 666.625 23.2729C666.634 23.2687 666.647 23.2622 666.662 23.2552C666.707 23.2344 666.751 23.2127 666.797 23.194C666.846 23.174 666.766 23.2001 666.853 23.1755C666.931 23.1534 667.009 23.1286 667.089 23.1134C667.442 23.057 667.801 23.0458 668.156 23.08L668.163 23.0816C668.266 23.0888 668.369 23.096 668.472 23.1033C668.651 23.1112 668.827 23.0613 668.976 22.961C669.001 22.9715 669.027 22.9813 669.053 22.992C669.79 23.489 670.373 24.1813 670.738 24.9914C670.498 26.7326 669.928 28.4119 669.057 29.9389C669.046 29.9418 669.036 29.9456 669.024 29.9484C669.001 29.9545 668.984 29.9594 668.966 29.9643C668.952 29.9657 668.938 29.9673 668.919 29.9698C668.403 30.0325 667.909 30.2132 667.475 30.4978C667.041 30.7824 666.678 31.1633 666.415 31.6109C666.314 31.6583 666.223 31.727 666.151 31.8123C666.078 31.8977 666.024 31.9978 665.994 32.1057C665.898 32.7406 665.714 33.3592 665.449 33.9439C665.402 34.044 665.344 34.1391 665.278 34.2276C665.235 34.2874 665.19 34.3443 665.145 34.4019L665.127 34.4231C665.111 34.44 665.095 34.4567 665.079 34.4731C665.034 34.5183 664.988 34.5608 664.941 34.6036L664.939 34.6054C664.911 34.6268 664.882 34.6476 664.853 34.6677C664.83 34.6828 664.808 34.6972 664.785 34.7114L664.76 34.7249C664.694 34.7548 664.63 34.7862 664.562 34.813C664.373 34.8881 663.826 35.4034 664.197 35.592C664.491 35.7783 664.819 35.9024 665.163 35.9567C665.506 36.0109 665.857 35.994 666.193 35.9072C666.9 35.8452 667.591 35.6622 668.236 35.366C668.25 35.3703 668.264 35.3758 668.277 35.3825C668.119 36.0816 667.798 36.7332 667.339 37.2837C667.132 37.5316 666.893 37.7504 666.628 37.934C666.445 38.0259 666.269 38.1308 666.101 38.2479C666.003 38.2957 665.903 38.3391 665.802 38.3808C665.338 38.4769 664.874 38.573 664.41 38.6691C664.374 38.6783 664.341 38.6963 664.313 38.7214C663.155 38.6669 662.028 38.3291 661.03 37.7375C660.899 37.6596 660.596 37.9206 660.746 38.0099C660.942 38.1266 661.144 38.2298 661.349 38.3268C661.306 38.3841 661.292 38.4491 661.345 38.4952C662.019 39.0792 662.761 39.5799 663.555 39.9867C663.548 40.0007 663.546 40.0163 663.548 40.0317C663.55 40.0471 663.556 40.0616 663.566 40.0735C663.903 40.4356 664.339 40.6902 664.821 40.8052C664.828 40.8195 664.84 40.8307 664.855 40.8367C665.08 40.9336 665.311 41.0137 665.547 41.0765C667.81 42.3719 670.488 42.7401 673.017 42.1037C674.338 41.9993 675.623 41.627 676.795 41.0094C677.967 40.3919 679.001 39.542 679.833 38.5117C682.239 35.6528 682.822 32.002 683.209 28.3992C683.24 28.1911 683.214 27.9785 683.134 27.784C683.336 26.0487 683.44 24.3033 683.445 22.5563C683.63 21.517 683.785 20.4701 683.908 19.4153C683.983 18.7696 683.562 18.5879 683.024 18.6718ZM662.428 9.51984C661.799 9.45111 661.167 9.41428 660.535 9.40949C661.377 9.25061 662.236 9.2076 663.09 9.28165C662.868 9.35761 662.648 9.43868 662.428 9.51984Z"
      fill="black"
    />
    <path
      d="M653.958 35.7806C653.825 35.7037 653.693 35.6268 653.56 35.5499C653.539 35.5403 653.516 35.5357 653.493 35.5366C653.525 35.4545 653.534 35.3653 653.519 35.2785C653.504 35.1917 653.466 35.1106 653.409 35.0437C652.391 33.8859 650.435 33.2342 650.275 31.5391C650.236 31.1258 649.866 31.0712 649.446 31.2085C649.442 30.8174 649.411 30.427 649.354 30.04C649.299 29.671 648.985 29.5859 648.615 29.6676C648.634 29.6046 648.617 29.5702 648.582 29.5564C648.584 29.5182 648.588 29.4803 648.59 29.4421C648.596 29.3277 648.508 29.3286 648.419 29.3678C648.411 29.3408 648.401 29.3148 648.388 29.29C648.392 29.2753 648.392 29.2599 648.389 29.2451C647.394 25.7384 647.244 22.0461 647.951 18.4703C647.989 18.276 647.626 18.4268 647.597 18.5708C647.523 18.9429 647.464 19.3174 647.409 19.6923C647.335 19.7297 647.266 19.7906 647.258 19.8517C647.23 20.0514 647.209 20.2521 647.182 20.452C647.085 20.4743 646.962 20.5547 646.943 20.6351C646.529 22.4367 646.115 24.2403 645.577 26.0096C645.322 26.8843 645.018 27.7442 644.668 28.5853C644.373 29.355 643.914 30.0511 643.322 30.6253C643.209 30.7244 643.089 30.8157 642.964 30.8986C642.856 30.9486 642.754 31.0093 642.658 31.0797C642.091 31.3914 641.428 31.4808 640.798 31.3306C640.698 31.3047 640.475 31.4412 640.512 31.5631C640.533 31.6323 640.561 31.6994 640.595 31.7636C640.588 31.7751 640.584 31.7881 640.583 31.8014C640.583 31.8147 640.585 31.8279 640.591 31.8401C640.596 31.8522 640.605 31.8628 640.615 31.8711C640.625 31.8793 640.638 31.885 640.651 31.8875C640.659 31.8902 640.667 31.8915 640.675 31.8942C640.851 32.1017 641.076 32.263 641.329 32.364C641.582 32.465 641.856 32.5027 642.127 32.4737C642.26 32.548 642.41 32.5851 642.563 32.5809C644.249 32.598 645.892 32.0446 647.224 31.0106C647.225 31.0264 647.222 31.0425 647.224 31.0582C647.243 31.1852 647.249 31.3101 647.262 31.4361C647.199 31.5087 647.145 31.5887 647.102 31.6743C647.007 31.7378 646.939 31.8339 646.91 31.9444C646.845 32.2757 646.746 32.5994 646.614 32.9102C646.553 33.0561 646.483 33.1982 646.408 33.3381C645.976 33.8639 645.426 34.2805 644.803 34.5543C644.179 34.8281 643.5 34.9514 642.821 34.9143C642.767 34.8627 642.712 34.8127 642.664 34.756C642.557 34.6311 642.231 34.8666 642.332 34.9852C642.377 35.0377 642.429 35.0825 642.477 35.1308C642.479 35.1439 642.483 35.1567 642.49 35.168C642.496 35.1794 642.506 35.1891 642.517 35.1965C642.54 35.2143 642.566 35.2279 642.59 35.2443C642.866 35.4799 643.188 35.655 643.536 35.7584C643.543 35.762 643.552 35.7645 643.56 35.7658C643.769 35.8315 643.985 35.872 644.203 35.8865C644.126 36.1488 644.202 36.368 644.6 36.4176C646.813 36.6948 649.046 36.7756 651.274 36.659C651.39 36.6432 651.502 36.6075 651.605 36.5536C651.984 36.7393 652.563 36.5309 652.987 36.1956C653.005 36.2112 653.027 36.2219 653.051 36.2265C653.074 36.2312 653.099 36.2297 653.121 36.2221C653.282 36.1828 653.442 36.1435 653.602 36.1041L653.604 36.1036L653.79 36.0579C653.865 36.0373 653.929 35.9891 653.969 35.9231C653.994 35.8795 654.013 35.8124 653.958 35.7806ZM642.03 31.8176L641.992 31.8192C641.754 31.7996 641.517 31.7619 641.285 31.7065C641.593 31.7027 641.898 31.6494 642.189 31.5487C642.128 31.6329 642.074 31.723 642.03 31.8176ZM644.574 29.6911C644.368 29.95 644.132 30.1829 643.87 30.3847C644.135 30.0938 644.369 29.7751 644.566 29.4341C644.725 29.1526 644.869 28.8624 644.995 28.5648C644.88 28.9493 644.74 29.3255 644.574 29.6911ZM645.134 34.7905C644.999 34.8634 644.876 34.9561 644.769 35.0655C644.737 35.0668 644.706 35.0749 644.678 35.0892C644.472 35.1977 644.247 35.2631 644.015 35.2814C643.783 35.2997 643.55 35.2705 643.33 35.1957C644.347 35.0971 645.307 34.6837 646.078 34.0134C646.082 34.0431 646.097 34.0704 646.119 34.0908C645.84 34.3868 645.505 34.6247 645.134 34.7905V34.7905Z"
      fill="black"
    />
    <path
      d="M648.865 16.7471C648.444 17.828 648.138 18.9503 647.953 20.0954C647.757 21.2332 647.696 22.3904 647.773 23.5425C647.793 23.8296 647.803 24.1173 647.83 24.4033L647.95 25.2574L648.009 25.6843L648.103 26.1048L648.296 26.9446C648.602 28.0522 649.028 29.1229 649.567 30.1374C650.091 31.1599 650.728 32.1204 651.467 33.0009C651.836 33.441 652.231 33.8591 652.649 34.2533C653.063 34.653 653.497 35.0308 653.95 35.3851C654.173 35.5669 654.406 35.7366 654.647 35.8934C654.887 36.0521 655.115 36.2317 655.366 36.3738C655.858 36.6741 656.367 36.9472 656.89 37.1916C657.935 37.6942 659.029 38.0884 660.155 38.3679C657.843 37.9587 655.656 37.0227 653.763 35.6324C651.864 34.2294 650.308 32.4145 649.211 30.3239C648.669 29.2785 648.244 28.1766 647.943 27.0383L647.754 26.1767L647.662 25.7457L647.606 25.3085L647.495 24.4342C647.477 24.1413 647.476 23.8471 647.465 23.554C647.385 21.206 647.865 18.8726 648.865 16.7471Z"
      fill="black"
    />
    <path
      d="M657.822 31.352C657.822 31.352 659.863 32.0077 660.511 30.3438"
      stroke="black"
      strokeWidth="0.192391"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M655.129 21.6123C655.588 21.6123 655.96 21.24 655.96 20.7808C655.96 20.3215 655.588 19.9492 655.129 19.9492C654.669 19.9492 654.297 20.3215 654.297 20.7808C654.297 21.24 654.669 21.6123 655.129 21.6123Z"
      fill="black"
    />
    <path
      d="M655.664 21.4171C655.538 21.5229 655.384 21.5891 655.22 21.6072C655.057 21.6254 654.892 21.5946 654.746 21.5188C654.6 21.4431 654.479 21.3258 654.4 21.1817C654.321 21.0376 654.286 20.8732 654.3 20.7094C654.314 20.5455 654.377 20.3895 654.479 20.2611C654.582 20.1327 654.721 20.0377 654.878 19.988C655.034 19.9384 655.202 19.9363 655.36 19.9821C655.518 20.0279 655.659 20.1196 655.765 20.2454C655.907 20.4142 655.976 20.6324 655.957 20.8521C655.938 21.0719 655.833 21.2751 655.664 21.4171V21.4171Z"
      stroke="black"
      strokeWidth="0.232125"
      strokeLinejoin="round"
    />
    <path
      d="M649.307 23.3242C648.999 23.5621 648.135 24.7936 648.871 25.5183"
      stroke="black"
      strokeWidth="0.175557"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M683.94 24.054C683.838 11.1614 674.583 5.9796 669.84 5.33867C665.097 4.69773 658.662 3.0313 651.83 10.9789C644.997 18.9265 646.638 31.475 639.908 31.4819C640.54 32.119 641.351 32.5472 642.234 32.7089C643.116 32.8705 644.027 32.7579 644.843 32.3861C647.792 31.1043 647.853 30.6556 647.853 30.6556C647.853 30.6556 644.459 35.719 641.318 34.5653C641.318 34.5653 646.788 38.8286 654.468 35.9599C652.231 34.6411 650.404 32.7273 649.19 30.4316C647.976 28.1359 647.424 25.5483 647.593 22.957C647.861 17.97 648.866 16.7492 648.866 16.7492C652.869 9.83932 663.943 19.6973 663.943 19.6973C663.943 19.6973 665.353 23.1567 663.943 24.6308C663.943 24.6308 664.584 25.9769 666.058 24.054C667.532 22.1312 670.929 22.9644 670.801 26.0409C670.673 29.1174 667.597 31.1906 666.571 30.3463C666.571 30.3463 666.233 34.2448 663.326 34.8217C663.326 34.8217 664.729 37.1547 667.378 35.7019C670.028 34.2492 665.908 39.6102 662.595 38.1091C657.126 35.6308 663.986 41.8506 669.175 42.4235C674.217 42.9802 684.092 43.0713 683.94 24.054Z"
      stroke="black"
      strokeWidth="0.232125"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M659.079 43.9531C659.079 43.9531 646.273 51.5234 644.564 65.3676"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path d="M653.28 65.3672C653.28 65.3672 651.856 74.9812 646.672 72.9943L653.28 65.3672Z" fill="#F0DC01" />
    <path
      d="M649.976 79.0401C648.836 78.3564 643.732 71.1739 643.037 54.2552C642.342 37.3366 640.803 29.9882 635.505 30.415C630.207 30.8418 631.232 45.5405 631.232 45.5405"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M625.871 42.9766C625.871 42.9766 619.951 44.7542 620.122 54.7185C620.293 64.6829 626.104 66.6486 626.959 76.2625C627.814 85.8765 625.592 102.455 635.847 110.83C646.102 119.205 659.433 112.539 664.731 102.114C670.03 91.6876 674.815 78.7982 674.815 78.7982"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M678.882 75.167C678.882 75.167 685.071 51.3529 671.262 48.6183C657.454 45.8836 650.018 66.5645 650.018 66.5645C650.018 66.5645 665.244 60.3537 678.063 77.7306"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M669.734 41.1176C669.913 41.4692 670.089 41.822 670.258 42.1774L670.254 42.1679C670.558 42.7104 670.651 43.3459 670.516 43.9529C670.35 44.5744 669.949 45.1074 669.398 45.44C669.266 45.5197 669.135 45.6088 668.999 45.6797L668.578 45.8595C668.298 45.9709 668.009 46.0598 667.715 46.1253C667.426 46.1956 667.133 46.2499 666.839 46.288C666.548 46.3376 666.254 46.3667 665.96 46.3749C664.773 46.4908 663.576 46.3949 662.423 46.0916C661.815 45.9282 661.251 45.6296 660.774 45.2179C660.532 44.997 660.329 44.7364 660.174 44.4473C660.028 44.1534 659.938 43.835 659.908 43.5083L659.906 43.4886L659.906 43.4714C659.967 41.9217 660.052 40.372 660.213 38.8223C660.374 40.372 660.459 41.9217 660.52 43.4714L660.518 43.4346C660.605 43.9226 660.865 44.3629 661.25 44.6746C661.664 44.987 662.136 45.2124 662.639 45.3371C663.166 45.4772 663.705 45.5597 664.249 45.5829C664.804 45.6248 665.36 45.628 665.915 45.5925C667.006 45.5997 668.085 45.3707 669.08 44.9212C669.538 44.6926 669.897 44.3035 670.088 43.8279C670.256 43.3189 670.247 42.7678 670.061 42.2649L670.057 42.2551C669.944 41.8781 669.837 41.4984 669.734 41.1176Z"
      fill="black"
    />
    <path
      d="M671.45 38.8223C671.45 38.8223 687.061 39.1145 688.544 69.9306C690.027 100.747 692.042 102.627 690.906 104.507C689.77 106.387 667.145 103.396 663.332 104.507"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M647.468 114.982C647.982 116.131 629.636 261.308 629.195 261.786C628.754 262.264 661.399 261.825 674.816 264.608C688.233 267.391 690.028 261.786 690.028 261.786C690.028 261.786 682.849 229.593 682.849 210.421C682.849 191.248 682.336 152.536 682.849 147.665C683.362 142.793 689.259 140.358 690.028 126.834C690.797 113.31 686.443 105.331 686.443 105.331"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M625.872 86.1934C625.872 86.1934 596.965 126.128 597.221 127.923C597.477 129.718 602.349 131.065 608.502 126.93C614.655 122.796 605.938 128.179 609.783 130.743C613.629 133.307 614.142 130.743 614.142 130.743C614.142 130.743 613.629 134.751 616.705 134.029C619.782 133.307 639.088 112.943 639.088 112.943C639.088 112.943 628.966 158.22 630.348 163.696"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M636.721 262.088C631.363 262.343 625.118 262.707 620.171 264.926C616.942 266.374 615.629 269.152 613.885 272.005L680.265 273.096C680.265 273.096 681.783 268.502 680.265 265.383"
      stroke="black"
      strokeWidth="0.577143"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M682.684 178.528C682.684 178.528 695.668 223.655 699.257 228.218C702.846 232.781 707.974 238.105 707.205 239.417C706.436 240.729 687.673 250.575 688.85 256.181"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M706.47 241.231C706.47 241.231 711 243.327 711 247.155C711 250.984 682.684 270.725 682.684 270.725"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M674.816 6.48314C674.816 6.48314 679.26 -3.98132 687.293 4.00259C695.326 11.9865 692.361 20.8298 696.01 23.3125C700.966 26.6853 684.388 25.8307 682.337 19.165C678.754 7.5206 674.816 6.48314 674.816 6.48314Z"
      fill="black"
      stroke="black"
      strokeWidth="0.232125"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M673.1 6.3473C673.1 6.3473 676.773 5.11478 678.432 9.35377C680.091 13.5927 679.571 13.1035 679.571 13.1035C679.571 13.1035 676.876 7.8933 673.1 6.3473Z"
      fill="#F0DC01"
    />
    <path
      d="M669.514 25.0379C669.514 25.0379 667.361 23.5736 666.413 25.8993"
      stroke="black"
      strokeWidth="0.221844"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
    <path
      d="M81.3623 107.965C85.4729 113.664 92.5196 110.923 95.9431 106.226C98.5562 102.642 100.618 98.4122 102.696 94.4947C105.024 90.1245 107.084 85.6167 108.864 80.9962C111.459 74.2256 113.877 66.9007 114.097 59.5952C114.152 57.744 113.749 55.2814 115.053 53.7403C116.463 52.0739 117.502 50.3953 118.258 45.5363C119.338 38.5998 119.25 35.9223 115.822 39.3833C113.394 41.8357 116.056 38.7607 116.338 35.1528C116.704 30.4779 109.517 37.063 109.517 37.063C109.517 37.063 117.617 25.411 109.541 27.8465C101.465 30.2821 100.568 43.1008 100.055 42.9726C99.5427 42.8444 94.5434 37.7169 93.0051 40.537C91.4669 43.3571 97.8763 47.7112 97.8763 47.7112C97.8763 47.7112 92.1078 58.6114 91.4669 59.2523C91.4669 59.2523 83.6472 70.8101 83.7114 73.7479"
      fill="white"
    />
    <path
      d="M81.3623 107.965C85.4729 113.664 92.5196 110.923 95.9431 106.226C98.5562 102.642 100.618 98.4122 102.696 94.4947C105.024 90.1245 107.084 85.6167 108.864 80.9962C111.459 74.2256 113.877 66.9007 114.097 59.5952C114.152 57.744 113.749 55.2814 115.053 53.7403C116.463 52.0739 117.502 50.3953 118.258 45.5363C119.338 38.5998 119.25 35.9223 115.822 39.3833C113.394 41.8357 116.056 38.7607 116.338 35.1528C116.704 30.4779 109.517 37.063 109.517 37.063C109.517 37.063 117.617 25.411 109.541 27.8465C101.465 30.2821 100.568 43.1008 100.055 42.9726C99.5427 42.8444 94.5434 37.7169 93.0051 40.537C91.4669 43.3571 97.8763 47.7112 97.8763 47.7112C97.8763 47.7112 92.1078 58.6114 91.4669 59.2523C91.4669 59.2523 83.6472 70.8101 83.7114 73.7479"
      stroke="black"
      strokeWidth="0.384762"
      strokeLinecap="round"
      strokeLinejoin="round"
    />
  </svg>
);
