<?php
/**
 * The Map settings metabox file.
 *
 * @package Location_Weather
 */

if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access directly.

SPLW::createSection(
	'sp_location_weather_generator',
	array(
		'title'  => __( 'Weather Map Settings', 'location-weather' ),
		'icon'   => '<span><i class="splwp-icon-weather-map"></i></span>',
		'fields' => array(
			array(
				'type'    => 'notice',
				'style'   => 'normal',
				'class'   => 'lw-typography-pro-notice',
				'content' => sprintf(
					/* translators: %1$s: anchor tag start, %2$s: first anchor tag end,%3$s: second anchor tag start, %4$s: second anchor tag end. */
					__( 'To unlock live %1$sWeather Maps%2$s and %3$sRadar Maps%4$s to track storms and weather in real-time, %5$sUpgrade to Pro!%6$s', 'location-weather' ),
					'<a href="https://locationweather.io/demos/weather-map/" target="_blank"><b>',
					'</b></a>',
					'<a href="https://locationweather.io/demos/weather-map-windy/" target="_blank"><b>',
					'</b></a>',
					'<a href="https://locationweather.io/pricing/?ref=1" target="_blank"><b>',
					'</b></a>'
				),
			),
			array(
				'type'       => 'tabbed',
				'class'      => 'lw-display-map-tabs',
				'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
				'tabs'       => array(
					array(
						'title'  => __( 'Map Preferences', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-map-preferences"></i></span>',
						'fields' => array(
							array(
								'id'         => 'lw-map-section-title',
								'type'       => 'switcher',
								'title'      => __( 'Weather Map Section Title', 'location-weather' ),
								'class'      => 'splw-first-fields splw_show_hide',
								'default'    => false,
								'only_pro'   => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
								'dependency' => array( 'weather-view', '==', 'map', true ),
							),
							array(
								'id'         => 'lw_map_layers_display_types',
								'type'       => 'button_set',
								'class'      => 'splw-first-fields lw_display_button_set',
								'only_pro'   => true,
								'title'      => __( 'Data Layer Display Type', 'location-weather' ),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div><div class="lw-short-content">%s</div>',
									__( 'Display Layers Type', 'location-weather' ),
									__( 'Choose an option from the visible or collapsible to display the maps layers.', 'location-weather' )
								),
								'options'    => array(
									'visible'     => __( 'Visible', 'location-weather' ),
									'collapsible' => __( 'Collapsible', 'location-weather' ),
								),
								'default'    => 'visible',
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_layers_opacity',
								'class'      => 'lw_map_layers_opacity',
								'type'       => 'slider',
								'only_pro'   => true,
								'title'      => __( 'Layers Opacity', 'location-weather' ),
								'unit'       => '%',
								'max'        => 100,
								'min'        => 10,
								'default'    => 50,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_zoom_level',
								'type'       => 'slider',
								'class'      => 'lw_map_layers_opacity',
								'only_pro'   => true,
								'title'      => __( 'Zoom Level', 'location-weather' ),
								'max'        => 20,
								'min'        => 5,
								'default'    => 8,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_enable_zoom_scroll_wheel',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Zoom Scroll Wheel', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'location-weather' ),
								'text_off'   => __( 'Disabled', 'location-weather' ),
								'text_width' => 100,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_legends',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Layer Label Indicator', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
						),
					),
					array(
						'title'  => __( 'Control Layers', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-control-layer"></i></span>',
						'fields' => array(
							array(
								'id'         => 'lw_map_show_temp_layers',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Temperature', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_precipitation_layers',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Precipitation', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_pressure_layers',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Pressure', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_clouds_layers',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Clouds', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_wind_layers',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Wind Speed', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_wind_direction_layers',
								'only_pro'   => true,
								'type'       => 'switcher',
								'class'      => 'splw_show_hide',
								'title'      => __( 'Wind Direction', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_rain_layers',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Rain Chance', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_snow_layers',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Snow', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
						),
					),
					array(
						'title'  => __( 'Popup Weather Data', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-popup-weather"></i></span>',
						'fields' => array(
							array(
								'id'         => 'lw_map_show_location',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Location', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_temp',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Temperature', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_temp_icon',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Weather Condition Icon', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_short_desc',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Weather Condition Short Description', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_temp_high_low',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'High & Low Temperature', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_clouds',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Clouds', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_humidity',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Humidity', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_pressure',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Pressure', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_wind_speed',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Wind Speed', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_wind_direction',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Wind Direction', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_visibility',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Visibility', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
							array(
								'id'         => 'lw_map_show_date_time',
								'type'       => 'switcher',
								'only_pro'   => true,
								'class'      => 'splw_show_hide',
								'title'      => __( 'Time & Date', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 80,
								'dependency' => array( 'weather-view', 'any', 'map,tabs,combined,accordion,grid', true ),
							),
						),
					),
				),
			),
		),
	)
);
