<?php
/**
 * The display setup configuration.
 *
 * @package Location_Weather
 */

if ( ! defined( 'ABSPATH' ) ) {
	die;
} // Cannot access directly.

SPLW::createSection(
	'sp_location_weather_generator',
	array(
		'title'  => __( 'Display Settings', 'location-weather' ),
		'icon'   => '<span><i class="splwp-icon-display-icon"></i></span>',
		'fields' => array(
			array(
				'type'  => 'tabbed',
				'class' => 'lw-display-tabs',
				'tabs'  => array(
					array(
						'title'  => __( 'Regional Preferences', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-regional-weather"></i></span>',
						'fields' => array(
							array(
								'id'         => 'lw-title',
								'type'       => 'switcher',
								'title'      => __( 'Weather Section Title', 'location-weather' ),
								'class'      => 'splw-first-fields',
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-location-address',
								'type'       => 'switcher',
								'title'      => __( 'Location Name', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-date',
								'type'       => 'switcher',
								'title'      => __( 'Current Date', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw_date_format',
								'type'       => 'select',
								'title'      => __( 'Date Format', 'location-weather' ),
								'title_info' => '<div class="lw-info-label">' . __( 'Date Format', 'location-weather' ) . '</div> <div class="lw-short-content">' . __( 'Choose the most common date format for your visitors.', 'location-weather' ) . '</div><div class="info-button"><a class="lw-open-docs" href="https://locationweather.io/docs/how-to-set-the-date-format/" target="_blank">' . __( 'Open Docs', 'location-weather' ) . '</a></div>',
								'options'    => array(
									'M j, Y' => date_i18n( 'M j, Y' ) . ' (M j, Y)',
									'F j, Y' => date_i18n( 'F j, Y' ) . ' (F j, Y)',
									'Y-m-d'  => date_i18n( 'Y-m-d' ) . ' (Y-m-d)',
									'm/d/Y'  => date_i18n( 'm/d/Y' ) . ' (m/d/Y)',
									'd/m/Y'  => date_i18n( 'd/m/Y' ) . ' (d/m/Y)',
									'custom' => __( 'Custom', 'location-weather' ),
								),
								'default'    => 'M j, Y',
								'dependency' => array(
									'lw-date',
									'==',
									'true',
								),
							),
							array(
								'id'         => 'lw_client_date_format',
								'type'       => 'text',
								'class'      => 'lw_client_date_format',
								'title'      => ' ',
								'default'    => 'F j, Y',
								'dependency' => array(
									'lw-date|lw_date_format',
									'==|==',
									'true|custom',
									true,
								),
							),
							array(
								'id'         => 'lw-show-time',
								'type'       => 'switcher',
								'title'      => __( 'Current Time', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-time-format',
								'class'      => 'splw_custom_button_fields',
								'type'       => 'select',
								'title'      => __( 'Time Format', 'location-weather' ),
								'options'    => array(
									'g:i a' => gmdate( 'g:i a', time() ) . ' (g:i a)',
									'g:i A' => gmdate( 'g:i A', time() ) . ' (g:i A)',
									'H:i'   => gmdate( 'H:i', time() ) . ' (H:i)',
								),
								'default'    => 'g:i a',
								'dependency' => array(
									'lw-show-time',
									'==',
									'true',
									true,
								),
							),
							array(
								'id'         => 'lw-utc-time-zone',
								'type'       => 'select',
								'title'      => 'Time Zone',
								'options'    => array(
									''          => __( 'Default (auto-detected)', 'location-weather' ),
									'UTC-12'    => __( 'UTC-12', 'location-weather' ),
									'UTC-11.5'  => __( 'UTC-11:30', 'location-weather' ),
									'UTC-11'    => __( 'UTC-11', 'location-weather' ),
									'UTC-10.5'  => __( 'UTC-10:30', 'location-weather' ),
									'UTC-10'    => __( 'UTC-10', 'location-weather' ),
									'UTC-9.5'   => __( 'UTC-9:30', 'location-weather' ),
									'UTC-9'     => __( 'UTC-9', 'location-weather' ),
									'UTC-8.5'   => __( 'UTC-8:30', 'location-weather' ),
									'UTC-8'     => __( 'UTC-8', 'location-weather' ),
									'UTC-7.5'   => __( 'UTC-7:30', 'location-weather' ),
									'UTC-7'     => __( 'UTC-7', 'location-weather' ),
									'UTC-6.5'   => __( 'UTC-6:30', 'location-weather' ),
									'UTC-6'     => __( 'UTC-6', 'location-weather' ),
									'UTC-5.5'   => __( 'UTC-5:30', 'location-weather' ),
									'UTC-5'     => __( 'UTC-5', 'location-weather' ),
									'UTC-4.5'   => __( 'UTC-4:30', 'location-weather' ),
									'UTC-4'     => __( 'UTC-4', 'location-weather' ),
									'UTC-3.5'   => __( 'UTC-3:5', 'location-weather' ),
									'UTC-3'     => __( 'UTC-3', 'location-weather' ),
									'UTC-2.5'   => __( 'UTC-2:30', 'location-weather' ),
									'UTC-2'     => __( 'UTC-2', 'location-weather' ),
									'UTC-1.5'   => __( 'UTC-1:30', 'location-weather' ),
									'UTC-1'     => __( 'UTC-1', 'location-weather' ),
									'UTC-0.5'   => __( 'UTC-30', 'location-weather' ),
									'UTC+0'     => __( 'UTC+0', 'location-weather' ),
									'UTC+0.5'   => __( 'UTC+0:30', 'location-weather' ),
									'UTC+1'     => __( 'UTC+1', 'location-weather' ),
									'UTC+1.5'   => __( 'UTC+1:30', 'location-weather' ),
									'UTC+2'     => __( 'UTC+2', 'location-weather' ),
									'UTC+2.5'   => __( 'UTC+2:30', 'location-weather' ),
									'UTC+3'     => __( 'UTC+3', 'location-weather' ),
									'UTC+3.5'   => __( 'UTC+3:30', 'location-weather' ),
									'UTC+4'     => __( 'UTC+4', 'location-weather' ),
									'UTC+4.5'   => __( 'UTC+4:30', 'location-weather' ),
									'UTC+5'     => __( 'UTC+5', 'location-weather' ),
									'UTC+5.5'   => __( 'UTC+5:30', 'location-weather' ),
									'UTC+5.75'  => __( 'UTC+5:45', 'location-weather' ),
									'UTC+6'     => __( 'UTC+6', 'location-weather' ),
									'UTC+6.5'   => __( 'UTC+6:30', 'location-weather' ),
									'UTC+7'     => __( 'UTC+7', 'location-weather' ),
									'UTC+7.5'   => __( 'UTC+7:30', 'location-weather' ),
									'UTC+8'     => __( 'UTC+8', 'location-weather' ),
									'UTC+8.5'   => __( 'UTC+8:30', 'location-weather' ),
									'UTC+8.75'  => __( 'UTC+8:45', 'location-weather' ),
									'UTC+9'     => __( 'UTC+9', 'location-weather' ),
									'UTC+9.5'   => __( 'UTC+9:30', 'location-weather' ),
									'UTC+10'    => __( 'UTC+10', 'location-weather' ),
									'UTC+10.5'  => __( 'UTC+10:30', 'location-weather' ),
									'UTC+11'    => __( 'UTC+11', 'location-weather' ),
									'UTC+11.5'  => __( 'UTC+11:30', 'location-weather' ),
									'UTC+12'    => __( 'UTC+12', 'location-weather' ),
									'UTC+12.5'  => __( 'UTC+12:30', 'location-weather' ),
									'UTC+12.75' => __( 'UTC+12:45', 'location-weather' ),
									'UTC+13'    => __( 'UTC+13', 'location-weather' ),
									'UTC+13.5'  => __( 'UTC+13:30', 'location-weather' ),
									'UTC+13.75' => __( 'UTC+13:45', 'location-weather' ),
									'UTC+14'    => __( 'UTC+14', 'location-weather' ),
								),
								'default'    => '',
								'title_info' => '<div class="lw-info-label">' . __( 'Time Zone', 'location-weather' ) . '</div> <div class="lw-short-content">' . __( 'Recommended to use Default (auto-detected). If your location time is incorrect, use this option to adjust it.', 'location-weather' ) . '</div>',
							),
							array(
								'id'         => 'lw-language',
								'type'       => 'select',
								'title'      => __( 'Language', 'location-weather' ),
								'title_info' => '<div class="lw-info-label">' . __( 'OpenWeatherMap Language', 'location-weather' ) . '</div> <div class="lw-short-content">' . __( 'This is the language for the data from OpenWeatherMap, not for this plugin. English is set as default language.', 'location-weather' ) . '</div>',
								'options'    => array(
									'en'    => __( 'English', 'location-weather' ),
									'af'    => __( 'Afrikaans', 'location-weather' ),
									'sq'    => __( 'Albanian', 'location-weather' ), // al for Albanian.
									'ar'    => __( 'Arabic', 'location-weather' ),
									'az'    => __( 'Azerbaijani', 'location-weather' ),
									'bg'    => __( 'Bulgarian', 'location-weather' ),
									'ca'    => __( 'Catalan', 'location-weather' ),
									'cz'    => __( 'Czech', 'location-weather' ),
									'da'    => __( 'Danish', 'location-weather' ),
									'de'    => __( 'German', 'location-weather' ),
									'el'    => __( 'Greek', 'location-weather' ),
									'eu'    => __( 'Basque', 'location-weather' ),
									'fa'    => __( 'Persian (Farsi)', 'location-weather' ),
									'fi'    => __( 'Finnish', 'location-weather' ),
									'fr'    => __( 'French', 'location-weather' ),
									'gl'    => __( 'Galician', 'location-weather' ),
									'he'    => __( 'Hebrew', 'location-weather' ),
									'hi'    => __( 'Hindi', 'location-weather' ),
									'hr'    => __( 'Croatian', 'location-weather' ),
									'hu'    => __( 'Hungarian', 'location-weather' ),
									'id'    => __( 'Indonesian', 'location-weather' ),
									'it'    => __( 'Italian', 'location-weather' ),
									'ja'    => __( 'Japanese', 'location-weather' ),
									'kr'    => __( 'Korean', 'location-weather' ),
									'la'    => __( 'Latvian', 'location-weather' ),
									'lt'    => __( 'Lithuanian', 'location-weather' ),
									'mk'    => __( 'Macedonian', 'location-weather' ),
									'no'    => __( 'Norwegian', 'location-weather' ),
									'nl'    => __( 'Dutch', 'location-weather' ),
									'pl'    => __( 'Polish', 'location-weather' ),
									'pt'    => __( 'Portuguese', 'location-weather' ),
									'pt_br' => __( 'Português Brasil', 'location-weather' ),
									'ro'    => __( 'Romanian', 'location-weather' ),
									'ru'    => __( 'Russian', 'location-weather' ),
									'sv'    => __( 'Swedish', 'location-weather' ), // sv, se for Swedish.
									'sk'    => __( 'Slovak', 'location-weather' ),
									'sl'    => __( 'Slovenian', 'location-weather' ),
									'es'    => __( 'Spanish', 'location-weather' ), // sp, es for spanish lang.
									'sr'    => __( 'Serbian', 'location-weather' ),
									'th'    => __( 'Thai', 'location-weather' ),
									'tr'    => __( 'Turkish', 'location-weather' ),
									'uk'    => __( 'Ukrainian', 'location-weather' ), // ua, uk for Ukrainian lang.
									'vi'    => __( 'Vietnamese', 'location-weather' ),
									'zh_cn' => __( 'Chinese Simplified', 'location-weather' ),
									'zh_tw' => __( 'Chinese Traditional', 'location-weather' ),
									'zu'    => __( 'Zulu', 'location-weather' ),

								),
								'default'    => 'en',
							),
							array(
								'id'         => 'lw-preloader',
								'type'       => 'switcher',
								'title'      => __( 'Preloader', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'location-weather' ),
								'text_off'   => __( 'Disabled', 'location-weather' ),
								'text_width' => 94,
							),
						),
					),
					array(
						'title'  => __( 'Current Weather', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-current-weather"></i></span>',
						'fields' => array(
							array(
								'id'         => 'lw-icon',
								'type'       => 'switcher',
								'title'      => __( 'Weather Condition Icon', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'               => 'weather-current-icon-type',
								'class'            => 'weather-current-icon-type',
								'forecast_preview' => true,
								'type'             => 'select',
								'title'            => __( 'Icon Type', 'location-weather' ),
								'options'          => array(
									'forecast_icon_set_one' => __( 'Animated', 'location-weather' ),
									'forecast_icon_set_two'   => __( 'Static (No-animation) ', 'location-weather' ),
									'forecast_icon_set_six' => __( 'Animated 2 (Line)', 'location-weather' ),
									'forecast_icon_set_seven' => __( 'Animated 3', 'location-weather' ),
									'forecast_icon_set_three' => __( 'Light (Line) ', 'location-weather' ),
									'forecast_icon_set_eight' => __( 'Medium (Line) ', 'location-weather' ),
									'forecast_icon_set_four'  => __( 'Fill ', 'location-weather' ),
									'forecast_icon_set_five'  => __( 'Glassmorphism', 'location-weather' ),
								),
								'title_info'       => '<div class="lw-info-label">' . __( 'Icon Type', 'location-weather' ) . '</div> <div class="lw-short-content">' . __( 'Choose a icon type to visually represent various weather conditions in current weather. These icon sets offer a variety of design options for displaying current weather information.', 'location-weather' ) . '</div><div class="info-button"><a class="lw-open-docs" href="https://locationweather.io/docs/how-to-configure-current-weather-icon-type/" target="_blank">' . __( 'Open Docs', 'location-weather' ) . '</a></div>',
								'default'          => 'forecast_icon_set_one',
								'dependency'       => array( 'lw-icon', '==', 'true', true ),
							),
							array(
								'id'         => 'lw-current-icon-color',
								'type'       => 'color',
								'class'      => 'lw-forecast-data-pro',
								'title'      => __( 'Icon Color', 'location-weather' ),
								'default'    => '#fff',
								'dependency' => array( 'lw-icon|weather-current-icon-type', '==|any', 'true|forecast_icon_set_three,forecast_icon_set_four', true ),
							),
							array(
								'id'         => 'lw_current_icon_size',
								'type'       => 'spinner',
								'class'      => 'current-icon-size',
								'title'      => __( 'Icon size', 'location-weather' ),
								'unit'       => __( 'px', 'location-weather' ),
								'max'        => 30000,
								'min'        => 1,
								'default'    => 58,
								'dependency' => array( 'lw-icon', '==', 'true', true ),
							),
							array(
								'id'         => 'lw-temperature',
								'type'       => 'switcher',
								'title'      => __( 'Temperature', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-high-low-temperature',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'High & Low Temperature', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-real-feel',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'Real Feel', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-short-description',
								'type'       => 'switcher',
								'title'      => __( 'Weather Condition Short Description', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'type'    => 'notice',
								'style'   => 'normal',
								/* translators: %1$s: anchor tag start, %2$s: anchor tag end. */
								'content' => sprintf( __( 'To show more weather details & stylish icons, %1$sUpgrade to Pro!%2$s', 'location-weather' ), '<a class="lw-open-live-demo" href="https://locationweather.io/pricing/?ref=1" target="_blank"><strong>', '</strong></a>' ),
							),
						),
					),
					array(
						'title'  => __( 'Control Additional Data', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-additional-data"></i></span>',
						'fields' => array(
							array(
								'id'         => 'lw-pressure',
								'type'       => 'switcher',
								'title'      => __( 'Pressure', 'location-weather' ),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div>%s',
									__( 'Atmospheric or Air Pressure', 'location-weather' ),
									__( 'Atmospheric or air pressure on the sea level.', 'location-weather' )
								),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-humidity',
								'type'       => 'switcher',
								'title'      => __( 'Humidity', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-wind',
								'type'       => 'switcher',
								'title'      => __( 'Wind', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-precipitation',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'Precipitation', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-clouds',
								'type'       => 'switcher',
								'title'      => __( 'Clouds', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-rain-chance',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'Rain Chance', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-snow',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'Snow', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-wind-gusts',
								'type'       => 'switcher',
								'title'      => __( 'Wind Gust', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-uv-index',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'UV Index', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div> <div class="lw-short-content">%s</div>',
									__( 'UV Index', 'location-weather' ),
									__( 'The UV index measures the strength of UV radiation from the sun, indicating potential risks of sun exposure, with higher values signifying increased risk. It’s used in weather forecasts to guide sun protection measures.', 'location-weather' )
								),
							),
							array(
								'id'         => 'lw-dew-point',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'Dew Point', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div> <div class="lw-short-content">%s</div>',
									__( 'Dew Point', 'location-weather' ),
									__( 'Set weather for specific locations with coordinates to display the Dew Point.', 'location-weather' )
								),
							),
							array(
								'id'         => 'lw-air-quality',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'Air Quality', 'location-weather' ),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div> <div class="lw-short-content">%s</div>',
									__( 'Air Quality', 'location-weather' ),
									__( 'Set weather for specific locations with coordinates to display the Air Quality.', 'location-weather' )
								),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-visibility',
								'type'       => 'switcher',
								'title'      => __( 'Visibility', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-sunrise-sunset',
								'type'       => 'switcher',
								'title'      => __( 'Sunrise & Sunset Time', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-moonrise-moonset',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'Moonrise & Moonset Time', 'location-weather' ),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div> <div class="lw-short-content">%s</div>',
									__( 'Moonrise & Moonset Time', 'location-weather' ),
									__( 'Set weather for specific locations with coordinates to display the Moonrise & Moonset Time.', 'location-weather' )
								),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-moon-phase',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'Moon Phase', 'location-weather' ),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div> <div class="lw-short-content">%s</div>',
									__( 'Moon Phase', 'location-weather' ),
									__( 'Set weather for specific locations with coordinates to display the Moon Phase.', 'location-weather' )
								),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-national-alerts',
								'class'      => 'splw_show_hide',
								'type'       => 'switcher',
								'title'      => __( 'National Weather Alerts', 'location-weather' ),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div> <div class="lw-short-content">%s</div>',
									__( 'Display National Weather Alerts', 'location-weather' ),
									__( 'Set weather for specific locations with coordinates to display the National Weather Alerts.', 'location-weather' )
								),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'type'    => 'notice',
								'style'   => 'normal',
								'content' => sprintf(
									/* translators: %1$s: anchor tag start, %2$s: anchor tag end. */
									__( 'To gain access to additional weather data, %1$sUpgrade to Pro!%2$s', 'location-weather' ),
									'<a class="lw-open-live-demo" href="https://locationweather.io/pricing/?ref=1" target="_blank"><strong>',
									'</strong></a>'
								),
							),
						),
					),
					array(
						'title'  => __( 'Additional Data Styles', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-additional-data-style"></i></span>',
						'fields' => array(
							array(
								'id'         => 'weather-additional-data-layout',
								'class'      => 'weather-additional-data-layout',
								'type'       => 'image_select',
								'title'      => __( 'Additional Data Layout', 'location-weather' ),
								'options'    => array(
									'center'               => array(
										'image' => SPLW::include_plugin_url( 'assets/images/additional-data-layout/list-center.svg' ),
										'name'  => __( 'List Center', 'location-weather' ),
									),
									'left'                 => array(
										'image' => SPLW::include_plugin_url( 'assets/images/additional-data-layout/list-left.svg' ),
										'name'  => __( 'List Left', 'location-weather' ),
									),
									'justified'            => array(
										'image' => SPLW::include_plugin_url( 'assets/images/additional-data-layout/list-justified.svg' ),
										'name'  => __( 'List Justified', 'location-weather' ),
									),
									'column-two'           => array(
										'image'    => SPLW::include_plugin_url( 'assets/images/additional-data-layout/list-2-column.svg' ),
										'name'     => __( 'List 2-Column', 'location-weather' ),
										'pro_only' => true,
									),
									'column-two-justified' => array(
										'image'    => SPLW::include_plugin_url( 'assets/images/additional-data-layout/list-2-col-justified.svg' ),
										'name'     => __( '2-Col Justified', 'location-weather' ),
										'pro_only' => true,
									),
									'grid-one'             => array(
										'image'    => SPLW::include_plugin_url( 'assets/images/additional-data-layout/list-2-column-1.svg' ),
										'name'     => __( 'Grid 1', 'location-weather' ),
										'pro_only' => true,
									),
									'grid-two'             => array(
										'image'    => SPLW::include_plugin_url( 'assets/images/additional-data-layout/grid-1.svg' ),
										'name'     => __( 'Grid 2', 'location-weather' ),
										'pro_only' => true,
									),
									'grid-three'           => array(
										'image'    => SPLW::include_plugin_url( 'assets/images/additional-data-layout/grid-2.svg' ),
										'name'     => __( 'Grid 3', 'location-weather' ),
										'pro_only' => true,
									),
									'carousel-simple'      => array(
										'image'    => SPLW::include_plugin_url( 'assets/images/additional-data-layout/carousel-simple.svg' ),
										'name'     => __( 'Carousel Simple', 'location-weather' ),
										'pro_only' => true,
									),
									'carousel-flat'        => array(
										'image'    => SPLW::include_plugin_url( 'assets/images/additional-data-layout/carousel-flat.svg' ),
										'name'     => __( 'Carousel Flat', 'location-weather' ),
										'pro_only' => true,
									),
								),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div><div class="lw-short-content">%s</div><div class="info-button"><a class="lw-open-docs" href="https://locationweather.io/docs/how-to-set-weather-additional-data-layout/" target="_blank">%s</a><a class="lw-open-live-demo" href="https://locationweather.io/demos/additional-data-layouts/" target="_blank">%s</a></div>',
									__( 'Additional Data Layout', 'location-weather' ),
									__( 'These styles allow you to choose the presentation that best suits your design and provides additional customization options for displaying weather data. See how it works.', 'location-weather' ),
									__( 'Open Docs', 'location-weather' ),
									__( 'Live Demo', 'location-weather' )
								),
								'default'    => 'center',
								'dependency' => array( 'weather-view', '==', 'vertical', true ),
							),
							array(
								'id'         => 'lw-comport-data-position',
								'type'       => 'checkbox',
								'title'      => __( 'Comport Data in List View', 'location-weather' ),
								'default'    => false,
								'title_info' => '<div class="lw-img-tag"><img src="' . SPLW::include_plugin_url( 'assets/images/comport-data-position.svg' ) . '" alt="comport-data-position"></div><div class="lw-info-label img">' . __( 'Comport Data in List View', 'location-weather' ) . '</div>',
								'dependency' => array( 'weather-view|weather-additional-data-layout', '==|any', 'vertical|justified,left,center', true ),
							),
							array(
								'id'         => 'weather-layout-style',
								'type'       => 'image_select',
								'class'      => 'weather-layout-style',
								'title'      => __( 'Layout Style', 'location-weather' ),
								'options'    => array(
									'clean'   => array(
										'image' => SPLW::include_plugin_url( 'assets/images/layout-style/clean.svg' ),
										'name'  => __( 'Clean', 'location-weather' ),
									),
									'divided' => array(
										'image'    => SPLW::include_plugin_url( 'assets/images/layout-style/divided.svg' ),
										'name'     => __( 'Divided', 'location-weather' ),
										'pro_only' => true,
									),
									'striped' => array(
										'image'    => SPLW::include_plugin_url( 'assets/images/layout-style/striped.svg' ),
										'name'     => __( 'Striped', 'location-weather' ),
										'pro_only' => true,
									),
								),
								'default'    => 'clean',
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div><div class="lw-short-content">%s</div><div class="info-button"><a class="lw-open-docs" href="https://locationweather.io/docs/how-to-configure-weather-additional-data-layout-style/" target="_blank">%s</a></div>',
									__( 'Layout Style', 'location-weather' ),
									__( 'Layout Styles provide different visual presentations for your weather data, allowing you to choose the one that best fits your design preferences.', 'location-weather' ),
									__( 'Open Docs', 'location-weather' )
								),
								'dependency' => array( 'weather-view|weather-additional-data-layout', '==|any', 'vertical|column-two-justified,column-two,justified,left,center', true ),
							),
							array(
								'id'         => 'lw-weather-icons',
								'type'       => 'switcher',
								'class'      => 'show-weather-icons',
								'title'      => __( 'Display Icon', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'weather-icon-type',
								'class'      => 'weather-icon-type',
								'preview'    => true,
								'type'       => 'select',
								'title'      => __( 'Icon Type', 'location-weather' ),
								'options'    => array(
									'icon_set_one'   => __( 'Regular', 'location-weather' ),
									'icon_set_two'   => __( 'Fill', 'location-weather' ),
									'icon_set_three' => __( 'Light', 'location-weather' ),
									'icon_set_four'  => __( 'Light 2', 'location-weather' ),
									'icon_set_five'  => __( 'Generic Mixed', 'location-weather' ),
								),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div><div class="lw-short-content">%s</div><div class="info-button"><a class="lw-open-docs" href="https://locationweather.io/docs/how-to-choose-weather-additional-data-icon/" target="_blank">%s</a></div>',
									__( 'Icon Type', 'location-weather' ),
									__( 'Choose an icon set of three distinct sets of icons for displaying additional weather data. These icon sets enhance the visual presentation of additional weather data nicely.', 'location-weather' ),
									__( 'Open Docs', 'location-weather' )
								),
								'default'    => 'icon_set_one',
								'dependency' => array( 'lw-weather-icons', '==', 'true', true ),
							),
							array(
								'id'         => 'lw-icon-color',
								'type'       => 'color_group',
								'title'      => __( 'Icon Color', 'location-weather' ),
								'options'    => array(
									'color' => __( 'Color', 'location-weather' ),
								),
								'default'    => array(
									'color' => '#ffffff',
								),
								'dependency' => array( 'lw-weather-icons', '==', 'true', true ),
							),
							array(
								'id'         => 'lw_icon_size',
								'class'      => 'lw_icon_size',
								'type'       => 'spinner',
								'title'      => __( 'Icon size', 'location-weather' ),
								'unit'       => __( 'px', 'location-weather' ),
								'max'        => 30000,
								'min'        => 1,
								'default'    => 16,
								'dependency' => array( 'lw-weather-icons', '==', 'true', true ),

							),
							array(
								'id'              => 'lw_additional-data-space',
								'type'            => 'spacing',
								'class'           => 'lw-additional-data-space-between',
								'title'           => __( 'Space', 'location-weather' ),
								'units'           => array(
									__( 'px', 'location-weather' ),
								),
								'all'             => true,
								'all_title'       => __( 'Vertical', 'location-weather' ),
								'horizontal'      => true,
								'all_icon'        => '<i class="fa fa-arrows-v" aria-hidden="true"></i>',
								'horizontal_icon' => '<i class="fa fa-arrows-h" aria-hidden="true"></i>',
								'default'         => array(
									'all'        => '4',
									'horizontal' => '0',
								),
								'title_info'      => '<div class="lw-img-tag"><img src="' . SPLW::include_plugin_url( 'assets/images/space.webp' ) . '" alt=""></div><div class="lw-info-label img">' . __( 'Space', 'location-weather' ) . '</div>',
								'dependency'      => array( 'weather-view|weather-additional-data-layout', '==|any', 'vertical|column-two-justified,column-two,justified,left,center', true ),
							),
							array(
								'id'      => 'lw_additional-data-border',
								'type'    => 'border',
								'class'   => 'lw-forecast-data-pro',
								'title'   => __( 'Border', 'location-weather' ),
								'all'     => true,
								'radius'  => true,
								'default' => array(
									'all'    => '1',
									'style'  => 'solid',
									'color'  => '#e2e2e2',
									'radius' => '4',
								),
							),
							array(
								'id'         => 'lw-weather-additional-data-margin',
								'type'       => 'spacing',
								'class'      => 'lw-weather-additional-data-margin',
								'title'      => __( 'Margin', 'location-weather' ),
								'units'      => array(
									__( 'px', 'location-weather' ),
								),
								'right'      => false,
								'left'       => false,
								'default'    => array(
									'top'    => '8',
									'bottom' => '3',
								),
								'title_info' => '<div class="lw-img-tag"><img src="' . SPLW::include_plugin_url( 'assets/images/additional-data-area-margin.svg' ) . '" alt="weather-content-padding"></div><div class="lw-info-label img">' . __( 'Additional Data Area Margin', 'location-weather' ) . '</div>',
							),
							array(
								'type'    => 'notice',
								'style'   => 'normal',
								'class'   => 'notice-padding',
								/* translators: %1$s: anchor tag start, %2$s: first anchor tag end,%3$s: second anchor tag start, %4$s: second anchor tag end. */
								'content' => sprintf( __( 'To display weather data in %1$sAdditional Styles%2$s with advanced customizations, %3$sUpgrade to Pro!%4$s', 'location-weather' ), '<a class="lw-open-live-demo" href="https://locationweather.io/demos/additional-data-layouts/" target="_blank"><strong>', '</strong></a>', '<a class="lw-open-live-demo" href="https://locationweather.io/pricing/?ref=1" target="_blank"><strong>', '</strong></a>' ),

							),
							array(
								'id'    => 'lw-carousel-heading',
								'class' => 'carousel-options',
								'type'  => 'subheading',
								'title' => __( 'Weather Additional Data Carousel', 'location-weather' ),
							),
							array(
								'id'         => 'enable-carousel-autoplay',
								'type'       => 'switcher',
								'class'      => 'lw-forecast-data-pro',
								'title'      => __( 'Carousel AutoPlay', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'location-weather' ),
								'text_off'   => __( 'Disabled', 'location-weather' ),
								'text_width' => 94,

							),
							array(
								'id'         => 'carousel-autoplay-speed',
								'type'       => 'spinner',
								'class'      => 'lw-forecast-data-pro ',
								'title'      => __( 'AutoPlay Delay Time', 'location-weather' ),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div>%s',
									__( 'AutoPlay Delay Time', 'location-weather' ),
									__( 'Set autoplay delay or interval time. The amount of time to delay between automatically cycling a weather item. For example, 1000 milliseconds (ms) equals 1 second.', 'location-weather' )
								),
								'unit'       => __( 'ms', 'location-weather' ),
								'max'        => 30000,
								'min'        => 1,
								'default'    => 3000,
							),
							array(
								'id'         => 'carousel-speed',
								'type'       => 'spinner',
								'class'      => 'lw-forecast-data-pro',
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div>%s',
									__( 'Carousel Speed', 'location-weather' ),
									__( 'Set carousel scrolling speed. For example, 1000 milliseconds (ms) equals 1 second.', 'location-weather' )
								),
								'title'      => __( 'Carousel Speed', 'location-weather' ),
								'unit'       => __( 'ms', 'location-weather' ),
								'max'        => 30000,
								'min'        => 1,
								'default'    => 600,
							),
							array(
								'id'         => 'carousel_onhover',
								'type'       => 'switcher',
								'class'      => 'lw-forecast-data-pro',
								'title'      => __( 'Stop on Hover', 'location-weather' ),
								'text_on'    => __( 'Enabled', 'location-weather' ),
								'text_off'   => __( 'Disabled', 'location-weather' ),
								'text_width' => 94,
								'default'    => false,
							),
							array(
								'id'       => 'lw_carousel-column',
								'class'    => 'lw-forecast-data-pro',
								'type'     => 'spacing',
								'title'    => __( 'Columns', 'location-weather' ),
								'all'      => true,
								'all_icon' => '<i class="fa fa-desktop"></i>',
								'min'      => 1,
								'max'      => 10,
								'unit'     => false,
								'default'  => array(
									'all' => '3',
								),
							),
							array(
								'id'      => 'weather-details-nav-icon',
								'class'   => 'lw-forecast-data-pro nav-icons',
								'type'    => 'button_set',
								'title'   => __( 'Navigation Icon', 'location-weather' ),
								'options' => array(
									'chevron' => '<i class="fas fa-chevron-right"></i>',
									'angle'   => '<i class="fas fa-angle-right"></i>',
									'arrow'   => '<i class="fas fa-arrow-right"></i>',
									'none'    => __( 'Hide', 'location-weather' ),
								),
								'default' => 'none',
							),
							array(
								'id'      => 'weather-details-nav-color',
								'type'    => 'color_group',
								'class'   => 'lw-forecast-data-pro',
								'title'   => __( 'Navigation Color', 'location-weather' ),
								'options' => array(
									'color'      => __( 'Arrow Color', 'location-weather' ),
									'background' => __( 'Hover Color', 'location-weather' ),
								),
								'default' => array(
									'color'      => '#ffffff',
									'background' => '#ffffff',
								),
							),
							array(
								'type'    => 'notice',
								'style'   => 'normal',
								'class'   => 'notice-padding',
								/* translators: %1$s: anchor tag start, %2$s: first anchor tag end,%3$s: second anchor tag start, %4$s: second anchor tag end. */
								'content' => sprintf( __( 'To unlock the %1$sWeather Data Carousel%2$s with flexible options, %3$sUpgrade to Pro!%4$s', 'location-weather' ), '<a class="lw-open-live-demo" href="https://locationweather.io/demos/weather-carousel/" target="_blank"><strong>', '</strong></a>', '<a class="lw-open-live-demo" href="https://locationweather.io/pricing/?ref=1" target="_blank"><strong>', '</strong></a>' ),
							),
						),
					),
					array(
						'title'  => __( 'Weather Forecast Data', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-forecast-data"></i></span>',
						'fields' => array(
							array(
								'id'         => 'lw-enable-forecast',
								'type'       => 'switcher',
								'title'      => __( 'Enable Weather Forecast', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Enabled', 'location-weather' ),
								'text_off'   => __( 'Disabled', 'location-weather' ),
								'text_width' => 94,
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div><div class="lw-short-content">%s</div>',
									__( 'Enable Weather Forecast', 'location-weather' ),
									__( 'This option allows you to enable or activate weather forecasts, providing users with future weather predictions and enhancing the utility of your weather feature.', 'location-weather' )
								),
							),
							array(
								'id'         => 'lw_forecast_data_sortable',
								'type'       => 'sortable',
								'title'      => __( 'Forecast Data', 'location-weather' ),
								'class'      => 'style_generator_sortable',
								'dependency' => array( 'lw-enable-forecast', '==', 'true' ),
								'default'    => array(
									'temperature'   => true,
									'precipitation' => true,
									'rainchance'    => true,
									'wind'          => true,
									'humidity'      => true,
									'pressure'      => true,
									'snow'          => false,
								),
								'fields'     => array(
									array(
										'id'         => 'temperature',
										'type'       => 'switcher',
										'title'      => __( 'Temperature', 'location-weather' ),
										'text_on'    => __( 'Show', 'location-weather' ),
										'text_off'   => __( 'Hide', 'location-weather' ),
										'text_width' => 75,
									),
									array(
										'id'         => 'precipitation',
										'type'       => 'switcher',
										'title'      => __( 'Precipitation', 'location-weather' ),
										'text_on'    => __( 'Show', 'location-weather' ),
										'text_off'   => __( 'Hide', 'location-weather' ),
										'text_width' => 75,
									),
									array(
										'id'         => 'rainchance',
										'type'       => 'switcher',
										'title'      => __( 'Rain Chance', 'location-weather' ),
										'text_on'    => __( 'Show', 'location-weather' ),
										'text_off'   => __( 'Hide', 'location-weather' ),
										'text_width' => 75,
									),
									array(
										'id'         => 'wind',
										'class'      => 'wind_switch',
										'type'       => 'switcher',
										'title'      => __( 'Wind', 'location-weather' ),
										'text_on'    => __( 'Show', 'location-weather' ),
										'text_off'   => __( 'Hide', 'location-weather' ),
										'text_width' => 75,
									),
									array(
										'id'         => 'humidity',
										'class'      => 'humidity_switch',
										'type'       => 'switcher',
										'title'      => __( 'Humidity', 'location-weather' ),
										'text_on'    => __( 'Show', 'location-weather' ),
										'text_off'   => __( 'Hide', 'location-weather' ),
										'text_width' => 75,
									),
									array(
										'id'         => 'pressure',
										'type'       => 'switcher',
										'title'      => __( 'Pressure', 'location-weather' ),
										'text_on'    => __( 'Show', 'location-weather' ),
										'text_off'   => __( 'Hide', 'location-weather' ),
										'text_width' => 75,
									),
									array(
										'id'         => 'snow',
										'type'       => 'switcher',
										'title'      => __( 'Snow', 'location-weather' ),
										'text_on'    => __( 'Show', 'location-weather' ),
										'text_off'   => __( 'Hide', 'location-weather' ),
										'text_width' => 75,
									),
								),
							),
							array(
								'id'         => 'enable-graph-chart',
								'type'       => 'switcher',
								'class'      => 'lw-forecast-data-pro splw_show_hide lw-graph-chart',
								'title'      => __( 'Weather Graph Chart', 'location-weather' ),
								'text_on'    => __( 'Enabled', 'location-weather' ),
								'text_off'   => __( 'Disabled', 'location-weather' ),
								'text_width' => 100,
								'only_pro'   => true,
								'default'    => 'true',
								'dependency' => array( 'lw-enable-forecast', '==', 'true' ),
							),
							array(
								'id'         => 'lw-forecast-type',
								'class'      => 'lw-forecast-type',
								'type'       => 'button_set',
								'title'      => __( 'Weather Forecast Type', 'location-weather' ),
								'options'    => array(
									'daily'  => __( 'Daily', 'location-weather' ),
									'hourly' => __( 'Hourly', 'location-weather' ),
									'both'   => __( 'Both', 'location-weather' ),
								),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div><div class="lw-short-content">%s</div><div class="info-button"><a class="lw-open-docs" href="https://locationweather.io/docs/how-to-configure-weather-forecast-type/" target="_blank">%s</a><a class="lw-open-live-demo" href="https://locationweather.io/demos/daily-hourly-weather-forecast/" target="_blank">%s</a></div>',
									__( 'Weather Forecast Type', 'location-weather' ),
									__( 'The Weather Forecast Type option offers flexibility by allowing you to choose between daily, hourly, or a combination of both formats for displaying weather forecasts.', 'location-weather' ),
									__( 'Open Docs', 'location-weather' ),
									__( 'Live Demo', 'location-weather' )
								),
								'desc'       => sprintf(
								/* translators: 1: start link tag, 2: close tag. */
									__( 'This is a %1$sPro feature!%2$s', 'location-weather' ),
									'<a class="lw-open-live-demo" href="https://locationweather.io/pricing/?ref=1" target="_blank">',
									'</a>'
								),
								'default'    => 'hourly',
								'dependency' => array( 'lw-enable-forecast', '==', 'true' ),
							),
							array(
								'id'         => 'lw-forecast-day',
								'class'      => 'lw-forecast-data-pro',
								'type'       => 'select',
								'title'      => 'Number of Forecast Days to Show',
								'options'    => array(
									'5' => __( '16 Days', 'location-weather' ),
								),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div><div class="lw-short-content">%s</div><a class="lw-open-docs" href="https://locationweather.io/docs/docs/how-to-set-the-number-of-forecast-days-to-show/" target="_blank">%s</a>',
									__( 'Forecast Days To Show', 'location-weather' ),
									__( 'Set the number of days you want to show weather forecasts for.', 'location-weather' ),
									__( 'Open Docs', 'location-weather' )
								),
								'default'    => '5',
								'dependency' => array( 'lw-enable-forecast|lw-forecast-type', '==|!=', 'true|hourly' ),
							),
							array(
								'id'         => 'lw-forecast-day-name-length',
								'class'      => 'lw-forecast-data-pro',
								'type'       => 'radio',
								'title'      => __( 'Forecast Days Name Length Type', 'location-weather' ),
								'options'    => array(
									'normal' => __( 'Normal (Sunday)', 'location-weather' ),
									'short'  => __( 'Short (Sun)', 'location-weather' ),
								),
								'default'    => 'normal',
								'dependency' => array( 'lw-enable-forecast|lw-forecast-type', '==|!=', 'true|hourly' ),
							),
							array(
								'id'         => 'forecast-title',
								'class'      => 'lw-forecast-data-pro',
								'type'       => 'text',
								'title'      => __( 'Daily Forecast Title', 'location-weather' ),
								'default'    => __( 'Daily Forecast', 'location-weather' ),
								'dependency' => array( 'lw-enable-forecast|lw-forecast-type', '==|!=', 'true|hourly', true ),
							),
							array(
								'id'         => 'lw-hourly-type',
								'type'       => 'button_set',
								'title'      => __( 'Hourly Forecast Type', 'location-weather' ),
								'options'    => array(
									'one-hour'   => __( '1-Hour', 'location-weather' ),
									'three-hour' => __( '3-Hour', 'location-weather' ),
								),
								'title_info' =>
									__(
										'OpenWeatherAPI free api you can show only 3 hourly forecast.',
										'location-weather'
									),
								'default'    => 'three-hour',
								'dependency' => array( 'lw-enable-forecast|lw-forecast-type', '==|!=', 'true|daily' ),
							),
							array(
								'id'         => 'lw-number-forecast-hours',
								'type'       => 'spinner',
								'class'      => 'lw-number-forecast-hours',
								'title'      => __( 'Number of Forecast Hours to Show', 'location-weather' ),
								'unit'       => __( 'Hours', 'location-weather' ),
								'max'        => 96,
								'min'        => 1,
								'default'    => 8,
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div><div class="lw-short-content">%s</div><div class="info-button"><a class="lw-open-docs" href="https://locationweather.io/docs/how-to-set-the-number-of-forecast-hours-to-show/" target="_blank">%s</a></div>',
									__( 'Forecast Hours To Show', 'location-weather' ),
									__( 'The maximum forecast data available is 48 hours for the One Call API and 96 hours for Developer, Professional, or Enterprise plans.', 'location-weather' ),
									__( 'Open Docs', 'location-weather' )
								),
								'desc'       => sprintf(
								/* translators: 1: start link tag, 2: close tag. */
									__( 'To show more than 8 hours, %1$sUpgrade to Pro!%2$s', 'location-weather' ),
									'<a class="lw-open-live-demo" href="https://locationweather.io/pricing/?ref=1" target="_blank">',
									'</a>'
								),
								'dependency' => array( 'lw-enable-forecast|lw-forecast-type|lw-hourly-type', '==|!=|==', 'true|daily|one-hour' ),
							),
							array(
								'id'         => 'lw-number-forecast-three-hours',
								'type'       => 'select',
								'class'      => 'lw-number-forecast-three-hours',
								'title'      => __( 'Number of Forecast Hours to Show', 'location-weather' ),
								'options'    => array(
									'1'  => __( '3 Hour', 'location-weather' ),
									'2'  => __( '6 Hours', 'location-weather' ),
									'3'  => __( '9 Hours', 'location-weather' ),
									'4'  => __( '12 Hours', 'location-weather' ),
									'5'  => __( '15 Hours', 'location-weather' ),
									'6'  => __( '18 Hours', 'location-weather' ),
									'7'  => __( '21 Hours', 'location-weather' ),
									'8'  => __( '24 Hours', 'location-weather' ),
									'9'  => __( '27 Hours', 'location-weather' ),
									'10' => __( '30 Hours', 'location-weather' ),
									'11' => __( '33 Hours', 'location-weather' ),
									'12' => __( '36 Hours', 'location-weather' ),
									'13' => __( '39 Hours', 'location-weather' ),
									'14' => __( '42 Hours', 'location-weather' ),
									'15' => __( '45 Hours', 'location-weather' ),
									'16' => __( '48 Hours', 'location-weather' ),
									'17' => __( '51 Hours', 'location-weather' ),
									'18' => __( '54 Hours', 'location-weather' ),
									'19' => __( '57 Hours', 'location-weather' ),
									'20' => __( '60 Hours', 'location-weather' ),
									'21' => __( '63 Hours', 'location-weather' ),
									'22' => __( '66 Hours', 'location-weather' ),
									'23' => __( '69 Hours', 'location-weather' ),
									'24' => __( '72 Hours', 'location-weather' ),
									'25' => __( '75 Hours', 'location-weather' ),
									'26' => __( '78 Hours', 'location-weather' ),
									'27' => __( '81 Hours', 'location-weather' ),
									'28' => __( '84 Hours', 'location-weather' ),
									'29' => __( '87 Hours', 'location-weather' ),
									'30' => __( '90 Hours', 'location-weather' ),
									'31' => __( '93 Hours', 'location-weather' ),
									'32' => __( '96 Hours', 'location-weather' ),
									'33' => __( '99 Hours', 'location-weather' ),
									'34' => __( '102 Hours', 'location-weather' ),
									'35' => __( '105 Hours', 'location-weather' ),
									'36' => __( '108 Hours', 'location-weather' ),
									'37' => __( '111 Hours', 'location-weather' ),
									'38' => __( '114 Hours', 'location-weather' ),
									'39' => __( '117 Hours', 'location-weather' ),
									'40' => __( '120 Hours', 'location-weather' ),
								),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div>%s',
									__( 'Forecast Hours To Show', 'location-weather' ),
									__( 'Set the number of the hours you want to show weather forecasts for.', 'location-weather' )
								),
								'desc'       => sprintf(
								/* translators: 1: start link tag, 2: close tag. */
									__( 'To show more than 24 hours, %1$sUpgrade to Pro!%2$s', 'location-weather' ),
									'<a class="lw-open-live-demo" href="https://locationweather.io/pricing/?ref=1" target="_blank">',
									'</a>'
								),
								'default'    => '8',
								'dependency' => array( 'lw-enable-forecast|lw-forecast-type|lw-hourly-type', '==|!=|==', 'true|daily|three-hour' ),
							),
							array(
								'id'         => 'hourly-forecast-title',
								'type'       => 'text',
								'title'      => __( 'Hourly Forecast Title', 'location-weather' ),
								'default'    => __( 'Hourly Forecast', 'location-weather' ),
								'dependency' => array( 'lw-enable-forecast|lw-forecast-type', '==|!=', 'true|daily', true ),
							),
							array(
								'id'         => 'lw-swap-forecast-display',
								'type'       => 'checkbox',
								'title'      => __( 'Swap Forecast Display', 'location-weather' ),
								'class'      => 'lw-forecast-data-pro',
								'default'    => false,
								'only_pro'   => true,
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div>%s',
									__( 'Swap Forecast Display', 'location-weather' ),
									__( 'Swap the layout style between Hourly (Filters) and Daily (Dropdown). Useful for reversing their positions and display formats.', 'location-weather' )
								),
								'dependency' => array( 'weather-view', '==', 'grid', true ),
							),
							array(
								'id'               => 'weather-forecast-icon-type',
								'class'            => 'weather-forecast-icon-type',
								'forecast_preview' => true,
								'type'             => 'select',
								'title'            => __( 'Icon Type', 'location-weather' ),
								'options'          => array(
									'forecast_icon_set_one'   => __( 'Animated', 'location-weather' ),
									'forecast_icon_set_two'   => __( 'Static (No-animation) ', 'location-weather' ),
									'forecast_icon_set_six'   => __( 'Animated 2 (Line)', 'location-weather' ),
									'forecast_icon_set_seven' => __( 'Animated 3', 'location-weather' ),
									'forecast_icon_set_three' => __( 'Light (Line) ', 'location-weather' ),
									'forecast_icon_set_eight' => __( 'Medium (Line) ', 'location-weather' ),
									'forecast_icon_set_four'  => __( 'Fill ', 'location-weather' ),
									'forecast_icon_set_five'  => __( 'Glassmorphism', 'location-weather' ),
								),
								'title_info'       => sprintf(
									'<div class="lw-info-label">%s</div><div class="lw-short-content">%s</div><div class="info-button"><a class="lw-open-docs" href="https://locationweather.io/docs/how-to-configure-forecast-data-icon-type/" target="_blank">%s</a></div>',
									__( 'Icon Type', 'location-weather' ),
									__( 'Choose an icon type to visually represent various weather conditions in weather forecasts. These icon sets offer a variety of design options for displaying forecasted weather information.', 'location-weather' ),
									__( 'Open Docs', 'location-weather' )
								),
								'default'          => 'forecast_icon_set_one',
								'dependency'       => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'type'    => 'notice',
								'style'   => 'normal',
								'class'   => 'forecast-pro-notice',
								'content' => sprintf(
									/* translators: 1: start link tag, 2: close link tag 3: start link and strong tag. 4: close link and strong tag. */
									__( 'To display advanced %1$sWeather Forecast Data%2$s with customizable options, %3$sUpgrade to Pro!%4$s', 'location-weather' ),
									'<a href="https://locationweather.io/demos/daily-hourly-weather-forecast/" target="_blank"><strong>',
									'</strong></a>',
									'<a class="lw-open-live-demo" href="https://locationweather.io/pricing/?ref=1" target="_blank"><strong>',
									'</strong></a>'
								),
							),
							array(
								'id'         => 'lw-hourly-time-style',
								'class'      => 'lw-forecast-data-pro',
								'type'       => 'checkbox',
								'title'      => __( 'Display Day/Date with Hour', 'location-weather' ),
								'default'    => false,
								'dependency' => array( 'lw-enable-forecast|lw-forecast-type', '==|!=', 'true|daily' ),
							),
							array(
								'id'         => 'lw-forecast-icon-color',
								'class'      => 'lw-forecast-data-pro',
								'type'       => 'color',
								'title'      => __( 'Icon Color', 'location-weather' ),
								'default'    => '#fff',
								'dependency' => array( 'lw-enable-forecast', '==', 'true' ),
							),
							array(
								'id'         => 'lw_forecast_icon_size',
								'type'       => 'spinner',
								'class'      => 'forecast-icon-size lw-forecast-data-pro',
								'title'      => __( 'Icon size', 'location-weather' ),
								'unit'       => __( 'px', 'location-weather' ),
								'max'        => 30000,
								'min'        => 1,
								'default'    => 50,
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'id'         => 'lw-forecast-background-color',
								'type'       => 'color',
								'class'      => 'lw-forecast-data-pro',
								'title'      => __( 'Forecast Data Background', 'location-weather' ),
								'default'    => 'transparent',
								'title_info' => '<div class="lw-img-tag"><img src="' . SPLW::include_plugin_url( 'assets/images/weather-forecast-data-background.webp' ) . '" alt="weather-content-padding"></div><div class="lw-info-label img">' . __( 'Weather Forecast Data Background', 'location-weather' ) . '</div>',
								'dependency' => array( 'lw-enable-forecast|weather-template|weather-view', '==|any|==', 'true|template-one,template-two,template-three|vertical', true ),
							),
							array(
								'id'          => 'lw_forecast_toggle_button_style',
								'type'        => 'border',
								'class'       => 'lw_forecast_toggle_button_style lw-forecast-data-pro',
								'title'       => __( 'Forecast Toggle Button', 'location-weather' ),
								'width_title' => __( 'Border Width', 'location-weather' ),
								'all'         => true,
								'background'  => true,
								'active_bg'   => true,
								'default'     => array(
									'all'        => '2',
									'style'      => 'solid',
									'color'      => '#fff',
									'active_bg'  => '#fff',
									'background' => '#EA6A1D',
								),
								'dependency'  => array( 'lw-enable-forecast|lw-forecast-type', '==|==', 'true|both', true ),
							),
							array(
								'id'         => 'lw-forecast-toggle-text-color',
								'type'       => 'color_group',
								'class'      => 'lw-forecast-data-pro',
								'title'      => __( 'Forecast Toggle Button Text', 'location-weather' ),
								'options'    => array(
									'color'      => __( 'Color', 'location-weather' ),
									'background' => __( 'Active Color', 'location-weather' ),
								),
								'default'    => array(
									'color'      => '#ffffff',
									'background' => '#EA6A1D',
								),
								'dependency' => array( 'lw-enable-forecast|lw-forecast-type', '==|==', 'true|both', true ),
							),
							array(
								'id'         => 'lw_forecast_max_height',
								'type'       => 'spinner',
								'class'      => 'forecast-max-height lw-forecast-data-pro',
								'title'      => __( 'Maximum Height', 'location-weather' ),
								'unit'       => __( 'px', 'location-weather' ),
								'max'        => 30000,
								'min'        => 1,
								'default'    => 320,
								'title_info' => '<div class="lw-img-tag"><img src="' . SPLW::include_plugin_url( 'assets/images/forecast-area-maximum-height.svg' ) . '" alt="forecast-area-maximum-height"></div><div class="lw-info-label img">' . __( 'Forecast Area Maximum Height', 'location-weather' ) . '</div>',
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'id'         => 'lw-forecast-data-margin',
								'type'       => 'spacing',
								'class'      => 'lw-forecast-data-margin lw-forecast-data-pro',
								'title'      => __( 'Margin', 'location-weather' ),
								'units'      => array(
									__( 'px', 'location-weather' ),
								),
								'right'      => false,
								'left'       => false,
								'default'    => array(
									'top'    => '0',
									'bottom' => '0',
								),
								'title_info' => '<div class="lw-img-tag"><img src="' . SPLW::include_plugin_url( 'assets/images/forecast-area-margin.svg' ) . '" alt="forecast-area-margin"></div><div class="lw-info-label img">' . __( 'Forecast Area Margin', 'location-weather' ) . '</div>',
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'id'         => 'lw-temperature-heading',
								'type'       => 'subheading',
								'class'      => 'forecast-carousel-options',
								'title'      => __( 'Weather Forecast Data Carousel', 'location-weather' ),
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'id'         => 'enable-forecast-carousel-autoplay',
								'type'       => 'switcher',
								'class'      => 'lw-forecast-data-pro splw_show_hide',
								'title'      => __( 'Carousel AutoPlay', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Enabled', 'location-weather' ),
								'text_off'   => __( 'Disabled', 'location-weather' ),
								'text_width' => 94,
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'id'         => 'forecast-carousel-autoplay-speed',
								'type'       => 'spinner',
								'class'      => 'lw-forecast-data-pro',
								'title'      => __( 'AutoPlay Delay Time', 'location-weather' ),
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div>%s',
									__( 'AutoPlay Delay Time', 'location-weather' ),
									__( 'Set autoplay delay or interval time. The amount of time to delay between automatically cycling a weather item. For example, 1000 milliseconds (ms) equals 1 second.', 'location-weather' )
								),
								'unit'       => __( 'ms', 'location-weather' ),
								'max'        => 30000,
								'min'        => 1,
								'default'    => 3000,
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'id'         => 'forecast-carousel-speed',
								'type'       => 'spinner',
								'class'      => 'lw-forecast-data-pro',
								'title_info' => sprintf(
									'<div class="lw-info-label">%s</div>%s',
									__( 'Carousel Speed', 'location-weather' ),
									__( 'Set carousel scrolling speed. For example, 1000 milliseconds (ms) equals 1 second.', 'location-weather' )
								),
								'title'      => __( 'Carousel Speed', 'location-weather' ),
								'unit'       => __( 'ms', 'location-weather' ),
								'max'        => 30000,
								'min'        => 1,
								'default'    => 600,
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),

							),
							array(
								'id'         => 'forecast_carousel_onhover',
								'type'       => 'switcher',
								'class'      => 'lw-forecast-data-pro splw_show_hide',
								'title'      => __( 'Stop on Hover', 'location-weather' ),
								'text_on'    => __( 'Enabled', 'location-weather' ),
								'text_off'   => __( 'Disabled', 'location-weather' ),
								'text_width' => 94,
								'default'    => false,
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'id'         => 'enable-forecast-carousel-infinite-loop',
								'type'       => 'switcher',
								'class'      => 'lw-forecast-data-pro splw_show_hide',
								'title'      => __( 'Infinite Loop', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Enabled', 'location-weather' ),
								'text_off'   => __( 'Disabled', 'location-weather' ),
								'text_width' => 94,
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'id'         => 'lw_forecast-column',
								'class'      => 'lw_forecast-column lw-forecast-data-pro',
								'type'       => 'spacing',
								'title'      => __( 'Columns', 'location-weather' ),
								'all'        => true,
								'all_icon'   => '<i class="fa fa-desktop"></i>',
								'min'        => 1,
								'max'        => 10,
								'unit'       => false,
								'default'    => array(
									'all' => '3',
								),
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'id'         => 'forecast-nav-icon',
								'class'      => 'lw-forecast-data-pro nav-icons',
								'type'       => 'button_set',
								'title'      => __( 'Navigation Icon', 'location-weather' ),
								'options'    => array(
									'chevron' => '<i class="fas fa-chevron-right"></i>',
									'angle'   => '<i class="fas fa-angle-right"></i>',
									'arrow'   => '<i class="fas fa-arrow-right"></i>',
									'none'    => __( 'Hide', 'location-weather' ),
								),
								'default'    => 'none',
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
							array(
								'id'         => 'forecast-nav-color',
								'type'       => 'color_group',
								'class'      => 'lw-forecast-data-pro',
								'title'      => __( 'Navigation Color', 'location-weather' ),
								'options'    => array(
									'color'      => __( 'Arrow Color', 'location-weather' ),
									'background' => __( 'Hover Color', 'location-weather' ),
								),
								'default'    => array(
									'color'      => '#ffffff',
									'background' => '#ffffff',
								),
								'dependency' => array( 'lw-enable-forecast', '==', 'true', true ),
							),
						),
					),
					array(
						'title'  => __( 'Footer', 'location-weather' ),
						'icon'   => '<span><i class="splwp-icon-footer"></i></span>',
						'fields' => array(
							array(
								'id'         => 'lw-weather-details',
								'type'       => 'switcher',
								'title'      => __( 'Detailed Weather', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-weather-update-time',
								'type'       => 'switcher',
								'title'      => __( 'Data Update Time', 'location-weather' ),
								'default'    => false,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
							),
							array(
								'id'         => 'lw-attribution',
								'type'       => 'switcher',
								'title'      => __( 'Weather Attribution', 'location-weather' ),
								'default'    => true,
								'text_on'    => __( 'Show', 'location-weather' ),
								'text_off'   => __( 'Hide', 'location-weather' ),
								'text_width' => 75,
								'title_info' => sprintf( '<div class="lw-info-label">%s</div><div class="lw-short-content">%s</div> <a class="lw-open-docs" href="https://locationweather.io/docs/how-to-display-weather-attribution/" target="_blank">%s</a>', __( 'Weather Attribution (Copyright)', 'location-weather' ), __( 'You can show the weather attribution or copyright in the weather widget footer area for weather authenticity.', 'location-weather' ), __( 'Open Docs', 'location-weather' ) ),
							),
							array(
								'id'         => 'lw-openweather-links',
								'type'       => 'checkbox',
								'title'      => __( 'Link To OpenWeatherMap', 'location-weather' ),
								'default'    => false,
								'dependency' => array( 'lw-attribution', '==', 'true', true ),
							),
							array(
								'id'      => 'lw-attr-margin',
								'type'    => 'spacing',
								'class'   => 'lw-attr-margin',
								'title'   => __( 'Margin', 'location-weather' ),
								'units'   => array(
									__( 'px', 'location-weather' ),
								),
								'right'   => false,
								'left'    => false,
								'default' => array(
									'top'    => '0',
									'bottom' => '0',
								),
							),
						),
					),
				),
			),
		),
	)
);
