<?php

if (!defined('ABSPATH')) exit;
/**
 * Misc Functions
 * 
 * Functions related to the plugin
 * 
 * @package Loan Calculator
 * @since 1.0.1
 */

/**
 * Get Base Currency Code.
 *
 * @package Loan Calculator
 * @since 1.0.1
 */

function ww_loan_get_currency()
{
	$loan_all_setting_data = get_option('ww_loan_option');
	$loan_all_setting_data = apply_filters('ww_loan_calculator_all_setting_data', $loan_all_setting_data, array('shortcode_render' => true));

	$ww_loan_currency = !empty($loan_all_setting_data['ww_loan_currency']) ? $loan_all_setting_data['ww_loan_currency']  :'USD';

	return apply_filters('ww_loan_currency', $ww_loan_currency);
}

/**
 * Frequency Label for 
 * calculator dropdown field
 * 
 * @package Loan Calculator
 * @since 1.3.4
 */
function ww_loan_repayment_frequency_label()
{

	return apply_filters(
		'ww_loan_repayment_frequency_label',
		array(
			'Monthly' => __('Monthly', 'loan-calculator-wp'),
			'Quarterly' => __('Quarterly', 'loan-calculator-wp'),
			'Yearly' => __('Yearly', 'loan-calculator-wp'),
			'Weekly' => __('Weekly', 'loan-calculator-wp'),
			'Fortnight' => __('Fortnightly', 'loan-calculator-wp'),
		)
	);
}

/**
 * Frequency Label for 
 * final calculation section
 * 
 * @package Loan Calculator
 * @since 1.3.4
 */
function ww_loan_repayment_frequency_calc_label()
{

	return apply_filters(
		'ww_loan_repayment_frequency_calc_label',
		array(
			'Monthly' => __('Monthly for ', 'loan-calculator-wp'),
			'Quarterly' => __('Quarterly for ', 'loan-calculator-wp'),
			'Yearly' => __('Yearly for ', 'loan-calculator-wp'),
			'Weekly' => __('Weekly for', 'loan-calculator-wp'),
			'Fortnight' => __('Fortnightly for', 'loan-calculator-wp'),
		)
	);
}

/**
 * Loan form chart types are adjustable using the display settings in the plugin.
 * final calculation section
 * 
 * @package Loan Calculator
 * @since 1.3.4
 */
function ww_loan_chart_types()
{
	return apply_filters(
		'ww_loan_chart_types',
		array(
			'bar' => __('Bar', 'loan-calculator-wp'),
			'stacked_bar' => __('Stacked Bar', 'loan-calculator-wp'),
			'pie' => __('Pie', 'loan-calculator-wp'),
			'bubble' => __('Bubble ', 'loan-calculator-wp'),
			'doughnut' => __('Doughnut ', 'loan-calculator-wp'),
			'line' => __('Line ', 'loan-calculator-wp'),
			'polarArea' => __('PolarArea ', 'loan-calculator-wp'),
			'radar' => __('Radar ', 'loan-calculator-wp'),
			'scatter' => __('Scatter ', 'loan-calculator-wp'),
		)
	);
}

/**
 * Get full list of currency codes.
 * 
 * @package Loan Calculator
 * @since 1.0.1
 */
function ww_loan_get_currencies()
{

	static $currencies;

	if (!isset($currencies)) {
		$currencies = array_unique(
			apply_filters(
				'ww_loan_currencies',
				array(
					'AED' => __('United Arab Emirates dirham', 'loan-calculator-wp'),
					'AFN' => __('Afghan afghani', 'loan-calculator-wp'),
					'ALL' => __('Albanian lek', 'loan-calculator-wp'),
					'AMD' => __('Armenian dram', 'loan-calculator-wp'),
					'ANG' => __('Netherlands Antillean guilder', 'loan-calculator-wp'),
					'AOA' => __('Angolan kwanza', 'loan-calculator-wp'),
					'ARS' => __('Argentine peso', 'loan-calculator-wp'),
					'AUD' => __('Australian dollar', 'loan-calculator-wp'),
					'AWG' => __('Aruban florin', 'loan-calculator-wp'),
					'AZN' => __('Azerbaijani manat', 'loan-calculator-wp'),
					'BAM' => __('Bosnia and Herzegovina convertible mark', 'loan-calculator-wp'),
					'BBD' => __('Barbadian dollar', 'loan-calculator-wp'),
					'BDT' => __('Bangladeshi taka', 'loan-calculator-wp'),
					'BGN' => __('Bulgarian lev', 'loan-calculator-wp'),
					'BHD' => __('Bahraini dinar', 'loan-calculator-wp'),
					'BIF' => __('Burundian franc', 'loan-calculator-wp'),
					'BMD' => __('Bermudian dollar', 'loan-calculator-wp'),
					'BND' => __('Brunei dollar', 'loan-calculator-wp'),
					'BOB' => __('Bolivian boliviano', 'loan-calculator-wp'),
					'BRL' => __('Brazilian real', 'loan-calculator-wp'),
					'BSD' => __('Bahamian dollar', 'loan-calculator-wp'),
					'BTC' => __('Bitcoin', 'loan-calculator-wp'),
					'BTN' => __('Bhutanese ngultrum', 'loan-calculator-wp'),
					'BWP' => __('Botswana pula', 'loan-calculator-wp'),
					'BYR' => __('Belarusian ruble (old)', 'loan-calculator-wp'),
					'BYN' => __('Belarusian ruble', 'loan-calculator-wp'),
					'BZD' => __('Belize dollar', 'loan-calculator-wp'),
					'CAD' => __('Canadian dollar', 'loan-calculator-wp'),
					'CDF' => __('Congolese franc', 'loan-calculator-wp'),
					'CHF' => __('Swiss franc', 'loan-calculator-wp'),
					'CLP' => __('Chilean peso', 'loan-calculator-wp'),
					'CNY' => __('Chinese yuan', 'loan-calculator-wp'),
					'COP' => __('Colombian peso', 'loan-calculator-wp'),
					'CRC' => __('Costa Rican col&oacute;n', 'loan-calculator-wp'),
					'CUC' => __('Cuban convertible peso', 'loan-calculator-wp'),
					'CUP' => __('Cuban peso', 'loan-calculator-wp'),
					'CVE' => __('Cape Verdean escudo', 'loan-calculator-wp'),
					'CZK' => __('Czech koruna', 'loan-calculator-wp'),
					'DJF' => __('Djiboutian franc', 'loan-calculator-wp'),
					'DKK' => __('Danish krone', 'loan-calculator-wp'),
					'DOP' => __('Dominican peso', 'loan-calculator-wp'),
					'DZD' => __('Algerian dinar', 'loan-calculator-wp'),
					'EGP' => __('Egyptian pound', 'loan-calculator-wp'),
					'ERN' => __('Eritrean nakfa', 'loan-calculator-wp'),
					'ETB' => __('Ethiopian birr', 'loan-calculator-wp'),
					'EUR' => __('Euro', 'loan-calculator-wp'),
					'FJD' => __('Fijian dollar', 'loan-calculator-wp'),
					'FKP' => __('Falkland Islands pound', 'loan-calculator-wp'),
					'GBP' => __('Pound sterling', 'loan-calculator-wp'),
					'GBP' => __('United Kingdom (UK) pound', 'loan-calculator-wp'),
					'GEL' => __('Georgian lari', 'loan-calculator-wp'),
					'GGP' => __('Guernsey pound', 'loan-calculator-wp'),
					'GHS' => __('Ghana cedi', 'loan-calculator-wp'),
					'GIP' => __('Gibraltar pound', 'loan-calculator-wp'),
					'GMD' => __('Gambian dalasi', 'loan-calculator-wp'),
					'GNF' => __('Guinean franc', 'loan-calculator-wp'),
					'GTQ' => __('Guatemalan quetzal', 'loan-calculator-wp'),
					'GYD' => __('Guyanese dollar', 'loan-calculator-wp'),
					'HKD' => __('Hong Kong dollar', 'loan-calculator-wp'),
					'HNL' => __('Honduran lempira', 'loan-calculator-wp'),
					'HRK' => __('Croatian kuna', 'loan-calculator-wp'),
					'HTG' => __('Haitian gourde', 'loan-calculator-wp'),
					'HUF' => __('Hungarian forint', 'loan-calculator-wp'),
					'IDR' => __('Indonesian rupiah', 'loan-calculator-wp'),
					'ILS' => __('Israeli new shekel', 'loan-calculator-wp'),
					'IMP' => __('Manx pound', 'loan-calculator-wp'),
					'INR' => __('Indian rupee', 'loan-calculator-wp'),
					'IQD' => __('Iraqi dinar', 'loan-calculator-wp'),
					'IRR' => __('Iranian rial', 'loan-calculator-wp'),
					'IRT' => __('Iranian toman', 'loan-calculator-wp'),
					'ISK' => __('Icelandic kr&oacute;na', 'loan-calculator-wp'),
					'JEP' => __('Jersey pound', 'loan-calculator-wp'),
					'JMD' => __('Jamaican dollar', 'loan-calculator-wp'),
					'JOD' => __('Jordanian dinar', 'loan-calculator-wp'),
					'JPY' => __('Japanese yen', 'loan-calculator-wp'),
					'KES' => __('Kenyan shilling', 'loan-calculator-wp'),
					'KGS' => __('Kyrgyzstani som', 'loan-calculator-wp'),
					'KHR' => __('Cambodian riel', 'loan-calculator-wp'),
					'KMF' => __('Comorian franc', 'loan-calculator-wp'),
					'KPW' => __('North Korean won', 'loan-calculator-wp'),
					'KRW' => __('South Korean won', 'loan-calculator-wp'),
					'KWD' => __('Kuwaiti dinar', 'loan-calculator-wp'),
					'KYD' => __('Cayman Islands dollar', 'loan-calculator-wp'),
					'KZT' => __('Kazakhstani tenge', 'loan-calculator-wp'),
					'LAK' => __('Lao kip', 'loan-calculator-wp'),
					'LBP' => __('Lebanese pound', 'loan-calculator-wp'),
					'LKR' => __('Sri Lankan rupee', 'loan-calculator-wp'),
					'LRD' => __('Liberian dollar', 'loan-calculator-wp'),
					'LSL' => __('Lesotho loti', 'loan-calculator-wp'),
					'LYD' => __('Libyan dinar', 'loan-calculator-wp'),
					'MAD' => __('Moroccan dirham', 'loan-calculator-wp'),
					'MDL' => __('Moldovan leu', 'loan-calculator-wp'),
					'MGA' => __('Malagasy ariary', 'loan-calculator-wp'),
					'MKD' => __('Macedonian denar', 'loan-calculator-wp'),
					'MMK' => __('Burmese kyat', 'loan-calculator-wp'),
					'MNT' => __('Mongolian t&ouml;gr&ouml;g', 'loan-calculator-wp'),
					'MOP' => __('Macanese pataca', 'loan-calculator-wp'),
					'MRU' => __('Mauritanian ouguiya', 'loan-calculator-wp'),
					'MUR' => __('Mauritian rupee', 'loan-calculator-wp'),
					'MVR' => __('Maldivian rufiyaa', 'loan-calculator-wp'),
					'MWK' => __('Malawian kwacha', 'loan-calculator-wp'),
					'MXN' => __('Mexican peso', 'loan-calculator-wp'),
					'MYR' => __('Malaysian ringgit', 'loan-calculator-wp'),
					'MZN' => __('Mozambican metical', 'loan-calculator-wp'),
					'NAD' => __('Namibian dollar', 'loan-calculator-wp'),
					'NGN' => __('Nigerian naira', 'loan-calculator-wp'),
					'NIO' => __('Nicaraguan c&oacute;rdoba', 'loan-calculator-wp'),
					'NOK' => __('Norwegian krone', 'loan-calculator-wp'),
					'NPR' => __('Nepalese rupee', 'loan-calculator-wp'),
					'NZD' => __('New Zealand dollar', 'loan-calculator-wp'),
					'OMR' => __('Omani rial', 'loan-calculator-wp'),
					'PAB' => __('Panamanian balboa', 'loan-calculator-wp'),
					'PEN' => __('Sol', 'loan-calculator-wp'),
					'PGK' => __('Papua New Guinean kina', 'loan-calculator-wp'),
					'PHP' => __('Philippine peso', 'loan-calculator-wp'),
					'PKR' => __('Pakistani rupee', 'loan-calculator-wp'),
					'PLN' => __('Polish z&#x142;oty', 'loan-calculator-wp'),
					'PRB' => __('Transnistrian ruble', 'loan-calculator-wp'),
					'PYG' => __('Paraguayan guaran&iacute;', 'loan-calculator-wp'),
					'QAR' => __('Qatari riyal', 'loan-calculator-wp'),
					'RON' => __('Romanian leu', 'loan-calculator-wp'),
					'RSD' => __('Serbian dinar', 'loan-calculator-wp'),
					'RUB' => __('Russian ruble', 'loan-calculator-wp'),
					'RWF' => __('Rwandan franc', 'loan-calculator-wp'),
					'SAR' => __('Saudi riyal', 'loan-calculator-wp'),
					'SBD' => __('Solomon Islands dollar', 'loan-calculator-wp'),
					'SCR' => __('Seychellois rupee', 'loan-calculator-wp'),
					'SDG' => __('Sudanese pound', 'loan-calculator-wp'),
					'SEK' => __('Swedish krona', 'loan-calculator-wp'),
					'SGD' => __('Singapore dollar', 'loan-calculator-wp'),
					'SHP' => __('Saint Helena pound', 'loan-calculator-wp'),
					'SLL' => __('Sierra Leonean leone', 'loan-calculator-wp'),
					'SOS' => __('Somali shilling', 'loan-calculator-wp'),
					'SRD' => __('Surinamese dollar', 'loan-calculator-wp'),
					'SSP' => __('South Sudanese pound', 'loan-calculator-wp'),
					'STN' => __('S&atilde;o Tom&eacute; and Pr&iacute;ncipe dobra', 'loan-calculator-wp'),
					'SYP' => __('Syrian pound', 'loan-calculator-wp'),
					'SZL' => __('Swazi lilangeni', 'loan-calculator-wp'),
					'THB' => __('Thai baht', 'loan-calculator-wp'),
					'TJS' => __('Tajikistani somoni', 'loan-calculator-wp'),
					'TMT' => __('Turkmenistan manat', 'loan-calculator-wp'),
					'TND' => __('Tunisian dinar', 'loan-calculator-wp'),
					'TOP' => __('Tongan pa&#x2bb;anga', 'loan-calculator-wp'),
					'TRY' => __('Turkish lira', 'loan-calculator-wp'),
					'TTD' => __('Trinidad and Tobago dollar', 'loan-calculator-wp'),
					'TWD' => __('New Taiwan dollar', 'loan-calculator-wp'),
					'TZS' => __('Tanzanian shilling', 'loan-calculator-wp'),
					'UAH' => __('Ukrainian hryvnia', 'loan-calculator-wp'),
					'UGX' => __('Ugandan shilling', 'loan-calculator-wp'),
					'USD' => __('United States (US) dollar', 'loan-calculator-wp'),
					'UYU' => __('Uruguayan peso', 'loan-calculator-wp'),
					'UZS' => __('Uzbekistani som', 'loan-calculator-wp'),
					'VEF' => __('Venezuelan bol&iacute;var', 'loan-calculator-wp'),
					'VES' => __('Bol&iacute;var soberano', 'loan-calculator-wp'),
					'VND' => __('Vietnamese &#x111;&#x1ed3;ng', 'loan-calculator-wp'),
					'VUV' => __('Vanuatu vatu', 'loan-calculator-wp'),
					'WST' => __('Samoan t&#x101;l&#x101;', 'loan-calculator-wp'),
					'XAF' => __('Central African CFA franc', 'loan-calculator-wp'),
					'XCD' => __('East Caribbean dollar', 'loan-calculator-wp'),
					'XOF' => __('West African CFA franc', 'loan-calculator-wp'),
					'XPF' => __('CFP franc', 'loan-calculator-wp'),
					'YER' => __('Yemeni rial', 'loan-calculator-wp'),
					'ZAR' => __('South African rand', 'loan-calculator-wp'),
					'ZMW' => __('Zambian kwacha', 'loan-calculator-wp'),
				)
			)
		);
	}

	return $currencies;
}

/**
 * Get all available Currency symbols.
 *
 * Currency symbols and names should follow the Unicode CLDR recommendation (http://cldr.unicode.org/translation/currency-names)
 *
 * @since 4.1.0
 * @return array
 */
function ww_loan_get_currency_symbols()
{

	$symbols = apply_filters(
		'ww_loan_currency_symbols',
		array(
			'AED' => '&#x62f;.&#x625;',
			'AFN' => '&#x60b;',
			'ALL' => 'L',
			'AMD' => 'AMD',
			'ANG' => '&fnof;',
			'AOA' => 'Kz',
			'ARS' => '&#36;',
			'AUD' => '&#36;',
			'AWG' => 'Afl.',
			'AZN' => 'AZN',
			'BAM' => 'KM',
			'BBD' => '&#36;',
			'BDT' => '&#2547;&nbsp;',
			'BGN' => '&#1083;&#1074;.',
			'BHD' => '.&#x62f;.&#x628;',
			'BIF' => 'Fr',
			'BMD' => '&#36;',
			'BND' => '&#36;',
			'BOB' => 'Bs.',
			'BRL' => '&#82;&#36;',
			'BSD' => '&#36;',
			'BTC' => '&#3647;',
			'BTN' => 'Nu.',
			'BWP' => 'P',
			'BYR' => 'Br',
			'BYN' => 'Br',
			'BZD' => '&#36;',
			'CAD' => '&#36;',
			'CDF' => 'Fr',
			'CHF' => '&#67;&#72;&#70;',
			'CLP' => '&#36;',
			'CNY' => '&yen;',
			'COP' => '&#36;',
			'CRC' => '&#x20a1;',
			'CUC' => '&#36;',
			'CUP' => '&#36;',
			'CVE' => '&#36;',
			'CZK' => '&#75;&#269;',
			'DJF' => 'Fr',
			'DKK' => 'DKK',
			'DOP' => 'RD&#36;',
			'DZD' => '&#x62f;.&#x62c;',
			'EGP' => 'EGP',
			'ERN' => 'Nfk',
			'ETB' => 'Br',
			'EUR' => '&euro;',
			'FJD' => '&#36;',
			'FKP' => '&pound;',
			'GBP' => '&pound;',
			'GEL' => '&#x20be;',
			'GGP' => '&pound;',
			'GHS' => '&#x20b5;',
			'GIP' => '&pound;',
			'GMD' => 'D',
			'GNF' => 'Fr',
			'GTQ' => 'Q',
			'GYD' => '&#36;',
			'HKD' => '&#36;',
			'HNL' => 'L',
			'HRK' => 'kn',
			'HTG' => 'G',
			'HUF' => '&#70;&#116;',
			'IDR' => 'Rp',
			'ILS' => '&#8362;',
			'IMP' => '&pound;',
			'INR' => '&#8377;',
			'IQD' => '&#x639;.&#x62f;',
			'IRR' => '&#xfdfc;',
			'IRT' => '&#x062A;&#x0648;&#x0645;&#x0627;&#x0646;',
			'ISK' => 'kr.',
			'JEP' => '&pound;',
			'JMD' => '&#36;',
			'JOD' => '&#x62f;.&#x627;',
			'JPY' => '&yen;',
			'KES' => 'KSh',
			'KGS' => '&#x441;&#x43e;&#x43c;',
			'KHR' => '&#x17db;',
			'KMF' => 'Fr',
			'KPW' => '&#x20a9;',
			'KRW' => '&#8361;',
			'KWD' => '&#x62f;.&#x643;',
			'KYD' => '&#36;',
			'KZT' => '&#8376;',
			'LAK' => '&#8365;',
			'LBP' => '&#x644;.&#x644;',
			'LKR' => '&#xdbb;&#xdd4;',
			'LRD' => '&#36;',
			'LSL' => 'L',
			'LYD' => '&#x644;.&#x62f;',
			'MAD' => '&#x62f;.&#x645;.',
			'MDL' => 'MDL',
			'MGA' => 'Ar',
			'MKD' => '&#x434;&#x435;&#x43d;',
			'MMK' => 'Ks',
			'MNT' => '&#x20ae;',
			'MOP' => 'P',
			'MRU' => 'UM',
			'MUR' => '&#x20a8;',
			'MVR' => '.&#x783;',
			'MWK' => 'MK',
			'MXN' => '&#36;',
			'MYR' => '&#82;&#77;',
			'MZN' => 'MT',
			'NAD' => 'N&#36;',
			'NGN' => '&#8358;',
			'NIO' => 'C&#36;',
			'NOK' => '&#107;&#114;',
			'NPR' => '&#8360;',
			'NZD' => '&#36;',
			'OMR' => '&#x631;.&#x639;.',
			'PAB' => 'B/.',
			'PEN' => 'S/',
			'PGK' => 'K',
			'PHP' => '&#8369;',
			'PKR' => '&#8360;',
			'PLN' => '&#122;&#322;',
			'PRB' => '&#x440;.',
			'PYG' => '&#8370;',
			'QAR' => '&#x631;.&#x642;',
			'RMB' => '&yen;',
			'RON' => 'lei',
			'RSD' => '&#1088;&#1089;&#1076;',
			'RUB' => '&#8381;',
			'RWF' => 'Fr',
			'SAR' => '&#x631;.&#x633;',
			'SBD' => '&#36;',
			'SCR' => '&#x20a8;',
			'SDG' => '&#x62c;.&#x633;.',
			'SEK' => '&#107;&#114;',
			'SGD' => '&#36;',
			'SHP' => '&pound;',
			'SLL' => 'Le',
			'SOS' => 'Sh',
			'SRD' => '&#36;',
			'SSP' => '&pound;',
			'STN' => 'Db',
			'SYP' => '&#x644;.&#x633;',
			'SZL' => 'L',
			'THB' => '&#3647;',
			'TJS' => '&#x405;&#x41c;',
			'TMT' => 'm',
			'TND' => '&#x62f;.&#x62a;',
			'TOP' => 'T&#36;',
			'TRY' => '&#8378;',
			'TTD' => '&#36;',
			'TWD' => '&#78;&#84;&#36;',
			'TZS' => 'Sh',
			'UAH' => '&#8372;',
			'UGX' => 'UGX',
			'USD' => '&#36;',
			'UYU' => '&#36;',
			'UZS' => 'UZS',
			'VEF' => 'Bs F',
			'VES' => 'Bs.S',
			'VND' => '&#8363;',
			'VUV' => 'Vt',
			'WST' => 'T',
			'XAF' => 'CFA',
			'XCD' => '&#36;',
			'XOF' => 'CFA',
			'XPF' => 'Fr',
			'YER' => '&#xfdfc;',
			'ZAR' => '&#82;',
			'ZMW' => 'ZK',
		)
	);

	return $symbols;
}

/**
 * Get Currency symbol
 *
 * @package Loan Calculator
 * @since 1.0.1
 */

function ww_loan_get_currency_symbol($currency = '')
{
	if (!$currency) {
		$currency = ww_loan_get_currency();
	}
	$symbols = ww_loan_get_currency_symbols();

	$currency_symbol = isset($symbols[$currency]) ? $symbols[$currency]  :'';

	return apply_filters('ww_loan_currency_symbol', $currency_symbol, $currency);
}


function ww_get_google_fonts()
{
	$ww_get_google_fonts = apply_filters(
		'ww_get_fonts',
		array(
			'Arial' => "font-family :Arial",
			'Arial Black' => "font-family :Arial Black",
			'Arial Narrow' => "font-family :Arial Narrow",
			'Arial Rounded MT Bold' => "font-family :Arial Rounded MT Bold",
			'ABeeZee' => "font-family :ABeeZee",
			'Albert Sans' => "font-family :Albert Sans",
			'Alegreya Sans SC' => "font-family :Alegreya Sans SC",
			'Amaranth' => "font-family :Amaranth",
			'Andika' => "font-family :Andika",
			'Anek Gujarati' => "font-family :Anek Gujarati",
			'Annapurna SIL' => "font-family :Annapurna SIL",
			'Antonio' => "font-family :Antonio",
			'Bangers' => "font-family :Bangers",
			'Bebas Neue' => "font-family :Bebas Neue",
			'Blinker' => "font-family :Blinker",
			'Cabin Condensed' => "font-family :Cabin Condensed",
			'Carter One' => "font-family :Carter One",
			'Comic Neue' => "font-family :Comic Neue",
			'Concert One' => "font-family :Concert One",
			'Cookie' => "font-family :Cookie",
			'Courgette' => "font-family :Courgette",
			'Cousine' => "font-family :Cousine",
			'DM Mono' => "font-family :DM Mono",
			'DM Sans' => "font-family :DM Sans",
			'DM Serif Text' => "font-family :DM Serif Text",
			'Dela Gothic One' => "font-family :Dela Gothic One",
			'Exo 2' => "font-family :Exo 2",
			'Fira Sans Extra Condensed' => "font-family :Fira Sans Extra Condensed",
			'Fira Sans' => "font-family :Fira Sans",
			'Fjalla One' => "font-family :Fjalla One",
			'Fredoka' => "font-family :Fredoka",
			'Fugaz One' => "font-family :Fugaz One",
			'Gothic A1' => "font-family :Gothic A1",
			'Gudea' => "font-family :Gudea",
			'Handlee' => "font-family :Handlee",
			'Hind Siliguri' => "font-family :Hind Siliguri",
			'Hind' => "font-family :Hind",
			'IBM Plex Sans' => "font-family :IBM Plex Sans",
			'Inter' => "font-family :Inter",
			'Istok Web' => "font-family :Istok Web",
			'Kalam' => "font-family :Kalam",
			'Kanit' => "font-family :Kanit",
			'Kosugi Maru' => "font-family :Kosugi Maru",
			'Lato' => "font-family :Lato",
			'League Spartan' => "font-family :League Spartan",
			'Lexend Deca' => "font-family :Lexend Deca",
			'Lobster' => "font-family :Lobster",
			'Lobster Two' => "font-family :Lobster Two",
			'Lunasima' => "font-family :Lunasima",
			'Marcellus' => "font-family :Marcellus",
			'Marmelad' => "font-family :Marmelad",
			'Merriweather' => "font-family :Merriweather",
			'Montserrat' => "font-family :Montserrat",
			'Mukta Malar' => "font-family :Mukta Malar",
			'Mukta' => "font-family :Mukta",
			'Mulish' => "font-family :Mulish",
			'Noto Color Emoji' => "font-family :Noto Color Emoji",
			'Noto Sans Gujarati' => "font-family :Noto Sans Gujarati",
			'Noto Sans' => "font-family :Noto Sans",
			'Noto Serif' => "font-family :Noto Serif",
			'Nunito' => "font-family :Nunito",
			'Open Sans' => "font-family :Open Sans",
			'Oswald' => "font-family :Oswald",
			'Outfit' => "font-family :Outfit",
			'Overpass' => "font-family :Overpass",
			'Oxygen' => "font-family :Oxygen",
			'PT Sans Caption' => "font-family :PT Sans Caption",
			'PT Sans Narrow' => "font-family :PT Sans Narrow",
			'PT Sans' => "font-family :PT Sans",
			'Pacifico' => "font-family :Pacifico",
			'Patrick Hand' => "font-family :Patrick Hand",
			'Poppins' => "font-family :Poppins",
			'Protest Riot' => "font-family :Protest Riot",
			'Protest Strike' => "font-family :Protest Strike",
			'Public Sans' => "font-family :Public Sans",
			'Quicksand' => "font-family :Quicksand",
			'Raleway' => "font-family :Raleway",
			'Readex Pro' => "font-family :Readex Pro",
			'Righteous' => "font-family :Righteous",
			'Roboto Condensed' => "font-family :Roboto Condensed",
			'Roboto Slab' => "font-family :Roboto Slab",
			'Roboto' => "font-family :Roboto",
			'Ropa Sans' => "font-family :Ropa Sans",
			'Rubik' => "font-family :Rubik",
			'Ruda' => "font-family :Ruda",
			'Saira Semi Condensed' => "font-family :Saira Semi Condensed",
			'Sanchez' => "font-family :Sanchez",
			'Secular One' => "font-family :Secular One",
			'Sen' => "font-family :Sen",
			'Sofia' => "font-family :Sofia",
			'Sora' => "font-family :Sora",
			'Staatliches' => "font-family :Staatliches",
			'Teko' => "font-family :Teko",
			'Tenor Sans' => "font-family :Tenor Sans",
			'Tiro Devanagari Hindi' => "font-family :Tiro Devanagari Hindi",
			'Titillium Web' => "font-family :Titillium Web",
			'Ubuntu Condensed' => "font-family :Ubuntu Condensed",
			'Ubuntu' => "font-family :Ubuntu",
			'Varela Round' => "font-family :Varela Round",
			'Viga' => "font-family :Viga",
			'Voltaire' => "font-family :Voltaire",
			'Work Sans' => "font-family :Work Sans",
			'Yatra One' => "font-family :Yatra One",
			'Yeseva One' => "font-family :Yeseva One",
			'Book Antiqua' => "font-family :Book Antiqua",
			'Bookman Old Style' => "font-family :Bookman Old Style",
			'Calibri' => "font-family :Calibri",
			'Cambria' => "font-family :Cambria",
			'Candara' => "font-family :Candara",
			'Century Gothic' => "font-family :Century Gothic",
			'Comic Sans MS' => "font-family :Comic Sans MS",
			'Consolas' => "font-family :Consolas",
			'Constantia' => "font-family :Constantia",
			'Corbel' => "font-family :Corbel",
			'Courier New' => "font-family :Courier New",
			'DejaVu Sans' => "font-family :DejaVu Sans",
			'DejaVu Serif' => "font-family :DejaVu Serif",
			'Droid Sans' => "font-family :Droid Sans",
			'Droid Serif' => "font-family :Droid Serif",
			'Georgia' => "font-family :Georgia",
			'Geneva' => "font-family :Geneva",
			'Helvetica' => "font-family :Helvetica",
			'Impact' => "font-family :Impact",
			'Lucida Console' => "font-family :Lucida Console",
			'Lucida Grande' => "font-family :Lucida Grande",
			'Lucida Sans Unicode' => "font-family :Lucida Sans Unicode",
			'Monaco' => "font-family :Monaco",
			'Palatino Linotype' => "font-family :Palatino Linotype",
			'Tahoma' => "font-family :Tahoma",
			'Times New Roman' => "font-family :Times New Roman",
			'Trebuchet MS' => "font-family :Trebuchet MS",
			'Verdana' => "font-family :Verdana",
			'Webdings' => "font-family :Webdings",
			'Wingdings' => "font-family :Wingdings",
			'MS Sans Serif' => "font-family :MS Sans Serif",
			'MS Serif' => "font-family :MS Serif",
			'MV Boli' => "font-family :MV Boli",
			'Franklin Gothic Medium' => "font-family :Franklin Gothic Medium",
			'Garamond' => "font-family :Garamond",
			'Ebrima' => "font-family :Ebrima",
			'Leelawadee' => "font-family :Leelawadee",
			'Malgun Gothic' => "font-family :Malgun Gothic",
			'Mangal' => "font-family :Mangal",
			'Meiryo' => "font-family :Meiryo",
			'Microsoft Himalaya' => "font-family :Microsoft Himalaya",
			'Microsoft JhengHei' => "font-family :Microsoft JhengHei",
			'Microsoft New Tai Lue' => "font-family :Microsoft New Tai Lue",
			'Microsoft PhagsPa' => "font-family :Microsoft PhagsPa",
			'Microsoft Tai Le' => "font-family :Microsoft Tai Le",
			'Microsoft YaHei' => "font-family :Microsoft YaHei",
			'Microsoft Yi Baiti' => "font-family :Microsoft Yi Baiti",
			'MingLiU-ExtB' => "font-family :MingLiU-ExtB",
			'PMingLiU-ExtB' => "font-family :PMingLiU-ExtB",
			'MingLiU_HKSCS-ExtB' => "font-family :MingLiU_HKSCS-ExtB",
			'PMingLiU_HKSCS-ExtB' => "font-family :PMingLiU_HKSCS-ExtB",
			'MingLiU' => "font-family :MingLiU",
			'PMingLiU' => "font-family :PMingLiU",
			'Courier' => "font-family :Courier",
			'Courier New' => "font-family :Courier New",
			'Consolas' => "font-family :Consolas",
			'Lucida Console' => "font-family :Lucida Console",
			'Monaco' => "font-family :Monaco",
			'Andale Mono' => "font-family :Andale Mono",
			'Bitstream Vera Sans Mono' => "font-family :Bitstream Vera Sans Mono",
			'Courier 10 Pitch' => "font-family :Courier 10 Pitch",
			'DejaVu Sans Mono' => "font-family :DejaVu Sans Mono",
			'Droid Sans Mono' => "font-family :Droid Sans Mono",
			'Everson Mono' => "font-family :Everson Mono",
			'Fixed' => "font-family :Fixed",
			'Inconsolata' => "font-family :Inconsolata",
			'Monaco' => "font-family :Monaco",
			'Monospace' => "font-family :Monospace",
			'Nimbus Mono L' => "font-family :Nimbus Mono L",
			'OCR-A' => "font-family :OCR-A",
			'OCR-B' => "font-family :OCR-B",
			'Source Code Pro' => "font-family :Source Code Pro",
			'Ubuntu Mono' => "font-family :Ubuntu Mono",
			'Copperplate' => "font-family :Copperplate",
			'Papyrus' => "font-family :Papyrus",
			'Brush Script MT' => "font-family :Brush Script MT",
			'Edwardian Script ITC' => "font-family :Edwardian Script ITC",
			'Freestyle Script' => "font-family :Freestyle Script",
			'French Script MT' => "font-family :French Script MT",
			'Kristen ITC' => "font-family :Kristen ITC",
			'Lucida Handwriting' => "font-family :Lucida Handwriting",
			'Mistral' => "font-family :Mistral",
			'Monotype Corsiva' => "font-family :Monotype Corsiva",
			'Parchment' => "font-family :Parchment",
			'Papyrus' => "font-family :Papyrus",
			'Segoe Script' => "font-family :Segoe Script",
			'Viner Hand ITC' => "font-family :Viner Hand ITC",
			'Vivaldi' => "font-family :Vivaldi",
			'Wide Latin' => "font-family :Wide Latin",
			'Agency FB' => "font-family :Agency FB",
			'Algerian' => "font-family :Algerian",
			'Bauhaus 93' => "font-family :Bauhaus 93",
			'Berlin Sans FB' => "font-family :Berlin Sans FB",
			'Bernard MT Condensed' => "font-family :Bernard MT Condensed",
			'Bodoni MT' => "font-family :Bodoni MT",
			'Britannic Bold' => "font-family :Britannic Bold",
			'Broadway' => "font-family :Broadway",
			'Brush Script MT' => "font-family :Brush Script MT",
			'Californian FB' => "font-family :Californian FB",
			'Centaur' => "font-family :Centaur",
			'Century' => "font-family :Century",
			'Chiller' => "font-family :Chiller",
			'Colonna MT' => "font-family :Colonna MT",
			'Cooper Black' => "font-family :Cooper Black",
			'Curlz MT' => "font-family :Curlz MT",
			'Edwardian Script ITC' => "font-family :Edwardian Script ITC",
			'Elephant' => "font-family :Elephant",
			'Engravers MT' => "font-family :Engravers MT",
			'Felix Titling' => "font-family :Felix Titling",
			'Footlight MT Light' => "font-family :Footlight MT Light",
			'Forte' => "font-family :Forte",
			'Franklin Gothic Book' => "font-family :Franklin Gothic Book",
			'Franklin Gothic Demi' => "font-family :Franklin Gothic Demi",
			'Franklin Gothic Demi Cond' => "font-family :Franklin Gothic Demi Cond",
			'Franklin Gothic Heavy' => "font-family :Franklin Gothic Heavy",
			'Franklin Gothic Medium' => "font-family :Franklin Gothic Medium",
			'French Script MT' => "font-family :French Script MT",
			'Gabriola' => "font-family :Gabriola",
			'Gill Sans MT' => "font-family :Gill Sans MT",
			'Goudy Old Style' => "font-family :Goudy Old Style",
			'Goudy Stout' => "font-family :Goudy Stout",
			'Haettenschweiler' => "font-family :Haettenschweiler",
			'Harrington' => "font-family :Harrington",
			'High Tower Text' => "font-family :High Tower Text",
			'Imprint MT Shadow' => "font-family :Imprint MT Shadow",
			'Jokerman' => "font-family :Jokerman",
			'Juice ITC' => "font-family :Juice ITC",
			'Kristen ITC' => "font-family :Kristen ITC",
			'Kunstler Script' => "font-family :Kunstler Script",
			'Lucida Bright' => "font-family :Lucida Bright",
			'Lucida Calligraphy' => "font-family :Lucida Calligraphy",
			'Lucida Fax' => "font-family :Lucida Fax",
			'Magneto' => "font-family :Magneto",
			'Matura MT Script Capitals' => "font-family :Matura MT Script Capitals",
			'Mistral' => "font-family :Mistral",
			'Modern No. 20' => "font-family :Modern No. 20",
			'Mongolian Baiti' => "font-family :Mongolian Baiti",
			'Old English Text MT' => "font-family :Old English Text MT",
			'Onyx' => "font-family :Onyx",
			'Palace Script MT' => "font-family :Palace Script MT",
			'Papyrus' => "font-family :Papyrus",
			'Perpetua' => "font-family :Perpetua",
			'Perpetua Titling MT' => "font-family :Perpetua Titling MT",
			'Playbill' => "font-family :Playbill",
			'Poor Richard' => "font-family :Poor Richard",
			'Rage Italic' => "font-family :Rage Italic",
			'Ravie' => "font-family :Ravie",
			'Rockwell' => "font-family :Rockwell",
			'Script MT Bold' => "font-family :Script MT Bold",
			'Showcard Gothic' => "font-family :Showcard Gothic",
			'Snap ITC' => "font-family :Snap ITC",
			'Stencil' => "font-family :Stencil",
			'Tw Cen MT' => "font-family :Tw Cen MT",
			'Tw Cen MT Condensed' => "font-family :Tw Cen MT Condensed",
			'Tw Cen MT Condensed Extra Bold' => "font-family :Tw Cen MT Condensed Extra Bold",
			'Verdana Ref' => "font-family :Verdana Ref",
			'Viner Hand ITC' => "font-family :Viner Hand ITC",
			'Vivaldi' => "font-family :Vivaldi",
			'Vladimir Script' => "font-family :Vladimir Script",
			'Wide Latin' => "font-family :Wide Latin",
			'Gill Sans' => "font-family :Gill Sans",
			'Gill Sans MT Condensed' => "font-family :Gill Sans MT Condensed",
			'Gill Sans Ultra Bold' => "font-family :Gill Sans Ultra Bold",
			'Goudy Old Style' => "font-family :Goudy Old Style",
			'High Tower Text' => "font-family :High Tower Text",
			'MS Outlook' => "font-family :MS Outlook",
			'Perpetua' => "font-family :Perpetua",
			'Perpetua Titling MT' => "font-family :Perpetua Titling MT",
			'Tw Cen MT' => "font-family :Tw Cen MT",
			'Tw Cen MT Condensed' => "font-family :Tw Cen MT Condensed",
			'Tw Cen MT Condensed Extra Bold' => "font-family :Tw Cen MT Condensed Extra Bold",
			'Arial Narrow' => "font-family :Arial Narrow",
			'Book Antiqua' => "font-family :Book Antiqua",
			'Century Gothic' => "font-family :Century Gothic",
			'Courier New' => "font-family :Courier New",
			'Franklin Gothic Book' => "font-family :Franklin Gothic Book",
			'Garamond' => "font-family :Garamond",
			'Lucida Sans Typewriter' => "font-family :Lucida Sans Typewriter",
			'MS Reference Sans Serif' => "font-family :MS Reference Sans Serif",
			'Palatino Linotype' => "font-family :Palatino Linotype",
			'Trebuchet MS' => "font-family :Trebuchet MS",
			'Verdana' => "font-family :Verdana",
			'Calibri' => "font-family :Calibri",
			'Cambria' => "font-family :Cambria",
			'Candara' => "font-family :Candara",
			'Consolas' => "font-family :Consolas",
			'Constantia' => "font-family :Constantia",
			'Corbel' => "font-family :Corbel",
			'Perpetua' => "font-family :Perpetua",
			'Rockwell' => "font-family :Rockwell",
			'Tahoma' => "font-family :Tahoma",
			'Tw Cen MT' => "font-family :Tw Cen MT",
			'Tw Cen MT Condensed' => "font-family :Tw Cen MT Condensed",
			'Tw Cen MT Condensed Extra Bold' => "font-family :Tw Cen MT Condensed Extra Bold",
			'Verdana' => "font-family :Verdana",
			'Vladimir Script' => "font-family :Vladimir Script"
		)
	);
	return $ww_get_google_fonts;
}
