<?php
/**
 * Country calling codes based on E.164
 *
 * @link https://en.wikipedia.org/wiki/E.164
 */

class Listo_TelephoneCountryCodes implements Listo {
	private function __construct() {}

	private static $items = array(
		'abw' => '+297',
		'afg' => '+93',
		'ago' => '+244',
		'aia' => '+1',
		'alb' => '+355',
		'and' => '+376',
		'are' => '+971',
		'arg' => '+54',
		'arm' => '+374',
		'asm' => '+1',
		'atg' => '+1',
		'aus' => '+61',
		'aut' => '+43',
		'aze' => '+994',
		'bdi' => '+257',
		'bel' => '+32',
		'ben' => '+229',
		'bes' => '+599',
		'bfa' => '+226',
		'bgd' => '+880',
		'bgr' => '+359',
		'bhr' => '+973',
		'bhs' => '+1',
		'bih' => '+387',
		'blr' => '+375',
		'blz' => '+501',
		'bmu' => '+1',
		'bol' => '+591',
		'bra' => '+55',
		'brb' => '+1',
		'brn' => '+673',
		'btn' => '+975',
		'bwa' => '+267',
		'caf' => '+236',
		'can' => '+1',
		'che' => '+41',
		'chl' => '+56',
		'chn' => '+86',
		'civ' => '+225',
		'cmr' => '+237',
		'cod' => '+243',
		'cog' => '+242',
		'cok' => '+682',
		'col' => '+57',
		'com' => '+269',
		'cpv' => '+238',
		'cri' => '+506',
		'cub' => '+53',
		'cuw' => '+599',
		'cym' => '+1',
		'cyp' => '+357',
		'cze' => '+420',
		'deu' => '+49',
		'dji' => '+253',
		'dma' => '+1',
		'dnk' => '+45',
		'dom' => '+1',
		'dza' => '+213',
		'ecu' => '+593',
		'egy' => '+20',
		'eri' => '+291',
		'esp' => '+34',
		'est' => '+372',
		'eth' => '+251',
		'fin' => '+358',
		'fji' => '+679',
		'flk' => '+500',
		'fra' => '+33',
		'fro' => '+298',
		'fsm' => '+691',
		'gab' => '+241',
		'gbr' => '+44',
		'geo' => '+995',
		'gha' => '+233',
		'gib' => '+350',
		'gin' => '+224',
		'glp' => '+590',
		'gmb' => '+220',
		'gnb' => '+245',
		'gnq' => '+240',
		'grc' => '+30',
		'grd' => '+1',
		'grl' => '+299',
		'gtm' => '+502',
		'guf' => '+594',
		'gum' => '+1',
		'guy' => '+592',
		'hkg' => '+852',
		'hnd' => '+504',
		'hrv' => '+385',
		'hti' => '+509',
		'hun' => '+36',
		'idn' => '+62',
		'ind' => '+91',
		'iot' => '+246',
		'irl' => '+353',
		'irn' => '+98',
		'irq' => '+964',
		'isl' => '+354',
		'isr' => '+972',
		'ita' => '+39',
		'jam' => '+1',
		'jor' => '+962',
		'jpn' => '+81',
		'kaz' => '+7',
		'ken' => '+254',
		'kgz' => '+996',
		'khm' => '+855',
		'kir' => '+686',
		'kna' => '+1',
		'kor' => '+82',
		'kwt' => '+965',
		'lao' => '+856',
		'lbn' => '+961',
		'lbr' => '+231',
		'lby' => '+218',
		'lca' => '+1',
		'lie' => '+423',
		'lka' => '+94',
		'lso' => '+266',
		'ltu' => '+370',
		'lux' => '+352',
		'lva' => '+371',
		'mac' => '+853',
		'mar' => '+212',
		'mco' => '+377',
		'mda' => '+373',
		'mdg' => '+261',
		'mdv' => '+960',
		'mex' => '+52',
		'mhl' => '+692',
		'mkd' => '+389',
		'mli' => '+223',
		'mlt' => '+356',
		'mmr' => '+95',
		'mne' => '+382',
		'mng' => '+976',
		'mnp' => '+1',
		'moz' => '+258',
		'mrt' => '+222',
		'msr' => '+1',
		'mtq' => '+596',
		'mus' => '+230',
		'mwi' => '+265',
		'mys' => '+60',
		'nam' => '+264',
		'ncl' => '+687',
		'ner' => '+227',
		'nfk' => '+672',
		'nga' => '+234',
		'nic' => '+505',
		'niu' => '+683',
		'nld' => '+31',
		'nor' => '+47',
		'npl' => '+977',
		'nru' => '+674',
		'nzl' => '+64',
		'omn' => '+968',
		'pak' => '+92',
		'pan' => '+507',
		'per' => '+51',
		'phl' => '+63',
		'plw' => '+680',
		'png' => '+675',
		'pol' => '+48',
		'pri' => '+1',
		'prk' => '+850',
		'prt' => '+351',
		'pry' => '+595',
		'pyf' => '+689',
		'qat' => '+974',
		'rou' => '+40',
		'rus' => '+7',
		'rwa' => '+250',
		'sau' => '+966',
		'sdn' => '+249',
		'sen' => '+221',
		'sgp' => '+65',
		'slb' => '+677',
		'sle' => '+232',
		'slv' => '+503',
		'smr' => '+378',
		'som' => '+252',
		'spm' => '+508',
		'srb' => '+381',
		'ssd' => '+211',
		'stp' => '+239',
		'sur' => '+597',
		'svk' => '+421',
		'svn' => '+386',
		'swe' => '+46',
		'swz' => '+268',
		'sxm' => '+1',
		'syc' => '+248',
		'syr' => '+963',
		'tca' => '+1',
		'tcd' => '+235',
		'tgo' => '+228',
		'tha' => '+66',
		'tjk' => '+992',
		'tkl' => '+690',
		'tkm' => '+993',
		'tls' => '+670',
		'ton' => '+676',
		'tto' => '+1',
		'tun' => '+216',
		'tur' => '+90',
		'tuv' => '+688',
		'twn' => '+886',
		'tza' => '+255',
		'uga' => '+256',
		'ukr' => '+380',
		'ury' => '+598',
		'usa' => '+1',
		'uzb' => '+998',
		'vct' => '+1',
		'ven' => '+58',
		'vgb' => '+1',
		'vir' => '+1',
		'vnm' => '+84',
		'vut' => '+678',
		'wlf' => '+681',
		'wsm' => '+685',
		'yem' => '+967',
		'zaf' => '+27',
		'zmb' => '+260',
		'zwe' => '+263',
	);

	public static function items() {
		return self::$items;
	}

	public static function groups() {
		return array();
	}

	public static function get_code( $a3 ) {
		$a3 = strtolower( $a3 );
		return self::$items[$a3] ?? '';
	}
}
