<?php
/**
 * Unicode emoji flag sequences
 *
 * @link https://en.wikipedia.org/wiki/Regional_indicator_symbol
 */

class Listo_EmojiFlags implements Listo {
	private function __construct() {}

	private static $items = array(
		'ac' => '1F1E6 1F1E8',
		'ad' => '1F1E6 1F1E9',
		'ae' => '1F1E6 1F1EA',
		'af' => '1F1E6 1F1EB',
		'ag' => '1F1E6 1F1EC',
		'ai' => '1F1E6 1F1EE',
		'al' => '1F1E6 1F1F1',
		'am' => '1F1E6 1F1F2',
		'ao' => '1F1E6 1F1F4',
		'aq' => '1F1E6 1F1F6',
		'ar' => '1F1E6 1F1F7',
		'as' => '1F1E6 1F1F8',
		'at' => '1F1E6 1F1F9',
		'au' => '1F1E6 1F1FA',
		'aw' => '1F1E6 1F1FC',
		'ax' => '1F1E6 1F1FD',
		'az' => '1F1E6 1F1FF',
		'ba' => '1F1E7 1F1E6',
		'bb' => '1F1E7 1F1E7',
		'bd' => '1F1E7 1F1E9',
		'be' => '1F1E7 1F1EA',
		'bf' => '1F1E7 1F1EB',
		'bg' => '1F1E7 1F1EC',
		'bh' => '1F1E7 1F1ED',
		'bi' => '1F1E7 1F1EE',
		'bj' => '1F1E7 1F1EF',
		'bl' => '1F1E7 1F1F1',
		'bm' => '1F1E7 1F1F2',
		'bn' => '1F1E7 1F1F3',
		'bo' => '1F1E7 1F1F4',
		'bq' => '1F1E7 1F1F6',
		'br' => '1F1E7 1F1F7',
		'bs' => '1F1E7 1F1F8',
		'bt' => '1F1E7 1F1F9',
		'bv' => '1F1E7 1F1FB',
		'bw' => '1F1E7 1F1FC',
		'by' => '1F1E7 1F1FE',
		'bz' => '1F1E7 1F1FF',
		'ca' => '1F1E8 1F1E6',
		'cc' => '1F1E8 1F1E8',
		'cd' => '1F1E8 1F1E9',
		'cf' => '1F1E8 1F1EB',
		'cg' => '1F1E8 1F1EC',
		'ch' => '1F1E8 1F1ED',
		'ci' => '1F1E8 1F1EE',
		'ck' => '1F1E8 1F1F0',
		'cl' => '1F1E8 1F1F1',
		'cm' => '1F1E8 1F1F2',
		'cn' => '1F1E8 1F1F3',
		'co' => '1F1E8 1F1F4',
		'cp' => '1F1E8 1F1F5',
		'cq' => '1F1E8 1F1F6',
		'cr' => '1F1E8 1F1F7',
		'cu' => '1F1E8 1F1FA',
		'cv' => '1F1E8 1F1FB',
		'cw' => '1F1E8 1F1FC',
		'cx' => '1F1E8 1F1FD',
		'cy' => '1F1E8 1F1FE',
		'cz' => '1F1E8 1F1FF',
		'de' => '1F1E9 1F1EA',
		'dg' => '1F1E9 1F1EC',
		'dj' => '1F1E9 1F1EF',
		'dk' => '1F1E9 1F1F0',
		'dm' => '1F1E9 1F1F2',
		'do' => '1F1E9 1F1F4',
		'dz' => '1F1E9 1F1FF',
		'ea' => '1F1EA 1F1E6',
		'ec' => '1F1EA 1F1E8',
		'ee' => '1F1EA 1F1EA',
		'eg' => '1F1EA 1F1EC',
		'eh' => '1F1EA 1F1ED',
		'er' => '1F1EA 1F1F7',
		'es' => '1F1EA 1F1F8',
		'et' => '1F1EA 1F1F9',
		'eu' => '1F1EA 1F1FA',
		'fi' => '1F1EB 1F1EE',
		'fj' => '1F1EB 1F1EF',
		'fk' => '1F1EB 1F1F0',
		'fm' => '1F1EB 1F1F2',
		'fo' => '1F1EB 1F1F4',
		'fr' => '1F1EB 1F1F7',
		'ga' => '1F1EC 1F1E6',
		'gb' => '1F1EC 1F1E7',
		'gd' => '1F1EC 1F1E9',
		'ge' => '1F1EC 1F1EA',
		'gf' => '1F1EC 1F1EB',
		'gg' => '1F1EC 1F1EC',
		'gh' => '1F1EC 1F1ED',
		'gi' => '1F1EC 1F1EE',
		'gl' => '1F1EC 1F1F1',
		'gm' => '1F1EC 1F1F2',
		'gn' => '1F1EC 1F1F3',
		'gp' => '1F1EC 1F1F5',
		'gq' => '1F1EC 1F1F6',
		'gr' => '1F1EC 1F1F7',
		'gs' => '1F1EC 1F1F8',
		'gt' => '1F1EC 1F1F9',
		'gu' => '1F1EC 1F1FA',
		'gw' => '1F1EC 1F1FC',
		'gy' => '1F1EC 1F1FE',
		'hk' => '1F1ED 1F1F0',
		'hm' => '1F1ED 1F1F2',
		'hn' => '1F1ED 1F1F3',
		'hr' => '1F1ED 1F1F7',
		'ht' => '1F1ED 1F1F9',
		'hu' => '1F1ED 1F1FA',
		'ic' => '1F1EE 1F1E8',
		'id' => '1F1EE 1F1E9',
		'ie' => '1F1EE 1F1EA',
		'il' => '1F1EE 1F1F1',
		'im' => '1F1EE 1F1F2',
		'in' => '1F1EE 1F1F3',
		'io' => '1F1EE 1F1F4',
		'iq' => '1F1EE 1F1F6',
		'ir' => '1F1EE 1F1F7',
		'is' => '1F1EE 1F1F8',
		'it' => '1F1EE 1F1F9',
		'je' => '1F1EF 1F1EA',
		'jm' => '1F1EF 1F1F2',
		'jo' => '1F1EF 1F1F4',
		'jp' => '1F1EF 1F1F5',
		'ke' => '1F1F0 1F1EA',
		'kg' => '1F1F0 1F1EC',
		'kh' => '1F1F0 1F1ED',
		'ki' => '1F1F0 1F1EE',
		'km' => '1F1F0 1F1F2',
		'kn' => '1F1F0 1F1F3',
		'kp' => '1F1F0 1F1F5',
		'kr' => '1F1F0 1F1F7',
		'kw' => '1F1F0 1F1FC',
		'ky' => '1F1F0 1F1FE',
		'kz' => '1F1F0 1F1FF',
		'la' => '1F1F1 1F1E6',
		'lb' => '1F1F1 1F1E7',
		'lc' => '1F1F1 1F1E8',
		'li' => '1F1F1 1F1EE',
		'lk' => '1F1F1 1F1F0',
		'lr' => '1F1F1 1F1F7',
		'ls' => '1F1F1 1F1F8',
		'lt' => '1F1F1 1F1F9',
		'lu' => '1F1F1 1F1FA',
		'lv' => '1F1F1 1F1FB',
		'ly' => '1F1F1 1F1FE',
		'ma' => '1F1F2 1F1E6',
		'mc' => '1F1F2 1F1E8',
		'md' => '1F1F2 1F1E9',
		'me' => '1F1F2 1F1EA',
		'mf' => '1F1F2 1F1EB',
		'mg' => '1F1F2 1F1EC',
		'mh' => '1F1F2 1F1ED',
		'mk' => '1F1F2 1F1F0',
		'ml' => '1F1F2 1F1F1',
		'mm' => '1F1F2 1F1F2',
		'mn' => '1F1F2 1F1F3',
		'mo' => '1F1F2 1F1F4',
		'mp' => '1F1F2 1F1F5',
		'mq' => '1F1F2 1F1F6',
		'mr' => '1F1F2 1F1F7',
		'ms' => '1F1F2 1F1F8',
		'mt' => '1F1F2 1F1F9',
		'mu' => '1F1F2 1F1FA',
		'mv' => '1F1F2 1F1FB',
		'mw' => '1F1F2 1F1FC',
		'mx' => '1F1F2 1F1FD',
		'my' => '1F1F2 1F1FE',
		'mz' => '1F1F2 1F1FF',
		'na' => '1F1F3 1F1E6',
		'nc' => '1F1F3 1F1E8',
		'ne' => '1F1F3 1F1EA',
		'nf' => '1F1F3 1F1EB',
		'ng' => '1F1F3 1F1EC',
		'ni' => '1F1F3 1F1EE',
		'nl' => '1F1F3 1F1F1',
		'no' => '1F1F3 1F1F4',
		'np' => '1F1F3 1F1F5',
		'nr' => '1F1F3 1F1F7',
		'nu' => '1F1F3 1F1FA',
		'nz' => '1F1F3 1F1FF',
		'om' => '1F1F4 1F1F2',
		'pa' => '1F1F5 1F1E6',
		'pe' => '1F1F5 1F1EA',
		'pf' => '1F1F5 1F1EB',
		'pg' => '1F1F5 1F1EC',
		'ph' => '1F1F5 1F1ED',
		'pk' => '1F1F5 1F1F0',
		'pl' => '1F1F5 1F1F1',
		'pm' => '1F1F5 1F1F2',
		'pn' => '1F1F5 1F1F3',
		'pr' => '1F1F5 1F1F7',
		'ps' => '1F1F5 1F1F8',
		'pt' => '1F1F5 1F1F9',
		'pw' => '1F1F5 1F1FC',
		'py' => '1F1F5 1F1FE',
		'qa' => '1F1F6 1F1E6',
		're' => '1F1F7 1F1EA',
		'ro' => '1F1F7 1F1F4',
		'rs' => '1F1F7 1F1F8',
		'ru' => '1F1F7 1F1FA',
		'rw' => '1F1F7 1F1FC',
		'sa' => '1F1F8 1F1E6',
		'sb' => '1F1F8 1F1E7',
		'sc' => '1F1F8 1F1E8',
		'sd' => '1F1F8 1F1E9',
		'se' => '1F1F8 1F1EA',
		'sg' => '1F1F8 1F1EC',
		'sh' => '1F1F8 1F1ED',
		'si' => '1F1F8 1F1EE',
		'sj' => '1F1F8 1F1EF',
		'sk' => '1F1F8 1F1F0',
		'sl' => '1F1F8 1F1F1',
		'sm' => '1F1F8 1F1F2',
		'sn' => '1F1F8 1F1F3',
		'so' => '1F1F8 1F1F4',
		'sr' => '1F1F8 1F1F7',
		'ss' => '1F1F8 1F1F8',
		'st' => '1F1F8 1F1F9',
		'sv' => '1F1F8 1F1FB',
		'sx' => '1F1F8 1F1FD',
		'sy' => '1F1F8 1F1FE',
		'sz' => '1F1F8 1F1FF',
		'ta' => '1F1F9 1F1E6',
		'tc' => '1F1F9 1F1E8',
		'td' => '1F1F9 1F1E9',
		'tf' => '1F1F9 1F1EB',
		'tg' => '1F1F9 1F1EC',
		'th' => '1F1F9 1F1ED',
		'tj' => '1F1F9 1F1EF',
		'tk' => '1F1F9 1F1F0',
		'tl' => '1F1F9 1F1F1',
		'tm' => '1F1F9 1F1F2',
		'tn' => '1F1F9 1F1F3',
		'to' => '1F1F9 1F1F4',
		'tr' => '1F1F9 1F1F7',
		'tt' => '1F1F9 1F1F9',
		'tv' => '1F1F9 1F1FB',
		'tw' => '1F1F9 1F1FC',
		'tz' => '1F1F9 1F1FF',
		'ua' => '1F1FA 1F1E6',
		'ug' => '1F1FA 1F1EC',
		'um' => '1F1FA 1F1F2',
		'un' => '1F1FA 1F1F3',
		'us' => '1F1FA 1F1F8',
		'uy' => '1F1FA 1F1FE',
		'uz' => '1F1FA 1F1FF',
		'va' => '1F1FB 1F1E6',
		'vc' => '1F1FB 1F1E8',
		've' => '1F1FB 1F1EA',
		'vg' => '1F1FB 1F1EC',
		'vi' => '1F1FB 1F1EE',
		'vn' => '1F1FB 1F1F3',
		'vu' => '1F1FB 1F1FA',
		'wf' => '1F1FC 1F1EB',
		'ws' => '1F1FC 1F1F8',
		'xk' => '1F1FD 1F1F0',
		'ye' => '1F1FE 1F1EA',
		'yt' => '1F1FE 1F1F9',
		'za' => '1F1FF 1F1E6',
		'zm' => '1F1FF 1F1F2',
		'zw' => '1F1FF 1F1FC',
	);

	public static function items() {
		return self::$items;
	}

	public static function groups() {
		return array();
	}

	public static function get_html( $a2 ) {
		$a2 = strtolower( $a2 );
		$sequence = self::$items[$a2] ?? '';

		if ( ! $sequence ) {
			return $sequence;
		}

		$sequence = explode( ' ', $sequence );

		return sprintf( '&#x%s;&#x%s;', ...$sequence );
	}
}
